package com.bcxin.api.interfaces.tenants.requests.organizations;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel("企业信息修改")
@Data
public class CompanyUpdateRequest extends RequestAbstract {

    @ApiModelProperty(value = "id", hidden = true)
    private String id;

    /**
     * 图标
     */
    @ApiModelProperty(value = "图标")
    private String logoPath;

    /**
     * 系统名称
     */
    @ApiModelProperty(value = "系统名称")
    private String sysName;
    /**
     * 描述
     */
    @ApiModelProperty(value = "描述")
    private String description;
    /**
     * 经度
     */
    @ApiModelProperty(value = "经度")
    private Double longitude;
    /**
     * 纬度
     */
    @ApiModelProperty(value = "纬度")
    private Double latitude;


    @ApiModelProperty(value = "机构类型")
    private String institutionalCode;

    @ApiModelProperty(value = "保安服务公司类型（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.IndustryDetailType")
    private IndustryDetailType industryDetailType;


    //基本信息
    @ApiModelProperty(value = "公司名称")
    private String name;

    @ApiModelProperty(value = "总/分/子公司", notes = "com.bcxin.Infrastructures.enums.ParentSubsidiary")
    private ParentSubsidiary type;

    @ApiModelProperty(value = "联系电话")
    private String telephone;

    @ApiModelProperty(value = "经济类型", notes = "com.bcxin.Infrastructures.enums.EconomicType")
    private EconomicType economicType;

    @ApiModelProperty(value = "公司类型", notes = "com.bcxin.Infrastructures.enums.CompanyNature")
    private CompanyNature nature;

    @ApiModelProperty(value = "注册地区")
    private LocationRequest placeOfRegister;

    @ApiModelProperty(value = "经营地区")
    private LocationRequest placeOfBusiness;


    //总公司信息，保安行业必填
    @ApiModelProperty(value = "总公司名称（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentName;

    @ApiModelProperty(value = "总公司证件类型（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType")
    private CompanyCertificateType parentCertificateType;

    @ApiModelProperty(value = "总公司证件号码（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentCertificateNumber;

    @ApiModelProperty(value = "总公司法人姓名（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentLegalPersonName;

    @ApiModelProperty(value = "总公司联系电话（机构类型 = 保安服务公司 && (总/分/子公司 = 分 || 子) 必填）")
    private String parentLegalPersonTelephone;

    //法人或负责人信息
    @ApiModelProperty(value = "法人姓名")
    private String legalPersonName;

    @ApiModelProperty(value = "法人手机号码")
    private String legalPersonTelephone;

    @ApiModelProperty(value = "法人证件类型", notes = "com.bcxin.Infrastructures.enums.CredentialType")
    private CredentialType legalPersonCredentialType;

    @ApiModelProperty(value = "法人证件号码")
    private String legalPersonCredentialNumber;

    @ApiModelProperty(value = "法人国籍")
    private String legalPersonNationality;

    //保安负责人信息
    @ApiModelProperty(value = "保安负责人姓名")
    private String securityPersonName;

    @ApiModelProperty(value = "保安负责人手机号码")
    private String securityPersonTelephone;

    @ApiModelProperty(value = "保安负责人证件类型", notes = "com.bcxin.Infrastructures.enums.CredentialType")
    private CredentialType securityPersonCredentialType;

    @ApiModelProperty(value = "保安负责人证件号码")
    private String securityPersonCredentialNumber;

    //注册信息
    @ApiModelProperty(value = "注册资本（万元）")
    private String registeredCapital;

    @ApiModelProperty(value = "固定资产（万元，机构类型 = 保安服务公司 必填）")
    private String fixedCapital;

    @ApiModelProperty(value = "年营业额（万元，机构类型 = 保安服务公司 必填）")
    private String annualSalesVolume;

    @ApiModelProperty(value = "年利税（万元，机构类型 = 保安服务公司 必填）")
    private String annualProfitTax;

    @ApiModelProperty(value = "证件类型", notes = "com.bcxin.Infrastructures.enums.CompanyCertificateType")
    private CompanyCertificateType certificateType;

    @ApiModelProperty(value = "统一社会信用代码")
    private String unifySocialCreditCode;

    @ApiModelProperty(value = "营业执照扫描件")
    private String unifySocialCreditCodeFile;


    //资质信息
    @ApiModelProperty(value = "保安服务许可/保安培训备案证号（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String servicePermitNumber;

    @ApiModelProperty(value = "发证机关名称（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String nameOfIssuingAuthority;

    @ApiModelProperty(value = "保安服务许可证首次发证日期或者培训单位的发证日期（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private Date firstIssueServicePermit;

    @ApiModelProperty(value = "保安服务许可证扫描件或者保安培训许可（备案）证扫描件（机构类型 = 保安服务公司 || 保安培训单位 必填）")
    private String servicePermitAttachment;


    @ApiModelProperty(value = "批准文号（机构类型 = 保安服务公司 必填）")
    private String securityApprovalNumber;

    @ApiModelProperty(value = "服务范围（机构类型 = 保安服务公司 必填）")
    private List<String> serviceScopeList;

    @ApiModelProperty(value = "人力防范评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecurityPreparednessRating")
    private SecurityPreparednessRating securityPreparednessRating;

    @ApiModelProperty(value = "武装守护押运评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecurityArmedRating")
    private SecurityArmedRating securityArmedRating;

    @ApiModelProperty(value = "安全技术防范评定等级（机构类型 = 保安服务公司 必填）", notes = "com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating")
    private SecuritySafetyDefenseRating securitySafetyDefenseRating;

    @ApiModelProperty(value = "是否有风险评估资质（机构类型 = 保安服务公司 必填）")
    private Boolean isRiskAssessment;


    @ApiModelProperty(value = "培训单位的培训内容（机构类型 = 保安培训单位 必填）")
    private String trainContent;


    //自行招用保安员单位
    @ApiModelProperty(value = "拟自招保安员数（机构类型 = 自行招用保安员单位 必填）")
    private Integer numberOfSecurityGuards;

    @ApiModelProperty(value = "是否治安保卫重点单位（机构类型 = 自行招用保安员单位 必填）")
    private Boolean isPublicSecuritySecurity;

    @ApiModelProperty(value = "是否物业企业（机构类型 = 自行招用保安员单位 必填）")
    private Boolean isPropertyEnterprise;

    @ApiModelProperty(value = "自招保安单位性质（机构类型 = 自行招用保安员单位 必填）")
    private String natureOfSelfRecruitedUnits;


    //监管归属
    @ApiModelProperty(value = "监管地区", hidden = true)
    private String placeOfSupervise;

    @ApiModelProperty(value = "监管机构", hidden = true)
    private String superviseDepartId;

    @ApiModelProperty(value = "监管机构名称", hidden = true)
    private String superviseDepartName;


    @ApiModelProperty(value = "传真")
    private String fax;


    @ApiModelProperty(value = "系统管理员")
    private ContactRequest administrator;

    @ApiModelProperty(value = "地理位置")
    private String locationAddress;


    @ApiModel("企业人员信息")
    @Data
    public static class ContactRequest implements Serializable {
        @ApiModelProperty(value = "姓名", required = true)
        private String name;

        @ApiModelProperty(value = "手机号码", required = true)
        private String telephone;
    }
}
