package com.bcxin.api.interfaces.tenants.requests.externalMembers;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.api.interfaces.RequestAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.util.Collection;

@ApiModel("批量修改状态")
@Getter
public class UpdateExternalMemberStatusRequest extends RequestAbstract {
    @ApiModelProperty("成员Id")
    private final Collection<String> ids;

    @ApiModelProperty("Init=未审核;Passed=审核通过;NoPassed=未通过;Deleted=已被删除;")
    private final ApprovedStatus status;

    private final String note;


    public UpdateExternalMemberStatusRequest(Collection<String> ids, ApprovedStatus status, String note) {
        this.ids = ids;
        this.status = status;
        this.note = note;
    }
}
