package com.bcxin.api.interfaces.tenants.criterias;

import com.bcxin.Infrastructures.enums.*;
import com.bcxin.api.interfaces.CriteriaAbstract;
import lombok.Data;

import java.util.Collection;
import java.util.Date;
import java.util.List;

@Data
public class EmployeeCriteria extends CriteriaAbstract {
    private String keyword;
    private Date hiredDate;
    private String organName;
    private String position;
    //是否持资格证：是/否，判断用户的证书信息是否有“保安资格证”类型的证书信息； 1持证 0未持证
    private String cerStatus;
    //是否签订合同：是/否，判断用户的合同信息是否有有效的记录 1签订 0未签订
    private String contractStatus;
    private String gradeCerStatus;
    //证件核验状态：未提交/已提交/已核验
    private Collection<UserCheckedStatus> checkedStatuses;
    private Collection<String> departIds;
    private Collection<CredentialType> credentialTypes;
    private Collection<OccupationType> occupationTypes;
    private Collection<RealNameAuthenticatedStatus> authenticatedStatuses;
    private Collection<BackgroundScreeningStatus> backgroundScreeningStatus;
    private boolean ignorePermission;
    /**
     * 导出列
     */
    private List<String> columns;

    private Collection<Integer> level;
    private Sex sex;
    private Integer beginAge;
    private Integer endAge;

    private Date startDate;
    private Date endDate;
    /**
     * 是否投保
     */
    private TrueFalseStatus insure;
}
