package com.bcxin.api.interfaces.tenants;

import com.bcxin.api.interfaces.identities.requests.XlcpLoginRequest;
import com.bcxin.api.interfaces.tenants.responses.LoginUserResponse;
import org.springframework.stereotype.Component;

import java.io.UnsupportedEncodingException;

@Component
public interface SingleLoginRpcProvider {

    void checkAuth() throws Exception;

    void saveLoginUser(String userName) throws Exception;

    String encryptByAES(String content);

    String saveLoginUserForNaturalPerson(String code);

    String saveLoginUserForNaturalPerson(String certName,String certNo,String mobile);

    /**
     * <b> 法人以自然人方式创建账号信息 </b>
     * @author ZXF
     * @create 2022/11/15 0015 14:21
     * @version
     * @注意事项 </b>
     */
    String saveLoginUserForLegalPerson(String certName,String certNo,String mobile);

    String getRedirectUrlForNaturalPerson() throws UnsupportedEncodingException;

    LoginUserResponse findByIdNum(String userName);
    boolean isUserByUserName(String userName);

    XlcpLoginRequest getByEmployeeId(String organId, String employeeId) throws Exception;
}
