package com.bcxin.api.interfaces.rbacs.custom.response;

import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.utils.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@ApiModel("用户返回对象")
@Data
public class RbacUserResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "职员id")
    private String employeeId;

    @ApiModelProperty(value = "姓名")
    private String userName;

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "所在部门id")
    private String departId;

    @ApiModelProperty(value = "所在部门")
    private String departName;

    @ApiModelProperty(value = "职业类型")
    private String occupationType;

    @ApiModelProperty(value = "添加角色时间")
    private String addRoleTime;

    public RbacUserResponse() {
    }

    public RbacUserResponse(String employeeId, String userName, String mobile, String departId, String departName,
                            Integer occupationType, Date addRoleTime) {
        this.employeeId = employeeId;
        this.userName = userName;
        this.mobile = mobile;
        this.departId = departId;
        this.departName = departName;
        if (occupationType == 0) {
            this.occupationType = OccupationType.Normal.getTypeName();
        } else if (occupationType == 1) {
            this.occupationType = OccupationType.SecurityGuard.getTypeName();
        }
        this.addRoleTime = DateUtil.format2ShortDate(addRoleTime, "yyyy-MM-dd HH:mm:ss");
    }
}
