package com.bcxin.api.interfaces.commons;

import com.bcxin.api.interfaces.commons.responses.SuperviseDepartmentResponse;
import org.springframework.stereotype.Component;

/**
 * description: 监管机构
 * author: linchunpeng
 * date:  2023-05-10 9:46
 */
@Component
public interface SuperviseDepartmentRpcProvider {

    /**
     * description: 根据区域id获取监管机构树形结构
     * author: linchunpeng
     * date:  2023-05-10 9:37
     */
    SuperviseDepartmentResponse findByRegionId(String regionId, String industryCode);

    /**
     * description: 清除redis缓存
     * author: linchunpeng
     * date:  2023-05-10 18:19
     */
    void clearRedis(String regionId);
}
