package com.bcxin.api.interfaces.commons;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.List;
import java.util.Map;

@Component
public interface ConfigDictRpcProvider {

    JSONObject findAll();


    /**
     * description: 获取注册页面数据字典列表
     * author: linchunpeng
     * date:  2023-05-08 14:01
     */
    Map<String, List<Map<String, String>>> findRegisterDict();

    /**
     * description: 删除注册页面数据字典缓存
     * author: linchunpeng
     * date:  2023-05-08 14:34
     */
    void clearRegisterDictRedis();

    List<Map<String,String>> getIndustryList();

    List<Map<String,String>> getInstitutionalListByIndustryId(String id);

    List<Map<String,String>> getInstitutionalListByIds(Collection<String> ids);

    /**
     * description: 根据行业类型，获取机构类型列表
     * author: linchunpeng
     * date:  2023-05-08 13:10
     */
    List<Map<String, String>> getOrgTypeList(String industryTypeValue);
}
