/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.entities.OperatorValueType;
import com.bcxin.Infrastructures.enums.BackgroundScreeningStatus;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.Sex;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.api.interfaces.ResponseAbstract;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

public class EmployeeGetResponse
extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String telephone;
    private final String departId;
    private final String departName;
    private final Boolean departLeader;
    private final String organName;
    private String credentialType;
    private final String credentialNumber;
    private String checkedStatus;
    private String occupationType;
    private String authenticatedStatus;
    private final Date hiredDate;
    private final String cerStatus;
    private final String contractStatus;
    private String gradeCerStatus;
    private final String position;
    private final String authenticatedResult;
    private String sex;
    private final Date birthdate;
    private Integer age;
    private final String nation;
    private final String education;
    private final String politicsStatus;
    private final String householdType;
    private final String militaryStatus;
    private final String nativePlace;
    private final String maritalStatus;
    private final String stature;
    private final String emergencyContact;
    private final String emergencyPhone;
    private final String licenseLevel;
    private String insure;
    private final String cerNo;
    private final long workDays;
    private final String superiorName;
    private Date contractValidDateTo;
    @Temporal(value=TemporalType.DATE)
    private Date positiveDate;
    private Date validDateFrom;
    private Date validDateTo;
    private String address;
    private Date createdTime;
    private Date lastCheckedStatusTime;
    private String domainAdmin;
    private String departAdmin;
    private String manageDeparts;
    private OperatorValueType operator;
    private String operatorName;
    private String operatorTime;
    private String personStatus;
    private String probation;
    private String planPositiveDate;
    private String placeOfNow;
    private String gradeLevel;
    private String gradeCerNo;
    private String backgroundScreeningStatus;

    public EmployeeGetResponse(String organName, String id, String name, String telephone, String departId, String departName, Boolean departLeader, CredentialType credentialType, String credentialNumber, UserCheckedStatus checkedStatus, OccupationType occupationType, RealNameAuthenticatedStatus authenticatedStatus, Date hiredDate, boolean cerStatus, boolean contractStatus, boolean gradeCerStatus, String gradeLevel, String gradeCerNo, String position, String authenticatedResult, Sex sex, Date birthdate, String nation, String education, String politicsStatus, String householdType, String militaryStatus, String nativePlace, String maritalStatus, String stature, String emergencyContact, String emergencyPhone, String licenseLevel, BackgroundScreeningStatus backgroundScreeningStatus, TrueFalseStatus insure, String cerNo, String superiorName, Date contractValidDateTo, Date positiveDate, Date validDateFrom, Date validDateTo, String address, Date createdTime, TrueFalseStatus domainAdmin, TrueFalseStatus departAdmin, String manageDeparts, String personStatus, String probation, String planPositiveDate, String placeOfNow, OperatorValueType operator, Date lastCheckedStatusTime) {
        this.organName = organName;
        this.id = id;
        this.name = name;
        this.telephone = telephone;
        this.departId = departId;
        this.departName = departName;
        this.departLeader = departLeader;
        this.operator = operator;
        if (operator != null) {
            this.operatorName = operator.getName();
            this.operatorTime = operator.getOperatorTime();
        }
        if (credentialType != null) {
            this.credentialType = credentialType.getTypeName();
        }
        this.credentialNumber = credentialNumber;
        if (checkedStatus != null) {
            this.checkedStatus = checkedStatus.getTypeName();
        }
        if (occupationType != null) {
            this.occupationType = occupationType.getTypeName();
        }
        if (authenticatedStatus != null) {
            this.authenticatedStatus = authenticatedStatus.getTypeName();
        }
        this.hiredDate = hiredDate;
        this.cerStatus = cerStatus ? TrueFalseStatus.True.getTypeName() : TrueFalseStatus.False.getTypeName();
        this.gradeCerStatus = gradeCerStatus ? TrueFalseStatus.True.getTypeName() : TrueFalseStatus.False.getTypeName();
        this.contractStatus = contractStatus ? TrueFalseStatus.True.getTypeName() : TrueFalseStatus.False.getTypeName();
        this.position = position;
        this.authenticatedResult = authenticatedResult;
        if (sex != null) {
            this.sex = sex.getTypeName();
        }
        this.birthdate = birthdate;
        this.nation = nation;
        this.education = education;
        this.politicsStatus = politicsStatus;
        this.householdType = householdType;
        this.militaryStatus = militaryStatus;
        this.nativePlace = nativePlace;
        this.maritalStatus = maritalStatus;
        this.stature = stature;
        this.emergencyContact = emergencyContact;
        this.emergencyPhone = emergencyPhone;
        this.licenseLevel = licenseLevel;
        if (backgroundScreeningStatus == BackgroundScreeningStatus.Init) {
            this.backgroundScreeningStatus = BackgroundScreeningStatus.Init.getTypeName();
        } else if (backgroundScreeningStatus == BackgroundScreeningStatus.Good) {
            this.backgroundScreeningStatus = BackgroundScreeningStatus.Good.getTypeName();
        } else if (backgroundScreeningStatus == BackgroundScreeningStatus.Illegal) {
            this.backgroundScreeningStatus = BackgroundScreeningStatus.Illegal.getTypeName();
        }
        this.insure = insure != null ? insure.getTypeName() : TrueFalseStatus.False.getTypeName();
        this.cerNo = cerNo;
        this.gradeLevel = gradeLevel;
        this.gradeCerNo = gradeCerNo;
        this.workDays = hiredDate != null ? DateUtil.between((Date)hiredDate, (Date)Timestamp.from(Instant.now()), (DateUnit)DateUnit.DAY) : 0L;
        this.superiorName = superiorName;
        this.contractValidDateTo = contractValidDateTo;
        this.positiveDate = positiveDate;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
        this.address = address;
        this.createdTime = createdTime;
        if (domainAdmin != null) {
            this.domainAdmin = domainAdmin.getTypeName();
        }
        if (departAdmin != null) {
            this.departAdmin = departAdmin.getTypeName();
        }
        this.manageDeparts = manageDeparts;
        if (birthdate != null) {
            this.age = DateUtil.ageOfNow((Date)birthdate);
        }
        this.personStatus = personStatus;
        this.probation = probation;
        this.planPositiveDate = planPositiveDate;
        this.placeOfNow = placeOfNow;
        this.lastCheckedStatusTime = lastCheckedStatusTime;
    }

    public String getHiredDateText() {
        return com.bcxin.Infrastructures.utils.DateUtil.format2ShortDate((Date)this.getHiredDate());
    }

    public static EmployeeGetResponse create(String organName, String id, String name, String telephone, String departId, String departName, Boolean departLeader, CredentialType credentialType, String credentialNumber, UserCheckedStatus checkedStatus, OccupationType occupationType, RealNameAuthenticatedStatus authenticatedStatus, Date hiredDate, boolean cerStatus, boolean contractStatus, boolean gradeCerStatus, String gradeLevel, String gradeCerNo, String position, String authenticatedResult, Sex sex, Date birthdate, String nation, String education, String politicsStatus, String householdType, String militaryStatus, String nativePlace, String maritalStatus, String stature, String emergencyContact, String emergencyPhone, String licenseLevel, BackgroundScreeningStatus backgroundScreeningStatus, TrueFalseStatus insure, String cerNo, String superiorName, Date contractValidDateTo, Date positiveDate, Date validDateFrom, Date validDateTo, String address, Date createdTime, TrueFalseStatus domainAdmin, TrueFalseStatus departAdmin, String manageDeparts, String personStatus, String probation, String planPositiveDate, String placeOfNow, OperatorValueType operator, Date lastCheckedStatusTime) {
        return new EmployeeGetResponse(organName, id, name, telephone, departId, departName, departLeader, credentialType, credentialNumber, checkedStatus, occupationType, authenticatedStatus, hiredDate, cerStatus, contractStatus, gradeCerStatus, gradeLevel, gradeCerNo, position, authenticatedResult, sex, birthdate, nation, education, politicsStatus, householdType, militaryStatus, nativePlace, maritalStatus, stature, emergencyContact, emergencyPhone, licenseLevel, backgroundScreeningStatus, insure, cerNo, superiorName, contractValidDateTo, positiveDate, validDateFrom, validDateTo, address, createdTime, domainAdmin, departAdmin, manageDeparts, personStatus, probation, planPositiveDate, placeOfNow, operator, lastCheckedStatusTime);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getDepartId() {
        return this.departId;
    }

    public String getDepartName() {
        return this.departName;
    }

    public Boolean getDepartLeader() {
        return this.departLeader;
    }

    public String getOrganName() {
        return this.organName;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getCredentialNumber() {
        return this.credentialNumber;
    }

    public String getCheckedStatus() {
        return this.checkedStatus;
    }

    public String getOccupationType() {
        return this.occupationType;
    }

    public String getAuthenticatedStatus() {
        return this.authenticatedStatus;
    }

    public Date getHiredDate() {
        return this.hiredDate;
    }

    public String getCerStatus() {
        return this.cerStatus;
    }

    public String getContractStatus() {
        return this.contractStatus;
    }

    public String getGradeCerStatus() {
        return this.gradeCerStatus;
    }

    public String getPosition() {
        return this.position;
    }

    public String getAuthenticatedResult() {
        return this.authenticatedResult;
    }

    public String getSex() {
        return this.sex;
    }

    public Date getBirthdate() {
        return this.birthdate;
    }

    public Integer getAge() {
        return this.age;
    }

    public String getNation() {
        return this.nation;
    }

    public String getEducation() {
        return this.education;
    }

    public String getPoliticsStatus() {
        return this.politicsStatus;
    }

    public String getHouseholdType() {
        return this.householdType;
    }

    public String getMilitaryStatus() {
        return this.militaryStatus;
    }

    public String getNativePlace() {
        return this.nativePlace;
    }

    public String getMaritalStatus() {
        return this.maritalStatus;
    }

    public String getStature() {
        return this.stature;
    }

    public String getEmergencyContact() {
        return this.emergencyContact;
    }

    public String getEmergencyPhone() {
        return this.emergencyPhone;
    }

    public String getLicenseLevel() {
        return this.licenseLevel;
    }

    public String getInsure() {
        return this.insure;
    }

    public String getCerNo() {
        return this.cerNo;
    }

    public long getWorkDays() {
        return this.workDays;
    }

    public String getSuperiorName() {
        return this.superiorName;
    }

    public Date getContractValidDateTo() {
        return this.contractValidDateTo;
    }

    public Date getPositiveDate() {
        return this.positiveDate;
    }

    public Date getValidDateFrom() {
        return this.validDateFrom;
    }

    public Date getValidDateTo() {
        return this.validDateTo;
    }

    public String getAddress() {
        return this.address;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public Date getLastCheckedStatusTime() {
        return this.lastCheckedStatusTime;
    }

    public String getDomainAdmin() {
        return this.domainAdmin;
    }

    public String getDepartAdmin() {
        return this.departAdmin;
    }

    public String getManageDeparts() {
        return this.manageDeparts;
    }

    public OperatorValueType getOperator() {
        return this.operator;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public String getOperatorTime() {
        return this.operatorTime;
    }

    public String getPersonStatus() {
        return this.personStatus;
    }

    public String getProbation() {
        return this.probation;
    }

    public String getPlanPositiveDate() {
        return this.planPositiveDate;
    }

    public String getPlaceOfNow() {
        return this.placeOfNow;
    }

    public String getGradeLevel() {
        return this.gradeLevel;
    }

    public String getGradeCerNo() {
        return this.gradeCerNo;
    }

    public String getBackgroundScreeningStatus() {
        return this.backgroundScreeningStatus;
    }
}

