CREATE TABLE `rbac_custom_role` (
     `id` bigint(20) NOT NULL COMMENT '主键id',
     `organization_id` varchar(50) NOT NULL COMMENT '企业id',
     `role_name` varchar(30) NOT NULL COMMENT '角色名称',
     `role_type` tinyint(4) NOT NULL COMMENT '角色类型，1：系统默认，2：用户自定义，备注：系统默认不可删除',
     `remark` varchar(200) DEFAULT NULL COMMENT '备注说明',
     `status` tinyint(4) NOT NULL COMMENT '角色状态，1：启用，0：禁用，备注：系统默认不可改状态\n',
     `seq` int(11) DEFAULT NULL COMMENT '排序',
     `create_time` datetime DEFAULT NULL COMMENT '创建时间',
     `create_user_id` varchar(50) DEFAULT NULL COMMENT '创建人',
     `update_time` datetime DEFAULT NULL COMMENT '更新时间',
     `update_user_id` varchar(50) DEFAULT NULL COMMENT '更新人',
     PRIMARY KEY (`id`),
     KEY `index_r_c_r_organization_id` (`organization_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色表';


CREATE TABLE `rbac_custom_role_user` (
       `id` bigint(20) NOT NULL COMMENT '主键id',
       `organization_id` varchar(50) NOT NULL COMMENT '企业id',
       `rbac_role_id` bigint(20) NOT NULL COMMENT '角色id',
       `tenant_employee_id` varchar(50) NOT NULL COMMENT '职员id',
       `create_time` datetime DEFAULT NULL COMMENT '创建时间',
       `create_user_id` varchar(50) DEFAULT NULL COMMENT '创建人',
       `update_time` datetime DEFAULT NULL COMMENT '更新时间',
       `update_user_id` varchar(50) DEFAULT NULL COMMENT '更新人',
       PRIMARY KEY (`id`),
       KEY `index_r_c_r_u_organization_id` (`organization_id`) USING BTREE,
       KEY `index_r_c_r_u_rbac_role_id` (`rbac_role_id`) USING BTREE,
       KEY `index_r_c_r_u_tenant_employee_id` (`tenant_employee_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色用户关联表';


CREATE TABLE `rbac_permit_app` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
    `app_code` varchar(50) NOT NULL COMMENT '应用代码/应用id',
    `app_name` varchar(50) NOT NULL COMMENT '应用名称',
    `app_logo` varchar(500) NOT NULL COMMENT '应用图标',
    `app_type` tinyint(4) NOT NULL COMMENT '应用类型，1：web应用，2：app应用，3：都有',
    `category` varchar(30) DEFAULT NULL COMMENT '应用分类',
    `category_seq` int(11) DEFAULT NULL COMMENT '分类排序',
    `seq` int(11) DEFAULT NULL COMMENT '排序',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8 COMMENT='权限应用表';


CREATE TABLE `rbac_permit_app_role` (
      `id` bigint(20) NOT NULL COMMENT '主键id',
      `organization_id` varchar(50) NOT NULL COMMENT '企业id',
      `permit_app_id` bigint(20) NOT NULL COMMENT '权限应用id',
      `rbac_role_id` bigint(20) NOT NULL COMMENT '角色id',
      `app_code` varchar(50) NOT NULL COMMENT '应用代码',
      `permit_type` tinyint(4) NOT NULL COMMENT '应用权限类型，1：web权限，2：app权限，3：都有',
      `create_time` datetime DEFAULT NULL COMMENT '创建时间',
      `create_user_id` varchar(50) DEFAULT NULL COMMENT '创建人',
      `update_time` datetime DEFAULT NULL COMMENT '更新时间',
      `update_user_id` varchar(50) DEFAULT NULL COMMENT '更新人',
      PRIMARY KEY (`id`),
      KEY `index_r_p_a_r_organization_id` (`organization_id`) USING BTREE,
      KEY `index_r_p_a_r_permit_app_id` (`permit_app_id`) USING BTREE,
      KEY `index_r_p_a_r_tenant_rbac_role_id` (`rbac_role_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='权限应用角色关联表';


CREATE TABLE `rbac_permit_app_user` (
      `id` bigint(20) NOT NULL COMMENT '主键id',
      `organization_id` varchar(50) NOT NULL COMMENT '企业id',
      `permit_app_id` bigint(20) NOT NULL COMMENT '权限应用id',
      `tenant_employee_id` varchar(50) NOT NULL COMMENT '职员id',
      `app_code` varchar(50) NOT NULL COMMENT '应用代码',
      `permit_type` tinyint(4) NOT NULL COMMENT '应用权限类型，1：web权限，2：app权限，3：都有',
      `create_time` datetime DEFAULT NULL COMMENT '创建时间',
      `create_user_id` varchar(50) DEFAULT NULL COMMENT '创建人',
      `update_time` datetime DEFAULT NULL COMMENT '更新时间',
      `update_user_id` varchar(50) DEFAULT NULL COMMENT '更新人',
      PRIMARY KEY (`id`),
      KEY `index_r_p_a_u_organization_id` (`organization_id`) USING BTREE,
      KEY `index_r_p_a_u_permit_app_id` (`permit_app_id`) USING BTREE,
      KEY `index_r_p_a_u_tenant_tenant_employee_id` (`tenant_employee_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='权限应用用户关联表';


CREATE TABLE `rbac_permit_option` (
    `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键id',
    `permit_app_id` bigint(20) NOT NULL COMMENT '权限应用id',
    `app_code` varchar(50) NOT NULL COMMENT '应用代码/应用id',
    `category` varchar(30) DEFAULT NULL COMMENT '操作项分类',
    `option_type` tinyint(4) NOT NULL COMMENT '操作项类型，1：web，2：app',
    `option_code` varchar(100) NOT NULL COMMENT '操作项代码/菜单id',
    `option_name` varchar(50) NOT NULL COMMENT '操作项名称',
    `seq` int(11) DEFAULT NULL COMMENT '排序',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=382 DEFAULT CHARSET=utf8 COMMENT='权限操作项表';


CREATE TABLE `rbac_permit_option_role` (
    `id` bigint(20) NOT NULL COMMENT '主键id',
    `organization_id` varchar(50) NOT NULL COMMENT '企业id',
    `permit_app_id` bigint(20) NOT NULL COMMENT '权限应用id',
    `permit_option_id` bigint(20) NOT NULL COMMENT '权限操作项id',
    `rbac_role_id` bigint(20) NOT NULL COMMENT '角色id',
    `app_code` varchar(50) NOT NULL COMMENT '应用代码',
    `option_type` tinyint(4) NOT NULL COMMENT '操作项类型，1：web，2：app',
    `option_code` varchar(100) NOT NULL COMMENT '操作项代码',
    `create_time` datetime DEFAULT NULL COMMENT '创建时间',
    `create_user_id` varchar(50) DEFAULT NULL COMMENT '创建人',
    `update_time` datetime DEFAULT NULL COMMENT '更新时间',
    `update_user_id` varchar(50) DEFAULT NULL COMMENT '更新人',
    PRIMARY KEY (`id`),
    KEY `index_r_p_o_r_organization_id` (`organization_id`) USING BTREE,
    KEY `index_r_p_o_r_permit_app_id` (`permit_app_id`) USING BTREE,
    KEY `index_r_p_o_r_permit_option_id` (`permit_option_id`) USING BTREE,
    KEY `index_r_p_o_r_tenant_rbac_role_id` (`rbac_role_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='权限操作项角色关联表';


CREATE TABLE `rbac_permit_option_user` (
    `id` bigint(20) NOT NULL COMMENT '主键id',
    `organization_id` varchar(50) NOT NULL COMMENT '企业id',
    `permit_app_id` bigint(20) NOT NULL COMMENT '权限应用id',
    `permit_option_id` bigint(20) NOT NULL COMMENT '权限操作项id',
    `tenant_employee_id` varchar(50) NOT NULL COMMENT '职员id',
    `app_code` varchar(50) NOT NULL COMMENT '应用代码',
    `option_type` tinyint(4) NOT NULL COMMENT '操作项类型，1：web，2：app',
    `option_code` varchar(100) NOT NULL COMMENT '操作项代码',
    `create_time` datetime DEFAULT NULL COMMENT '创建时间',
    `create_user_id` varchar(50) DEFAULT NULL COMMENT '创建人',
    `update_time` datetime DEFAULT NULL COMMENT '更新时间',
    `update_user_id` varchar(50) DEFAULT NULL COMMENT '更新人',
    PRIMARY KEY (`id`),
    KEY `index_r_p_o_u_organization_id` (`organization_id`) USING BTREE,
    KEY `index_r_p_o_u_permit_app_id` (`permit_app_id`) USING BTREE,
    KEY `index_r_p_o_u_permit_option_id` (`permit_option_id`) USING BTREE,
    KEY `index_r_p_o_u_tenant_tenant_employee_id` (`tenant_employee_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='权限操作项用户关联表';