ALTER TABLE obpm2_security.`tenant_organizations`
ADD COLUMN `status`  tinyint(4) NOT NULL DEFAULT 1 COMMENT '公司状态，1-正常，2-注销，3-撤销，4-吊销' AFTER `lon_lat_json`,
ADD COLUMN `fax`  varchar(20) NULL DEFAULT NULL COMMENT '传真' AFTER `status`,
ADD COLUMN `telephone`  varchar(20) NULL DEFAULT NULL COMMENT '联系电话' AFTER `fax`,
ADD COLUMN `type`  tinyint(4) NOT NULL DEFAULT 1 COMMENT '总分子公司，1-总公司，2分公司，3-子公司' AFTER `telephone`,
ADD COLUMN `industry_detail_type`  tinyint(4) NULL DEFAULT 0 COMMENT '保安服务公司类型，0-无，1-普通保安服务公司，2-武装守护押运保安服务公司，3-外资保安服务公司' AFTER `type`,
ADD COLUMN `supervise_region_code`  varchar(200) NOT NULL DEFAULT '#' COMMENT '监管地区' AFTER `industry_detail_type`,
ADD COLUMN `supervise_depart_id`  varchar(200) NOT NULL DEFAULT '#' COMMENT '监管机构' AFTER `supervise_region_code`,
ADD COLUMN `supervise_depart_name`  varchar(200) NOT NULL DEFAULT '#' COMMENT '监管机构名称(冗余)' AFTER `supervise_depart_id`;


ALTER TABLE obpm2_security.`tenant_companies`
ADD COLUMN `parent_name`  varchar(255) NULL DEFAULT NULL COMMENT '总公司名称' AFTER `unify_social_credit_code_file`,
ADD COLUMN `parent_certificate_type`  tinyint(4) NULL DEFAULT NULL COMMENT '总公司证件类型' AFTER `parent_name`,
ADD COLUMN `parent_certificate_number`  varchar(100) NULL DEFAULT NULL COMMENT '总公司证件号码' AFTER `parent_certificate_type`,
ADD COLUMN `parent_legal_person_name`  varchar(255) NULL DEFAULT NULL COMMENT '总公司法人姓名' AFTER `parent_certificate_number`,
ADD COLUMN `parent_legal_person_telephone`  varchar(20) NULL DEFAULT NULL COMMENT '总公司联系电话' AFTER `parent_legal_person_name`,
ADD COLUMN `economic_type`  tinyint(4) NOT NULL DEFAULT 1 COMMENT '经济类型，1-国有经济，2-集体经济，3-私营经济，4-个体经济，5-联营经济，6-股份制，7-外商投资，8-港澳台投资与其他经济，9-其他经济' AFTER `parent_legal_person_telephone`,
ADD COLUMN `nature`  tinyint(4) NULL DEFAULT NULL COMMENT '公司类型，1-国有资本，2-民营，3-外资（包括港澳台投资），4-其它' AFTER `economic_type`,
ADD COLUMN `service_scope`  int(11) NULL DEFAULT NULL COMMENT '服务范围' AFTER `nature`,
ADD COLUMN `service_scope_description`  varchar(200) NULL DEFAULT NULL COMMENT '服务范围描述' AFTER `service_scope`,
ADD COLUMN `registered_capital`  varchar(50) NOT NULL DEFAULT '' COMMENT '注册资本' AFTER `service_scope_description`,
ADD COLUMN `fixed_capital`  varchar(50) NULL DEFAULT NULL COMMENT '固定资本' AFTER `registered_capital`,
ADD COLUMN `annual_profit_tax`  varchar(50) NULL DEFAULT NULL COMMENT '年利税' AFTER `fixed_capital`,
ADD COLUMN `annual_sales_volume`  varchar(50) NULL DEFAULT NULL COMMENT '年营业额' AFTER `annual_profit_tax`,
ADD COLUMN `certificate_type`  tinyint(4) NOT NULL DEFAULT 0 COMMENT '证件类型' AFTER `annual_sales_volume`,
ADD COLUMN `service_permit_number`  varchar(100)  NULL DEFAULT NULL COMMENT '保安服务许可/保安培训备案证号' AFTER `certificate_type`,
ADD COLUMN `security_approval_number`  varchar(100)  NULL DEFAULT NULL COMMENT '批准文号' AFTER `service_permit_number`,
ADD COLUMN `name_of_issuing_authority`  varchar(200)  NULL DEFAULT NULL COMMENT '发证机关' AFTER `security_approval_number`,
ADD COLUMN `first_issue_service_permit`  date  NULL DEFAULT NULL COMMENT '保安服务许可证首次发证日期或者培训单位的发证日期' AFTER `name_of_issuing_authority`,
ADD COLUMN `service_permit_attachment`  varchar(500)  NULL DEFAULT NULL COMMENT '保安服务许可证扫描件或者保安培训许可（备案）证扫描件' AFTER `first_issue_service_permit`,
ADD COLUMN `train_content`  varchar(500)  NULL DEFAULT NULL COMMENT '培训单位的培训内容' AFTER `service_permit_attachment`,
ADD COLUMN `security_preparedness_rating`  tinyint(4)  NULL DEFAULT NULL COMMENT '人力防范评定等级，0-无，1-一级，2-二级，3-三级，4-准三级' AFTER `train_content`,
ADD COLUMN `security_armed_rating`  tinyint(4)  NULL DEFAULT NULL COMMENT '武装守护押运评定等级，0-无，1-一级，2-二级' AFTER `security_preparedness_rating`,
ADD COLUMN `security_safety_defense_rating`  tinyint(4)  NULL DEFAULT NULL COMMENT '安全技术防范评定等级，0-无，1-一级，2-二级，3-三级' AFTER `security_armed_rating`,
ADD COLUMN `is_risk_assessment`  tinyint(4)  NULL DEFAULT NULL COMMENT '是否有风险评估资质，0-否，1-是' AFTER `security_safety_defense_rating`,
ADD COLUMN `number_of_security_guards`  int(11)  NULL DEFAULT NULL COMMENT '自行招用保安员单位.拟自招保安员数' AFTER `is_risk_assessment`,
ADD COLUMN `is_public_security_security`  tinyint(4)  NULL DEFAULT NULL COMMENT '自行招用保安员单位.是否治安保卫重点单位，0-否，1-是' AFTER `number_of_security_guards`,
ADD COLUMN `is_property_enterprise`  tinyint(4)  NULL DEFAULT NULL COMMENT '自行招用保安员单位.是否物业企业，0-否，1-是' AFTER `is_public_security_security`,
ADD COLUMN `nature_of_self_recruited_units`  varchar(10)  NULL DEFAULT NULL COMMENT '自行招用保安员单位.自招保安单位性质' AFTER `is_property_enterprise`,
ADD COLUMN `legal_person_name`  varchar(200)  NOT NULL DEFAULT '' COMMENT '法人姓名' AFTER `nature_of_self_recruited_units`,
ADD COLUMN `legal_person_telephone`  varchar(20)  NOT NULL DEFAULT '' COMMENT '法人手机号码' AFTER `legal_person_name`,
ADD COLUMN `legal_person_credential_type`  tinyint(4)  NOT NULL DEFAULT 0 COMMENT '法人证件类型' AFTER `legal_person_telephone`,
ADD COLUMN `legal_person_credential_number`  varchar(100)  NOT NULL DEFAULT '' COMMENT '法人证件号码' AFTER `legal_person_credential_type`,
ADD COLUMN `legal_person_nationality`  varchar(30)  NOT NULL DEFAULT '' COMMENT '法人国籍' AFTER `legal_person_credential_number`,
ADD COLUMN `security_person_name`  varchar(200)  NULL DEFAULT NULL COMMENT '保安负责人姓名' AFTER `legal_person_nationality`,
ADD COLUMN `security_person_telephone`  varchar(20)  NULL DEFAULT NULL COMMENT '保安负责人手机号码' AFTER `security_person_name`,
ADD COLUMN `security_person_credential_type`  tinyint(4)  NULL DEFAULT NULL COMMENT '保安负责人证件类型' AFTER `security_person_telephone`,
ADD COLUMN `security_person_credential_number`  varchar(100)  NULL DEFAULT NULL COMMENT '保安负责人证件号码' AFTER `security_person_credential_type`,
ADD COLUMN `create_time`  datetime NULL DEFAULT NULL COMMENT '创建时间' AFTER `security_person_credential_number`,
ADD COLUMN `last_updated_time`  datetime NULL DEFAULT NULL COMMENT '更新时间' AFTER `create_time`;


ALTER TABLE obpm2_security.`tenant_users`
ADD COLUMN `nationality`  varchar(30) NULL DEFAULT NULL COMMENT '国籍' AFTER `last_sync_time`,
ADD COLUMN `work_year`  int(11) NULL DEFAULT NULL COMMENT '从业年限' AFTER `nationality`,
ADD COLUMN `diseases_history`  varchar(500) NULL DEFAULT NULL COMMENT '疾病历史' AFTER `work_year`;


UPDATE obpm2_security.`tenant_organizations` SET `industry_code`='01' WHERE `industry_code`='保安行业';
UPDATE obpm2_security.`tenant_organizations` SET `industry_code`='02' WHERE `industry_code`='大活行业';
UPDATE obpm2_security.`tenant_organizations` SET `industry_code`='03' WHERE `industry_code`='其他';


UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0101' WHERE `institutional_code`='保安协会';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0102' WHERE `institutional_code`='保安服务公司';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0103' WHERE `institutional_code`='保安培训单位';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0104' WHERE `institutional_code` like '自行招用保安%';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0105' WHERE `institutional_code`='省级保安协会';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0106' WHERE `institutional_code`='市级保安协会';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0107' WHERE `institutional_code`='省级保安监管机构';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0108' WHERE `institutional_code`='市级保安监管机构';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0201' WHERE `institutional_code`='活动承办方';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0202' WHERE `institutional_code`='政府单位';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0301' WHERE `institutional_code`='其他';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0201' WHERE `institutional_code`='承办单位';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0203' WHERE `institutional_code`='风评机构';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0204' WHERE `institutional_code`='服务机构';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0205' WHERE `institutional_code`='公安机构';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0108' WHERE `institutional_code`='市级保安监督机构';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0103' WHERE `institutional_code`='保安培训机构';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0102' WHERE `institutional_code`='保安服务公司及培训单位';
UPDATE obpm2_security.`tenant_organizations` SET `institutional_code`='0109' WHERE `institutional_code`='治安机关';



DELETE FROM obpm2_security.obpm2_security.`config_dict` WHERE code_type = 'education' and code_value = '10';

UPDATE obpm2_security.tenant_users u SET u.education = '初中' WHERE u.education = '其他';
UPDATE obpm2_security.tenant_users u SET u.education = '初中' WHERE u.education = '小学';
UPDATE obpm2_security.tenant_users u SET u.education = '硕士研究生及以上' WHERE u.education = '硕士研究生';
UPDATE obpm2_security.tenant_users u SET u.education = '硕士研究生及以上' WHERE u.education = '博士后';
UPDATE obpm2_security.tenant_users u SET u.education = '硕士研究生及以上' WHERE u.education = '博士';
UPDATE obpm2_security.tenant_users u SET u.education = '初中' WHERE u.education = '1';
UPDATE obpm2_security.tenant_users u SET u.education = '初中' WHERE u.education = '2';
UPDATE obpm2_security.tenant_users u SET u.education = '高中' WHERE u.education = '3';
UPDATE obpm2_security.tenant_users u SET u.education = '中专' WHERE u.education = '4';
UPDATE obpm2_security.tenant_users u SET u.education = '大专' WHERE u.education = '5';
UPDATE obpm2_security.tenant_users u SET u.education = '本科' WHERE u.education = '6';
UPDATE obpm2_security.tenant_users u SET u.education = '硕士研究生及以上' WHERE u.education = '7';


DROP TABLE IF EXISTS obpm2_security.`t_supervise_department`;
CREATE TABLE obpm2_security.`t_supervise_department` (
  `pk_id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `id` varchar(32) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL COMMENT '名称',
  `superior` varchar(100) DEFAULT NULL COMMENT '上级编码',
  `status` varchar(10) DEFAULT NULL COMMENT '状态',
  `index_code` varchar(200) DEFAULT NULL COMMENT '层级',
  `region_id` varchar(32) DEFAULT NULL COMMENT '地区id',
  PRIMARY KEY (`pk_id`),
  UNIQUE KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=utf8 COMMENT='监管机构表';

DROP TABLE obpm2_security.`config_dict`;
CREATE TABLE obpm2_security.`config_dict` (
   `id` int(20) NOT NULL AUTO_INCREMENT COMMENT '代码条目ID',
   `is_active` varchar(1) DEFAULT '1' COMMENT '是否有效',
   `code_type` varchar(30) DEFAULT NULL COMMENT '代码类型',
   `description` varchar(255) DEFAULT NULL COMMENT '代码中文描述',
   `code_value` varchar(20) DEFAULT NULL COMMENT '代码值',
   `label` varchar(100) DEFAULT NULL COMMENT '代码值中文描述',
   `seq` int(2) DEFAULT NULL COMMENT '排序',
   PRIMARY KEY (`id`),
   KEY `index_codeType_codeValue` (`code_type`,`code_value`)
) ENGINE=InnoDB AUTO_INCREMENT=2187 DEFAULT CHARSET=utf8 COMMENT='字典表';

INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2095', '1', 'bloodType', '血型', 'A', 'A', '1');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2096', '1', 'bloodType', '血型', 'B', 'B', '2');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2097', '1', 'bloodType', '血型', 'O', 'O', '3');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2098', '1', 'bloodType', '血型', 'AB', 'AB', '4');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2099', '1', 'politicalStatus', '政治面貌', '01', '中共党员', '1');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2100', '1', 'politicalStatus', '政治面貌', '02', '中共预备党员', '2');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2101', '1', 'politicalStatus', '政治面貌', '03', '共青团员', '3');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2102', '1', 'politicalStatus', '政治面貌', '04', '民革会员', '4');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2103', '1', 'politicalStatus', '政治面貌', '05', '民盟盟员', '5');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2104', '1', 'politicalStatus', '政治面貌', '06', '民建会员', '6');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2105', '1', 'politicalStatus', '政治面貌', '07', '民进会员', '7');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2106', '1', 'politicalStatus', '政治面貌', '08', '农工党党员', '8');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2107', '1', 'politicalStatus', '政治面貌', '09', '致公党党员', '9');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2108', '1', 'politicalStatus', '政治面貌', '10', '九三学社社员', '10');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2109', '1', 'politicalStatus', '政治面貌', '11', '台盟盟员', '11');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2110', '1', 'politicalStatus', '政治面貌', '12', '无党派民主人士', '12');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2111', '1', 'politicalStatus', '政治面貌', '13', '群众', '13');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2113', '1', 'education', '学历', '2', '初中', '2');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2114', '1', 'education', '学历', '3', '高中', '3');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2115', '1', 'education', '学历', '4', '中专', '4');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2116', '1', 'education', '学历', '5', '大专', '5');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2117', '1', 'education', '学历', '6', '本科', '6');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2118', '1', 'education', '学历', '7', '硕士研究生及以上', '7');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2121', '1', 'sex', '性别', '1', '男', '1');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2122', '1', 'sex', '性别', '2', '女', '2');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2123', '1', 'sex', '性别', '9', '未说明性别', '3');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2124', '1', 'sexRequire', '性别要求', '0', '不限', '1');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2125', '1', 'sexRequire', '性别要求', '1', '男', '2');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2126', '1', 'sexRequire', '性别要求', '2', '女', '3');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2127', '1', 'nation', '民族', '01', '汉族', '1');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2128', '1', 'nation', '民族', '02', '蒙古族', '2');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2129', '1', 'nation', '民族', '03', '回族', '3');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2130', '1', 'nation', '民族', '04', '藏族', '4');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2131', '1', 'nation', '民族', '05', '维吾尔族', '5');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2132', '1', 'nation', '民族', '06', '苗族', '6');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2133', '1', 'nation', '民族', '07', '彝族', '7');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2134', '1', 'nation', '民族', '08', '壮族', '8');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2135', '1', 'nation', '民族', '09', '布依族', '9');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2136', '1', 'nation', '民族', '10', '朝鲜族', '10');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2137', '1', 'nation', '民族', '11', '满族', '11');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2138', '1', 'nation', '民族', '12', '侗族', '12');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2139', '1', 'nation', '民族', '13', '瑶族', '13');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2140', '1', 'nation', '民族', '14', '白族', '14');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2141', '1', 'nation', '民族', '15', '土家族', '15');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2142', '1', 'nation', '民族', '16', '哈尼族', '16');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2143', '1', 'nation', '民族', '17', '哈萨克族', '17');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2144', '1', 'nation', '民族', '18', '傣族', '18');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2145', '1', 'nation', '民族', '19', '黎族', '19');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2146', '1', 'nation', '民族', '20', '傈僳族', '20');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2147', '1', 'nation', '民族', '21', '佤族', '21');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2148', '1', 'nation', '民族', '22', '畲族', '22');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2149', '1', 'nation', '民族', '23', '高山族', '23');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2150', '1', 'nation', '民族', '24', '拉祜族', '24');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2151', '1', 'nation', '民族', '25', '水族', '25');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2152', '1', 'nation', '民族', '26', '东乡族', '26');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2153', '1', 'nation', '民族', '27', '纳西族', '27');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2154', '1', 'nation', '民族', '28', '景颇族', '28');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2155', '1', 'nation', '民族', '29', '柯尔克孜族', '29');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2156', '1', 'nation', '民族', '30', '土族', '30');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2157', '1', 'nation', '民族', '31', '达斡尔族', '31');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2158', '1', 'nation', '民族', '32', '仫佬族', '32');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2159', '1', 'nation', '民族', '33', '羌族', '33');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2160', '1', 'nation', '民族', '34', '布朗族', '34');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2161', '1', 'nation', '民族', '35', '撒拉族', '35');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2162', '1', 'nation', '民族', '36', '毛南族', '36');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2163', '1', 'nation', '民族', '37', '仡佬族', '37');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2164', '1', 'nation', '民族', '38', '锡伯族', '38');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2165', '1', 'nation', '民族', '39', '阿昌族', '39');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2166', '1', 'nation', '民族', '40', '普米族', '40');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2167', '1', 'nation', '民族', '41', '塔吉克族', '41');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2168', '1', 'nation', '民族', '42', '怒族', '42');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2169', '1', 'nation', '民族', '43', '乌孜别克族', '43');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2170', '1', 'nation', '民族', '44', '俄罗斯族', '44');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2171', '1', 'nation', '民族', '45', '鄂温克族', '45');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2172', '1', 'nation', '民族', '46', '崩龙族', '46');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2173', '1', 'nation', '民族', '47', '保安族', '47');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2174', '1', 'nation', '民族', '48', '裕固族', '48');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2175', '1', 'nation', '民族', '49', '京族', '49');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2176', '1', 'nation', '民族', '50', '塔塔尔族', '50');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2177', '1', 'nation', '民族', '51', '独龙族', '51');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2178', '1', 'nation', '民族', '52', '鄂伦春族', '52');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2179', '1', 'nation', '民族', '53', '赫哲族', '53');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2180', '1', 'nation', '民族', '54', '门巴族', '54');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2181', '1', 'nation', '民族', '55', '珞巴族', '55');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2182', '1', 'nation', '民族', '56', '基诺族', '56');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2183', '1', 'nation', '民族', '97', '其他', '57');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2184', '1', 'nation', '民族', '98', '外国血统中国籍人士', '58');
INSERT INTO obpm2_security.`config_dict` (`id`, `is_active`, `code_type`, `description`, `code_value`, `label`, `seq`) VALUES ('2186', '1', 'bloodType', '血型', 'S', '其它', '5');
