/*
 Navicat Premium Data Transfer

 Source Server         : V5测试
 Source Server Type    : MySQL
 Source Server Version : 50732
 Source Host           : 114.115.143.15:3300
 Source Schema         : obpm2

 Target Server Type    : MySQL
 Target Server Version : 50732
 File Encoding         : 65001

 Date: 08/03/2022 15:37:27
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for config_dict
-- ----------------------------
DROP TABLE IF EXISTS `config_dict`;
CREATE TABLE `config_dict`  (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT '代码条目ID',
  `is_active` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '是否有效',
  `code_type` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代码类型',
  `description` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代码中文描述',
  `code_value` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代码值',
  `label` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '代码值中文描述',
  `seq` int(2) NULL DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `index_codeType_codeValue`(`code_type`, `code_value`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 2187 CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '字典表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of config_dict
-- ----------------------------
INSERT INTO `config_dict` VALUES (2095, '1', 'bloodType', '血型', 'A', 'A', 1);
INSERT INTO `config_dict` VALUES (2096, '1', 'bloodType', '血型', 'B', 'B', 2);
INSERT INTO `config_dict` VALUES (2097, '1', 'bloodType', '血型', 'O', 'O', 3);
INSERT INTO `config_dict` VALUES (2098, '1', 'bloodType', '血型', 'AB', 'AB', 4);
INSERT INTO `config_dict` VALUES (2099, '1', 'politicalStatus', '政治面貌', '01', '中共党员', 1);
INSERT INTO `config_dict` VALUES (2100, '1', 'politicalStatus', '政治面貌', '02', '中共预备党员', 2);
INSERT INTO `config_dict` VALUES (2101, '1', 'politicalStatus', '政治面貌', '03', '共青团员', 3);
INSERT INTO `config_dict` VALUES (2102, '1', 'politicalStatus', '政治面貌', '04', '民革会员', 4);
INSERT INTO `config_dict` VALUES (2103, '1', 'politicalStatus', '政治面貌', '05', '民盟盟员', 5);
INSERT INTO `config_dict` VALUES (2104, '1', 'politicalStatus', '政治面貌', '06', '民建会员', 6);
INSERT INTO `config_dict` VALUES (2105, '1', 'politicalStatus', '政治面貌', '07', '民进会员', 7);
INSERT INTO `config_dict` VALUES (2106, '1', 'politicalStatus', '政治面貌', '08', '农工党党员', 8);
INSERT INTO `config_dict` VALUES (2107, '1', 'politicalStatus', '政治面貌', '09', '致公党党员', 9);
INSERT INTO `config_dict` VALUES (2108, '1', 'politicalStatus', '政治面貌', '10', '九三学社社员', 10);
INSERT INTO `config_dict` VALUES (2109, '1', 'politicalStatus', '政治面貌', '11', '台盟盟员', 11);
INSERT INTO `config_dict` VALUES (2110, '1', 'politicalStatus', '政治面貌', '12', '无党派民主人士', 12);
INSERT INTO `config_dict` VALUES (2111, '1', 'politicalStatus', '政治面貌', '13', '群众', 13);
INSERT INTO `config_dict` VALUES (2113, '1', 'education', '学历', '2', '初中', 2);
INSERT INTO `config_dict` VALUES (2114, '1', 'education', '学历', '3', '高中', 3);
INSERT INTO `config_dict` VALUES (2115, '1', 'education', '学历', '4', '中专', 4);
INSERT INTO `config_dict` VALUES (2116, '1', 'education', '学历', '5', '大专', 5);
INSERT INTO `config_dict` VALUES (2117, '1', 'education', '学历', '6', '本科', 6);
INSERT INTO `config_dict` VALUES (2118, '1', 'education', '学历', '7', '硕士研究生及以上', 7);
INSERT INTO `config_dict` VALUES (2121, '1', 'sex', '性别', '1', '男', 1);
INSERT INTO `config_dict` VALUES (2122, '1', 'sex', '性别', '2', '女', 2);
INSERT INTO `config_dict` VALUES (2123, '1', 'sex', '性别', '9', '未说明性别', 3);
INSERT INTO `config_dict` VALUES (2124, '1', 'sexRequire', '性别要求', '0', '不限', 1);
INSERT INTO `config_dict` VALUES (2125, '1', 'sexRequire', '性别要求', '1', '男', 2);
INSERT INTO `config_dict` VALUES (2126, '1', 'sexRequire', '性别要求', '2', '女', 3);
INSERT INTO `config_dict` VALUES (2127, '1', 'nation', '民族', '01', '汉族', 1);
INSERT INTO `config_dict` VALUES (2128, '1', 'nation', '民族', '02', '蒙古族', 2);
INSERT INTO `config_dict` VALUES (2129, '1', 'nation', '民族', '03', '回族', 3);
INSERT INTO `config_dict` VALUES (2130, '1', 'nation', '民族', '04', '藏族', 4);
INSERT INTO `config_dict` VALUES (2131, '1', 'nation', '民族', '05', '维吾尔族', 5);
INSERT INTO `config_dict` VALUES (2132, '1', 'nation', '民族', '06', '苗族', 6);
INSERT INTO `config_dict` VALUES (2133, '1', 'nation', '民族', '07', '彝族', 7);
INSERT INTO `config_dict` VALUES (2134, '1', 'nation', '民族', '08', '壮族', 8);
INSERT INTO `config_dict` VALUES (2135, '1', 'nation', '民族', '09', '布依族', 9);
INSERT INTO `config_dict` VALUES (2136, '1', 'nation', '民族', '10', '朝鲜族', 10);
INSERT INTO `config_dict` VALUES (2137, '1', 'nation', '民族', '11', '满族', 11);
INSERT INTO `config_dict` VALUES (2138, '1', 'nation', '民族', '12', '侗族', 12);
INSERT INTO `config_dict` VALUES (2139, '1', 'nation', '民族', '13', '瑶族', 13);
INSERT INTO `config_dict` VALUES (2140, '1', 'nation', '民族', '14', '白族', 14);
INSERT INTO `config_dict` VALUES (2141, '1', 'nation', '民族', '15', '土家族', 15);
INSERT INTO `config_dict` VALUES (2142, '1', 'nation', '民族', '16', '哈尼族', 16);
INSERT INTO `config_dict` VALUES (2143, '1', 'nation', '民族', '17', '哈萨克族', 17);
INSERT INTO `config_dict` VALUES (2144, '1', 'nation', '民族', '18', '傣族', 18);
INSERT INTO `config_dict` VALUES (2145, '1', 'nation', '民族', '19', '黎族', 19);
INSERT INTO `config_dict` VALUES (2146, '1', 'nation', '民族', '20', '傈僳族', 20);
INSERT INTO `config_dict` VALUES (2147, '1', 'nation', '民族', '21', '佤族', 21);
INSERT INTO `config_dict` VALUES (2148, '1', 'nation', '民族', '22', '畲族', 22);
INSERT INTO `config_dict` VALUES (2149, '1', 'nation', '民族', '23', '高山族', 23);
INSERT INTO `config_dict` VALUES (2150, '1', 'nation', '民族', '24', '拉祜族', 24);
INSERT INTO `config_dict` VALUES (2151, '1', 'nation', '民族', '25', '水族', 25);
INSERT INTO `config_dict` VALUES (2152, '1', 'nation', '民族', '26', '东乡族', 26);
INSERT INTO `config_dict` VALUES (2153, '1', 'nation', '民族', '27', '纳西族', 27);
INSERT INTO `config_dict` VALUES (2154, '1', 'nation', '民族', '28', '景颇族', 28);
INSERT INTO `config_dict` VALUES (2155, '1', 'nation', '民族', '29', '柯尔克孜族', 29);
INSERT INTO `config_dict` VALUES (2156, '1', 'nation', '民族', '30', '土族', 30);
INSERT INTO `config_dict` VALUES (2157, '1', 'nation', '民族', '31', '达斡尔族', 31);
INSERT INTO `config_dict` VALUES (2158, '1', 'nation', '民族', '32', '仫佬族', 32);
INSERT INTO `config_dict` VALUES (2159, '1', 'nation', '民族', '33', '羌族', 33);
INSERT INTO `config_dict` VALUES (2160, '1', 'nation', '民族', '34', '布朗族', 34);
INSERT INTO `config_dict` VALUES (2161, '1', 'nation', '民族', '35', '撒拉族', 35);
INSERT INTO `config_dict` VALUES (2162, '1', 'nation', '民族', '36', '毛难族', 36);
INSERT INTO `config_dict` VALUES (2163, '1', 'nation', '民族', '37', '仡佬族', 37);
INSERT INTO `config_dict` VALUES (2164, '1', 'nation', '民族', '38', '锡伯族', 38);
INSERT INTO `config_dict` VALUES (2165, '1', 'nation', '民族', '39', '阿昌族', 39);
INSERT INTO `config_dict` VALUES (2166, '1', 'nation', '民族', '40', '普米族', 40);
INSERT INTO `config_dict` VALUES (2167, '1', 'nation', '民族', '41', '塔吉克族', 41);
INSERT INTO `config_dict` VALUES (2168, '1', 'nation', '民族', '42', '怒族', 42);
INSERT INTO `config_dict` VALUES (2169, '1', 'nation', '民族', '43', '乌孜别克族', 43);
INSERT INTO `config_dict` VALUES (2170, '1', 'nation', '民族', '44', '俄罗斯族', 44);
INSERT INTO `config_dict` VALUES (2171, '1', 'nation', '民族', '45', '鄂温克族', 45);
INSERT INTO `config_dict` VALUES (2172, '1', 'nation', '民族', '46', '崩龙族', 46);
INSERT INTO `config_dict` VALUES (2173, '1', 'nation', '民族', '47', '保安族', 47);
INSERT INTO `config_dict` VALUES (2174, '1', 'nation', '民族', '48', '裕固族', 48);
INSERT INTO `config_dict` VALUES (2175, '1', 'nation', '民族', '49', '京族', 49);
INSERT INTO `config_dict` VALUES (2176, '1', 'nation', '民族', '50', '塔塔尔族', 50);
INSERT INTO `config_dict` VALUES (2177, '1', 'nation', '民族', '51', '独龙族', 51);
INSERT INTO `config_dict` VALUES (2178, '1', 'nation', '民族', '52', '鄂伦春族', 52);
INSERT INTO `config_dict` VALUES (2179, '1', 'nation', '民族', '53', '赫哲族', 53);
INSERT INTO `config_dict` VALUES (2180, '1', 'nation', '民族', '54', '门巴族', 54);
INSERT INTO `config_dict` VALUES (2181, '1', 'nation', '民族', '55', '珞巴族', 55);
INSERT INTO `config_dict` VALUES (2182, '1', 'nation', '民族', '56', '基诺族', 56);
INSERT INTO `config_dict` VALUES (2183, '1', 'nation', '民族', '97', '其他', 57);
INSERT INTO `config_dict` VALUES (2184, '1', 'nation', '民族', '98', '外国血统中国籍人士', 58);
INSERT INTO `config_dict` VALUES (2185, '1', 'education', '学历', '10', '其他', 10);
INSERT INTO `config_dict` VALUES (2186, '1', 'bloodType', '血型', 'S', '其它', 5);

-- ----------------------------
-- Table structure for sys_config
-- ----------------------------
DROP TABLE IF EXISTS `sys_config`;
CREATE TABLE `sys_config`  (
  `config_id` int(11) NOT NULL,
  `active` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `config_key` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `config_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `config_value` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `remark` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`config_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_config
-- ----------------------------
INSERT INTO `sys_config` VALUES (1, '1', 'v5WebUrl', 'v5前端访问地址', 'https://v5qy.test.baibaodun.cn', NULL);

-- ----------------------------
-- Table structure for sys_region
-- ----------------------------
DROP TABLE IF EXISTS `sys_region`;
CREATE TABLE `sys_region`  (
  `id` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '区域ID',
  `createTime` datetime(0) NOT NULL COMMENT '创建时间',
  `createBy` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人ID',
  `updateTime` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `updateBy` varchar(20) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人ID',
  `region_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '区域名称',
  `region_full_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '区域全称',
  `region_level` varchar(6) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '区域级别',
  `seq` int(4) NULL DEFAULT NULL COMMENT '排序',
  `first_letter` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '地区首字母',
  `remark` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `isActiveMarket` varchar(1) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '是否激活市场',
  `zipCode` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '邮政编码',
  `parent_id` varchar(8) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '上级区域ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci COMMENT = '地区' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_region
-- ----------------------------
INSERT INTO `sys_region` VALUES ('110000', '2018-01-30 19:30:19', NULL, NULL, NULL, '北京市', '北京市', '1', 1, 'B', NULL, '0', '', '100000');
INSERT INTO `sys_region` VALUES ('110100', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '北京市市辖区', '2', 1, 'S', NULL, '1', '100000', '110000');
INSERT INTO `sys_region` VALUES ('110101', '2018-01-30 19:30:19', NULL, NULL, NULL, '东城区', '北京市市辖区东城区', '3', 1, 'D', NULL, '1', '100010', '110100');
INSERT INTO `sys_region` VALUES ('110102', '2018-01-30 19:30:19', NULL, NULL, NULL, '西城区', '北京市市辖区西城区', '3', 2, 'X', NULL, '1', '100032', '110100');
INSERT INTO `sys_region` VALUES ('110105', '2018-01-30 19:30:19', NULL, NULL, NULL, '朝阳区', '北京市市辖区朝阳区', '3', 3, 'C', NULL, '1', '100020', '110100');
INSERT INTO `sys_region` VALUES ('110106', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰台区', '北京市市辖区丰台区', '3', 4, 'F', NULL, '1', '100071', '110100');
INSERT INTO `sys_region` VALUES ('110107', '2018-01-30 19:30:19', NULL, NULL, NULL, '石景山区', '北京市市辖区石景山区', '3', 5, 'S', NULL, '1', '100043', '110100');
INSERT INTO `sys_region` VALUES ('110108', '2018-01-30 19:30:19', NULL, NULL, NULL, '海淀区', '北京市市辖区海淀区', '3', 6, 'H', NULL, '1', '100089', '110100');
INSERT INTO `sys_region` VALUES ('110109', '2018-01-30 19:30:19', NULL, NULL, NULL, '门头沟区', '北京市市辖区门头沟区', '3', 7, 'M', NULL, '1', '102300', '110100');
INSERT INTO `sys_region` VALUES ('110111', '2018-01-30 19:30:19', NULL, NULL, NULL, '房山区', '北京市市辖区房山区', '3', 8, 'F', NULL, '1', '102488', '110100');
INSERT INTO `sys_region` VALUES ('110112', '2018-01-30 19:30:19', NULL, NULL, NULL, '通州区', '北京市市辖区通州区', '3', 9, 'T', NULL, '1', '101149', '110100');
INSERT INTO `sys_region` VALUES ('110113', '2018-01-30 19:30:19', NULL, NULL, NULL, '顺义区', '北京市市辖区顺义区', '3', 10, 'S', NULL, '1', '101300', '110100');
INSERT INTO `sys_region` VALUES ('110114', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌平区', '北京市市辖区昌平区', '3', 11, 'C', NULL, '1', '102200', '110100');
INSERT INTO `sys_region` VALUES ('110115', '2018-01-30 19:30:19', NULL, NULL, NULL, '大兴区', '北京市市辖区大兴区', '3', 12, 'D', NULL, '1', '102600', '110100');
INSERT INTO `sys_region` VALUES ('110116', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀柔区', '北京市市辖区怀柔区', '3', 13, 'H', NULL, '1', '101400', '110100');
INSERT INTO `sys_region` VALUES ('110117', '2018-01-30 19:30:19', NULL, NULL, NULL, '平谷区', '北京市市辖区平谷区', '3', 14, 'P', NULL, '1', '101200', '110100');
INSERT INTO `sys_region` VALUES ('110118', '2018-01-30 19:30:19', NULL, NULL, NULL, '密云区', '北京市市辖区密云区', '3', 15, 'M', NULL, '1', '101599', '110100');
INSERT INTO `sys_region` VALUES ('110119', '2018-01-30 19:30:19', NULL, NULL, NULL, '延庆区', '北京市市辖区延庆区', '3', 16, 'Y', NULL, '1', '102101', '110100');
INSERT INTO `sys_region` VALUES ('120000', '2018-01-30 19:30:19', NULL, NULL, NULL, '天津市', '天津市', '1', 2, 'T', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('120100', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '天津市市辖区', '2', 1, 'S', NULL, '1', '300000', '120000');
INSERT INTO `sys_region` VALUES ('120101', '2018-01-30 19:30:19', NULL, NULL, NULL, '和平区', '天津市市辖区和平区', '3', 1, 'H', NULL, '1', '300041', '120100');
INSERT INTO `sys_region` VALUES ('120102', '2018-01-30 19:30:19', NULL, NULL, NULL, '河东区', '天津市市辖区河东区', '3', 2, 'H', NULL, '1', '300171', '120100');
INSERT INTO `sys_region` VALUES ('120103', '2018-01-30 19:30:19', NULL, NULL, NULL, '河西区', '天津市市辖区河西区', '3', 3, 'H', NULL, '1', '300202', '120100');
INSERT INTO `sys_region` VALUES ('120104', '2018-01-30 19:30:19', NULL, NULL, NULL, '南开区', '天津市市辖区南开区', '3', 4, 'N', NULL, '1', '300110', '120100');
INSERT INTO `sys_region` VALUES ('120105', '2018-01-30 19:30:19', NULL, NULL, NULL, '河北区', '天津市市辖区河北区', '3', 5, 'H', NULL, '1', '300143', '120100');
INSERT INTO `sys_region` VALUES ('120106', '2018-01-30 19:30:19', NULL, NULL, NULL, '红桥区', '天津市市辖区红桥区', '3', 6, 'H', NULL, '1', '300131', '120100');
INSERT INTO `sys_region` VALUES ('120110', '2018-01-30 19:30:19', NULL, NULL, NULL, '东丽区', '天津市市辖区东丽区', '3', 7, 'D', NULL, '1', '300300', '120100');
INSERT INTO `sys_region` VALUES ('120111', '2018-01-30 19:30:19', NULL, NULL, NULL, '西青区', '天津市市辖区西青区', '3', 8, 'X', NULL, '1', '300380', '120100');
INSERT INTO `sys_region` VALUES ('120112', '2018-01-30 19:30:19', NULL, NULL, NULL, '津南区', '天津市市辖区津南区', '3', 9, 'J', NULL, '1', '300350', '120100');
INSERT INTO `sys_region` VALUES ('120113', '2018-01-30 19:30:19', NULL, NULL, NULL, '北辰区', '天津市市辖区北辰区', '3', 10, 'B', NULL, '1', '300400', '120100');
INSERT INTO `sys_region` VALUES ('120114', '2018-01-30 19:30:19', NULL, NULL, NULL, '武清区', '天津市市辖区武清区', '3', 11, 'W', NULL, '1', '301700', '120100');
INSERT INTO `sys_region` VALUES ('120115', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝坻区', '天津市市辖区宝坻区', '3', 12, 'B', NULL, '1', '301800', '120100');
INSERT INTO `sys_region` VALUES ('120116', '2018-01-30 19:30:19', NULL, NULL, NULL, '滨海新区', '天津市市辖区滨海新区', '3', 13, 'B', NULL, '1', '300451', '120100');
INSERT INTO `sys_region` VALUES ('120117', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁河区', '天津市市辖区宁河区', '3', 14, 'N', NULL, '1', NULL, '120100');
INSERT INTO `sys_region` VALUES ('120118', '2018-01-30 19:30:19', NULL, NULL, NULL, '静海区', '天津市市辖区静海区', '3', 15, 'J', NULL, '1', NULL, '120100');
INSERT INTO `sys_region` VALUES ('120119', '2018-01-30 19:30:19', NULL, NULL, NULL, '蓟州区', '天津市市辖区蓟州区', '3', 16, 'J', NULL, '1', NULL, '120100');
INSERT INTO `sys_region` VALUES ('130000', '2018-01-30 19:30:19', NULL, NULL, NULL, '河北省', '河北省', '1', 3, 'H', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('130100', '2018-01-30 19:30:19', NULL, NULL, NULL, '石家庄市', '河北省石家庄市', '2', 1, 'S', NULL, '1', '050011', '130000');
INSERT INTO `sys_region` VALUES ('130101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省石家庄市市辖区', '3', 1, 'S', NULL, '1', NULL, '130100');
INSERT INTO `sys_region` VALUES ('130102', '2018-01-30 19:30:19', NULL, NULL, NULL, '长安区', '河北省石家庄市长安区', '3', 2, 'C', NULL, '1', '050011', '130100');
INSERT INTO `sys_region` VALUES ('130104', '2018-01-30 19:30:19', NULL, NULL, NULL, '桥西区', '河北省石家庄市桥西区', '3', 3, 'Q', NULL, '1', '050091', '130100');
INSERT INTO `sys_region` VALUES ('130105', '2018-01-30 19:30:19', NULL, NULL, NULL, '新华区', '河北省石家庄市新华区', '3', 4, 'X', NULL, '1', '050051', '130100');
INSERT INTO `sys_region` VALUES ('130107', '2018-01-30 19:30:19', NULL, NULL, NULL, '井陉矿区', '河北省石家庄市井陉矿区', '3', 5, 'J', NULL, '1', '050100', '130100');
INSERT INTO `sys_region` VALUES ('130108', '2018-01-30 19:30:19', NULL, NULL, NULL, '裕华区', '河北省石家庄市裕华区', '3', 6, 'Y', NULL, '1', '050031', '130100');
INSERT INTO `sys_region` VALUES ('130109', '2018-01-30 19:30:19', NULL, NULL, NULL, '藁城区', '河北省石家庄市藁城区', '3', 7, 'Z', NULL, '1', '052160', '130100');
INSERT INTO `sys_region` VALUES ('130110', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹿泉区', '河北省石家庄市鹿泉区', '3', 8, 'L', NULL, '1', '050200', '130100');
INSERT INTO `sys_region` VALUES ('130111', '2018-01-30 19:30:19', NULL, NULL, NULL, '栾城区', '河北省石家庄市栾城区', '3', 9, 'Z', NULL, '1', '051430', '130100');
INSERT INTO `sys_region` VALUES ('130121', '2018-01-30 19:30:19', NULL, NULL, NULL, '井陉县', '河北省石家庄市井陉县', '3', 10, 'J', NULL, '1', '050300', '130100');
INSERT INTO `sys_region` VALUES ('130123', '2018-01-30 19:30:19', NULL, NULL, NULL, '正定县', '河北省石家庄市正定县', '3', 11, 'Z', NULL, '1', '050800', '130100');
INSERT INTO `sys_region` VALUES ('130125', '2018-01-30 19:30:19', NULL, NULL, NULL, '行唐县', '河北省石家庄市行唐县', '3', 12, 'X', NULL, '1', '050600', '130100');
INSERT INTO `sys_region` VALUES ('130126', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵寿县', '河北省石家庄市灵寿县', '3', 13, 'L', NULL, '1', '050500', '130100');
INSERT INTO `sys_region` VALUES ('130127', '2018-01-30 19:30:19', NULL, NULL, NULL, '高邑县', '河北省石家庄市高邑县', '3', 14, 'G', NULL, '1', '051330', '130100');
INSERT INTO `sys_region` VALUES ('130128', '2018-01-30 19:30:19', NULL, NULL, NULL, '深泽县', '河北省石家庄市深泽县', '3', 15, 'S', NULL, '1', '052560', '130100');
INSERT INTO `sys_region` VALUES ('130129', '2018-01-30 19:30:19', NULL, NULL, NULL, '赞皇县', '河北省石家庄市赞皇县', '3', 16, 'Z', NULL, '1', '051230', '130100');
INSERT INTO `sys_region` VALUES ('130130', '2018-01-30 19:30:19', NULL, NULL, NULL, '无极县', '河北省石家庄市无极县', '3', 17, 'W', NULL, '1', '052460', '130100');
INSERT INTO `sys_region` VALUES ('130131', '2018-01-30 19:30:19', NULL, NULL, NULL, '平山县', '河北省石家庄市平山县', '3', 18, 'P', NULL, '1', '050400', '130100');
INSERT INTO `sys_region` VALUES ('130132', '2018-01-30 19:30:19', NULL, NULL, NULL, '元氏县', '河北省石家庄市元氏县', '3', 19, 'Y', NULL, '1', '051130', '130100');
INSERT INTO `sys_region` VALUES ('130133', '2018-01-30 19:30:19', NULL, NULL, NULL, '赵县', '河北省石家庄市赵县', '3', 20, 'Z', NULL, '1', '051530', '130100');
INSERT INTO `sys_region` VALUES ('130183', '2018-01-30 19:30:19', NULL, NULL, NULL, '晋州市', '河北省石家庄市晋州市', '3', 21, 'J', NULL, '1', '052260', '130100');
INSERT INTO `sys_region` VALUES ('130184', '2018-01-30 19:30:19', NULL, NULL, NULL, '新乐市', '河北省石家庄市新乐市', '3', 22, 'X', NULL, '1', '050700', '130100');
INSERT INTO `sys_region` VALUES ('130200', '2018-01-30 19:30:19', NULL, NULL, NULL, '唐山市', '河北省唐山市', '2', 2, 'T', NULL, '1', '063000', '130000');
INSERT INTO `sys_region` VALUES ('130201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省唐山市市辖区', '3', 1, 'S', NULL, '1', NULL, '130200');
INSERT INTO `sys_region` VALUES ('130202', '2018-01-30 19:30:19', NULL, NULL, NULL, '路南区', '河北省唐山市路南区', '3', 2, 'L', NULL, '1', '063000', '130200');
INSERT INTO `sys_region` VALUES ('130203', '2018-01-30 19:30:19', NULL, NULL, NULL, '路北区', '河北省唐山市路北区', '3', 3, 'L', NULL, '1', '063000', '130200');
INSERT INTO `sys_region` VALUES ('130204', '2018-01-30 19:30:19', NULL, NULL, NULL, '古冶区', '河北省唐山市古冶区', '3', 4, 'G', NULL, '1', '063100', '130200');
INSERT INTO `sys_region` VALUES ('130205', '2018-01-30 19:30:19', NULL, NULL, NULL, '开平区', '河北省唐山市开平区', '3', 5, 'K', NULL, '1', '063021', '130200');
INSERT INTO `sys_region` VALUES ('130207', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰南区', '河北省唐山市丰南区', '3', 6, 'F', NULL, '1', '063300', '130200');
INSERT INTO `sys_region` VALUES ('130208', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰润区', '河北省唐山市丰润区', '3', 7, 'F', NULL, '1', '064000', '130200');
INSERT INTO `sys_region` VALUES ('130209', '2018-01-30 19:30:19', NULL, NULL, NULL, '曹妃甸区', '河北省唐山市曹妃甸区', '3', 8, 'C', NULL, '1', '063200', '130200');
INSERT INTO `sys_region` VALUES ('130223', '2018-01-30 19:30:19', NULL, NULL, NULL, '滦县', '河北省唐山市滦县', '3', 9, 'L', NULL, '1', '063700', '130200');
INSERT INTO `sys_region` VALUES ('130224', '2018-01-30 19:30:19', NULL, NULL, NULL, '滦南县', '河北省唐山市滦南县', '3', 10, 'L', NULL, '1', '063500', '130200');
INSERT INTO `sys_region` VALUES ('130225', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐亭县', '河北省唐山市乐亭县', '3', 11, 'L', NULL, '1', '063600', '130200');
INSERT INTO `sys_region` VALUES ('130227', '2018-01-30 19:30:19', NULL, NULL, NULL, '迁西县', '河北省唐山市迁西县', '3', 12, 'Q', NULL, '1', '064300', '130200');
INSERT INTO `sys_region` VALUES ('130229', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉田县', '河北省唐山市玉田县', '3', 13, 'Y', NULL, '1', '064100', '130200');
INSERT INTO `sys_region` VALUES ('130281', '2018-01-30 19:30:19', NULL, NULL, NULL, '遵化市', '河北省唐山市遵化市', '3', 14, 'Z', NULL, '1', '064200', '130200');
INSERT INTO `sys_region` VALUES ('130283', '2018-01-30 19:30:19', NULL, NULL, NULL, '迁安市', '河北省唐山市迁安市', '3', 15, 'Q', NULL, '1', '064400', '130200');
INSERT INTO `sys_region` VALUES ('130300', '2018-01-30 19:30:19', NULL, NULL, NULL, '秦皇岛市', '河北省秦皇岛市', '2', 3, 'Q', NULL, '1', '066000', '130000');
INSERT INTO `sys_region` VALUES ('130301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省秦皇岛市市辖区', '3', 1, 'S', NULL, '1', NULL, '130300');
INSERT INTO `sys_region` VALUES ('130302', '2018-01-30 19:30:19', NULL, NULL, NULL, '海港区', '河北省秦皇岛市海港区', '3', 2, 'H', NULL, '1', '066000', '130300');
INSERT INTO `sys_region` VALUES ('130303', '2018-01-30 19:30:19', NULL, NULL, NULL, '山海关区', '河北省秦皇岛市山海关区', '3', 3, 'S', NULL, '1', '066200', '130300');
INSERT INTO `sys_region` VALUES ('130304', '2018-01-30 19:30:19', NULL, NULL, NULL, '北戴河区', '河北省秦皇岛市北戴河区', '3', 4, 'B', NULL, '1', '066100', '130300');
INSERT INTO `sys_region` VALUES ('130306', '2018-01-30 19:30:19', NULL, NULL, NULL, '抚宁区', '河北省秦皇岛市抚宁区', '3', 5, 'F', NULL, '1', NULL, '130300');
INSERT INTO `sys_region` VALUES ('130321', '2018-01-30 19:30:19', NULL, NULL, NULL, '青龙满族自治县', '河北省秦皇岛市青龙满族自治县', '3', 6, 'Q', NULL, '1', '066500', '130300');
INSERT INTO `sys_region` VALUES ('130322', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌黎县', '河北省秦皇岛市昌黎县', '3', 7, 'C', NULL, '1', '066600', '130300');
INSERT INTO `sys_region` VALUES ('130324', '2018-01-30 19:30:19', NULL, NULL, NULL, '卢龙县', '河北省秦皇岛市卢龙县', '3', 8, 'L', NULL, '1', '066400', '130300');
INSERT INTO `sys_region` VALUES ('130400', '2018-01-30 19:30:19', NULL, NULL, NULL, '邯郸市', '河北省邯郸市', '2', 4, 'H', NULL, '1', '056002', '130000');
INSERT INTO `sys_region` VALUES ('130401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省邯郸市市辖区', '3', 1, 'S', NULL, '1', NULL, '130400');
INSERT INTO `sys_region` VALUES ('130402', '2018-01-30 19:30:19', NULL, NULL, NULL, '邯山区', '河北省邯郸市邯山区', '3', 2, 'H', NULL, '1', '056001', '130400');
INSERT INTO `sys_region` VALUES ('130403', '2018-01-30 19:30:19', NULL, NULL, NULL, '丛台区', '河北省邯郸市丛台区', '3', 3, 'C', NULL, '1', '056002', '130400');
INSERT INTO `sys_region` VALUES ('130404', '2018-01-30 19:30:19', NULL, NULL, NULL, '复兴区', '河北省邯郸市复兴区', '3', 4, 'F', NULL, '1', '056003', '130400');
INSERT INTO `sys_region` VALUES ('130406', '2018-01-30 19:30:19', NULL, NULL, NULL, '峰峰矿区', '河北省邯郸市峰峰矿区', '3', 5, 'F', NULL, '1', '056200', '130400');
INSERT INTO `sys_region` VALUES ('130421', '2018-01-30 19:30:19', NULL, NULL, NULL, '邯郸县', '河北省邯郸市邯郸县', '3', 6, 'H', NULL, '1', '056101', '130400');
INSERT INTO `sys_region` VALUES ('130423', '2018-01-30 19:30:19', NULL, NULL, NULL, '临漳县', '河北省邯郸市临漳县', '3', 7, 'L', NULL, '1', '056600', '130400');
INSERT INTO `sys_region` VALUES ('130424', '2018-01-30 19:30:19', NULL, NULL, NULL, '成安县', '河北省邯郸市成安县', '3', 8, 'C', NULL, '1', '056700', '130400');
INSERT INTO `sys_region` VALUES ('130425', '2018-01-30 19:30:19', NULL, NULL, NULL, '大名县', '河北省邯郸市大名县', '3', 9, 'D', NULL, '1', '056900', '130400');
INSERT INTO `sys_region` VALUES ('130426', '2018-01-30 19:30:19', NULL, NULL, NULL, '涉县', '河北省邯郸市涉县', '3', 10, 'S', NULL, '1', '056400', '130400');
INSERT INTO `sys_region` VALUES ('130427', '2018-01-30 19:30:19', NULL, NULL, NULL, '磁县', '河北省邯郸市磁县', '3', 11, 'C', NULL, '1', '056500', '130400');
INSERT INTO `sys_region` VALUES ('130428', '2018-01-30 19:30:19', NULL, NULL, NULL, '肥乡县', '河北省邯郸市肥乡县', '3', 12, 'F', NULL, '1', '057550', '130400');
INSERT INTO `sys_region` VALUES ('130429', '2018-01-30 19:30:19', NULL, NULL, NULL, '永年县', '河北省邯郸市永年县', '3', 13, 'Y', NULL, '1', '057150', '130400');
INSERT INTO `sys_region` VALUES ('130430', '2018-01-30 19:30:19', NULL, NULL, NULL, '邱县', '河北省邯郸市邱县', '3', 14, 'Q', NULL, '1', '057450', '130400');
INSERT INTO `sys_region` VALUES ('130431', '2018-01-30 19:30:19', NULL, NULL, NULL, '鸡泽县', '河北省邯郸市鸡泽县', '3', 15, 'J', NULL, '1', '057350', '130400');
INSERT INTO `sys_region` VALUES ('130432', '2018-01-30 19:30:19', NULL, NULL, NULL, '广平县', '河北省邯郸市广平县', '3', 16, 'G', NULL, '1', '057650', '130400');
INSERT INTO `sys_region` VALUES ('130433', '2018-01-30 19:30:19', NULL, NULL, NULL, '馆陶县', '河北省邯郸市馆陶县', '3', 17, 'G', NULL, '1', '057750', '130400');
INSERT INTO `sys_region` VALUES ('130434', '2018-01-30 19:30:19', NULL, NULL, NULL, '魏县', '河北省邯郸市魏县', '3', 18, 'W', NULL, '1', '056800', '130400');
INSERT INTO `sys_region` VALUES ('130435', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲周县', '河北省邯郸市曲周县', '3', 19, 'Q', NULL, '1', '057250', '130400');
INSERT INTO `sys_region` VALUES ('130481', '2018-01-30 19:30:19', NULL, NULL, NULL, '武安市', '河北省邯郸市武安市', '3', 20, 'W', NULL, '1', '056300', '130400');
INSERT INTO `sys_region` VALUES ('130500', '2018-01-30 19:30:19', NULL, NULL, NULL, '邢台市', '河北省邢台市', '2', 5, 'X', NULL, '1', '054001', '130000');
INSERT INTO `sys_region` VALUES ('130501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省邢台市市辖区', '3', 1, 'S', NULL, '1', NULL, '130500');
INSERT INTO `sys_region` VALUES ('130502', '2018-01-30 19:30:19', NULL, NULL, NULL, '桥东区', '河北省邢台市桥东区', '3', 2, 'Q', NULL, '1', '054001', '130500');
INSERT INTO `sys_region` VALUES ('130503', '2018-01-30 19:30:19', NULL, NULL, NULL, '桥西区', '河北省邢台市桥西区', '3', 3, 'Q', NULL, '1', '054000', '130500');
INSERT INTO `sys_region` VALUES ('130521', '2018-01-30 19:30:19', NULL, NULL, NULL, '邢台县', '河北省邢台市邢台县', '3', 4, 'X', NULL, '1', '054001', '130500');
INSERT INTO `sys_region` VALUES ('130522', '2018-01-30 19:30:19', NULL, NULL, NULL, '临城县', '河北省邢台市临城县', '3', 5, 'L', NULL, '1', '054300', '130500');
INSERT INTO `sys_region` VALUES ('130523', '2018-01-30 19:30:19', NULL, NULL, NULL, '内丘县', '河北省邢台市内丘县', '3', 6, 'N', NULL, '1', '054200', '130500');
INSERT INTO `sys_region` VALUES ('130524', '2018-01-30 19:30:19', NULL, NULL, NULL, '柏乡县', '河北省邢台市柏乡县', '3', 7, 'B', NULL, '1', '055450', '130500');
INSERT INTO `sys_region` VALUES ('130525', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆尧县', '河北省邢台市隆尧县', '3', 8, 'L', NULL, '1', '055350', '130500');
INSERT INTO `sys_region` VALUES ('130526', '2018-01-30 19:30:19', NULL, NULL, NULL, '任县', '河北省邢台市任县', '3', 9, 'R', NULL, '1', '055150', '130500');
INSERT INTO `sys_region` VALUES ('130527', '2018-01-30 19:30:19', NULL, NULL, NULL, '南和县', '河北省邢台市南和县', '3', 10, 'N', NULL, '1', '054400', '130500');
INSERT INTO `sys_region` VALUES ('130528', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁晋县', '河北省邢台市宁晋县', '3', 11, 'N', NULL, '1', '055550', '130500');
INSERT INTO `sys_region` VALUES ('130529', '2018-01-30 19:30:19', NULL, NULL, NULL, '巨鹿县', '河北省邢台市巨鹿县', '3', 12, 'J', NULL, '1', '055250', '130500');
INSERT INTO `sys_region` VALUES ('130530', '2018-01-30 19:30:19', NULL, NULL, NULL, '新河县', '河北省邢台市新河县', '3', 13, 'X', NULL, '1', '055650', '130500');
INSERT INTO `sys_region` VALUES ('130531', '2018-01-30 19:30:19', NULL, NULL, NULL, '广宗县', '河北省邢台市广宗县', '3', 14, 'G', NULL, '1', '054600', '130500');
INSERT INTO `sys_region` VALUES ('130532', '2018-01-30 19:30:19', NULL, NULL, NULL, '平乡县', '河北省邢台市平乡县', '3', 15, 'P', NULL, '1', '054500', '130500');
INSERT INTO `sys_region` VALUES ('130533', '2018-01-30 19:30:19', NULL, NULL, NULL, '威县', '河北省邢台市威县', '3', 16, 'W', NULL, '1', '054700', '130500');
INSERT INTO `sys_region` VALUES ('130534', '2018-01-30 19:30:19', NULL, NULL, NULL, '清河县', '河北省邢台市清河县', '3', 17, 'Q', NULL, '1', '054800', '130500');
INSERT INTO `sys_region` VALUES ('130535', '2018-01-30 19:30:19', NULL, NULL, NULL, '临西县', '河北省邢台市临西县', '3', 18, 'L', NULL, '1', '054900', '130500');
INSERT INTO `sys_region` VALUES ('130581', '2018-01-30 19:30:19', NULL, NULL, NULL, '南宫市', '河北省邢台市南宫市', '3', 19, 'N', NULL, '1', '055750', '130500');
INSERT INTO `sys_region` VALUES ('130582', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙河市', '河北省邢台市沙河市', '3', 20, 'S', NULL, '1', '054100', '130500');
INSERT INTO `sys_region` VALUES ('130600', '2018-01-30 19:30:19', NULL, NULL, NULL, '保定市', '河北省保定市', '2', 6, 'B', NULL, '1', '071052', '130000');
INSERT INTO `sys_region` VALUES ('130601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省保定市市辖区', '3', 1, 'S', NULL, '1', NULL, '130600');
INSERT INTO `sys_region` VALUES ('130602', '2018-01-30 19:30:19', NULL, NULL, NULL, '竞秀区', '河北省保定市竞秀区', '3', 2, 'J', NULL, '1', '071051', '130600');
INSERT INTO `sys_region` VALUES ('130606', '2018-01-30 19:30:19', NULL, NULL, NULL, '莲池区', '河北省保定市莲池区', '3', 3, 'L', NULL, '1', NULL, '130600');
INSERT INTO `sys_region` VALUES ('130607', '2018-01-30 19:30:19', NULL, NULL, NULL, '满城区', '河北省保定市满城区', '3', 4, 'M', NULL, '1', NULL, '130600');
INSERT INTO `sys_region` VALUES ('130608', '2018-01-30 19:30:19', NULL, NULL, NULL, '清苑区', '河北省保定市清苑区', '3', 5, 'Q', NULL, '1', NULL, '130600');
INSERT INTO `sys_region` VALUES ('130609', '2018-01-30 19:30:19', NULL, NULL, NULL, '徐水区', '河北省保定市徐水区', '3', 6, 'X', NULL, '1', NULL, '130600');
INSERT INTO `sys_region` VALUES ('130623', '2018-01-30 19:30:19', NULL, NULL, NULL, '涞水县', '河北省保定市涞水县', '3', 7, 'Z', NULL, '1', '074100', '130600');
INSERT INTO `sys_region` VALUES ('130624', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜平县', '河北省保定市阜平县', '3', 8, 'F', NULL, '1', '073200', '130600');
INSERT INTO `sys_region` VALUES ('130626', '2018-01-30 19:30:19', NULL, NULL, NULL, '定兴县', '河北省保定市定兴县', '3', 9, 'D', NULL, '1', '072650', '130600');
INSERT INTO `sys_region` VALUES ('130627', '2018-01-30 19:30:19', NULL, NULL, NULL, '唐县', '河北省保定市唐县', '3', 10, 'T', NULL, '1', '072350', '130600');
INSERT INTO `sys_region` VALUES ('130628', '2018-01-30 19:30:19', NULL, NULL, NULL, '高阳县', '河北省保定市高阳县', '3', 11, 'G', NULL, '1', '071500', '130600');
INSERT INTO `sys_region` VALUES ('130629', '2018-01-30 19:30:19', NULL, NULL, NULL, '容城县', '河北省保定市容城县', '3', 12, 'R', NULL, '1', '071700', '130600');
INSERT INTO `sys_region` VALUES ('130630', '2018-01-30 19:30:19', NULL, NULL, NULL, '涞源县', '河北省保定市涞源县', '3', 13, 'Z', NULL, '1', '074300', '130600');
INSERT INTO `sys_region` VALUES ('130631', '2018-01-30 19:30:19', NULL, NULL, NULL, '望都县', '河北省保定市望都县', '3', 14, 'W', NULL, '1', '072450', '130600');
INSERT INTO `sys_region` VALUES ('130632', '2018-01-30 19:30:19', NULL, NULL, NULL, '安新县', '河北省保定市安新县', '3', 15, 'A', NULL, '1', '071600', '130600');
INSERT INTO `sys_region` VALUES ('130633', '2018-01-30 19:30:19', NULL, NULL, NULL, '易县', '河北省保定市易县', '3', 16, 'Y', NULL, '1', '074200', '130600');
INSERT INTO `sys_region` VALUES ('130634', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲阳县', '河北省保定市曲阳县', '3', 17, 'Q', NULL, '1', '073100', '130600');
INSERT INTO `sys_region` VALUES ('130635', '2018-01-30 19:30:19', NULL, NULL, NULL, '蠡县', '河北省保定市蠡县', '3', 18, 'Z', NULL, '1', '071400', '130600');
INSERT INTO `sys_region` VALUES ('130636', '2018-01-30 19:30:19', NULL, NULL, NULL, '顺平县', '河北省保定市顺平县', '3', 19, 'S', NULL, '1', '072250', '130600');
INSERT INTO `sys_region` VALUES ('130637', '2018-01-30 19:30:19', NULL, NULL, NULL, '博野县', '河北省保定市博野县', '3', 20, 'B', NULL, '1', '071300', '130600');
INSERT INTO `sys_region` VALUES ('130638', '2018-01-30 19:30:19', NULL, NULL, NULL, '雄县', '河北省保定市雄县', '3', 21, 'X', NULL, '1', '071800', '130600');
INSERT INTO `sys_region` VALUES ('130681', '2018-01-30 19:30:19', NULL, NULL, NULL, '涿州市', '河北省保定市涿州市', '3', 22, 'Z', NULL, '1', '072750', '130600');
INSERT INTO `sys_region` VALUES ('130683', '2018-01-30 19:30:19', NULL, NULL, NULL, '安国市', '河北省保定市安国市', '3', 23, 'A', NULL, '1', '071200', '130600');
INSERT INTO `sys_region` VALUES ('130684', '2018-01-30 19:30:19', NULL, NULL, NULL, '高碑店市', '河北省保定市高碑店市', '3', 24, 'G', NULL, '1', '074000', '130600');
INSERT INTO `sys_region` VALUES ('130700', '2018-01-30 19:30:19', NULL, NULL, NULL, '张家口市', '河北省张家口市', '2', 7, 'Z', NULL, '1', '075000', '130000');
INSERT INTO `sys_region` VALUES ('130701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省张家口市市辖区', '3', 1, 'S', NULL, '1', NULL, '130700');
INSERT INTO `sys_region` VALUES ('130702', '2018-01-30 19:30:19', NULL, NULL, NULL, '桥东区', '河北省张家口市桥东区', '3', 2, 'Q', NULL, '1', '075000', '130700');
INSERT INTO `sys_region` VALUES ('130703', '2018-01-30 19:30:19', NULL, NULL, NULL, '桥西区', '河北省张家口市桥西区', '3', 3, 'Q', NULL, '1', '075061', '130700');
INSERT INTO `sys_region` VALUES ('130705', '2018-01-30 19:30:19', NULL, NULL, NULL, '宣化区', '河北省张家口市宣化区', '3', 4, 'X', NULL, '1', '075100', '130700');
INSERT INTO `sys_region` VALUES ('130706', '2018-01-30 19:30:19', NULL, NULL, NULL, '下花园区', '河北省张家口市下花园区', '3', 5, 'X', NULL, '1', '075300', '130700');
INSERT INTO `sys_region` VALUES ('130708', '2018-01-30 19:30:19', NULL, NULL, NULL, '万全区', '河北省张家口市万全区', '3', 6, 'W', NULL, '1', NULL, '130700');
INSERT INTO `sys_region` VALUES ('130709', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇礼区', '河北省张家口市崇礼区', '3', 7, 'C', NULL, '1', NULL, '130700');
INSERT INTO `sys_region` VALUES ('130722', '2018-01-30 19:30:19', NULL, NULL, NULL, '张北县', '河北省张家口市张北县', '3', 8, 'Z', NULL, '1', '076450', '130700');
INSERT INTO `sys_region` VALUES ('130723', '2018-01-30 19:30:19', NULL, NULL, NULL, '康保县', '河北省张家口市康保县', '3', 9, 'K', NULL, '1', '076650', '130700');
INSERT INTO `sys_region` VALUES ('130724', '2018-01-30 19:30:19', NULL, NULL, NULL, '沽源县', '河北省张家口市沽源县', '3', 10, 'G', NULL, '1', '076550', '130700');
INSERT INTO `sys_region` VALUES ('130725', '2018-01-30 19:30:19', NULL, NULL, NULL, '尚义县', '河北省张家口市尚义县', '3', 11, 'S', NULL, '1', '076750', '130700');
INSERT INTO `sys_region` VALUES ('130726', '2018-01-30 19:30:19', NULL, NULL, NULL, '蔚县', '河北省张家口市蔚县', '3', 12, 'W', NULL, '1', '075700', '130700');
INSERT INTO `sys_region` VALUES ('130727', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳原县', '河北省张家口市阳原县', '3', 13, 'Y', NULL, '1', '075800', '130700');
INSERT INTO `sys_region` VALUES ('130728', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀安县', '河北省张家口市怀安县', '3', 14, 'H', NULL, '1', '076150', '130700');
INSERT INTO `sys_region` VALUES ('130730', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀来县', '河北省张家口市怀来县', '3', 15, 'H', NULL, '1', '075400', '130700');
INSERT INTO `sys_region` VALUES ('130731', '2018-01-30 19:30:19', NULL, NULL, NULL, '涿鹿县', '河北省张家口市涿鹿县', '3', 16, 'Z', NULL, '1', '075600', '130700');
INSERT INTO `sys_region` VALUES ('130732', '2018-01-30 19:30:19', NULL, NULL, NULL, '赤城县', '河北省张家口市赤城县', '3', 17, 'C', NULL, '1', '075500', '130700');
INSERT INTO `sys_region` VALUES ('130800', '2018-01-30 19:30:19', NULL, NULL, NULL, '承德市', '河北省承德市', '2', 8, 'C', NULL, '1', '067000', '130000');
INSERT INTO `sys_region` VALUES ('130801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省承德市市辖区', '3', 1, 'S', NULL, '1', NULL, '130800');
INSERT INTO `sys_region` VALUES ('130802', '2018-01-30 19:30:19', NULL, NULL, NULL, '双桥区', '河北省承德市双桥区', '3', 2, 'S', NULL, '1', '067000', '130800');
INSERT INTO `sys_region` VALUES ('130803', '2018-01-30 19:30:19', NULL, NULL, NULL, '双滦区', '河北省承德市双滦区', '3', 3, 'S', NULL, '1', '067001', '130800');
INSERT INTO `sys_region` VALUES ('130804', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹰手营子矿区', '河北省承德市鹰手营子矿区', '3', 4, 'Y', NULL, '1', '067200', '130800');
INSERT INTO `sys_region` VALUES ('130821', '2018-01-30 19:30:19', NULL, NULL, NULL, '承德县', '河北省承德市承德县', '3', 5, 'C', NULL, '1', '067400', '130800');
INSERT INTO `sys_region` VALUES ('130822', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴隆县', '河北省承德市兴隆县', '3', 6, 'X', NULL, '1', '067300', '130800');
INSERT INTO `sys_region` VALUES ('130823', '2018-01-30 19:30:19', NULL, NULL, NULL, '平泉县', '河北省承德市平泉县', '3', 7, 'P', NULL, '1', '067500', '130800');
INSERT INTO `sys_region` VALUES ('130824', '2018-01-30 19:30:19', NULL, NULL, NULL, '滦平县', '河北省承德市滦平县', '3', 8, 'L', NULL, '1', '068250', '130800');
INSERT INTO `sys_region` VALUES ('130825', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆化县', '河北省承德市隆化县', '3', 9, 'L', NULL, '1', '068150', '130800');
INSERT INTO `sys_region` VALUES ('130826', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰宁满族自治县', '河北省承德市丰宁满族自治县', '3', 10, 'F', NULL, '1', '068350', '130800');
INSERT INTO `sys_region` VALUES ('130827', '2018-01-30 19:30:19', NULL, NULL, NULL, '宽城满族自治县', '河北省承德市宽城满族自治县', '3', 11, 'K', NULL, '1', '067600', '130800');
INSERT INTO `sys_region` VALUES ('130828', '2018-01-30 19:30:19', NULL, NULL, NULL, '围场满族蒙古族自治县', '河北省承德市围场满族蒙古族自治县', '3', 12, 'W', NULL, '1', '068450', '130800');
INSERT INTO `sys_region` VALUES ('130900', '2018-01-30 19:30:19', NULL, NULL, NULL, '沧州市', '河北省沧州市', '2', 9, 'C', NULL, '1', '061001', '130000');
INSERT INTO `sys_region` VALUES ('130901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省沧州市市辖区', '3', 1, 'S', NULL, '1', NULL, '130900');
INSERT INTO `sys_region` VALUES ('130902', '2018-01-30 19:30:19', NULL, NULL, NULL, '新华区', '河北省沧州市新华区', '3', 2, 'X', NULL, '1', '061000', '130900');
INSERT INTO `sys_region` VALUES ('130903', '2018-01-30 19:30:19', NULL, NULL, NULL, '运河区', '河北省沧州市运河区', '3', 3, 'Y', NULL, '1', '061001', '130900');
INSERT INTO `sys_region` VALUES ('130921', '2018-01-30 19:30:19', NULL, NULL, NULL, '沧县', '河北省沧州市沧县', '3', 4, 'C', NULL, '1', '061000', '130900');
INSERT INTO `sys_region` VALUES ('130922', '2018-01-30 19:30:19', NULL, NULL, NULL, '青县', '河北省沧州市青县', '3', 5, 'Q', NULL, '1', '062650', '130900');
INSERT INTO `sys_region` VALUES ('130923', '2018-01-30 19:30:19', NULL, NULL, NULL, '东光县', '河北省沧州市东光县', '3', 6, 'D', NULL, '1', '061600', '130900');
INSERT INTO `sys_region` VALUES ('130924', '2018-01-30 19:30:19', NULL, NULL, NULL, '海兴县', '河北省沧州市海兴县', '3', 7, 'H', NULL, '1', '061200', '130900');
INSERT INTO `sys_region` VALUES ('130925', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐山县', '河北省沧州市盐山县', '3', 8, 'Y', NULL, '1', '061300', '130900');
INSERT INTO `sys_region` VALUES ('130926', '2018-01-30 19:30:19', NULL, NULL, NULL, '肃宁县', '河北省沧州市肃宁县', '3', 9, 'S', NULL, '1', '062350', '130900');
INSERT INTO `sys_region` VALUES ('130927', '2018-01-30 19:30:19', NULL, NULL, NULL, '南皮县', '河北省沧州市南皮县', '3', 10, 'N', NULL, '1', '061500', '130900');
INSERT INTO `sys_region` VALUES ('130928', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴桥县', '河北省沧州市吴桥县', '3', 11, 'W', NULL, '1', '061800', '130900');
INSERT INTO `sys_region` VALUES ('130929', '2018-01-30 19:30:19', NULL, NULL, NULL, '献县', '河北省沧州市献县', '3', 12, 'X', NULL, '1', '062250', '130900');
INSERT INTO `sys_region` VALUES ('130930', '2018-01-30 19:30:19', NULL, NULL, NULL, '孟村回族自治县', '河北省沧州市孟村回族自治县', '3', 13, 'M', NULL, '1', '061400', '130900');
INSERT INTO `sys_region` VALUES ('130981', '2018-01-30 19:30:19', NULL, NULL, NULL, '泊头市', '河北省沧州市泊头市', '3', 14, 'B', NULL, '1', '062150', '130900');
INSERT INTO `sys_region` VALUES ('130982', '2018-01-30 19:30:19', NULL, NULL, NULL, '任丘市', '河北省沧州市任丘市', '3', 15, 'R', NULL, '1', '062550', '130900');
INSERT INTO `sys_region` VALUES ('130983', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄骅市', '河北省沧州市黄骅市', '3', 16, 'H', NULL, '1', '061100', '130900');
INSERT INTO `sys_region` VALUES ('130984', '2018-01-30 19:30:19', NULL, NULL, NULL, '河间市', '河北省沧州市河间市', '3', 17, 'H', NULL, '1', '062450', '130900');
INSERT INTO `sys_region` VALUES ('131000', '2018-01-30 19:30:19', NULL, NULL, NULL, '廊坊市', '河北省廊坊市', '2', 10, 'L', NULL, '1', '065000', '130000');
INSERT INTO `sys_region` VALUES ('131001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省廊坊市市辖区', '3', 1, 'S', NULL, '1', NULL, '131000');
INSERT INTO `sys_region` VALUES ('131002', '2018-01-30 19:30:19', NULL, NULL, NULL, '安次区', '河北省廊坊市安次区', '3', 2, 'A', NULL, '1', '065000', '131000');
INSERT INTO `sys_region` VALUES ('131003', '2018-01-30 19:30:19', NULL, NULL, NULL, '广阳区', '河北省廊坊市广阳区', '3', 3, 'G', NULL, '1', '065000', '131000');
INSERT INTO `sys_region` VALUES ('131022', '2018-01-30 19:30:19', NULL, NULL, NULL, '固安县', '河北省廊坊市固安县', '3', 4, 'G', NULL, '1', '065500', '131000');
INSERT INTO `sys_region` VALUES ('131023', '2018-01-30 19:30:19', NULL, NULL, NULL, '永清县', '河北省廊坊市永清县', '3', 5, 'Y', NULL, '1', '065600', '131000');
INSERT INTO `sys_region` VALUES ('131024', '2018-01-30 19:30:19', NULL, NULL, NULL, '香河县', '河北省廊坊市香河县', '3', 6, 'X', NULL, '1', '065400', '131000');
INSERT INTO `sys_region` VALUES ('131025', '2018-01-30 19:30:19', NULL, NULL, NULL, '大城县', '河北省廊坊市大城县', '3', 7, 'D', NULL, '1', '065900', '131000');
INSERT INTO `sys_region` VALUES ('131026', '2018-01-30 19:30:19', NULL, NULL, NULL, '文安县', '河北省廊坊市文安县', '3', 8, 'W', NULL, '1', '065800', '131000');
INSERT INTO `sys_region` VALUES ('131028', '2018-01-30 19:30:19', NULL, NULL, NULL, '大厂回族自治县', '河北省廊坊市大厂回族自治县', '3', 9, 'D', NULL, '1', '065300', '131000');
INSERT INTO `sys_region` VALUES ('131081', '2018-01-30 19:30:19', NULL, NULL, NULL, '霸州市', '河北省廊坊市霸州市', '3', 10, 'B', NULL, '1', '065700', '131000');
INSERT INTO `sys_region` VALUES ('131082', '2018-01-30 19:30:19', NULL, NULL, NULL, '三河市', '河北省廊坊市三河市', '3', 11, 'S', NULL, '1', '065200', '131000');
INSERT INTO `sys_region` VALUES ('131100', '2018-01-30 19:30:19', NULL, NULL, NULL, '衡水市', '河北省衡水市', '2', 11, 'H', NULL, '1', '053000', '130000');
INSERT INTO `sys_region` VALUES ('131101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河北省衡水市市辖区', '3', 1, 'S', NULL, '1', NULL, '131100');
INSERT INTO `sys_region` VALUES ('131102', '2018-01-30 19:30:19', NULL, NULL, NULL, '桃城区', '河北省衡水市桃城区', '3', 2, 'T', NULL, '1', '053000', '131100');
INSERT INTO `sys_region` VALUES ('131103', '2018-01-30 19:30:19', NULL, NULL, NULL, '冀州区', '河北省衡水市冀州区', '3', 3, 'J', NULL, '1', NULL, '131100');
INSERT INTO `sys_region` VALUES ('131121', '2018-01-30 19:30:19', NULL, NULL, NULL, '枣强县', '河北省衡水市枣强县', '3', 4, 'Z', NULL, '1', '053100', '131100');
INSERT INTO `sys_region` VALUES ('131122', '2018-01-30 19:30:19', NULL, NULL, NULL, '武邑县', '河北省衡水市武邑县', '3', 5, 'W', NULL, '1', '053400', '131100');
INSERT INTO `sys_region` VALUES ('131123', '2018-01-30 19:30:19', NULL, NULL, NULL, '武强县', '河北省衡水市武强县', '3', 6, 'W', NULL, '1', '053300', '131100');
INSERT INTO `sys_region` VALUES ('131124', '2018-01-30 19:30:19', NULL, NULL, NULL, '饶阳县', '河北省衡水市饶阳县', '3', 7, 'R', NULL, '1', '053900', '131100');
INSERT INTO `sys_region` VALUES ('131125', '2018-01-30 19:30:19', NULL, NULL, NULL, '安平县', '河北省衡水市安平县', '3', 8, 'A', NULL, '1', '053600', '131100');
INSERT INTO `sys_region` VALUES ('131126', '2018-01-30 19:30:19', NULL, NULL, NULL, '故城县', '河北省衡水市故城县', '3', 9, 'G', NULL, '1', '053800', '131100');
INSERT INTO `sys_region` VALUES ('131127', '2018-01-30 19:30:19', NULL, NULL, NULL, '景县', '河北省衡水市景县', '3', 10, 'J', NULL, '1', '053500', '131100');
INSERT INTO `sys_region` VALUES ('131128', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜城县', '河北省衡水市阜城县', '3', 11, 'F', NULL, '1', '053700', '131100');
INSERT INTO `sys_region` VALUES ('131182', '2018-01-30 19:30:19', NULL, NULL, NULL, '深州市', '河北省衡水市深州市', '3', 12, 'S', NULL, '1', '053800', '131100');
INSERT INTO `sys_region` VALUES ('139000', '2018-01-30 19:30:19', NULL, NULL, NULL, '省直辖县级行政区划', '河北省省直辖县级行政区划', '2', 12, 'S', NULL, '1', NULL, '130000');
INSERT INTO `sys_region` VALUES ('139001', '2018-01-30 19:30:19', NULL, NULL, NULL, '定州市', '河北省省直辖县级行政区划定州市', '3', 1, 'D', NULL, '1', NULL, '139000');
INSERT INTO `sys_region` VALUES ('139002', '2018-01-30 19:30:19', NULL, NULL, NULL, '辛集市', '河北省省直辖县级行政区划辛集市', '3', 2, 'X', NULL, '1', NULL, '139000');
INSERT INTO `sys_region` VALUES ('140000', '2018-01-30 19:30:19', NULL, NULL, NULL, '山西省', '山西省', '1', 4, 'S', NULL, '0', '', '100000');
INSERT INTO `sys_region` VALUES ('140100', '2018-01-30 19:30:19', NULL, NULL, NULL, '太原市', '山西省太原市', '2', 1, 'T', NULL, '1', '030082', '140000');
INSERT INTO `sys_region` VALUES ('140101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省太原市市辖区', '3', 1, 'S', NULL, '1', NULL, '140100');
INSERT INTO `sys_region` VALUES ('140105', '2018-01-30 19:30:19', NULL, NULL, NULL, '小店区', '山西省太原市小店区', '3', 2, 'X', NULL, '1', '030032', '140100');
INSERT INTO `sys_region` VALUES ('140106', '2018-01-30 19:30:19', NULL, NULL, NULL, '迎泽区', '山西省太原市迎泽区', '3', 3, 'Y', NULL, '1', '030002', '140100');
INSERT INTO `sys_region` VALUES ('140107', '2018-01-30 19:30:19', NULL, NULL, NULL, '杏花岭区', '山西省太原市杏花岭区', '3', 4, 'X', NULL, '1', '030009', '140100');
INSERT INTO `sys_region` VALUES ('140108', '2018-01-30 19:30:19', NULL, NULL, NULL, '尖草坪区', '山西省太原市尖草坪区', '3', 5, 'J', NULL, '1', '030023', '140100');
INSERT INTO `sys_region` VALUES ('140109', '2018-01-30 19:30:19', NULL, NULL, NULL, '万柏林区', '山西省太原市万柏林区', '3', 6, 'W', NULL, '1', '030024', '140100');
INSERT INTO `sys_region` VALUES ('140110', '2018-01-30 19:30:19', NULL, NULL, NULL, '晋源区', '山西省太原市晋源区', '3', 7, 'J', NULL, '1', '030025', '140100');
INSERT INTO `sys_region` VALUES ('140121', '2018-01-30 19:30:19', NULL, NULL, NULL, '清徐县', '山西省太原市清徐县', '3', 8, 'Q', NULL, '1', '030400', '140100');
INSERT INTO `sys_region` VALUES ('140122', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳曲县', '山西省太原市阳曲县', '3', 9, 'Y', NULL, '1', '030100', '140100');
INSERT INTO `sys_region` VALUES ('140123', '2018-01-30 19:30:19', NULL, NULL, NULL, '娄烦县', '山西省太原市娄烦县', '3', 10, 'L', NULL, '1', '030300', '140100');
INSERT INTO `sys_region` VALUES ('140181', '2018-01-30 19:30:19', NULL, NULL, NULL, '古交市', '山西省太原市古交市', '3', 11, 'G', NULL, '1', '030200', '140100');
INSERT INTO `sys_region` VALUES ('140200', '2018-01-30 19:30:19', NULL, NULL, NULL, '大同市', '山西省大同市', '2', 2, 'D', NULL, '1', '037008', '140000');
INSERT INTO `sys_region` VALUES ('140201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省大同市市辖区', '3', 1, 'S', NULL, '1', NULL, '140200');
INSERT INTO `sys_region` VALUES ('140202', '2018-01-30 19:30:19', NULL, NULL, NULL, '城区', '山西省大同市城区', '3', 2, 'C', NULL, '1', '037008', '140200');
INSERT INTO `sys_region` VALUES ('140203', '2018-01-30 19:30:19', NULL, NULL, NULL, '矿区', '山西省大同市矿区', '3', 3, 'K', NULL, '1', '037003', '140200');
INSERT INTO `sys_region` VALUES ('140211', '2018-01-30 19:30:19', NULL, NULL, NULL, '南郊区', '山西省大同市南郊区', '3', 4, 'N', NULL, '1', '037001', '140200');
INSERT INTO `sys_region` VALUES ('140212', '2018-01-30 19:30:19', NULL, NULL, NULL, '新荣区', '山西省大同市新荣区', '3', 5, 'X', NULL, '1', '037002', '140200');
INSERT INTO `sys_region` VALUES ('140221', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳高县', '山西省大同市阳高县', '3', 6, 'Y', NULL, '1', '038100', '140200');
INSERT INTO `sys_region` VALUES ('140222', '2018-01-30 19:30:19', NULL, NULL, NULL, '天镇县', '山西省大同市天镇县', '3', 7, 'T', NULL, '1', '038200', '140200');
INSERT INTO `sys_region` VALUES ('140223', '2018-01-30 19:30:19', NULL, NULL, NULL, '广灵县', '山西省大同市广灵县', '3', 8, 'G', NULL, '1', '037500', '140200');
INSERT INTO `sys_region` VALUES ('140224', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵丘县', '山西省大同市灵丘县', '3', 9, 'L', NULL, '1', '034400', '140200');
INSERT INTO `sys_region` VALUES ('140225', '2018-01-30 19:30:19', NULL, NULL, NULL, '浑源县', '山西省大同市浑源县', '3', 10, 'H', NULL, '1', '037400', '140200');
INSERT INTO `sys_region` VALUES ('140226', '2018-01-30 19:30:19', NULL, NULL, NULL, '左云县', '山西省大同市左云县', '3', 11, 'Z', NULL, '1', '037100', '140200');
INSERT INTO `sys_region` VALUES ('140227', '2018-01-30 19:30:19', NULL, NULL, NULL, '大同县', '山西省大同市大同县', '3', 12, 'D', NULL, '1', '037300', '140200');
INSERT INTO `sys_region` VALUES ('140300', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳泉市', '山西省阳泉市', '2', 3, 'Y', NULL, '1', '045000', '140000');
INSERT INTO `sys_region` VALUES ('140301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省阳泉市市辖区', '3', 1, 'S', NULL, '1', NULL, '140300');
INSERT INTO `sys_region` VALUES ('140302', '2018-01-30 19:30:19', NULL, NULL, NULL, '城区', '山西省阳泉市城区', '3', 2, 'C', NULL, '1', '045000', '140300');
INSERT INTO `sys_region` VALUES ('140303', '2018-01-30 19:30:19', NULL, NULL, NULL, '矿区', '山西省阳泉市矿区', '3', 3, 'K', NULL, '1', '045000', '140300');
INSERT INTO `sys_region` VALUES ('140311', '2018-01-30 19:30:19', NULL, NULL, NULL, '郊区', '山西省阳泉市郊区', '3', 4, 'J', NULL, '1', '045011', '140300');
INSERT INTO `sys_region` VALUES ('140321', '2018-01-30 19:30:19', NULL, NULL, NULL, '平定县', '山西省阳泉市平定县', '3', 5, 'P', NULL, '1', '045200', '140300');
INSERT INTO `sys_region` VALUES ('140322', '2018-01-30 19:30:19', NULL, NULL, NULL, '盂县', '山西省阳泉市盂县', '3', 6, 'Y', NULL, '1', '045100', '140300');
INSERT INTO `sys_region` VALUES ('140400', '2018-01-30 19:30:19', NULL, NULL, NULL, '长治市', '山西省长治市', '2', 4, 'C', NULL, '1', '046000', '140000');
INSERT INTO `sys_region` VALUES ('140401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省长治市市辖区', '3', 1, 'S', NULL, '1', NULL, '140400');
INSERT INTO `sys_region` VALUES ('140402', '2018-01-30 19:30:19', NULL, NULL, NULL, '城区', '山西省长治市城区', '3', 2, 'C', NULL, '1', '046011', '140400');
INSERT INTO `sys_region` VALUES ('140411', '2018-01-30 19:30:19', NULL, NULL, NULL, '郊区', '山西省长治市郊区', '3', 3, 'J', NULL, '1', '046011', '140400');
INSERT INTO `sys_region` VALUES ('140421', '2018-01-30 19:30:19', NULL, NULL, NULL, '长治县', '山西省长治市长治县', '3', 4, 'C', NULL, '1', '047100', '140400');
INSERT INTO `sys_region` VALUES ('140423', '2018-01-30 19:30:19', NULL, NULL, NULL, '襄垣县', '山西省长治市襄垣县', '3', 5, 'X', NULL, '1', '046200', '140400');
INSERT INTO `sys_region` VALUES ('140424', '2018-01-30 19:30:19', NULL, NULL, NULL, '屯留县', '山西省长治市屯留县', '3', 6, 'T', NULL, '1', '046100', '140400');
INSERT INTO `sys_region` VALUES ('140425', '2018-01-30 19:30:19', NULL, NULL, NULL, '平顺县', '山西省长治市平顺县', '3', 7, 'P', NULL, '1', '047400', '140400');
INSERT INTO `sys_region` VALUES ('140426', '2018-01-30 19:30:19', NULL, NULL, NULL, '黎城县', '山西省长治市黎城县', '3', 8, 'L', NULL, '1', '047600', '140400');
INSERT INTO `sys_region` VALUES ('140427', '2018-01-30 19:30:19', NULL, NULL, NULL, '壶关县', '山西省长治市壶关县', '3', 9, 'H', NULL, '1', '047300', '140400');
INSERT INTO `sys_region` VALUES ('140428', '2018-01-30 19:30:19', NULL, NULL, NULL, '长子县', '山西省长治市长子县', '3', 10, 'C', NULL, '1', '046600', '140400');
INSERT INTO `sys_region` VALUES ('140429', '2018-01-30 19:30:19', NULL, NULL, NULL, '武乡县', '山西省长治市武乡县', '3', 11, 'W', NULL, '1', '046300', '140400');
INSERT INTO `sys_region` VALUES ('140430', '2018-01-30 19:30:19', NULL, NULL, NULL, '沁县', '山西省长治市沁县', '3', 12, 'Q', NULL, '1', '046400', '140400');
INSERT INTO `sys_region` VALUES ('140431', '2018-01-30 19:30:19', NULL, NULL, NULL, '沁源县', '山西省长治市沁源县', '3', 13, 'Q', NULL, '1', '046500', '140400');
INSERT INTO `sys_region` VALUES ('140481', '2018-01-30 19:30:19', NULL, NULL, NULL, '潞城市', '山西省长治市潞城市', '3', 14, 'L', NULL, '1', '047500', '140400');
INSERT INTO `sys_region` VALUES ('140500', '2018-01-30 19:30:19', NULL, NULL, NULL, '晋城市', '山西省晋城市', '2', 5, 'J', NULL, '1', '048000', '140000');
INSERT INTO `sys_region` VALUES ('140501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省晋城市市辖区', '3', 1, 'S', NULL, '1', NULL, '140500');
INSERT INTO `sys_region` VALUES ('140502', '2018-01-30 19:30:19', NULL, NULL, NULL, '城区', '山西省晋城市城区', '3', 2, 'C', NULL, '1', '048000', '140500');
INSERT INTO `sys_region` VALUES ('140521', '2018-01-30 19:30:19', NULL, NULL, NULL, '沁水县', '山西省晋城市沁水县', '3', 3, 'Q', NULL, '1', '048200', '140500');
INSERT INTO `sys_region` VALUES ('140522', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳城县', '山西省晋城市阳城县', '3', 4, 'Y', NULL, '1', '048100', '140500');
INSERT INTO `sys_region` VALUES ('140524', '2018-01-30 19:30:19', NULL, NULL, NULL, '陵川县', '山西省晋城市陵川县', '3', 5, 'L', NULL, '1', '048300', '140500');
INSERT INTO `sys_region` VALUES ('140525', '2018-01-30 19:30:19', NULL, NULL, NULL, '泽州县', '山西省晋城市泽州县', '3', 6, 'Z', NULL, '1', '048012', '140500');
INSERT INTO `sys_region` VALUES ('140581', '2018-01-30 19:30:19', NULL, NULL, NULL, '高平市', '山西省晋城市高平市', '3', 7, 'G', NULL, '1', '048400', '140500');
INSERT INTO `sys_region` VALUES ('140600', '2018-01-30 19:30:19', NULL, NULL, NULL, '朔州市', '山西省朔州市', '2', 6, 'S', NULL, '1', '038500', '140000');
INSERT INTO `sys_region` VALUES ('140601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省朔州市市辖区', '3', 1, 'S', NULL, '1', NULL, '140600');
INSERT INTO `sys_region` VALUES ('140602', '2018-01-30 19:30:19', NULL, NULL, NULL, '朔城区', '山西省朔州市朔城区', '3', 2, 'S', NULL, '1', '036000', '140600');
INSERT INTO `sys_region` VALUES ('140603', '2018-01-30 19:30:19', NULL, NULL, NULL, '平鲁区', '山西省朔州市平鲁区', '3', 3, 'P', NULL, '1', '038600', '140600');
INSERT INTO `sys_region` VALUES ('140621', '2018-01-30 19:30:19', NULL, NULL, NULL, '山阴县', '山西省朔州市山阴县', '3', 4, 'S', NULL, '1', '036900', '140600');
INSERT INTO `sys_region` VALUES ('140622', '2018-01-30 19:30:19', NULL, NULL, NULL, '应县', '山西省朔州市应县', '3', 5, 'Y', NULL, '1', '037600', '140600');
INSERT INTO `sys_region` VALUES ('140623', '2018-01-30 19:30:19', NULL, NULL, NULL, '右玉县', '山西省朔州市右玉县', '3', 6, 'Y', NULL, '1', '037200', '140600');
INSERT INTO `sys_region` VALUES ('140624', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀仁县', '山西省朔州市怀仁县', '3', 7, 'H', NULL, '1', '038300', '140600');
INSERT INTO `sys_region` VALUES ('140700', '2018-01-30 19:30:19', NULL, NULL, NULL, '晋中市', '山西省晋中市', '2', 7, 'J', NULL, '1', '030600', '140000');
INSERT INTO `sys_region` VALUES ('140701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省晋中市市辖区', '3', 1, 'S', NULL, '1', NULL, '140700');
INSERT INTO `sys_region` VALUES ('140702', '2018-01-30 19:30:19', NULL, NULL, NULL, '榆次区', '山西省晋中市榆次区', '3', 2, 'Y', NULL, '1', '030600', '140700');
INSERT INTO `sys_region` VALUES ('140721', '2018-01-30 19:30:19', NULL, NULL, NULL, '榆社县', '山西省晋中市榆社县', '3', 3, 'Y', NULL, '1', '031800', '140700');
INSERT INTO `sys_region` VALUES ('140722', '2018-01-30 19:30:19', NULL, NULL, NULL, '左权县', '山西省晋中市左权县', '3', 4, 'Z', NULL, '1', '032600', '140700');
INSERT INTO `sys_region` VALUES ('140723', '2018-01-30 19:30:19', NULL, NULL, NULL, '和顺县', '山西省晋中市和顺县', '3', 5, 'H', NULL, '1', '032700', '140700');
INSERT INTO `sys_region` VALUES ('140724', '2018-01-30 19:30:19', NULL, NULL, NULL, '昔阳县', '山西省晋中市昔阳县', '3', 6, 'X', NULL, '1', '045300', '140700');
INSERT INTO `sys_region` VALUES ('140725', '2018-01-30 19:30:19', NULL, NULL, NULL, '寿阳县', '山西省晋中市寿阳县', '3', 7, 'S', NULL, '1', '045400', '140700');
INSERT INTO `sys_region` VALUES ('140726', '2018-01-30 19:30:19', NULL, NULL, NULL, '太谷县', '山西省晋中市太谷县', '3', 8, 'T', NULL, '1', '030800', '140700');
INSERT INTO `sys_region` VALUES ('140727', '2018-01-30 19:30:19', NULL, NULL, NULL, '祁县', '山西省晋中市祁县', '3', 9, 'Q', NULL, '1', '030900', '140700');
INSERT INTO `sys_region` VALUES ('140728', '2018-01-30 19:30:19', NULL, NULL, NULL, '平遥县', '山西省晋中市平遥县', '3', 10, 'P', NULL, '1', '031100', '140700');
INSERT INTO `sys_region` VALUES ('140729', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵石县', '山西省晋中市灵石县', '3', 11, 'L', NULL, '1', '031300', '140700');
INSERT INTO `sys_region` VALUES ('140781', '2018-01-30 19:30:19', NULL, NULL, NULL, '介休市', '山西省晋中市介休市', '3', 12, 'J', NULL, '1', '032000', '140700');
INSERT INTO `sys_region` VALUES ('140800', '2018-01-30 19:30:19', NULL, NULL, NULL, '运城市', '山西省运城市', '2', 8, 'Y', NULL, '1', '044000', '140000');
INSERT INTO `sys_region` VALUES ('140801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省运城市市辖区', '3', 1, 'S', NULL, '1', NULL, '140800');
INSERT INTO `sys_region` VALUES ('140802', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐湖区', '山西省运城市盐湖区', '3', 2, 'Y', NULL, '1', '044000', '140800');
INSERT INTO `sys_region` VALUES ('140821', '2018-01-30 19:30:19', NULL, NULL, NULL, '临猗县', '山西省运城市临猗县', '3', 3, 'L', NULL, '1', '044100', '140800');
INSERT INTO `sys_region` VALUES ('140822', '2018-01-30 19:30:19', NULL, NULL, NULL, '万荣县', '山西省运城市万荣县', '3', 4, 'W', NULL, '1', '044200', '140800');
INSERT INTO `sys_region` VALUES ('140823', '2018-01-30 19:30:19', NULL, NULL, NULL, '闻喜县', '山西省运城市闻喜县', '3', 5, 'W', NULL, '1', '043800', '140800');
INSERT INTO `sys_region` VALUES ('140824', '2018-01-30 19:30:19', NULL, NULL, NULL, '稷山县', '山西省运城市稷山县', '3', 6, 'Z', NULL, '1', '043200', '140800');
INSERT INTO `sys_region` VALUES ('140825', '2018-01-30 19:30:19', NULL, NULL, NULL, '新绛县', '山西省运城市新绛县', '3', 7, 'X', NULL, '1', '043100', '140800');
INSERT INTO `sys_region` VALUES ('140826', '2018-01-30 19:30:19', NULL, NULL, NULL, '绛县', '山西省运城市绛县', '3', 8, 'Z', NULL, '1', '043600', '140800');
INSERT INTO `sys_region` VALUES ('140827', '2018-01-30 19:30:19', NULL, NULL, NULL, '垣曲县', '山西省运城市垣曲县', '3', 9, 'Y', NULL, '1', '043700', '140800');
INSERT INTO `sys_region` VALUES ('140828', '2018-01-30 19:30:19', NULL, NULL, NULL, '夏县', '山西省运城市夏县', '3', 10, 'X', NULL, '1', '044400', '140800');
INSERT INTO `sys_region` VALUES ('140829', '2018-01-30 19:30:19', NULL, NULL, NULL, '平陆县', '山西省运城市平陆县', '3', 11, 'P', NULL, '1', '044300', '140800');
INSERT INTO `sys_region` VALUES ('140830', '2018-01-30 19:30:19', NULL, NULL, NULL, '芮城县', '山西省运城市芮城县', '3', 12, 'Z', NULL, '1', '044600', '140800');
INSERT INTO `sys_region` VALUES ('140881', '2018-01-30 19:30:19', NULL, NULL, NULL, '永济市', '山西省运城市永济市', '3', 13, 'Y', NULL, '1', '044500', '140800');
INSERT INTO `sys_region` VALUES ('140882', '2018-01-30 19:30:19', NULL, NULL, NULL, '河津市', '山西省运城市河津市', '3', 14, 'H', NULL, '1', '043300', '140800');
INSERT INTO `sys_region` VALUES ('140900', '2018-01-30 19:30:19', NULL, NULL, NULL, '忻州市', '山西省忻州市', '2', 9, 'X', NULL, '1', '034000', '140000');
INSERT INTO `sys_region` VALUES ('140901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省忻州市市辖区', '3', 1, 'S', NULL, '1', NULL, '140900');
INSERT INTO `sys_region` VALUES ('140902', '2018-01-30 19:30:19', NULL, NULL, NULL, '忻府区', '山西省忻州市忻府区', '3', 2, 'X', NULL, '1', '034000', '140900');
INSERT INTO `sys_region` VALUES ('140921', '2018-01-30 19:30:19', NULL, NULL, NULL, '定襄县', '山西省忻州市定襄县', '3', 3, 'D', NULL, '1', '035400', '140900');
INSERT INTO `sys_region` VALUES ('140922', '2018-01-30 19:30:19', NULL, NULL, NULL, '五台县', '山西省忻州市五台县', '3', 4, 'W', NULL, '1', '035500', '140900');
INSERT INTO `sys_region` VALUES ('140923', '2018-01-30 19:30:19', NULL, NULL, NULL, '代县', '山西省忻州市代县', '3', 5, 'D', NULL, '1', '034200', '140900');
INSERT INTO `sys_region` VALUES ('140924', '2018-01-30 19:30:19', NULL, NULL, NULL, '繁峙县', '山西省忻州市繁峙县', '3', 6, 'F', NULL, '1', '034300', '140900');
INSERT INTO `sys_region` VALUES ('140925', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁武县', '山西省忻州市宁武县', '3', 7, 'N', NULL, '1', '036700', '140900');
INSERT INTO `sys_region` VALUES ('140926', '2018-01-30 19:30:19', NULL, NULL, NULL, '静乐县', '山西省忻州市静乐县', '3', 8, 'J', NULL, '1', '035100', '140900');
INSERT INTO `sys_region` VALUES ('140927', '2018-01-30 19:30:19', NULL, NULL, NULL, '神池县', '山西省忻州市神池县', '3', 9, 'S', NULL, '1', '036100', '140900');
INSERT INTO `sys_region` VALUES ('140928', '2018-01-30 19:30:19', NULL, NULL, NULL, '五寨县', '山西省忻州市五寨县', '3', 10, 'W', NULL, '1', '036200', '140900');
INSERT INTO `sys_region` VALUES ('140929', '2018-01-30 19:30:19', NULL, NULL, NULL, '岢岚县', '山西省忻州市岢岚县', '3', 11, 'Z', NULL, '1', '036300', '140900');
INSERT INTO `sys_region` VALUES ('140930', '2018-01-30 19:30:19', NULL, NULL, NULL, '河曲县', '山西省忻州市河曲县', '3', 12, 'H', NULL, '1', '036500', '140900');
INSERT INTO `sys_region` VALUES ('140931', '2018-01-30 19:30:19', NULL, NULL, NULL, '保德县', '山西省忻州市保德县', '3', 13, 'B', NULL, '1', '036600', '140900');
INSERT INTO `sys_region` VALUES ('140932', '2018-01-30 19:30:19', NULL, NULL, NULL, '偏关县', '山西省忻州市偏关县', '3', 14, 'P', NULL, '1', '036400', '140900');
INSERT INTO `sys_region` VALUES ('140981', '2018-01-30 19:30:19', NULL, NULL, NULL, '原平市', '山西省忻州市原平市', '3', 15, 'Y', NULL, '1', '034100', '140900');
INSERT INTO `sys_region` VALUES ('141000', '2018-01-30 19:30:19', NULL, NULL, NULL, '临汾市', '山西省临汾市', '2', 10, 'L', NULL, '1', '041000', '140000');
INSERT INTO `sys_region` VALUES ('141001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省临汾市市辖区', '3', 1, 'S', NULL, '1', NULL, '141000');
INSERT INTO `sys_region` VALUES ('141002', '2018-01-30 19:30:19', NULL, NULL, NULL, '尧都区', '山西省临汾市尧都区', '3', 2, 'Y', NULL, '1', '041000', '141000');
INSERT INTO `sys_region` VALUES ('141021', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲沃县', '山西省临汾市曲沃县', '3', 3, 'Q', NULL, '1', '043400', '141000');
INSERT INTO `sys_region` VALUES ('141022', '2018-01-30 19:30:19', NULL, NULL, NULL, '翼城县', '山西省临汾市翼城县', '3', 4, 'Y', NULL, '1', '043500', '141000');
INSERT INTO `sys_region` VALUES ('141023', '2018-01-30 19:30:19', NULL, NULL, NULL, '襄汾县', '山西省临汾市襄汾县', '3', 5, 'X', NULL, '1', '041500', '141000');
INSERT INTO `sys_region` VALUES ('141024', '2018-01-30 19:30:19', NULL, NULL, NULL, '洪洞县', '山西省临汾市洪洞县', '3', 6, 'H', NULL, '1', '041600', '141000');
INSERT INTO `sys_region` VALUES ('141025', '2018-01-30 19:30:19', NULL, NULL, NULL, '古县', '山西省临汾市古县', '3', 7, 'G', NULL, '1', '042400', '141000');
INSERT INTO `sys_region` VALUES ('141026', '2018-01-30 19:30:19', NULL, NULL, NULL, '安泽县', '山西省临汾市安泽县', '3', 8, 'A', NULL, '1', '042500', '141000');
INSERT INTO `sys_region` VALUES ('141027', '2018-01-30 19:30:19', NULL, NULL, NULL, '浮山县', '山西省临汾市浮山县', '3', 9, 'F', NULL, '1', '042600', '141000');
INSERT INTO `sys_region` VALUES ('141028', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉县', '山西省临汾市吉县', '3', 10, 'J', NULL, '1', '042200', '141000');
INSERT INTO `sys_region` VALUES ('141029', '2018-01-30 19:30:19', NULL, NULL, NULL, '乡宁县', '山西省临汾市乡宁县', '3', 11, 'X', NULL, '1', '042100', '141000');
INSERT INTO `sys_region` VALUES ('141030', '2018-01-30 19:30:19', NULL, NULL, NULL, '大宁县', '山西省临汾市大宁县', '3', 12, 'D', NULL, '1', '042300', '141000');
INSERT INTO `sys_region` VALUES ('141031', '2018-01-30 19:30:19', NULL, NULL, NULL, '隰县', '山西省临汾市隰县', '3', 13, 'Z', NULL, '1', '041300', '141000');
INSERT INTO `sys_region` VALUES ('141032', '2018-01-30 19:30:19', NULL, NULL, NULL, '永和县', '山西省临汾市永和县', '3', 14, 'Y', NULL, '1', '041400', '141000');
INSERT INTO `sys_region` VALUES ('141033', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒲县', '山西省临汾市蒲县', '3', 15, 'P', NULL, '1', '041200', '141000');
INSERT INTO `sys_region` VALUES ('141034', '2018-01-30 19:30:19', NULL, NULL, NULL, '汾西县', '山西省临汾市汾西县', '3', 16, 'F', NULL, '1', '031500', '141000');
INSERT INTO `sys_region` VALUES ('141081', '2018-01-30 19:30:19', NULL, NULL, NULL, '侯马市', '山西省临汾市侯马市', '3', 17, 'H', NULL, '1', '043000', '141000');
INSERT INTO `sys_region` VALUES ('141082', '2018-01-30 19:30:19', NULL, NULL, NULL, '霍州市', '山西省临汾市霍州市', '3', 18, 'H', NULL, '1', '031400', '141000');
INSERT INTO `sys_region` VALUES ('141100', '2018-01-30 19:30:19', NULL, NULL, NULL, '吕梁市', '山西省吕梁市', '2', 11, 'L', NULL, '1', '033000', '140000');
INSERT INTO `sys_region` VALUES ('141101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山西省吕梁市市辖区', '3', 1, 'S', NULL, '1', NULL, '141100');
INSERT INTO `sys_region` VALUES ('141102', '2018-01-30 19:30:19', NULL, NULL, NULL, '离石区', '山西省吕梁市离石区', '3', 2, 'L', NULL, '1', '033000', '141100');
INSERT INTO `sys_region` VALUES ('141121', '2018-01-30 19:30:19', NULL, NULL, NULL, '文水县', '山西省吕梁市文水县', '3', 3, 'W', NULL, '1', '032100', '141100');
INSERT INTO `sys_region` VALUES ('141122', '2018-01-30 19:30:19', NULL, NULL, NULL, '交城县', '山西省吕梁市交城县', '3', 4, 'J', NULL, '1', '030500', '141100');
INSERT INTO `sys_region` VALUES ('141123', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴县', '山西省吕梁市兴县', '3', 5, 'X', NULL, '1', '033600', '141100');
INSERT INTO `sys_region` VALUES ('141124', '2018-01-30 19:30:19', NULL, NULL, NULL, '临县', '山西省吕梁市临县', '3', 6, 'L', NULL, '1', '033200', '141100');
INSERT INTO `sys_region` VALUES ('141125', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳林县', '山西省吕梁市柳林县', '3', 7, 'L', NULL, '1', '033300', '141100');
INSERT INTO `sys_region` VALUES ('141126', '2018-01-30 19:30:19', NULL, NULL, NULL, '石楼县', '山西省吕梁市石楼县', '3', 8, 'S', NULL, '1', '032500', '141100');
INSERT INTO `sys_region` VALUES ('141127', '2018-01-30 19:30:19', NULL, NULL, NULL, '岚县', '山西省吕梁市岚县', '3', 9, 'Z', NULL, '1', '033500', '141100');
INSERT INTO `sys_region` VALUES ('141128', '2018-01-30 19:30:19', NULL, NULL, NULL, '方山县', '山西省吕梁市方山县', '3', 10, 'F', NULL, '1', '033100', '141100');
INSERT INTO `sys_region` VALUES ('141129', '2018-01-30 19:30:19', NULL, NULL, NULL, '中阳县', '山西省吕梁市中阳县', '3', 11, 'Z', NULL, '1', '033400', '141100');
INSERT INTO `sys_region` VALUES ('141130', '2018-01-30 19:30:19', NULL, NULL, NULL, '交口县', '山西省吕梁市交口县', '3', 12, 'J', NULL, '1', '032400', '141100');
INSERT INTO `sys_region` VALUES ('141181', '2018-01-30 19:30:19', NULL, NULL, NULL, '孝义市', '山西省吕梁市孝义市', '3', 13, 'X', NULL, '1', '032300', '141100');
INSERT INTO `sys_region` VALUES ('141182', '2018-01-30 19:30:19', NULL, NULL, NULL, '汾阳市', '山西省吕梁市汾阳市', '3', 14, 'F', NULL, '1', '032200', '141100');
INSERT INTO `sys_region` VALUES ('150000', '2018-01-30 19:30:19', NULL, NULL, NULL, '内蒙古自治区', '内蒙古自治区', '1', 5, 'N', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('150100', '2018-01-30 19:30:19', NULL, NULL, NULL, '呼和浩特市', '内蒙古自治区呼和浩特市', '2', 1, 'H', NULL, '1', '010000', '150000');
INSERT INTO `sys_region` VALUES ('150101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区呼和浩特市市辖区', '3', 1, 'S', NULL, '1', '', '150100');
INSERT INTO `sys_region` VALUES ('150102', '2018-01-30 19:30:19', NULL, NULL, NULL, '新城区', '内蒙古自治区呼和浩特市新城区', '3', 2, 'X', NULL, '1', '010050', '150100');
INSERT INTO `sys_region` VALUES ('150103', '2018-01-30 19:30:19', NULL, NULL, NULL, '回民区', '内蒙古自治区呼和浩特市回民区', '3', 3, 'H', NULL, '1', '010030', '150100');
INSERT INTO `sys_region` VALUES ('150104', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉泉区', '内蒙古自治区呼和浩特市玉泉区', '3', 4, 'Y', NULL, '1', '010020', '150100');
INSERT INTO `sys_region` VALUES ('150105', '2018-01-30 19:30:19', NULL, NULL, NULL, '赛罕区', '内蒙古自治区呼和浩特市赛罕区', '3', 5, 'S', NULL, '1', '010020', '150100');
INSERT INTO `sys_region` VALUES ('150121', '2018-01-30 19:30:19', NULL, NULL, NULL, '土默特左旗', '内蒙古自治区呼和浩特市土默特左旗', '3', 6, 'T', NULL, '1', '010100', '150100');
INSERT INTO `sys_region` VALUES ('150122', '2018-01-30 19:30:19', NULL, NULL, NULL, '托克托县', '内蒙古自治区呼和浩特市托克托县', '3', 7, 'T', NULL, '1', '010200', '150100');
INSERT INTO `sys_region` VALUES ('150123', '2018-01-30 19:30:19', NULL, NULL, NULL, '和林格尔县', '内蒙古自治区呼和浩特市和林格尔县', '3', 8, 'H', NULL, '1', '011500', '150100');
INSERT INTO `sys_region` VALUES ('150124', '2018-01-30 19:30:19', NULL, NULL, NULL, '清水河县', '内蒙古自治区呼和浩特市清水河县', '3', 9, 'Q', NULL, '1', '011600', '150100');
INSERT INTO `sys_region` VALUES ('150125', '2018-01-30 19:30:19', NULL, NULL, NULL, '武川县', '内蒙古自治区呼和浩特市武川县', '3', 10, 'W', NULL, '1', '011700', '150100');
INSERT INTO `sys_region` VALUES ('150200', '2018-01-30 19:30:19', NULL, NULL, NULL, '包头市', '内蒙古自治区包头市', '2', 2, 'B', NULL, '1', '014025', '150000');
INSERT INTO `sys_region` VALUES ('150201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区包头市市辖区', '3', 1, 'S', NULL, '1', NULL, '150200');
INSERT INTO `sys_region` VALUES ('150202', '2018-01-30 19:30:19', NULL, NULL, NULL, '东河区', '内蒙古自治区包头市东河区', '3', 2, 'D', NULL, '1', '014040', '150200');
INSERT INTO `sys_region` VALUES ('150203', '2018-01-30 19:30:19', NULL, NULL, NULL, '昆都仑区', '内蒙古自治区包头市昆都仑区', '3', 3, 'K', NULL, '1', '014010', '150200');
INSERT INTO `sys_region` VALUES ('150204', '2018-01-30 19:30:19', NULL, NULL, NULL, '青山区', '内蒙古自治区包头市青山区', '3', 4, 'Q', NULL, '1', '014030', '150200');
INSERT INTO `sys_region` VALUES ('150205', '2018-01-30 19:30:19', NULL, NULL, NULL, '石拐区', '内蒙古自治区包头市石拐区', '3', 5, 'S', NULL, '1', '014070', '150200');
INSERT INTO `sys_region` VALUES ('150206', '2018-01-30 19:30:19', NULL, NULL, NULL, '白云鄂博矿区', '内蒙古自治区包头市白云鄂博矿区', '3', 6, 'B', NULL, '1', '014080', '150200');
INSERT INTO `sys_region` VALUES ('150207', '2018-01-30 19:30:19', NULL, NULL, NULL, '九原区', '内蒙古自治区包头市九原区', '3', 7, 'J', NULL, '1', '014060', '150200');
INSERT INTO `sys_region` VALUES ('150221', '2018-01-30 19:30:19', NULL, NULL, NULL, '土默特右旗', '内蒙古自治区包头市土默特右旗', '3', 8, 'T', NULL, '1', '014100', '150200');
INSERT INTO `sys_region` VALUES ('150222', '2018-01-30 19:30:19', NULL, NULL, NULL, '固阳县', '内蒙古自治区包头市固阳县', '3', 9, 'G', NULL, '1', '014200', '150200');
INSERT INTO `sys_region` VALUES ('150223', '2018-01-30 19:30:19', NULL, NULL, NULL, '达尔罕茂明安联合旗', '内蒙古自治区包头市达尔罕茂明安联合旗', '3', 10, 'D', NULL, '1', '014500', '150200');
INSERT INTO `sys_region` VALUES ('150300', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌海市', '内蒙古自治区乌海市', '2', 3, 'W', NULL, '1', '016000', '150000');
INSERT INTO `sys_region` VALUES ('150301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区乌海市市辖区', '3', 1, 'S', NULL, '1', NULL, '150300');
INSERT INTO `sys_region` VALUES ('150302', '2018-01-30 19:30:19', NULL, NULL, NULL, '海勃湾区', '内蒙古自治区乌海市海勃湾区', '3', 2, 'H', NULL, '1', '016000', '150300');
INSERT INTO `sys_region` VALUES ('150303', '2018-01-30 19:30:19', NULL, NULL, NULL, '海南区', '内蒙古自治区乌海市海南区', '3', 3, 'H', NULL, '1', '016030', '150300');
INSERT INTO `sys_region` VALUES ('150304', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌达区', '内蒙古自治区乌海市乌达区', '3', 4, 'W', NULL, '1', '016040', '150300');
INSERT INTO `sys_region` VALUES ('150400', '2018-01-30 19:30:19', NULL, NULL, NULL, '赤峰市', '内蒙古自治区赤峰市', '2', 4, 'C', NULL, '1', '024000', '150000');
INSERT INTO `sys_region` VALUES ('150401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区赤峰市市辖区', '3', 1, 'S', NULL, '1', NULL, '150400');
INSERT INTO `sys_region` VALUES ('150402', '2018-01-30 19:30:19', NULL, NULL, NULL, '红山区', '内蒙古自治区赤峰市红山区', '3', 2, 'H', NULL, '1', '024020', '150400');
INSERT INTO `sys_region` VALUES ('150403', '2018-01-30 19:30:19', NULL, NULL, NULL, '元宝山区', '内蒙古自治区赤峰市元宝山区', '3', 3, 'Y', NULL, '1', '024076', '150400');
INSERT INTO `sys_region` VALUES ('150404', '2018-01-30 19:30:19', NULL, NULL, NULL, '松山区', '内蒙古自治区赤峰市松山区', '3', 4, 'S', NULL, '1', '024005', '150400');
INSERT INTO `sys_region` VALUES ('150421', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿鲁科尔沁旗', '内蒙古自治区赤峰市阿鲁科尔沁旗', '3', 5, 'A', NULL, '1', '025550', '150400');
INSERT INTO `sys_region` VALUES ('150422', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴林左旗', '内蒙古自治区赤峰市巴林左旗', '3', 6, 'B', NULL, '1', '025450', '150400');
INSERT INTO `sys_region` VALUES ('150423', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴林右旗', '内蒙古自治区赤峰市巴林右旗', '3', 7, 'B', NULL, '1', '025150', '150400');
INSERT INTO `sys_region` VALUES ('150424', '2018-01-30 19:30:19', NULL, NULL, NULL, '林西县', '内蒙古自治区赤峰市林西县', '3', 8, 'L', NULL, '1', '025250', '150400');
INSERT INTO `sys_region` VALUES ('150425', '2018-01-30 19:30:19', NULL, NULL, NULL, '克什克腾旗', '内蒙古自治区赤峰市克什克腾旗', '3', 9, 'K', NULL, '1', '025350', '150400');
INSERT INTO `sys_region` VALUES ('150426', '2018-01-30 19:30:19', NULL, NULL, NULL, '翁牛特旗', '内蒙古自治区赤峰市翁牛特旗', '3', 10, 'W', NULL, '1', '024500', '150400');
INSERT INTO `sys_region` VALUES ('150428', '2018-01-30 19:30:19', NULL, NULL, NULL, '喀喇沁旗', '内蒙古自治区赤峰市喀喇沁旗', '3', 11, 'K', NULL, '1', '024400', '150400');
INSERT INTO `sys_region` VALUES ('150429', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁城县', '内蒙古自治区赤峰市宁城县', '3', 12, 'N', NULL, '1', '024200', '150400');
INSERT INTO `sys_region` VALUES ('150430', '2018-01-30 19:30:19', NULL, NULL, NULL, '敖汉旗', '内蒙古自治区赤峰市敖汉旗', '3', 13, 'A', NULL, '1', '024300', '150400');
INSERT INTO `sys_region` VALUES ('150500', '2018-01-30 19:30:19', NULL, NULL, NULL, '通辽市', '内蒙古自治区通辽市', '2', 5, 'T', NULL, '1', '028000', '150000');
INSERT INTO `sys_region` VALUES ('150501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区通辽市市辖区', '3', 1, 'S', NULL, '1', NULL, '150500');
INSERT INTO `sys_region` VALUES ('150502', '2018-01-30 19:30:19', NULL, NULL, NULL, '科尔沁区', '内蒙古自治区通辽市科尔沁区', '3', 2, 'K', NULL, '1', '028000', '150500');
INSERT INTO `sys_region` VALUES ('150521', '2018-01-30 19:30:19', NULL, NULL, NULL, '科尔沁左翼中旗', '内蒙古自治区通辽市科尔沁左翼中旗', '3', 3, 'K', NULL, '1', '029300', '150500');
INSERT INTO `sys_region` VALUES ('150522', '2018-01-30 19:30:19', NULL, NULL, NULL, '科尔沁左翼后旗', '内蒙古自治区通辽市科尔沁左翼后旗', '3', 4, 'K', NULL, '1', '028100', '150500');
INSERT INTO `sys_region` VALUES ('150523', '2018-01-30 19:30:19', NULL, NULL, NULL, '开鲁县', '内蒙古自治区通辽市开鲁县', '3', 5, 'K', NULL, '1', '028400', '150500');
INSERT INTO `sys_region` VALUES ('150524', '2018-01-30 19:30:19', NULL, NULL, NULL, '库伦旗', '内蒙古自治区通辽市库伦旗', '3', 6, 'K', NULL, '1', '028200', '150500');
INSERT INTO `sys_region` VALUES ('150525', '2018-01-30 19:30:19', NULL, NULL, NULL, '奈曼旗', '内蒙古自治区通辽市奈曼旗', '3', 7, 'N', NULL, '1', '028300', '150500');
INSERT INTO `sys_region` VALUES ('150526', '2018-01-30 19:30:19', NULL, NULL, NULL, '扎鲁特旗', '内蒙古自治区通辽市扎鲁特旗', '3', 8, 'Z', NULL, '1', '029100', '150500');
INSERT INTO `sys_region` VALUES ('150581', '2018-01-30 19:30:19', NULL, NULL, NULL, '霍林郭勒市', '内蒙古自治区通辽市霍林郭勒市', '3', 9, 'H', NULL, '1', '029200', '150500');
INSERT INTO `sys_region` VALUES ('150600', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄂尔多斯市', '内蒙古自治区鄂尔多斯市', '2', 6, 'E', NULL, '1', '017004', '150000');
INSERT INTO `sys_region` VALUES ('150601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区鄂尔多斯市市辖区', '3', 1, 'S', NULL, '1', NULL, '150600');
INSERT INTO `sys_region` VALUES ('150602', '2018-01-30 19:30:19', NULL, NULL, NULL, '东胜区', '内蒙古自治区鄂尔多斯市东胜区', '3', 2, 'D', NULL, '1', '017000', '150600');
INSERT INTO `sys_region` VALUES ('150603', '2018-01-30 19:30:19', NULL, NULL, NULL, '康巴什区', '内蒙古自治区鄂尔多斯市康巴什区', '3', 3, 'K', NULL, '1', NULL, '150600');
INSERT INTO `sys_region` VALUES ('150621', '2018-01-30 19:30:19', NULL, NULL, NULL, '达拉特旗', '内蒙古自治区鄂尔多斯市达拉特旗', '3', 4, 'D', NULL, '1', '014300', '150600');
INSERT INTO `sys_region` VALUES ('150622', '2018-01-30 19:30:19', NULL, NULL, NULL, '准格尔旗', '内蒙古自治区鄂尔多斯市准格尔旗', '3', 5, 'Z', NULL, '1', '017100', '150600');
INSERT INTO `sys_region` VALUES ('150623', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄂托克前旗', '内蒙古自治区鄂尔多斯市鄂托克前旗', '3', 6, 'E', NULL, '1', '016200', '150600');
INSERT INTO `sys_region` VALUES ('150624', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄂托克旗', '内蒙古自治区鄂尔多斯市鄂托克旗', '3', 7, 'E', NULL, '1', '016100', '150600');
INSERT INTO `sys_region` VALUES ('150625', '2018-01-30 19:30:19', NULL, NULL, NULL, '杭锦旗', '内蒙古自治区鄂尔多斯市杭锦旗', '3', 8, 'H', NULL, '1', '017400', '150600');
INSERT INTO `sys_region` VALUES ('150626', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌审旗', '内蒙古自治区鄂尔多斯市乌审旗', '3', 9, 'W', NULL, '1', '017300', '150600');
INSERT INTO `sys_region` VALUES ('150627', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊金霍洛旗', '内蒙古自治区鄂尔多斯市伊金霍洛旗', '3', 10, 'Y', NULL, '1', '017200', '150600');
INSERT INTO `sys_region` VALUES ('150700', '2018-01-30 19:30:19', NULL, NULL, NULL, '呼伦贝尔市', '内蒙古自治区呼伦贝尔市', '2', 7, 'H', NULL, '1', '021008', '150000');
INSERT INTO `sys_region` VALUES ('150701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区呼伦贝尔市市辖区', '3', 1, 'S', NULL, '1', NULL, '150700');
INSERT INTO `sys_region` VALUES ('150702', '2018-01-30 19:30:19', NULL, NULL, NULL, '海拉尔区', '内蒙古自治区呼伦贝尔市海拉尔区', '3', 2, 'H', NULL, '1', '021000', '150700');
INSERT INTO `sys_region` VALUES ('150703', '2018-01-30 19:30:19', NULL, NULL, NULL, '扎赉诺尔区', '内蒙古自治区呼伦贝尔市扎赉诺尔区', '3', 3, 'Z', NULL, '1', '021410', '150700');
INSERT INTO `sys_region` VALUES ('150721', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿荣旗', '内蒙古自治区呼伦贝尔市阿荣旗', '3', 4, 'A', NULL, '1', '162750', '150700');
INSERT INTO `sys_region` VALUES ('150722', '2018-01-30 19:30:19', NULL, NULL, NULL, '莫力达瓦达斡尔族自治旗', '内蒙古自治区呼伦贝尔市莫力达瓦达斡尔族自治旗', '3', 5, 'M', NULL, '1', '162850', '150700');
INSERT INTO `sys_region` VALUES ('150723', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄂伦春自治旗', '内蒙古自治区呼伦贝尔市鄂伦春自治旗', '3', 6, 'E', NULL, '1', '165450', '150700');
INSERT INTO `sys_region` VALUES ('150724', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄂温克族自治旗', '内蒙古自治区呼伦贝尔市鄂温克族自治旗', '3', 7, 'E', NULL, '1', '021100', '150700');
INSERT INTO `sys_region` VALUES ('150725', '2018-01-30 19:30:19', NULL, NULL, NULL, '陈巴尔虎旗', '内蒙古自治区呼伦贝尔市陈巴尔虎旗', '3', 8, 'C', NULL, '1', '021500', '150700');
INSERT INTO `sys_region` VALUES ('150726', '2018-01-30 19:30:19', NULL, NULL, NULL, '新巴尔虎左旗', '内蒙古自治区呼伦贝尔市新巴尔虎左旗', '3', 9, 'X', NULL, '1', '021200', '150700');
INSERT INTO `sys_region` VALUES ('150727', '2018-01-30 19:30:19', NULL, NULL, NULL, '新巴尔虎右旗', '内蒙古自治区呼伦贝尔市新巴尔虎右旗', '3', 10, 'X', NULL, '1', '021300', '150700');
INSERT INTO `sys_region` VALUES ('150781', '2018-01-30 19:30:19', NULL, NULL, NULL, '满洲里市', '内蒙古自治区呼伦贝尔市满洲里市', '3', 11, 'M', NULL, '1', '021400', '150700');
INSERT INTO `sys_region` VALUES ('150782', '2018-01-30 19:30:19', NULL, NULL, NULL, '牙克石市', '内蒙古自治区呼伦贝尔市牙克石市', '3', 12, 'Y', NULL, '1', '022150', '150700');
INSERT INTO `sys_region` VALUES ('150783', '2018-01-30 19:30:19', NULL, NULL, NULL, '扎兰屯市', '内蒙古自治区呼伦贝尔市扎兰屯市', '3', 13, 'Z', NULL, '1', '162650', '150700');
INSERT INTO `sys_region` VALUES ('150784', '2018-01-30 19:30:19', NULL, NULL, NULL, '额尔古纳市', '内蒙古自治区呼伦贝尔市额尔古纳市', '3', 14, 'E', NULL, '1', '022250', '150700');
INSERT INTO `sys_region` VALUES ('150785', '2018-01-30 19:30:19', NULL, NULL, NULL, '根河市', '内蒙古自治区呼伦贝尔市根河市', '3', 15, 'G', NULL, '1', '022350', '150700');
INSERT INTO `sys_region` VALUES ('150800', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴彦淖尔市', '内蒙古自治区巴彦淖尔市', '2', 8, 'B', NULL, '1', '015001', '150000');
INSERT INTO `sys_region` VALUES ('150801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区巴彦淖尔市市辖区', '3', 1, 'S', NULL, '1', NULL, '150800');
INSERT INTO `sys_region` VALUES ('150802', '2018-01-30 19:30:19', NULL, NULL, NULL, '临河区', '内蒙古自治区巴彦淖尔市临河区', '3', 2, 'L', NULL, '1', '015001', '150800');
INSERT INTO `sys_region` VALUES ('150821', '2018-01-30 19:30:19', NULL, NULL, NULL, '五原县', '内蒙古自治区巴彦淖尔市五原县', '3', 3, 'W', NULL, '1', '015100', '150800');
INSERT INTO `sys_region` VALUES ('150822', '2018-01-30 19:30:19', NULL, NULL, NULL, '磴口县', '内蒙古自治区巴彦淖尔市磴口县', '3', 4, 'Z', NULL, '1', '015200', '150800');
INSERT INTO `sys_region` VALUES ('150823', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌拉特前旗', '内蒙古自治区巴彦淖尔市乌拉特前旗', '3', 5, 'W', NULL, '1', '014400', '150800');
INSERT INTO `sys_region` VALUES ('150824', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌拉特中旗', '内蒙古自治区巴彦淖尔市乌拉特中旗', '3', 6, 'W', NULL, '1', '015300', '150800');
INSERT INTO `sys_region` VALUES ('150825', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌拉特后旗', '内蒙古自治区巴彦淖尔市乌拉特后旗', '3', 7, 'W', NULL, '1', '015500', '150800');
INSERT INTO `sys_region` VALUES ('150826', '2018-01-30 19:30:19', NULL, NULL, NULL, '杭锦后旗', '内蒙古自治区巴彦淖尔市杭锦后旗', '3', 8, 'H', NULL, '1', '015400', '150800');
INSERT INTO `sys_region` VALUES ('150900', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌兰察布市', '内蒙古自治区乌兰察布市', '2', 9, 'W', NULL, '1', '012000', '150000');
INSERT INTO `sys_region` VALUES ('150901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '内蒙古自治区乌兰察布市市辖区', '3', 1, 'S', NULL, '1', NULL, '150900');
INSERT INTO `sys_region` VALUES ('150902', '2018-01-30 19:30:19', NULL, NULL, NULL, '集宁区', '内蒙古自治区乌兰察布市集宁区', '3', 2, 'J', NULL, '1', '012000', '150900');
INSERT INTO `sys_region` VALUES ('150921', '2018-01-30 19:30:19', NULL, NULL, NULL, '卓资县', '内蒙古自治区乌兰察布市卓资县', '3', 3, 'Z', NULL, '1', '012300', '150900');
INSERT INTO `sys_region` VALUES ('150922', '2018-01-30 19:30:19', NULL, NULL, NULL, '化德县', '内蒙古自治区乌兰察布市化德县', '3', 4, 'H', NULL, '1', '013350', '150900');
INSERT INTO `sys_region` VALUES ('150923', '2018-01-30 19:30:19', NULL, NULL, NULL, '商都县', '内蒙古自治区乌兰察布市商都县', '3', 5, 'S', NULL, '1', '013450', '150900');
INSERT INTO `sys_region` VALUES ('150924', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴和县', '内蒙古自治区乌兰察布市兴和县', '3', 6, 'X', NULL, '1', '013650', '150900');
INSERT INTO `sys_region` VALUES ('150925', '2018-01-30 19:30:19', NULL, NULL, NULL, '凉城县', '内蒙古自治区乌兰察布市凉城县', '3', 7, 'L', NULL, '1', '013750', '150900');
INSERT INTO `sys_region` VALUES ('150926', '2018-01-30 19:30:19', NULL, NULL, NULL, '察哈尔右翼前旗', '内蒙古自治区乌兰察布市察哈尔右翼前旗', '3', 8, 'C', NULL, '1', '012200', '150900');
INSERT INTO `sys_region` VALUES ('150927', '2018-01-30 19:30:19', NULL, NULL, NULL, '察哈尔右翼中旗', '内蒙古自治区乌兰察布市察哈尔右翼中旗', '3', 9, 'C', NULL, '1', '013550', '150900');
INSERT INTO `sys_region` VALUES ('150928', '2018-01-30 19:30:19', NULL, NULL, NULL, '察哈尔右翼后旗', '内蒙古自治区乌兰察布市察哈尔右翼后旗', '3', 10, 'C', NULL, '1', '012400', '150900');
INSERT INTO `sys_region` VALUES ('150929', '2018-01-30 19:30:19', NULL, NULL, NULL, '四子王旗', '内蒙古自治区乌兰察布市四子王旗', '3', 11, 'S', NULL, '1', '011800', '150900');
INSERT INTO `sys_region` VALUES ('150981', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰镇市', '内蒙古自治区乌兰察布市丰镇市', '3', 12, 'F', NULL, '1', '012100', '150900');
INSERT INTO `sys_region` VALUES ('152200', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴安盟', '内蒙古自治区兴安盟', '2', 10, 'X', NULL, '1', '137401', '150000');
INSERT INTO `sys_region` VALUES ('152201', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌兰浩特市', '内蒙古自治区兴安盟乌兰浩特市', '3', 1, 'W', NULL, '1', '137401', '152200');
INSERT INTO `sys_region` VALUES ('152202', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿尔山市', '内蒙古自治区兴安盟阿尔山市', '3', 2, 'A', NULL, '1', '137800', '152200');
INSERT INTO `sys_region` VALUES ('152221', '2018-01-30 19:30:19', NULL, NULL, NULL, '科尔沁右翼前旗', '内蒙古自治区兴安盟科尔沁右翼前旗', '3', 3, 'K', NULL, '1', '137423', '152200');
INSERT INTO `sys_region` VALUES ('152222', '2018-01-30 19:30:19', NULL, NULL, NULL, '科尔沁右翼中旗', '内蒙古自治区兴安盟科尔沁右翼中旗', '3', 4, 'K', NULL, '1', '029400', '152200');
INSERT INTO `sys_region` VALUES ('152223', '2018-01-30 19:30:19', NULL, NULL, NULL, '扎赉特旗', '内蒙古自治区兴安盟扎赉特旗', '3', 5, 'Z', NULL, '1', '137600', '152200');
INSERT INTO `sys_region` VALUES ('152224', '2018-01-30 19:30:19', NULL, NULL, NULL, '突泉县', '内蒙古自治区兴安盟突泉县', '3', 6, 'T', NULL, '1', '137500', '152200');
INSERT INTO `sys_region` VALUES ('152500', '2018-01-30 19:30:19', NULL, NULL, NULL, '锡林郭勒盟', '内蒙古自治区锡林郭勒盟', '2', 11, 'X', NULL, '1', '026000', '150000');
INSERT INTO `sys_region` VALUES ('152501', '2018-01-30 19:30:19', NULL, NULL, NULL, '二连浩特市', '内蒙古自治区锡林郭勒盟二连浩特市', '3', 1, 'E', NULL, '1', '011100', '152500');
INSERT INTO `sys_region` VALUES ('152502', '2018-01-30 19:30:19', NULL, NULL, NULL, '锡林浩特市', '内蒙古自治区锡林郭勒盟锡林浩特市', '3', 2, 'X', NULL, '1', '026021', '152500');
INSERT INTO `sys_region` VALUES ('152522', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿巴嘎旗', '内蒙古自治区锡林郭勒盟阿巴嘎旗', '3', 3, 'A', NULL, '1', '011400', '152500');
INSERT INTO `sys_region` VALUES ('152523', '2018-01-30 19:30:19', NULL, NULL, NULL, '苏尼特左旗', '内蒙古自治区锡林郭勒盟苏尼特左旗', '3', 4, 'S', NULL, '1', '011300', '152500');
INSERT INTO `sys_region` VALUES ('152524', '2018-01-30 19:30:19', NULL, NULL, NULL, '苏尼特右旗', '内蒙古自治区锡林郭勒盟苏尼特右旗', '3', 5, 'S', NULL, '1', '011200', '152500');
INSERT INTO `sys_region` VALUES ('152525', '2018-01-30 19:30:19', NULL, NULL, NULL, '东乌珠穆沁旗', '内蒙古自治区锡林郭勒盟东乌珠穆沁旗', '3', 6, 'D', NULL, '1', '026300', '152500');
INSERT INTO `sys_region` VALUES ('152526', '2018-01-30 19:30:19', NULL, NULL, NULL, '西乌珠穆沁旗', '内蒙古自治区锡林郭勒盟西乌珠穆沁旗', '3', 7, 'X', NULL, '1', '026200', '152500');
INSERT INTO `sys_region` VALUES ('152527', '2018-01-30 19:30:19', NULL, NULL, NULL, '太仆寺旗', '内蒙古自治区锡林郭勒盟太仆寺旗', '3', 8, 'T', NULL, '1', '027000', '152500');
INSERT INTO `sys_region` VALUES ('152528', '2018-01-30 19:30:19', NULL, NULL, NULL, '镶黄旗', '内蒙古自治区锡林郭勒盟镶黄旗', '3', 9, 'X', NULL, '1', '013250', '152500');
INSERT INTO `sys_region` VALUES ('152529', '2018-01-30 19:30:19', NULL, NULL, NULL, '正镶白旗', '内蒙古自治区锡林郭勒盟正镶白旗', '3', 10, 'Z', NULL, '1', '013800', '152500');
INSERT INTO `sys_region` VALUES ('152530', '2018-01-30 19:30:19', NULL, NULL, NULL, '正蓝旗', '内蒙古自治区锡林郭勒盟正蓝旗', '3', 11, 'Z', NULL, '1', '027200', '152500');
INSERT INTO `sys_region` VALUES ('152531', '2018-01-30 19:30:19', NULL, NULL, NULL, '多伦县', '内蒙古自治区锡林郭勒盟多伦县', '3', 12, 'D', NULL, '1', '027300', '152500');
INSERT INTO `sys_region` VALUES ('152900', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿拉善盟', '内蒙古自治区阿拉善盟', '2', 12, 'A', NULL, '1', '750306', '150000');
INSERT INTO `sys_region` VALUES ('152921', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿拉善左旗', '内蒙古自治区阿拉善盟阿拉善左旗', '3', 1, 'A', NULL, '1', '750306', '152900');
INSERT INTO `sys_region` VALUES ('152922', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿拉善右旗', '内蒙古自治区阿拉善盟阿拉善右旗', '3', 2, 'A', NULL, '1', '737300', '152900');
INSERT INTO `sys_region` VALUES ('152923', '2018-01-30 19:30:19', NULL, NULL, NULL, '额济纳旗', '内蒙古自治区阿拉善盟额济纳旗', '3', 3, 'E', NULL, '1', '735400', '152900');
INSERT INTO `sys_region` VALUES ('210000', '2018-01-30 19:30:19', NULL, NULL, NULL, '辽宁省', '辽宁省', '1', 6, 'L', NULL, '0', '', '100000');
INSERT INTO `sys_region` VALUES ('210100', '2018-01-30 19:30:19', NULL, NULL, NULL, '沈阳市', '辽宁省沈阳市', '2', 1, 'S', NULL, '1', '110013', '210000');
INSERT INTO `sys_region` VALUES ('210101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省沈阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '210100');
INSERT INTO `sys_region` VALUES ('210102', '2018-01-30 19:30:19', NULL, NULL, NULL, '和平区', '辽宁省沈阳市和平区', '3', 2, 'H', NULL, '1', '110001', '210100');
INSERT INTO `sys_region` VALUES ('210103', '2018-01-30 19:30:19', NULL, NULL, NULL, '沈河区', '辽宁省沈阳市沈河区', '3', 3, 'S', NULL, '1', '110011', '210100');
INSERT INTO `sys_region` VALUES ('210104', '2018-01-30 19:30:19', NULL, NULL, NULL, '大东区', '辽宁省沈阳市大东区', '3', 4, 'D', NULL, '1', '110041', '210100');
INSERT INTO `sys_region` VALUES ('210105', '2018-01-30 19:30:19', NULL, NULL, NULL, '皇姑区', '辽宁省沈阳市皇姑区', '3', 5, 'H', NULL, '1', '110031', '210100');
INSERT INTO `sys_region` VALUES ('210106', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁西区', '辽宁省沈阳市铁西区', '3', 6, 'T', NULL, '1', '110021', '210100');
INSERT INTO `sys_region` VALUES ('210111', '2018-01-30 19:30:19', NULL, NULL, NULL, '苏家屯区', '辽宁省沈阳市苏家屯区', '3', 7, 'S', NULL, '1', '110101', '210100');
INSERT INTO `sys_region` VALUES ('210112', '2018-01-30 19:30:19', NULL, NULL, NULL, '浑南区', '辽宁省沈阳市浑南区', '3', 8, 'H', NULL, '1', '110015', '210100');
INSERT INTO `sys_region` VALUES ('210113', '2018-01-30 19:30:19', NULL, NULL, NULL, '沈北新区', '辽宁省沈阳市沈北新区', '3', 9, 'S', NULL, '1', '110121', '210100');
INSERT INTO `sys_region` VALUES ('210114', '2018-01-30 19:30:19', NULL, NULL, NULL, '于洪区', '辽宁省沈阳市于洪区', '3', 10, 'Y', NULL, '1', '110141', '210100');
INSERT INTO `sys_region` VALUES ('210115', '2018-01-30 19:30:19', NULL, NULL, NULL, '辽中区', '辽宁省沈阳市辽中区', '3', 11, 'L', NULL, '1', NULL, '210100');
INSERT INTO `sys_region` VALUES ('210123', '2018-01-30 19:30:19', NULL, NULL, NULL, '康平县', '辽宁省沈阳市康平县', '3', 12, 'K', NULL, '1', '110500', '210100');
INSERT INTO `sys_region` VALUES ('210124', '2018-01-30 19:30:19', NULL, NULL, NULL, '法库县', '辽宁省沈阳市法库县', '3', 13, 'F', NULL, '1', '110400', '210100');
INSERT INTO `sys_region` VALUES ('210181', '2018-01-30 19:30:19', NULL, NULL, NULL, '新民市', '辽宁省沈阳市新民市', '3', 14, 'X', NULL, '1', '110300', '210100');
INSERT INTO `sys_region` VALUES ('210200', '2018-01-30 19:30:19', NULL, NULL, NULL, '大连市', '辽宁省大连市', '2', 2, 'D', NULL, '1', '116011', '210000');
INSERT INTO `sys_region` VALUES ('210201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省大连市市辖区', '3', 1, 'S', NULL, '1', NULL, '210200');
INSERT INTO `sys_region` VALUES ('210202', '2018-01-30 19:30:19', NULL, NULL, NULL, '中山区', '辽宁省大连市中山区', '3', 2, 'Z', NULL, '1', '116001', '210200');
INSERT INTO `sys_region` VALUES ('210203', '2018-01-30 19:30:19', NULL, NULL, NULL, '西岗区', '辽宁省大连市西岗区', '3', 3, 'X', NULL, '1', '116011', '210200');
INSERT INTO `sys_region` VALUES ('210204', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙河口区', '辽宁省大连市沙河口区', '3', 4, 'S', NULL, '1', '116021', '210200');
INSERT INTO `sys_region` VALUES ('210211', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘井子区', '辽宁省大连市甘井子区', '3', 5, 'G', NULL, '1', '116033', '210200');
INSERT INTO `sys_region` VALUES ('210212', '2018-01-30 19:30:19', NULL, NULL, NULL, '旅顺口区', '辽宁省大连市旅顺口区', '3', 6, 'L', NULL, '1', '116041', '210200');
INSERT INTO `sys_region` VALUES ('210213', '2018-01-30 19:30:19', NULL, NULL, NULL, '金州区', '辽宁省大连市金州区', '3', 7, 'J', NULL, '1', '116100', '210200');
INSERT INTO `sys_region` VALUES ('210214', '2018-01-30 19:30:19', NULL, NULL, NULL, '普兰店区', '辽宁省大连市普兰店区', '3', 8, 'P', NULL, '1', NULL, '210200');
INSERT INTO `sys_region` VALUES ('210224', '2018-01-30 19:30:19', NULL, NULL, NULL, '长海县', '辽宁省大连市长海县', '3', 9, 'C', NULL, '1', '116500', '210200');
INSERT INTO `sys_region` VALUES ('210281', '2018-01-30 19:30:19', NULL, NULL, NULL, '瓦房店市', '辽宁省大连市瓦房店市', '3', 10, 'W', NULL, '1', '116300', '210200');
INSERT INTO `sys_region` VALUES ('210283', '2018-01-30 19:30:19', NULL, NULL, NULL, '庄河市', '辽宁省大连市庄河市', '3', 11, 'Z', NULL, '1', '116400', '210200');
INSERT INTO `sys_region` VALUES ('210300', '2018-01-30 19:30:19', NULL, NULL, NULL, '鞍山市', '辽宁省鞍山市', '2', 3, 'A', NULL, '1', '114001', '210000');
INSERT INTO `sys_region` VALUES ('210301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省鞍山市市辖区', '3', 1, 'S', NULL, '1', NULL, '210300');
INSERT INTO `sys_region` VALUES ('210302', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁东区', '辽宁省鞍山市铁东区', '3', 2, 'T', NULL, '1', '114001', '210300');
INSERT INTO `sys_region` VALUES ('210303', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁西区', '辽宁省鞍山市铁西区', '3', 3, 'T', NULL, '1', '114013', '210300');
INSERT INTO `sys_region` VALUES ('210304', '2018-01-30 19:30:19', NULL, NULL, NULL, '立山区', '辽宁省鞍山市立山区', '3', 4, 'L', NULL, '1', '114031', '210300');
INSERT INTO `sys_region` VALUES ('210311', '2018-01-30 19:30:19', NULL, NULL, NULL, '千山区', '辽宁省鞍山市千山区', '3', 5, 'Q', NULL, '1', '114041', '210300');
INSERT INTO `sys_region` VALUES ('210321', '2018-01-30 19:30:19', NULL, NULL, NULL, '台安县', '辽宁省鞍山市台安县', '3', 6, 'T', NULL, '1', '114100', '210300');
INSERT INTO `sys_region` VALUES ('210323', '2018-01-30 19:30:19', NULL, NULL, NULL, '岫岩满族自治县', '辽宁省鞍山市岫岩满族自治县', '3', 7, 'Z', NULL, '1', '114300', '210300');
INSERT INTO `sys_region` VALUES ('210381', '2018-01-30 19:30:19', NULL, NULL, NULL, '海城市', '辽宁省鞍山市海城市', '3', 8, 'H', NULL, '1', '114200', '210300');
INSERT INTO `sys_region` VALUES ('210400', '2018-01-30 19:30:19', NULL, NULL, NULL, '抚顺市', '辽宁省抚顺市', '2', 4, 'F', NULL, '1', '113008', '210000');
INSERT INTO `sys_region` VALUES ('210401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省抚顺市市辖区', '3', 1, 'S', NULL, '1', NULL, '210400');
INSERT INTO `sys_region` VALUES ('210402', '2018-01-30 19:30:19', NULL, NULL, NULL, '新抚区', '辽宁省抚顺市新抚区', '3', 2, 'X', NULL, '1', '113008', '210400');
INSERT INTO `sys_region` VALUES ('210403', '2018-01-30 19:30:19', NULL, NULL, NULL, '东洲区', '辽宁省抚顺市东洲区', '3', 3, 'D', NULL, '1', '113003', '210400');
INSERT INTO `sys_region` VALUES ('210404', '2018-01-30 19:30:19', NULL, NULL, NULL, '望花区', '辽宁省抚顺市望花区', '3', 4, 'W', NULL, '1', '113001', '210400');
INSERT INTO `sys_region` VALUES ('210411', '2018-01-30 19:30:19', NULL, NULL, NULL, '顺城区', '辽宁省抚顺市顺城区', '3', 5, 'S', NULL, '1', '113006', '210400');
INSERT INTO `sys_region` VALUES ('210421', '2018-01-30 19:30:19', NULL, NULL, NULL, '抚顺县', '辽宁省抚顺市抚顺县', '3', 6, 'F', NULL, '1', '113006', '210400');
INSERT INTO `sys_region` VALUES ('210422', '2018-01-30 19:30:19', NULL, NULL, NULL, '新宾满族自治县', '辽宁省抚顺市新宾满族自治县', '3', 7, 'X', NULL, '1', '113200', '210400');
INSERT INTO `sys_region` VALUES ('210423', '2018-01-30 19:30:19', NULL, NULL, NULL, '清原满族自治县', '辽宁省抚顺市清原满族自治县', '3', 8, 'Q', NULL, '1', '113300', '210400');
INSERT INTO `sys_region` VALUES ('210500', '2018-01-30 19:30:19', NULL, NULL, NULL, '本溪市', '辽宁省本溪市', '2', 5, 'B', NULL, '1', '117000', '210000');
INSERT INTO `sys_region` VALUES ('210501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省本溪市市辖区', '3', 1, 'S', NULL, '1', NULL, '210500');
INSERT INTO `sys_region` VALUES ('210502', '2018-01-30 19:30:19', NULL, NULL, NULL, '平山区', '辽宁省本溪市平山区', '3', 2, 'P', NULL, '1', '117000', '210500');
INSERT INTO `sys_region` VALUES ('210503', '2018-01-30 19:30:19', NULL, NULL, NULL, '溪湖区', '辽宁省本溪市溪湖区', '3', 3, 'X', NULL, '1', '117002', '210500');
INSERT INTO `sys_region` VALUES ('210504', '2018-01-30 19:30:19', NULL, NULL, NULL, '明山区', '辽宁省本溪市明山区', '3', 4, 'M', NULL, '1', '117021', '210500');
INSERT INTO `sys_region` VALUES ('210505', '2018-01-30 19:30:19', NULL, NULL, NULL, '南芬区', '辽宁省本溪市南芬区', '3', 5, 'N', NULL, '1', '117014', '210500');
INSERT INTO `sys_region` VALUES ('210521', '2018-01-30 19:30:19', NULL, NULL, NULL, '本溪满族自治县', '辽宁省本溪市本溪满族自治县', '3', 6, 'B', NULL, '1', '117100', '210500');
INSERT INTO `sys_region` VALUES ('210522', '2018-01-30 19:30:19', NULL, NULL, NULL, '桓仁满族自治县', '辽宁省本溪市桓仁满族自治县', '3', 7, 'H', NULL, '1', '117200', '210500');
INSERT INTO `sys_region` VALUES ('210600', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹东市', '辽宁省丹东市', '2', 6, 'D', NULL, '1', '118000', '210000');
INSERT INTO `sys_region` VALUES ('210601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省丹东市市辖区', '3', 1, 'S', NULL, '1', NULL, '210600');
INSERT INTO `sys_region` VALUES ('210602', '2018-01-30 19:30:19', NULL, NULL, NULL, '元宝区', '辽宁省丹东市元宝区', '3', 2, 'Y', NULL, '1', '118000', '210600');
INSERT INTO `sys_region` VALUES ('210603', '2018-01-30 19:30:19', NULL, NULL, NULL, '振兴区', '辽宁省丹东市振兴区', '3', 3, 'Z', NULL, '1', '118002', '210600');
INSERT INTO `sys_region` VALUES ('210604', '2018-01-30 19:30:19', NULL, NULL, NULL, '振安区', '辽宁省丹东市振安区', '3', 4, 'Z', NULL, '1', '118001', '210600');
INSERT INTO `sys_region` VALUES ('210624', '2018-01-30 19:30:19', NULL, NULL, NULL, '宽甸满族自治县', '辽宁省丹东市宽甸满族自治县', '3', 5, 'K', NULL, '1', '118200', '210600');
INSERT INTO `sys_region` VALUES ('210681', '2018-01-30 19:30:19', NULL, NULL, NULL, '东港市', '辽宁省丹东市东港市', '3', 6, 'D', NULL, '1', '118300', '210600');
INSERT INTO `sys_region` VALUES ('210682', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤城市', '辽宁省丹东市凤城市', '3', 7, 'F', NULL, '1', '118100', '210600');
INSERT INTO `sys_region` VALUES ('210700', '2018-01-30 19:30:19', NULL, NULL, NULL, '锦州市', '辽宁省锦州市', '2', 7, 'J', NULL, '1', '121000', '210000');
INSERT INTO `sys_region` VALUES ('210701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省锦州市市辖区', '3', 1, 'S', NULL, '1', NULL, '210700');
INSERT INTO `sys_region` VALUES ('210702', '2018-01-30 19:30:19', NULL, NULL, NULL, '古塔区', '辽宁省锦州市古塔区', '3', 2, 'G', NULL, '1', '121001', '210700');
INSERT INTO `sys_region` VALUES ('210703', '2018-01-30 19:30:19', NULL, NULL, NULL, '凌河区', '辽宁省锦州市凌河区', '3', 3, 'L', NULL, '1', '121000', '210700');
INSERT INTO `sys_region` VALUES ('210711', '2018-01-30 19:30:19', NULL, NULL, NULL, '太和区', '辽宁省锦州市太和区', '3', 4, 'T', NULL, '1', '121011', '210700');
INSERT INTO `sys_region` VALUES ('210726', '2018-01-30 19:30:19', NULL, NULL, NULL, '黑山县', '辽宁省锦州市黑山县', '3', 5, 'H', NULL, '1', '121400', '210700');
INSERT INTO `sys_region` VALUES ('210727', '2018-01-30 19:30:19', NULL, NULL, NULL, '义县', '辽宁省锦州市义县', '3', 6, 'Y', NULL, '1', '121100', '210700');
INSERT INTO `sys_region` VALUES ('210781', '2018-01-30 19:30:19', NULL, NULL, NULL, '凌海市', '辽宁省锦州市凌海市', '3', 7, 'L', NULL, '1', '121200', '210700');
INSERT INTO `sys_region` VALUES ('210782', '2018-01-30 19:30:19', NULL, NULL, NULL, '北镇市', '辽宁省锦州市北镇市', '3', 8, 'B', NULL, '1', '121300', '210700');
INSERT INTO `sys_region` VALUES ('210800', '2018-01-30 19:30:19', NULL, NULL, NULL, '营口市', '辽宁省营口市', '2', 8, 'Y', NULL, '1', '115003', '210000');
INSERT INTO `sys_region` VALUES ('210801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省营口市市辖区', '3', 1, 'S', NULL, '1', NULL, '210800');
INSERT INTO `sys_region` VALUES ('210802', '2018-01-30 19:30:19', NULL, NULL, NULL, '站前区', '辽宁省营口市站前区', '3', 2, 'Z', NULL, '1', '115002', '210800');
INSERT INTO `sys_region` VALUES ('210803', '2018-01-30 19:30:19', NULL, NULL, NULL, '西市区', '辽宁省营口市西市区', '3', 3, 'X', NULL, '1', '115004', '210800');
INSERT INTO `sys_region` VALUES ('210804', '2018-01-30 19:30:19', NULL, NULL, NULL, '鲅鱼圈区', '辽宁省营口市鲅鱼圈区', '3', 4, 'Z', NULL, '1', '115007', '210800');
INSERT INTO `sys_region` VALUES ('210811', '2018-01-30 19:30:19', NULL, NULL, NULL, '老边区', '辽宁省营口市老边区', '3', 5, 'L', NULL, '1', '115005', '210800');
INSERT INTO `sys_region` VALUES ('210881', '2018-01-30 19:30:19', NULL, NULL, NULL, '盖州市', '辽宁省营口市盖州市', '3', 6, 'G', NULL, '1', '115200', '210800');
INSERT INTO `sys_region` VALUES ('210882', '2018-01-30 19:30:19', NULL, NULL, NULL, '大石桥市', '辽宁省营口市大石桥市', '3', 7, 'D', NULL, '1', '115100', '210800');
INSERT INTO `sys_region` VALUES ('210900', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜新市', '辽宁省阜新市', '2', 9, 'F', NULL, '1', '123000', '210000');
INSERT INTO `sys_region` VALUES ('210901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省阜新市市辖区', '3', 1, 'S', NULL, '1', NULL, '210900');
INSERT INTO `sys_region` VALUES ('210902', '2018-01-30 19:30:19', NULL, NULL, NULL, '海州区', '辽宁省阜新市海州区', '3', 2, 'H', NULL, '1', '123000', '210900');
INSERT INTO `sys_region` VALUES ('210903', '2018-01-30 19:30:19', NULL, NULL, NULL, '新邱区', '辽宁省阜新市新邱区', '3', 3, 'X', NULL, '1', '123005', '210900');
INSERT INTO `sys_region` VALUES ('210904', '2018-01-30 19:30:19', NULL, NULL, NULL, '太平区', '辽宁省阜新市太平区', '3', 4, 'T', NULL, '1', '123003', '210900');
INSERT INTO `sys_region` VALUES ('210905', '2018-01-30 19:30:19', NULL, NULL, NULL, '清河门区', '辽宁省阜新市清河门区', '3', 5, 'Q', NULL, '1', '123006', '210900');
INSERT INTO `sys_region` VALUES ('210911', '2018-01-30 19:30:19', NULL, NULL, NULL, '细河区', '辽宁省阜新市细河区', '3', 6, 'X', NULL, '1', '123000', '210900');
INSERT INTO `sys_region` VALUES ('210921', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜新蒙古族自治县', '辽宁省阜新市阜新蒙古族自治县', '3', 7, 'F', NULL, '1', '123100', '210900');
INSERT INTO `sys_region` VALUES ('210922', '2018-01-30 19:30:19', NULL, NULL, NULL, '彰武县', '辽宁省阜新市彰武县', '3', 8, 'Z', NULL, '1', '123200', '210900');
INSERT INTO `sys_region` VALUES ('211000', '2018-01-30 19:30:19', NULL, NULL, NULL, '辽阳市', '辽宁省辽阳市', '2', 10, 'L', NULL, '1', '111000', '210000');
INSERT INTO `sys_region` VALUES ('211001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省辽阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '211000');
INSERT INTO `sys_region` VALUES ('211002', '2018-01-30 19:30:19', NULL, NULL, NULL, '白塔区', '辽宁省辽阳市白塔区', '3', 2, 'B', NULL, '1', '111000', '211000');
INSERT INTO `sys_region` VALUES ('211003', '2018-01-30 19:30:19', NULL, NULL, NULL, '文圣区', '辽宁省辽阳市文圣区', '3', 3, 'W', NULL, '1', '111000', '211000');
INSERT INTO `sys_region` VALUES ('211004', '2018-01-30 19:30:19', NULL, NULL, NULL, '宏伟区', '辽宁省辽阳市宏伟区', '3', 4, 'H', NULL, '1', '111003', '211000');
INSERT INTO `sys_region` VALUES ('211005', '2018-01-30 19:30:19', NULL, NULL, NULL, '弓长岭区', '辽宁省辽阳市弓长岭区', '3', 5, 'G', NULL, '1', '111008', '211000');
INSERT INTO `sys_region` VALUES ('211011', '2018-01-30 19:30:19', NULL, NULL, NULL, '太子河区', '辽宁省辽阳市太子河区', '3', 6, 'T', NULL, '1', '111000', '211000');
INSERT INTO `sys_region` VALUES ('211021', '2018-01-30 19:30:19', NULL, NULL, NULL, '辽阳县', '辽宁省辽阳市辽阳县', '3', 7, 'L', NULL, '1', '111200', '211000');
INSERT INTO `sys_region` VALUES ('211081', '2018-01-30 19:30:19', NULL, NULL, NULL, '灯塔市', '辽宁省辽阳市灯塔市', '3', 8, 'D', NULL, '1', '111300', '211000');
INSERT INTO `sys_region` VALUES ('211100', '2018-01-30 19:30:19', NULL, NULL, NULL, '盘锦市', '辽宁省盘锦市', '2', 11, 'P', NULL, '1', '124010', '210000');
INSERT INTO `sys_region` VALUES ('211101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省盘锦市市辖区', '3', 1, 'S', NULL, '1', NULL, '211100');
INSERT INTO `sys_region` VALUES ('211102', '2018-01-30 19:30:19', NULL, NULL, NULL, '双台子区', '辽宁省盘锦市双台子区', '3', 2, 'S', NULL, '1', '124000', '211100');
INSERT INTO `sys_region` VALUES ('211103', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴隆台区', '辽宁省盘锦市兴隆台区', '3', 3, 'X', NULL, '1', '124010', '211100');
INSERT INTO `sys_region` VALUES ('211104', '2018-01-30 19:30:19', NULL, NULL, NULL, '大洼区', '辽宁省盘锦市大洼区', '3', 4, 'D', NULL, '1', NULL, '211100');
INSERT INTO `sys_region` VALUES ('211122', '2018-01-30 19:30:19', NULL, NULL, NULL, '盘山县', '辽宁省盘锦市盘山县', '3', 5, 'P', NULL, '1', '124000', '211100');
INSERT INTO `sys_region` VALUES ('211200', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁岭市', '辽宁省铁岭市', '2', 12, 'T', NULL, '1', '112000', '210000');
INSERT INTO `sys_region` VALUES ('211201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省铁岭市市辖区', '3', 1, 'S', NULL, '1', NULL, '211200');
INSERT INTO `sys_region` VALUES ('211202', '2018-01-30 19:30:19', NULL, NULL, NULL, '银州区', '辽宁省铁岭市银州区', '3', 2, 'Y', NULL, '1', '112000', '211200');
INSERT INTO `sys_region` VALUES ('211204', '2018-01-30 19:30:19', NULL, NULL, NULL, '清河区', '辽宁省铁岭市清河区', '3', 3, 'Q', NULL, '1', '112003', '211200');
INSERT INTO `sys_region` VALUES ('211221', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁岭县', '辽宁省铁岭市铁岭县', '3', 4, 'T', NULL, '1', '112000', '211200');
INSERT INTO `sys_region` VALUES ('211223', '2018-01-30 19:30:19', NULL, NULL, NULL, '西丰县', '辽宁省铁岭市西丰县', '3', 5, 'X', NULL, '1', '112400', '211200');
INSERT INTO `sys_region` VALUES ('211224', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌图县', '辽宁省铁岭市昌图县', '3', 6, 'C', NULL, '1', '112500', '211200');
INSERT INTO `sys_region` VALUES ('211281', '2018-01-30 19:30:19', NULL, NULL, NULL, '调兵山市', '辽宁省铁岭市调兵山市', '3', 7, 'D', NULL, '1', '112700', '211200');
INSERT INTO `sys_region` VALUES ('211282', '2018-01-30 19:30:19', NULL, NULL, NULL, '开原市', '辽宁省铁岭市开原市', '3', 8, 'K', NULL, '1', '112300', '211200');
INSERT INTO `sys_region` VALUES ('211300', '2018-01-30 19:30:19', NULL, NULL, NULL, '朝阳市', '辽宁省朝阳市', '2', 13, 'C', NULL, '1', '122000', '210000');
INSERT INTO `sys_region` VALUES ('211301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省朝阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '211300');
INSERT INTO `sys_region` VALUES ('211302', '2018-01-30 19:30:19', NULL, NULL, NULL, '双塔区', '辽宁省朝阳市双塔区', '3', 2, 'S', NULL, '1', '122000', '211300');
INSERT INTO `sys_region` VALUES ('211303', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙城区', '辽宁省朝阳市龙城区', '3', 3, 'L', NULL, '1', '122000', '211300');
INSERT INTO `sys_region` VALUES ('211321', '2018-01-30 19:30:19', NULL, NULL, NULL, '朝阳县', '辽宁省朝阳市朝阳县', '3', 4, 'C', NULL, '1', '122000', '211300');
INSERT INTO `sys_region` VALUES ('211322', '2018-01-30 19:30:19', NULL, NULL, NULL, '建平县', '辽宁省朝阳市建平县', '3', 5, 'J', NULL, '1', '122400', '211300');
INSERT INTO `sys_region` VALUES ('211324', '2018-01-30 19:30:19', NULL, NULL, NULL, '喀喇沁左翼蒙古族自治县', '辽宁省朝阳市喀喇沁左翼蒙古族自治县', '3', 6, 'K', NULL, '1', '122300', '211300');
INSERT INTO `sys_region` VALUES ('211381', '2018-01-30 19:30:19', NULL, NULL, NULL, '北票市', '辽宁省朝阳市北票市', '3', 7, 'B', NULL, '1', '122100', '211300');
INSERT INTO `sys_region` VALUES ('211382', '2018-01-30 19:30:19', NULL, NULL, NULL, '凌源市', '辽宁省朝阳市凌源市', '3', 8, 'L', NULL, '1', '122500', '211300');
INSERT INTO `sys_region` VALUES ('211400', '2018-01-30 19:30:19', NULL, NULL, NULL, '葫芦岛市', '辽宁省葫芦岛市', '2', 14, 'H', NULL, '1', '125000', '210000');
INSERT INTO `sys_region` VALUES ('211401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '辽宁省葫芦岛市市辖区', '3', 1, 'S', NULL, '1', NULL, '211400');
INSERT INTO `sys_region` VALUES ('211402', '2018-01-30 19:30:19', NULL, NULL, NULL, '连山区', '辽宁省葫芦岛市连山区', '3', 2, 'L', NULL, '1', '125001', '211400');
INSERT INTO `sys_region` VALUES ('211403', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙港区', '辽宁省葫芦岛市龙港区', '3', 3, 'L', NULL, '1', '125003', '211400');
INSERT INTO `sys_region` VALUES ('211404', '2018-01-30 19:30:19', NULL, NULL, NULL, '南票区', '辽宁省葫芦岛市南票区', '3', 4, 'N', NULL, '1', '125027', '211400');
INSERT INTO `sys_region` VALUES ('211421', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥中县', '辽宁省葫芦岛市绥中县', '3', 5, 'S', NULL, '1', '125200', '211400');
INSERT INTO `sys_region` VALUES ('211422', '2018-01-30 19:30:19', NULL, NULL, NULL, '建昌县', '辽宁省葫芦岛市建昌县', '3', 6, 'J', NULL, '1', '125300', '211400');
INSERT INTO `sys_region` VALUES ('211481', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴城市', '辽宁省葫芦岛市兴城市', '3', 7, 'X', NULL, '1', '125100', '211400');
INSERT INTO `sys_region` VALUES ('220000', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉林省', '吉林省', '1', 7, 'J', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('220100', '2018-01-30 19:30:19', NULL, NULL, NULL, '长春市', '吉林省长春市', '2', 1, 'C', NULL, '1', '130022', '220000');
INSERT INTO `sys_region` VALUES ('220101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省长春市市辖区', '3', 1, 'S', NULL, '1', NULL, '220100');
INSERT INTO `sys_region` VALUES ('220102', '2018-01-30 19:30:19', NULL, NULL, NULL, '南关区', '吉林省长春市南关区', '3', 2, 'N', NULL, '1', '130022', '220100');
INSERT INTO `sys_region` VALUES ('220103', '2018-01-30 19:30:19', NULL, NULL, NULL, '宽城区', '吉林省长春市宽城区', '3', 3, 'K', NULL, '1', '130051', '220100');
INSERT INTO `sys_region` VALUES ('220104', '2018-01-30 19:30:19', NULL, NULL, NULL, '朝阳区', '吉林省长春市朝阳区', '3', 4, 'C', NULL, '1', '130012', '220100');
INSERT INTO `sys_region` VALUES ('220105', '2018-01-30 19:30:19', NULL, NULL, NULL, '二道区', '吉林省长春市二道区', '3', 5, 'E', NULL, '1', '130031', '220100');
INSERT INTO `sys_region` VALUES ('220106', '2018-01-30 19:30:19', NULL, NULL, NULL, '绿园区', '吉林省长春市绿园区', '3', 6, 'L', NULL, '1', '130062', '220100');
INSERT INTO `sys_region` VALUES ('220112', '2018-01-30 19:30:19', NULL, NULL, NULL, '双阳区', '吉林省长春市双阳区', '3', 7, 'S', NULL, '1', '130600', '220100');
INSERT INTO `sys_region` VALUES ('220113', '2018-01-30 19:30:19', NULL, NULL, NULL, '九台区', '吉林省长春市九台区', '3', 8, 'J', NULL, '1', '130500', '220100');
INSERT INTO `sys_region` VALUES ('220122', '2018-01-30 19:30:19', NULL, NULL, NULL, '农安县', '吉林省长春市农安县', '3', 9, 'N', NULL, '1', '130200', '220100');
INSERT INTO `sys_region` VALUES ('220182', '2018-01-30 19:30:19', NULL, NULL, NULL, '榆树市', '吉林省长春市榆树市', '3', 10, 'Y', NULL, '1', '130400', '220100');
INSERT INTO `sys_region` VALUES ('220183', '2018-01-30 19:30:19', NULL, NULL, NULL, '德惠市', '吉林省长春市德惠市', '3', 11, 'D', NULL, '1', '130300', '220100');
INSERT INTO `sys_region` VALUES ('220200', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉林市', '吉林省吉林市', '2', 2, 'J', NULL, '1', '132011', '220000');
INSERT INTO `sys_region` VALUES ('220201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省吉林市市辖区', '3', 1, 'S', NULL, '1', NULL, '220200');
INSERT INTO `sys_region` VALUES ('220202', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌邑区', '吉林省吉林市昌邑区', '3', 2, 'C', NULL, '1', '132002', '220200');
INSERT INTO `sys_region` VALUES ('220203', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙潭区', '吉林省吉林市龙潭区', '3', 3, 'L', NULL, '1', '132021', '220200');
INSERT INTO `sys_region` VALUES ('220204', '2018-01-30 19:30:19', NULL, NULL, NULL, '船营区', '吉林省吉林市船营区', '3', 4, 'C', NULL, '1', '132011', '220200');
INSERT INTO `sys_region` VALUES ('220211', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰满区', '吉林省吉林市丰满区', '3', 5, 'F', NULL, '1', '132013', '220200');
INSERT INTO `sys_region` VALUES ('220221', '2018-01-30 19:30:19', NULL, NULL, NULL, '永吉县', '吉林省吉林市永吉县', '3', 6, 'Y', NULL, '1', '132200', '220200');
INSERT INTO `sys_region` VALUES ('220281', '2018-01-30 19:30:19', NULL, NULL, NULL, '蛟河市', '吉林省吉林市蛟河市', '3', 7, 'Z', NULL, '1', '132500', '220200');
INSERT INTO `sys_region` VALUES ('220282', '2018-01-30 19:30:19', NULL, NULL, NULL, '桦甸市', '吉林省吉林市桦甸市', '3', 8, 'Z', NULL, '1', '132400', '220200');
INSERT INTO `sys_region` VALUES ('220283', '2018-01-30 19:30:19', NULL, NULL, NULL, '舒兰市', '吉林省吉林市舒兰市', '3', 9, 'S', NULL, '1', '132600', '220200');
INSERT INTO `sys_region` VALUES ('220284', '2018-01-30 19:30:19', NULL, NULL, NULL, '磐石市', '吉林省吉林市磐石市', '3', 10, 'P', NULL, '1', '132300', '220200');
INSERT INTO `sys_region` VALUES ('220300', '2018-01-30 19:30:19', NULL, NULL, NULL, '四平市', '吉林省四平市', '2', 3, 'S', NULL, '1', '136000', '220000');
INSERT INTO `sys_region` VALUES ('220301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省四平市市辖区', '3', 1, 'S', NULL, '1', NULL, '220300');
INSERT INTO `sys_region` VALUES ('220302', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁西区', '吉林省四平市铁西区', '3', 2, 'T', NULL, '1', '136000', '220300');
INSERT INTO `sys_region` VALUES ('220303', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁东区', '吉林省四平市铁东区', '3', 3, 'T', NULL, '1', '136001', '220300');
INSERT INTO `sys_region` VALUES ('220322', '2018-01-30 19:30:19', NULL, NULL, NULL, '梨树县', '吉林省四平市梨树县', '3', 4, 'L', NULL, '1', '136500', '220300');
INSERT INTO `sys_region` VALUES ('220323', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊通满族自治县', '吉林省四平市伊通满族自治县', '3', 5, 'Y', NULL, '1', '130700', '220300');
INSERT INTO `sys_region` VALUES ('220381', '2018-01-30 19:30:19', NULL, NULL, NULL, '公主岭市', '吉林省四平市公主岭市', '3', 6, 'G', NULL, '1', '136100', '220300');
INSERT INTO `sys_region` VALUES ('220382', '2018-01-30 19:30:19', NULL, NULL, NULL, '双辽市', '吉林省四平市双辽市', '3', 7, 'S', NULL, '1', '136400', '220300');
INSERT INTO `sys_region` VALUES ('220400', '2018-01-30 19:30:19', NULL, NULL, NULL, '辽源市', '吉林省辽源市', '2', 4, 'L', NULL, '1', '136200', '220000');
INSERT INTO `sys_region` VALUES ('220401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省辽源市市辖区', '3', 1, 'S', NULL, '1', NULL, '220400');
INSERT INTO `sys_region` VALUES ('220402', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙山区', '吉林省辽源市龙山区', '3', 2, 'L', NULL, '1', '136200', '220400');
INSERT INTO `sys_region` VALUES ('220403', '2018-01-30 19:30:19', NULL, NULL, NULL, '西安区', '吉林省辽源市西安区', '3', 3, 'X', NULL, '1', '136201', '220400');
INSERT INTO `sys_region` VALUES ('220421', '2018-01-30 19:30:19', NULL, NULL, NULL, '东丰县', '吉林省辽源市东丰县', '3', 4, 'D', NULL, '1', '136300', '220400');
INSERT INTO `sys_region` VALUES ('220422', '2018-01-30 19:30:19', NULL, NULL, NULL, '东辽县', '吉林省辽源市东辽县', '3', 5, 'D', NULL, '1', '136600', '220400');
INSERT INTO `sys_region` VALUES ('220500', '2018-01-30 19:30:19', NULL, NULL, NULL, '通化市', '吉林省通化市', '2', 5, 'T', NULL, '1', '134001', '220000');
INSERT INTO `sys_region` VALUES ('220501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省通化市市辖区', '3', 1, 'S', NULL, '1', NULL, '220500');
INSERT INTO `sys_region` VALUES ('220502', '2018-01-30 19:30:19', NULL, NULL, NULL, '东昌区', '吉林省通化市东昌区', '3', 2, 'D', NULL, '1', '134001', '220500');
INSERT INTO `sys_region` VALUES ('220503', '2018-01-30 19:30:19', NULL, NULL, NULL, '二道江区', '吉林省通化市二道江区', '3', 3, 'E', NULL, '1', '134003', '220500');
INSERT INTO `sys_region` VALUES ('220521', '2018-01-30 19:30:19', NULL, NULL, NULL, '通化县', '吉林省通化市通化县', '3', 4, 'T', NULL, '1', '134100', '220500');
INSERT INTO `sys_region` VALUES ('220523', '2018-01-30 19:30:19', NULL, NULL, NULL, '辉南县', '吉林省通化市辉南县', '3', 5, 'H', NULL, '1', '135100', '220500');
INSERT INTO `sys_region` VALUES ('220524', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳河县', '吉林省通化市柳河县', '3', 6, 'L', NULL, '1', '135300', '220500');
INSERT INTO `sys_region` VALUES ('220581', '2018-01-30 19:30:19', NULL, NULL, NULL, '梅河口市', '吉林省通化市梅河口市', '3', 7, 'M', NULL, '1', '135000', '220500');
INSERT INTO `sys_region` VALUES ('220582', '2018-01-30 19:30:19', NULL, NULL, NULL, '集安市', '吉林省通化市集安市', '3', 8, 'J', NULL, '1', '134200', '220500');
INSERT INTO `sys_region` VALUES ('220600', '2018-01-30 19:30:19', NULL, NULL, NULL, '白山市', '吉林省白山市', '2', 6, 'B', NULL, '1', '134300', '220000');
INSERT INTO `sys_region` VALUES ('220601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省白山市市辖区', '3', 1, 'S', NULL, '1', NULL, '220600');
INSERT INTO `sys_region` VALUES ('220602', '2018-01-30 19:30:19', NULL, NULL, NULL, '浑江区', '吉林省白山市浑江区', '3', 2, 'H', NULL, '1', '134300', '220600');
INSERT INTO `sys_region` VALUES ('220605', '2018-01-30 19:30:19', NULL, NULL, NULL, '江源区', '吉林省白山市江源区', '3', 3, 'J', NULL, '1', '134700', '220600');
INSERT INTO `sys_region` VALUES ('220621', '2018-01-30 19:30:19', NULL, NULL, NULL, '抚松县', '吉林省白山市抚松县', '3', 4, 'F', NULL, '1', '134500', '220600');
INSERT INTO `sys_region` VALUES ('220622', '2018-01-30 19:30:19', NULL, NULL, NULL, '靖宇县', '吉林省白山市靖宇县', '3', 5, 'J', NULL, '1', '135200', '220600');
INSERT INTO `sys_region` VALUES ('220623', '2018-01-30 19:30:19', NULL, NULL, NULL, '长白朝鲜族自治县', '吉林省白山市长白朝鲜族自治县', '3', 6, 'C', NULL, '1', '134400', '220600');
INSERT INTO `sys_region` VALUES ('220681', '2018-01-30 19:30:19', NULL, NULL, NULL, '临江市', '吉林省白山市临江市', '3', 7, 'L', NULL, '1', '134600', '220600');
INSERT INTO `sys_region` VALUES ('220700', '2018-01-30 19:30:19', NULL, NULL, NULL, '松原市', '吉林省松原市', '2', 7, 'S', NULL, '1', '138000', '220000');
INSERT INTO `sys_region` VALUES ('220701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省松原市市辖区', '3', 1, 'S', NULL, '1', NULL, '220700');
INSERT INTO `sys_region` VALUES ('220702', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁江区', '吉林省松原市宁江区', '3', 2, 'N', NULL, '1', '138000', '220700');
INSERT INTO `sys_region` VALUES ('220721', '2018-01-30 19:30:19', NULL, NULL, NULL, '前郭尔罗斯蒙古族自治县', '吉林省松原市前郭尔罗斯蒙古族自治县', '3', 3, 'Q', NULL, '1', '138000', '220700');
INSERT INTO `sys_region` VALUES ('220722', '2018-01-30 19:30:19', NULL, NULL, NULL, '长岭县', '吉林省松原市长岭县', '3', 4, 'C', NULL, '1', '131500', '220700');
INSERT INTO `sys_region` VALUES ('220723', '2018-01-30 19:30:19', NULL, NULL, NULL, '乾安县', '吉林省松原市乾安县', '3', 5, 'Q', NULL, '1', '131400', '220700');
INSERT INTO `sys_region` VALUES ('220781', '2018-01-30 19:30:19', NULL, NULL, NULL, '扶余市', '吉林省松原市扶余市', '3', 6, 'F', NULL, '1', '131200', '220700');
INSERT INTO `sys_region` VALUES ('220800', '2018-01-30 19:30:19', NULL, NULL, NULL, '白城市', '吉林省白城市', '2', 8, 'B', NULL, '1', '137000', '220000');
INSERT INTO `sys_region` VALUES ('220801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '吉林省白城市市辖区', '3', 1, 'S', NULL, '1', NULL, '220800');
INSERT INTO `sys_region` VALUES ('220802', '2018-01-30 19:30:19', NULL, NULL, NULL, '洮北区', '吉林省白城市洮北区', '3', 2, 'Z', NULL, '1', '137000', '220800');
INSERT INTO `sys_region` VALUES ('220821', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇赉县', '吉林省白城市镇赉县', '3', 3, 'Z', NULL, '1', '137300', '220800');
INSERT INTO `sys_region` VALUES ('220822', '2018-01-30 19:30:19', NULL, NULL, NULL, '通榆县', '吉林省白城市通榆县', '3', 4, 'T', NULL, '1', '137200', '220800');
INSERT INTO `sys_region` VALUES ('220881', '2018-01-30 19:30:19', NULL, NULL, NULL, '洮南市', '吉林省白城市洮南市', '3', 5, 'Z', NULL, '1', '137100', '220800');
INSERT INTO `sys_region` VALUES ('220882', '2018-01-30 19:30:19', NULL, NULL, NULL, '大安市', '吉林省白城市大安市', '3', 6, 'D', NULL, '1', '131300', '220800');
INSERT INTO `sys_region` VALUES ('222400', '2018-01-30 19:30:19', NULL, NULL, NULL, '延边朝鲜族自治州', '吉林省延边朝鲜族自治州', '2', 9, 'Y', NULL, '1', '133000', '220000');
INSERT INTO `sys_region` VALUES ('222401', '2018-01-30 19:30:19', NULL, NULL, NULL, '延吉市', '吉林省延边朝鲜族自治州延吉市', '3', 1, 'Y', NULL, '1', '133000', '222400');
INSERT INTO `sys_region` VALUES ('222402', '2018-01-30 19:30:19', NULL, NULL, NULL, '图们市', '吉林省延边朝鲜族自治州图们市', '3', 2, 'T', NULL, '1', '133100', '222400');
INSERT INTO `sys_region` VALUES ('222403', '2018-01-30 19:30:19', NULL, NULL, NULL, '敦化市', '吉林省延边朝鲜族自治州敦化市', '3', 3, 'D', NULL, '1', '133700', '222400');
INSERT INTO `sys_region` VALUES ('222404', '2018-01-30 19:30:19', NULL, NULL, NULL, '珲春市', '吉林省延边朝鲜族自治州珲春市', '3', 4, 'Z', NULL, '1', '133300', '222400');
INSERT INTO `sys_region` VALUES ('222405', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙井市', '吉林省延边朝鲜族自治州龙井市', '3', 5, 'L', NULL, '1', '133400', '222400');
INSERT INTO `sys_region` VALUES ('222406', '2018-01-30 19:30:19', NULL, NULL, NULL, '和龙市', '吉林省延边朝鲜族自治州和龙市', '3', 6, 'H', NULL, '1', '133500', '222400');
INSERT INTO `sys_region` VALUES ('222424', '2018-01-30 19:30:19', NULL, NULL, NULL, '汪清县', '吉林省延边朝鲜族自治州汪清县', '3', 7, 'W', NULL, '1', '133200', '222400');
INSERT INTO `sys_region` VALUES ('222426', '2018-01-30 19:30:19', NULL, NULL, NULL, '安图县', '吉林省延边朝鲜族自治州安图县', '3', 8, 'A', NULL, '1', '133600', '222400');
INSERT INTO `sys_region` VALUES ('230000', '2018-01-30 19:30:19', NULL, NULL, NULL, '黑龙江省', '黑龙江省', '1', 8, 'H', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('230100', '2018-01-30 19:30:19', NULL, NULL, NULL, '哈尔滨市', '黑龙江省哈尔滨市', '2', 1, 'H', NULL, '1', '150010', '230000');
INSERT INTO `sys_region` VALUES ('230101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省哈尔滨市市辖区', '3', 1, 'S', NULL, '1', NULL, '230100');
INSERT INTO `sys_region` VALUES ('230102', '2018-01-30 19:30:19', NULL, NULL, NULL, '道里区', '黑龙江省哈尔滨市道里区', '3', 2, 'D', NULL, '1', '150010', '230100');
INSERT INTO `sys_region` VALUES ('230103', '2018-01-30 19:30:19', NULL, NULL, NULL, '南岗区', '黑龙江省哈尔滨市南岗区', '3', 3, 'N', NULL, '1', '150006', '230100');
INSERT INTO `sys_region` VALUES ('230104', '2018-01-30 19:30:19', NULL, NULL, NULL, '道外区', '黑龙江省哈尔滨市道外区', '3', 4, 'D', NULL, '1', '150020', '230100');
INSERT INTO `sys_region` VALUES ('230108', '2018-01-30 19:30:19', NULL, NULL, NULL, '平房区', '黑龙江省哈尔滨市平房区', '3', 5, 'P', NULL, '1', '150060', '230100');
INSERT INTO `sys_region` VALUES ('230109', '2018-01-30 19:30:19', NULL, NULL, NULL, '松北区', '黑龙江省哈尔滨市松北区', '3', 6, 'S', NULL, '1', '150028', '230100');
INSERT INTO `sys_region` VALUES ('230110', '2018-01-30 19:30:19', NULL, NULL, NULL, '香坊区', '黑龙江省哈尔滨市香坊区', '3', 7, 'X', NULL, '1', '150036', '230100');
INSERT INTO `sys_region` VALUES ('230111', '2018-01-30 19:30:19', NULL, NULL, NULL, '呼兰区', '黑龙江省哈尔滨市呼兰区', '3', 8, 'H', NULL, '1', '150500', '230100');
INSERT INTO `sys_region` VALUES ('230112', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿城区', '黑龙江省哈尔滨市阿城区', '3', 9, 'A', NULL, '1', '150300', '230100');
INSERT INTO `sys_region` VALUES ('230113', '2018-01-30 19:30:19', NULL, NULL, NULL, '双城区', '黑龙江省哈尔滨市双城区', '3', 10, 'S', NULL, '1', '150100', '230100');
INSERT INTO `sys_region` VALUES ('230123', '2018-01-30 19:30:19', NULL, NULL, NULL, '依兰县', '黑龙江省哈尔滨市依兰县', '3', 11, 'Y', NULL, '1', '154800', '230100');
INSERT INTO `sys_region` VALUES ('230124', '2018-01-30 19:30:19', NULL, NULL, NULL, '方正县', '黑龙江省哈尔滨市方正县', '3', 12, 'F', NULL, '1', '150800', '230100');
INSERT INTO `sys_region` VALUES ('230125', '2018-01-30 19:30:19', NULL, NULL, NULL, '宾县', '黑龙江省哈尔滨市宾县', '3', 13, 'B', NULL, '1', '150400', '230100');
INSERT INTO `sys_region` VALUES ('230126', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴彦县', '黑龙江省哈尔滨市巴彦县', '3', 14, 'B', NULL, '1', '151800', '230100');
INSERT INTO `sys_region` VALUES ('230127', '2018-01-30 19:30:19', NULL, NULL, NULL, '木兰县', '黑龙江省哈尔滨市木兰县', '3', 15, 'M', NULL, '1', '151900', '230100');
INSERT INTO `sys_region` VALUES ('230128', '2018-01-30 19:30:19', NULL, NULL, NULL, '通河县', '黑龙江省哈尔滨市通河县', '3', 16, 'T', NULL, '1', '150900', '230100');
INSERT INTO `sys_region` VALUES ('230129', '2018-01-30 19:30:19', NULL, NULL, NULL, '延寿县', '黑龙江省哈尔滨市延寿县', '3', 17, 'Y', NULL, '1', '150700', '230100');
INSERT INTO `sys_region` VALUES ('230183', '2018-01-30 19:30:19', NULL, NULL, NULL, '尚志市', '黑龙江省哈尔滨市尚志市', '3', 18, 'S', NULL, '1', '150600', '230100');
INSERT INTO `sys_region` VALUES ('230184', '2018-01-30 19:30:19', NULL, NULL, NULL, '五常市', '黑龙江省哈尔滨市五常市', '3', 19, 'W', NULL, '1', '150200', '230100');
INSERT INTO `sys_region` VALUES ('230200', '2018-01-30 19:30:19', NULL, NULL, NULL, '齐齐哈尔市', '黑龙江省齐齐哈尔市', '2', 2, 'Q', NULL, '1', '161005', '230000');
INSERT INTO `sys_region` VALUES ('230201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省齐齐哈尔市市辖区', '3', 1, 'S', NULL, '1', NULL, '230200');
INSERT INTO `sys_region` VALUES ('230202', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙沙区', '黑龙江省齐齐哈尔市龙沙区', '3', 2, 'L', NULL, '1', '161000', '230200');
INSERT INTO `sys_region` VALUES ('230203', '2018-01-30 19:30:19', NULL, NULL, NULL, '建华区', '黑龙江省齐齐哈尔市建华区', '3', 3, 'J', NULL, '1', '161006', '230200');
INSERT INTO `sys_region` VALUES ('230204', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁锋区', '黑龙江省齐齐哈尔市铁锋区', '3', 4, 'T', NULL, '1', '161000', '230200');
INSERT INTO `sys_region` VALUES ('230205', '2018-01-30 19:30:19', NULL, NULL, NULL, '昂昂溪区', '黑龙江省齐齐哈尔市昂昂溪区', '3', 5, 'A', NULL, '1', '161031', '230200');
INSERT INTO `sys_region` VALUES ('230206', '2018-01-30 19:30:19', NULL, NULL, NULL, '富拉尔基区', '黑龙江省齐齐哈尔市富拉尔基区', '3', 6, 'F', NULL, '1', '161041', '230200');
INSERT INTO `sys_region` VALUES ('230207', '2018-01-30 19:30:19', NULL, NULL, NULL, '碾子山区', '黑龙江省齐齐哈尔市碾子山区', '3', 7, 'N', NULL, '1', '161046', '230200');
INSERT INTO `sys_region` VALUES ('230208', '2018-01-30 19:30:19', NULL, NULL, NULL, '梅里斯达斡尔族区', '黑龙江省齐齐哈尔市梅里斯达斡尔族区', '3', 8, 'M', NULL, '1', '161021', '230200');
INSERT INTO `sys_region` VALUES ('230221', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙江县', '黑龙江省齐齐哈尔市龙江县', '3', 9, 'L', NULL, '1', '161100', '230200');
INSERT INTO `sys_region` VALUES ('230223', '2018-01-30 19:30:19', NULL, NULL, NULL, '依安县', '黑龙江省齐齐哈尔市依安县', '3', 10, 'Y', NULL, '1', '161500', '230200');
INSERT INTO `sys_region` VALUES ('230224', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰来县', '黑龙江省齐齐哈尔市泰来县', '3', 11, 'T', NULL, '1', '162400', '230200');
INSERT INTO `sys_region` VALUES ('230225', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘南县', '黑龙江省齐齐哈尔市甘南县', '3', 12, 'G', NULL, '1', '162100', '230200');
INSERT INTO `sys_region` VALUES ('230227', '2018-01-30 19:30:19', NULL, NULL, NULL, '富裕县', '黑龙江省齐齐哈尔市富裕县', '3', 13, 'F', NULL, '1', '161200', '230200');
INSERT INTO `sys_region` VALUES ('230229', '2018-01-30 19:30:19', NULL, NULL, NULL, '克山县', '黑龙江省齐齐哈尔市克山县', '3', 14, 'K', NULL, '1', '161600', '230200');
INSERT INTO `sys_region` VALUES ('230230', '2018-01-30 19:30:19', NULL, NULL, NULL, '克东县', '黑龙江省齐齐哈尔市克东县', '3', 15, 'K', NULL, '1', '164800', '230200');
INSERT INTO `sys_region` VALUES ('230231', '2018-01-30 19:30:19', NULL, NULL, NULL, '拜泉县', '黑龙江省齐齐哈尔市拜泉县', '3', 16, 'B', NULL, '1', '164700', '230200');
INSERT INTO `sys_region` VALUES ('230281', '2018-01-30 19:30:19', NULL, NULL, NULL, '讷河市', '黑龙江省齐齐哈尔市讷河市', '3', 17, 'Z', NULL, '1', '161300', '230200');
INSERT INTO `sys_region` VALUES ('230300', '2018-01-30 19:30:19', NULL, NULL, NULL, '鸡西市', '黑龙江省鸡西市', '2', 3, 'J', NULL, '1', '158100', '230000');
INSERT INTO `sys_region` VALUES ('230301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省鸡西市市辖区', '3', 1, 'S', NULL, '1', NULL, '230300');
INSERT INTO `sys_region` VALUES ('230302', '2018-01-30 19:30:19', NULL, NULL, NULL, '鸡冠区', '黑龙江省鸡西市鸡冠区', '3', 2, 'J', NULL, '1', '158100', '230300');
INSERT INTO `sys_region` VALUES ('230303', '2018-01-30 19:30:19', NULL, NULL, NULL, '恒山区', '黑龙江省鸡西市恒山区', '3', 3, 'H', NULL, '1', '158130', '230300');
INSERT INTO `sys_region` VALUES ('230304', '2018-01-30 19:30:19', NULL, NULL, NULL, '滴道区', '黑龙江省鸡西市滴道区', '3', 4, 'D', NULL, '1', '158150', '230300');
INSERT INTO `sys_region` VALUES ('230305', '2018-01-30 19:30:19', NULL, NULL, NULL, '梨树区', '黑龙江省鸡西市梨树区', '3', 5, 'L', NULL, '1', '158160', '230300');
INSERT INTO `sys_region` VALUES ('230306', '2018-01-30 19:30:19', NULL, NULL, NULL, '城子河区', '黑龙江省鸡西市城子河区', '3', 6, 'C', NULL, '1', '158170', '230300');
INSERT INTO `sys_region` VALUES ('230307', '2018-01-30 19:30:19', NULL, NULL, NULL, '麻山区', '黑龙江省鸡西市麻山区', '3', 7, 'M', NULL, '1', '158180', '230300');
INSERT INTO `sys_region` VALUES ('230321', '2018-01-30 19:30:19', NULL, NULL, NULL, '鸡东县', '黑龙江省鸡西市鸡东县', '3', 8, 'J', NULL, '1', '158200', '230300');
INSERT INTO `sys_region` VALUES ('230381', '2018-01-30 19:30:19', NULL, NULL, NULL, '虎林市', '黑龙江省鸡西市虎林市', '3', 9, 'H', NULL, '1', '158400', '230300');
INSERT INTO `sys_region` VALUES ('230382', '2018-01-30 19:30:19', NULL, NULL, NULL, '密山市', '黑龙江省鸡西市密山市', '3', 10, 'M', NULL, '1', '158300', '230300');
INSERT INTO `sys_region` VALUES ('230400', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹤岗市', '黑龙江省鹤岗市', '2', 4, 'H', NULL, '1', '154100', '230000');
INSERT INTO `sys_region` VALUES ('230401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省鹤岗市市辖区', '3', 1, 'S', NULL, '1', NULL, '230400');
INSERT INTO `sys_region` VALUES ('230402', '2018-01-30 19:30:19', NULL, NULL, NULL, '向阳区', '黑龙江省鹤岗市向阳区', '3', 2, 'X', NULL, '1', '154100', '230400');
INSERT INTO `sys_region` VALUES ('230403', '2018-01-30 19:30:19', NULL, NULL, NULL, '工农区', '黑龙江省鹤岗市工农区', '3', 3, 'G', NULL, '1', '154101', '230400');
INSERT INTO `sys_region` VALUES ('230404', '2018-01-30 19:30:19', NULL, NULL, NULL, '南山区', '黑龙江省鹤岗市南山区', '3', 4, 'N', NULL, '1', '154104', '230400');
INSERT INTO `sys_region` VALUES ('230405', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴安区', '黑龙江省鹤岗市兴安区', '3', 5, 'X', NULL, '1', '154102', '230400');
INSERT INTO `sys_region` VALUES ('230406', '2018-01-30 19:30:19', NULL, NULL, NULL, '东山区', '黑龙江省鹤岗市东山区', '3', 6, 'D', NULL, '1', '154106', '230400');
INSERT INTO `sys_region` VALUES ('230407', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴山区', '黑龙江省鹤岗市兴山区', '3', 7, 'X', NULL, '1', '154105', '230400');
INSERT INTO `sys_region` VALUES ('230421', '2018-01-30 19:30:19', NULL, NULL, NULL, '萝北县', '黑龙江省鹤岗市萝北县', '3', 8, 'L', NULL, '1', '154200', '230400');
INSERT INTO `sys_region` VALUES ('230422', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥滨县', '黑龙江省鹤岗市绥滨县', '3', 9, 'S', NULL, '1', '156200', '230400');
INSERT INTO `sys_region` VALUES ('230500', '2018-01-30 19:30:19', NULL, NULL, NULL, '双鸭山市', '黑龙江省双鸭山市', '2', 5, 'S', NULL, '1', '155100', '230000');
INSERT INTO `sys_region` VALUES ('230501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省双鸭山市市辖区', '3', 1, 'S', NULL, '1', NULL, '230500');
INSERT INTO `sys_region` VALUES ('230502', '2018-01-30 19:30:19', NULL, NULL, NULL, '尖山区', '黑龙江省双鸭山市尖山区', '3', 2, 'J', NULL, '1', '155100', '230500');
INSERT INTO `sys_region` VALUES ('230503', '2018-01-30 19:30:19', NULL, NULL, NULL, '岭东区', '黑龙江省双鸭山市岭东区', '3', 3, 'L', NULL, '1', '155120', '230500');
INSERT INTO `sys_region` VALUES ('230505', '2018-01-30 19:30:19', NULL, NULL, NULL, '四方台区', '黑龙江省双鸭山市四方台区', '3', 4, 'S', NULL, '1', '155130', '230500');
INSERT INTO `sys_region` VALUES ('230506', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝山区', '黑龙江省双鸭山市宝山区', '3', 5, 'B', NULL, '1', '155131', '230500');
INSERT INTO `sys_region` VALUES ('230521', '2018-01-30 19:30:19', NULL, NULL, NULL, '集贤县', '黑龙江省双鸭山市集贤县', '3', 6, 'J', NULL, '1', '155900', '230500');
INSERT INTO `sys_region` VALUES ('230522', '2018-01-30 19:30:19', NULL, NULL, NULL, '友谊县', '黑龙江省双鸭山市友谊县', '3', 7, 'Y', NULL, '1', '155800', '230500');
INSERT INTO `sys_region` VALUES ('230523', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝清县', '黑龙江省双鸭山市宝清县', '3', 8, 'B', NULL, '1', '155600', '230500');
INSERT INTO `sys_region` VALUES ('230524', '2018-01-30 19:30:19', NULL, NULL, NULL, '饶河县', '黑龙江省双鸭山市饶河县', '3', 9, 'R', NULL, '1', '155700', '230500');
INSERT INTO `sys_region` VALUES ('230600', '2018-01-30 19:30:19', NULL, NULL, NULL, '大庆市', '黑龙江省大庆市', '2', 6, 'D', NULL, '1', '163000', '230000');
INSERT INTO `sys_region` VALUES ('230601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省大庆市市辖区', '3', 1, 'S', NULL, '1', NULL, '230600');
INSERT INTO `sys_region` VALUES ('230602', '2018-01-30 19:30:19', NULL, NULL, NULL, '萨尔图区', '黑龙江省大庆市萨尔图区', '3', 2, 'S', NULL, '1', '163001', '230600');
INSERT INTO `sys_region` VALUES ('230603', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙凤区', '黑龙江省大庆市龙凤区', '3', 3, 'L', NULL, '1', '163711', '230600');
INSERT INTO `sys_region` VALUES ('230604', '2018-01-30 19:30:19', NULL, NULL, NULL, '让胡路区', '黑龙江省大庆市让胡路区', '3', 4, 'R', NULL, '1', '163712', '230600');
INSERT INTO `sys_region` VALUES ('230605', '2018-01-30 19:30:19', NULL, NULL, NULL, '红岗区', '黑龙江省大庆市红岗区', '3', 5, 'H', NULL, '1', '163511', '230600');
INSERT INTO `sys_region` VALUES ('230606', '2018-01-30 19:30:19', NULL, NULL, NULL, '大同区', '黑龙江省大庆市大同区', '3', 6, 'D', NULL, '1', '163515', '230600');
INSERT INTO `sys_region` VALUES ('230621', '2018-01-30 19:30:19', NULL, NULL, NULL, '肇州县', '黑龙江省大庆市肇州县', '3', 7, 'Z', NULL, '1', '166400', '230600');
INSERT INTO `sys_region` VALUES ('230622', '2018-01-30 19:30:19', NULL, NULL, NULL, '肇源县', '黑龙江省大庆市肇源县', '3', 8, 'Z', NULL, '1', '166500', '230600');
INSERT INTO `sys_region` VALUES ('230623', '2018-01-30 19:30:19', NULL, NULL, NULL, '林甸县', '黑龙江省大庆市林甸县', '3', 9, 'L', NULL, '1', '166300', '230600');
INSERT INTO `sys_region` VALUES ('230624', '2018-01-30 19:30:19', NULL, NULL, NULL, '杜尔伯特蒙古族自治县', '黑龙江省大庆市杜尔伯特蒙古族自治县', '3', 10, 'D', NULL, '1', '166200', '230600');
INSERT INTO `sys_region` VALUES ('230700', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊春市', '黑龙江省伊春市', '2', 7, 'Y', NULL, '1', '153000', '230000');
INSERT INTO `sys_region` VALUES ('230701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省伊春市市辖区', '3', 1, 'S', NULL, '1', NULL, '230700');
INSERT INTO `sys_region` VALUES ('230702', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊春区', '黑龙江省伊春市伊春区', '3', 2, 'Y', NULL, '1', '153000', '230700');
INSERT INTO `sys_region` VALUES ('230703', '2018-01-30 19:30:19', NULL, NULL, NULL, '南岔区', '黑龙江省伊春市南岔区', '3', 3, 'N', NULL, '1', '153100', '230700');
INSERT INTO `sys_region` VALUES ('230704', '2018-01-30 19:30:19', NULL, NULL, NULL, '友好区', '黑龙江省伊春市友好区', '3', 4, 'Y', NULL, '1', '153031', '230700');
INSERT INTO `sys_region` VALUES ('230705', '2018-01-30 19:30:19', NULL, NULL, NULL, '西林区', '黑龙江省伊春市西林区', '3', 5, 'X', NULL, '1', '153025', '230700');
INSERT INTO `sys_region` VALUES ('230706', '2018-01-30 19:30:19', NULL, NULL, NULL, '翠峦区', '黑龙江省伊春市翠峦区', '3', 6, 'C', NULL, '1', '153013', '230700');
INSERT INTO `sys_region` VALUES ('230707', '2018-01-30 19:30:19', NULL, NULL, NULL, '新青区', '黑龙江省伊春市新青区', '3', 7, 'X', NULL, '1', '153036', '230700');
INSERT INTO `sys_region` VALUES ('230708', '2018-01-30 19:30:19', NULL, NULL, NULL, '美溪区', '黑龙江省伊春市美溪区', '3', 8, 'M', NULL, '1', '153021', '230700');
INSERT INTO `sys_region` VALUES ('230709', '2018-01-30 19:30:19', NULL, NULL, NULL, '金山屯区', '黑龙江省伊春市金山屯区', '3', 9, 'J', NULL, '1', '153026', '230700');
INSERT INTO `sys_region` VALUES ('230710', '2018-01-30 19:30:19', NULL, NULL, NULL, '五营区', '黑龙江省伊春市五营区', '3', 10, 'W', NULL, '1', '153033', '230700');
INSERT INTO `sys_region` VALUES ('230711', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌马河区', '黑龙江省伊春市乌马河区', '3', 11, 'W', NULL, '1', '153011', '230700');
INSERT INTO `sys_region` VALUES ('230712', '2018-01-30 19:30:19', NULL, NULL, NULL, '汤旺河区', '黑龙江省伊春市汤旺河区', '3', 12, 'T', NULL, '1', '153037', '230700');
INSERT INTO `sys_region` VALUES ('230713', '2018-01-30 19:30:19', NULL, NULL, NULL, '带岭区', '黑龙江省伊春市带岭区', '3', 13, 'D', NULL, '1', '153106', '230700');
INSERT INTO `sys_region` VALUES ('230714', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌伊岭区', '黑龙江省伊春市乌伊岭区', '3', 14, 'W', NULL, '1', '153038', '230700');
INSERT INTO `sys_region` VALUES ('230715', '2018-01-30 19:30:19', NULL, NULL, NULL, '红星区', '黑龙江省伊春市红星区', '3', 15, 'H', NULL, '1', '153035', '230700');
INSERT INTO `sys_region` VALUES ('230716', '2018-01-30 19:30:19', NULL, NULL, NULL, '上甘岭区', '黑龙江省伊春市上甘岭区', '3', 16, 'S', NULL, '1', '153032', '230700');
INSERT INTO `sys_region` VALUES ('230722', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉荫县', '黑龙江省伊春市嘉荫县', '3', 17, 'J', NULL, '1', '153200', '230700');
INSERT INTO `sys_region` VALUES ('230781', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁力市', '黑龙江省伊春市铁力市', '3', 18, 'T', NULL, '1', '152500', '230700');
INSERT INTO `sys_region` VALUES ('230800', '2018-01-30 19:30:19', NULL, NULL, NULL, '佳木斯市', '黑龙江省佳木斯市', '2', 8, 'J', NULL, '1', '154002', '230000');
INSERT INTO `sys_region` VALUES ('230801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省佳木斯市市辖区', '3', 1, 'S', NULL, '1', NULL, '230800');
INSERT INTO `sys_region` VALUES ('230803', '2018-01-30 19:30:19', NULL, NULL, NULL, '向阳区', '黑龙江省佳木斯市向阳区', '3', 2, 'X', NULL, '1', '154002', '230800');
INSERT INTO `sys_region` VALUES ('230804', '2018-01-30 19:30:19', NULL, NULL, NULL, '前进区', '黑龙江省佳木斯市前进区', '3', 3, 'Q', NULL, '1', '154002', '230800');
INSERT INTO `sys_region` VALUES ('230805', '2018-01-30 19:30:19', NULL, NULL, NULL, '东风区', '黑龙江省佳木斯市东风区', '3', 4, 'D', NULL, '1', '154005', '230800');
INSERT INTO `sys_region` VALUES ('230811', '2018-01-30 19:30:19', NULL, NULL, NULL, '郊区', '黑龙江省佳木斯市郊区', '3', 5, 'J', NULL, '1', '154004', '230800');
INSERT INTO `sys_region` VALUES ('230822', '2018-01-30 19:30:19', NULL, NULL, NULL, '桦南县', '黑龙江省佳木斯市桦南县', '3', 6, 'Z', NULL, '1', '154400', '230800');
INSERT INTO `sys_region` VALUES ('230826', '2018-01-30 19:30:19', NULL, NULL, NULL, '桦川县', '黑龙江省佳木斯市桦川县', '3', 7, 'Z', NULL, '1', '154300', '230800');
INSERT INTO `sys_region` VALUES ('230828', '2018-01-30 19:30:19', NULL, NULL, NULL, '汤原县', '黑龙江省佳木斯市汤原县', '3', 8, 'T', NULL, '1', '154700', '230800');
INSERT INTO `sys_region` VALUES ('230881', '2018-01-30 19:30:19', NULL, NULL, NULL, '同江市', '黑龙江省佳木斯市同江市', '3', 9, 'T', NULL, '1', '156400', '230800');
INSERT INTO `sys_region` VALUES ('230882', '2018-01-30 19:30:19', NULL, NULL, NULL, '富锦市', '黑龙江省佳木斯市富锦市', '3', 10, 'F', NULL, '1', '156100', '230800');
INSERT INTO `sys_region` VALUES ('230883', '2018-01-30 19:30:19', NULL, NULL, NULL, '抚远市', '黑龙江省佳木斯市抚远市', '3', 11, 'F', NULL, '1', NULL, '230800');
INSERT INTO `sys_region` VALUES ('230900', '2018-01-30 19:30:19', NULL, NULL, NULL, '七台河市', '黑龙江省七台河市', '2', 9, 'Q', NULL, '1', '154600', '230000');
INSERT INTO `sys_region` VALUES ('230901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省七台河市市辖区', '3', 1, 'S', NULL, '1', NULL, '230900');
INSERT INTO `sys_region` VALUES ('230902', '2018-01-30 19:30:19', NULL, NULL, NULL, '新兴区', '黑龙江省七台河市新兴区', '3', 2, 'X', NULL, '1', '154604', '230900');
INSERT INTO `sys_region` VALUES ('230903', '2018-01-30 19:30:19', NULL, NULL, NULL, '桃山区', '黑龙江省七台河市桃山区', '3', 3, 'T', NULL, '1', '154600', '230900');
INSERT INTO `sys_region` VALUES ('230904', '2018-01-30 19:30:19', NULL, NULL, NULL, '茄子河区', '黑龙江省七台河市茄子河区', '3', 4, 'Q', NULL, '1', '154622', '230900');
INSERT INTO `sys_region` VALUES ('230921', '2018-01-30 19:30:19', NULL, NULL, NULL, '勃利县', '黑龙江省七台河市勃利县', '3', 5, 'B', NULL, '1', '154500', '230900');
INSERT INTO `sys_region` VALUES ('231000', '2018-01-30 19:30:19', NULL, NULL, NULL, '牡丹江市', '黑龙江省牡丹江市', '2', 10, 'M', NULL, '1', '157000', '230000');
INSERT INTO `sys_region` VALUES ('231001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省牡丹江市市辖区', '3', 1, 'S', NULL, '1', NULL, '231000');
INSERT INTO `sys_region` VALUES ('231002', '2018-01-30 19:30:19', NULL, NULL, NULL, '东安区', '黑龙江省牡丹江市东安区', '3', 2, 'D', NULL, '1', '157000', '231000');
INSERT INTO `sys_region` VALUES ('231003', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳明区', '黑龙江省牡丹江市阳明区', '3', 3, 'Y', NULL, '1', '157013', '231000');
INSERT INTO `sys_region` VALUES ('231004', '2018-01-30 19:30:19', NULL, NULL, NULL, '爱民区', '黑龙江省牡丹江市爱民区', '3', 4, 'A', NULL, '1', '157009', '231000');
INSERT INTO `sys_region` VALUES ('231005', '2018-01-30 19:30:19', NULL, NULL, NULL, '西安区', '黑龙江省牡丹江市西安区', '3', 5, 'X', NULL, '1', '157000', '231000');
INSERT INTO `sys_region` VALUES ('231025', '2018-01-30 19:30:19', NULL, NULL, NULL, '林口县', '黑龙江省牡丹江市林口县', '3', 6, 'L', NULL, '1', '157600', '231000');
INSERT INTO `sys_region` VALUES ('231081', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥芬河市', '黑龙江省牡丹江市绥芬河市', '3', 7, 'S', NULL, '1', '157300', '231000');
INSERT INTO `sys_region` VALUES ('231083', '2018-01-30 19:30:19', NULL, NULL, NULL, '海林市', '黑龙江省牡丹江市海林市', '3', 8, 'H', NULL, '1', '157100', '231000');
INSERT INTO `sys_region` VALUES ('231084', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁安市', '黑龙江省牡丹江市宁安市', '3', 9, 'N', NULL, '1', '157400', '231000');
INSERT INTO `sys_region` VALUES ('231085', '2018-01-30 19:30:19', NULL, NULL, NULL, '穆棱市', '黑龙江省牡丹江市穆棱市', '3', 10, 'M', NULL, '1', '157500', '231000');
INSERT INTO `sys_region` VALUES ('231086', '2018-01-30 19:30:19', NULL, NULL, NULL, '东宁市', '黑龙江省牡丹江市东宁市', '3', 11, 'D', NULL, '1', NULL, '231000');
INSERT INTO `sys_region` VALUES ('231100', '2018-01-30 19:30:19', NULL, NULL, NULL, '黑河市', '黑龙江省黑河市', '2', 11, 'H', NULL, '1', '164300', '230000');
INSERT INTO `sys_region` VALUES ('231101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省黑河市市辖区', '3', 1, 'S', NULL, '1', NULL, '231100');
INSERT INTO `sys_region` VALUES ('231102', '2018-01-30 19:30:19', NULL, NULL, NULL, '爱辉区', '黑龙江省黑河市爱辉区', '3', 2, 'A', NULL, '1', '164300', '231100');
INSERT INTO `sys_region` VALUES ('231121', '2018-01-30 19:30:19', NULL, NULL, NULL, '嫩江县', '黑龙江省黑河市嫩江县', '3', 3, 'N', NULL, '1', '161400', '231100');
INSERT INTO `sys_region` VALUES ('231123', '2018-01-30 19:30:19', NULL, NULL, NULL, '逊克县', '黑龙江省黑河市逊克县', '3', 4, 'X', NULL, '1', '164400', '231100');
INSERT INTO `sys_region` VALUES ('231124', '2018-01-30 19:30:19', NULL, NULL, NULL, '孙吴县', '黑龙江省黑河市孙吴县', '3', 5, 'S', NULL, '1', '164200', '231100');
INSERT INTO `sys_region` VALUES ('231181', '2018-01-30 19:30:19', NULL, NULL, NULL, '北安市', '黑龙江省黑河市北安市', '3', 6, 'B', NULL, '1', '164000', '231100');
INSERT INTO `sys_region` VALUES ('231182', '2018-01-30 19:30:19', NULL, NULL, NULL, '五大连池市', '黑龙江省黑河市五大连池市', '3', 7, 'W', NULL, '1', '164100', '231100');
INSERT INTO `sys_region` VALUES ('231200', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥化市', '黑龙江省绥化市', '2', 12, 'S', NULL, '1', '152000', '230000');
INSERT INTO `sys_region` VALUES ('231201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '黑龙江省绥化市市辖区', '3', 1, 'S', NULL, '1', NULL, '231200');
INSERT INTO `sys_region` VALUES ('231202', '2018-01-30 19:30:19', NULL, NULL, NULL, '北林区', '黑龙江省绥化市北林区', '3', 2, 'B', NULL, '1', '152000', '231200');
INSERT INTO `sys_region` VALUES ('231221', '2018-01-30 19:30:19', NULL, NULL, NULL, '望奎县', '黑龙江省绥化市望奎县', '3', 3, 'W', NULL, '1', '152100', '231200');
INSERT INTO `sys_region` VALUES ('231222', '2018-01-30 19:30:19', NULL, NULL, NULL, '兰西县', '黑龙江省绥化市兰西县', '3', 4, 'L', NULL, '1', '151500', '231200');
INSERT INTO `sys_region` VALUES ('231223', '2018-01-30 19:30:19', NULL, NULL, NULL, '青冈县', '黑龙江省绥化市青冈县', '3', 5, 'Q', NULL, '1', '151600', '231200');
INSERT INTO `sys_region` VALUES ('231224', '2018-01-30 19:30:19', NULL, NULL, NULL, '庆安县', '黑龙江省绥化市庆安县', '3', 6, 'Q', NULL, '1', '152400', '231200');
INSERT INTO `sys_region` VALUES ('231225', '2018-01-30 19:30:19', NULL, NULL, NULL, '明水县', '黑龙江省绥化市明水县', '3', 7, 'M', NULL, '1', '151700', '231200');
INSERT INTO `sys_region` VALUES ('231226', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥棱县', '黑龙江省绥化市绥棱县', '3', 8, 'S', NULL, '1', '152200', '231200');
INSERT INTO `sys_region` VALUES ('231281', '2018-01-30 19:30:19', NULL, NULL, NULL, '安达市', '黑龙江省绥化市安达市', '3', 9, 'A', NULL, '1', '151400', '231200');
INSERT INTO `sys_region` VALUES ('231282', '2018-01-30 19:30:19', NULL, NULL, NULL, '肇东市', '黑龙江省绥化市肇东市', '3', 10, 'Z', NULL, '1', '151100', '231200');
INSERT INTO `sys_region` VALUES ('231283', '2018-01-30 19:30:19', NULL, NULL, NULL, '海伦市', '黑龙江省绥化市海伦市', '3', 11, 'H', NULL, '1', '152300', '231200');
INSERT INTO `sys_region` VALUES ('232700', '2018-01-30 19:30:19', NULL, NULL, NULL, '大兴安岭地区', '黑龙江省大兴安岭地区', '2', 13, 'D', NULL, '1', '165000', '230000');
INSERT INTO `sys_region` VALUES ('232721', '2018-01-30 19:30:19', NULL, NULL, NULL, '呼玛县', '黑龙江省大兴安岭地区呼玛县', '3', 1, 'H', NULL, '1', '165100', '232700');
INSERT INTO `sys_region` VALUES ('232722', '2018-01-30 19:30:19', NULL, NULL, NULL, '塔河县', '黑龙江省大兴安岭地区塔河县', '3', 2, 'T', NULL, '1', '165200', '232700');
INSERT INTO `sys_region` VALUES ('232723', '2018-01-30 19:30:19', NULL, NULL, NULL, '漠河县', '黑龙江省大兴安岭地区漠河县', '3', 3, 'M', NULL, '1', '165300', '232700');
INSERT INTO `sys_region` VALUES ('310000', '2018-01-30 19:30:19', NULL, NULL, NULL, '上海市', '上海市', '1', 9, 'S', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('310100', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '上海市市辖区', '2', 1, 'S', NULL, '1', '200000', '310000');
INSERT INTO `sys_region` VALUES ('310101', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄浦区', '上海市市辖区黄浦区', '3', 1, 'H', NULL, '1', '200001', '310100');
INSERT INTO `sys_region` VALUES ('310104', '2018-01-30 19:30:19', NULL, NULL, NULL, '徐汇区', '上海市市辖区徐汇区', '3', 2, 'X', NULL, '1', '200030', '310100');
INSERT INTO `sys_region` VALUES ('310105', '2018-01-30 19:30:19', NULL, NULL, NULL, '长宁区', '上海市市辖区长宁区', '3', 3, 'C', NULL, '1', '200050', '310100');
INSERT INTO `sys_region` VALUES ('310106', '2018-01-30 19:30:19', NULL, NULL, NULL, '静安区', '上海市市辖区静安区', '3', 4, 'J', NULL, '1', '200040', '310100');
INSERT INTO `sys_region` VALUES ('310107', '2018-01-30 19:30:19', NULL, NULL, NULL, '普陀区', '上海市市辖区普陀区', '3', 5, 'P', NULL, '1', '200333', '310100');
INSERT INTO `sys_region` VALUES ('310109', '2018-01-30 19:30:19', NULL, NULL, NULL, '虹口区', '上海市市辖区虹口区', '3', 6, 'H', NULL, '1', '200086', '310100');
INSERT INTO `sys_region` VALUES ('310110', '2018-01-30 19:30:19', NULL, NULL, NULL, '杨浦区', '上海市市辖区杨浦区', '3', 7, 'Y', NULL, '1', '200082', '310100');
INSERT INTO `sys_region` VALUES ('310112', '2018-01-30 19:30:19', NULL, NULL, NULL, '闵行区', '上海市市辖区闵行区', '3', 8, 'Z', NULL, '1', '201100', '310100');
INSERT INTO `sys_region` VALUES ('310113', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝山区', '上海市市辖区宝山区', '3', 9, 'B', NULL, '1', '201900', '310100');
INSERT INTO `sys_region` VALUES ('310114', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉定区', '上海市市辖区嘉定区', '3', 10, 'J', NULL, '1', '201800', '310100');
INSERT INTO `sys_region` VALUES ('310115', '2018-01-30 19:30:19', NULL, NULL, NULL, '浦东新区', '上海市市辖区浦东新区', '3', 11, 'P', NULL, '1', '200135', '310100');
INSERT INTO `sys_region` VALUES ('310116', '2018-01-30 19:30:19', NULL, NULL, NULL, '金山区', '上海市市辖区金山区', '3', 12, 'J', NULL, '1', '200540', '310100');
INSERT INTO `sys_region` VALUES ('310117', '2018-01-30 19:30:19', NULL, NULL, NULL, '松江区', '上海市市辖区松江区', '3', 13, 'S', NULL, '1', '201600', '310100');
INSERT INTO `sys_region` VALUES ('310118', '2018-01-30 19:30:19', NULL, NULL, NULL, '青浦区', '上海市市辖区青浦区', '3', 14, 'Q', NULL, '1', '201700', '310100');
INSERT INTO `sys_region` VALUES ('310120', '2018-01-30 19:30:19', NULL, NULL, NULL, '奉贤区', '上海市市辖区奉贤区', '3', 15, 'F', NULL, '1', '201400', '310100');
INSERT INTO `sys_region` VALUES ('310151', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇明区', '上海市市辖区崇明区', '3', 16, 'C', NULL, '1', NULL, '310100');
INSERT INTO `sys_region` VALUES ('320000', '2018-01-30 19:30:19', NULL, NULL, NULL, '江苏省', '江苏省', '1', 10, 'J', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('320100', '2018-01-30 19:30:19', NULL, NULL, NULL, '南京市', '江苏省南京市', '2', 1, 'N', NULL, '1', '210008', '320000');
INSERT INTO `sys_region` VALUES ('320101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省南京市市辖区', '3', 1, 'S', NULL, '1', NULL, '320100');
INSERT INTO `sys_region` VALUES ('320102', '2018-01-30 19:30:19', NULL, NULL, NULL, '玄武区', '江苏省南京市玄武区', '3', 2, 'X', NULL, '1', '210018', '320100');
INSERT INTO `sys_region` VALUES ('320104', '2018-01-30 19:30:19', NULL, NULL, NULL, '秦淮区', '江苏省南京市秦淮区', '3', 3, 'Q', NULL, '1', '210001', '320100');
INSERT INTO `sys_region` VALUES ('320105', '2018-01-30 19:30:19', NULL, NULL, NULL, '建邺区', '江苏省南京市建邺区', '3', 4, 'J', NULL, '1', '210004', '320100');
INSERT INTO `sys_region` VALUES ('320106', '2018-01-30 19:30:19', NULL, NULL, NULL, '鼓楼区', '江苏省南京市鼓楼区', '3', 5, 'G', NULL, '1', '210009', '320100');
INSERT INTO `sys_region` VALUES ('320111', '2018-01-30 19:30:19', NULL, NULL, NULL, '浦口区', '江苏省南京市浦口区', '3', 6, 'P', NULL, '1', '211800', '320100');
INSERT INTO `sys_region` VALUES ('320113', '2018-01-30 19:30:19', NULL, NULL, NULL, '栖霞区', '江苏省南京市栖霞区', '3', 7, 'Q', NULL, '1', '210046', '320100');
INSERT INTO `sys_region` VALUES ('320114', '2018-01-30 19:30:19', NULL, NULL, NULL, '雨花台区', '江苏省南京市雨花台区', '3', 8, 'Y', NULL, '1', '210012', '320100');
INSERT INTO `sys_region` VALUES ('320115', '2018-01-30 19:30:19', NULL, NULL, NULL, '江宁区', '江苏省南京市江宁区', '3', 9, 'J', NULL, '1', '211100', '320100');
INSERT INTO `sys_region` VALUES ('320116', '2018-01-30 19:30:19', NULL, NULL, NULL, '六合区', '江苏省南京市六合区', '3', 10, 'L', NULL, '1', '211500', '320100');
INSERT INTO `sys_region` VALUES ('320117', '2018-01-30 19:30:19', NULL, NULL, NULL, '溧水区', '江苏省南京市溧水区', '3', 11, 'Z', NULL, '1', '211200', '320100');
INSERT INTO `sys_region` VALUES ('320118', '2018-01-30 19:30:19', NULL, NULL, NULL, '高淳区', '江苏省南京市高淳区', '3', 12, 'G', NULL, '1', '211300', '320100');
INSERT INTO `sys_region` VALUES ('320200', '2018-01-30 19:30:19', NULL, NULL, NULL, '无锡市', '江苏省无锡市', '2', 2, 'W', NULL, '1', '214000', '320000');
INSERT INTO `sys_region` VALUES ('320201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省无锡市市辖区', '3', 1, 'S', NULL, '1', NULL, '320200');
INSERT INTO `sys_region` VALUES ('320205', '2018-01-30 19:30:19', NULL, NULL, NULL, '锡山区', '江苏省无锡市锡山区', '3', 2, 'X', NULL, '1', '214101', '320200');
INSERT INTO `sys_region` VALUES ('320206', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠山区', '江苏省无锡市惠山区', '3', 3, 'H', NULL, '1', '214174', '320200');
INSERT INTO `sys_region` VALUES ('320211', '2018-01-30 19:30:19', NULL, NULL, NULL, '滨湖区', '江苏省无锡市滨湖区', '3', 4, 'B', NULL, '1', '214123', '320200');
INSERT INTO `sys_region` VALUES ('320213', '2018-01-30 19:30:19', NULL, NULL, NULL, '梁溪区', '江苏省无锡市梁溪区', '3', 5, 'L', NULL, '1', NULL, '320200');
INSERT INTO `sys_region` VALUES ('320214', '2018-01-30 19:30:19', NULL, NULL, NULL, '新吴区', '江苏省无锡市新吴区', '3', 6, 'X', NULL, '1', NULL, '320200');
INSERT INTO `sys_region` VALUES ('320281', '2018-01-30 19:30:19', NULL, NULL, NULL, '江阴市', '江苏省无锡市江阴市', '3', 7, 'J', NULL, '1', '214431', '320200');
INSERT INTO `sys_region` VALUES ('320282', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜兴市', '江苏省无锡市宜兴市', '3', 8, 'Y', NULL, '1', '214200', '320200');
INSERT INTO `sys_region` VALUES ('320300', '2018-01-30 19:30:19', NULL, NULL, NULL, '徐州市', '江苏省徐州市', '2', 3, 'X', NULL, '1', '221003', '320000');
INSERT INTO `sys_region` VALUES ('320301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省徐州市市辖区', '3', 1, 'S', NULL, '1', NULL, '320300');
INSERT INTO `sys_region` VALUES ('320302', '2018-01-30 19:30:19', NULL, NULL, NULL, '鼓楼区', '江苏省徐州市鼓楼区', '3', 2, 'G', NULL, '1', '221005', '320300');
INSERT INTO `sys_region` VALUES ('320303', '2018-01-30 19:30:19', NULL, NULL, NULL, '云龙区', '江苏省徐州市云龙区', '3', 3, 'Y', NULL, '1', '221007', '320300');
INSERT INTO `sys_region` VALUES ('320305', '2018-01-30 19:30:19', NULL, NULL, NULL, '贾汪区', '江苏省徐州市贾汪区', '3', 4, 'J', NULL, '1', '221003', '320300');
INSERT INTO `sys_region` VALUES ('320311', '2018-01-30 19:30:19', NULL, NULL, NULL, '泉山区', '江苏省徐州市泉山区', '3', 5, 'Q', NULL, '1', '221006', '320300');
INSERT INTO `sys_region` VALUES ('320312', '2018-01-30 19:30:19', NULL, NULL, NULL, '铜山区', '江苏省徐州市铜山区', '3', 6, 'T', NULL, '1', '221106', '320300');
INSERT INTO `sys_region` VALUES ('320321', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰县', '江苏省徐州市丰县', '3', 7, 'F', NULL, '1', '221700', '320300');
INSERT INTO `sys_region` VALUES ('320322', '2018-01-30 19:30:19', NULL, NULL, NULL, '沛县', '江苏省徐州市沛县', '3', 8, 'P', NULL, '1', '221600', '320300');
INSERT INTO `sys_region` VALUES ('320324', '2018-01-30 19:30:19', NULL, NULL, NULL, '睢宁县', '江苏省徐州市睢宁县', '3', 9, 'Z', NULL, '1', '221200', '320300');
INSERT INTO `sys_region` VALUES ('320381', '2018-01-30 19:30:19', NULL, NULL, NULL, '新沂市', '江苏省徐州市新沂市', '3', 10, 'X', NULL, '1', '221400', '320300');
INSERT INTO `sys_region` VALUES ('320382', '2018-01-30 19:30:19', NULL, NULL, NULL, '邳州市', '江苏省徐州市邳州市', '3', 11, 'Z', NULL, '1', '221300', '320300');
INSERT INTO `sys_region` VALUES ('320400', '2018-01-30 19:30:19', NULL, NULL, NULL, '常州市', '江苏省常州市', '2', 4, 'C', NULL, '1', '213000', '320000');
INSERT INTO `sys_region` VALUES ('320401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省常州市市辖区', '3', 1, 'S', NULL, '1', NULL, '320400');
INSERT INTO `sys_region` VALUES ('320402', '2018-01-30 19:30:19', NULL, NULL, NULL, '天宁区', '江苏省常州市天宁区', '3', 2, 'T', NULL, '1', '213000', '320400');
INSERT INTO `sys_region` VALUES ('320404', '2018-01-30 19:30:19', NULL, NULL, NULL, '钟楼区', '江苏省常州市钟楼区', '3', 3, 'Z', NULL, '1', '213023', '320400');
INSERT INTO `sys_region` VALUES ('320411', '2018-01-30 19:30:19', NULL, NULL, NULL, '新北区', '江苏省常州市新北区', '3', 4, 'X', NULL, '1', '213022', '320400');
INSERT INTO `sys_region` VALUES ('320412', '2018-01-30 19:30:19', NULL, NULL, NULL, '武进区', '江苏省常州市武进区', '3', 5, 'W', NULL, '1', '213100', '320400');
INSERT INTO `sys_region` VALUES ('320413', '2018-01-30 19:30:19', NULL, NULL, NULL, '金坛区', '江苏省常州市金坛区', '3', 6, 'J', NULL, '1', NULL, '320400');
INSERT INTO `sys_region` VALUES ('320481', '2018-01-30 19:30:19', NULL, NULL, NULL, '溧阳市', '江苏省常州市溧阳市', '3', 7, 'Z', NULL, '1', '213300', '320400');
INSERT INTO `sys_region` VALUES ('320500', '2018-01-30 19:30:19', NULL, NULL, NULL, '苏州市', '江苏省苏州市', '2', 5, 'S', NULL, '1', '215002', '320000');
INSERT INTO `sys_region` VALUES ('320501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省苏州市市辖区', '3', 1, 'S', NULL, '1', NULL, '320500');
INSERT INTO `sys_region` VALUES ('320505', '2018-01-30 19:30:19', NULL, NULL, NULL, '虎丘区', '江苏省苏州市虎丘区', '3', 2, 'H', NULL, '1', '215004', '320500');
INSERT INTO `sys_region` VALUES ('320506', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴中区', '江苏省苏州市吴中区', '3', 3, 'W', NULL, '1', '215128', '320500');
INSERT INTO `sys_region` VALUES ('320507', '2018-01-30 19:30:19', NULL, NULL, NULL, '相城区', '江苏省苏州市相城区', '3', 4, 'X', NULL, '1', '215131', '320500');
INSERT INTO `sys_region` VALUES ('320508', '2018-01-30 19:30:19', NULL, NULL, NULL, '姑苏区', '江苏省苏州市姑苏区', '3', 5, 'G', NULL, '1', '215031', '320500');
INSERT INTO `sys_region` VALUES ('320509', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴江区', '江苏省苏州市吴江区', '3', 6, 'W', NULL, '1', '215200', '320500');
INSERT INTO `sys_region` VALUES ('320581', '2018-01-30 19:30:19', NULL, NULL, NULL, '常熟市', '江苏省苏州市常熟市', '3', 7, 'C', NULL, '1', '215500', '320500');
INSERT INTO `sys_region` VALUES ('320582', '2018-01-30 19:30:19', NULL, NULL, NULL, '张家港市', '江苏省苏州市张家港市', '3', 8, 'Z', NULL, '1', '215600', '320500');
INSERT INTO `sys_region` VALUES ('320583', '2018-01-30 19:30:19', NULL, NULL, NULL, '昆山市', '江苏省苏州市昆山市', '3', 9, 'K', NULL, '1', '215300', '320500');
INSERT INTO `sys_region` VALUES ('320585', '2018-01-30 19:30:19', NULL, NULL, NULL, '太仓市', '江苏省苏州市太仓市', '3', 10, 'T', NULL, '1', '215400', '320500');
INSERT INTO `sys_region` VALUES ('320600', '2018-01-30 19:30:19', NULL, NULL, NULL, '南通市', '江苏省南通市', '2', 6, 'N', NULL, '1', '226001', '320000');
INSERT INTO `sys_region` VALUES ('320601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省南通市市辖区', '3', 1, 'S', NULL, '1', NULL, '320600');
INSERT INTO `sys_region` VALUES ('320602', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇川区', '江苏省南通市崇川区', '3', 2, 'C', NULL, '1', '226001', '320600');
INSERT INTO `sys_region` VALUES ('320611', '2018-01-30 19:30:19', NULL, NULL, NULL, '港闸区', '江苏省南通市港闸区', '3', 3, 'G', NULL, '1', '226001', '320600');
INSERT INTO `sys_region` VALUES ('320612', '2018-01-30 19:30:19', NULL, NULL, NULL, '通州区', '江苏省南通市通州区', '3', 4, 'T', NULL, '1', '226300', '320600');
INSERT INTO `sys_region` VALUES ('320621', '2018-01-30 19:30:19', NULL, NULL, NULL, '海安县', '江苏省南通市海安县', '3', 5, 'H', NULL, '1', '226600', '320600');
INSERT INTO `sys_region` VALUES ('320623', '2018-01-30 19:30:19', NULL, NULL, NULL, '如东县', '江苏省南通市如东县', '3', 6, 'R', NULL, '1', '226400', '320600');
INSERT INTO `sys_region` VALUES ('320681', '2018-01-30 19:30:19', NULL, NULL, NULL, '启东市', '江苏省南通市启东市', '3', 7, 'Q', NULL, '1', '226200', '320600');
INSERT INTO `sys_region` VALUES ('320682', '2018-01-30 19:30:19', NULL, NULL, NULL, '如皋市', '江苏省南通市如皋市', '3', 8, 'R', NULL, '1', '226500', '320600');
INSERT INTO `sys_region` VALUES ('320684', '2018-01-30 19:30:19', NULL, NULL, NULL, '海门市', '江苏省南通市海门市', '3', 9, 'H', NULL, '1', '226100', '320600');
INSERT INTO `sys_region` VALUES ('320700', '2018-01-30 19:30:19', NULL, NULL, NULL, '连云港市', '江苏省连云港市', '2', 7, 'L', NULL, '1', '222002', '320000');
INSERT INTO `sys_region` VALUES ('320701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省连云港市市辖区', '3', 1, 'S', NULL, '1', NULL, '320700');
INSERT INTO `sys_region` VALUES ('320703', '2018-01-30 19:30:19', NULL, NULL, NULL, '连云区', '江苏省连云港市连云区', '3', 2, 'L', NULL, '1', '222042', '320700');
INSERT INTO `sys_region` VALUES ('320706', '2018-01-30 19:30:19', NULL, NULL, NULL, '海州区', '江苏省连云港市海州区', '3', 3, 'H', NULL, '1', '222003', '320700');
INSERT INTO `sys_region` VALUES ('320707', '2018-01-30 19:30:19', NULL, NULL, NULL, '赣榆区', '江苏省连云港市赣榆区', '3', 4, 'G', NULL, '1', '222100', '320700');
INSERT INTO `sys_region` VALUES ('320722', '2018-01-30 19:30:19', NULL, NULL, NULL, '东海县', '江苏省连云港市东海县', '3', 5, 'D', NULL, '1', '222300', '320700');
INSERT INTO `sys_region` VALUES ('320723', '2018-01-30 19:30:19', NULL, NULL, NULL, '灌云县', '江苏省连云港市灌云县', '3', 6, 'G', NULL, '1', '222200', '320700');
INSERT INTO `sys_region` VALUES ('320724', '2018-01-30 19:30:19', NULL, NULL, NULL, '灌南县', '江苏省连云港市灌南县', '3', 7, 'G', NULL, '1', '222500', '320700');
INSERT INTO `sys_region` VALUES ('320800', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮安市', '江苏省淮安市', '2', 8, 'H', NULL, '1', '223001', '320000');
INSERT INTO `sys_region` VALUES ('320801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省淮安市市辖区', '3', 1, 'S', NULL, '1', NULL, '320800');
INSERT INTO `sys_region` VALUES ('320803', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮安区', '江苏省淮安市淮安区', '3', 2, 'H', NULL, '1', '223200', '320800');
INSERT INTO `sys_region` VALUES ('320804', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮阴区', '江苏省淮安市淮阴区', '3', 3, 'H', NULL, '1', '223300', '320800');
INSERT INTO `sys_region` VALUES ('320812', '2018-01-30 19:30:19', NULL, NULL, NULL, '清江浦区', '江苏省淮安市清江浦区', '3', 4, 'Q', NULL, '1', NULL, '320800');
INSERT INTO `sys_region` VALUES ('320813', '2018-01-30 19:30:19', NULL, NULL, NULL, '洪泽区', '江苏省淮安市洪泽区', '3', 5, 'H', NULL, '1', NULL, '320800');
INSERT INTO `sys_region` VALUES ('320826', '2018-01-30 19:30:19', NULL, NULL, NULL, '涟水县', '江苏省淮安市涟水县', '3', 6, 'L', NULL, '1', '223400', '320800');
INSERT INTO `sys_region` VALUES ('320830', '2018-01-30 19:30:19', NULL, NULL, NULL, '盱眙县', '江苏省淮安市盱眙县', '3', 7, 'Z', NULL, '1', '211700', '320800');
INSERT INTO `sys_region` VALUES ('320831', '2018-01-30 19:30:19', NULL, NULL, NULL, '金湖县', '江苏省淮安市金湖县', '3', 8, 'J', NULL, '1', '211600', '320800');
INSERT INTO `sys_region` VALUES ('320900', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐城市', '江苏省盐城市', '2', 9, 'Y', NULL, '1', '224005', '320000');
INSERT INTO `sys_region` VALUES ('320901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省盐城市市辖区', '3', 1, 'S', NULL, '1', NULL, '320900');
INSERT INTO `sys_region` VALUES ('320902', '2018-01-30 19:30:19', NULL, NULL, NULL, '亭湖区', '江苏省盐城市亭湖区', '3', 2, 'T', NULL, '1', '224005', '320900');
INSERT INTO `sys_region` VALUES ('320903', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐都区', '江苏省盐城市盐都区', '3', 3, 'Y', NULL, '1', '224055', '320900');
INSERT INTO `sys_region` VALUES ('320904', '2018-01-30 19:30:19', NULL, NULL, NULL, '大丰区', '江苏省盐城市大丰区', '3', 4, 'D', NULL, '1', NULL, '320900');
INSERT INTO `sys_region` VALUES ('320921', '2018-01-30 19:30:19', NULL, NULL, NULL, '响水县', '江苏省盐城市响水县', '3', 5, 'X', NULL, '1', '224600', '320900');
INSERT INTO `sys_region` VALUES ('320922', '2018-01-30 19:30:19', NULL, NULL, NULL, '滨海县', '江苏省盐城市滨海县', '3', 6, 'B', NULL, '1', '224500', '320900');
INSERT INTO `sys_region` VALUES ('320923', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜宁县', '江苏省盐城市阜宁县', '3', 7, 'F', NULL, '1', '224400', '320900');
INSERT INTO `sys_region` VALUES ('320924', '2018-01-30 19:30:19', NULL, NULL, NULL, '射阳县', '江苏省盐城市射阳县', '3', 8, 'S', NULL, '1', '224300', '320900');
INSERT INTO `sys_region` VALUES ('320925', '2018-01-30 19:30:19', NULL, NULL, NULL, '建湖县', '江苏省盐城市建湖县', '3', 9, 'J', NULL, '1', '224700', '320900');
INSERT INTO `sys_region` VALUES ('320981', '2018-01-30 19:30:19', NULL, NULL, NULL, '东台市', '江苏省盐城市东台市', '3', 10, 'D', NULL, '1', '224200', '320900');
INSERT INTO `sys_region` VALUES ('321000', '2018-01-30 19:30:19', NULL, NULL, NULL, '扬州市', '江苏省扬州市', '2', 10, 'Y', NULL, '1', '225002', '320000');
INSERT INTO `sys_region` VALUES ('321001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省扬州市市辖区', '3', 1, 'S', NULL, '1', NULL, '321000');
INSERT INTO `sys_region` VALUES ('321002', '2018-01-30 19:30:19', NULL, NULL, NULL, '广陵区', '江苏省扬州市广陵区', '3', 2, 'G', NULL, '1', '225002', '321000');
INSERT INTO `sys_region` VALUES ('321003', '2018-01-30 19:30:19', NULL, NULL, NULL, '邗江区', '江苏省扬州市邗江区', '3', 3, 'Z', NULL, '1', '225002', '321000');
INSERT INTO `sys_region` VALUES ('321012', '2018-01-30 19:30:19', NULL, NULL, NULL, '江都区', '江苏省扬州市江都区', '3', 4, 'J', NULL, '1', '225200', '321000');
INSERT INTO `sys_region` VALUES ('321023', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝应县', '江苏省扬州市宝应县', '3', 5, 'B', NULL, '1', '225800', '321000');
INSERT INTO `sys_region` VALUES ('321081', '2018-01-30 19:30:19', NULL, NULL, NULL, '仪征市', '江苏省扬州市仪征市', '3', 6, 'Y', NULL, '1', '211400', '321000');
INSERT INTO `sys_region` VALUES ('321084', '2018-01-30 19:30:19', NULL, NULL, NULL, '高邮市', '江苏省扬州市高邮市', '3', 7, 'G', NULL, '1', '225600', '321000');
INSERT INTO `sys_region` VALUES ('321100', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇江市', '江苏省镇江市', '2', 11, 'Z', NULL, '1', '212004', '320000');
INSERT INTO `sys_region` VALUES ('321101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省镇江市市辖区', '3', 1, 'S', NULL, '1', NULL, '321100');
INSERT INTO `sys_region` VALUES ('321102', '2018-01-30 19:30:19', NULL, NULL, NULL, '京口区', '江苏省镇江市京口区', '3', 2, 'J', NULL, '1', '212003', '321100');
INSERT INTO `sys_region` VALUES ('321111', '2018-01-30 19:30:19', NULL, NULL, NULL, '润州区', '江苏省镇江市润州区', '3', 3, 'R', NULL, '1', '212005', '321100');
INSERT INTO `sys_region` VALUES ('321112', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹徒区', '江苏省镇江市丹徒区', '3', 4, 'D', NULL, '1', '212028', '321100');
INSERT INTO `sys_region` VALUES ('321181', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹阳市', '江苏省镇江市丹阳市', '3', 5, 'D', NULL, '1', '212300', '321100');
INSERT INTO `sys_region` VALUES ('321182', '2018-01-30 19:30:19', NULL, NULL, NULL, '扬中市', '江苏省镇江市扬中市', '3', 6, 'Y', NULL, '1', '212200', '321100');
INSERT INTO `sys_region` VALUES ('321183', '2018-01-30 19:30:19', NULL, NULL, NULL, '句容市', '江苏省镇江市句容市', '3', 7, 'J', NULL, '1', '212400', '321100');
INSERT INTO `sys_region` VALUES ('321200', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰州市', '江苏省泰州市', '2', 12, 'T', NULL, '1', '225300', '320000');
INSERT INTO `sys_region` VALUES ('321201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省泰州市市辖区', '3', 1, 'S', NULL, '1', NULL, '321200');
INSERT INTO `sys_region` VALUES ('321202', '2018-01-30 19:30:19', NULL, NULL, NULL, '海陵区', '江苏省泰州市海陵区', '3', 2, 'H', NULL, '1', '225300', '321200');
INSERT INTO `sys_region` VALUES ('321203', '2018-01-30 19:30:19', NULL, NULL, NULL, '高港区', '江苏省泰州市高港区', '3', 3, 'G', NULL, '1', '225321', '321200');
INSERT INTO `sys_region` VALUES ('321204', '2018-01-30 19:30:19', NULL, NULL, NULL, '姜堰区', '江苏省泰州市姜堰区', '3', 4, 'J', NULL, '1', '225500', '321200');
INSERT INTO `sys_region` VALUES ('321281', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴化市', '江苏省泰州市兴化市', '3', 5, 'X', NULL, '1', '225700', '321200');
INSERT INTO `sys_region` VALUES ('321282', '2018-01-30 19:30:19', NULL, NULL, NULL, '靖江市', '江苏省泰州市靖江市', '3', 6, 'J', NULL, '1', '214500', '321200');
INSERT INTO `sys_region` VALUES ('321283', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰兴市', '江苏省泰州市泰兴市', '3', 7, 'T', NULL, '1', '225400', '321200');
INSERT INTO `sys_region` VALUES ('321300', '2018-01-30 19:30:19', NULL, NULL, NULL, '宿迁市', '江苏省宿迁市', '2', 13, 'S', NULL, '1', '223800', '320000');
INSERT INTO `sys_region` VALUES ('321301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江苏省宿迁市市辖区', '3', 1, 'S', NULL, '1', NULL, '321300');
INSERT INTO `sys_region` VALUES ('321302', '2018-01-30 19:30:19', NULL, NULL, NULL, '宿城区', '江苏省宿迁市宿城区', '3', 2, 'S', NULL, '1', '223800', '321300');
INSERT INTO `sys_region` VALUES ('321311', '2018-01-30 19:30:19', NULL, NULL, NULL, '宿豫区', '江苏省宿迁市宿豫区', '3', 3, 'S', NULL, '1', '223800', '321300');
INSERT INTO `sys_region` VALUES ('321322', '2018-01-30 19:30:19', NULL, NULL, NULL, '沭阳县', '江苏省宿迁市沭阳县', '3', 4, 'Z', NULL, '1', '223600', '321300');
INSERT INTO `sys_region` VALUES ('321323', '2018-01-30 19:30:19', NULL, NULL, NULL, '泗阳县', '江苏省宿迁市泗阳县', '3', 5, 'Z', NULL, '1', '223700', '321300');
INSERT INTO `sys_region` VALUES ('321324', '2018-01-30 19:30:19', NULL, NULL, NULL, '泗洪县', '江苏省宿迁市泗洪县', '3', 6, 'Z', NULL, '1', '223900', '321300');
INSERT INTO `sys_region` VALUES ('330000', '2018-01-30 19:30:19', NULL, NULL, NULL, '浙江省', '浙江省', '1', 11, 'Z', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('330100', '2018-01-30 19:30:19', NULL, NULL, NULL, '杭州市', '浙江省杭州市', '2', 1, 'H', NULL, '1', '310026', '330000');
INSERT INTO `sys_region` VALUES ('330101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省杭州市市辖区', '3', 1, 'S', NULL, '1', NULL, '330100');
INSERT INTO `sys_region` VALUES ('330102', '2018-01-30 19:30:19', NULL, NULL, NULL, '上城区', '浙江省杭州市上城区', '3', 2, 'S', NULL, '1', '310002', '330100');
INSERT INTO `sys_region` VALUES ('330103', '2018-01-30 19:30:19', NULL, NULL, NULL, '下城区', '浙江省杭州市下城区', '3', 3, 'X', NULL, '1', '310006', '330100');
INSERT INTO `sys_region` VALUES ('330104', '2018-01-30 19:30:19', NULL, NULL, NULL, '江干区', '浙江省杭州市江干区', '3', 4, 'J', NULL, '1', '310016', '330100');
INSERT INTO `sys_region` VALUES ('330105', '2018-01-30 19:30:19', NULL, NULL, NULL, '拱墅区', '浙江省杭州市拱墅区', '3', 5, 'G', NULL, '1', '310011', '330100');
INSERT INTO `sys_region` VALUES ('330106', '2018-01-30 19:30:19', NULL, NULL, NULL, '西湖区', '浙江省杭州市西湖区', '3', 6, 'X', NULL, '1', '310013', '330100');
INSERT INTO `sys_region` VALUES ('330108', '2018-01-30 19:30:19', NULL, NULL, NULL, '滨江区', '浙江省杭州市滨江区', '3', 7, 'B', NULL, '1', '310051', '330100');
INSERT INTO `sys_region` VALUES ('330109', '2018-01-30 19:30:19', NULL, NULL, NULL, '萧山区', '浙江省杭州市萧山区', '3', 8, 'X', NULL, '1', '311200', '330100');
INSERT INTO `sys_region` VALUES ('330110', '2018-01-30 19:30:19', NULL, NULL, NULL, '余杭区', '浙江省杭州市余杭区', '3', 9, 'Y', NULL, '1', '311100', '330100');
INSERT INTO `sys_region` VALUES ('330111', '2018-01-30 19:30:19', NULL, NULL, NULL, '富阳区', '浙江省杭州市富阳区', '3', 10, 'F', NULL, '1', NULL, '330100');
INSERT INTO `sys_region` VALUES ('330122', '2018-01-30 19:30:19', NULL, NULL, NULL, '桐庐县', '浙江省杭州市桐庐县', '3', 11, 'T', NULL, '1', '311500', '330100');
INSERT INTO `sys_region` VALUES ('330127', '2018-01-30 19:30:19', NULL, NULL, NULL, '淳安县', '浙江省杭州市淳安县', '3', 12, 'C', NULL, '1', '311700', '330100');
INSERT INTO `sys_region` VALUES ('330182', '2018-01-30 19:30:19', NULL, NULL, NULL, '建德市', '浙江省杭州市建德市', '3', 13, 'J', NULL, '1', '311600', '330100');
INSERT INTO `sys_region` VALUES ('330185', '2018-01-30 19:30:19', NULL, NULL, NULL, '临安市', '浙江省杭州市临安市', '3', 14, 'L', NULL, '1', '311300', '330100');
INSERT INTO `sys_region` VALUES ('330200', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁波市', '浙江省宁波市', '2', 2, 'N', NULL, '1', '315000', '330000');
INSERT INTO `sys_region` VALUES ('330201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省宁波市市辖区', '3', 1, 'S', NULL, '1', NULL, '330200');
INSERT INTO `sys_region` VALUES ('330203', '2018-01-30 19:30:19', NULL, NULL, NULL, '海曙区', '浙江省宁波市海曙区', '3', 2, 'H', NULL, '1', '315000', '330200');
INSERT INTO `sys_region` VALUES ('330204', '2018-01-30 19:30:19', NULL, NULL, NULL, '江东区', '浙江省宁波市江东区', '3', 3, 'J', NULL, '1', '315040', '330200');
INSERT INTO `sys_region` VALUES ('330205', '2018-01-30 19:30:19', NULL, NULL, NULL, '江北区', '浙江省宁波市江北区', '3', 4, 'J', NULL, '1', '315020', '330200');
INSERT INTO `sys_region` VALUES ('330206', '2018-01-30 19:30:19', NULL, NULL, NULL, '北仑区', '浙江省宁波市北仑区', '3', 5, 'B', NULL, '1', '315800', '330200');
INSERT INTO `sys_region` VALUES ('330211', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇海区', '浙江省宁波市镇海区', '3', 6, 'Z', NULL, '1', '315200', '330200');
INSERT INTO `sys_region` VALUES ('330212', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄞州区', '浙江省宁波市鄞州区', '3', 7, 'Z', NULL, '1', '315100', '330200');
INSERT INTO `sys_region` VALUES ('330225', '2018-01-30 19:30:19', NULL, NULL, NULL, '象山县', '浙江省宁波市象山县', '3', 8, 'X', NULL, '1', '315700', '330200');
INSERT INTO `sys_region` VALUES ('330226', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁海县', '浙江省宁波市宁海县', '3', 9, 'N', NULL, '1', '315600', '330200');
INSERT INTO `sys_region` VALUES ('330281', '2018-01-30 19:30:19', NULL, NULL, NULL, '余姚市', '浙江省宁波市余姚市', '3', 10, 'Y', NULL, '1', '315400', '330200');
INSERT INTO `sys_region` VALUES ('330282', '2018-01-30 19:30:19', NULL, NULL, NULL, '慈溪市', '浙江省宁波市慈溪市', '3', 11, 'C', NULL, '1', '315300', '330200');
INSERT INTO `sys_region` VALUES ('330283', '2018-01-30 19:30:19', NULL, NULL, NULL, '奉化市', '浙江省宁波市奉化市', '3', 12, 'F', NULL, '1', '315500', '330200');
INSERT INTO `sys_region` VALUES ('330300', '2018-01-30 19:30:19', NULL, NULL, NULL, '温州市', '浙江省温州市', '2', 3, 'W', NULL, '1', '325000', '330000');
INSERT INTO `sys_region` VALUES ('330301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省温州市市辖区', '3', 1, 'S', NULL, '1', NULL, '330300');
INSERT INTO `sys_region` VALUES ('330302', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹿城区', '浙江省温州市鹿城区', '3', 2, 'L', NULL, '1', '325000', '330300');
INSERT INTO `sys_region` VALUES ('330303', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙湾区', '浙江省温州市龙湾区', '3', 3, 'L', NULL, '1', '325013', '330300');
INSERT INTO `sys_region` VALUES ('330304', '2018-01-30 19:30:19', NULL, NULL, NULL, '瓯海区', '浙江省温州市瓯海区', '3', 4, 'Z', NULL, '1', '325005', '330300');
INSERT INTO `sys_region` VALUES ('330305', '2018-01-30 19:30:19', NULL, NULL, NULL, '洞头区', '浙江省温州市洞头区', '3', 5, 'D', NULL, '1', NULL, '330300');
INSERT INTO `sys_region` VALUES ('330324', '2018-01-30 19:30:19', NULL, NULL, NULL, '永嘉县', '浙江省温州市永嘉县', '3', 6, 'Y', NULL, '1', '325100', '330300');
INSERT INTO `sys_region` VALUES ('330326', '2018-01-30 19:30:19', NULL, NULL, NULL, '平阳县', '浙江省温州市平阳县', '3', 7, 'P', NULL, '1', '325400', '330300');
INSERT INTO `sys_region` VALUES ('330327', '2018-01-30 19:30:19', NULL, NULL, NULL, '苍南县', '浙江省温州市苍南县', '3', 8, 'C', NULL, '1', '325800', '330300');
INSERT INTO `sys_region` VALUES ('330328', '2018-01-30 19:30:19', NULL, NULL, NULL, '文成县', '浙江省温州市文成县', '3', 9, 'W', NULL, '1', '325300', '330300');
INSERT INTO `sys_region` VALUES ('330329', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰顺县', '浙江省温州市泰顺县', '3', 10, 'T', NULL, '1', '325500', '330300');
INSERT INTO `sys_region` VALUES ('330381', '2018-01-30 19:30:19', NULL, NULL, NULL, '瑞安市', '浙江省温州市瑞安市', '3', 11, 'R', NULL, '1', '325200', '330300');
INSERT INTO `sys_region` VALUES ('330382', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐清市', '浙江省温州市乐清市', '3', 12, 'L', NULL, '1', '325600', '330300');
INSERT INTO `sys_region` VALUES ('330400', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉兴市', '浙江省嘉兴市', '2', 4, 'J', NULL, '1', '314000', '330000');
INSERT INTO `sys_region` VALUES ('330401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省嘉兴市市辖区', '3', 1, 'S', NULL, '1', NULL, '330400');
INSERT INTO `sys_region` VALUES ('330402', '2018-01-30 19:30:19', NULL, NULL, NULL, '南湖区', '浙江省嘉兴市南湖区', '3', 2, 'N', NULL, '1', '314051', '330400');
INSERT INTO `sys_region` VALUES ('330411', '2018-01-30 19:30:19', NULL, NULL, NULL, '秀洲区', '浙江省嘉兴市秀洲区', '3', 3, 'X', NULL, '1', '314031', '330400');
INSERT INTO `sys_region` VALUES ('330421', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉善县', '浙江省嘉兴市嘉善县', '3', 4, 'J', NULL, '1', '314100', '330400');
INSERT INTO `sys_region` VALUES ('330424', '2018-01-30 19:30:19', NULL, NULL, NULL, '海盐县', '浙江省嘉兴市海盐县', '3', 5, 'H', NULL, '1', '314300', '330400');
INSERT INTO `sys_region` VALUES ('330481', '2018-01-30 19:30:19', NULL, NULL, NULL, '海宁市', '浙江省嘉兴市海宁市', '3', 6, 'H', NULL, '1', '314400', '330400');
INSERT INTO `sys_region` VALUES ('330482', '2018-01-30 19:30:19', NULL, NULL, NULL, '平湖市', '浙江省嘉兴市平湖市', '3', 7, 'P', NULL, '1', '314200', '330400');
INSERT INTO `sys_region` VALUES ('330483', '2018-01-30 19:30:19', NULL, NULL, NULL, '桐乡市', '浙江省嘉兴市桐乡市', '3', 8, 'T', NULL, '1', '314500', '330400');
INSERT INTO `sys_region` VALUES ('330500', '2018-01-30 19:30:19', NULL, NULL, NULL, '湖州市', '浙江省湖州市', '2', 5, 'H', NULL, '1', '313000', '330000');
INSERT INTO `sys_region` VALUES ('330501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省湖州市市辖区', '3', 1, 'S', NULL, '1', NULL, '330500');
INSERT INTO `sys_region` VALUES ('330502', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴兴区', '浙江省湖州市吴兴区', '3', 2, 'W', NULL, '1', '313000', '330500');
INSERT INTO `sys_region` VALUES ('330503', '2018-01-30 19:30:19', NULL, NULL, NULL, '南浔区', '浙江省湖州市南浔区', '3', 3, 'N', NULL, '1', '313009', '330500');
INSERT INTO `sys_region` VALUES ('330521', '2018-01-30 19:30:19', NULL, NULL, NULL, '德清县', '浙江省湖州市德清县', '3', 4, 'D', NULL, '1', '313200', '330500');
INSERT INTO `sys_region` VALUES ('330522', '2018-01-30 19:30:19', NULL, NULL, NULL, '长兴县', '浙江省湖州市长兴县', '3', 5, 'C', NULL, '1', '313100', '330500');
INSERT INTO `sys_region` VALUES ('330523', '2018-01-30 19:30:19', NULL, NULL, NULL, '安吉县', '浙江省湖州市安吉县', '3', 6, 'A', NULL, '1', '313300', '330500');
INSERT INTO `sys_region` VALUES ('330600', '2018-01-30 19:30:19', NULL, NULL, NULL, '绍兴市', '浙江省绍兴市', '2', 6, 'S', NULL, '1', '312000', '330000');
INSERT INTO `sys_region` VALUES ('330601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省绍兴市市辖区', '3', 1, 'S', NULL, '1', NULL, '330600');
INSERT INTO `sys_region` VALUES ('330602', '2018-01-30 19:30:19', NULL, NULL, NULL, '越城区', '浙江省绍兴市越城区', '3', 2, 'Y', NULL, '1', '312000', '330600');
INSERT INTO `sys_region` VALUES ('330603', '2018-01-30 19:30:19', NULL, NULL, NULL, '柯桥区', '浙江省绍兴市柯桥区', '3', 3, 'K', NULL, '1', '312030', '330600');
INSERT INTO `sys_region` VALUES ('330604', '2018-01-30 19:30:19', NULL, NULL, NULL, '上虞区', '浙江省绍兴市上虞区', '3', 4, 'S', NULL, '1', '312300', '330600');
INSERT INTO `sys_region` VALUES ('330624', '2018-01-30 19:30:19', NULL, NULL, NULL, '新昌县', '浙江省绍兴市新昌县', '3', 5, 'X', NULL, '1', '312500', '330600');
INSERT INTO `sys_region` VALUES ('330681', '2018-01-30 19:30:19', NULL, NULL, NULL, '诸暨市', '浙江省绍兴市诸暨市', '3', 6, 'Z', NULL, '1', '311800', '330600');
INSERT INTO `sys_region` VALUES ('330683', '2018-01-30 19:30:19', NULL, NULL, NULL, '嵊州市', '浙江省绍兴市嵊州市', '3', 7, 'Z', NULL, '1', '312400', '330600');
INSERT INTO `sys_region` VALUES ('330700', '2018-01-30 19:30:19', NULL, NULL, NULL, '金华市', '浙江省金华市', '2', 7, 'J', NULL, '1', '321000', '330000');
INSERT INTO `sys_region` VALUES ('330701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省金华市市辖区', '3', 1, 'S', NULL, '1', NULL, '330700');
INSERT INTO `sys_region` VALUES ('330702', '2018-01-30 19:30:19', NULL, NULL, NULL, '婺城区', '浙江省金华市婺城区', '3', 2, 'Z', NULL, '1', '321000', '330700');
INSERT INTO `sys_region` VALUES ('330703', '2018-01-30 19:30:19', NULL, NULL, NULL, '金东区', '浙江省金华市金东区', '3', 3, 'J', NULL, '1', '321000', '330700');
INSERT INTO `sys_region` VALUES ('330723', '2018-01-30 19:30:19', NULL, NULL, NULL, '武义县', '浙江省金华市武义县', '3', 4, 'W', NULL, '1', '321200', '330700');
INSERT INTO `sys_region` VALUES ('330726', '2018-01-30 19:30:19', NULL, NULL, NULL, '浦江县', '浙江省金华市浦江县', '3', 5, 'P', NULL, '1', '322200', '330700');
INSERT INTO `sys_region` VALUES ('330727', '2018-01-30 19:30:19', NULL, NULL, NULL, '磐安县', '浙江省金华市磐安县', '3', 6, 'P', NULL, '1', '322300', '330700');
INSERT INTO `sys_region` VALUES ('330781', '2018-01-30 19:30:19', NULL, NULL, NULL, '兰溪市', '浙江省金华市兰溪市', '3', 7, 'L', NULL, '1', '321100', '330700');
INSERT INTO `sys_region` VALUES ('330782', '2018-01-30 19:30:19', NULL, NULL, NULL, '义乌市', '浙江省金华市义乌市', '3', 8, 'Y', NULL, '1', '322000', '330700');
INSERT INTO `sys_region` VALUES ('330783', '2018-01-30 19:30:19', NULL, NULL, NULL, '东阳市', '浙江省金华市东阳市', '3', 9, 'D', NULL, '1', '322100', '330700');
INSERT INTO `sys_region` VALUES ('330784', '2018-01-30 19:30:19', NULL, NULL, NULL, '永康市', '浙江省金华市永康市', '3', 10, 'Y', NULL, '1', '321300', '330700');
INSERT INTO `sys_region` VALUES ('330800', '2018-01-30 19:30:19', NULL, NULL, NULL, '衢州市', '浙江省衢州市', '2', 8, 'Z', NULL, '1', '324002', '330000');
INSERT INTO `sys_region` VALUES ('330801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省衢州市市辖区', '3', 1, 'S', NULL, '1', NULL, '330800');
INSERT INTO `sys_region` VALUES ('330802', '2018-01-30 19:30:19', NULL, NULL, NULL, '柯城区', '浙江省衢州市柯城区', '3', 2, 'K', NULL, '1', '324100', '330800');
INSERT INTO `sys_region` VALUES ('330803', '2018-01-30 19:30:19', NULL, NULL, NULL, '衢江区', '浙江省衢州市衢江区', '3', 3, 'Z', NULL, '1', '324022', '330800');
INSERT INTO `sys_region` VALUES ('330822', '2018-01-30 19:30:19', NULL, NULL, NULL, '常山县', '浙江省衢州市常山县', '3', 4, 'C', NULL, '1', '324200', '330800');
INSERT INTO `sys_region` VALUES ('330824', '2018-01-30 19:30:19', NULL, NULL, NULL, '开化县', '浙江省衢州市开化县', '3', 5, 'K', NULL, '1', '324300', '330800');
INSERT INTO `sys_region` VALUES ('330825', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙游县', '浙江省衢州市龙游县', '3', 6, 'L', NULL, '1', '324400', '330800');
INSERT INTO `sys_region` VALUES ('330881', '2018-01-30 19:30:19', NULL, NULL, NULL, '江山市', '浙江省衢州市江山市', '3', 7, 'J', NULL, '1', '324100', '330800');
INSERT INTO `sys_region` VALUES ('330900', '2018-01-30 19:30:19', NULL, NULL, NULL, '舟山市', '浙江省舟山市', '2', 9, 'Z', NULL, '1', '316000', '330000');
INSERT INTO `sys_region` VALUES ('330901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省舟山市市辖区', '3', 1, 'S', NULL, '1', NULL, '330900');
INSERT INTO `sys_region` VALUES ('330902', '2018-01-30 19:30:19', NULL, NULL, NULL, '定海区', '浙江省舟山市定海区', '3', 2, 'D', NULL, '1', '316000', '330900');
INSERT INTO `sys_region` VALUES ('330903', '2018-01-30 19:30:19', NULL, NULL, NULL, '普陀区', '浙江省舟山市普陀区', '3', 3, 'P', NULL, '1', '316100', '330900');
INSERT INTO `sys_region` VALUES ('330921', '2018-01-30 19:30:19', NULL, NULL, NULL, '岱山县', '浙江省舟山市岱山县', '3', 4, 'Z', NULL, '1', '316200', '330900');
INSERT INTO `sys_region` VALUES ('330922', '2018-01-30 19:30:19', NULL, NULL, NULL, '嵊泗县', '浙江省舟山市嵊泗县', '3', 5, 'Z', NULL, '1', '202450', '330900');
INSERT INTO `sys_region` VALUES ('331000', '2018-01-30 19:30:19', NULL, NULL, NULL, '台州市', '浙江省台州市', '2', 10, 'T', NULL, '1', '318000', '330000');
INSERT INTO `sys_region` VALUES ('331001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省台州市市辖区', '3', 1, 'S', NULL, '1', NULL, '331000');
INSERT INTO `sys_region` VALUES ('331002', '2018-01-30 19:30:19', NULL, NULL, NULL, '椒江区', '浙江省台州市椒江区', '3', 2, 'J', NULL, '1', '318000', '331000');
INSERT INTO `sys_region` VALUES ('331003', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄岩区', '浙江省台州市黄岩区', '3', 3, 'H', NULL, '1', '318020', '331000');
INSERT INTO `sys_region` VALUES ('331004', '2018-01-30 19:30:19', NULL, NULL, NULL, '路桥区', '浙江省台州市路桥区', '3', 4, 'L', NULL, '1', '318050', '331000');
INSERT INTO `sys_region` VALUES ('331021', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉环县', '浙江省台州市玉环县', '3', 5, 'Y', NULL, '1', '317600', '331000');
INSERT INTO `sys_region` VALUES ('331022', '2018-01-30 19:30:19', NULL, NULL, NULL, '三门县', '浙江省台州市三门县', '3', 6, 'S', NULL, '1', '317100', '331000');
INSERT INTO `sys_region` VALUES ('331023', '2018-01-30 19:30:19', NULL, NULL, NULL, '天台县', '浙江省台州市天台县', '3', 7, 'T', NULL, '1', '317200', '331000');
INSERT INTO `sys_region` VALUES ('331024', '2018-01-30 19:30:19', NULL, NULL, NULL, '仙居县', '浙江省台州市仙居县', '3', 8, 'X', NULL, '1', '317300', '331000');
INSERT INTO `sys_region` VALUES ('331081', '2018-01-30 19:30:19', NULL, NULL, NULL, '温岭市', '浙江省台州市温岭市', '3', 9, 'W', NULL, '1', '317500', '331000');
INSERT INTO `sys_region` VALUES ('331082', '2018-01-30 19:30:19', NULL, NULL, NULL, '临海市', '浙江省台州市临海市', '3', 10, 'L', NULL, '1', '317000', '331000');
INSERT INTO `sys_region` VALUES ('331100', '2018-01-30 19:30:19', NULL, NULL, NULL, '丽水市', '浙江省丽水市', '2', 11, 'L', NULL, '1', '323000', '330000');
INSERT INTO `sys_region` VALUES ('331101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '浙江省丽水市市辖区', '3', 1, 'S', NULL, '1', NULL, '331100');
INSERT INTO `sys_region` VALUES ('331102', '2018-01-30 19:30:19', NULL, NULL, NULL, '莲都区', '浙江省丽水市莲都区', '3', 2, 'L', NULL, '1', '323000', '331100');
INSERT INTO `sys_region` VALUES ('331121', '2018-01-30 19:30:19', NULL, NULL, NULL, '青田县', '浙江省丽水市青田县', '3', 3, 'Q', NULL, '1', '323900', '331100');
INSERT INTO `sys_region` VALUES ('331122', '2018-01-30 19:30:19', NULL, NULL, NULL, '缙云县', '浙江省丽水市缙云县', '3', 4, 'Z', NULL, '1', '321400', '331100');
INSERT INTO `sys_region` VALUES ('331123', '2018-01-30 19:30:19', NULL, NULL, NULL, '遂昌县', '浙江省丽水市遂昌县', '3', 5, 'S', NULL, '1', '323300', '331100');
INSERT INTO `sys_region` VALUES ('331124', '2018-01-30 19:30:19', NULL, NULL, NULL, '松阳县', '浙江省丽水市松阳县', '3', 6, 'S', NULL, '1', '323400', '331100');
INSERT INTO `sys_region` VALUES ('331125', '2018-01-30 19:30:19', NULL, NULL, NULL, '云和县', '浙江省丽水市云和县', '3', 7, 'Y', NULL, '1', '323600', '331100');
INSERT INTO `sys_region` VALUES ('331126', '2018-01-30 19:30:19', NULL, NULL, NULL, '庆元县', '浙江省丽水市庆元县', '3', 8, 'Q', NULL, '1', '323800', '331100');
INSERT INTO `sys_region` VALUES ('331127', '2018-01-30 19:30:19', NULL, NULL, NULL, '景宁畲族自治县', '浙江省丽水市景宁畲族自治县', '3', 9, 'J', NULL, '1', '323500', '331100');
INSERT INTO `sys_region` VALUES ('331181', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙泉市', '浙江省丽水市龙泉市', '3', 10, 'L', NULL, '1', '323700', '331100');
INSERT INTO `sys_region` VALUES ('340000', '2018-01-30 19:30:19', NULL, NULL, NULL, '安徽省', '安徽省', '1', 12, 'A', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('340100', '2018-01-30 19:30:19', NULL, NULL, NULL, '合肥市', '安徽省合肥市', '2', 1, 'H', NULL, '1', '230001', '340000');
INSERT INTO `sys_region` VALUES ('340101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省合肥市市辖区', '3', 1, 'S', NULL, '1', NULL, '340100');
INSERT INTO `sys_region` VALUES ('340102', '2018-01-30 19:30:19', NULL, NULL, NULL, '瑶海区', '安徽省合肥市瑶海区', '3', 2, 'Y', NULL, '1', '230011', '340100');
INSERT INTO `sys_region` VALUES ('340103', '2018-01-30 19:30:19', NULL, NULL, NULL, '庐阳区', '安徽省合肥市庐阳区', '3', 3, 'L', NULL, '1', '230001', '340100');
INSERT INTO `sys_region` VALUES ('340104', '2018-01-30 19:30:19', NULL, NULL, NULL, '蜀山区', '安徽省合肥市蜀山区', '3', 4, 'S', NULL, '1', '230031', '340100');
INSERT INTO `sys_region` VALUES ('340111', '2018-01-30 19:30:19', NULL, NULL, NULL, '包河区', '安徽省合肥市包河区', '3', 5, 'B', NULL, '1', '230041', '340100');
INSERT INTO `sys_region` VALUES ('340121', '2018-01-30 19:30:19', NULL, NULL, NULL, '长丰县', '安徽省合肥市长丰县', '3', 6, 'C', NULL, '1', '231100', '340100');
INSERT INTO `sys_region` VALUES ('340122', '2018-01-30 19:30:19', NULL, NULL, NULL, '肥东县', '安徽省合肥市肥东县', '3', 7, 'F', NULL, '1', '231600', '340100');
INSERT INTO `sys_region` VALUES ('340123', '2018-01-30 19:30:19', NULL, NULL, NULL, '肥西县', '安徽省合肥市肥西县', '3', 8, 'F', NULL, '1', '231200', '340100');
INSERT INTO `sys_region` VALUES ('340124', '2018-01-30 19:30:19', NULL, NULL, NULL, '庐江县', '安徽省合肥市庐江县', '3', 9, 'L', NULL, '1', '231500', '340100');
INSERT INTO `sys_region` VALUES ('340181', '2018-01-30 19:30:19', NULL, NULL, NULL, '巢湖市', '安徽省合肥市巢湖市', '3', 10, 'C', NULL, '1', '238000', '340100');
INSERT INTO `sys_region` VALUES ('340200', '2018-01-30 19:30:19', NULL, NULL, NULL, '芜湖市', '安徽省芜湖市', '2', 2, 'W', NULL, '1', '241000', '340000');
INSERT INTO `sys_region` VALUES ('340201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省芜湖市市辖区', '3', 1, 'S', NULL, '1', NULL, '340200');
INSERT INTO `sys_region` VALUES ('340202', '2018-01-30 19:30:19', NULL, NULL, NULL, '镜湖区', '安徽省芜湖市镜湖区', '3', 2, 'J', NULL, '1', '241000', '340200');
INSERT INTO `sys_region` VALUES ('340203', '2018-01-30 19:30:19', NULL, NULL, NULL, '弋江区', '安徽省芜湖市弋江区', '3', 3, 'Z', NULL, '1', '241000', '340200');
INSERT INTO `sys_region` VALUES ('340207', '2018-01-30 19:30:19', NULL, NULL, NULL, '鸠江区', '安徽省芜湖市鸠江区', '3', 4, 'Z', NULL, '1', '241000', '340200');
INSERT INTO `sys_region` VALUES ('340208', '2018-01-30 19:30:19', NULL, NULL, NULL, '三山区', '安徽省芜湖市三山区', '3', 5, 'S', NULL, '1', '241000', '340200');
INSERT INTO `sys_region` VALUES ('340221', '2018-01-30 19:30:19', NULL, NULL, NULL, '芜湖县', '安徽省芜湖市芜湖县', '3', 6, 'W', NULL, '1', '241100', '340200');
INSERT INTO `sys_region` VALUES ('340222', '2018-01-30 19:30:19', NULL, NULL, NULL, '繁昌县', '安徽省芜湖市繁昌县', '3', 7, 'F', NULL, '1', '241200', '340200');
INSERT INTO `sys_region` VALUES ('340223', '2018-01-30 19:30:19', NULL, NULL, NULL, '南陵县', '安徽省芜湖市南陵县', '3', 8, 'N', NULL, '1', '242400', '340200');
INSERT INTO `sys_region` VALUES ('340225', '2018-01-30 19:30:19', NULL, NULL, NULL, '无为县', '安徽省芜湖市无为县', '3', 9, 'W', NULL, '1', '238300', '340200');
INSERT INTO `sys_region` VALUES ('340300', '2018-01-30 19:30:19', NULL, NULL, NULL, '蚌埠市', '安徽省蚌埠市', '2', 3, 'B', NULL, '1', '233000', '340000');
INSERT INTO `sys_region` VALUES ('340301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省蚌埠市市辖区', '3', 1, 'S', NULL, '1', NULL, '340300');
INSERT INTO `sys_region` VALUES ('340302', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙子湖区', '安徽省蚌埠市龙子湖区', '3', 2, 'L', NULL, '1', '233000', '340300');
INSERT INTO `sys_region` VALUES ('340303', '2018-01-30 19:30:19', NULL, NULL, NULL, '蚌山区', '安徽省蚌埠市蚌山区', '3', 3, 'B', NULL, '1', '233000', '340300');
INSERT INTO `sys_region` VALUES ('340304', '2018-01-30 19:30:19', NULL, NULL, NULL, '禹会区', '安徽省蚌埠市禹会区', '3', 4, 'Y', NULL, '1', '233010', '340300');
INSERT INTO `sys_region` VALUES ('340311', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮上区', '安徽省蚌埠市淮上区', '3', 5, 'H', NULL, '1', '233002', '340300');
INSERT INTO `sys_region` VALUES ('340321', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀远县', '安徽省蚌埠市怀远县', '3', 6, 'H', NULL, '1', '233400', '340300');
INSERT INTO `sys_region` VALUES ('340322', '2018-01-30 19:30:19', NULL, NULL, NULL, '五河县', '安徽省蚌埠市五河县', '3', 7, 'W', NULL, '1', '233300', '340300');
INSERT INTO `sys_region` VALUES ('340323', '2018-01-30 19:30:19', NULL, NULL, NULL, '固镇县', '安徽省蚌埠市固镇县', '3', 8, 'G', NULL, '1', '233700', '340300');
INSERT INTO `sys_region` VALUES ('340400', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮南市', '安徽省淮南市', '2', 4, 'H', NULL, '1', '232001', '340000');
INSERT INTO `sys_region` VALUES ('340401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省淮南市市辖区', '3', 1, 'S', NULL, '1', NULL, '340400');
INSERT INTO `sys_region` VALUES ('340402', '2018-01-30 19:30:19', NULL, NULL, NULL, '大通区', '安徽省淮南市大通区', '3', 2, 'D', NULL, '1', '232033', '340400');
INSERT INTO `sys_region` VALUES ('340403', '2018-01-30 19:30:19', NULL, NULL, NULL, '田家庵区', '安徽省淮南市田家庵区', '3', 3, 'T', NULL, '1', '232000', '340400');
INSERT INTO `sys_region` VALUES ('340404', '2018-01-30 19:30:19', NULL, NULL, NULL, '谢家集区', '安徽省淮南市谢家集区', '3', 4, 'X', NULL, '1', '232052', '340400');
INSERT INTO `sys_region` VALUES ('340405', '2018-01-30 19:30:19', NULL, NULL, NULL, '八公山区', '安徽省淮南市八公山区', '3', 5, 'B', NULL, '1', '232072', '340400');
INSERT INTO `sys_region` VALUES ('340406', '2018-01-30 19:30:19', NULL, NULL, NULL, '潘集区', '安徽省淮南市潘集区', '3', 6, 'P', NULL, '1', '232082', '340400');
INSERT INTO `sys_region` VALUES ('340421', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤台县', '安徽省淮南市凤台县', '3', 7, 'F', NULL, '1', '232100', '340400');
INSERT INTO `sys_region` VALUES ('340422', '2018-01-30 19:30:19', NULL, NULL, NULL, '寿县', '安徽省淮南市寿县', '3', 8, 'S', NULL, '1', NULL, '340400');
INSERT INTO `sys_region` VALUES ('340500', '2018-01-30 19:30:19', NULL, NULL, NULL, '马鞍山市', '安徽省马鞍山市', '2', 5, 'M', NULL, '1', '243001', '340000');
INSERT INTO `sys_region` VALUES ('340501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省马鞍山市市辖区', '3', 1, 'S', NULL, '1', NULL, '340500');
INSERT INTO `sys_region` VALUES ('340503', '2018-01-30 19:30:19', NULL, NULL, NULL, '花山区', '安徽省马鞍山市花山区', '3', 2, 'H', NULL, '1', '243000', '340500');
INSERT INTO `sys_region` VALUES ('340504', '2018-01-30 19:30:19', NULL, NULL, NULL, '雨山区', '安徽省马鞍山市雨山区', '3', 3, 'Y', NULL, '1', '243071', '340500');
INSERT INTO `sys_region` VALUES ('340506', '2018-01-30 19:30:19', NULL, NULL, NULL, '博望区', '安徽省马鞍山市博望区', '3', 4, 'B', NULL, '1', '243131', '340500');
INSERT INTO `sys_region` VALUES ('340521', '2018-01-30 19:30:19', NULL, NULL, NULL, '当涂县', '安徽省马鞍山市当涂县', '3', 5, 'D', NULL, '1', '243100', '340500');
INSERT INTO `sys_region` VALUES ('340522', '2018-01-30 19:30:19', NULL, NULL, NULL, '含山县', '安徽省马鞍山市含山县', '3', 6, 'H', NULL, '1', '238100', '340500');
INSERT INTO `sys_region` VALUES ('340523', '2018-01-30 19:30:19', NULL, NULL, NULL, '和县', '安徽省马鞍山市和县', '3', 7, 'H', NULL, '1', '238200', '340500');
INSERT INTO `sys_region` VALUES ('340600', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮北市', '安徽省淮北市', '2', 6, 'H', NULL, '1', '235000', '340000');
INSERT INTO `sys_region` VALUES ('340601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省淮北市市辖区', '3', 1, 'S', NULL, '1', NULL, '340600');
INSERT INTO `sys_region` VALUES ('340602', '2018-01-30 19:30:19', NULL, NULL, NULL, '杜集区', '安徽省淮北市杜集区', '3', 2, 'D', NULL, '1', '235000', '340600');
INSERT INTO `sys_region` VALUES ('340603', '2018-01-30 19:30:19', NULL, NULL, NULL, '相山区', '安徽省淮北市相山区', '3', 3, 'X', NULL, '1', '235000', '340600');
INSERT INTO `sys_region` VALUES ('340604', '2018-01-30 19:30:19', NULL, NULL, NULL, '烈山区', '安徽省淮北市烈山区', '3', 4, 'L', NULL, '1', '235000', '340600');
INSERT INTO `sys_region` VALUES ('340621', '2018-01-30 19:30:19', NULL, NULL, NULL, '濉溪县', '安徽省淮北市濉溪县', '3', 5, 'Z', NULL, '1', '235100', '340600');
INSERT INTO `sys_region` VALUES ('340700', '2018-01-30 19:30:19', NULL, NULL, NULL, '铜陵市', '安徽省铜陵市', '2', 7, 'T', NULL, '1', '244000', '340000');
INSERT INTO `sys_region` VALUES ('340701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省铜陵市市辖区', '3', 1, 'S', NULL, '1', NULL, '340700');
INSERT INTO `sys_region` VALUES ('340705', '2018-01-30 19:30:19', NULL, NULL, NULL, '铜官区', '安徽省铜陵市铜官区', '3', 2, 'T', NULL, '1', NULL, '340700');
INSERT INTO `sys_region` VALUES ('340706', '2018-01-30 19:30:19', NULL, NULL, NULL, '义安区', '安徽省铜陵市义安区', '3', 3, 'Y', NULL, '1', NULL, '340700');
INSERT INTO `sys_region` VALUES ('340711', '2018-01-30 19:30:19', NULL, NULL, NULL, '郊区', '安徽省铜陵市郊区', '3', 4, 'J', NULL, '1', '244000', '340700');
INSERT INTO `sys_region` VALUES ('340722', '2018-01-30 19:30:19', NULL, NULL, NULL, '枞阳县', '安徽省铜陵市枞阳县', '3', 5, 'Z', NULL, '1', NULL, '340700');
INSERT INTO `sys_region` VALUES ('340800', '2018-01-30 19:30:19', NULL, NULL, NULL, '安庆市', '安徽省安庆市', '2', 8, 'A', NULL, '1', '246001', '340000');
INSERT INTO `sys_region` VALUES ('340801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省安庆市市辖区', '3', 1, 'S', NULL, '1', NULL, '340800');
INSERT INTO `sys_region` VALUES ('340802', '2018-01-30 19:30:19', NULL, NULL, NULL, '迎江区', '安徽省安庆市迎江区', '3', 2, 'Y', NULL, '1', '246001', '340800');
INSERT INTO `sys_region` VALUES ('340803', '2018-01-30 19:30:19', NULL, NULL, NULL, '大观区', '安徽省安庆市大观区', '3', 3, 'D', NULL, '1', '246002', '340800');
INSERT INTO `sys_region` VALUES ('340811', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜秀区', '安徽省安庆市宜秀区', '3', 4, 'Y', NULL, '1', '246003', '340800');
INSERT INTO `sys_region` VALUES ('340822', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀宁县', '安徽省安庆市怀宁县', '3', 5, 'H', NULL, '1', '246100', '340800');
INSERT INTO `sys_region` VALUES ('340824', '2018-01-30 19:30:19', NULL, NULL, NULL, '潜山县', '安徽省安庆市潜山县', '3', 6, 'Q', NULL, '1', '246300', '340800');
INSERT INTO `sys_region` VALUES ('340825', '2018-01-30 19:30:19', NULL, NULL, NULL, '太湖县', '安徽省安庆市太湖县', '3', 7, 'T', NULL, '1', '246400', '340800');
INSERT INTO `sys_region` VALUES ('340826', '2018-01-30 19:30:19', NULL, NULL, NULL, '宿松县', '安徽省安庆市宿松县', '3', 8, 'S', NULL, '1', '246500', '340800');
INSERT INTO `sys_region` VALUES ('340827', '2018-01-30 19:30:19', NULL, NULL, NULL, '望江县', '安徽省安庆市望江县', '3', 9, 'W', NULL, '1', '246200', '340800');
INSERT INTO `sys_region` VALUES ('340828', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳西县', '安徽省安庆市岳西县', '3', 10, 'Y', NULL, '1', '246600', '340800');
INSERT INTO `sys_region` VALUES ('340881', '2018-01-30 19:30:19', NULL, NULL, NULL, '桐城市', '安徽省安庆市桐城市', '3', 11, 'T', NULL, '1', '231400', '340800');
INSERT INTO `sys_region` VALUES ('341000', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄山市', '安徽省黄山市', '2', 9, 'H', NULL, '1', '245000', '340000');
INSERT INTO `sys_region` VALUES ('341001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省黄山市市辖区', '3', 1, 'S', NULL, '1', NULL, '341000');
INSERT INTO `sys_region` VALUES ('341002', '2018-01-30 19:30:19', NULL, NULL, NULL, '屯溪区', '安徽省黄山市屯溪区', '3', 2, 'T', NULL, '1', '245000', '341000');
INSERT INTO `sys_region` VALUES ('341003', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄山区', '安徽省黄山市黄山区', '3', 3, 'H', NULL, '1', '242700', '341000');
INSERT INTO `sys_region` VALUES ('341004', '2018-01-30 19:30:19', NULL, NULL, NULL, '徽州区', '安徽省黄山市徽州区', '3', 4, 'H', NULL, '1', '245061', '341000');
INSERT INTO `sys_region` VALUES ('341021', '2018-01-30 19:30:19', NULL, NULL, NULL, '歙县', '安徽省黄山市歙县', '3', 5, 'Z', NULL, '1', '245200', '341000');
INSERT INTO `sys_region` VALUES ('341022', '2018-01-30 19:30:19', NULL, NULL, NULL, '休宁县', '安徽省黄山市休宁县', '3', 6, 'X', NULL, '1', '245400', '341000');
INSERT INTO `sys_region` VALUES ('341023', '2018-01-30 19:30:19', NULL, NULL, NULL, '黟县', '安徽省黄山市黟县', '3', 7, 'Z', NULL, '1', '245500', '341000');
INSERT INTO `sys_region` VALUES ('341024', '2018-01-30 19:30:19', NULL, NULL, NULL, '祁门县', '安徽省黄山市祁门县', '3', 8, 'Q', NULL, '1', '245600', '341000');
INSERT INTO `sys_region` VALUES ('341100', '2018-01-30 19:30:19', NULL, NULL, NULL, '滁州市', '安徽省滁州市', '2', 10, 'C', NULL, '1', '239000', '340000');
INSERT INTO `sys_region` VALUES ('341101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省滁州市市辖区', '3', 1, 'S', NULL, '1', NULL, '341100');
INSERT INTO `sys_region` VALUES ('341102', '2018-01-30 19:30:19', NULL, NULL, NULL, '琅琊区', '安徽省滁州市琅琊区', '3', 2, 'L', NULL, '1', '239000', '341100');
INSERT INTO `sys_region` VALUES ('341103', '2018-01-30 19:30:19', NULL, NULL, NULL, '南谯区', '安徽省滁州市南谯区', '3', 3, 'N', NULL, '1', '239000', '341100');
INSERT INTO `sys_region` VALUES ('341122', '2018-01-30 19:30:19', NULL, NULL, NULL, '来安县', '安徽省滁州市来安县', '3', 4, 'L', NULL, '1', '239200', '341100');
INSERT INTO `sys_region` VALUES ('341124', '2018-01-30 19:30:19', NULL, NULL, NULL, '全椒县', '安徽省滁州市全椒县', '3', 5, 'Q', NULL, '1', '239500', '341100');
INSERT INTO `sys_region` VALUES ('341125', '2018-01-30 19:30:19', NULL, NULL, NULL, '定远县', '安徽省滁州市定远县', '3', 6, 'D', NULL, '1', '233200', '341100');
INSERT INTO `sys_region` VALUES ('341126', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤阳县', '安徽省滁州市凤阳县', '3', 7, 'F', NULL, '1', '233100', '341100');
INSERT INTO `sys_region` VALUES ('341181', '2018-01-30 19:30:19', NULL, NULL, NULL, '天长市', '安徽省滁州市天长市', '3', 8, 'T', NULL, '1', '239300', '341100');
INSERT INTO `sys_region` VALUES ('341182', '2018-01-30 19:30:19', NULL, NULL, NULL, '明光市', '安徽省滁州市明光市', '3', 9, 'M', NULL, '1', '239400', '341100');
INSERT INTO `sys_region` VALUES ('341200', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜阳市', '安徽省阜阳市', '2', 11, 'F', NULL, '1', '236033', '340000');
INSERT INTO `sys_region` VALUES ('341201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省阜阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '341200');
INSERT INTO `sys_region` VALUES ('341202', '2018-01-30 19:30:19', NULL, NULL, NULL, '颍州区', '安徽省阜阳市颍州区', '3', 2, 'Z', NULL, '1', '236001', '341200');
INSERT INTO `sys_region` VALUES ('341203', '2018-01-30 19:30:19', NULL, NULL, NULL, '颍东区', '安徽省阜阳市颍东区', '3', 3, 'Z', NULL, '1', '236058', '341200');
INSERT INTO `sys_region` VALUES ('341204', '2018-01-30 19:30:19', NULL, NULL, NULL, '颍泉区', '安徽省阜阳市颍泉区', '3', 4, 'Z', NULL, '1', '236045', '341200');
INSERT INTO `sys_region` VALUES ('341221', '2018-01-30 19:30:19', NULL, NULL, NULL, '临泉县', '安徽省阜阳市临泉县', '3', 5, 'L', NULL, '1', '236400', '341200');
INSERT INTO `sys_region` VALUES ('341222', '2018-01-30 19:30:19', NULL, NULL, NULL, '太和县', '安徽省阜阳市太和县', '3', 6, 'T', NULL, '1', '236600', '341200');
INSERT INTO `sys_region` VALUES ('341225', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜南县', '安徽省阜阳市阜南县', '3', 7, 'F', NULL, '1', '236300', '341200');
INSERT INTO `sys_region` VALUES ('341226', '2018-01-30 19:30:19', NULL, NULL, NULL, '颍上县', '安徽省阜阳市颍上县', '3', 8, 'Z', NULL, '1', '236200', '341200');
INSERT INTO `sys_region` VALUES ('341282', '2018-01-30 19:30:19', NULL, NULL, NULL, '界首市', '安徽省阜阳市界首市', '3', 9, 'J', NULL, '1', '236500', '341200');
INSERT INTO `sys_region` VALUES ('341300', '2018-01-30 19:30:19', NULL, NULL, NULL, '宿州市', '安徽省宿州市', '2', 12, 'S', NULL, '1', '234000', '340000');
INSERT INTO `sys_region` VALUES ('341301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省宿州市市辖区', '3', 1, 'S', NULL, '1', NULL, '341300');
INSERT INTO `sys_region` VALUES ('341302', '2018-01-30 19:30:19', NULL, NULL, NULL, '埇桥区', '安徽省宿州市埇桥区', '3', 2, NULL, NULL, '1', '234000', '341300');
INSERT INTO `sys_region` VALUES ('341321', '2018-01-30 19:30:19', NULL, NULL, NULL, '砀山县', '安徽省宿州市砀山县', '3', 3, 'Z', NULL, '1', '235300', '341300');
INSERT INTO `sys_region` VALUES ('341322', '2018-01-30 19:30:19', NULL, NULL, NULL, '萧县', '安徽省宿州市萧县', '3', 4, 'X', NULL, '1', '235200', '341300');
INSERT INTO `sys_region` VALUES ('341323', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵璧县', '安徽省宿州市灵璧县', '3', 5, 'L', NULL, '1', '234200', '341300');
INSERT INTO `sys_region` VALUES ('341324', '2018-01-30 19:30:19', NULL, NULL, NULL, '泗县', '安徽省宿州市泗县', '3', 6, 'Z', NULL, '1', '234300', '341300');
INSERT INTO `sys_region` VALUES ('341500', '2018-01-30 19:30:19', NULL, NULL, NULL, '六安市', '安徽省六安市', '2', 13, 'L', NULL, '1', '237000', '340000');
INSERT INTO `sys_region` VALUES ('341501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省六安市市辖区', '3', 1, 'S', NULL, '1', NULL, '341500');
INSERT INTO `sys_region` VALUES ('341502', '2018-01-30 19:30:19', NULL, NULL, NULL, '金安区', '安徽省六安市金安区', '3', 2, 'J', NULL, '1', '237005', '341500');
INSERT INTO `sys_region` VALUES ('341503', '2018-01-30 19:30:19', NULL, NULL, NULL, '裕安区', '安徽省六安市裕安区', '3', 3, 'Y', NULL, '1', '237010', '341500');
INSERT INTO `sys_region` VALUES ('341504', '2018-01-30 19:30:19', NULL, NULL, NULL, '叶集区', '安徽省六安市叶集区', '3', 4, 'Y', NULL, '1', NULL, '341500');
INSERT INTO `sys_region` VALUES ('341522', '2018-01-30 19:30:19', NULL, NULL, NULL, '霍邱县', '安徽省六安市霍邱县', '3', 5, 'H', NULL, '1', '237400', '341500');
INSERT INTO `sys_region` VALUES ('341523', '2018-01-30 19:30:19', NULL, NULL, NULL, '舒城县', '安徽省六安市舒城县', '3', 6, 'S', NULL, '1', '231300', '341500');
INSERT INTO `sys_region` VALUES ('341524', '2018-01-30 19:30:19', NULL, NULL, NULL, '金寨县', '安徽省六安市金寨县', '3', 7, 'J', NULL, '1', '237300', '341500');
INSERT INTO `sys_region` VALUES ('341525', '2018-01-30 19:30:19', NULL, NULL, NULL, '霍山县', '安徽省六安市霍山县', '3', 8, 'H', NULL, '1', '237200', '341500');
INSERT INTO `sys_region` VALUES ('341600', '2018-01-30 19:30:19', NULL, NULL, NULL, '亳州市', '安徽省亳州市', '2', 14, 'Z', NULL, '1', '236802', '340000');
INSERT INTO `sys_region` VALUES ('341601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省亳州市市辖区', '3', 1, 'S', NULL, '1', NULL, '341600');
INSERT INTO `sys_region` VALUES ('341602', '2018-01-30 19:30:19', NULL, NULL, NULL, '谯城区', '安徽省亳州市谯城区', '3', 2, 'Z', NULL, '1', '236800', '341600');
INSERT INTO `sys_region` VALUES ('341621', '2018-01-30 19:30:19', NULL, NULL, NULL, '涡阳县', '安徽省亳州市涡阳县', '3', 3, 'W', NULL, '1', '233600', '341600');
INSERT INTO `sys_region` VALUES ('341622', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒙城县', '安徽省亳州市蒙城县', '3', 4, 'M', NULL, '1', '233500', '341600');
INSERT INTO `sys_region` VALUES ('341623', '2018-01-30 19:30:19', NULL, NULL, NULL, '利辛县', '安徽省亳州市利辛县', '3', 5, 'L', NULL, '1', '236700', '341600');
INSERT INTO `sys_region` VALUES ('341700', '2018-01-30 19:30:19', NULL, NULL, NULL, '池州市', '安徽省池州市', '2', 15, 'C', NULL, '1', '247100', '340000');
INSERT INTO `sys_region` VALUES ('341701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省池州市市辖区', '3', 1, 'S', NULL, '1', NULL, '341700');
INSERT INTO `sys_region` VALUES ('341702', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵池区', '安徽省池州市贵池区', '3', 2, 'G', NULL, '1', '247100', '341700');
INSERT INTO `sys_region` VALUES ('341721', '2018-01-30 19:30:19', NULL, NULL, NULL, '东至县', '安徽省池州市东至县', '3', 3, 'D', NULL, '1', '247200', '341700');
INSERT INTO `sys_region` VALUES ('341722', '2018-01-30 19:30:19', NULL, NULL, NULL, '石台县', '安徽省池州市石台县', '3', 4, 'S', NULL, '1', '245100', '341700');
INSERT INTO `sys_region` VALUES ('341723', '2018-01-30 19:30:19', NULL, NULL, NULL, '青阳县', '安徽省池州市青阳县', '3', 5, 'Q', NULL, '1', '242800', '341700');
INSERT INTO `sys_region` VALUES ('341800', '2018-01-30 19:30:19', NULL, NULL, NULL, '宣城市', '安徽省宣城市', '2', 16, 'X', NULL, '1', '242000', '340000');
INSERT INTO `sys_region` VALUES ('341801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '安徽省宣城市市辖区', '3', 1, 'S', NULL, '1', NULL, '341800');
INSERT INTO `sys_region` VALUES ('341802', '2018-01-30 19:30:19', NULL, NULL, NULL, '宣州区', '安徽省宣城市宣州区', '3', 2, 'X', NULL, '1', '242000', '341800');
INSERT INTO `sys_region` VALUES ('341821', '2018-01-30 19:30:19', NULL, NULL, NULL, '郎溪县', '安徽省宣城市郎溪县', '3', 3, 'L', NULL, '1', '242100', '341800');
INSERT INTO `sys_region` VALUES ('341822', '2018-01-30 19:30:19', NULL, NULL, NULL, '广德县', '安徽省宣城市广德县', '3', 4, 'G', NULL, '1', '242200', '341800');
INSERT INTO `sys_region` VALUES ('341823', '2018-01-30 19:30:19', NULL, NULL, NULL, '泾县', '安徽省宣城市泾县', '3', 5, 'Z', NULL, '1', '242500', '341800');
INSERT INTO `sys_region` VALUES ('341824', '2018-01-30 19:30:19', NULL, NULL, NULL, '绩溪县', '安徽省宣城市绩溪县', '3', 6, 'J', NULL, '1', '245300', '341800');
INSERT INTO `sys_region` VALUES ('341825', '2018-01-30 19:30:19', NULL, NULL, NULL, '旌德县', '安徽省宣城市旌德县', '3', 7, 'Z', NULL, '1', '242600', '341800');
INSERT INTO `sys_region` VALUES ('341881', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁国市', '安徽省宣城市宁国市', '3', 8, 'N', NULL, '1', '242300', '341800');
INSERT INTO `sys_region` VALUES ('350000', '2018-01-30 19:30:19', NULL, NULL, NULL, '福建省', '福建省', '1', 13, 'F', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('350100', '2018-01-30 19:30:19', NULL, NULL, NULL, '福州市', '福建省福州市', '2', 1, 'F', NULL, '1', '350001', '350000');
INSERT INTO `sys_region` VALUES ('350101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省福州市市辖区', '3', 1, 'S', NULL, '1', NULL, '350100');
INSERT INTO `sys_region` VALUES ('350102', '2018-01-30 19:30:19', NULL, NULL, NULL, '鼓楼区', '福建省福州市鼓楼区', '3', 2, 'G', NULL, '1', '350001', '350100');
INSERT INTO `sys_region` VALUES ('350103', '2018-01-30 19:30:19', NULL, NULL, NULL, '台江区', '福建省福州市台江区', '3', 3, 'T', NULL, '1', '350004', '350100');
INSERT INTO `sys_region` VALUES ('350104', '2018-01-30 19:30:19', NULL, NULL, NULL, '仓山区', '福建省福州市仓山区', '3', 4, 'C', NULL, '1', '350007', '350100');
INSERT INTO `sys_region` VALUES ('350105', '2018-01-30 19:30:19', NULL, NULL, NULL, '马尾区', '福建省福州市马尾区', '3', 5, 'M', NULL, '1', '350015', '350100');
INSERT INTO `sys_region` VALUES ('350111', '2018-01-30 19:30:19', NULL, NULL, NULL, '晋安区', '福建省福州市晋安区', '3', 6, 'J', NULL, '1', '350011', '350100');
INSERT INTO `sys_region` VALUES ('350121', '2018-01-30 19:30:19', NULL, NULL, NULL, '闽侯县', '福建省福州市闽侯县', '3', 7, 'M', NULL, '1', '350100', '350100');
INSERT INTO `sys_region` VALUES ('350122', '2018-01-30 19:30:19', NULL, NULL, NULL, '连江县', '福建省福州市连江县', '3', 8, 'L', NULL, '1', '350500', '350100');
INSERT INTO `sys_region` VALUES ('350123', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗源县', '福建省福州市罗源县', '3', 9, 'L', NULL, '1', '350600', '350100');
INSERT INTO `sys_region` VALUES ('350124', '2018-01-30 19:30:19', NULL, NULL, NULL, '闽清县', '福建省福州市闽清县', '3', 10, 'M', NULL, '1', '350800', '350100');
INSERT INTO `sys_region` VALUES ('350125', '2018-01-30 19:30:19', NULL, NULL, NULL, '永泰县', '福建省福州市永泰县', '3', 11, 'Y', NULL, '1', '350700', '350100');
INSERT INTO `sys_region` VALUES ('350128', '2018-01-30 19:30:19', NULL, NULL, NULL, '平潭县', '福建省福州市平潭县', '3', 12, 'P', NULL, '1', '350400', '350100');
INSERT INTO `sys_region` VALUES ('350181', '2018-01-30 19:30:19', NULL, NULL, NULL, '福清市', '福建省福州市福清市', '3', 13, 'F', NULL, '1', '350300', '350100');
INSERT INTO `sys_region` VALUES ('350182', '2018-01-30 19:30:19', NULL, NULL, NULL, '长乐市', '福建省福州市长乐市', '3', 14, 'C', NULL, '1', '350200', '350100');
INSERT INTO `sys_region` VALUES ('350200', '2018-01-30 19:30:19', NULL, NULL, NULL, '厦门市', '福建省厦门市', '2', 2, 'X', NULL, '1', '361003', '350000');
INSERT INTO `sys_region` VALUES ('350201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省厦门市市辖区', '3', 1, 'S', NULL, '1', NULL, '350200');
INSERT INTO `sys_region` VALUES ('350203', '2018-01-30 19:30:19', NULL, NULL, NULL, '思明区', '福建省厦门市思明区', '3', 2, 'S', NULL, '1', '361001', '350200');
INSERT INTO `sys_region` VALUES ('350205', '2018-01-30 19:30:19', NULL, NULL, NULL, '海沧区', '福建省厦门市海沧区', '3', 3, 'H', NULL, '1', '361026', '350200');
INSERT INTO `sys_region` VALUES ('350206', '2018-01-30 19:30:19', NULL, NULL, NULL, '湖里区', '福建省厦门市湖里区', '3', 4, 'H', NULL, '1', '361006', '350200');
INSERT INTO `sys_region` VALUES ('350211', '2018-01-30 19:30:19', NULL, NULL, NULL, '集美区', '福建省厦门市集美区', '3', 5, 'J', NULL, '1', '361021', '350200');
INSERT INTO `sys_region` VALUES ('350212', '2018-01-30 19:30:19', NULL, NULL, NULL, '同安区', '福建省厦门市同安区', '3', 6, 'T', NULL, '1', '361100', '350200');
INSERT INTO `sys_region` VALUES ('350213', '2018-01-30 19:30:19', NULL, NULL, NULL, '翔安区', '福建省厦门市翔安区', '3', 7, 'X', NULL, '1', '361101', '350200');
INSERT INTO `sys_region` VALUES ('350300', '2018-01-30 19:30:19', NULL, NULL, NULL, '莆田市', '福建省莆田市', '2', 3, 'P', NULL, '1', '351100', '350000');
INSERT INTO `sys_region` VALUES ('350301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省莆田市市辖区', '3', 1, 'S', NULL, '1', NULL, '350300');
INSERT INTO `sys_region` VALUES ('350302', '2018-01-30 19:30:19', NULL, NULL, NULL, '城厢区', '福建省莆田市城厢区', '3', 2, 'C', NULL, '1', '351100', '350300');
INSERT INTO `sys_region` VALUES ('350303', '2018-01-30 19:30:19', NULL, NULL, NULL, '涵江区', '福建省莆田市涵江区', '3', 3, 'H', NULL, '1', '351111', '350300');
INSERT INTO `sys_region` VALUES ('350304', '2018-01-30 19:30:19', NULL, NULL, NULL, '荔城区', '福建省莆田市荔城区', '3', 4, 'L', NULL, '1', '351100', '350300');
INSERT INTO `sys_region` VALUES ('350305', '2018-01-30 19:30:19', NULL, NULL, NULL, '秀屿区', '福建省莆田市秀屿区', '3', 5, 'X', NULL, '1', '351152', '350300');
INSERT INTO `sys_region` VALUES ('350322', '2018-01-30 19:30:19', NULL, NULL, NULL, '仙游县', '福建省莆田市仙游县', '3', 6, 'X', NULL, '1', '351200', '350300');
INSERT INTO `sys_region` VALUES ('350400', '2018-01-30 19:30:19', NULL, NULL, NULL, '三明市', '福建省三明市', '2', 4, 'S', NULL, '1', '365000', '350000');
INSERT INTO `sys_region` VALUES ('350401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省三明市市辖区', '3', 1, 'S', NULL, '1', NULL, '350400');
INSERT INTO `sys_region` VALUES ('350402', '2018-01-30 19:30:19', NULL, NULL, NULL, '梅列区', '福建省三明市梅列区', '3', 2, 'M', NULL, '1', '365000', '350400');
INSERT INTO `sys_region` VALUES ('350403', '2018-01-30 19:30:19', NULL, NULL, NULL, '三元区', '福建省三明市三元区', '3', 3, 'S', NULL, '1', '365001', '350400');
INSERT INTO `sys_region` VALUES ('350421', '2018-01-30 19:30:19', NULL, NULL, NULL, '明溪县', '福建省三明市明溪县', '3', 4, 'M', NULL, '1', '365200', '350400');
INSERT INTO `sys_region` VALUES ('350423', '2018-01-30 19:30:19', NULL, NULL, NULL, '清流县', '福建省三明市清流县', '3', 5, 'Q', NULL, '1', '365300', '350400');
INSERT INTO `sys_region` VALUES ('350424', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁化县', '福建省三明市宁化县', '3', 6, 'N', NULL, '1', '365400', '350400');
INSERT INTO `sys_region` VALUES ('350425', '2018-01-30 19:30:19', NULL, NULL, NULL, '大田县', '福建省三明市大田县', '3', 7, 'D', NULL, '1', '366100', '350400');
INSERT INTO `sys_region` VALUES ('350426', '2018-01-30 19:30:19', NULL, NULL, NULL, '尤溪县', '福建省三明市尤溪县', '3', 8, 'Y', NULL, '1', '365100', '350400');
INSERT INTO `sys_region` VALUES ('350427', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙县', '福建省三明市沙县', '3', 9, 'S', NULL, '1', '365500', '350400');
INSERT INTO `sys_region` VALUES ('350428', '2018-01-30 19:30:19', NULL, NULL, NULL, '将乐县', '福建省三明市将乐县', '3', 10, 'J', NULL, '1', '353300', '350400');
INSERT INTO `sys_region` VALUES ('350429', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰宁县', '福建省三明市泰宁县', '3', 11, 'T', NULL, '1', '354400', '350400');
INSERT INTO `sys_region` VALUES ('350430', '2018-01-30 19:30:19', NULL, NULL, NULL, '建宁县', '福建省三明市建宁县', '3', 12, 'J', NULL, '1', '354500', '350400');
INSERT INTO `sys_region` VALUES ('350481', '2018-01-30 19:30:19', NULL, NULL, NULL, '永安市', '福建省三明市永安市', '3', 13, 'Y', NULL, '1', '366000', '350400');
INSERT INTO `sys_region` VALUES ('350500', '2018-01-30 19:30:19', NULL, NULL, NULL, '泉州市', '福建省泉州市', '2', 5, 'Q', NULL, '1', '362000', '350000');
INSERT INTO `sys_region` VALUES ('350501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省泉州市市辖区', '3', 1, 'S', NULL, '1', NULL, '350500');
INSERT INTO `sys_region` VALUES ('350502', '2018-01-30 19:30:19', NULL, NULL, NULL, '鲤城区', '福建省泉州市鲤城区', '3', 2, 'L', NULL, '1', '362000', '350500');
INSERT INTO `sys_region` VALUES ('350503', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰泽区', '福建省泉州市丰泽区', '3', 3, 'F', NULL, '1', '362000', '350500');
INSERT INTO `sys_region` VALUES ('350504', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛江区', '福建省泉州市洛江区', '3', 4, 'L', NULL, '1', '362011', '350500');
INSERT INTO `sys_region` VALUES ('350505', '2018-01-30 19:30:19', NULL, NULL, NULL, '泉港区', '福建省泉州市泉港区', '3', 5, 'Q', NULL, '1', '362114', '350500');
INSERT INTO `sys_region` VALUES ('350521', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠安县', '福建省泉州市惠安县', '3', 6, 'H', NULL, '1', '362100', '350500');
INSERT INTO `sys_region` VALUES ('350524', '2018-01-30 19:30:19', NULL, NULL, NULL, '安溪县', '福建省泉州市安溪县', '3', 7, 'A', NULL, '1', '362400', '350500');
INSERT INTO `sys_region` VALUES ('350525', '2018-01-30 19:30:19', NULL, NULL, NULL, '永春县', '福建省泉州市永春县', '3', 8, 'Y', NULL, '1', '362600', '350500');
INSERT INTO `sys_region` VALUES ('350526', '2018-01-30 19:30:19', NULL, NULL, NULL, '德化县', '福建省泉州市德化县', '3', 9, 'D', NULL, '1', '362500', '350500');
INSERT INTO `sys_region` VALUES ('350527', '2018-01-30 19:30:19', NULL, NULL, NULL, '金门县', '福建省泉州市金门县', '3', 10, 'J', NULL, '1', '', '350500');
INSERT INTO `sys_region` VALUES ('350581', '2018-01-30 19:30:19', NULL, NULL, NULL, '石狮市', '福建省泉州市石狮市', '3', 11, 'S', NULL, '1', '362700', '350500');
INSERT INTO `sys_region` VALUES ('350582', '2018-01-30 19:30:19', NULL, NULL, NULL, '晋江市', '福建省泉州市晋江市', '3', 12, 'J', NULL, '1', '362200', '350500');
INSERT INTO `sys_region` VALUES ('350583', '2018-01-30 19:30:19', NULL, NULL, NULL, '南安市', '福建省泉州市南安市', '3', 13, 'N', NULL, '1', '362300', '350500');
INSERT INTO `sys_region` VALUES ('350600', '2018-01-30 19:30:19', NULL, NULL, NULL, '漳州市', '福建省漳州市', '2', 6, 'Z', NULL, '1', '363005', '350000');
INSERT INTO `sys_region` VALUES ('350601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省漳州市市辖区', '3', 1, 'S', NULL, '1', NULL, '350600');
INSERT INTO `sys_region` VALUES ('350602', '2018-01-30 19:30:19', NULL, NULL, NULL, '芗城区', '福建省漳州市芗城区', '3', 2, 'Z', NULL, '1', '363000', '350600');
INSERT INTO `sys_region` VALUES ('350603', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙文区', '福建省漳州市龙文区', '3', 3, 'L', NULL, '1', '363005', '350600');
INSERT INTO `sys_region` VALUES ('350622', '2018-01-30 19:30:19', NULL, NULL, NULL, '云霄县', '福建省漳州市云霄县', '3', 4, 'Y', NULL, '1', '363300', '350600');
INSERT INTO `sys_region` VALUES ('350623', '2018-01-30 19:30:19', NULL, NULL, NULL, '漳浦县', '福建省漳州市漳浦县', '3', 5, 'Z', NULL, '1', '363200', '350600');
INSERT INTO `sys_region` VALUES ('350624', '2018-01-30 19:30:19', NULL, NULL, NULL, '诏安县', '福建省漳州市诏安县', '3', 6, 'Z', NULL, '1', '363500', '350600');
INSERT INTO `sys_region` VALUES ('350625', '2018-01-30 19:30:19', NULL, NULL, NULL, '长泰县', '福建省漳州市长泰县', '3', 7, 'C', NULL, '1', '363900', '350600');
INSERT INTO `sys_region` VALUES ('350626', '2018-01-30 19:30:19', NULL, NULL, NULL, '东山县', '福建省漳州市东山县', '3', 8, 'D', NULL, '1', '363400', '350600');
INSERT INTO `sys_region` VALUES ('350627', '2018-01-30 19:30:19', NULL, NULL, NULL, '南靖县', '福建省漳州市南靖县', '3', 9, 'N', NULL, '1', '363600', '350600');
INSERT INTO `sys_region` VALUES ('350628', '2018-01-30 19:30:19', NULL, NULL, NULL, '平和县', '福建省漳州市平和县', '3', 10, 'P', NULL, '1', '363700', '350600');
INSERT INTO `sys_region` VALUES ('350629', '2018-01-30 19:30:19', NULL, NULL, NULL, '华安县', '福建省漳州市华安县', '3', 11, 'H', NULL, '1', '363800', '350600');
INSERT INTO `sys_region` VALUES ('350681', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙海市', '福建省漳州市龙海市', '3', 12, 'L', NULL, '1', '363100', '350600');
INSERT INTO `sys_region` VALUES ('350700', '2018-01-30 19:30:19', NULL, NULL, NULL, '南平市', '福建省南平市', '2', 7, 'N', NULL, '1', '353000', '350000');
INSERT INTO `sys_region` VALUES ('350701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省南平市市辖区', '3', 1, 'S', NULL, '1', NULL, '350700');
INSERT INTO `sys_region` VALUES ('350702', '2018-01-30 19:30:19', NULL, NULL, NULL, '延平区', '福建省南平市延平区', '3', 2, 'Y', NULL, '1', '353000', '350700');
INSERT INTO `sys_region` VALUES ('350703', '2018-01-30 19:30:19', NULL, NULL, NULL, '建阳区', '福建省南平市建阳区', '3', 3, 'J', NULL, '1', '354200', '350700');
INSERT INTO `sys_region` VALUES ('350721', '2018-01-30 19:30:19', NULL, NULL, NULL, '顺昌县', '福建省南平市顺昌县', '3', 4, 'S', NULL, '1', '353200', '350700');
INSERT INTO `sys_region` VALUES ('350722', '2018-01-30 19:30:19', NULL, NULL, NULL, '浦城县', '福建省南平市浦城县', '3', 5, 'P', NULL, '1', '353400', '350700');
INSERT INTO `sys_region` VALUES ('350723', '2018-01-30 19:30:19', NULL, NULL, NULL, '光泽县', '福建省南平市光泽县', '3', 6, 'G', NULL, '1', '354100', '350700');
INSERT INTO `sys_region` VALUES ('350724', '2018-01-30 19:30:19', NULL, NULL, NULL, '松溪县', '福建省南平市松溪县', '3', 7, 'S', NULL, '1', '353500', '350700');
INSERT INTO `sys_region` VALUES ('350725', '2018-01-30 19:30:19', NULL, NULL, NULL, '政和县', '福建省南平市政和县', '3', 8, 'Z', NULL, '1', '353600', '350700');
INSERT INTO `sys_region` VALUES ('350781', '2018-01-30 19:30:19', NULL, NULL, NULL, '邵武市', '福建省南平市邵武市', '3', 9, 'S', NULL, '1', '354000', '350700');
INSERT INTO `sys_region` VALUES ('350782', '2018-01-30 19:30:19', NULL, NULL, NULL, '武夷山市', '福建省南平市武夷山市', '3', 10, 'W', NULL, '1', '354300', '350700');
INSERT INTO `sys_region` VALUES ('350783', '2018-01-30 19:30:19', NULL, NULL, NULL, '建瓯市', '福建省南平市建瓯市', '3', 11, 'J', NULL, '1', '353100', '350700');
INSERT INTO `sys_region` VALUES ('350800', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙岩市', '福建省龙岩市', '2', 8, 'L', NULL, '1', '364000', '350000');
INSERT INTO `sys_region` VALUES ('350801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省龙岩市市辖区', '3', 1, 'S', NULL, '1', NULL, '350800');
INSERT INTO `sys_region` VALUES ('350802', '2018-01-30 19:30:19', NULL, NULL, NULL, '新罗区', '福建省龙岩市新罗区', '3', 2, 'X', NULL, '1', '364000', '350800');
INSERT INTO `sys_region` VALUES ('350803', '2018-01-30 19:30:19', NULL, NULL, NULL, '永定区', '福建省龙岩市永定区', '3', 3, 'Y', NULL, '1', NULL, '350800');
INSERT INTO `sys_region` VALUES ('350821', '2018-01-30 19:30:19', NULL, NULL, NULL, '长汀县', '福建省龙岩市长汀县', '3', 4, 'C', NULL, '1', '366300', '350800');
INSERT INTO `sys_region` VALUES ('350823', '2018-01-30 19:30:19', NULL, NULL, NULL, '上杭县', '福建省龙岩市上杭县', '3', 5, 'S', NULL, '1', '364200', '350800');
INSERT INTO `sys_region` VALUES ('350824', '2018-01-30 19:30:19', NULL, NULL, NULL, '武平县', '福建省龙岩市武平县', '3', 6, 'W', NULL, '1', '364300', '350800');
INSERT INTO `sys_region` VALUES ('350825', '2018-01-30 19:30:19', NULL, NULL, NULL, '连城县', '福建省龙岩市连城县', '3', 7, 'L', NULL, '1', '366200', '350800');
INSERT INTO `sys_region` VALUES ('350881', '2018-01-30 19:30:19', NULL, NULL, NULL, '漳平市', '福建省龙岩市漳平市', '3', 8, 'Z', NULL, '1', '364400', '350800');
INSERT INTO `sys_region` VALUES ('350900', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁德市', '福建省宁德市', '2', 9, 'N', NULL, '1', '352100', '350000');
INSERT INTO `sys_region` VALUES ('350901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '福建省宁德市市辖区', '3', 1, 'S', NULL, '1', NULL, '350900');
INSERT INTO `sys_region` VALUES ('350902', '2018-01-30 19:30:19', NULL, NULL, NULL, '蕉城区', '福建省宁德市蕉城区', '3', 2, 'J', NULL, '1', '352100', '350900');
INSERT INTO `sys_region` VALUES ('350921', '2018-01-30 19:30:19', NULL, NULL, NULL, '霞浦县', '福建省宁德市霞浦县', '3', 3, 'X', NULL, '1', '355100', '350900');
INSERT INTO `sys_region` VALUES ('350922', '2018-01-30 19:30:19', NULL, NULL, NULL, '古田县', '福建省宁德市古田县', '3', 4, 'G', NULL, '1', '352200', '350900');
INSERT INTO `sys_region` VALUES ('350923', '2018-01-30 19:30:19', NULL, NULL, NULL, '屏南县', '福建省宁德市屏南县', '3', 5, 'P', NULL, '1', '352300', '350900');
INSERT INTO `sys_region` VALUES ('350924', '2018-01-30 19:30:19', NULL, NULL, NULL, '寿宁县', '福建省宁德市寿宁县', '3', 6, 'S', NULL, '1', '355500', '350900');
INSERT INTO `sys_region` VALUES ('350925', '2018-01-30 19:30:19', NULL, NULL, NULL, '周宁县', '福建省宁德市周宁县', '3', 7, 'Z', NULL, '1', '355400', '350900');
INSERT INTO `sys_region` VALUES ('350926', '2018-01-30 19:30:19', NULL, NULL, NULL, '柘荣县', '福建省宁德市柘荣县', '3', 8, 'Z', NULL, '1', '355300', '350900');
INSERT INTO `sys_region` VALUES ('350981', '2018-01-30 19:30:19', NULL, NULL, NULL, '福安市', '福建省宁德市福安市', '3', 9, 'F', NULL, '1', '355000', '350900');
INSERT INTO `sys_region` VALUES ('350982', '2018-01-30 19:30:19', NULL, NULL, NULL, '福鼎市', '福建省宁德市福鼎市', '3', 10, 'F', NULL, '1', '355200', '350900');
INSERT INTO `sys_region` VALUES ('360000', '2018-01-30 19:30:19', NULL, NULL, NULL, '江西省', '江西省', '1', 14, 'J', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('360100', '2018-01-30 19:30:19', NULL, NULL, NULL, '南昌市', '江西省南昌市', '2', 1, 'N', NULL, '1', '330008', '360000');
INSERT INTO `sys_region` VALUES ('360101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省南昌市市辖区', '3', 1, 'S', NULL, '1', NULL, '360100');
INSERT INTO `sys_region` VALUES ('360102', '2018-01-30 19:30:19', NULL, NULL, NULL, '东湖区', '江西省南昌市东湖区', '3', 2, 'D', NULL, '1', '330006', '360100');
INSERT INTO `sys_region` VALUES ('360103', '2018-01-30 19:30:19', NULL, NULL, NULL, '西湖区', '江西省南昌市西湖区', '3', 3, 'X', NULL, '1', '330009', '360100');
INSERT INTO `sys_region` VALUES ('360104', '2018-01-30 19:30:19', NULL, NULL, NULL, '青云谱区', '江西省南昌市青云谱区', '3', 4, 'Q', NULL, '1', '330001', '360100');
INSERT INTO `sys_region` VALUES ('360105', '2018-01-30 19:30:19', NULL, NULL, NULL, '湾里区', '江西省南昌市湾里区', '3', 5, 'W', NULL, '1', '330004', '360100');
INSERT INTO `sys_region` VALUES ('360111', '2018-01-30 19:30:19', NULL, NULL, NULL, '青山湖区', '江西省南昌市青山湖区', '3', 6, 'Q', NULL, '1', '330029', '360100');
INSERT INTO `sys_region` VALUES ('360112', '2018-01-30 19:30:19', NULL, NULL, NULL, '新建区', '江西省南昌市新建区', '3', 7, 'X', NULL, '1', NULL, '360100');
INSERT INTO `sys_region` VALUES ('360121', '2018-01-30 19:30:19', NULL, NULL, NULL, '南昌县', '江西省南昌市南昌县', '3', 8, 'N', NULL, '1', '330200', '360100');
INSERT INTO `sys_region` VALUES ('360123', '2018-01-30 19:30:19', NULL, NULL, NULL, '安义县', '江西省南昌市安义县', '3', 9, 'A', NULL, '1', '330500', '360100');
INSERT INTO `sys_region` VALUES ('360124', '2018-01-30 19:30:19', NULL, NULL, NULL, '进贤县', '江西省南昌市进贤县', '3', 10, 'J', NULL, '1', '331700', '360100');
INSERT INTO `sys_region` VALUES ('360200', '2018-01-30 19:30:19', NULL, NULL, NULL, '景德镇市', '江西省景德镇市', '2', 2, 'J', NULL, '1', '333000', '360000');
INSERT INTO `sys_region` VALUES ('360201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省景德镇市市辖区', '3', 1, 'S', NULL, '1', NULL, '360200');
INSERT INTO `sys_region` VALUES ('360202', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌江区', '江西省景德镇市昌江区', '3', 2, 'C', NULL, '1', '333000', '360200');
INSERT INTO `sys_region` VALUES ('360203', '2018-01-30 19:30:19', NULL, NULL, NULL, '珠山区', '江西省景德镇市珠山区', '3', 3, 'Z', NULL, '1', '333000', '360200');
INSERT INTO `sys_region` VALUES ('360222', '2018-01-30 19:30:19', NULL, NULL, NULL, '浮梁县', '江西省景德镇市浮梁县', '3', 4, 'F', NULL, '1', '333400', '360200');
INSERT INTO `sys_region` VALUES ('360281', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐平市', '江西省景德镇市乐平市', '3', 5, 'L', NULL, '1', '333300', '360200');
INSERT INTO `sys_region` VALUES ('360300', '2018-01-30 19:30:19', NULL, NULL, NULL, '萍乡市', '江西省萍乡市', '2', 3, 'P', NULL, '1', '337000', '360000');
INSERT INTO `sys_region` VALUES ('360301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省萍乡市市辖区', '3', 1, 'S', NULL, '1', NULL, '360300');
INSERT INTO `sys_region` VALUES ('360302', '2018-01-30 19:30:19', NULL, NULL, NULL, '安源区', '江西省萍乡市安源区', '3', 2, 'A', NULL, '1', '337000', '360300');
INSERT INTO `sys_region` VALUES ('360313', '2018-01-30 19:30:19', NULL, NULL, NULL, '湘东区', '江西省萍乡市湘东区', '3', 3, 'X', NULL, '1', '337016', '360300');
INSERT INTO `sys_region` VALUES ('360321', '2018-01-30 19:30:19', NULL, NULL, NULL, '莲花县', '江西省萍乡市莲花县', '3', 4, 'L', NULL, '1', '337100', '360300');
INSERT INTO `sys_region` VALUES ('360322', '2018-01-30 19:30:19', NULL, NULL, NULL, '上栗县', '江西省萍乡市上栗县', '3', 5, 'S', NULL, '1', '337009', '360300');
INSERT INTO `sys_region` VALUES ('360323', '2018-01-30 19:30:19', NULL, NULL, NULL, '芦溪县', '江西省萍乡市芦溪县', '3', 6, 'L', NULL, '1', '337053', '360300');
INSERT INTO `sys_region` VALUES ('360400', '2018-01-30 19:30:19', NULL, NULL, NULL, '九江市', '江西省九江市', '2', 4, 'J', NULL, '1', '332000', '360000');
INSERT INTO `sys_region` VALUES ('360401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省九江市市辖区', '3', 1, 'S', NULL, '1', NULL, '360400');
INSERT INTO `sys_region` VALUES ('360402', '2018-01-30 19:30:19', NULL, NULL, NULL, '濂溪区', '江西省九江市濂溪区', '3', 2, 'Z', NULL, '1', '332005', '360400');
INSERT INTO `sys_region` VALUES ('360403', '2018-01-30 19:30:19', NULL, NULL, NULL, '浔阳区', '江西省九江市浔阳区', '3', 3, 'Z', NULL, '1', '332000', '360400');
INSERT INTO `sys_region` VALUES ('360421', '2018-01-30 19:30:19', NULL, NULL, NULL, '九江县', '江西省九江市九江县', '3', 4, 'J', NULL, '1', '332100', '360400');
INSERT INTO `sys_region` VALUES ('360423', '2018-01-30 19:30:19', NULL, NULL, NULL, '武宁县', '江西省九江市武宁县', '3', 5, 'W', NULL, '1', '332300', '360400');
INSERT INTO `sys_region` VALUES ('360424', '2018-01-30 19:30:19', NULL, NULL, NULL, '修水县', '江西省九江市修水县', '3', 6, 'X', NULL, '1', '332400', '360400');
INSERT INTO `sys_region` VALUES ('360425', '2018-01-30 19:30:19', NULL, NULL, NULL, '永修县', '江西省九江市永修县', '3', 7, 'Y', NULL, '1', '330300', '360400');
INSERT INTO `sys_region` VALUES ('360426', '2018-01-30 19:30:19', NULL, NULL, NULL, '德安县', '江西省九江市德安县', '3', 8, 'D', NULL, '1', '330400', '360400');
INSERT INTO `sys_region` VALUES ('360428', '2018-01-30 19:30:19', NULL, NULL, NULL, '都昌县', '江西省九江市都昌县', '3', 9, 'D', NULL, '1', '332600', '360400');
INSERT INTO `sys_region` VALUES ('360429', '2018-01-30 19:30:19', NULL, NULL, NULL, '湖口县', '江西省九江市湖口县', '3', 10, 'H', NULL, '1', '332500', '360400');
INSERT INTO `sys_region` VALUES ('360430', '2018-01-30 19:30:19', NULL, NULL, NULL, '彭泽县', '江西省九江市彭泽县', '3', 11, 'P', NULL, '1', '332700', '360400');
INSERT INTO `sys_region` VALUES ('360481', '2018-01-30 19:30:19', NULL, NULL, NULL, '瑞昌市', '江西省九江市瑞昌市', '3', 12, 'R', NULL, '1', '332200', '360400');
INSERT INTO `sys_region` VALUES ('360482', '2018-01-30 19:30:19', NULL, NULL, NULL, '共青城市', '江西省九江市共青城市', '3', 13, 'G', NULL, '1', '332020', '360400');
INSERT INTO `sys_region` VALUES ('360483', '2018-01-30 19:30:19', NULL, NULL, NULL, '庐山市', '江西省九江市庐山市', '3', 14, 'L', NULL, '1', NULL, '360400');
INSERT INTO `sys_region` VALUES ('360500', '2018-01-30 19:30:19', NULL, NULL, NULL, '新余市', '江西省新余市', '2', 5, 'X', NULL, '1', '338025', '360000');
INSERT INTO `sys_region` VALUES ('360501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省新余市市辖区', '3', 1, 'S', NULL, '1', NULL, '360500');
INSERT INTO `sys_region` VALUES ('360502', '2018-01-30 19:30:19', NULL, NULL, NULL, '渝水区', '江西省新余市渝水区', '3', 2, 'Y', NULL, '1', '338025', '360500');
INSERT INTO `sys_region` VALUES ('360521', '2018-01-30 19:30:19', NULL, NULL, NULL, '分宜县', '江西省新余市分宜县', '3', 3, 'F', NULL, '1', '336600', '360500');
INSERT INTO `sys_region` VALUES ('360600', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹰潭市', '江西省鹰潭市', '2', 6, 'Y', NULL, '1', '335000', '360000');
INSERT INTO `sys_region` VALUES ('360601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省鹰潭市市辖区', '3', 1, 'S', NULL, '1', NULL, '360600');
INSERT INTO `sys_region` VALUES ('360602', '2018-01-30 19:30:19', NULL, NULL, NULL, '月湖区', '江西省鹰潭市月湖区', '3', 2, 'Y', NULL, '1', '335000', '360600');
INSERT INTO `sys_region` VALUES ('360622', '2018-01-30 19:30:19', NULL, NULL, NULL, '余江县', '江西省鹰潭市余江县', '3', 3, 'Y', NULL, '1', '335200', '360600');
INSERT INTO `sys_region` VALUES ('360681', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵溪市', '江西省鹰潭市贵溪市', '3', 4, 'G', NULL, '1', '335400', '360600');
INSERT INTO `sys_region` VALUES ('360700', '2018-01-30 19:30:19', NULL, NULL, NULL, '赣州市', '江西省赣州市', '2', 7, 'G', NULL, '1', '341000', '360000');
INSERT INTO `sys_region` VALUES ('360701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省赣州市市辖区', '3', 1, 'S', NULL, '1', NULL, '360700');
INSERT INTO `sys_region` VALUES ('360702', '2018-01-30 19:30:19', NULL, NULL, NULL, '章贡区', '江西省赣州市章贡区', '3', 2, 'Z', NULL, '1', '341000', '360700');
INSERT INTO `sys_region` VALUES ('360703', '2018-01-30 19:30:19', NULL, NULL, NULL, '南康区', '江西省赣州市南康区', '3', 3, 'N', NULL, '1', '341400', '360700');
INSERT INTO `sys_region` VALUES ('360721', '2018-01-30 19:30:19', NULL, NULL, NULL, '赣县', '江西省赣州市赣县', '3', 4, 'G', NULL, '1', '341100', '360700');
INSERT INTO `sys_region` VALUES ('360722', '2018-01-30 19:30:19', NULL, NULL, NULL, '信丰县', '江西省赣州市信丰县', '3', 5, 'X', NULL, '1', '341600', '360700');
INSERT INTO `sys_region` VALUES ('360723', '2018-01-30 19:30:19', NULL, NULL, NULL, '大余县', '江西省赣州市大余县', '3', 6, 'D', NULL, '1', '341500', '360700');
INSERT INTO `sys_region` VALUES ('360724', '2018-01-30 19:30:19', NULL, NULL, NULL, '上犹县', '江西省赣州市上犹县', '3', 7, 'S', NULL, '1', '341200', '360700');
INSERT INTO `sys_region` VALUES ('360725', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇义县', '江西省赣州市崇义县', '3', 8, 'C', NULL, '1', '341300', '360700');
INSERT INTO `sys_region` VALUES ('360726', '2018-01-30 19:30:19', NULL, NULL, NULL, '安远县', '江西省赣州市安远县', '3', 9, 'A', NULL, '1', '342100', '360700');
INSERT INTO `sys_region` VALUES ('360727', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙南县', '江西省赣州市龙南县', '3', 10, 'L', NULL, '1', '341700', '360700');
INSERT INTO `sys_region` VALUES ('360728', '2018-01-30 19:30:19', NULL, NULL, NULL, '定南县', '江西省赣州市定南县', '3', 11, 'D', NULL, '1', '341900', '360700');
INSERT INTO `sys_region` VALUES ('360729', '2018-01-30 19:30:19', NULL, NULL, NULL, '全南县', '江西省赣州市全南县', '3', 12, 'Q', NULL, '1', '341800', '360700');
INSERT INTO `sys_region` VALUES ('360730', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁都县', '江西省赣州市宁都县', '3', 13, 'N', NULL, '1', '342800', '360700');
INSERT INTO `sys_region` VALUES ('360731', '2018-01-30 19:30:19', NULL, NULL, NULL, '于都县', '江西省赣州市于都县', '3', 14, 'Y', NULL, '1', '342300', '360700');
INSERT INTO `sys_region` VALUES ('360732', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴国县', '江西省赣州市兴国县', '3', 15, 'X', NULL, '1', '342400', '360700');
INSERT INTO `sys_region` VALUES ('360733', '2018-01-30 19:30:19', NULL, NULL, NULL, '会昌县', '江西省赣州市会昌县', '3', 16, 'H', NULL, '1', '342600', '360700');
INSERT INTO `sys_region` VALUES ('360734', '2018-01-30 19:30:19', NULL, NULL, NULL, '寻乌县', '江西省赣州市寻乌县', '3', 17, 'X', NULL, '1', '342200', '360700');
INSERT INTO `sys_region` VALUES ('360735', '2018-01-30 19:30:19', NULL, NULL, NULL, '石城县', '江西省赣州市石城县', '3', 18, 'S', NULL, '1', '342700', '360700');
INSERT INTO `sys_region` VALUES ('360781', '2018-01-30 19:30:19', NULL, NULL, NULL, '瑞金市', '江西省赣州市瑞金市', '3', 19, 'R', NULL, '1', '342500', '360700');
INSERT INTO `sys_region` VALUES ('360800', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉安市', '江西省吉安市', '2', 8, 'J', NULL, '1', '343000', '360000');
INSERT INTO `sys_region` VALUES ('360801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省吉安市市辖区', '3', 1, 'S', NULL, '1', NULL, '360800');
INSERT INTO `sys_region` VALUES ('360802', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉州区', '江西省吉安市吉州区', '3', 2, 'J', NULL, '1', '343000', '360800');
INSERT INTO `sys_region` VALUES ('360803', '2018-01-30 19:30:19', NULL, NULL, NULL, '青原区', '江西省吉安市青原区', '3', 3, 'Q', NULL, '1', '343009', '360800');
INSERT INTO `sys_region` VALUES ('360821', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉安县', '江西省吉安市吉安县', '3', 4, 'J', NULL, '1', '343100', '360800');
INSERT INTO `sys_region` VALUES ('360822', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉水县', '江西省吉安市吉水县', '3', 5, 'J', NULL, '1', '331600', '360800');
INSERT INTO `sys_region` VALUES ('360823', '2018-01-30 19:30:19', NULL, NULL, NULL, '峡江县', '江西省吉安市峡江县', '3', 6, 'X', NULL, '1', '331409', '360800');
INSERT INTO `sys_region` VALUES ('360824', '2018-01-30 19:30:19', NULL, NULL, NULL, '新干县', '江西省吉安市新干县', '3', 7, 'X', NULL, '1', '331300', '360800');
INSERT INTO `sys_region` VALUES ('360825', '2018-01-30 19:30:19', NULL, NULL, NULL, '永丰县', '江西省吉安市永丰县', '3', 8, 'Y', NULL, '1', '331500', '360800');
INSERT INTO `sys_region` VALUES ('360826', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰和县', '江西省吉安市泰和县', '3', 9, 'T', NULL, '1', '343700', '360800');
INSERT INTO `sys_region` VALUES ('360827', '2018-01-30 19:30:19', NULL, NULL, NULL, '遂川县', '江西省吉安市遂川县', '3', 10, 'S', NULL, '1', '343900', '360800');
INSERT INTO `sys_region` VALUES ('360828', '2018-01-30 19:30:19', NULL, NULL, NULL, '万安县', '江西省吉安市万安县', '3', 11, 'W', NULL, '1', '343800', '360800');
INSERT INTO `sys_region` VALUES ('360829', '2018-01-30 19:30:19', NULL, NULL, NULL, '安福县', '江西省吉安市安福县', '3', 12, 'A', NULL, '1', '343200', '360800');
INSERT INTO `sys_region` VALUES ('360830', '2018-01-30 19:30:19', NULL, NULL, NULL, '永新县', '江西省吉安市永新县', '3', 13, 'Y', NULL, '1', '343400', '360800');
INSERT INTO `sys_region` VALUES ('360881', '2018-01-30 19:30:19', NULL, NULL, NULL, '井冈山市', '江西省吉安市井冈山市', '3', 14, 'J', NULL, '1', '343600', '360800');
INSERT INTO `sys_region` VALUES ('360900', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜春市', '江西省宜春市', '2', 9, 'Y', NULL, '1', '336000', '360000');
INSERT INTO `sys_region` VALUES ('360901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省宜春市市辖区', '3', 1, 'S', NULL, '1', NULL, '360900');
INSERT INTO `sys_region` VALUES ('360902', '2018-01-30 19:30:19', NULL, NULL, NULL, '袁州区', '江西省宜春市袁州区', '3', 2, 'Y', NULL, '1', '336000', '360900');
INSERT INTO `sys_region` VALUES ('360921', '2018-01-30 19:30:19', NULL, NULL, NULL, '奉新县', '江西省宜春市奉新县', '3', 3, 'F', NULL, '1', '330700', '360900');
INSERT INTO `sys_region` VALUES ('360922', '2018-01-30 19:30:19', NULL, NULL, NULL, '万载县', '江西省宜春市万载县', '3', 4, 'W', NULL, '1', '336100', '360900');
INSERT INTO `sys_region` VALUES ('360923', '2018-01-30 19:30:19', NULL, NULL, NULL, '上高县', '江西省宜春市上高县', '3', 5, 'S', NULL, '1', '336400', '360900');
INSERT INTO `sys_region` VALUES ('360924', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜丰县', '江西省宜春市宜丰县', '3', 6, 'Y', NULL, '1', '336300', '360900');
INSERT INTO `sys_region` VALUES ('360925', '2018-01-30 19:30:19', NULL, NULL, NULL, '靖安县', '江西省宜春市靖安县', '3', 7, 'J', NULL, '1', '330600', '360900');
INSERT INTO `sys_region` VALUES ('360926', '2018-01-30 19:30:19', NULL, NULL, NULL, '铜鼓县', '江西省宜春市铜鼓县', '3', 8, 'T', NULL, '1', '336200', '360900');
INSERT INTO `sys_region` VALUES ('360981', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰城市', '江西省宜春市丰城市', '3', 9, 'F', NULL, '1', '331100', '360900');
INSERT INTO `sys_region` VALUES ('360982', '2018-01-30 19:30:19', NULL, NULL, NULL, '樟树市', '江西省宜春市樟树市', '3', 10, 'Z', NULL, '1', '331200', '360900');
INSERT INTO `sys_region` VALUES ('360983', '2018-01-30 19:30:19', NULL, NULL, NULL, '高安市', '江西省宜春市高安市', '3', 11, 'G', NULL, '1', '330800', '360900');
INSERT INTO `sys_region` VALUES ('361000', '2018-01-30 19:30:19', NULL, NULL, NULL, '抚州市', '江西省抚州市', '2', 10, 'F', NULL, '1', '344000', '360000');
INSERT INTO `sys_region` VALUES ('361001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省抚州市市辖区', '3', 1, 'S', NULL, '1', NULL, '361000');
INSERT INTO `sys_region` VALUES ('361002', '2018-01-30 19:30:19', NULL, NULL, NULL, '临川区', '江西省抚州市临川区', '3', 2, 'L', NULL, '1', '344000', '361000');
INSERT INTO `sys_region` VALUES ('361021', '2018-01-30 19:30:19', NULL, NULL, NULL, '南城县', '江西省抚州市南城县', '3', 3, 'N', NULL, '1', '344700', '361000');
INSERT INTO `sys_region` VALUES ('361022', '2018-01-30 19:30:19', NULL, NULL, NULL, '黎川县', '江西省抚州市黎川县', '3', 4, 'L', NULL, '1', '344600', '361000');
INSERT INTO `sys_region` VALUES ('361023', '2018-01-30 19:30:19', NULL, NULL, NULL, '南丰县', '江西省抚州市南丰县', '3', 5, 'N', NULL, '1', '344500', '361000');
INSERT INTO `sys_region` VALUES ('361024', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇仁县', '江西省抚州市崇仁县', '3', 6, 'C', NULL, '1', '344200', '361000');
INSERT INTO `sys_region` VALUES ('361025', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐安县', '江西省抚州市乐安县', '3', 7, 'L', NULL, '1', '344300', '361000');
INSERT INTO `sys_region` VALUES ('361026', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜黄县', '江西省抚州市宜黄县', '3', 8, 'Y', NULL, '1', '344400', '361000');
INSERT INTO `sys_region` VALUES ('361027', '2018-01-30 19:30:19', NULL, NULL, NULL, '金溪县', '江西省抚州市金溪县', '3', 9, 'J', NULL, '1', '344800', '361000');
INSERT INTO `sys_region` VALUES ('361028', '2018-01-30 19:30:19', NULL, NULL, NULL, '资溪县', '江西省抚州市资溪县', '3', 10, 'Z', NULL, '1', '335300', '361000');
INSERT INTO `sys_region` VALUES ('361029', '2018-01-30 19:30:19', NULL, NULL, NULL, '东乡县', '江西省抚州市东乡县', '3', 11, 'D', NULL, '1', '331800', '361000');
INSERT INTO `sys_region` VALUES ('361030', '2018-01-30 19:30:19', NULL, NULL, NULL, '广昌县', '江西省抚州市广昌县', '3', 12, 'G', NULL, '1', '344900', '361000');
INSERT INTO `sys_region` VALUES ('361100', '2018-01-30 19:30:19', NULL, NULL, NULL, '上饶市', '江西省上饶市', '2', 11, 'S', NULL, '1', '334000', '360000');
INSERT INTO `sys_region` VALUES ('361101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '江西省上饶市市辖区', '3', 1, 'S', NULL, '1', NULL, '361100');
INSERT INTO `sys_region` VALUES ('361102', '2018-01-30 19:30:19', NULL, NULL, NULL, '信州区', '江西省上饶市信州区', '3', 2, 'X', NULL, '1', '334000', '361100');
INSERT INTO `sys_region` VALUES ('361103', '2018-01-30 19:30:19', NULL, NULL, NULL, '广丰区', '江西省上饶市广丰区', '3', 3, 'G', NULL, '1', NULL, '361100');
INSERT INTO `sys_region` VALUES ('361121', '2018-01-30 19:30:19', NULL, NULL, NULL, '上饶县', '江西省上饶市上饶县', '3', 4, 'S', NULL, '1', '334100', '361100');
INSERT INTO `sys_region` VALUES ('361123', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉山县', '江西省上饶市玉山县', '3', 5, 'Y', NULL, '1', '334700', '361100');
INSERT INTO `sys_region` VALUES ('361124', '2018-01-30 19:30:19', NULL, NULL, NULL, '铅山县', '江西省上饶市铅山县', '3', 6, 'Q', NULL, '1', '334500', '361100');
INSERT INTO `sys_region` VALUES ('361125', '2018-01-30 19:30:19', NULL, NULL, NULL, '横峰县', '江西省上饶市横峰县', '3', 7, 'H', NULL, '1', '334300', '361100');
INSERT INTO `sys_region` VALUES ('361126', '2018-01-30 19:30:19', NULL, NULL, NULL, '弋阳县', '江西省上饶市弋阳县', '3', 8, 'Z', NULL, '1', '334400', '361100');
INSERT INTO `sys_region` VALUES ('361127', '2018-01-30 19:30:19', NULL, NULL, NULL, '余干县', '江西省上饶市余干县', '3', 9, 'Y', NULL, '1', '335100', '361100');
INSERT INTO `sys_region` VALUES ('361128', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄱阳县', '江西省上饶市鄱阳县', '3', 10, 'Z', NULL, '1', '333100', '361100');
INSERT INTO `sys_region` VALUES ('361129', '2018-01-30 19:30:19', NULL, NULL, NULL, '万年县', '江西省上饶市万年县', '3', 11, 'W', NULL, '1', '335500', '361100');
INSERT INTO `sys_region` VALUES ('361130', '2018-01-30 19:30:19', NULL, NULL, NULL, '婺源县', '江西省上饶市婺源县', '3', 12, 'Z', NULL, '1', '333200', '361100');
INSERT INTO `sys_region` VALUES ('361181', '2018-01-30 19:30:19', NULL, NULL, NULL, '德兴市', '江西省上饶市德兴市', '3', 13, 'D', NULL, '1', '334200', '361100');
INSERT INTO `sys_region` VALUES ('370000', '2018-01-30 19:30:19', NULL, NULL, NULL, '山东省', '山东省', '1', 15, 'S', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('370100', '2018-01-30 19:30:19', NULL, NULL, NULL, '济南市', '山东省济南市', '2', 1, 'J', NULL, '1', '250001', '370000');
INSERT INTO `sys_region` VALUES ('370101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省济南市市辖区', '3', 1, 'S', NULL, '1', NULL, '370100');
INSERT INTO `sys_region` VALUES ('370102', '2018-01-30 19:30:19', NULL, NULL, NULL, '历下区', '山东省济南市历下区', '3', 2, 'L', NULL, '1', '250014', '370100');
INSERT INTO `sys_region` VALUES ('370103', '2018-01-30 19:30:19', NULL, NULL, NULL, '市中区', '山东省济南市市中区', '3', 3, 'S', NULL, '1', '250001', '370100');
INSERT INTO `sys_region` VALUES ('370104', '2018-01-30 19:30:19', NULL, NULL, NULL, '槐荫区', '山东省济南市槐荫区', '3', 4, 'H', NULL, '1', '250117', '370100');
INSERT INTO `sys_region` VALUES ('370105', '2018-01-30 19:30:19', NULL, NULL, NULL, '天桥区', '山东省济南市天桥区', '3', 5, 'T', NULL, '1', '250031', '370100');
INSERT INTO `sys_region` VALUES ('370112', '2018-01-30 19:30:19', NULL, NULL, NULL, '历城区', '山东省济南市历城区', '3', 6, 'L', NULL, '1', '250100', '370100');
INSERT INTO `sys_region` VALUES ('370113', '2018-01-30 19:30:19', NULL, NULL, NULL, '长清区', '山东省济南市长清区', '3', 7, 'C', NULL, '1', '250300', '370100');
INSERT INTO `sys_region` VALUES ('370124', '2018-01-30 19:30:19', NULL, NULL, NULL, '平阴县', '山东省济南市平阴县', '3', 8, 'P', NULL, '1', '250400', '370100');
INSERT INTO `sys_region` VALUES ('370125', '2018-01-30 19:30:19', NULL, NULL, NULL, '济阳县', '山东省济南市济阳县', '3', 9, 'J', NULL, '1', '251400', '370100');
INSERT INTO `sys_region` VALUES ('370126', '2018-01-30 19:30:19', NULL, NULL, NULL, '商河县', '山东省济南市商河县', '3', 10, 'S', NULL, '1', '251600', '370100');
INSERT INTO `sys_region` VALUES ('370171', '2021-03-02 19:30:19', NULL, NULL, NULL, '济南高新技术产业开发区', '山东省济南市章济南高新技术产业开发区', '3', 12, 'J', NULL, '1', '250101', '370100');
INSERT INTO `sys_region` VALUES ('370181', '2018-01-30 19:30:19', NULL, NULL, NULL, '章丘市', '山东省济南市章丘市', '3', 11, 'Z', NULL, '1', '250200', '370100');
INSERT INTO `sys_region` VALUES ('370200', '2018-01-30 19:30:19', NULL, NULL, NULL, '青岛市', '山东省青岛市', '2', 2, 'Q', NULL, '1', '266001', '370000');
INSERT INTO `sys_region` VALUES ('370201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省青岛市市辖区', '3', 1, 'S', NULL, '1', NULL, '370200');
INSERT INTO `sys_region` VALUES ('370202', '2018-01-30 19:30:19', NULL, NULL, NULL, '市南区', '山东省青岛市市南区', '3', 2, 'S', NULL, '1', '266001', '370200');
INSERT INTO `sys_region` VALUES ('370203', '2018-01-30 19:30:19', NULL, NULL, NULL, '市北区', '山东省青岛市市北区', '3', 3, 'S', NULL, '1', '266011', '370200');
INSERT INTO `sys_region` VALUES ('370211', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄岛区', '山东省青岛市黄岛区', '3', 4, 'H', NULL, '1', '266500', '370200');
INSERT INTO `sys_region` VALUES ('370212', '2018-01-30 19:30:19', NULL, NULL, NULL, '崂山区', '山东省青岛市崂山区', '3', 5, 'Z', NULL, '1', '266100', '370200');
INSERT INTO `sys_region` VALUES ('370213', '2018-01-30 19:30:19', NULL, NULL, NULL, '李沧区', '山东省青岛市李沧区', '3', 6, 'L', NULL, '1', '266021', '370200');
INSERT INTO `sys_region` VALUES ('370214', '2018-01-30 19:30:19', NULL, NULL, NULL, '城阳区', '山东省青岛市城阳区', '3', 7, 'C', NULL, '1', '266041', '370200');
INSERT INTO `sys_region` VALUES ('370281', '2018-01-30 19:30:19', NULL, NULL, NULL, '胶州市', '山东省青岛市胶州市', '3', 8, 'J', NULL, '1', '266300', '370200');
INSERT INTO `sys_region` VALUES ('370282', '2018-01-30 19:30:19', NULL, NULL, NULL, '即墨市', '山东省青岛市即墨市', '3', 9, 'J', NULL, '1', '266200', '370200');
INSERT INTO `sys_region` VALUES ('370283', '2018-01-30 19:30:19', NULL, NULL, NULL, '平度市', '山东省青岛市平度市', '3', 10, 'P', NULL, '1', '266700', '370200');
INSERT INTO `sys_region` VALUES ('370285', '2018-01-30 19:30:19', NULL, NULL, NULL, '莱西市', '山东省青岛市莱西市', '3', 11, 'L', NULL, '1', '266600', '370200');
INSERT INTO `sys_region` VALUES ('370300', '2018-01-30 19:30:19', NULL, NULL, NULL, '淄博市', '山东省淄博市', '2', 3, 'Z', NULL, '1', '255039', '370000');
INSERT INTO `sys_region` VALUES ('370301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省淄博市市辖区', '3', 1, 'S', NULL, '1', NULL, '370300');
INSERT INTO `sys_region` VALUES ('370302', '2018-01-30 19:30:19', NULL, NULL, NULL, '淄川区', '山东省淄博市淄川区', '3', 2, 'Z', NULL, '1', '255100', '370300');
INSERT INTO `sys_region` VALUES ('370303', '2018-01-30 19:30:19', NULL, NULL, NULL, '张店区', '山东省淄博市张店区', '3', 3, 'Z', NULL, '1', '255022', '370300');
INSERT INTO `sys_region` VALUES ('370304', '2018-01-30 19:30:19', NULL, NULL, NULL, '博山区', '山东省淄博市博山区', '3', 4, 'B', NULL, '1', '255200', '370300');
INSERT INTO `sys_region` VALUES ('370305', '2018-01-30 19:30:19', NULL, NULL, NULL, '临淄区', '山东省淄博市临淄区', '3', 5, 'L', NULL, '1', '255400', '370300');
INSERT INTO `sys_region` VALUES ('370306', '2018-01-30 19:30:19', NULL, NULL, NULL, '周村区', '山东省淄博市周村区', '3', 6, 'Z', NULL, '1', '255300', '370300');
INSERT INTO `sys_region` VALUES ('370321', '2018-01-30 19:30:19', NULL, NULL, NULL, '桓台县', '山东省淄博市桓台县', '3', 7, 'H', NULL, '1', '256400', '370300');
INSERT INTO `sys_region` VALUES ('370322', '2018-01-30 19:30:19', NULL, NULL, NULL, '高青县', '山东省淄博市高青县', '3', 8, 'G', NULL, '1', '256300', '370300');
INSERT INTO `sys_region` VALUES ('370323', '2018-01-30 19:30:19', NULL, NULL, NULL, '沂源县', '山东省淄博市沂源县', '3', 9, 'Y', NULL, '1', '256100', '370300');
INSERT INTO `sys_region` VALUES ('370400', '2018-01-30 19:30:19', NULL, NULL, NULL, '枣庄市', '山东省枣庄市', '2', 4, 'Z', NULL, '1', '277101', '370000');
INSERT INTO `sys_region` VALUES ('370401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省枣庄市市辖区', '3', 1, 'S', NULL, '1', NULL, '370400');
INSERT INTO `sys_region` VALUES ('370402', '2018-01-30 19:30:19', NULL, NULL, NULL, '市中区', '山东省枣庄市市中区', '3', 2, 'S', NULL, '1', '277101', '370400');
INSERT INTO `sys_region` VALUES ('370403', '2018-01-30 19:30:19', NULL, NULL, NULL, '薛城区', '山东省枣庄市薛城区', '3', 3, 'X', NULL, '1', '277000', '370400');
INSERT INTO `sys_region` VALUES ('370404', '2018-01-30 19:30:19', NULL, NULL, NULL, '峄城区', '山东省枣庄市峄城区', '3', 4, 'Z', NULL, '1', '277300', '370400');
INSERT INTO `sys_region` VALUES ('370405', '2018-01-30 19:30:19', NULL, NULL, NULL, '台儿庄区', '山东省枣庄市台儿庄区', '3', 5, 'T', NULL, '1', '277400', '370400');
INSERT INTO `sys_region` VALUES ('370406', '2018-01-30 19:30:19', NULL, NULL, NULL, '山亭区', '山东省枣庄市山亭区', '3', 6, 'S', NULL, '1', '277200', '370400');
INSERT INTO `sys_region` VALUES ('370481', '2018-01-30 19:30:19', NULL, NULL, NULL, '滕州市', '山东省枣庄市滕州市', '3', 7, 'Z', NULL, '1', '277500', '370400');
INSERT INTO `sys_region` VALUES ('370500', '2018-01-30 19:30:19', NULL, NULL, NULL, '东营市', '山东省东营市', '2', 5, 'D', NULL, '1', '257093', '370000');
INSERT INTO `sys_region` VALUES ('370501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省东营市市辖区', '3', 1, 'S', NULL, '1', NULL, '370500');
INSERT INTO `sys_region` VALUES ('370502', '2018-01-30 19:30:19', NULL, NULL, NULL, '东营区', '山东省东营市东营区', '3', 2, 'D', NULL, '1', '257029', '370500');
INSERT INTO `sys_region` VALUES ('370503', '2018-01-30 19:30:19', NULL, NULL, NULL, '河口区', '山东省东营市河口区', '3', 3, 'H', NULL, '1', '257200', '370500');
INSERT INTO `sys_region` VALUES ('370505', '2018-01-30 19:30:19', NULL, NULL, NULL, '垦利区', '山东省东营市垦利区', '3', 4, 'K', NULL, '1', NULL, '370500');
INSERT INTO `sys_region` VALUES ('370522', '2018-01-30 19:30:19', NULL, NULL, NULL, '利津县', '山东省东营市利津县', '3', 5, 'L', NULL, '1', '257400', '370500');
INSERT INTO `sys_region` VALUES ('370523', '2018-01-30 19:30:19', NULL, NULL, NULL, '广饶县', '山东省东营市广饶县', '3', 6, 'G', NULL, '1', '257300', '370500');
INSERT INTO `sys_region` VALUES ('370600', '2018-01-30 19:30:19', NULL, NULL, NULL, '烟台市', '山东省烟台市', '2', 6, 'Y', NULL, '1', '264010', '370000');
INSERT INTO `sys_region` VALUES ('370601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省烟台市市辖区', '3', 1, 'S', NULL, '1', NULL, '370600');
INSERT INTO `sys_region` VALUES ('370602', '2018-01-30 19:30:19', NULL, NULL, NULL, '芝罘区', '山东省烟台市芝罘区', '3', 2, 'Z', NULL, '1', '264001', '370600');
INSERT INTO `sys_region` VALUES ('370611', '2018-01-30 19:30:19', NULL, NULL, NULL, '福山区', '山东省烟台市福山区', '3', 3, 'F', NULL, '1', '265500', '370600');
INSERT INTO `sys_region` VALUES ('370612', '2018-01-30 19:30:19', NULL, NULL, NULL, '牟平区', '山东省烟台市牟平区', '3', 4, 'M', NULL, '1', '264100', '370600');
INSERT INTO `sys_region` VALUES ('370613', '2018-01-30 19:30:19', NULL, NULL, NULL, '莱山区', '山东省烟台市莱山区', '3', 5, 'L', NULL, '1', '264600', '370600');
INSERT INTO `sys_region` VALUES ('370634', '2018-01-30 19:30:19', NULL, NULL, NULL, '长岛县', '山东省烟台市长岛县', '3', 6, 'C', NULL, '1', '265800', '370600');
INSERT INTO `sys_region` VALUES ('370681', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙口市', '山东省烟台市龙口市', '3', 7, 'L', NULL, '1', '265700', '370600');
INSERT INTO `sys_region` VALUES ('370682', '2018-01-30 19:30:19', NULL, NULL, NULL, '莱阳市', '山东省烟台市莱阳市', '3', 8, 'L', NULL, '1', '265200', '370600');
INSERT INTO `sys_region` VALUES ('370683', '2018-01-30 19:30:19', NULL, NULL, NULL, '莱州市', '山东省烟台市莱州市', '3', 9, 'L', NULL, '1', '261400', '370600');
INSERT INTO `sys_region` VALUES ('370684', '2018-01-30 19:30:19', NULL, NULL, NULL, '蓬莱市', '山东省烟台市蓬莱市', '3', 10, 'P', NULL, '1', '265600', '370600');
INSERT INTO `sys_region` VALUES ('370685', '2018-01-30 19:30:19', NULL, NULL, NULL, '招远市', '山东省烟台市招远市', '3', 11, 'Z', NULL, '1', '265400', '370600');
INSERT INTO `sys_region` VALUES ('370686', '2018-01-30 19:30:19', NULL, NULL, NULL, '栖霞市', '山东省烟台市栖霞市', '3', 12, 'Q', NULL, '1', '265300', '370600');
INSERT INTO `sys_region` VALUES ('370687', '2018-01-30 19:30:19', NULL, NULL, NULL, '海阳市', '山东省烟台市海阳市', '3', 13, 'H', NULL, '1', '265100', '370600');
INSERT INTO `sys_region` VALUES ('370700', '2018-01-30 19:30:19', NULL, NULL, NULL, '潍坊市', '山东省潍坊市', '2', 7, 'W', NULL, '1', '261041', '370000');
INSERT INTO `sys_region` VALUES ('370701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省潍坊市市辖区', '3', 1, 'S', NULL, '1', NULL, '370700');
INSERT INTO `sys_region` VALUES ('370702', '2018-01-30 19:30:19', NULL, NULL, NULL, '潍城区', '山东省潍坊市潍城区', '3', 2, 'W', NULL, '1', '261021', '370700');
INSERT INTO `sys_region` VALUES ('370703', '2018-01-30 19:30:19', NULL, NULL, NULL, '寒亭区', '山东省潍坊市寒亭区', '3', 3, 'H', NULL, '1', '261100', '370700');
INSERT INTO `sys_region` VALUES ('370704', '2018-01-30 19:30:19', NULL, NULL, NULL, '坊子区', '山东省潍坊市坊子区', '3', 4, 'F', NULL, '1', '261200', '370700');
INSERT INTO `sys_region` VALUES ('370705', '2018-01-30 19:30:19', NULL, NULL, NULL, '奎文区', '山东省潍坊市奎文区', '3', 5, 'K', NULL, '1', '261031', '370700');
INSERT INTO `sys_region` VALUES ('370724', '2018-01-30 19:30:19', NULL, NULL, NULL, '临朐县', '山东省潍坊市临朐县', '3', 6, 'L', NULL, '1', '262600', '370700');
INSERT INTO `sys_region` VALUES ('370725', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌乐县', '山东省潍坊市昌乐县', '3', 7, 'C', NULL, '1', '262400', '370700');
INSERT INTO `sys_region` VALUES ('370781', '2018-01-30 19:30:19', NULL, NULL, NULL, '青州市', '山东省潍坊市青州市', '3', 8, 'Q', NULL, '1', '262500', '370700');
INSERT INTO `sys_region` VALUES ('370782', '2018-01-30 19:30:19', NULL, NULL, NULL, '诸城市', '山东省潍坊市诸城市', '3', 9, 'Z', NULL, '1', '262200', '370700');
INSERT INTO `sys_region` VALUES ('370783', '2018-01-30 19:30:19', NULL, NULL, NULL, '寿光市', '山东省潍坊市寿光市', '3', 10, 'S', NULL, '1', '262700', '370700');
INSERT INTO `sys_region` VALUES ('370784', '2018-01-30 19:30:19', NULL, NULL, NULL, '安丘市', '山东省潍坊市安丘市', '3', 11, 'A', NULL, '1', '262100', '370700');
INSERT INTO `sys_region` VALUES ('370785', '2018-01-30 19:30:19', NULL, NULL, NULL, '高密市', '山东省潍坊市高密市', '3', 12, 'G', NULL, '1', '261500', '370700');
INSERT INTO `sys_region` VALUES ('370786', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌邑市', '山东省潍坊市昌邑市', '3', 13, 'C', NULL, '1', '261300', '370700');
INSERT INTO `sys_region` VALUES ('370800', '2018-01-30 19:30:19', NULL, NULL, NULL, '济宁市', '山东省济宁市', '2', 8, 'J', NULL, '1', '272119', '370000');
INSERT INTO `sys_region` VALUES ('370801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省济宁市市辖区', '3', 1, 'S', NULL, '1', NULL, '370800');
INSERT INTO `sys_region` VALUES ('370811', '2018-01-30 19:30:19', NULL, NULL, NULL, '任城区', '山东省济宁市任城区', '3', 2, 'R', NULL, '1', '272113', '370800');
INSERT INTO `sys_region` VALUES ('370812', '2018-01-30 19:30:19', NULL, NULL, NULL, '兖州区', '山东省济宁市兖州区', '3', 3, 'Z', NULL, '1', '272000', '370800');
INSERT INTO `sys_region` VALUES ('370826', '2018-01-30 19:30:19', NULL, NULL, NULL, '微山县', '山东省济宁市微山县', '3', 4, 'W', NULL, '1', '277600', '370800');
INSERT INTO `sys_region` VALUES ('370827', '2018-01-30 19:30:19', NULL, NULL, NULL, '鱼台县', '山东省济宁市鱼台县', '3', 5, 'Y', NULL, '1', '272300', '370800');
INSERT INTO `sys_region` VALUES ('370828', '2018-01-30 19:30:19', NULL, NULL, NULL, '金乡县', '山东省济宁市金乡县', '3', 6, 'J', NULL, '1', '272200', '370800');
INSERT INTO `sys_region` VALUES ('370829', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉祥县', '山东省济宁市嘉祥县', '3', 7, 'J', NULL, '1', '272400', '370800');
INSERT INTO `sys_region` VALUES ('370830', '2018-01-30 19:30:19', NULL, NULL, NULL, '汶上县', '山东省济宁市汶上县', '3', 8, 'Z', NULL, '1', '272501', '370800');
INSERT INTO `sys_region` VALUES ('370831', '2018-01-30 19:30:19', NULL, NULL, NULL, '泗水县', '山东省济宁市泗水县', '3', 9, 'Z', NULL, '1', '273200', '370800');
INSERT INTO `sys_region` VALUES ('370832', '2018-01-30 19:30:19', NULL, NULL, NULL, '梁山县', '山东省济宁市梁山县', '3', 10, 'L', NULL, '1', '272600', '370800');
INSERT INTO `sys_region` VALUES ('370881', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲阜市', '山东省济宁市曲阜市', '3', 11, 'Q', NULL, '1', '273100', '370800');
INSERT INTO `sys_region` VALUES ('370883', '2018-01-30 19:30:19', NULL, NULL, NULL, '邹城市', '山东省济宁市邹城市', '3', 12, 'Z', NULL, '1', '273500', '370800');
INSERT INTO `sys_region` VALUES ('370900', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰安市', '山东省泰安市', '2', 9, 'T', NULL, '1', '271000', '370000');
INSERT INTO `sys_region` VALUES ('370901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省泰安市市辖区', '3', 1, 'S', NULL, '1', NULL, '370900');
INSERT INTO `sys_region` VALUES ('370902', '2018-01-30 19:30:19', NULL, NULL, NULL, '泰山区', '山东省泰安市泰山区', '3', 2, 'T', NULL, '1', '271000', '370900');
INSERT INTO `sys_region` VALUES ('370911', '2018-01-30 19:30:19', NULL, NULL, NULL, '岱岳区', '山东省泰安市岱岳区', '3', 3, 'Z', NULL, '1', '271000', '370900');
INSERT INTO `sys_region` VALUES ('370921', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁阳县', '山东省泰安市宁阳县', '3', 4, 'N', NULL, '1', '271400', '370900');
INSERT INTO `sys_region` VALUES ('370923', '2018-01-30 19:30:19', NULL, NULL, NULL, '东平县', '山东省泰安市东平县', '3', 5, 'D', NULL, '1', '271500', '370900');
INSERT INTO `sys_region` VALUES ('370982', '2018-01-30 19:30:19', NULL, NULL, NULL, '新泰市', '山东省泰安市新泰市', '3', 6, 'X', NULL, '1', '271200', '370900');
INSERT INTO `sys_region` VALUES ('370983', '2018-01-30 19:30:19', NULL, NULL, NULL, '肥城市', '山东省泰安市肥城市', '3', 7, 'F', NULL, '1', '271600', '370900');
INSERT INTO `sys_region` VALUES ('371000', '2018-01-30 19:30:19', NULL, NULL, NULL, '威海市', '山东省威海市', '2', 10, 'W', NULL, '1', '264200', '370000');
INSERT INTO `sys_region` VALUES ('371001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省威海市市辖区', '3', 1, 'S', NULL, '1', NULL, '371000');
INSERT INTO `sys_region` VALUES ('371002', '2018-01-30 19:30:19', NULL, NULL, NULL, '环翠区', '山东省威海市环翠区', '3', 2, 'H', NULL, '1', '264200', '371000');
INSERT INTO `sys_region` VALUES ('371003', '2018-01-30 19:30:19', NULL, NULL, NULL, '文登区', '山东省威海市文登区', '3', 3, 'W', NULL, '1', '266440', '371000');
INSERT INTO `sys_region` VALUES ('371082', '2018-01-30 19:30:19', NULL, NULL, NULL, '荣成市', '山东省威海市荣成市', '3', 4, 'R', NULL, '1', '264300', '371000');
INSERT INTO `sys_region` VALUES ('371083', '2018-01-30 19:30:19', NULL, NULL, NULL, '乳山市', '山东省威海市乳山市', '3', 5, 'R', NULL, '1', '264500', '371000');
INSERT INTO `sys_region` VALUES ('371100', '2018-01-30 19:30:19', NULL, NULL, NULL, '日照市', '山东省日照市', '2', 11, 'R', NULL, '1', '276800', '370000');
INSERT INTO `sys_region` VALUES ('371101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省日照市市辖区', '3', 1, 'S', NULL, '1', NULL, '371100');
INSERT INTO `sys_region` VALUES ('371102', '2018-01-30 19:30:19', NULL, NULL, NULL, '东港区', '山东省日照市东港区', '3', 2, 'D', NULL, '1', '276800', '371100');
INSERT INTO `sys_region` VALUES ('371103', '2018-01-30 19:30:19', NULL, NULL, NULL, '岚山区', '山东省日照市岚山区', '3', 3, 'Z', NULL, '1', '276808', '371100');
INSERT INTO `sys_region` VALUES ('371121', '2018-01-30 19:30:19', NULL, NULL, NULL, '五莲县', '山东省日照市五莲县', '3', 4, 'W', NULL, '1', '262300', '371100');
INSERT INTO `sys_region` VALUES ('371122', '2018-01-30 19:30:19', NULL, NULL, NULL, '莒县', '山东省日照市莒县', '3', 5, 'Z', NULL, '1', '276500', '371100');
INSERT INTO `sys_region` VALUES ('371200', '2018-01-30 19:30:19', NULL, NULL, NULL, '莱芜市', '山东省莱芜市', '2', 12, 'L', NULL, '1', '271100', '370000');
INSERT INTO `sys_region` VALUES ('371201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省莱芜市市辖区', '3', 1, 'S', NULL, '1', NULL, '371200');
INSERT INTO `sys_region` VALUES ('371202', '2018-01-30 19:30:19', NULL, NULL, NULL, '莱城区', '山东省莱芜市莱城区', '3', 2, 'L', NULL, '1', '271199', '371200');
INSERT INTO `sys_region` VALUES ('371203', '2018-01-30 19:30:19', NULL, NULL, NULL, '钢城区', '山东省莱芜市钢城区', '3', 3, 'G', NULL, '1', '271100', '371200');
INSERT INTO `sys_region` VALUES ('371300', '2018-01-30 19:30:19', NULL, NULL, NULL, '临沂市', '山东省临沂市', '2', 13, 'L', NULL, '1', '253000', '370000');
INSERT INTO `sys_region` VALUES ('371301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省临沂市市辖区', '3', 1, 'S', NULL, '1', NULL, '371300');
INSERT INTO `sys_region` VALUES ('371302', '2018-01-30 19:30:19', NULL, NULL, NULL, '兰山区', '山东省临沂市兰山区', '3', 2, 'L', NULL, '1', '276002', '371300');
INSERT INTO `sys_region` VALUES ('371311', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗庄区', '山东省临沂市罗庄区', '3', 3, 'L', NULL, '1', '276022', '371300');
INSERT INTO `sys_region` VALUES ('371312', '2018-01-30 19:30:19', NULL, NULL, NULL, '河东区', '山东省临沂市河东区', '3', 4, 'H', NULL, '1', '276034', '371300');
INSERT INTO `sys_region` VALUES ('371321', '2018-01-30 19:30:19', NULL, NULL, NULL, '沂南县', '山东省临沂市沂南县', '3', 5, 'Y', NULL, '1', '276300', '371300');
INSERT INTO `sys_region` VALUES ('371322', '2018-01-30 19:30:19', NULL, NULL, NULL, '郯城县', '山东省临沂市郯城县', '3', 6, 'Z', NULL, '1', '276100', '371300');
INSERT INTO `sys_region` VALUES ('371323', '2018-01-30 19:30:19', NULL, NULL, NULL, '沂水县', '山东省临沂市沂水县', '3', 7, 'Y', NULL, '1', '276400', '371300');
INSERT INTO `sys_region` VALUES ('371324', '2018-01-30 19:30:19', NULL, NULL, NULL, '兰陵县', '山东省临沂市兰陵县', '3', 8, 'L', NULL, '1', '277700', '371300');
INSERT INTO `sys_region` VALUES ('371325', '2018-01-30 19:30:19', NULL, NULL, NULL, '费县', '山东省临沂市费县', '3', 9, 'F', NULL, '1', '273400', '371300');
INSERT INTO `sys_region` VALUES ('371326', '2018-01-30 19:30:19', NULL, NULL, NULL, '平邑县', '山东省临沂市平邑县', '3', 10, 'P', NULL, '1', '273300', '371300');
INSERT INTO `sys_region` VALUES ('371327', '2018-01-30 19:30:19', NULL, NULL, NULL, '莒南县', '山东省临沂市莒南县', '3', 11, 'Z', NULL, '1', '276600', '371300');
INSERT INTO `sys_region` VALUES ('371328', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒙阴县', '山东省临沂市蒙阴县', '3', 12, 'M', NULL, '1', '276200', '371300');
INSERT INTO `sys_region` VALUES ('371329', '2018-01-30 19:30:19', NULL, NULL, NULL, '临沭县', '山东省临沂市临沭县', '3', 13, 'L', NULL, '1', '276700', '371300');
INSERT INTO `sys_region` VALUES ('371400', '2018-01-30 19:30:19', NULL, NULL, NULL, '德州市', '山东省德州市', '2', 14, 'D', NULL, '1', '253000', '370000');
INSERT INTO `sys_region` VALUES ('371401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省德州市市辖区', '3', 1, 'S', NULL, '1', NULL, '371400');
INSERT INTO `sys_region` VALUES ('371402', '2018-01-30 19:30:19', NULL, NULL, NULL, '德城区', '山东省德州市德城区', '3', 2, 'D', NULL, '1', '253012', '371400');
INSERT INTO `sys_region` VALUES ('371403', '2018-01-30 19:30:19', NULL, NULL, NULL, '陵城区', '山东省德州市陵城区', '3', 3, 'L', NULL, '1', '253500', '371400');
INSERT INTO `sys_region` VALUES ('371422', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁津县', '山东省德州市宁津县', '3', 4, 'N', NULL, '1', '253400', '371400');
INSERT INTO `sys_region` VALUES ('371423', '2018-01-30 19:30:19', NULL, NULL, NULL, '庆云县', '山东省德州市庆云县', '3', 5, 'Q', NULL, '1', '253700', '371400');
INSERT INTO `sys_region` VALUES ('371424', '2018-01-30 19:30:19', NULL, NULL, NULL, '临邑县', '山东省德州市临邑县', '3', 6, 'L', NULL, '1', '251500', '371400');
INSERT INTO `sys_region` VALUES ('371425', '2018-01-30 19:30:19', NULL, NULL, NULL, '齐河县', '山东省德州市齐河县', '3', 7, 'Q', NULL, '1', '251100', '371400');
INSERT INTO `sys_region` VALUES ('371426', '2018-01-30 19:30:19', NULL, NULL, NULL, '平原县', '山东省德州市平原县', '3', 8, 'P', NULL, '1', '253100', '371400');
INSERT INTO `sys_region` VALUES ('371427', '2018-01-30 19:30:19', NULL, NULL, NULL, '夏津县', '山东省德州市夏津县', '3', 9, 'X', NULL, '1', '253200', '371400');
INSERT INTO `sys_region` VALUES ('371428', '2018-01-30 19:30:19', NULL, NULL, NULL, '武城县', '山东省德州市武城县', '3', 10, 'W', NULL, '1', '253300', '371400');
INSERT INTO `sys_region` VALUES ('371481', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐陵市', '山东省德州市乐陵市', '3', 11, 'L', NULL, '1', '253600', '371400');
INSERT INTO `sys_region` VALUES ('371482', '2018-01-30 19:30:19', NULL, NULL, NULL, '禹城市', '山东省德州市禹城市', '3', 12, 'Y', NULL, '1', '251200', '371400');
INSERT INTO `sys_region` VALUES ('371500', '2018-01-30 19:30:19', NULL, NULL, NULL, '聊城市', '山东省聊城市', '2', 15, 'L', NULL, '1', '252052', '370000');
INSERT INTO `sys_region` VALUES ('371501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省聊城市市辖区', '3', 1, 'S', NULL, '1', NULL, '371500');
INSERT INTO `sys_region` VALUES ('371502', '2018-01-30 19:30:19', NULL, NULL, NULL, '东昌府区', '山东省聊城市东昌府区', '3', 2, 'D', NULL, '1', '252000', '371500');
INSERT INTO `sys_region` VALUES ('371521', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳谷县', '山东省聊城市阳谷县', '3', 3, 'Y', NULL, '1', '252300', '371500');
INSERT INTO `sys_region` VALUES ('371522', '2018-01-30 19:30:19', NULL, NULL, NULL, '莘县', '山东省聊城市莘县', '3', 4, 'Z', NULL, '1', '252400', '371500');
INSERT INTO `sys_region` VALUES ('371523', '2018-01-30 19:30:19', NULL, NULL, NULL, '茌平县', '山东省聊城市茌平县', '3', 5, 'Z', NULL, '1', '252100', '371500');
INSERT INTO `sys_region` VALUES ('371524', '2018-01-30 19:30:19', NULL, NULL, NULL, '东阿县', '山东省聊城市东阿县', '3', 6, 'D', NULL, '1', '252200', '371500');
INSERT INTO `sys_region` VALUES ('371525', '2018-01-30 19:30:19', NULL, NULL, NULL, '冠县', '山东省聊城市冠县', '3', 7, 'G', NULL, '1', '252500', '371500');
INSERT INTO `sys_region` VALUES ('371526', '2018-01-30 19:30:19', NULL, NULL, NULL, '高唐县', '山东省聊城市高唐县', '3', 8, 'G', NULL, '1', '252800', '371500');
INSERT INTO `sys_region` VALUES ('371581', '2018-01-30 19:30:19', NULL, NULL, NULL, '临清市', '山东省聊城市临清市', '3', 9, 'L', NULL, '1', '252600', '371500');
INSERT INTO `sys_region` VALUES ('371600', '2018-01-30 19:30:19', NULL, NULL, NULL, '滨州市', '山东省滨州市', '2', 16, 'B', NULL, '1', '256619', '370000');
INSERT INTO `sys_region` VALUES ('371601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省滨州市市辖区', '3', 1, 'S', NULL, '1', NULL, '371600');
INSERT INTO `sys_region` VALUES ('371602', '2018-01-30 19:30:19', NULL, NULL, NULL, '滨城区', '山东省滨州市滨城区', '3', 2, 'B', NULL, '1', '256613', '371600');
INSERT INTO `sys_region` VALUES ('371603', '2018-01-30 19:30:19', NULL, NULL, NULL, '沾化区', '山东省滨州市沾化区', '3', 3, 'Z', NULL, '1', '256800', '371600');
INSERT INTO `sys_region` VALUES ('371621', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠民县', '山东省滨州市惠民县', '3', 4, 'H', NULL, '1', '251700', '371600');
INSERT INTO `sys_region` VALUES ('371622', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳信县', '山东省滨州市阳信县', '3', 5, 'Y', NULL, '1', '251800', '371600');
INSERT INTO `sys_region` VALUES ('371623', '2018-01-30 19:30:19', NULL, NULL, NULL, '无棣县', '山东省滨州市无棣县', '3', 6, 'W', NULL, '1', '251900', '371600');
INSERT INTO `sys_region` VALUES ('371625', '2018-01-30 19:30:19', NULL, NULL, NULL, '博兴县', '山东省滨州市博兴县', '3', 7, 'B', NULL, '1', '256500', '371600');
INSERT INTO `sys_region` VALUES ('371626', '2018-01-30 19:30:19', NULL, NULL, NULL, '邹平县', '山东省滨州市邹平县', '3', 8, 'Z', NULL, '1', '256200', '371600');
INSERT INTO `sys_region` VALUES ('371700', '2018-01-30 19:30:19', NULL, NULL, NULL, '菏泽市', '山东省菏泽市', '2', 17, 'H', NULL, '1', '274020', '370000');
INSERT INTO `sys_region` VALUES ('371701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '山东省菏泽市市辖区', '3', 1, 'S', NULL, '1', NULL, '371700');
INSERT INTO `sys_region` VALUES ('371702', '2018-01-30 19:30:19', NULL, NULL, NULL, '牡丹区', '山东省菏泽市牡丹区', '3', 2, 'M', NULL, '1', '274009', '371700');
INSERT INTO `sys_region` VALUES ('371703', '2018-01-30 19:30:19', NULL, NULL, NULL, '定陶区', '山东省菏泽市定陶区', '3', 3, 'D', NULL, '1', NULL, '371700');
INSERT INTO `sys_region` VALUES ('371721', '2018-01-30 19:30:19', NULL, NULL, NULL, '曹县', '山东省菏泽市曹县', '3', 4, 'C', NULL, '1', '274400', '371700');
INSERT INTO `sys_region` VALUES ('371722', '2018-01-30 19:30:19', NULL, NULL, NULL, '单县', '山东省菏泽市单县', '3', 5, 'D', NULL, '1', '273700', '371700');
INSERT INTO `sys_region` VALUES ('371723', '2018-01-30 19:30:19', NULL, NULL, NULL, '成武县', '山东省菏泽市成武县', '3', 6, 'C', NULL, '1', '274200', '371700');
INSERT INTO `sys_region` VALUES ('371724', '2018-01-30 19:30:19', NULL, NULL, NULL, '巨野县', '山东省菏泽市巨野县', '3', 7, 'J', NULL, '1', '274900', '371700');
INSERT INTO `sys_region` VALUES ('371725', '2018-01-30 19:30:19', NULL, NULL, NULL, '郓城县', '山东省菏泽市郓城县', '3', 8, 'Z', NULL, '1', '274700', '371700');
INSERT INTO `sys_region` VALUES ('371726', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄄城县', '山东省菏泽市鄄城县', '3', 9, 'Z', NULL, '1', '274600', '371700');
INSERT INTO `sys_region` VALUES ('371728', '2018-01-30 19:30:19', NULL, NULL, NULL, '东明县', '山东省菏泽市东明县', '3', 10, 'D', NULL, '1', '274500', '371700');
INSERT INTO `sys_region` VALUES ('410000', '2018-01-30 19:30:19', NULL, NULL, NULL, '河南省', '河南省', '1', 16, 'H', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('410100', '2018-01-30 19:30:19', NULL, NULL, NULL, '郑州市', '河南省郑州市', '2', 1, 'Z', NULL, '1', '450000', '410000');
INSERT INTO `sys_region` VALUES ('410101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省郑州市市辖区', '3', 1, 'S', NULL, '1', NULL, '410100');
INSERT INTO `sys_region` VALUES ('410102', '2018-01-30 19:30:19', NULL, NULL, NULL, '中原区', '河南省郑州市中原区', '3', 2, 'Z', NULL, '1', '450007', '410100');
INSERT INTO `sys_region` VALUES ('410103', '2018-01-30 19:30:19', NULL, NULL, NULL, '二七区', '河南省郑州市二七区', '3', 3, 'E', NULL, '1', '450052', '410100');
INSERT INTO `sys_region` VALUES ('410104', '2018-01-30 19:30:19', NULL, NULL, NULL, '管城回族区', '河南省郑州市管城回族区', '3', 4, 'G', NULL, '1', '450000', '410100');
INSERT INTO `sys_region` VALUES ('410105', '2018-01-30 19:30:19', NULL, NULL, NULL, '金水区', '河南省郑州市金水区', '3', 5, 'J', NULL, '1', '450003', '410100');
INSERT INTO `sys_region` VALUES ('410106', '2018-01-30 19:30:19', NULL, NULL, NULL, '上街区', '河南省郑州市上街区', '3', 6, 'S', NULL, '1', '450041', '410100');
INSERT INTO `sys_region` VALUES ('410108', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠济区', '河南省郑州市惠济区', '3', 7, 'H', NULL, '1', '450053', '410100');
INSERT INTO `sys_region` VALUES ('410122', '2018-01-30 19:30:19', NULL, NULL, NULL, '中牟县', '河南省郑州市中牟县', '3', 8, 'Z', NULL, '1', '451450', '410100');
INSERT INTO `sys_region` VALUES ('410181', '2018-01-30 19:30:19', NULL, NULL, NULL, '巩义市', '河南省郑州市巩义市', '3', 9, 'G', NULL, '1', '451200', '410100');
INSERT INTO `sys_region` VALUES ('410182', '2018-01-30 19:30:19', NULL, NULL, NULL, '荥阳市', '河南省郑州市荥阳市', '3', 10, 'Z', NULL, '1', '450100', '410100');
INSERT INTO `sys_region` VALUES ('410183', '2018-01-30 19:30:19', NULL, NULL, NULL, '新密市', '河南省郑州市新密市', '3', 11, 'X', NULL, '1', '452300', '410100');
INSERT INTO `sys_region` VALUES ('410184', '2018-01-30 19:30:19', NULL, NULL, NULL, '新郑市', '河南省郑州市新郑市', '3', 12, 'X', NULL, '1', '451100', '410100');
INSERT INTO `sys_region` VALUES ('410185', '2018-01-30 19:30:19', NULL, NULL, NULL, '登封市', '河南省郑州市登封市', '3', 13, 'D', NULL, '1', '452470', '410100');
INSERT INTO `sys_region` VALUES ('410200', '2018-01-30 19:30:19', NULL, NULL, NULL, '开封市', '河南省开封市', '2', 2, 'K', NULL, '1', '475001', '410000');
INSERT INTO `sys_region` VALUES ('410201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省开封市市辖区', '3', 1, 'S', NULL, '1', NULL, '410200');
INSERT INTO `sys_region` VALUES ('410202', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙亭区', '河南省开封市龙亭区', '3', 2, 'L', NULL, '1', '475100', '410200');
INSERT INTO `sys_region` VALUES ('410203', '2018-01-30 19:30:19', NULL, NULL, NULL, '顺河回族区', '河南省开封市顺河回族区', '3', 3, 'S', NULL, '1', '475000', '410200');
INSERT INTO `sys_region` VALUES ('410204', '2018-01-30 19:30:19', NULL, NULL, NULL, '鼓楼区', '河南省开封市鼓楼区', '3', 4, 'G', NULL, '1', '475000', '410200');
INSERT INTO `sys_region` VALUES ('410205', '2018-01-30 19:30:19', NULL, NULL, NULL, '禹王台区', '河南省开封市禹王台区', '3', 5, 'Y', NULL, '1', '475003', '410200');
INSERT INTO `sys_region` VALUES ('410211', '2018-01-30 19:30:19', NULL, NULL, NULL, '金明区', '河南省开封市金明区', '3', 6, 'J', NULL, '1', NULL, '410200');
INSERT INTO `sys_region` VALUES ('410212', '2018-01-30 19:30:19', NULL, NULL, NULL, '祥符区', '河南省开封市祥符区', '3', 7, 'X', NULL, '1', '475100', '410200');
INSERT INTO `sys_region` VALUES ('410221', '2018-01-30 19:30:19', NULL, NULL, NULL, '杞县', '河南省开封市杞县', '3', 8, 'Z', NULL, '1', '475200', '410200');
INSERT INTO `sys_region` VALUES ('410222', '2018-01-30 19:30:19', NULL, NULL, NULL, '通许县', '河南省开封市通许县', '3', 9, 'T', NULL, '1', '475400', '410200');
INSERT INTO `sys_region` VALUES ('410223', '2018-01-30 19:30:19', NULL, NULL, NULL, '尉氏县', '河南省开封市尉氏县', '3', 10, 'W', NULL, '1', '475500', '410200');
INSERT INTO `sys_region` VALUES ('410225', '2018-01-30 19:30:19', NULL, NULL, NULL, '兰考县', '河南省开封市兰考县', '3', 11, 'L', NULL, '1', '475300', '410200');
INSERT INTO `sys_region` VALUES ('410300', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛阳市', '河南省洛阳市', '2', 3, 'L', NULL, '1', '471000', '410000');
INSERT INTO `sys_region` VALUES ('410301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省洛阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '410300');
INSERT INTO `sys_region` VALUES ('410302', '2018-01-30 19:30:19', NULL, NULL, NULL, '老城区', '河南省洛阳市老城区', '3', 2, 'L', NULL, '1', '471002', '410300');
INSERT INTO `sys_region` VALUES ('410303', '2018-01-30 19:30:19', NULL, NULL, NULL, '西工区', '河南省洛阳市西工区', '3', 3, 'X', NULL, '1', '471000', '410300');
INSERT INTO `sys_region` VALUES ('410304', '2018-01-30 19:30:19', NULL, NULL, NULL, '瀍河回族区', '河南省洛阳市瀍河回族区', '3', 4, NULL, NULL, '1', '471002', '410300');
INSERT INTO `sys_region` VALUES ('410305', '2018-01-30 19:30:19', NULL, NULL, NULL, '涧西区', '河南省洛阳市涧西区', '3', 5, 'J', NULL, '1', '471003', '410300');
INSERT INTO `sys_region` VALUES ('410306', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉利区', '河南省洛阳市吉利区', '3', 6, 'J', NULL, '1', '471012', '410300');
INSERT INTO `sys_region` VALUES ('410311', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛龙区', '河南省洛阳市洛龙区', '3', 7, 'L', NULL, '1', '471000', '410300');
INSERT INTO `sys_region` VALUES ('410322', '2018-01-30 19:30:19', NULL, NULL, NULL, '孟津县', '河南省洛阳市孟津县', '3', 8, 'M', NULL, '1', '471100', '410300');
INSERT INTO `sys_region` VALUES ('410323', '2018-01-30 19:30:19', NULL, NULL, NULL, '新安县', '河南省洛阳市新安县', '3', 9, 'X', NULL, '1', '471800', '410300');
INSERT INTO `sys_region` VALUES ('410324', '2018-01-30 19:30:19', NULL, NULL, NULL, '栾川县', '河南省洛阳市栾川县', '3', 10, 'Z', NULL, '1', '471500', '410300');
INSERT INTO `sys_region` VALUES ('410325', '2018-01-30 19:30:19', NULL, NULL, NULL, '嵩县', '河南省洛阳市嵩县', '3', 11, 'Z', NULL, '1', '471400', '410300');
INSERT INTO `sys_region` VALUES ('410326', '2018-01-30 19:30:19', NULL, NULL, NULL, '汝阳县', '河南省洛阳市汝阳县', '3', 12, 'R', NULL, '1', '471200', '410300');
INSERT INTO `sys_region` VALUES ('410327', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜阳县', '河南省洛阳市宜阳县', '3', 13, 'Y', NULL, '1', '471600', '410300');
INSERT INTO `sys_region` VALUES ('410328', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛宁县', '河南省洛阳市洛宁县', '3', 14, 'L', NULL, '1', '471700', '410300');
INSERT INTO `sys_region` VALUES ('410329', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊川县', '河南省洛阳市伊川县', '3', 15, 'Y', NULL, '1', '471300', '410300');
INSERT INTO `sys_region` VALUES ('410381', '2018-01-30 19:30:19', NULL, NULL, NULL, '偃师市', '河南省洛阳市偃师市', '3', 16, 'Z', NULL, '1', '471900', '410300');
INSERT INTO `sys_region` VALUES ('410400', '2018-01-30 19:30:19', NULL, NULL, NULL, '平顶山市', '河南省平顶山市', '2', 4, 'P', NULL, '1', '467000', '410000');
INSERT INTO `sys_region` VALUES ('410401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省平顶山市市辖区', '3', 1, 'S', NULL, '1', NULL, '410400');
INSERT INTO `sys_region` VALUES ('410402', '2018-01-30 19:30:19', NULL, NULL, NULL, '新华区', '河南省平顶山市新华区', '3', 2, 'X', NULL, '1', '467002', '410400');
INSERT INTO `sys_region` VALUES ('410403', '2018-01-30 19:30:19', NULL, NULL, NULL, '卫东区', '河南省平顶山市卫东区', '3', 3, 'W', NULL, '1', '467021', '410400');
INSERT INTO `sys_region` VALUES ('410404', '2018-01-30 19:30:19', NULL, NULL, NULL, '石龙区', '河南省平顶山市石龙区', '3', 4, 'S', NULL, '1', '467045', '410400');
INSERT INTO `sys_region` VALUES ('410411', '2018-01-30 19:30:19', NULL, NULL, NULL, '湛河区', '河南省平顶山市湛河区', '3', 5, 'Z', NULL, '1', '467000', '410400');
INSERT INTO `sys_region` VALUES ('410421', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝丰县', '河南省平顶山市宝丰县', '3', 6, 'B', NULL, '1', '467400', '410400');
INSERT INTO `sys_region` VALUES ('410422', '2018-01-30 19:30:19', NULL, NULL, NULL, '叶县', '河南省平顶山市叶县', '3', 7, 'Y', NULL, '1', '467200', '410400');
INSERT INTO `sys_region` VALUES ('410423', '2018-01-30 19:30:19', NULL, NULL, NULL, '鲁山县', '河南省平顶山市鲁山县', '3', 8, 'L', NULL, '1', '467300', '410400');
INSERT INTO `sys_region` VALUES ('410425', '2018-01-30 19:30:19', NULL, NULL, NULL, '郏县', '河南省平顶山市郏县', '3', 9, 'Z', NULL, '1', '467100', '410400');
INSERT INTO `sys_region` VALUES ('410481', '2018-01-30 19:30:19', NULL, NULL, NULL, '舞钢市', '河南省平顶山市舞钢市', '3', 10, 'W', NULL, '1', '462500', '410400');
INSERT INTO `sys_region` VALUES ('410482', '2018-01-30 19:30:19', NULL, NULL, NULL, '汝州市', '河南省平顶山市汝州市', '3', 11, 'R', NULL, '1', '467500', '410400');
INSERT INTO `sys_region` VALUES ('410500', '2018-01-30 19:30:19', NULL, NULL, NULL, '安阳市', '河南省安阳市', '2', 5, 'A', NULL, '1', '455000', '410000');
INSERT INTO `sys_region` VALUES ('410501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省安阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '410500');
INSERT INTO `sys_region` VALUES ('410502', '2018-01-30 19:30:19', NULL, NULL, NULL, '文峰区', '河南省安阳市文峰区', '3', 2, 'W', NULL, '1', '455000', '410500');
INSERT INTO `sys_region` VALUES ('410503', '2018-01-30 19:30:19', NULL, NULL, NULL, '北关区', '河南省安阳市北关区', '3', 3, 'B', NULL, '1', '455001', '410500');
INSERT INTO `sys_region` VALUES ('410505', '2018-01-30 19:30:19', NULL, NULL, NULL, '殷都区', '河南省安阳市殷都区', '3', 4, 'Y', NULL, '1', '455004', '410500');
INSERT INTO `sys_region` VALUES ('410506', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙安区', '河南省安阳市龙安区', '3', 5, 'L', NULL, '1', '455001', '410500');
INSERT INTO `sys_region` VALUES ('410522', '2018-01-30 19:30:19', NULL, NULL, NULL, '安阳县', '河南省安阳市安阳县', '3', 6, 'A', NULL, '1', '455000', '410500');
INSERT INTO `sys_region` VALUES ('410523', '2018-01-30 19:30:19', NULL, NULL, NULL, '汤阴县', '河南省安阳市汤阴县', '3', 7, 'T', NULL, '1', '456150', '410500');
INSERT INTO `sys_region` VALUES ('410526', '2018-01-30 19:30:19', NULL, NULL, NULL, '滑县', '河南省安阳市滑县', '3', 8, 'H', NULL, '1', '456400', '410500');
INSERT INTO `sys_region` VALUES ('410527', '2018-01-30 19:30:19', NULL, NULL, NULL, '内黄县', '河南省安阳市内黄县', '3', 9, 'N', NULL, '1', '456350', '410500');
INSERT INTO `sys_region` VALUES ('410581', '2018-01-30 19:30:19', NULL, NULL, NULL, '林州市', '河南省安阳市林州市', '3', 10, 'L', NULL, '1', '456550', '410500');
INSERT INTO `sys_region` VALUES ('410600', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹤壁市', '河南省鹤壁市', '2', 6, 'H', NULL, '1', '458030', '410000');
INSERT INTO `sys_region` VALUES ('410601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省鹤壁市市辖区', '3', 1, 'S', NULL, '1', NULL, '410600');
INSERT INTO `sys_region` VALUES ('410602', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹤山区', '河南省鹤壁市鹤山区', '3', 2, 'H', NULL, '1', '458010', '410600');
INSERT INTO `sys_region` VALUES ('410603', '2018-01-30 19:30:19', NULL, NULL, NULL, '山城区', '河南省鹤壁市山城区', '3', 3, 'S', NULL, '1', '458000', '410600');
INSERT INTO `sys_region` VALUES ('410611', '2018-01-30 19:30:19', NULL, NULL, NULL, '淇滨区', '河南省鹤壁市淇滨区', '3', 4, 'Z', NULL, '1', '458000', '410600');
INSERT INTO `sys_region` VALUES ('410621', '2018-01-30 19:30:19', NULL, NULL, NULL, '浚县', '河南省鹤壁市浚县', '3', 5, 'J', NULL, '1', '456250', '410600');
INSERT INTO `sys_region` VALUES ('410622', '2018-01-30 19:30:19', NULL, NULL, NULL, '淇县', '河南省鹤壁市淇县', '3', 6, 'Z', NULL, '1', '456750', '410600');
INSERT INTO `sys_region` VALUES ('410700', '2018-01-30 19:30:19', NULL, NULL, NULL, '新乡市', '河南省新乡市', '2', 7, 'X', NULL, '1', '453000', '410000');
INSERT INTO `sys_region` VALUES ('410701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省新乡市市辖区', '3', 1, 'S', NULL, '1', NULL, '410700');
INSERT INTO `sys_region` VALUES ('410702', '2018-01-30 19:30:19', NULL, NULL, NULL, '红旗区', '河南省新乡市红旗区', '3', 2, 'H', NULL, '1', '453000', '410700');
INSERT INTO `sys_region` VALUES ('410703', '2018-01-30 19:30:19', NULL, NULL, NULL, '卫滨区', '河南省新乡市卫滨区', '3', 3, 'W', NULL, '1', '453000', '410700');
INSERT INTO `sys_region` VALUES ('410704', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤泉区', '河南省新乡市凤泉区', '3', 4, 'F', NULL, '1', '453011', '410700');
INSERT INTO `sys_region` VALUES ('410711', '2018-01-30 19:30:19', NULL, NULL, NULL, '牧野区', '河南省新乡市牧野区', '3', 5, 'M', NULL, '1', '453002', '410700');
INSERT INTO `sys_region` VALUES ('410721', '2018-01-30 19:30:19', NULL, NULL, NULL, '新乡县', '河南省新乡市新乡县', '3', 6, 'X', NULL, '1', '453700', '410700');
INSERT INTO `sys_region` VALUES ('410724', '2018-01-30 19:30:19', NULL, NULL, NULL, '获嘉县', '河南省新乡市获嘉县', '3', 7, 'H', NULL, '1', '453800', '410700');
INSERT INTO `sys_region` VALUES ('410725', '2018-01-30 19:30:19', NULL, NULL, NULL, '原阳县', '河南省新乡市原阳县', '3', 8, 'Y', NULL, '1', '453500', '410700');
INSERT INTO `sys_region` VALUES ('410726', '2018-01-30 19:30:19', NULL, NULL, NULL, '延津县', '河南省新乡市延津县', '3', 9, 'Y', NULL, '1', '453200', '410700');
INSERT INTO `sys_region` VALUES ('410727', '2018-01-30 19:30:19', NULL, NULL, NULL, '封丘县', '河南省新乡市封丘县', '3', 10, 'F', NULL, '1', '453300', '410700');
INSERT INTO `sys_region` VALUES ('410728', '2018-01-30 19:30:19', NULL, NULL, NULL, '长垣县', '河南省新乡市长垣县', '3', 11, 'C', NULL, '1', '453400', '410700');
INSERT INTO `sys_region` VALUES ('410781', '2018-01-30 19:30:19', NULL, NULL, NULL, '卫辉市', '河南省新乡市卫辉市', '3', 12, 'W', NULL, '1', '453100', '410700');
INSERT INTO `sys_region` VALUES ('410782', '2018-01-30 19:30:19', NULL, NULL, NULL, '辉县市', '河南省新乡市辉县市', '3', 13, 'H', NULL, '1', '453600', '410700');
INSERT INTO `sys_region` VALUES ('410800', '2018-01-30 19:30:19', NULL, NULL, NULL, '焦作市', '河南省焦作市', '2', 8, 'J', NULL, '1', '454002', '410000');
INSERT INTO `sys_region` VALUES ('410801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省焦作市市辖区', '3', 1, 'S', NULL, '1', NULL, '410800');
INSERT INTO `sys_region` VALUES ('410802', '2018-01-30 19:30:19', NULL, NULL, NULL, '解放区', '河南省焦作市解放区', '3', 2, 'J', NULL, '1', '454000', '410800');
INSERT INTO `sys_region` VALUES ('410803', '2018-01-30 19:30:19', NULL, NULL, NULL, '中站区', '河南省焦作市中站区', '3', 3, 'Z', NULL, '1', '454191', '410800');
INSERT INTO `sys_region` VALUES ('410804', '2018-01-30 19:30:19', NULL, NULL, NULL, '马村区', '河南省焦作市马村区', '3', 4, 'M', NULL, '1', '454171', '410800');
INSERT INTO `sys_region` VALUES ('410811', '2018-01-30 19:30:19', NULL, NULL, NULL, '山阳区', '河南省焦作市山阳区', '3', 5, 'S', NULL, '1', '454002', '410800');
INSERT INTO `sys_region` VALUES ('410821', '2018-01-30 19:30:19', NULL, NULL, NULL, '修武县', '河南省焦作市修武县', '3', 6, 'X', NULL, '1', '454350', '410800');
INSERT INTO `sys_region` VALUES ('410822', '2018-01-30 19:30:19', NULL, NULL, NULL, '博爱县', '河南省焦作市博爱县', '3', 7, 'B', NULL, '1', '454450', '410800');
INSERT INTO `sys_region` VALUES ('410823', '2018-01-30 19:30:19', NULL, NULL, NULL, '武陟县', '河南省焦作市武陟县', '3', 8, 'W', NULL, '1', '454950', '410800');
INSERT INTO `sys_region` VALUES ('410825', '2018-01-30 19:30:19', NULL, NULL, NULL, '温县', '河南省焦作市温县', '3', 9, 'W', NULL, '1', '454850', '410800');
INSERT INTO `sys_region` VALUES ('410882', '2018-01-30 19:30:19', NULL, NULL, NULL, '沁阳市', '河南省焦作市沁阳市', '3', 10, 'Q', NULL, '1', '454550', '410800');
INSERT INTO `sys_region` VALUES ('410883', '2018-01-30 19:30:19', NULL, NULL, NULL, '孟州市', '河南省焦作市孟州市', '3', 11, 'M', NULL, '1', '454750', '410800');
INSERT INTO `sys_region` VALUES ('410900', '2018-01-30 19:30:19', NULL, NULL, NULL, '濮阳市', '河南省濮阳市', '2', 9, 'Z', NULL, '1', '457000', '410000');
INSERT INTO `sys_region` VALUES ('410901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省濮阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '410900');
INSERT INTO `sys_region` VALUES ('410902', '2018-01-30 19:30:19', NULL, NULL, NULL, '华龙区', '河南省濮阳市华龙区', '3', 2, 'H', NULL, '1', '457001', '410900');
INSERT INTO `sys_region` VALUES ('410922', '2018-01-30 19:30:19', NULL, NULL, NULL, '清丰县', '河南省濮阳市清丰县', '3', 3, 'Q', NULL, '1', '457300', '410900');
INSERT INTO `sys_region` VALUES ('410923', '2018-01-30 19:30:19', NULL, NULL, NULL, '南乐县', '河南省濮阳市南乐县', '3', 4, 'N', NULL, '1', '457400', '410900');
INSERT INTO `sys_region` VALUES ('410926', '2018-01-30 19:30:19', NULL, NULL, NULL, '范县', '河南省濮阳市范县', '3', 5, 'F', NULL, '1', '457500', '410900');
INSERT INTO `sys_region` VALUES ('410927', '2018-01-30 19:30:19', NULL, NULL, NULL, '台前县', '河南省濮阳市台前县', '3', 6, 'T', NULL, '1', '457600', '410900');
INSERT INTO `sys_region` VALUES ('410928', '2018-01-30 19:30:19', NULL, NULL, NULL, '濮阳县', '河南省濮阳市濮阳县', '3', 7, 'Z', NULL, '1', '457100', '410900');
INSERT INTO `sys_region` VALUES ('411000', '2018-01-30 19:30:19', NULL, NULL, NULL, '许昌市', '河南省许昌市', '2', 10, 'X', NULL, '1', '461000', '410000');
INSERT INTO `sys_region` VALUES ('411001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省许昌市市辖区', '3', 1, 'S', NULL, '1', NULL, '411000');
INSERT INTO `sys_region` VALUES ('411002', '2018-01-30 19:30:19', NULL, NULL, NULL, '魏都区', '河南省许昌市魏都区', '3', 2, 'W', NULL, '1', '461000', '411000');
INSERT INTO `sys_region` VALUES ('411023', '2018-01-30 19:30:19', NULL, NULL, NULL, '许昌县', '河南省许昌市许昌县', '3', 3, 'X', NULL, '1', '461100', '411000');
INSERT INTO `sys_region` VALUES ('411024', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄢陵县', '河南省许昌市鄢陵县', '3', 4, 'Z', NULL, '1', '461200', '411000');
INSERT INTO `sys_region` VALUES ('411025', '2018-01-30 19:30:19', NULL, NULL, NULL, '襄城县', '河南省许昌市襄城县', '3', 5, 'X', NULL, '1', '461700', '411000');
INSERT INTO `sys_region` VALUES ('411081', '2018-01-30 19:30:19', NULL, NULL, NULL, '禹州市', '河南省许昌市禹州市', '3', 6, 'Y', NULL, '1', '461670', '411000');
INSERT INTO `sys_region` VALUES ('411082', '2018-01-30 19:30:19', NULL, NULL, NULL, '长葛市', '河南省许昌市长葛市', '3', 7, 'C', NULL, '1', '461500', '411000');
INSERT INTO `sys_region` VALUES ('411100', '2018-01-30 19:30:19', NULL, NULL, NULL, '漯河市', '河南省漯河市', '2', 11, 'Z', NULL, '1', '462000', '410000');
INSERT INTO `sys_region` VALUES ('411101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省漯河市市辖区', '3', 1, 'S', NULL, '1', NULL, '411100');
INSERT INTO `sys_region` VALUES ('411102', '2018-01-30 19:30:19', NULL, NULL, NULL, '源汇区', '河南省漯河市源汇区', '3', 2, 'Y', NULL, '1', '462000', '411100');
INSERT INTO `sys_region` VALUES ('411103', '2018-01-30 19:30:19', NULL, NULL, NULL, '郾城区', '河南省漯河市郾城区', '3', 3, 'Z', NULL, '1', '462300', '411100');
INSERT INTO `sys_region` VALUES ('411104', '2018-01-30 19:30:19', NULL, NULL, NULL, '召陵区', '河南省漯河市召陵区', '3', 4, 'Z', NULL, '1', '462300', '411100');
INSERT INTO `sys_region` VALUES ('411121', '2018-01-30 19:30:19', NULL, NULL, NULL, '舞阳县', '河南省漯河市舞阳县', '3', 5, 'W', NULL, '1', '462400', '411100');
INSERT INTO `sys_region` VALUES ('411122', '2018-01-30 19:30:19', NULL, NULL, NULL, '临颍县', '河南省漯河市临颍县', '3', 6, 'L', NULL, '1', '462600', '411100');
INSERT INTO `sys_region` VALUES ('411200', '2018-01-30 19:30:19', NULL, NULL, NULL, '三门峡市', '河南省三门峡市', '2', 12, 'S', NULL, '1', '472000', '410000');
INSERT INTO `sys_region` VALUES ('411201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省三门峡市市辖区', '3', 1, 'S', NULL, '1', NULL, '411200');
INSERT INTO `sys_region` VALUES ('411202', '2018-01-30 19:30:19', NULL, NULL, NULL, '湖滨区', '河南省三门峡市湖滨区', '3', 2, 'H', NULL, '1', '472000', '411200');
INSERT INTO `sys_region` VALUES ('411203', '2018-01-30 19:30:19', NULL, NULL, NULL, '陕州区', '河南省三门峡市陕州区', '3', 3, 'S', NULL, '1', NULL, '411200');
INSERT INTO `sys_region` VALUES ('411221', '2018-01-30 19:30:19', NULL, NULL, NULL, '渑池县', '河南省三门峡市渑池县', '3', 4, 'Z', NULL, '1', '472400', '411200');
INSERT INTO `sys_region` VALUES ('411224', '2018-01-30 19:30:19', NULL, NULL, NULL, '卢氏县', '河南省三门峡市卢氏县', '3', 5, 'L', NULL, '1', '472200', '411200');
INSERT INTO `sys_region` VALUES ('411281', '2018-01-30 19:30:19', NULL, NULL, NULL, '义马市', '河南省三门峡市义马市', '3', 6, 'Y', NULL, '1', '472300', '411200');
INSERT INTO `sys_region` VALUES ('411282', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵宝市', '河南省三门峡市灵宝市', '3', 7, 'L', NULL, '1', '472500', '411200');
INSERT INTO `sys_region` VALUES ('411300', '2018-01-30 19:30:19', NULL, NULL, NULL, '南阳市', '河南省南阳市', '2', 13, 'N', NULL, '1', '473002', '410000');
INSERT INTO `sys_region` VALUES ('411301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省南阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '411300');
INSERT INTO `sys_region` VALUES ('411302', '2018-01-30 19:30:19', NULL, NULL, NULL, '宛城区', '河南省南阳市宛城区', '3', 2, 'W', NULL, '1', '473001', '411300');
INSERT INTO `sys_region` VALUES ('411303', '2018-01-30 19:30:19', NULL, NULL, NULL, '卧龙区', '河南省南阳市卧龙区', '3', 3, 'W', NULL, '1', '473003', '411300');
INSERT INTO `sys_region` VALUES ('411321', '2018-01-30 19:30:19', NULL, NULL, NULL, '南召县', '河南省南阳市南召县', '3', 4, 'N', NULL, '1', '474650', '411300');
INSERT INTO `sys_region` VALUES ('411322', '2018-01-30 19:30:19', NULL, NULL, NULL, '方城县', '河南省南阳市方城县', '3', 5, 'F', NULL, '1', '473200', '411300');
INSERT INTO `sys_region` VALUES ('411323', '2018-01-30 19:30:19', NULL, NULL, NULL, '西峡县', '河南省南阳市西峡县', '3', 6, 'X', NULL, '1', '474550', '411300');
INSERT INTO `sys_region` VALUES ('411324', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇平县', '河南省南阳市镇平县', '3', 7, 'Z', NULL, '1', '474250', '411300');
INSERT INTO `sys_region` VALUES ('411325', '2018-01-30 19:30:19', NULL, NULL, NULL, '内乡县', '河南省南阳市内乡县', '3', 8, 'N', NULL, '1', '474350', '411300');
INSERT INTO `sys_region` VALUES ('411326', '2018-01-30 19:30:19', NULL, NULL, NULL, '淅川县', '河南省南阳市淅川县', '3', 9, 'Z', NULL, '1', '474450', '411300');
INSERT INTO `sys_region` VALUES ('411327', '2018-01-30 19:30:19', NULL, NULL, NULL, '社旗县', '河南省南阳市社旗县', '3', 10, 'S', NULL, '1', '473300', '411300');
INSERT INTO `sys_region` VALUES ('411328', '2018-01-30 19:30:19', NULL, NULL, NULL, '唐河县', '河南省南阳市唐河县', '3', 11, 'T', NULL, '1', '473400', '411300');
INSERT INTO `sys_region` VALUES ('411329', '2018-01-30 19:30:19', NULL, NULL, NULL, '新野县', '河南省南阳市新野县', '3', 12, 'X', NULL, '1', '473500', '411300');
INSERT INTO `sys_region` VALUES ('411330', '2018-01-30 19:30:19', NULL, NULL, NULL, '桐柏县', '河南省南阳市桐柏县', '3', 13, 'T', NULL, '1', '474750', '411300');
INSERT INTO `sys_region` VALUES ('411381', '2018-01-30 19:30:19', NULL, NULL, NULL, '邓州市', '河南省南阳市邓州市', '3', 14, 'D', NULL, '1', '474150', '411300');
INSERT INTO `sys_region` VALUES ('411400', '2018-01-30 19:30:19', NULL, NULL, NULL, '商丘市', '河南省商丘市', '2', 14, 'S', NULL, '1', '476000', '410000');
INSERT INTO `sys_region` VALUES ('411401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省商丘市市辖区', '3', 1, 'S', NULL, '1', NULL, '411400');
INSERT INTO `sys_region` VALUES ('411402', '2018-01-30 19:30:19', NULL, NULL, NULL, '梁园区', '河南省商丘市梁园区', '3', 2, 'L', NULL, '1', '476000', '411400');
INSERT INTO `sys_region` VALUES ('411403', '2018-01-30 19:30:19', NULL, NULL, NULL, '睢阳区', '河南省商丘市睢阳区', '3', 3, 'Z', NULL, '1', '476100', '411400');
INSERT INTO `sys_region` VALUES ('411421', '2018-01-30 19:30:19', NULL, NULL, NULL, '民权县', '河南省商丘市民权县', '3', 4, 'M', NULL, '1', '476800', '411400');
INSERT INTO `sys_region` VALUES ('411422', '2018-01-30 19:30:19', NULL, NULL, NULL, '睢县', '河南省商丘市睢县', '3', 5, 'Z', NULL, '1', '476900', '411400');
INSERT INTO `sys_region` VALUES ('411423', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁陵县', '河南省商丘市宁陵县', '3', 6, 'N', NULL, '1', '476700', '411400');
INSERT INTO `sys_region` VALUES ('411424', '2018-01-30 19:30:19', NULL, NULL, NULL, '柘城县', '河南省商丘市柘城县', '3', 7, 'Z', NULL, '1', '476200', '411400');
INSERT INTO `sys_region` VALUES ('411425', '2018-01-30 19:30:19', NULL, NULL, NULL, '虞城县', '河南省商丘市虞城县', '3', 8, 'Y', NULL, '1', '476300', '411400');
INSERT INTO `sys_region` VALUES ('411426', '2018-01-30 19:30:19', NULL, NULL, NULL, '夏邑县', '河南省商丘市夏邑县', '3', 9, 'X', NULL, '1', '476400', '411400');
INSERT INTO `sys_region` VALUES ('411481', '2018-01-30 19:30:19', NULL, NULL, NULL, '永城市', '河南省商丘市永城市', '3', 10, 'Y', NULL, '1', '476600', '411400');
INSERT INTO `sys_region` VALUES ('411500', '2018-01-30 19:30:19', NULL, NULL, NULL, '信阳市', '河南省信阳市', '2', 15, 'X', NULL, '1', '464000', '410000');
INSERT INTO `sys_region` VALUES ('411501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省信阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '411500');
INSERT INTO `sys_region` VALUES ('411502', '2018-01-30 19:30:19', NULL, NULL, NULL, '浉河区', '河南省信阳市浉河区', '3', 2, NULL, NULL, '1', '464000', '411500');
INSERT INTO `sys_region` VALUES ('411503', '2018-01-30 19:30:19', NULL, NULL, NULL, '平桥区', '河南省信阳市平桥区', '3', 3, 'P', NULL, '1', '464100', '411500');
INSERT INTO `sys_region` VALUES ('411521', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗山县', '河南省信阳市罗山县', '3', 4, 'L', NULL, '1', '464200', '411500');
INSERT INTO `sys_region` VALUES ('411522', '2018-01-30 19:30:19', NULL, NULL, NULL, '光山县', '河南省信阳市光山县', '3', 5, 'G', NULL, '1', '465450', '411500');
INSERT INTO `sys_region` VALUES ('411523', '2018-01-30 19:30:19', NULL, NULL, NULL, '新县', '河南省信阳市新县', '3', 6, 'X', NULL, '1', '465550', '411500');
INSERT INTO `sys_region` VALUES ('411524', '2018-01-30 19:30:19', NULL, NULL, NULL, '商城县', '河南省信阳市商城县', '3', 7, 'S', NULL, '1', '465350', '411500');
INSERT INTO `sys_region` VALUES ('411525', '2018-01-30 19:30:19', NULL, NULL, NULL, '固始县', '河南省信阳市固始县', '3', 8, 'G', NULL, '1', '465250', '411500');
INSERT INTO `sys_region` VALUES ('411526', '2018-01-30 19:30:19', NULL, NULL, NULL, '潢川县', '河南省信阳市潢川县', '3', 9, 'Z', NULL, '1', '465150', '411500');
INSERT INTO `sys_region` VALUES ('411527', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮滨县', '河南省信阳市淮滨县', '3', 10, 'H', NULL, '1', '464400', '411500');
INSERT INTO `sys_region` VALUES ('411528', '2018-01-30 19:30:19', NULL, NULL, NULL, '息县', '河南省信阳市息县', '3', 11, 'X', NULL, '1', '464300', '411500');
INSERT INTO `sys_region` VALUES ('411600', '2018-01-30 19:30:19', NULL, NULL, NULL, '周口市', '河南省周口市', '2', 16, 'Z', NULL, '1', '466000', '410000');
INSERT INTO `sys_region` VALUES ('411601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省周口市市辖区', '3', 1, 'S', NULL, '1', NULL, '411600');
INSERT INTO `sys_region` VALUES ('411602', '2018-01-30 19:30:19', NULL, NULL, NULL, '川汇区', '河南省周口市川汇区', '3', 2, 'C', NULL, '1', '466000', '411600');
INSERT INTO `sys_region` VALUES ('411621', '2018-01-30 19:30:19', NULL, NULL, NULL, '扶沟县', '河南省周口市扶沟县', '3', 3, 'F', NULL, '1', '461300', '411600');
INSERT INTO `sys_region` VALUES ('411622', '2018-01-30 19:30:19', NULL, NULL, NULL, '西华县', '河南省周口市西华县', '3', 4, 'X', NULL, '1', '466600', '411600');
INSERT INTO `sys_region` VALUES ('411623', '2018-01-30 19:30:19', NULL, NULL, NULL, '商水县', '河南省周口市商水县', '3', 5, 'S', NULL, '1', '466100', '411600');
INSERT INTO `sys_region` VALUES ('411624', '2018-01-30 19:30:19', NULL, NULL, NULL, '沈丘县', '河南省周口市沈丘县', '3', 6, 'S', NULL, '1', '466300', '411600');
INSERT INTO `sys_region` VALUES ('411625', '2018-01-30 19:30:19', NULL, NULL, NULL, '郸城县', '河南省周口市郸城县', '3', 7, 'D', NULL, '1', '477150', '411600');
INSERT INTO `sys_region` VALUES ('411626', '2018-01-30 19:30:19', NULL, NULL, NULL, '淮阳县', '河南省周口市淮阳县', '3', 8, 'H', NULL, '1', '466700', '411600');
INSERT INTO `sys_region` VALUES ('411627', '2018-01-30 19:30:19', NULL, NULL, NULL, '太康县', '河南省周口市太康县', '3', 9, 'T', NULL, '1', '461400', '411600');
INSERT INTO `sys_region` VALUES ('411628', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹿邑县', '河南省周口市鹿邑县', '3', 10, 'L', NULL, '1', '477200', '411600');
INSERT INTO `sys_region` VALUES ('411681', '2018-01-30 19:30:19', NULL, NULL, NULL, '项城市', '河南省周口市项城市', '3', 11, 'X', NULL, '1', '466200', '411600');
INSERT INTO `sys_region` VALUES ('411700', '2018-01-30 19:30:19', NULL, NULL, NULL, '驻马店市', '河南省驻马店市', '2', 17, 'Z', NULL, '1', '463000', '410000');
INSERT INTO `sys_region` VALUES ('411701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '河南省驻马店市市辖区', '3', 1, 'S', NULL, '1', NULL, '411700');
INSERT INTO `sys_region` VALUES ('411702', '2018-01-30 19:30:19', NULL, NULL, NULL, '驿城区', '河南省驻马店市驿城区', '3', 2, 'Z', NULL, '1', '463000', '411700');
INSERT INTO `sys_region` VALUES ('411721', '2018-01-30 19:30:19', NULL, NULL, NULL, '西平县', '河南省驻马店市西平县', '3', 3, 'X', NULL, '1', '463900', '411700');
INSERT INTO `sys_region` VALUES ('411722', '2018-01-30 19:30:19', NULL, NULL, NULL, '上蔡县', '河南省驻马店市上蔡县', '3', 4, 'S', NULL, '1', '463800', '411700');
INSERT INTO `sys_region` VALUES ('411723', '2018-01-30 19:30:19', NULL, NULL, NULL, '平舆县', '河南省驻马店市平舆县', '3', 5, 'P', NULL, '1', '463400', '411700');
INSERT INTO `sys_region` VALUES ('411724', '2018-01-30 19:30:19', NULL, NULL, NULL, '正阳县', '河南省驻马店市正阳县', '3', 6, 'Z', NULL, '1', '463600', '411700');
INSERT INTO `sys_region` VALUES ('411725', '2018-01-30 19:30:19', NULL, NULL, NULL, '确山县', '河南省驻马店市确山县', '3', 7, 'Q', NULL, '1', '463200', '411700');
INSERT INTO `sys_region` VALUES ('411726', '2018-01-30 19:30:19', NULL, NULL, NULL, '泌阳县', '河南省驻马店市泌阳县', '3', 8, 'M', NULL, '1', '463700', '411700');
INSERT INTO `sys_region` VALUES ('411727', '2018-01-30 19:30:19', NULL, NULL, NULL, '汝南县', '河南省驻马店市汝南县', '3', 9, 'R', NULL, '1', '463300', '411700');
INSERT INTO `sys_region` VALUES ('411728', '2018-01-30 19:30:19', NULL, NULL, NULL, '遂平县', '河南省驻马店市遂平县', '3', 10, 'S', NULL, '1', '463100', '411700');
INSERT INTO `sys_region` VALUES ('411729', '2018-01-30 19:30:19', NULL, NULL, NULL, '新蔡县', '河南省驻马店市新蔡县', '3', 11, 'X', NULL, '1', '463500', '411700');
INSERT INTO `sys_region` VALUES ('419000', '2018-01-30 19:30:19', NULL, NULL, NULL, '省直辖县级行政区划', '河南省省直辖县级行政区划', '2', 18, 'S', NULL, '1', '', '410000');
INSERT INTO `sys_region` VALUES ('419001', '2018-01-30 19:30:19', NULL, NULL, NULL, '济源市', '河南省省直辖县级行政区划济源市', '3', 1, 'J', NULL, '1', '454650', '419000');
INSERT INTO `sys_region` VALUES ('420000', '2018-01-30 19:30:19', NULL, NULL, NULL, '湖北省', '湖北省', '1', 17, 'H', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('420100', '2018-01-30 19:30:19', NULL, NULL, NULL, '武汉市', '湖北省武汉市', '2', 1, 'W', NULL, '1', '430014', '420000');
INSERT INTO `sys_region` VALUES ('420101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省武汉市市辖区', '3', 1, 'S', NULL, '1', NULL, '420100');
INSERT INTO `sys_region` VALUES ('420102', '2018-01-30 19:30:19', NULL, NULL, NULL, '江岸区', '湖北省武汉市江岸区', '3', 2, 'J', NULL, '1', '430014', '420100');
INSERT INTO `sys_region` VALUES ('420103', '2018-01-30 19:30:19', NULL, NULL, NULL, '江汉区', '湖北省武汉市江汉区', '3', 3, 'J', NULL, '1', '430021', '420100');
INSERT INTO `sys_region` VALUES ('420104', '2018-01-30 19:30:19', NULL, NULL, NULL, '硚口区', '湖北省武汉市硚口区', '3', 4, 'C', NULL, '1', '430033', '420100');
INSERT INTO `sys_region` VALUES ('420105', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉阳区', '湖北省武汉市汉阳区', '3', 5, 'H', NULL, '1', '430050', '420100');
INSERT INTO `sys_region` VALUES ('420106', '2018-01-30 19:30:19', NULL, NULL, NULL, '武昌区', '湖北省武汉市武昌区', '3', 6, 'W', NULL, '1', '430061', '420100');
INSERT INTO `sys_region` VALUES ('420107', '2018-01-30 19:30:19', NULL, NULL, NULL, '青山区', '湖北省武汉市青山区', '3', 7, 'Q', NULL, '1', '430080', '420100');
INSERT INTO `sys_region` VALUES ('420111', '2018-01-30 19:30:19', NULL, NULL, NULL, '洪山区', '湖北省武汉市洪山区', '3', 8, 'H', NULL, '1', '430070', '420100');
INSERT INTO `sys_region` VALUES ('420112', '2018-01-30 19:30:19', NULL, NULL, NULL, '东西湖区', '湖北省武汉市东西湖区', '3', 9, 'D', NULL, '1', '430040', '420100');
INSERT INTO `sys_region` VALUES ('420113', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉南区', '湖北省武汉市汉南区', '3', 10, 'H', NULL, '1', '430090', '420100');
INSERT INTO `sys_region` VALUES ('420114', '2018-01-30 19:30:19', NULL, NULL, NULL, '蔡甸区', '湖北省武汉市蔡甸区', '3', 11, 'C', NULL, '1', '430100', '420100');
INSERT INTO `sys_region` VALUES ('420115', '2018-01-30 19:30:19', NULL, NULL, NULL, '江夏区', '湖北省武汉市江夏区', '3', 12, 'J', NULL, '1', '430200', '420100');
INSERT INTO `sys_region` VALUES ('420116', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄陂区', '湖北省武汉市黄陂区', '3', 13, 'H', NULL, '1', '432200', '420100');
INSERT INTO `sys_region` VALUES ('420117', '2018-01-30 19:30:19', NULL, NULL, NULL, '新洲区', '湖北省武汉市新洲区', '3', 14, 'X', NULL, '1', '431400', '420100');
INSERT INTO `sys_region` VALUES ('420200', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄石市', '湖北省黄石市', '2', 2, 'H', NULL, '1', '435003', '420000');
INSERT INTO `sys_region` VALUES ('420201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省黄石市市辖区', '3', 1, 'S', NULL, '1', NULL, '420200');
INSERT INTO `sys_region` VALUES ('420202', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄石港区', '湖北省黄石市黄石港区', '3', 2, 'H', NULL, '1', '435000', '420200');
INSERT INTO `sys_region` VALUES ('420203', '2018-01-30 19:30:19', NULL, NULL, NULL, '西塞山区', '湖北省黄石市西塞山区', '3', 3, 'X', NULL, '1', '435001', '420200');
INSERT INTO `sys_region` VALUES ('420204', '2018-01-30 19:30:19', NULL, NULL, NULL, '下陆区', '湖北省黄石市下陆区', '3', 4, 'X', NULL, '1', '435005', '420200');
INSERT INTO `sys_region` VALUES ('420205', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁山区', '湖北省黄石市铁山区', '3', 5, 'T', NULL, '1', '435006', '420200');
INSERT INTO `sys_region` VALUES ('420222', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳新县', '湖北省黄石市阳新县', '3', 6, 'Y', NULL, '1', '435200', '420200');
INSERT INTO `sys_region` VALUES ('420281', '2018-01-30 19:30:19', NULL, NULL, NULL, '大冶市', '湖北省黄石市大冶市', '3', 7, 'D', NULL, '1', '435100', '420200');
INSERT INTO `sys_region` VALUES ('420300', '2018-01-30 19:30:19', NULL, NULL, NULL, '十堰市', '湖北省十堰市', '2', 3, 'S', NULL, '1', '442000', '420000');
INSERT INTO `sys_region` VALUES ('420301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省十堰市市辖区', '3', 1, 'S', NULL, '1', NULL, '420300');
INSERT INTO `sys_region` VALUES ('420302', '2018-01-30 19:30:19', NULL, NULL, NULL, '茅箭区', '湖北省十堰市茅箭区', '3', 2, 'M', NULL, '1', '442012', '420300');
INSERT INTO `sys_region` VALUES ('420303', '2018-01-30 19:30:19', NULL, NULL, NULL, '张湾区', '湖北省十堰市张湾区', '3', 3, 'Z', NULL, '1', '442001', '420300');
INSERT INTO `sys_region` VALUES ('420304', '2018-01-30 19:30:19', NULL, NULL, NULL, '郧阳区', '湖北省十堰市郧阳区', '3', 4, 'Y', NULL, '1', '442500', '420300');
INSERT INTO `sys_region` VALUES ('420322', '2018-01-30 19:30:19', NULL, NULL, NULL, '郧西县', '湖北省十堰市郧西县', '3', 5, 'Y', NULL, '1', '442600', '420300');
INSERT INTO `sys_region` VALUES ('420323', '2018-01-30 19:30:19', NULL, NULL, NULL, '竹山县', '湖北省十堰市竹山县', '3', 6, 'Z', NULL, '1', '442200', '420300');
INSERT INTO `sys_region` VALUES ('420324', '2018-01-30 19:30:19', NULL, NULL, NULL, '竹溪县', '湖北省十堰市竹溪县', '3', 7, 'Z', NULL, '1', '442300', '420300');
INSERT INTO `sys_region` VALUES ('420325', '2018-01-30 19:30:19', NULL, NULL, NULL, '房县', '湖北省十堰市房县', '3', 8, 'F', NULL, '1', '442100', '420300');
INSERT INTO `sys_region` VALUES ('420381', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹江口市', '湖北省十堰市丹江口市', '3', 9, 'D', NULL, '1', '442700', '420300');
INSERT INTO `sys_region` VALUES ('420500', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜昌市', '湖北省宜昌市', '2', 4, 'Y', NULL, '1', '443000', '420000');
INSERT INTO `sys_region` VALUES ('420501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省宜昌市市辖区', '3', 1, 'S', NULL, '1', NULL, '420500');
INSERT INTO `sys_region` VALUES ('420502', '2018-01-30 19:30:19', NULL, NULL, NULL, '西陵区', '湖北省宜昌市西陵区', '3', 2, 'X', NULL, '1', '443000', '420500');
INSERT INTO `sys_region` VALUES ('420503', '2018-01-30 19:30:19', NULL, NULL, NULL, '伍家岗区', '湖北省宜昌市伍家岗区', '3', 3, 'W', NULL, '1', '443001', '420500');
INSERT INTO `sys_region` VALUES ('420504', '2018-01-30 19:30:19', NULL, NULL, NULL, '点军区', '湖北省宜昌市点军区', '3', 4, 'D', NULL, '1', '443006', '420500');
INSERT INTO `sys_region` VALUES ('420505', '2018-01-30 19:30:19', NULL, NULL, NULL, '猇亭区', '湖北省宜昌市猇亭区', '3', 5, NULL, NULL, '1', '443007', '420500');
INSERT INTO `sys_region` VALUES ('420506', '2018-01-30 19:30:19', NULL, NULL, NULL, '夷陵区', '湖北省宜昌市夷陵区', '3', 6, 'Y', NULL, '1', '443100', '420500');
INSERT INTO `sys_region` VALUES ('420525', '2018-01-30 19:30:19', NULL, NULL, NULL, '远安县', '湖北省宜昌市远安县', '3', 7, 'Y', NULL, '1', '444200', '420500');
INSERT INTO `sys_region` VALUES ('420526', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴山县', '湖北省宜昌市兴山县', '3', 8, 'X', NULL, '1', '443711', '420500');
INSERT INTO `sys_region` VALUES ('420527', '2018-01-30 19:30:19', NULL, NULL, NULL, '秭归县', '湖北省宜昌市秭归县', '3', 9, 'Z', NULL, '1', '443600', '420500');
INSERT INTO `sys_region` VALUES ('420528', '2018-01-30 19:30:19', NULL, NULL, NULL, '长阳土家族自治县', '湖北省宜昌市长阳土家族自治县', '3', 10, 'C', NULL, '1', '443500', '420500');
INSERT INTO `sys_region` VALUES ('420529', '2018-01-30 19:30:19', NULL, NULL, NULL, '五峰土家族自治县', '湖北省宜昌市五峰土家族自治县', '3', 11, 'W', NULL, '1', '443413', '420500');
INSERT INTO `sys_region` VALUES ('420581', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜都市', '湖北省宜昌市宜都市', '3', 12, 'Y', NULL, '1', '443300', '420500');
INSERT INTO `sys_region` VALUES ('420582', '2018-01-30 19:30:19', NULL, NULL, NULL, '当阳市', '湖北省宜昌市当阳市', '3', 13, 'D', NULL, '1', '444100', '420500');
INSERT INTO `sys_region` VALUES ('420583', '2018-01-30 19:30:19', NULL, NULL, NULL, '枝江市', '湖北省宜昌市枝江市', '3', 14, 'Z', NULL, '1', '443200', '420500');
INSERT INTO `sys_region` VALUES ('420600', '2018-01-30 19:30:19', NULL, NULL, NULL, '襄阳市', '湖北省襄阳市', '2', 5, 'X', NULL, '1', '441021', '420000');
INSERT INTO `sys_region` VALUES ('420601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省襄阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '420600');
INSERT INTO `sys_region` VALUES ('420602', '2018-01-30 19:30:19', NULL, NULL, NULL, '襄城区', '湖北省襄阳市襄城区', '3', 2, 'X', NULL, '1', '441021', '420600');
INSERT INTO `sys_region` VALUES ('420606', '2018-01-30 19:30:19', NULL, NULL, NULL, '樊城区', '湖北省襄阳市樊城区', '3', 3, 'F', NULL, '1', '441001', '420600');
INSERT INTO `sys_region` VALUES ('420607', '2018-01-30 19:30:19', NULL, NULL, NULL, '襄州区', '湖北省襄阳市襄州区', '3', 4, 'X', NULL, '1', '441100', '420600');
INSERT INTO `sys_region` VALUES ('420624', '2018-01-30 19:30:19', NULL, NULL, NULL, '南漳县', '湖北省襄阳市南漳县', '3', 5, 'N', NULL, '1', '441500', '420600');
INSERT INTO `sys_region` VALUES ('420625', '2018-01-30 19:30:19', NULL, NULL, NULL, '谷城县', '湖北省襄阳市谷城县', '3', 6, 'G', NULL, '1', '441700', '420600');
INSERT INTO `sys_region` VALUES ('420626', '2018-01-30 19:30:19', NULL, NULL, NULL, '保康县', '湖北省襄阳市保康县', '3', 7, 'B', NULL, '1', '441600', '420600');
INSERT INTO `sys_region` VALUES ('420682', '2018-01-30 19:30:19', NULL, NULL, NULL, '老河口市', '湖北省襄阳市老河口市', '3', 8, 'L', NULL, '1', '441800', '420600');
INSERT INTO `sys_region` VALUES ('420683', '2018-01-30 19:30:19', NULL, NULL, NULL, '枣阳市', '湖北省襄阳市枣阳市', '3', 9, 'Z', NULL, '1', '441200', '420600');
INSERT INTO `sys_region` VALUES ('420684', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜城市', '湖北省襄阳市宜城市', '3', 10, 'Y', NULL, '1', '441400', '420600');
INSERT INTO `sys_region` VALUES ('420700', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄂州市', '湖北省鄂州市', '2', 6, 'E', NULL, '1', '436000', '420000');
INSERT INTO `sys_region` VALUES ('420701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省鄂州市市辖区', '3', 1, 'S', NULL, '1', NULL, '420700');
INSERT INTO `sys_region` VALUES ('420702', '2018-01-30 19:30:19', NULL, NULL, NULL, '梁子湖区', '湖北省鄂州市梁子湖区', '3', 2, 'L', NULL, '1', '436064', '420700');
INSERT INTO `sys_region` VALUES ('420703', '2018-01-30 19:30:19', NULL, NULL, NULL, '华容区', '湖北省鄂州市华容区', '3', 3, 'H', NULL, '1', '436030', '420700');
INSERT INTO `sys_region` VALUES ('420704', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄂城区', '湖北省鄂州市鄂城区', '3', 4, 'E', NULL, '1', '436000', '420700');
INSERT INTO `sys_region` VALUES ('420800', '2018-01-30 19:30:19', NULL, NULL, NULL, '荆门市', '湖北省荆门市', '2', 7, 'J', NULL, '1', '448000', '420000');
INSERT INTO `sys_region` VALUES ('420801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省荆门市市辖区', '3', 1, 'S', NULL, '1', NULL, '420800');
INSERT INTO `sys_region` VALUES ('420802', '2018-01-30 19:30:19', NULL, NULL, NULL, '东宝区', '湖北省荆门市东宝区', '3', 2, 'D', NULL, '1', '448004', '420800');
INSERT INTO `sys_region` VALUES ('420804', '2018-01-30 19:30:19', NULL, NULL, NULL, '掇刀区', '湖北省荆门市掇刀区', '3', 3, 'D', NULL, '1', '448124', '420800');
INSERT INTO `sys_region` VALUES ('420821', '2018-01-30 19:30:19', NULL, NULL, NULL, '京山县', '湖北省荆门市京山县', '3', 4, 'J', NULL, '1', '431800', '420800');
INSERT INTO `sys_region` VALUES ('420822', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙洋县', '湖北省荆门市沙洋县', '3', 5, 'S', NULL, '1', '448200', '420800');
INSERT INTO `sys_region` VALUES ('420881', '2018-01-30 19:30:19', NULL, NULL, NULL, '钟祥市', '湖北省荆门市钟祥市', '3', 6, 'Z', NULL, '1', '431900', '420800');
INSERT INTO `sys_region` VALUES ('420900', '2018-01-30 19:30:19', NULL, NULL, NULL, '孝感市', '湖北省孝感市', '2', 8, 'X', NULL, '1', '432100', '420000');
INSERT INTO `sys_region` VALUES ('420901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省孝感市市辖区', '3', 1, 'S', NULL, '1', NULL, '420900');
INSERT INTO `sys_region` VALUES ('420902', '2018-01-30 19:30:19', NULL, NULL, NULL, '孝南区', '湖北省孝感市孝南区', '3', 2, 'X', NULL, '1', '432100', '420900');
INSERT INTO `sys_region` VALUES ('420921', '2018-01-30 19:30:19', NULL, NULL, NULL, '孝昌县', '湖北省孝感市孝昌县', '3', 3, 'X', NULL, '1', '432900', '420900');
INSERT INTO `sys_region` VALUES ('420922', '2018-01-30 19:30:19', NULL, NULL, NULL, '大悟县', '湖北省孝感市大悟县', '3', 4, 'D', NULL, '1', '432800', '420900');
INSERT INTO `sys_region` VALUES ('420923', '2018-01-30 19:30:19', NULL, NULL, NULL, '云梦县', '湖北省孝感市云梦县', '3', 5, 'Y', NULL, '1', '432500', '420900');
INSERT INTO `sys_region` VALUES ('420981', '2018-01-30 19:30:19', NULL, NULL, NULL, '应城市', '湖北省孝感市应城市', '3', 6, 'Y', NULL, '1', '432400', '420900');
INSERT INTO `sys_region` VALUES ('420982', '2018-01-30 19:30:19', NULL, NULL, NULL, '安陆市', '湖北省孝感市安陆市', '3', 7, 'A', NULL, '1', '432600', '420900');
INSERT INTO `sys_region` VALUES ('420984', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉川市', '湖北省孝感市汉川市', '3', 8, 'H', NULL, '1', '432300', '420900');
INSERT INTO `sys_region` VALUES ('421000', '2018-01-30 19:30:19', NULL, NULL, NULL, '荆州市', '湖北省荆州市', '2', 9, 'J', NULL, '1', '434000', '420000');
INSERT INTO `sys_region` VALUES ('421001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省荆州市市辖区', '3', 1, 'S', NULL, '1', NULL, '421000');
INSERT INTO `sys_region` VALUES ('421002', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙市区', '湖北省荆州市沙市区', '3', 2, 'S', NULL, '1', '434000', '421000');
INSERT INTO `sys_region` VALUES ('421003', '2018-01-30 19:30:19', NULL, NULL, NULL, '荆州区', '湖北省荆州市荆州区', '3', 3, 'J', NULL, '1', '434020', '421000');
INSERT INTO `sys_region` VALUES ('421022', '2018-01-30 19:30:19', NULL, NULL, NULL, '公安县', '湖北省荆州市公安县', '3', 4, 'G', NULL, '1', '434300', '421000');
INSERT INTO `sys_region` VALUES ('421023', '2018-01-30 19:30:19', NULL, NULL, NULL, '监利县', '湖北省荆州市监利县', '3', 5, 'J', NULL, '1', '433300', '421000');
INSERT INTO `sys_region` VALUES ('421024', '2018-01-30 19:30:19', NULL, NULL, NULL, '江陵县', '湖北省荆州市江陵县', '3', 6, 'J', NULL, '1', '434101', '421000');
INSERT INTO `sys_region` VALUES ('421081', '2018-01-30 19:30:19', NULL, NULL, NULL, '石首市', '湖北省荆州市石首市', '3', 7, 'S', NULL, '1', '434400', '421000');
INSERT INTO `sys_region` VALUES ('421083', '2018-01-30 19:30:19', NULL, NULL, NULL, '洪湖市', '湖北省荆州市洪湖市', '3', 8, 'H', NULL, '1', '433200', '421000');
INSERT INTO `sys_region` VALUES ('421087', '2018-01-30 19:30:19', NULL, NULL, NULL, '松滋市', '湖北省荆州市松滋市', '3', 9, 'S', NULL, '1', '434200', '421000');
INSERT INTO `sys_region` VALUES ('421100', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄冈市', '湖北省黄冈市', '2', 10, 'H', NULL, '1', '438000', '420000');
INSERT INTO `sys_region` VALUES ('421101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省黄冈市市辖区', '3', 1, 'S', NULL, '1', NULL, '421100');
INSERT INTO `sys_region` VALUES ('421102', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄州区', '湖北省黄冈市黄州区', '3', 2, 'H', NULL, '1', '438000', '421100');
INSERT INTO `sys_region` VALUES ('421121', '2018-01-30 19:30:19', NULL, NULL, NULL, '团风县', '湖北省黄冈市团风县', '3', 3, 'T', NULL, '1', '438800', '421100');
INSERT INTO `sys_region` VALUES ('421122', '2018-01-30 19:30:19', NULL, NULL, NULL, '红安县', '湖北省黄冈市红安县', '3', 4, 'H', NULL, '1', '438401', '421100');
INSERT INTO `sys_region` VALUES ('421123', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗田县', '湖北省黄冈市罗田县', '3', 5, 'L', NULL, '1', '438600', '421100');
INSERT INTO `sys_region` VALUES ('421124', '2018-01-30 19:30:19', NULL, NULL, NULL, '英山县', '湖北省黄冈市英山县', '3', 6, 'Y', NULL, '1', '438700', '421100');
INSERT INTO `sys_region` VALUES ('421125', '2018-01-30 19:30:19', NULL, NULL, NULL, '浠水县', '湖北省黄冈市浠水县', '3', 7, 'Z', NULL, '1', '438200', '421100');
INSERT INTO `sys_region` VALUES ('421126', '2018-01-30 19:30:19', NULL, NULL, NULL, '蕲春县', '湖北省黄冈市蕲春县', '3', 8, 'Z', NULL, '1', '435300', '421100');
INSERT INTO `sys_region` VALUES ('421127', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄梅县', '湖北省黄冈市黄梅县', '3', 9, 'H', NULL, '1', '435500', '421100');
INSERT INTO `sys_region` VALUES ('421181', '2018-01-30 19:30:19', NULL, NULL, NULL, '麻城市', '湖北省黄冈市麻城市', '3', 10, 'M', NULL, '1', '438300', '421100');
INSERT INTO `sys_region` VALUES ('421182', '2018-01-30 19:30:19', NULL, NULL, NULL, '武穴市', '湖北省黄冈市武穴市', '3', 11, 'W', NULL, '1', '435400', '421100');
INSERT INTO `sys_region` VALUES ('421200', '2018-01-30 19:30:19', NULL, NULL, NULL, '咸宁市', '湖北省咸宁市', '2', 11, 'X', NULL, '1', '437000', '420000');
INSERT INTO `sys_region` VALUES ('421201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省咸宁市市辖区', '3', 1, 'S', NULL, '1', NULL, '421200');
INSERT INTO `sys_region` VALUES ('421202', '2018-01-30 19:30:19', NULL, NULL, NULL, '咸安区', '湖北省咸宁市咸安区', '3', 2, 'X', NULL, '1', '437000', '421200');
INSERT INTO `sys_region` VALUES ('421221', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉鱼县', '湖北省咸宁市嘉鱼县', '3', 3, 'J', NULL, '1', '437200', '421200');
INSERT INTO `sys_region` VALUES ('421222', '2018-01-30 19:30:19', NULL, NULL, NULL, '通城县', '湖北省咸宁市通城县', '3', 4, 'T', NULL, '1', '437400', '421200');
INSERT INTO `sys_region` VALUES ('421223', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇阳县', '湖北省咸宁市崇阳县', '3', 5, 'C', NULL, '1', '437500', '421200');
INSERT INTO `sys_region` VALUES ('421224', '2018-01-30 19:30:19', NULL, NULL, NULL, '通山县', '湖北省咸宁市通山县', '3', 6, 'T', NULL, '1', '437600', '421200');
INSERT INTO `sys_region` VALUES ('421281', '2018-01-30 19:30:19', NULL, NULL, NULL, '赤壁市', '湖北省咸宁市赤壁市', '3', 7, 'C', NULL, '1', '437300', '421200');
INSERT INTO `sys_region` VALUES ('421300', '2018-01-30 19:30:19', NULL, NULL, NULL, '随州市', '湖北省随州市', '2', 12, 'S', NULL, '1', '441300', '420000');
INSERT INTO `sys_region` VALUES ('421301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖北省随州市市辖区', '3', 1, 'S', NULL, '1', NULL, '421300');
INSERT INTO `sys_region` VALUES ('421303', '2018-01-30 19:30:19', NULL, NULL, NULL, '曾都区', '湖北省随州市曾都区', '3', 2, 'Z', NULL, '1', '441300', '421300');
INSERT INTO `sys_region` VALUES ('421321', '2018-01-30 19:30:19', NULL, NULL, NULL, '随县', '湖北省随州市随县', '3', 3, 'S', NULL, '1', '441309', '421300');
INSERT INTO `sys_region` VALUES ('421381', '2018-01-30 19:30:19', NULL, NULL, NULL, '广水市', '湖北省随州市广水市', '3', 4, 'G', NULL, '1', '432700', '421300');
INSERT INTO `sys_region` VALUES ('422800', '2018-01-30 19:30:19', NULL, NULL, NULL, '恩施土家族苗族自治州', '湖北省恩施土家族苗族自治州', '2', 13, 'E', NULL, '1', '445000', '420000');
INSERT INTO `sys_region` VALUES ('422801', '2018-01-30 19:30:19', NULL, NULL, NULL, '恩施市', '湖北省恩施土家族苗族自治州恩施市', '3', 1, 'E', NULL, '1', '445000', '422800');
INSERT INTO `sys_region` VALUES ('422802', '2018-01-30 19:30:19', NULL, NULL, NULL, '利川市', '湖北省恩施土家族苗族自治州利川市', '3', 2, 'L', NULL, '1', '445400', '422800');
INSERT INTO `sys_region` VALUES ('422822', '2018-01-30 19:30:19', NULL, NULL, NULL, '建始县', '湖北省恩施土家族苗族自治州建始县', '3', 3, 'J', NULL, '1', '445300', '422800');
INSERT INTO `sys_region` VALUES ('422823', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴东县', '湖北省恩施土家族苗族自治州巴东县', '3', 4, 'B', NULL, '1', '444300', '422800');
INSERT INTO `sys_region` VALUES ('422825', '2018-01-30 19:30:19', NULL, NULL, NULL, '宣恩县', '湖北省恩施土家族苗族自治州宣恩县', '3', 5, 'X', NULL, '1', '445500', '422800');
INSERT INTO `sys_region` VALUES ('422826', '2018-01-30 19:30:19', NULL, NULL, NULL, '咸丰县', '湖北省恩施土家族苗族自治州咸丰县', '3', 6, 'X', NULL, '1', '445600', '422800');
INSERT INTO `sys_region` VALUES ('422827', '2018-01-30 19:30:19', NULL, NULL, NULL, '来凤县', '湖北省恩施土家族苗族自治州来凤县', '3', 7, 'L', NULL, '1', '445700', '422800');
INSERT INTO `sys_region` VALUES ('422828', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹤峰县', '湖北省恩施土家族苗族自治州鹤峰县', '3', 8, 'H', NULL, '1', '445800', '422800');
INSERT INTO `sys_region` VALUES ('429000', '2018-01-30 19:30:19', NULL, NULL, NULL, '省直辖县级行政区划', '湖北省省直辖县级行政区划', '2', 14, 'S', NULL, '1', '', '420000');
INSERT INTO `sys_region` VALUES ('429004', '2018-01-30 19:30:19', NULL, NULL, NULL, '仙桃市', '湖北省省直辖县级行政区划仙桃市', '3', 1, 'X', NULL, '1', '433000', '429000');
INSERT INTO `sys_region` VALUES ('429005', '2018-01-30 19:30:19', NULL, NULL, NULL, '潜江市', '湖北省省直辖县级行政区划潜江市', '3', 2, 'Q', NULL, '1', '433100', '429000');
INSERT INTO `sys_region` VALUES ('429006', '2018-01-30 19:30:19', NULL, NULL, NULL, '天门市', '湖北省省直辖县级行政区划天门市', '3', 3, 'T', NULL, '1', '431700', '429000');
INSERT INTO `sys_region` VALUES ('429021', '2018-01-30 19:30:19', NULL, NULL, NULL, '神农架林区', '湖北省省直辖县级行政区划神农架林区', '3', 4, 'S', NULL, '1', '442400', '429000');
INSERT INTO `sys_region` VALUES ('430000', '2018-01-30 19:30:19', NULL, NULL, NULL, '湖南省', '湖南省', '1', 18, 'H', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('430100', '2018-01-30 19:30:19', NULL, NULL, NULL, '长沙市', '湖南省长沙市', '2', 1, 'C', NULL, '1', '410005', '430000');
INSERT INTO `sys_region` VALUES ('430101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省长沙市市辖区', '3', 1, 'S', NULL, '1', NULL, '430100');
INSERT INTO `sys_region` VALUES ('430102', '2018-01-30 19:30:19', NULL, NULL, NULL, '芙蓉区', '湖南省长沙市芙蓉区', '3', 2, 'Z', NULL, '1', '410011', '430100');
INSERT INTO `sys_region` VALUES ('430103', '2018-01-30 19:30:19', NULL, NULL, NULL, '天心区', '湖南省长沙市天心区', '3', 3, 'T', NULL, '1', '410004', '430100');
INSERT INTO `sys_region` VALUES ('430104', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳麓区', '湖南省长沙市岳麓区', '3', 4, 'Y', NULL, '1', '410013', '430100');
INSERT INTO `sys_region` VALUES ('430105', '2018-01-30 19:30:19', NULL, NULL, NULL, '开福区', '湖南省长沙市开福区', '3', 5, 'K', NULL, '1', '410008', '430100');
INSERT INTO `sys_region` VALUES ('430111', '2018-01-30 19:30:19', NULL, NULL, NULL, '雨花区', '湖南省长沙市雨花区', '3', 6, 'Y', NULL, '1', '410011', '430100');
INSERT INTO `sys_region` VALUES ('430112', '2018-01-30 19:30:19', NULL, NULL, NULL, '望城区', '湖南省长沙市望城区', '3', 7, 'W', NULL, '1', '410200', '430100');
INSERT INTO `sys_region` VALUES ('430121', '2018-01-30 19:30:19', NULL, NULL, NULL, '长沙县', '湖南省长沙市长沙县', '3', 8, 'C', NULL, '1', '410100', '430100');
INSERT INTO `sys_region` VALUES ('430124', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁乡县', '湖南省长沙市宁乡县', '3', 9, 'N', NULL, '1', '410600', '430100');
INSERT INTO `sys_region` VALUES ('430181', '2018-01-30 19:30:19', NULL, NULL, NULL, '浏阳市', '湖南省长沙市浏阳市', '3', 10, 'Z', NULL, '1', '410300', '430100');
INSERT INTO `sys_region` VALUES ('430200', '2018-01-30 19:30:19', NULL, NULL, NULL, '株洲市', '湖南省株洲市', '2', 2, 'Z', NULL, '1', '412000', '430000');
INSERT INTO `sys_region` VALUES ('430201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省株洲市市辖区', '3', 1, 'S', NULL, '1', NULL, '430200');
INSERT INTO `sys_region` VALUES ('430202', '2018-01-30 19:30:19', NULL, NULL, NULL, '荷塘区', '湖南省株洲市荷塘区', '3', 2, 'H', NULL, '1', '412000', '430200');
INSERT INTO `sys_region` VALUES ('430203', '2018-01-30 19:30:19', NULL, NULL, NULL, '芦淞区', '湖南省株洲市芦淞区', '3', 3, 'L', NULL, '1', '412000', '430200');
INSERT INTO `sys_region` VALUES ('430204', '2018-01-30 19:30:19', NULL, NULL, NULL, '石峰区', '湖南省株洲市石峰区', '3', 4, 'S', NULL, '1', '412005', '430200');
INSERT INTO `sys_region` VALUES ('430211', '2018-01-30 19:30:19', NULL, NULL, NULL, '天元区', '湖南省株洲市天元区', '3', 5, 'T', NULL, '1', '412007', '430200');
INSERT INTO `sys_region` VALUES ('430221', '2018-01-30 19:30:19', NULL, NULL, NULL, '株洲县', '湖南省株洲市株洲县', '3', 6, 'Z', NULL, '1', '412100', '430200');
INSERT INTO `sys_region` VALUES ('430223', '2018-01-30 19:30:19', NULL, NULL, NULL, '攸县', '湖南省株洲市攸县', '3', 7, 'Z', NULL, '1', '412300', '430200');
INSERT INTO `sys_region` VALUES ('430224', '2018-01-30 19:30:19', NULL, NULL, NULL, '茶陵县', '湖南省株洲市茶陵县', '3', 8, 'C', NULL, '1', '412400', '430200');
INSERT INTO `sys_region` VALUES ('430225', '2018-01-30 19:30:19', NULL, NULL, NULL, '炎陵县', '湖南省株洲市炎陵县', '3', 9, 'Y', NULL, '1', '412500', '430200');
INSERT INTO `sys_region` VALUES ('430281', '2018-01-30 19:30:19', NULL, NULL, NULL, '醴陵市', '湖南省株洲市醴陵市', '3', 10, 'Z', NULL, '1', '412200', '430200');
INSERT INTO `sys_region` VALUES ('430300', '2018-01-30 19:30:19', NULL, NULL, NULL, '湘潭市', '湖南省湘潭市', '2', 3, 'X', NULL, '1', '411100', '430000');
INSERT INTO `sys_region` VALUES ('430301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省湘潭市市辖区', '3', 1, 'S', NULL, '1', NULL, '430300');
INSERT INTO `sys_region` VALUES ('430302', '2018-01-30 19:30:19', NULL, NULL, NULL, '雨湖区', '湖南省湘潭市雨湖区', '3', 2, 'Y', NULL, '1', '411100', '430300');
INSERT INTO `sys_region` VALUES ('430304', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳塘区', '湖南省湘潭市岳塘区', '3', 3, 'Y', NULL, '1', '411101', '430300');
INSERT INTO `sys_region` VALUES ('430321', '2018-01-30 19:30:19', NULL, NULL, NULL, '湘潭县', '湖南省湘潭市湘潭县', '3', 4, 'X', NULL, '1', '411228', '430300');
INSERT INTO `sys_region` VALUES ('430381', '2018-01-30 19:30:19', NULL, NULL, NULL, '湘乡市', '湖南省湘潭市湘乡市', '3', 5, 'X', NULL, '1', '411400', '430300');
INSERT INTO `sys_region` VALUES ('430382', '2018-01-30 19:30:19', NULL, NULL, NULL, '韶山市', '湖南省湘潭市韶山市', '3', 6, 'S', NULL, '1', '411300', '430300');
INSERT INTO `sys_region` VALUES ('430400', '2018-01-30 19:30:19', NULL, NULL, NULL, '衡阳市', '湖南省衡阳市', '2', 4, 'H', NULL, '1', '421001', '430000');
INSERT INTO `sys_region` VALUES ('430401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省衡阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '430400');
INSERT INTO `sys_region` VALUES ('430405', '2018-01-30 19:30:19', NULL, NULL, NULL, '珠晖区', '湖南省衡阳市珠晖区', '3', 2, 'Z', NULL, '1', '421002', '430400');
INSERT INTO `sys_region` VALUES ('430406', '2018-01-30 19:30:19', NULL, NULL, NULL, '雁峰区', '湖南省衡阳市雁峰区', '3', 3, 'Y', NULL, '1', '421001', '430400');
INSERT INTO `sys_region` VALUES ('430407', '2018-01-30 19:30:19', NULL, NULL, NULL, '石鼓区', '湖南省衡阳市石鼓区', '3', 4, 'S', NULL, '1', '421005', '430400');
INSERT INTO `sys_region` VALUES ('430408', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒸湘区', '湖南省衡阳市蒸湘区', '3', 5, 'Z', NULL, '1', '421001', '430400');
INSERT INTO `sys_region` VALUES ('430412', '2018-01-30 19:30:19', NULL, NULL, NULL, '南岳区', '湖南省衡阳市南岳区', '3', 6, 'N', NULL, '1', '421900', '430400');
INSERT INTO `sys_region` VALUES ('430421', '2018-01-30 19:30:19', NULL, NULL, NULL, '衡阳县', '湖南省衡阳市衡阳县', '3', 7, 'H', NULL, '1', '421200', '430400');
INSERT INTO `sys_region` VALUES ('430422', '2018-01-30 19:30:19', NULL, NULL, NULL, '衡南县', '湖南省衡阳市衡南县', '3', 8, 'H', NULL, '1', '421131', '430400');
INSERT INTO `sys_region` VALUES ('430423', '2018-01-30 19:30:19', NULL, NULL, NULL, '衡山县', '湖南省衡阳市衡山县', '3', 9, 'H', NULL, '1', '421300', '430400');
INSERT INTO `sys_region` VALUES ('430424', '2018-01-30 19:30:19', NULL, NULL, NULL, '衡东县', '湖南省衡阳市衡东县', '3', 10, 'H', NULL, '1', '421400', '430400');
INSERT INTO `sys_region` VALUES ('430426', '2018-01-30 19:30:19', NULL, NULL, NULL, '祁东县', '湖南省衡阳市祁东县', '3', 11, 'Q', NULL, '1', '421600', '430400');
INSERT INTO `sys_region` VALUES ('430472', '2021-06-18 08:30:19', NULL, NULL, NULL, '高新区', '湖南省衡阳市高新区', '3', 14, 'G', NULL, '1', '421099', '430400');
INSERT INTO `sys_region` VALUES ('430481', '2018-01-30 19:30:19', NULL, NULL, NULL, '耒阳市', '湖南省衡阳市耒阳市', '3', 12, 'Z', NULL, '1', '421800', '430400');
INSERT INTO `sys_region` VALUES ('430482', '2018-01-30 19:30:19', NULL, NULL, NULL, '常宁市', '湖南省衡阳市常宁市', '3', 13, 'C', NULL, '1', '421500', '430400');
INSERT INTO `sys_region` VALUES ('430500', '2018-01-30 19:30:19', NULL, NULL, NULL, '邵阳市', '湖南省邵阳市', '2', 5, 'S', NULL, '1', '422000', '430000');
INSERT INTO `sys_region` VALUES ('430501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省邵阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '430500');
INSERT INTO `sys_region` VALUES ('430502', '2018-01-30 19:30:19', NULL, NULL, NULL, '双清区', '湖南省邵阳市双清区', '3', 2, 'S', NULL, '1', '422001', '430500');
INSERT INTO `sys_region` VALUES ('430503', '2018-01-30 19:30:19', NULL, NULL, NULL, '大祥区', '湖南省邵阳市大祥区', '3', 3, 'D', NULL, '1', '422000', '430500');
INSERT INTO `sys_region` VALUES ('430511', '2018-01-30 19:30:19', NULL, NULL, NULL, '北塔区', '湖南省邵阳市北塔区', '3', 4, 'B', NULL, '1', '422007', '430500');
INSERT INTO `sys_region` VALUES ('430521', '2018-01-30 19:30:19', NULL, NULL, NULL, '邵东县', '湖南省邵阳市邵东县', '3', 5, 'S', NULL, '1', '422800', '430500');
INSERT INTO `sys_region` VALUES ('430522', '2018-01-30 19:30:19', NULL, NULL, NULL, '新邵县', '湖南省邵阳市新邵县', '3', 6, 'X', NULL, '1', '422900', '430500');
INSERT INTO `sys_region` VALUES ('430523', '2018-01-30 19:30:19', NULL, NULL, NULL, '邵阳县', '湖南省邵阳市邵阳县', '3', 7, 'S', NULL, '1', '422100', '430500');
INSERT INTO `sys_region` VALUES ('430524', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆回县', '湖南省邵阳市隆回县', '3', 8, 'L', NULL, '1', '422200', '430500');
INSERT INTO `sys_region` VALUES ('430525', '2018-01-30 19:30:19', NULL, NULL, NULL, '洞口县', '湖南省邵阳市洞口县', '3', 9, 'D', NULL, '1', '422300', '430500');
INSERT INTO `sys_region` VALUES ('430527', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥宁县', '湖南省邵阳市绥宁县', '3', 10, 'S', NULL, '1', '422600', '430500');
INSERT INTO `sys_region` VALUES ('430528', '2018-01-30 19:30:19', NULL, NULL, NULL, '新宁县', '湖南省邵阳市新宁县', '3', 11, 'X', NULL, '1', '422700', '430500');
INSERT INTO `sys_region` VALUES ('430529', '2018-01-30 19:30:19', NULL, NULL, NULL, '城步苗族自治县', '湖南省邵阳市城步苗族自治县', '3', 12, 'C', NULL, '1', '422500', '430500');
INSERT INTO `sys_region` VALUES ('430581', '2018-01-30 19:30:19', NULL, NULL, NULL, '武冈市', '湖南省邵阳市武冈市', '3', 13, 'W', NULL, '1', '422400', '430500');
INSERT INTO `sys_region` VALUES ('430600', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳阳市', '湖南省岳阳市', '2', 6, 'Y', NULL, '1', '414000', '430000');
INSERT INTO `sys_region` VALUES ('430601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省岳阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '430600');
INSERT INTO `sys_region` VALUES ('430602', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳阳楼区', '湖南省岳阳市岳阳楼区', '3', 2, 'Y', NULL, '1', '414000', '430600');
INSERT INTO `sys_region` VALUES ('430603', '2018-01-30 19:30:19', NULL, NULL, NULL, '云溪区', '湖南省岳阳市云溪区', '3', 3, 'Y', NULL, '1', '414009', '430600');
INSERT INTO `sys_region` VALUES ('430611', '2018-01-30 19:30:19', NULL, NULL, NULL, '君山区', '湖南省岳阳市君山区', '3', 4, 'J', NULL, '1', '414005', '430600');
INSERT INTO `sys_region` VALUES ('430621', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳阳县', '湖南省岳阳市岳阳县', '3', 5, 'Y', NULL, '1', '414100', '430600');
INSERT INTO `sys_region` VALUES ('430623', '2018-01-30 19:30:19', NULL, NULL, NULL, '华容县', '湖南省岳阳市华容县', '3', 6, 'H', NULL, '1', '414200', '430600');
INSERT INTO `sys_region` VALUES ('430624', '2018-01-30 19:30:19', NULL, NULL, NULL, '湘阴县', '湖南省岳阳市湘阴县', '3', 7, 'X', NULL, '1', '414600', '430600');
INSERT INTO `sys_region` VALUES ('430626', '2018-01-30 19:30:19', NULL, NULL, NULL, '平江县', '湖南省岳阳市平江县', '3', 8, 'P', NULL, '1', '414500', '430600');
INSERT INTO `sys_region` VALUES ('430681', '2018-01-30 19:30:19', NULL, NULL, NULL, '汨罗市', '湖南省岳阳市汨罗市', '3', 9, 'Z', NULL, '1', '414400', '430600');
INSERT INTO `sys_region` VALUES ('430682', '2018-01-30 19:30:19', NULL, NULL, NULL, '临湘市', '湖南省岳阳市临湘市', '3', 10, 'L', NULL, '1', '414300', '430600');
INSERT INTO `sys_region` VALUES ('430700', '2018-01-30 19:30:19', NULL, NULL, NULL, '常德市', '湖南省常德市', '2', 7, 'C', NULL, '1', '415000', '430000');
INSERT INTO `sys_region` VALUES ('430701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省常德市市辖区', '3', 1, 'S', NULL, '1', NULL, '430700');
INSERT INTO `sys_region` VALUES ('430702', '2018-01-30 19:30:19', NULL, NULL, NULL, '武陵区', '湖南省常德市武陵区', '3', 2, 'W', NULL, '1', '415000', '430700');
INSERT INTO `sys_region` VALUES ('430703', '2018-01-30 19:30:19', NULL, NULL, NULL, '鼎城区', '湖南省常德市鼎城区', '3', 3, 'D', NULL, '1', '415101', '430700');
INSERT INTO `sys_region` VALUES ('430721', '2018-01-30 19:30:19', NULL, NULL, NULL, '安乡县', '湖南省常德市安乡县', '3', 4, 'A', NULL, '1', '415600', '430700');
INSERT INTO `sys_region` VALUES ('430722', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉寿县', '湖南省常德市汉寿县', '3', 5, 'H', NULL, '1', '415900', '430700');
INSERT INTO `sys_region` VALUES ('430723', '2018-01-30 19:30:19', NULL, NULL, NULL, '澧县', '湖南省常德市澧县', '3', 6, 'Z', NULL, '1', '415500', '430700');
INSERT INTO `sys_region` VALUES ('430724', '2018-01-30 19:30:19', NULL, NULL, NULL, '临澧县', '湖南省常德市临澧县', '3', 7, 'L', NULL, '1', '415200', '430700');
INSERT INTO `sys_region` VALUES ('430725', '2018-01-30 19:30:19', NULL, NULL, NULL, '桃源县', '湖南省常德市桃源县', '3', 8, 'T', NULL, '1', '415700', '430700');
INSERT INTO `sys_region` VALUES ('430726', '2018-01-30 19:30:19', NULL, NULL, NULL, '石门县', '湖南省常德市石门县', '3', 9, 'S', NULL, '1', '415300', '430700');
INSERT INTO `sys_region` VALUES ('430781', '2018-01-30 19:30:19', NULL, NULL, NULL, '津市市', '湖南省常德市津市市', '3', 10, 'J', NULL, '1', '415400', '430700');
INSERT INTO `sys_region` VALUES ('430800', '2018-01-30 19:30:19', NULL, NULL, NULL, '张家界市', '湖南省张家界市', '2', 8, 'Z', NULL, '1', '427000', '430000');
INSERT INTO `sys_region` VALUES ('430801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省张家界市市辖区', '3', 1, 'S', NULL, '1', NULL, '430800');
INSERT INTO `sys_region` VALUES ('430802', '2018-01-30 19:30:19', NULL, NULL, NULL, '永定区', '湖南省张家界市永定区', '3', 2, 'Y', NULL, '1', '427000', '430800');
INSERT INTO `sys_region` VALUES ('430811', '2018-01-30 19:30:19', NULL, NULL, NULL, '武陵源区', '湖南省张家界市武陵源区', '3', 3, 'W', NULL, '1', '427400', '430800');
INSERT INTO `sys_region` VALUES ('430821', '2018-01-30 19:30:19', NULL, NULL, NULL, '慈利县', '湖南省张家界市慈利县', '3', 4, 'C', NULL, '1', '427200', '430800');
INSERT INTO `sys_region` VALUES ('430822', '2018-01-30 19:30:19', NULL, NULL, NULL, '桑植县', '湖南省张家界市桑植县', '3', 5, 'S', NULL, '1', '427100', '430800');
INSERT INTO `sys_region` VALUES ('430900', '2018-01-30 19:30:19', NULL, NULL, NULL, '益阳市', '湖南省益阳市', '2', 9, 'Y', NULL, '1', '413000', '430000');
INSERT INTO `sys_region` VALUES ('430901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省益阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '430900');
INSERT INTO `sys_region` VALUES ('430902', '2018-01-30 19:30:19', NULL, NULL, NULL, '资阳区', '湖南省益阳市资阳区', '3', 2, 'Z', NULL, '1', '413001', '430900');
INSERT INTO `sys_region` VALUES ('430903', '2018-01-30 19:30:19', NULL, NULL, NULL, '赫山区', '湖南省益阳市赫山区', '3', 3, 'H', NULL, '1', '413002', '430900');
INSERT INTO `sys_region` VALUES ('430921', '2018-01-30 19:30:19', NULL, NULL, NULL, '南县', '湖南省益阳市南县', '3', 4, 'N', NULL, '1', '413200', '430900');
INSERT INTO `sys_region` VALUES ('430922', '2018-01-30 19:30:19', NULL, NULL, NULL, '桃江县', '湖南省益阳市桃江县', '3', 5, 'T', NULL, '1', '413400', '430900');
INSERT INTO `sys_region` VALUES ('430923', '2018-01-30 19:30:19', NULL, NULL, NULL, '安化县', '湖南省益阳市安化县', '3', 6, 'A', NULL, '1', '413500', '430900');
INSERT INTO `sys_region` VALUES ('430981', '2018-01-30 19:30:19', NULL, NULL, NULL, '沅江市', '湖南省益阳市沅江市', '3', 7, 'Z', NULL, '1', '413100', '430900');
INSERT INTO `sys_region` VALUES ('431000', '2018-01-30 19:30:19', NULL, NULL, NULL, '郴州市', '湖南省郴州市', '2', 10, 'C', NULL, '1', '423000', '430000');
INSERT INTO `sys_region` VALUES ('431001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省郴州市市辖区', '3', 1, 'S', NULL, '1', NULL, '431000');
INSERT INTO `sys_region` VALUES ('431002', '2018-01-30 19:30:19', NULL, NULL, NULL, '北湖区', '湖南省郴州市北湖区', '3', 2, 'B', NULL, '1', '423000', '431000');
INSERT INTO `sys_region` VALUES ('431003', '2018-01-30 19:30:19', NULL, NULL, NULL, '苏仙区', '湖南省郴州市苏仙区', '3', 3, 'S', NULL, '1', '423000', '431000');
INSERT INTO `sys_region` VALUES ('431021', '2018-01-30 19:30:19', NULL, NULL, NULL, '桂阳县', '湖南省郴州市桂阳县', '3', 4, 'G', NULL, '1', '424400', '431000');
INSERT INTO `sys_region` VALUES ('431022', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜章县', '湖南省郴州市宜章县', '3', 5, 'Y', NULL, '1', '424200', '431000');
INSERT INTO `sys_region` VALUES ('431023', '2018-01-30 19:30:19', NULL, NULL, NULL, '永兴县', '湖南省郴州市永兴县', '3', 6, 'Y', NULL, '1', '423300', '431000');
INSERT INTO `sys_region` VALUES ('431024', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉禾县', '湖南省郴州市嘉禾县', '3', 7, 'J', NULL, '1', '424500', '431000');
INSERT INTO `sys_region` VALUES ('431025', '2018-01-30 19:30:19', NULL, NULL, NULL, '临武县', '湖南省郴州市临武县', '3', 8, 'L', NULL, '1', '424300', '431000');
INSERT INTO `sys_region` VALUES ('431026', '2018-01-30 19:30:19', NULL, NULL, NULL, '汝城县', '湖南省郴州市汝城县', '3', 9, 'R', NULL, '1', '424100', '431000');
INSERT INTO `sys_region` VALUES ('431027', '2018-01-30 19:30:19', NULL, NULL, NULL, '桂东县', '湖南省郴州市桂东县', '3', 10, 'G', NULL, '1', '423500', '431000');
INSERT INTO `sys_region` VALUES ('431028', '2018-01-30 19:30:19', NULL, NULL, NULL, '安仁县', '湖南省郴州市安仁县', '3', 11, 'A', NULL, '1', '423600', '431000');
INSERT INTO `sys_region` VALUES ('431081', '2018-01-30 19:30:19', NULL, NULL, NULL, '资兴市', '湖南省郴州市资兴市', '3', 12, 'Z', NULL, '1', '423400', '431000');
INSERT INTO `sys_region` VALUES ('431100', '2018-01-30 19:30:19', NULL, NULL, NULL, '永州市', '湖南省永州市', '2', 11, 'Y', NULL, '1', '425000', '430000');
INSERT INTO `sys_region` VALUES ('431101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省永州市市辖区', '3', 1, 'S', NULL, '1', NULL, '431100');
INSERT INTO `sys_region` VALUES ('431102', '2018-01-30 19:30:19', NULL, NULL, NULL, '零陵区', '湖南省永州市零陵区', '3', 2, 'L', NULL, '1', '425100', '431100');
INSERT INTO `sys_region` VALUES ('431103', '2018-01-30 19:30:19', NULL, NULL, NULL, '冷水滩区', '湖南省永州市冷水滩区', '3', 3, 'L', NULL, '1', '425100', '431100');
INSERT INTO `sys_region` VALUES ('431121', '2018-01-30 19:30:19', NULL, NULL, NULL, '祁阳县', '湖南省永州市祁阳县', '3', 4, 'Q', NULL, '1', '426100', '431100');
INSERT INTO `sys_region` VALUES ('431122', '2018-01-30 19:30:19', NULL, NULL, NULL, '东安县', '湖南省永州市东安县', '3', 5, 'D', NULL, '1', '425900', '431100');
INSERT INTO `sys_region` VALUES ('431123', '2018-01-30 19:30:19', NULL, NULL, NULL, '双牌县', '湖南省永州市双牌县', '3', 6, 'S', NULL, '1', '425200', '431100');
INSERT INTO `sys_region` VALUES ('431124', '2018-01-30 19:30:19', NULL, NULL, NULL, '道县', '湖南省永州市道县', '3', 7, 'D', NULL, '1', '425300', '431100');
INSERT INTO `sys_region` VALUES ('431125', '2018-01-30 19:30:19', NULL, NULL, NULL, '江永县', '湖南省永州市江永县', '3', 8, 'J', NULL, '1', '425400', '431100');
INSERT INTO `sys_region` VALUES ('431126', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁远县', '湖南省永州市宁远县', '3', 9, 'N', NULL, '1', '425600', '431100');
INSERT INTO `sys_region` VALUES ('431127', '2018-01-30 19:30:19', NULL, NULL, NULL, '蓝山县', '湖南省永州市蓝山县', '3', 10, 'L', NULL, '1', '425800', '431100');
INSERT INTO `sys_region` VALUES ('431128', '2018-01-30 19:30:19', NULL, NULL, NULL, '新田县', '湖南省永州市新田县', '3', 11, 'X', NULL, '1', '425700', '431100');
INSERT INTO `sys_region` VALUES ('431129', '2018-01-30 19:30:19', NULL, NULL, NULL, '江华瑶族自治县', '湖南省永州市江华瑶族自治县', '3', 12, 'J', NULL, '1', '425500', '431100');
INSERT INTO `sys_region` VALUES ('431200', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀化市', '湖南省怀化市', '2', 12, 'H', NULL, '1', '418000', '430000');
INSERT INTO `sys_region` VALUES ('431201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省怀化市市辖区', '3', 1, 'S', NULL, '1', NULL, '431200');
INSERT INTO `sys_region` VALUES ('431202', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹤城区', '湖南省怀化市鹤城区', '3', 2, 'H', NULL, '1', '418000', '431200');
INSERT INTO `sys_region` VALUES ('431221', '2018-01-30 19:30:19', NULL, NULL, NULL, '中方县', '湖南省怀化市中方县', '3', 3, 'Z', NULL, '1', '418005', '431200');
INSERT INTO `sys_region` VALUES ('431222', '2018-01-30 19:30:19', NULL, NULL, NULL, '沅陵县', '湖南省怀化市沅陵县', '3', 4, 'Z', NULL, '1', '419600', '431200');
INSERT INTO `sys_region` VALUES ('431223', '2018-01-30 19:30:19', NULL, NULL, NULL, '辰溪县', '湖南省怀化市辰溪县', '3', 5, 'C', NULL, '1', '419500', '431200');
INSERT INTO `sys_region` VALUES ('431224', '2018-01-30 19:30:19', NULL, NULL, NULL, '溆浦县', '湖南省怀化市溆浦县', '3', 6, 'Z', NULL, '1', '419300', '431200');
INSERT INTO `sys_region` VALUES ('431225', '2018-01-30 19:30:19', NULL, NULL, NULL, '会同县', '湖南省怀化市会同县', '3', 7, 'H', NULL, '1', '418300', '431200');
INSERT INTO `sys_region` VALUES ('431226', '2018-01-30 19:30:19', NULL, NULL, NULL, '麻阳苗族自治县', '湖南省怀化市麻阳苗族自治县', '3', 8, 'M', NULL, '1', '419400', '431200');
INSERT INTO `sys_region` VALUES ('431227', '2018-01-30 19:30:19', NULL, NULL, NULL, '新晃侗族自治县', '湖南省怀化市新晃侗族自治县', '3', 9, 'X', NULL, '1', '419200', '431200');
INSERT INTO `sys_region` VALUES ('431228', '2018-01-30 19:30:19', NULL, NULL, NULL, '芷江侗族自治县', '湖南省怀化市芷江侗族自治县', '3', 10, 'Z', NULL, '1', '419100', '431200');
INSERT INTO `sys_region` VALUES ('431229', '2018-01-30 19:30:19', NULL, NULL, NULL, '靖州苗族侗族自治县', '湖南省怀化市靖州苗族侗族自治县', '3', 11, 'J', NULL, '1', '418400', '431200');
INSERT INTO `sys_region` VALUES ('431230', '2018-01-30 19:30:19', NULL, NULL, NULL, '通道侗族自治县', '湖南省怀化市通道侗族自治县', '3', 12, 'T', NULL, '1', '418500', '431200');
INSERT INTO `sys_region` VALUES ('431281', '2018-01-30 19:30:19', NULL, NULL, NULL, '洪江市', '湖南省怀化市洪江市', '3', 13, 'H', NULL, '1', '418100', '431200');
INSERT INTO `sys_region` VALUES ('431300', '2018-01-30 19:30:19', NULL, NULL, NULL, '娄底市', '湖南省娄底市', '2', 13, 'L', NULL, '1', '417000', '430000');
INSERT INTO `sys_region` VALUES ('431301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '湖南省娄底市市辖区', '3', 1, 'S', NULL, '1', NULL, '431300');
INSERT INTO `sys_region` VALUES ('431302', '2018-01-30 19:30:19', NULL, NULL, NULL, '娄星区', '湖南省娄底市娄星区', '3', 2, 'L', NULL, '1', '417000', '431300');
INSERT INTO `sys_region` VALUES ('431321', '2018-01-30 19:30:19', NULL, NULL, NULL, '双峰县', '湖南省娄底市双峰县', '3', 3, 'S', NULL, '1', '417700', '431300');
INSERT INTO `sys_region` VALUES ('431322', '2018-01-30 19:30:19', NULL, NULL, NULL, '新化县', '湖南省娄底市新化县', '3', 4, 'X', NULL, '1', '417600', '431300');
INSERT INTO `sys_region` VALUES ('431381', '2018-01-30 19:30:19', NULL, NULL, NULL, '冷水江市', '湖南省娄底市冷水江市', '3', 5, 'L', NULL, '1', '417500', '431300');
INSERT INTO `sys_region` VALUES ('431382', '2018-01-30 19:30:19', NULL, NULL, NULL, '涟源市', '湖南省娄底市涟源市', '3', 6, 'L', NULL, '1', '417100', '431300');
INSERT INTO `sys_region` VALUES ('433100', '2018-01-30 19:30:19', NULL, NULL, NULL, '湘西土家族苗族自治州', '湖南省湘西土家族苗族自治州', '2', 14, 'X', NULL, '1', '416000', '430000');
INSERT INTO `sys_region` VALUES ('433101', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉首市', '湖南省湘西土家族苗族自治州吉首市', '3', 1, 'J', NULL, '1', '416000', '433100');
INSERT INTO `sys_region` VALUES ('433122', '2018-01-30 19:30:19', NULL, NULL, NULL, '泸溪县', '湖南省湘西土家族苗族自治州泸溪县', '3', 2, 'Z', NULL, '1', '416100', '433100');
INSERT INTO `sys_region` VALUES ('433123', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤凰县', '湖南省湘西土家族苗族自治州凤凰县', '3', 3, 'F', NULL, '1', '416200', '433100');
INSERT INTO `sys_region` VALUES ('433124', '2018-01-30 19:30:19', NULL, NULL, NULL, '花垣县', '湖南省湘西土家族苗族自治州花垣县', '3', 4, 'H', NULL, '1', '416400', '433100');
INSERT INTO `sys_region` VALUES ('433125', '2018-01-30 19:30:19', NULL, NULL, NULL, '保靖县', '湖南省湘西土家族苗族自治州保靖县', '3', 5, 'B', NULL, '1', '416500', '433100');
INSERT INTO `sys_region` VALUES ('433126', '2018-01-30 19:30:19', NULL, NULL, NULL, '古丈县', '湖南省湘西土家族苗族自治州古丈县', '3', 6, 'G', NULL, '1', '416300', '433100');
INSERT INTO `sys_region` VALUES ('433127', '2018-01-30 19:30:19', NULL, NULL, NULL, '永顺县', '湖南省湘西土家族苗族自治州永顺县', '3', 7, 'Y', NULL, '1', '416700', '433100');
INSERT INTO `sys_region` VALUES ('433130', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙山县', '湖南省湘西土家族苗族自治州龙山县', '3', 8, 'L', NULL, '1', '416800', '433100');
INSERT INTO `sys_region` VALUES ('440000', '2018-01-30 19:30:19', NULL, NULL, NULL, '广东省', '广东省', '1', 19, 'G', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('440100', '2018-01-30 19:30:19', NULL, NULL, NULL, '广州市', '广东省广州市', '2', 1, 'G', NULL, '1', '510032', '440000');
INSERT INTO `sys_region` VALUES ('440101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省广州市市辖区', '3', 1, 'S', NULL, '1', NULL, '440100');
INSERT INTO `sys_region` VALUES ('440103', '2018-01-30 19:30:19', NULL, NULL, NULL, '荔湾区', '广东省广州市荔湾区', '3', 2, 'L', NULL, '1', '510170', '440100');
INSERT INTO `sys_region` VALUES ('440104', '2018-01-30 19:30:19', NULL, NULL, NULL, '越秀区', '广东省广州市越秀区', '3', 3, 'Y', NULL, '1', '510030', '440100');
INSERT INTO `sys_region` VALUES ('440105', '2018-01-30 19:30:19', NULL, NULL, NULL, '海珠区', '广东省广州市海珠区', '3', 4, 'H', NULL, '1', '510300', '440100');
INSERT INTO `sys_region` VALUES ('440106', '2018-01-30 19:30:19', NULL, NULL, NULL, '天河区', '广东省广州市天河区', '3', 5, 'T', NULL, '1', '510665', '440100');
INSERT INTO `sys_region` VALUES ('440111', '2018-01-30 19:30:19', NULL, NULL, NULL, '白云区', '广东省广州市白云区', '3', 6, 'B', NULL, '1', '510405', '440100');
INSERT INTO `sys_region` VALUES ('440112', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄埔区', '广东省广州市黄埔区', '3', 7, 'H', NULL, '1', '510700', '440100');
INSERT INTO `sys_region` VALUES ('440113', '2018-01-30 19:30:19', NULL, NULL, NULL, '番禺区', '广东省广州市番禺区', '3', 8, 'F', NULL, '1', '511400', '440100');
INSERT INTO `sys_region` VALUES ('440114', '2018-01-30 19:30:19', NULL, NULL, NULL, '花都区', '广东省广州市花都区', '3', 9, 'H', NULL, '1', '510800', '440100');
INSERT INTO `sys_region` VALUES ('440115', '2018-01-30 19:30:19', NULL, NULL, NULL, '南沙区', '广东省广州市南沙区', '3', 10, 'N', NULL, '1', '511458', '440100');
INSERT INTO `sys_region` VALUES ('440117', '2018-01-30 19:30:19', NULL, NULL, NULL, '从化区', '广东省广州市从化区', '3', 11, 'C', NULL, '1', '510900', '440100');
INSERT INTO `sys_region` VALUES ('440118', '2018-01-30 19:30:19', NULL, NULL, NULL, '增城区', '广东省广州市增城区', '3', 12, 'Z', NULL, '1', '511300', '440100');
INSERT INTO `sys_region` VALUES ('440200', '2018-01-30 19:30:19', NULL, NULL, NULL, '韶关市', '广东省韶关市', '2', 2, 'S', NULL, '1', '512002', '440000');
INSERT INTO `sys_region` VALUES ('440201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省韶关市市辖区', '3', 1, 'S', NULL, '1', NULL, '440200');
INSERT INTO `sys_region` VALUES ('440203', '2018-01-30 19:30:19', NULL, NULL, NULL, '武江区', '广东省韶关市武江区', '3', 2, 'W', NULL, '1', '512026', '440200');
INSERT INTO `sys_region` VALUES ('440204', '2018-01-30 19:30:19', NULL, NULL, NULL, '浈江区', '广东省韶关市浈江区', '3', 3, 'Z', NULL, '1', '512023', '440200');
INSERT INTO `sys_region` VALUES ('440205', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲江区', '广东省韶关市曲江区', '3', 4, 'Q', NULL, '1', '512101', '440200');
INSERT INTO `sys_region` VALUES ('440222', '2018-01-30 19:30:19', NULL, NULL, NULL, '始兴县', '广东省韶关市始兴县', '3', 5, 'S', NULL, '1', '512500', '440200');
INSERT INTO `sys_region` VALUES ('440224', '2018-01-30 19:30:19', NULL, NULL, NULL, '仁化县', '广东省韶关市仁化县', '3', 6, 'R', NULL, '1', '512300', '440200');
INSERT INTO `sys_region` VALUES ('440229', '2018-01-30 19:30:19', NULL, NULL, NULL, '翁源县', '广东省韶关市翁源县', '3', 7, 'W', NULL, '1', '512600', '440200');
INSERT INTO `sys_region` VALUES ('440232', '2018-01-30 19:30:19', NULL, NULL, NULL, '乳源瑶族自治县', '广东省韶关市乳源瑶族自治县', '3', 8, 'R', NULL, '1', '512700', '440200');
INSERT INTO `sys_region` VALUES ('440233', '2018-01-30 19:30:19', NULL, NULL, NULL, '新丰县', '广东省韶关市新丰县', '3', 9, 'X', NULL, '1', '511100', '440200');
INSERT INTO `sys_region` VALUES ('440281', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐昌市', '广东省韶关市乐昌市', '3', 10, 'L', NULL, '1', '512200', '440200');
INSERT INTO `sys_region` VALUES ('440282', '2018-01-30 19:30:19', NULL, NULL, NULL, '南雄市', '广东省韶关市南雄市', '3', 11, 'N', NULL, '1', '512400', '440200');
INSERT INTO `sys_region` VALUES ('440300', '2018-01-30 19:30:19', NULL, NULL, NULL, '深圳市', '广东省深圳市', '2', 3, 'S', NULL, '1', '518035', '440000');
INSERT INTO `sys_region` VALUES ('440301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省深圳市市辖区', '3', 1, 'S', NULL, '1', NULL, '440300');
INSERT INTO `sys_region` VALUES ('440303', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗湖区', '广东省深圳市罗湖区', '3', 2, 'L', NULL, '1', '518021', '440300');
INSERT INTO `sys_region` VALUES ('440304', '2018-01-30 19:30:19', NULL, NULL, NULL, '福田区', '广东省深圳市福田区', '3', 3, 'F', NULL, '1', '518048', '440300');
INSERT INTO `sys_region` VALUES ('440305', '2018-01-30 19:30:19', NULL, NULL, NULL, '南山区', '广东省深圳市南山区', '3', 4, 'N', NULL, '1', '518051', '440300');
INSERT INTO `sys_region` VALUES ('440306', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝安区', '广东省深圳市宝安区', '3', 5, 'B', NULL, '1', '518101', '440300');
INSERT INTO `sys_region` VALUES ('440307', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙岗区', '广东省深圳市龙岗区', '3', 6, 'L', NULL, '1', '518172', '440300');
INSERT INTO `sys_region` VALUES ('440308', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐田区', '广东省深圳市盐田区', '3', 7, 'Y', NULL, '1', '518081', '440300');
INSERT INTO `sys_region` VALUES ('440400', '2018-01-30 19:30:19', NULL, NULL, NULL, '珠海市', '广东省珠海市', '2', 4, 'Z', NULL, '1', '519000', '440000');
INSERT INTO `sys_region` VALUES ('440401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省珠海市市辖区', '3', 1, 'S', NULL, '1', NULL, '440400');
INSERT INTO `sys_region` VALUES ('440402', '2018-01-30 19:30:19', NULL, NULL, NULL, '香洲区', '广东省珠海市香洲区', '3', 2, 'X', NULL, '1', '519000', '440400');
INSERT INTO `sys_region` VALUES ('440403', '2018-01-30 19:30:19', NULL, NULL, NULL, '斗门区', '广东省珠海市斗门区', '3', 3, 'D', NULL, '1', '519110', '440400');
INSERT INTO `sys_region` VALUES ('440404', '2018-01-30 19:30:19', NULL, NULL, NULL, '金湾区', '广东省珠海市金湾区', '3', 4, 'J', NULL, '1', '519040', '440400');
INSERT INTO `sys_region` VALUES ('440500', '2018-01-30 19:30:19', NULL, NULL, NULL, '汕头市', '广东省汕头市', '2', 5, 'S', NULL, '1', '515041', '440000');
INSERT INTO `sys_region` VALUES ('440501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省汕头市市辖区', '3', 1, 'S', NULL, '1', NULL, '440500');
INSERT INTO `sys_region` VALUES ('440507', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙湖区', '广东省汕头市龙湖区', '3', 2, 'L', NULL, '1', '515041', '440500');
INSERT INTO `sys_region` VALUES ('440511', '2018-01-30 19:30:19', NULL, NULL, NULL, '金平区', '广东省汕头市金平区', '3', 3, 'J', NULL, '1', '515041', '440500');
INSERT INTO `sys_region` VALUES ('440512', '2018-01-30 19:30:19', NULL, NULL, NULL, '濠江区', '广东省汕头市濠江区', '3', 4, 'Z', NULL, '1', '515071', '440500');
INSERT INTO `sys_region` VALUES ('440513', '2018-01-30 19:30:19', NULL, NULL, NULL, '潮阳区', '广东省汕头市潮阳区', '3', 5, 'C', NULL, '1', '515100', '440500');
INSERT INTO `sys_region` VALUES ('440514', '2018-01-30 19:30:19', NULL, NULL, NULL, '潮南区', '广东省汕头市潮南区', '3', 6, 'C', NULL, '1', '515144', '440500');
INSERT INTO `sys_region` VALUES ('440515', '2018-01-30 19:30:19', NULL, NULL, NULL, '澄海区', '广东省汕头市澄海区', '3', 7, 'C', NULL, '1', '515800', '440500');
INSERT INTO `sys_region` VALUES ('440523', '2018-01-30 19:30:19', NULL, NULL, NULL, '南澳县', '广东省汕头市南澳县', '3', 8, 'N', NULL, '1', '515900', '440500');
INSERT INTO `sys_region` VALUES ('440600', '2018-01-30 19:30:19', NULL, NULL, NULL, '佛山市', '广东省佛山市', '2', 6, 'F', NULL, '1', '528000', '440000');
INSERT INTO `sys_region` VALUES ('440601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省佛山市市辖区', '3', 1, 'S', NULL, '1', NULL, '440600');
INSERT INTO `sys_region` VALUES ('440604', '2018-01-30 19:30:19', NULL, NULL, NULL, '禅城区', '广东省佛山市禅城区', '3', 2, 'Z', NULL, '1', '528000', '440600');
INSERT INTO `sys_region` VALUES ('440605', '2018-01-30 19:30:19', NULL, NULL, NULL, '南海区', '广东省佛山市南海区', '3', 3, 'N', NULL, '1', '528251', '440600');
INSERT INTO `sys_region` VALUES ('440606', '2018-01-30 19:30:19', NULL, NULL, NULL, '顺德区', '广东省佛山市顺德区', '3', 4, 'S', NULL, '1', '528300', '440600');
INSERT INTO `sys_region` VALUES ('440607', '2018-01-30 19:30:19', NULL, NULL, NULL, '三水区', '广东省佛山市三水区', '3', 5, 'S', NULL, '1', '528133', '440600');
INSERT INTO `sys_region` VALUES ('440608', '2018-01-30 19:30:19', NULL, NULL, NULL, '高明区', '广东省佛山市高明区', '3', 6, 'G', NULL, '1', '528500', '440600');
INSERT INTO `sys_region` VALUES ('440700', '2018-01-30 19:30:19', NULL, NULL, NULL, '江门市', '广东省江门市', '2', 7, 'J', NULL, '1', '529000', '440000');
INSERT INTO `sys_region` VALUES ('440701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省江门市市辖区', '3', 1, 'S', NULL, '1', NULL, '440700');
INSERT INTO `sys_region` VALUES ('440703', '2018-01-30 19:30:19', NULL, NULL, NULL, '蓬江区', '广东省江门市蓬江区', '3', 2, 'P', NULL, '1', '529000', '440700');
INSERT INTO `sys_region` VALUES ('440704', '2018-01-30 19:30:19', NULL, NULL, NULL, '江海区', '广东省江门市江海区', '3', 3, 'J', NULL, '1', '529040', '440700');
INSERT INTO `sys_region` VALUES ('440705', '2018-01-30 19:30:19', NULL, NULL, NULL, '新会区', '广东省江门市新会区', '3', 4, 'X', NULL, '1', '529100', '440700');
INSERT INTO `sys_region` VALUES ('440781', '2018-01-30 19:30:19', NULL, NULL, NULL, '台山市', '广东省江门市台山市', '3', 5, 'T', NULL, '1', '529200', '440700');
INSERT INTO `sys_region` VALUES ('440783', '2018-01-30 19:30:19', NULL, NULL, NULL, '开平市', '广东省江门市开平市', '3', 6, 'K', NULL, '1', '529337', '440700');
INSERT INTO `sys_region` VALUES ('440784', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹤山市', '广东省江门市鹤山市', '3', 7, 'H', NULL, '1', '529700', '440700');
INSERT INTO `sys_region` VALUES ('440785', '2018-01-30 19:30:19', NULL, NULL, NULL, '恩平市', '广东省江门市恩平市', '3', 8, 'E', NULL, '1', '529400', '440700');
INSERT INTO `sys_region` VALUES ('440800', '2018-01-30 19:30:19', NULL, NULL, NULL, '湛江市', '广东省湛江市', '2', 8, 'Z', NULL, '1', '524047', '440000');
INSERT INTO `sys_region` VALUES ('440801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省湛江市市辖区', '3', 1, 'S', NULL, '1', NULL, '440800');
INSERT INTO `sys_region` VALUES ('440802', '2018-01-30 19:30:19', NULL, NULL, NULL, '赤坎区', '广东省湛江市赤坎区', '3', 2, 'C', NULL, '1', '524033', '440800');
INSERT INTO `sys_region` VALUES ('440803', '2018-01-30 19:30:19', NULL, NULL, NULL, '霞山区', '广东省湛江市霞山区', '3', 3, 'X', NULL, '1', '524011', '440800');
INSERT INTO `sys_region` VALUES ('440804', '2018-01-30 19:30:19', NULL, NULL, NULL, '坡头区', '广东省湛江市坡头区', '3', 4, 'P', NULL, '1', '524057', '440800');
INSERT INTO `sys_region` VALUES ('440811', '2018-01-30 19:30:19', NULL, NULL, NULL, '麻章区', '广东省湛江市麻章区', '3', 5, 'M', NULL, '1', '524094', '440800');
INSERT INTO `sys_region` VALUES ('440823', '2018-01-30 19:30:19', NULL, NULL, NULL, '遂溪县', '广东省湛江市遂溪县', '3', 6, 'S', NULL, '1', '524300', '440800');
INSERT INTO `sys_region` VALUES ('440825', '2018-01-30 19:30:19', NULL, NULL, NULL, '徐闻县', '广东省湛江市徐闻县', '3', 7, 'X', NULL, '1', '524100', '440800');
INSERT INTO `sys_region` VALUES ('440881', '2018-01-30 19:30:19', NULL, NULL, NULL, '廉江市', '广东省湛江市廉江市', '3', 8, 'L', NULL, '1', '524400', '440800');
INSERT INTO `sys_region` VALUES ('440882', '2018-01-30 19:30:19', NULL, NULL, NULL, '雷州市', '广东省湛江市雷州市', '3', 9, 'L', NULL, '1', '524200', '440800');
INSERT INTO `sys_region` VALUES ('440883', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴川市', '广东省湛江市吴川市', '3', 10, 'W', NULL, '1', '524500', '440800');
INSERT INTO `sys_region` VALUES ('440900', '2018-01-30 19:30:19', NULL, NULL, NULL, '茂名市', '广东省茂名市', '2', 9, 'M', NULL, '1', '525000', '440000');
INSERT INTO `sys_region` VALUES ('440901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省茂名市市辖区', '3', 1, 'S', NULL, '1', NULL, '440900');
INSERT INTO `sys_region` VALUES ('440902', '2018-01-30 19:30:19', NULL, NULL, NULL, '茂南区', '广东省茂名市茂南区', '3', 2, 'M', NULL, '1', '525000', '440900');
INSERT INTO `sys_region` VALUES ('440904', '2018-01-30 19:30:19', NULL, NULL, NULL, '电白区', '广东省茂名市电白区', '3', 3, 'D', NULL, '1', '525400', '440900');
INSERT INTO `sys_region` VALUES ('440981', '2018-01-30 19:30:19', NULL, NULL, NULL, '高州市', '广东省茂名市高州市', '3', 4, 'G', NULL, '1', '525200', '440900');
INSERT INTO `sys_region` VALUES ('440982', '2018-01-30 19:30:19', NULL, NULL, NULL, '化州市', '广东省茂名市化州市', '3', 5, 'H', NULL, '1', '525100', '440900');
INSERT INTO `sys_region` VALUES ('440983', '2018-01-30 19:30:19', NULL, NULL, NULL, '信宜市', '广东省茂名市信宜市', '3', 6, 'X', NULL, '1', '525300', '440900');
INSERT INTO `sys_region` VALUES ('441200', '2018-01-30 19:30:19', NULL, NULL, NULL, '肇庆市', '广东省肇庆市', '2', 10, 'Z', NULL, '1', '526040', '440000');
INSERT INTO `sys_region` VALUES ('441201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省肇庆市市辖区', '3', 1, 'S', NULL, '1', NULL, '441200');
INSERT INTO `sys_region` VALUES ('441202', '2018-01-30 19:30:19', NULL, NULL, NULL, '端州区', '广东省肇庆市端州区', '3', 2, 'D', NULL, '1', '526060', '441200');
INSERT INTO `sys_region` VALUES ('441203', '2018-01-30 19:30:19', NULL, NULL, NULL, '鼎湖区', '广东省肇庆市鼎湖区', '3', 3, 'D', NULL, '1', '526070', '441200');
INSERT INTO `sys_region` VALUES ('441204', '2018-01-30 19:30:19', NULL, NULL, NULL, '高要区', '广东省肇庆市高要区', '3', 4, 'G', NULL, '1', NULL, '441200');
INSERT INTO `sys_region` VALUES ('441223', '2018-01-30 19:30:19', NULL, NULL, NULL, '广宁县', '广东省肇庆市广宁县', '3', 5, 'G', NULL, '1', '526300', '441200');
INSERT INTO `sys_region` VALUES ('441224', '2018-01-30 19:30:19', NULL, NULL, NULL, '怀集县', '广东省肇庆市怀集县', '3', 6, 'H', NULL, '1', '526400', '441200');
INSERT INTO `sys_region` VALUES ('441225', '2018-01-30 19:30:19', NULL, NULL, NULL, '封开县', '广东省肇庆市封开县', '3', 7, 'F', NULL, '1', '526500', '441200');
INSERT INTO `sys_region` VALUES ('441226', '2018-01-30 19:30:19', NULL, NULL, NULL, '德庆县', '广东省肇庆市德庆县', '3', 8, 'D', NULL, '1', '526600', '441200');
INSERT INTO `sys_region` VALUES ('441284', '2018-01-30 19:30:19', NULL, NULL, NULL, '四会市', '广东省肇庆市四会市', '3', 9, 'S', NULL, '1', '526200', '441200');
INSERT INTO `sys_region` VALUES ('441300', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠州市', '广东省惠州市', '2', 11, 'H', NULL, '1', '516000', '440000');
INSERT INTO `sys_region` VALUES ('441301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省惠州市市辖区', '3', 1, 'S', NULL, '1', NULL, '441300');
INSERT INTO `sys_region` VALUES ('441302', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠城区', '广东省惠州市惠城区', '3', 2, 'H', NULL, '1', '516008', '441300');
INSERT INTO `sys_region` VALUES ('441303', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠阳区', '广东省惠州市惠阳区', '3', 3, 'H', NULL, '1', '516211', '441300');
INSERT INTO `sys_region` VALUES ('441322', '2018-01-30 19:30:19', NULL, NULL, NULL, '博罗县', '广东省惠州市博罗县', '3', 4, 'B', NULL, '1', '516100', '441300');
INSERT INTO `sys_region` VALUES ('441323', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠东县', '广东省惠州市惠东县', '3', 5, 'H', NULL, '1', '516300', '441300');
INSERT INTO `sys_region` VALUES ('441324', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙门县', '广东省惠州市龙门县', '3', 6, 'L', NULL, '1', '516800', '441300');
INSERT INTO `sys_region` VALUES ('441400', '2018-01-30 19:30:19', NULL, NULL, NULL, '梅州市', '广东省梅州市', '2', 12, 'M', NULL, '1', '514021', '440000');
INSERT INTO `sys_region` VALUES ('441401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省梅州市市辖区', '3', 1, 'S', NULL, '1', NULL, '441400');
INSERT INTO `sys_region` VALUES ('441402', '2018-01-30 19:30:19', NULL, NULL, NULL, '梅江区', '广东省梅州市梅江区', '3', 2, 'M', NULL, '1', '514000', '441400');
INSERT INTO `sys_region` VALUES ('441403', '2018-01-30 19:30:19', NULL, NULL, NULL, '梅县区', '广东省梅州市梅县区', '3', 3, 'M', NULL, '1', '514787', '441400');
INSERT INTO `sys_region` VALUES ('441422', '2018-01-30 19:30:19', NULL, NULL, NULL, '大埔县', '广东省梅州市大埔县', '3', 4, 'D', NULL, '1', '514200', '441400');
INSERT INTO `sys_region` VALUES ('441423', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰顺县', '广东省梅州市丰顺县', '3', 5, 'F', NULL, '1', '514300', '441400');
INSERT INTO `sys_region` VALUES ('441424', '2018-01-30 19:30:19', NULL, NULL, NULL, '五华县', '广东省梅州市五华县', '3', 6, 'W', NULL, '1', '514400', '441400');
INSERT INTO `sys_region` VALUES ('441426', '2018-01-30 19:30:19', NULL, NULL, NULL, '平远县', '广东省梅州市平远县', '3', 7, 'P', NULL, '1', '514600', '441400');
INSERT INTO `sys_region` VALUES ('441427', '2018-01-30 19:30:19', NULL, NULL, NULL, '蕉岭县', '广东省梅州市蕉岭县', '3', 8, 'J', NULL, '1', '514100', '441400');
INSERT INTO `sys_region` VALUES ('441481', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴宁市', '广东省梅州市兴宁市', '3', 9, 'X', NULL, '1', '514500', '441400');
INSERT INTO `sys_region` VALUES ('441500', '2018-01-30 19:30:19', NULL, NULL, NULL, '汕尾市', '广东省汕尾市', '2', 13, 'S', NULL, '1', '516600', '440000');
INSERT INTO `sys_region` VALUES ('441501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省汕尾市市辖区', '3', 1, 'S', NULL, '1', NULL, '441500');
INSERT INTO `sys_region` VALUES ('441502', '2018-01-30 19:30:19', NULL, NULL, NULL, '城区', '广东省汕尾市城区', '3', 2, 'C', NULL, '1', '516600', '441500');
INSERT INTO `sys_region` VALUES ('441521', '2018-01-30 19:30:19', NULL, NULL, NULL, '海丰县', '广东省汕尾市海丰县', '3', 3, 'H', NULL, '1', '516400', '441500');
INSERT INTO `sys_region` VALUES ('441523', '2018-01-30 19:30:19', NULL, NULL, NULL, '陆河县', '广东省汕尾市陆河县', '3', 4, 'L', NULL, '1', '516700', '441500');
INSERT INTO `sys_region` VALUES ('441581', '2018-01-30 19:30:19', NULL, NULL, NULL, '陆丰市', '广东省汕尾市陆丰市', '3', 5, 'L', NULL, '1', '516500', '441500');
INSERT INTO `sys_region` VALUES ('441600', '2018-01-30 19:30:19', NULL, NULL, NULL, '河源市', '广东省河源市', '2', 14, 'H', NULL, '1', '517000', '440000');
INSERT INTO `sys_region` VALUES ('441601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省河源市市辖区', '3', 1, 'S', NULL, '1', NULL, '441600');
INSERT INTO `sys_region` VALUES ('441602', '2018-01-30 19:30:19', NULL, NULL, NULL, '源城区', '广东省河源市源城区', '3', 2, 'Y', NULL, '1', '517000', '441600');
INSERT INTO `sys_region` VALUES ('441621', '2018-01-30 19:30:19', NULL, NULL, NULL, '紫金县', '广东省河源市紫金县', '3', 3, 'Z', NULL, '1', '517400', '441600');
INSERT INTO `sys_region` VALUES ('441622', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙川县', '广东省河源市龙川县', '3', 4, 'L', NULL, '1', '517300', '441600');
INSERT INTO `sys_region` VALUES ('441623', '2018-01-30 19:30:19', NULL, NULL, NULL, '连平县', '广东省河源市连平县', '3', 5, 'L', NULL, '1', '517100', '441600');
INSERT INTO `sys_region` VALUES ('441624', '2018-01-30 19:30:19', NULL, NULL, NULL, '和平县', '广东省河源市和平县', '3', 6, 'H', NULL, '1', '517200', '441600');
INSERT INTO `sys_region` VALUES ('441625', '2018-01-30 19:30:19', NULL, NULL, NULL, '东源县', '广东省河源市东源县', '3', 7, 'D', NULL, '1', '517583', '441600');
INSERT INTO `sys_region` VALUES ('441700', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳江市', '广东省阳江市', '2', 15, 'Y', NULL, '1', '529500', '440000');
INSERT INTO `sys_region` VALUES ('441701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省阳江市市辖区', '3', 1, 'S', NULL, '1', NULL, '441700');
INSERT INTO `sys_region` VALUES ('441702', '2018-01-30 19:30:19', NULL, NULL, NULL, '江城区', '广东省阳江市江城区', '3', 2, 'J', NULL, '1', '529500', '441700');
INSERT INTO `sys_region` VALUES ('441704', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳东区', '广东省阳江市阳东区', '3', 3, 'Y', NULL, '1', '529900', '441700');
INSERT INTO `sys_region` VALUES ('441721', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳西县', '广东省阳江市阳西县', '3', 4, 'Y', NULL, '1', '529800', '441700');
INSERT INTO `sys_region` VALUES ('441781', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳春市', '广东省阳江市阳春市', '3', 5, 'Y', NULL, '1', '529600', '441700');
INSERT INTO `sys_region` VALUES ('441800', '2018-01-30 19:30:19', NULL, NULL, NULL, '清远市', '广东省清远市', '2', 16, 'Q', NULL, '1', '511500', '440000');
INSERT INTO `sys_region` VALUES ('441801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省清远市市辖区', '3', 1, 'S', NULL, '1', NULL, '441800');
INSERT INTO `sys_region` VALUES ('441802', '2018-01-30 19:30:19', NULL, NULL, NULL, '清城区', '广东省清远市清城区', '3', 2, 'Q', NULL, '1', '511515', '441800');
INSERT INTO `sys_region` VALUES ('441803', '2018-01-30 19:30:19', NULL, NULL, NULL, '清新区', '广东省清远市清新区', '3', 3, 'Q', NULL, '1', '511810', '441800');
INSERT INTO `sys_region` VALUES ('441821', '2018-01-30 19:30:19', NULL, NULL, NULL, '佛冈县', '广东省清远市佛冈县', '3', 4, 'F', NULL, '1', '511600', '441800');
INSERT INTO `sys_region` VALUES ('441823', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳山县', '广东省清远市阳山县', '3', 5, 'Y', NULL, '1', '513100', '441800');
INSERT INTO `sys_region` VALUES ('441825', '2018-01-30 19:30:19', NULL, NULL, NULL, '连山壮族瑶族自治县', '广东省清远市连山壮族瑶族自治县', '3', 6, 'L', NULL, '1', '513200', '441800');
INSERT INTO `sys_region` VALUES ('441826', '2018-01-30 19:30:19', NULL, NULL, NULL, '连南瑶族自治县', '广东省清远市连南瑶族自治县', '3', 7, 'L', NULL, '1', '513300', '441800');
INSERT INTO `sys_region` VALUES ('441881', '2018-01-30 19:30:19', NULL, NULL, NULL, '英德市', '广东省清远市英德市', '3', 8, 'Y', NULL, '1', '513000', '441800');
INSERT INTO `sys_region` VALUES ('441882', '2018-01-30 19:30:19', NULL, NULL, NULL, '连州市', '广东省清远市连州市', '3', 9, 'L', NULL, '1', '513400', '441800');
INSERT INTO `sys_region` VALUES ('441900', '2018-01-30 19:30:19', NULL, NULL, NULL, '东莞市', '广东省东莞市', '2', 17, 'D', NULL, '1', '523888', '440000');
INSERT INTO `sys_region` VALUES ('442000', '2018-01-30 19:30:19', NULL, NULL, NULL, '中山市', '广东省中山市', '2', 18, 'Z', NULL, '1', '528403', '440000');
INSERT INTO `sys_region` VALUES ('445100', '2018-01-30 19:30:19', NULL, NULL, NULL, '潮州市', '广东省潮州市', '2', 19, 'C', NULL, '1', '521000', '440000');
INSERT INTO `sys_region` VALUES ('445101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省潮州市市辖区', '3', 1, 'S', NULL, '1', NULL, '445100');
INSERT INTO `sys_region` VALUES ('445102', '2018-01-30 19:30:19', NULL, NULL, NULL, '湘桥区', '广东省潮州市湘桥区', '3', 2, 'X', NULL, '1', '521000', '445100');
INSERT INTO `sys_region` VALUES ('445103', '2018-01-30 19:30:19', NULL, NULL, NULL, '潮安区', '广东省潮州市潮安区', '3', 3, 'C', NULL, '1', '515638', '445100');
INSERT INTO `sys_region` VALUES ('445122', '2018-01-30 19:30:19', NULL, NULL, NULL, '饶平县', '广东省潮州市饶平县', '3', 4, 'R', NULL, '1', '515700', '445100');
INSERT INTO `sys_region` VALUES ('445200', '2018-01-30 19:30:19', NULL, NULL, NULL, '揭阳市', '广东省揭阳市', '2', 20, 'J', NULL, '1', '522000', '440000');
INSERT INTO `sys_region` VALUES ('445201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省揭阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '445200');
INSERT INTO `sys_region` VALUES ('445202', '2018-01-30 19:30:19', NULL, NULL, NULL, '榕城区', '广东省揭阳市榕城区', '3', 2, 'Z', NULL, '1', '522000', '445200');
INSERT INTO `sys_region` VALUES ('445203', '2018-01-30 19:30:19', NULL, NULL, NULL, '揭东区', '广东省揭阳市揭东区', '3', 3, 'J', NULL, '1', '515500', '445200');
INSERT INTO `sys_region` VALUES ('445222', '2018-01-30 19:30:19', NULL, NULL, NULL, '揭西县', '广东省揭阳市揭西县', '3', 4, 'J', NULL, '1', '515400', '445200');
INSERT INTO `sys_region` VALUES ('445224', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠来县', '广东省揭阳市惠来县', '3', 5, 'H', NULL, '1', '515200', '445200');
INSERT INTO `sys_region` VALUES ('445281', '2018-01-30 19:30:19', NULL, NULL, NULL, '普宁市', '广东省揭阳市普宁市', '3', 6, 'P', NULL, '1', '515300', '445200');
INSERT INTO `sys_region` VALUES ('445300', '2018-01-30 19:30:19', NULL, NULL, NULL, '云浮市', '广东省云浮市', '2', 21, 'Y', NULL, '1', '527300', '440000');
INSERT INTO `sys_region` VALUES ('445301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广东省云浮市市辖区', '3', 1, 'S', NULL, '1', NULL, '445300');
INSERT INTO `sys_region` VALUES ('445302', '2018-01-30 19:30:19', NULL, NULL, NULL, '云城区', '广东省云浮市云城区', '3', 2, 'Y', NULL, '1', '527300', '445300');
INSERT INTO `sys_region` VALUES ('445303', '2018-01-30 19:30:19', NULL, NULL, NULL, '云安区', '广东省云浮市云安区', '3', 3, 'Y', NULL, '1', '527500', '445300');
INSERT INTO `sys_region` VALUES ('445321', '2018-01-30 19:30:19', NULL, NULL, NULL, '新兴县', '广东省云浮市新兴县', '3', 4, 'X', NULL, '1', '527400', '445300');
INSERT INTO `sys_region` VALUES ('445322', '2018-01-30 19:30:19', NULL, NULL, NULL, '郁南县', '广东省云浮市郁南县', '3', 5, 'Y', NULL, '1', '527100', '445300');
INSERT INTO `sys_region` VALUES ('445381', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗定市', '广东省云浮市罗定市', '3', 6, 'L', NULL, '1', '527200', '445300');
INSERT INTO `sys_region` VALUES ('450000', '2018-01-30 19:30:19', NULL, NULL, NULL, '广西壮族自治区', '广西壮族自治区', '1', 20, 'G', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('450100', '2018-01-30 19:30:19', NULL, NULL, NULL, '南宁市', '广西壮族自治区南宁市', '2', 1, 'N', NULL, '1', '530028', '450000');
INSERT INTO `sys_region` VALUES ('450101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区南宁市市辖区', '3', 1, 'S', NULL, '1', NULL, '450100');
INSERT INTO `sys_region` VALUES ('450102', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴宁区', '广西壮族自治区南宁市兴宁区', '3', 2, 'X', NULL, '1', '530023', '450100');
INSERT INTO `sys_region` VALUES ('450103', '2018-01-30 19:30:19', NULL, NULL, NULL, '青秀区', '广西壮族自治区南宁市青秀区', '3', 3, 'Q', NULL, '1', '530213', '450100');
INSERT INTO `sys_region` VALUES ('450105', '2018-01-30 19:30:19', NULL, NULL, NULL, '江南区', '广西壮族自治区南宁市江南区', '3', 4, 'J', NULL, '1', '530031', '450100');
INSERT INTO `sys_region` VALUES ('450107', '2018-01-30 19:30:19', NULL, NULL, NULL, '西乡塘区', '广西壮族自治区南宁市西乡塘区', '3', 5, 'X', NULL, '1', '530001', '450100');
INSERT INTO `sys_region` VALUES ('450108', '2018-01-30 19:30:19', NULL, NULL, NULL, '良庆区', '广西壮族自治区南宁市良庆区', '3', 6, 'L', NULL, '1', '530219', '450100');
INSERT INTO `sys_region` VALUES ('450109', '2018-01-30 19:30:19', NULL, NULL, NULL, '邕宁区', '广西壮族自治区南宁市邕宁区', '3', 7, 'Z', NULL, '1', '530200', '450100');
INSERT INTO `sys_region` VALUES ('450110', '2018-01-30 19:30:19', NULL, NULL, NULL, '武鸣区', '广西壮族自治区南宁市武鸣区', '3', 8, 'W', NULL, '1', NULL, '450100');
INSERT INTO `sys_region` VALUES ('450115', '2018-01-30 19:30:19', NULL, NULL, NULL, '南湖分局管辖区', NULL, '3', 1, 'N', NULL, '1', NULL, '330402');
INSERT INTO `sys_region` VALUES ('450116', '2018-01-30 19:30:19', NULL, NULL, NULL, '高新分局管辖区', NULL, '3', 1, 'G', NULL, '1', NULL, '450130');
INSERT INTO `sys_region` VALUES ('450117', '2018-01-30 19:30:19', NULL, NULL, NULL, '青秀山风景名胜旅游区分局管辖区', NULL, '3', 1, 'Q', NULL, '1', NULL, '450103');
INSERT INTO `sys_region` VALUES ('450123', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆安县', '广西壮族自治区南宁市隆安县', '3', 1, 'L', NULL, '1', '532700', '450100');
INSERT INTO `sys_region` VALUES ('450124', '2018-01-30 19:30:19', NULL, NULL, NULL, '马山县', '广西壮族自治区南宁市马山县', '3', 2, 'M', NULL, '1', '530600', '450100');
INSERT INTO `sys_region` VALUES ('450125', '2018-01-30 19:30:19', NULL, NULL, NULL, '上林县', '广西壮族自治区南宁市上林县', '3', 3, 'S', NULL, '1', '530500', '450100');
INSERT INTO `sys_region` VALUES ('450126', '2018-01-30 19:30:19', NULL, NULL, NULL, '宾阳县', '广西壮族自治区南宁市宾阳县', '3', 4, 'B', NULL, '1', '530400', '450100');
INSERT INTO `sys_region` VALUES ('450127', '2018-01-30 19:30:19', NULL, NULL, NULL, '横县', '广西壮族自治区南宁市横县', '3', 5, 'H', NULL, '1', '530300', '450100');
INSERT INTO `sys_region` VALUES ('450128', '2018-01-30 19:30:19', NULL, NULL, NULL, '高新技术产业开发区', '广西壮族自治区南宁市高新技术产业开发区', '3', 6, 'G', NULL, '1', '530000', '450100');
INSERT INTO `sys_region` VALUES ('450129', '2018-01-30 19:30:19', NULL, NULL, NULL, '经济技术开发区', '广西壮族自治区南宁市经济技术开发区', '3', 7, 'J', NULL, '1', NULL, '450100');
INSERT INTO `sys_region` VALUES ('450130', '2018-01-30 19:30:19', NULL, NULL, NULL, '东盟经济技术开发区', '广西壮族自治区南宁市东盟经济技术开发区', '3', 8, 'D', NULL, '1', NULL, '450100');
INSERT INTO `sys_region` VALUES ('450200', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳州市', '广西壮族自治区柳州市', '2', 2, 'L', NULL, '1', '545001', '450000');
INSERT INTO `sys_region` VALUES ('450201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区柳州市市辖区', '3', 1, 'S', NULL, '1', NULL, '450200');
INSERT INTO `sys_region` VALUES ('450202', '2018-01-30 19:30:19', NULL, NULL, NULL, '城中区', '广西壮族自治区柳州市城中区', '3', 2, 'C', NULL, '1', '545001', '450200');
INSERT INTO `sys_region` VALUES ('450203', '2018-01-30 19:30:19', NULL, NULL, NULL, '鱼峰区', '广西壮族自治区柳州市鱼峰区', '3', 3, 'Y', NULL, '1', '545005', '450200');
INSERT INTO `sys_region` VALUES ('450204', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳南区', '广西壮族自治区柳州市柳南区', '3', 4, 'L', NULL, '1', '545007', '450200');
INSERT INTO `sys_region` VALUES ('450205', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳北区', '广西壮族自治区柳州市柳北区', '3', 5, 'L', NULL, '1', '545002', '450200');
INSERT INTO `sys_region` VALUES ('450206', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳江区', '广西壮族自治区柳州市柳江区', '3', 6, 'L', NULL, '1', NULL, '450200');
INSERT INTO `sys_region` VALUES ('450222', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳城县', '广西壮族自治区柳州市柳城县', '3', 7, 'L', NULL, '1', '545200', '450200');
INSERT INTO `sys_region` VALUES ('450223', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹿寨县', '广西壮族自治区柳州市鹿寨县', '3', 8, 'L', NULL, '1', '545600', '450200');
INSERT INTO `sys_region` VALUES ('450224', '2018-01-30 19:30:19', NULL, NULL, NULL, '融安县', '广西壮族自治区柳州市融安县', '3', 9, 'R', NULL, '1', '545400', '450200');
INSERT INTO `sys_region` VALUES ('450225', '2018-01-30 19:30:19', NULL, NULL, NULL, '融水苗族自治县', '广西壮族自治区柳州市融水苗族自治县', '3', 10, 'R', NULL, '1', '545300', '450200');
INSERT INTO `sys_region` VALUES ('450226', '2018-01-30 19:30:19', NULL, NULL, NULL, '三江侗族自治县', '广西壮族自治区柳州市三江侗族自治县', '3', 11, 'S', NULL, '1', '545500', '450200');
INSERT INTO `sys_region` VALUES ('450299', '2018-01-30 19:30:19', NULL, NULL, NULL, '柳东分局管辖区', '广西壮族自治区柳州市柳东分局管辖区', '3', 12, 'L', NULL, '1', NULL, '450200');
INSERT INTO `sys_region` VALUES ('450300', '2018-01-30 19:30:19', NULL, NULL, NULL, '桂林市', '广西壮族自治区桂林市', '2', 3, 'G', NULL, '1', '541100', '450000');
INSERT INTO `sys_region` VALUES ('450301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区桂林市市辖区', '3', 1, 'S', NULL, '1', NULL, '450300');
INSERT INTO `sys_region` VALUES ('450302', '2018-01-30 19:30:19', NULL, NULL, NULL, '秀峰区', '广西壮族自治区桂林市秀峰区', '3', 2, 'X', NULL, '1', '541001', '450300');
INSERT INTO `sys_region` VALUES ('450303', '2018-01-30 19:30:19', NULL, NULL, NULL, '叠彩区', '广西壮族自治区桂林市叠彩区', '3', 3, 'D', NULL, '1', '541001', '450300');
INSERT INTO `sys_region` VALUES ('450304', '2018-01-30 19:30:19', NULL, NULL, NULL, '象山区', '广西壮族自治区桂林市象山区', '3', 4, 'X', NULL, '1', '541002', '450300');
INSERT INTO `sys_region` VALUES ('450305', '2018-01-30 19:30:19', NULL, NULL, NULL, '七星区', '广西壮族自治区桂林市七星区', '3', 5, 'Q', NULL, '1', '541004', '450300');
INSERT INTO `sys_region` VALUES ('450311', '2018-01-30 19:30:19', NULL, NULL, NULL, '雁山区', '广西壮族自治区桂林市雁山区', '3', 6, 'Y', NULL, '1', '541006', '450300');
INSERT INTO `sys_region` VALUES ('450312', '2018-01-30 19:30:19', NULL, NULL, NULL, '临桂区', '广西壮族自治区桂林市临桂区', '3', 7, 'L', NULL, '1', '541100', '450300');
INSERT INTO `sys_region` VALUES ('450321', '2018-01-30 19:30:19', NULL, NULL, NULL, '阳朔县', '广西壮族自治区桂林市阳朔县', '3', 8, 'Y', NULL, '1', '541900', '450300');
INSERT INTO `sys_region` VALUES ('450323', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵川县', '广西壮族自治区桂林市灵川县', '3', 9, 'L', NULL, '1', '541200', '450300');
INSERT INTO `sys_region` VALUES ('450324', '2018-01-30 19:30:19', NULL, NULL, NULL, '全州县', '广西壮族自治区桂林市全州县', '3', 10, 'Q', NULL, '1', '541503', '450300');
INSERT INTO `sys_region` VALUES ('450325', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴安县', '广西壮族自治区桂林市兴安县', '3', 11, 'X', NULL, '1', '541300', '450300');
INSERT INTO `sys_region` VALUES ('450326', '2018-01-30 19:30:19', NULL, NULL, NULL, '永福县', '广西壮族自治区桂林市永福县', '3', 12, 'Y', NULL, '1', '541800', '450300');
INSERT INTO `sys_region` VALUES ('450327', '2018-01-30 19:30:19', NULL, NULL, NULL, '灌阳县', '广西壮族自治区桂林市灌阳县', '3', 13, 'G', NULL, '1', '541600', '450300');
INSERT INTO `sys_region` VALUES ('450328', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙胜各族自治县', '广西壮族自治区桂林市龙胜各族自治县', '3', 14, 'L', NULL, '1', '541700', '450300');
INSERT INTO `sys_region` VALUES ('450329', '2018-01-30 19:30:19', NULL, NULL, NULL, '资源县', '广西壮族自治区桂林市资源县', '3', 15, 'Z', NULL, '1', '541400', '450300');
INSERT INTO `sys_region` VALUES ('450330', '2018-01-30 19:30:19', NULL, NULL, NULL, '平乐县', '广西壮族自治区桂林市平乐县', '3', 16, 'P', NULL, '1', '542400', '450300');
INSERT INTO `sys_region` VALUES ('450331', '2018-01-30 19:30:19', NULL, NULL, NULL, '荔浦县', '广西壮族自治区桂林市荔浦县', '3', 17, 'L', NULL, '1', '546600', '450300');
INSERT INTO `sys_region` VALUES ('450332', '2018-01-30 19:30:19', NULL, NULL, NULL, '恭城瑶族自治县', '广西壮族自治区桂林市恭城瑶族自治县', '3', 18, 'G', NULL, '1', '542500', '450300');
INSERT INTO `sys_region` VALUES ('450400', '2018-01-30 19:30:19', NULL, NULL, NULL, '梧州市', '广西壮族自治区梧州市', '2', 4, 'W', NULL, '1', '543002', '450000');
INSERT INTO `sys_region` VALUES ('450401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区梧州市市辖区', '3', 1, 'S', NULL, '1', NULL, '450400');
INSERT INTO `sys_region` VALUES ('450403', '2018-01-30 19:30:19', NULL, NULL, NULL, '万秀区', '广西壮族自治区梧州市万秀区', '3', 2, 'W', NULL, '1', '543000', '450400');
INSERT INTO `sys_region` VALUES ('450405', '2018-01-30 19:30:19', NULL, NULL, NULL, '长洲区', '广西壮族自治区梧州市长洲区', '3', 3, 'C', NULL, '1', '543003', '450400');
INSERT INTO `sys_region` VALUES ('450406', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙圩区', '广西壮族自治区梧州市龙圩区', '3', 4, 'L', NULL, '1', '543002', '450400');
INSERT INTO `sys_region` VALUES ('450421', '2018-01-30 19:30:19', NULL, NULL, NULL, '苍梧县', '广西壮族自治区梧州市苍梧县', '3', 5, 'C', NULL, '1', '543100', '450400');
INSERT INTO `sys_region` VALUES ('450422', '2018-01-30 19:30:19', NULL, NULL, NULL, '藤县', '广西壮族自治区梧州市藤县', '3', 6, 'T', NULL, '1', '543300', '450400');
INSERT INTO `sys_region` VALUES ('450423', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒙山县', '广西壮族自治区梧州市蒙山县', '3', 7, 'M', NULL, '1', '546700', '450400');
INSERT INTO `sys_region` VALUES ('450481', '2018-01-30 19:30:19', NULL, NULL, NULL, '岑溪市', '广西壮族自治区梧州市岑溪市', '3', 8, 'Z', NULL, '1', '543200', '450400');
INSERT INTO `sys_region` VALUES ('450500', '2018-01-30 19:30:19', NULL, NULL, NULL, '北海市', '广西壮族自治区北海市', '2', 5, 'B', NULL, '1', '536000', '450000');
INSERT INTO `sys_region` VALUES ('450501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区北海市市辖区', '3', 1, 'S', NULL, '1', NULL, '450500');
INSERT INTO `sys_region` VALUES ('450502', '2018-01-30 19:30:19', NULL, NULL, NULL, '海城区', '广西壮族自治区北海市海城区', '3', 2, 'H', NULL, '1', '536000', '450500');
INSERT INTO `sys_region` VALUES ('450503', '2018-01-30 19:30:19', NULL, NULL, NULL, '银海区', '广西壮族自治区北海市银海区', '3', 3, 'Y', NULL, '1', '536000', '450500');
INSERT INTO `sys_region` VALUES ('450512', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁山港区', '广西壮族自治区北海市铁山港区', '3', 4, 'T', NULL, '1', '536017', '450500');
INSERT INTO `sys_region` VALUES ('450521', '2018-01-30 19:30:19', NULL, NULL, NULL, '合浦县', '广西壮族自治区北海市合浦县', '3', 5, 'H', NULL, '1', '536100', '450500');
INSERT INTO `sys_region` VALUES ('450600', '2018-01-30 19:30:19', NULL, NULL, NULL, '防城港市', '广西壮族自治区防城港市', '2', 6, 'F', NULL, '1', '538001', '450000');
INSERT INTO `sys_region` VALUES ('450601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区防城港市市辖区', '3', 1, 'S', NULL, '1', NULL, '450600');
INSERT INTO `sys_region` VALUES ('450602', '2018-01-30 19:30:19', NULL, NULL, NULL, '港口区', '广西壮族自治区防城港市港口区', '3', 2, 'G', NULL, '1', '538001', '450600');
INSERT INTO `sys_region` VALUES ('450603', '2018-01-30 19:30:19', NULL, NULL, NULL, '防城区', '广西壮族自治区防城港市防城区', '3', 3, 'F', NULL, '1', '538021', '450600');
INSERT INTO `sys_region` VALUES ('450604', '2018-01-30 19:30:19', NULL, NULL, NULL, '企沙工业区分局管辖区', '广西壮族自治区防城港市企沙工业区分局管辖区', '3', 4, 'Q', NULL, '1', NULL, '450600');
INSERT INTO `sys_region` VALUES ('450621', '2018-01-30 19:30:19', NULL, NULL, NULL, '上思县', '广西壮族自治区防城港市上思县', '3', 5, 'S', NULL, '1', '535500', '450600');
INSERT INTO `sys_region` VALUES ('450681', '2018-01-30 19:30:19', NULL, NULL, NULL, '东兴市', '广西壮族自治区防城港市东兴市', '3', 6, 'D', NULL, '1', '538100', '450600');
INSERT INTO `sys_region` VALUES ('450682', '2018-01-30 19:30:19', NULL, NULL, NULL, '海港分局管辖区', '广西壮族自治区防城港市海港分局管辖区', '3', 7, 'H', NULL, '1', NULL, '450600');
INSERT INTO `sys_region` VALUES ('450700', '2018-01-30 19:30:19', NULL, NULL, NULL, '钦州市', '广西壮族自治区钦州市', '2', 7, 'Q', NULL, '1', '535099', '450000');
INSERT INTO `sys_region` VALUES ('450701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区钦州市市辖区', '3', 1, 'S', NULL, '1', NULL, '450700');
INSERT INTO `sys_region` VALUES ('450702', '2018-01-30 19:30:19', NULL, NULL, NULL, '钦南区', '广西壮族自治区钦州市钦南区', '3', 2, 'Q', NULL, '1', '535099', '450700');
INSERT INTO `sys_region` VALUES ('450703', '2018-01-30 19:30:19', NULL, NULL, NULL, '钦北区', '广西壮族自治区钦州市钦北区', '3', 3, 'Q', NULL, '1', '535099', '450700');
INSERT INTO `sys_region` VALUES ('450704', '2018-01-30 19:30:19', NULL, NULL, NULL, '钦州港经济技术开发区', '广西壮族自治区钦州市钦州港经济技术开发区', '3', 4, 'Q', NULL, '1', NULL, '450700');
INSERT INTO `sys_region` VALUES ('450721', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵山县', '广西壮族自治区钦州市灵山县', '3', 5, 'L', NULL, '1', '535099', '450700');
INSERT INTO `sys_region` VALUES ('450722', '2018-01-30 19:30:19', NULL, NULL, NULL, '浦北县', '广西壮族自治区钦州市浦北县', '3', 6, 'P', NULL, '1', '535099', '450700');
INSERT INTO `sys_region` VALUES ('450800', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵港市', '广西壮族自治区贵港市', '2', 8, 'G', NULL, '1', '537100', '450000');
INSERT INTO `sys_region` VALUES ('450801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区贵港市市辖区', '3', 1, 'S', NULL, '1', NULL, '450800');
INSERT INTO `sys_region` VALUES ('450802', '2018-01-30 19:30:19', NULL, NULL, NULL, '港北区', '广西壮族自治区贵港市港北区', '3', 2, 'G', NULL, '1', '537100', '450800');
INSERT INTO `sys_region` VALUES ('450803', '2018-01-30 19:30:19', NULL, NULL, NULL, '港南区', '广西壮族自治区贵港市港南区', '3', 3, 'G', NULL, '1', '537100', '450800');
INSERT INTO `sys_region` VALUES ('450804', '2018-01-30 19:30:19', NULL, NULL, NULL, '覃塘区', '广西壮族自治区贵港市覃塘区', '3', 4, 'Z', NULL, '1', '537121', '450800');
INSERT INTO `sys_region` VALUES ('450821', '2018-01-30 19:30:19', NULL, NULL, NULL, '平南县', '广西壮族自治区贵港市平南县', '3', 5, 'P', NULL, '1', '537300', '450800');
INSERT INTO `sys_region` VALUES ('450881', '2018-01-30 19:30:19', NULL, NULL, NULL, '桂平市', '广西壮族自治区贵港市桂平市', '3', 6, 'G', NULL, '1', '537200', '450800');
INSERT INTO `sys_region` VALUES ('450900', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉林市', '广西壮族自治区玉林市', '2', 9, 'Y', NULL, '1', '537000', '450000');
INSERT INTO `sys_region` VALUES ('450901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区玉林市市辖区', '3', 1, 'S', NULL, '1', NULL, '450900');
INSERT INTO `sys_region` VALUES ('450902', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉州区', '广西壮族自治区玉林市玉州区', '3', 2, 'Y', NULL, '1', '537000', '450900');
INSERT INTO `sys_region` VALUES ('450903', '2018-01-30 19:30:19', NULL, NULL, NULL, '福绵区', '广西壮族自治区玉林市福绵区', '3', 3, 'F', NULL, '1', '537023', '450900');
INSERT INTO `sys_region` VALUES ('450904', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉东区', '广西壮族自治区玉林市玉东区', '3', 4, 'Y', NULL, '1', '537000', '450900');
INSERT INTO `sys_region` VALUES ('450921', '2018-01-30 19:30:19', NULL, NULL, NULL, '容县', '广西壮族自治区玉林市容县', '3', 5, 'R', NULL, '1', '537500', '450900');
INSERT INTO `sys_region` VALUES ('450922', '2018-01-30 19:30:19', NULL, NULL, NULL, '陆川县', '广西壮族自治区玉林市陆川县', '3', 6, 'L', NULL, '1', '537700', '450900');
INSERT INTO `sys_region` VALUES ('450923', '2018-01-30 19:30:19', NULL, NULL, NULL, '博白县', '广西壮族自治区玉林市博白县', '3', 7, 'B', NULL, '1', '537600', '450900');
INSERT INTO `sys_region` VALUES ('450924', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴业县', '广西壮族自治区玉林市兴业县', '3', 8, 'X', NULL, '1', '537800', '450900');
INSERT INTO `sys_region` VALUES ('450981', '2018-01-30 19:30:19', NULL, NULL, NULL, '北流市', '广西壮族自治区玉林市北流市', '3', 9, 'B', NULL, '1', '537400', '450900');
INSERT INTO `sys_region` VALUES ('451000', '2018-01-30 19:30:19', NULL, NULL, NULL, '百色市', '广西壮族自治区百色市', '2', 10, 'B', NULL, '1', '533000', '450000');
INSERT INTO `sys_region` VALUES ('451001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区百色市市辖区', '3', 1, 'S', NULL, '1', NULL, '451000');
INSERT INTO `sys_region` VALUES ('451002', '2018-01-30 19:30:19', NULL, NULL, NULL, '右江区', '广西壮族自治区百色市右江区', '3', 2, 'Y', NULL, '1', '533000', '451000');
INSERT INTO `sys_region` VALUES ('451003', '2018-01-30 19:30:19', NULL, NULL, NULL, '铝城分局管辖区', '广西壮族自治区百色市铝城分局管辖区', '3', 3, 'L', NULL, '1', NULL, '451000');
INSERT INTO `sys_region` VALUES ('451021', '2018-01-30 19:30:19', NULL, NULL, NULL, '田阳县', '广西壮族自治区百色市田阳县', '3', 4, 'T', NULL, '1', '533600', '451000');
INSERT INTO `sys_region` VALUES ('451022', '2018-01-30 19:30:19', NULL, NULL, NULL, '田东县', '广西壮族自治区百色市田东县', '3', 5, 'T', NULL, '1', '531500', '451000');
INSERT INTO `sys_region` VALUES ('451023', '2018-01-30 19:30:19', NULL, NULL, NULL, '平果县', '广西壮族自治区百色市平果县', '3', 6, 'P', NULL, '1', '531400', '451000');
INSERT INTO `sys_region` VALUES ('451024', '2018-01-30 19:30:19', NULL, NULL, NULL, '德保县', '广西壮族自治区百色市德保县', '3', 7, 'D', NULL, '1', '533700', '451000');
INSERT INTO `sys_region` VALUES ('451026', '2018-01-30 19:30:19', NULL, NULL, NULL, '那坡县', '广西壮族自治区百色市那坡县', '3', 8, 'N', NULL, '1', '533900', '451000');
INSERT INTO `sys_region` VALUES ('451027', '2018-01-30 19:30:19', NULL, NULL, NULL, '凌云县', '广西壮族自治区百色市凌云县', '3', 9, 'L', NULL, '1', '533100', '451000');
INSERT INTO `sys_region` VALUES ('451028', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐业县', '广西壮族自治区百色市乐业县', '3', 10, 'L', NULL, '1', '533200', '451000');
INSERT INTO `sys_region` VALUES ('451029', '2018-01-30 19:30:19', NULL, NULL, NULL, '田林县', '广西壮族自治区百色市田林县', '3', 11, 'T', NULL, '1', '533300', '451000');
INSERT INTO `sys_region` VALUES ('451030', '2018-01-30 19:30:19', NULL, NULL, NULL, '西林县', '广西壮族自治区百色市西林县', '3', 12, 'X', NULL, '1', '533500', '451000');
INSERT INTO `sys_region` VALUES ('451031', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆林各族自治县', '广西壮族自治区百色市隆林各族自治县', '3', 13, 'L', NULL, '1', '533400', '451000');
INSERT INTO `sys_region` VALUES ('451081', '2018-01-30 19:30:19', NULL, NULL, NULL, '靖西市', '广西壮族自治区百色市靖西市', '3', 14, 'J', NULL, '1', NULL, '451000');
INSERT INTO `sys_region` VALUES ('451100', '2018-01-30 19:30:19', NULL, NULL, NULL, '贺州市', '广西壮族自治区贺州市', '2', 11, 'H', NULL, '1', '542800', '450000');
INSERT INTO `sys_region` VALUES ('451101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区贺州市市辖区', '3', 1, 'S', NULL, '1', NULL, '451100');
INSERT INTO `sys_region` VALUES ('451102', '2018-01-30 19:30:19', NULL, NULL, NULL, '八步区', '广西壮族自治区贺州市八步区', '3', 2, 'B', NULL, '1', '542800', '451100');
INSERT INTO `sys_region` VALUES ('451103', '2018-01-30 19:30:19', NULL, NULL, NULL, '平桂区', '广西壮族自治区贺州市平桂区', '3', 3, 'P', NULL, '1', NULL, '451100');
INSERT INTO `sys_region` VALUES ('451121', '2018-01-30 19:30:19', NULL, NULL, NULL, '昭平县', '广西壮族自治区贺州市昭平县', '3', 4, 'Z', NULL, '1', '546800', '451100');
INSERT INTO `sys_region` VALUES ('451122', '2018-01-30 19:30:19', NULL, NULL, NULL, '钟山县', '广西壮族自治区贺州市钟山县', '3', 5, 'Z', NULL, '1', '542600', '451100');
INSERT INTO `sys_region` VALUES ('451123', '2018-01-30 19:30:19', NULL, NULL, NULL, '富川瑶族自治县', '广西壮族自治区贺州市富川瑶族自治县', '3', 6, 'F', NULL, '1', '542700', '451100');
INSERT INTO `sys_region` VALUES ('451200', '2018-01-30 19:30:19', NULL, NULL, NULL, '河池市', '广西壮族自治区河池市', '2', 12, 'H', NULL, '1', '547000', '450000');
INSERT INTO `sys_region` VALUES ('451201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区河池市市辖区', '3', 1, 'S', NULL, '1', NULL, '451200');
INSERT INTO `sys_region` VALUES ('451202', '2018-01-30 19:30:19', NULL, NULL, NULL, '金城江区', '广西壮族自治区河池市金城江区', '3', 2, 'J', NULL, '1', '547000', '451200');
INSERT INTO `sys_region` VALUES ('451221', '2018-01-30 19:30:19', NULL, NULL, NULL, '南丹县', '广西壮族自治区河池市南丹县', '3', 3, 'N', NULL, '1', '547200', '451200');
INSERT INTO `sys_region` VALUES ('451222', '2018-01-30 19:30:19', NULL, NULL, NULL, '天峨县', '广西壮族自治区河池市天峨县', '3', 4, 'T', NULL, '1', '547300', '451200');
INSERT INTO `sys_region` VALUES ('451223', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤山县', '广西壮族自治区河池市凤山县', '3', 5, 'F', NULL, '1', '547600', '451200');
INSERT INTO `sys_region` VALUES ('451224', '2018-01-30 19:30:19', NULL, NULL, NULL, '东兰县', '广西壮族自治区河池市东兰县', '3', 6, 'D', NULL, '1', '547400', '451200');
INSERT INTO `sys_region` VALUES ('451225', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗城仫佬族自治县', '广西壮族自治区河池市罗城仫佬族自治县', '3', 7, 'L', NULL, '1', '546400', '451200');
INSERT INTO `sys_region` VALUES ('451226', '2018-01-30 19:30:19', NULL, NULL, NULL, '环江毛南族自治县', '广西壮族自治区河池市环江毛南族自治县', '3', 8, 'H', NULL, '1', '547100', '451200');
INSERT INTO `sys_region` VALUES ('451227', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴马瑶族自治县', '广西壮族自治区河池市巴马瑶族自治县', '3', 9, 'B', NULL, '1', '547500', '451200');
INSERT INTO `sys_region` VALUES ('451228', '2018-01-30 19:30:19', NULL, NULL, NULL, '都安瑶族自治县', '广西壮族自治区河池市都安瑶族自治县', '3', 10, 'D', NULL, '1', '530700', '451200');
INSERT INTO `sys_region` VALUES ('451229', '2018-01-30 19:30:19', NULL, NULL, NULL, '大化瑶族自治县', '广西壮族自治区河池市大化瑶族自治县', '3', 11, 'D', NULL, '1', '530800', '451200');
INSERT INTO `sys_region` VALUES ('451281', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜州市', '广西壮族自治区河池市宜州市', '3', 12, 'Y', NULL, '1', '546300', '451200');
INSERT INTO `sys_region` VALUES ('451300', '2018-01-30 19:30:19', NULL, NULL, NULL, '来宾市', '广西壮族自治区来宾市', '2', 13, 'L', NULL, '1', '546100', '450000');
INSERT INTO `sys_region` VALUES ('451301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区来宾市市辖区', '3', 1, 'S', NULL, '1', NULL, '451300');
INSERT INTO `sys_region` VALUES ('451302', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴宾区', '广西壮族自治区来宾市兴宾区', '3', 2, 'X', NULL, '1', '546100', '451300');
INSERT INTO `sys_region` VALUES ('451303', '2018-01-30 19:30:19', NULL, NULL, NULL, '来宾高新技术产业开发区', '广西壮族自治区来宾市来宾高新技术产业开发区', '3', 3, 'L', NULL, '1', NULL, '451300');
INSERT INTO `sys_region` VALUES ('451321', '2018-01-30 19:30:19', NULL, NULL, NULL, '忻城县', '广西壮族自治区来宾市忻城县', '3', 4, 'X', NULL, '1', '546200', '451300');
INSERT INTO `sys_region` VALUES ('451322', '2018-01-30 19:30:19', NULL, NULL, NULL, '象州县', '广西壮族自治区来宾市象州县', '3', 5, 'X', NULL, '1', '545800', '451300');
INSERT INTO `sys_region` VALUES ('451323', '2018-01-30 19:30:19', NULL, NULL, NULL, '武宣县', '广西壮族自治区来宾市武宣县', '3', 6, 'W', NULL, '1', '545900', '451300');
INSERT INTO `sys_region` VALUES ('451324', '2018-01-30 19:30:19', NULL, NULL, NULL, '金秀瑶族自治县', '广西壮族自治区来宾市金秀瑶族自治县', '3', 7, 'J', NULL, '1', '545799', '451300');
INSERT INTO `sys_region` VALUES ('451381', '2018-01-30 19:30:19', NULL, NULL, NULL, '合山市', '广西壮族自治区来宾市合山市', '3', 8, 'H', NULL, '1', '546500', '451300');
INSERT INTO `sys_region` VALUES ('451400', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇左市', '广西壮族自治区崇左市', '2', 14, 'C', NULL, '1', '532299', '450000');
INSERT INTO `sys_region` VALUES ('451401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '广西壮族自治区崇左市市辖区', '3', 1, 'S', NULL, '1', NULL, '451400');
INSERT INTO `sys_region` VALUES ('451402', '2018-01-30 19:30:19', NULL, NULL, NULL, '江州区', '广西壮族自治区崇左市江州区', '3', 2, 'J', NULL, '1', '532299', '451400');
INSERT INTO `sys_region` VALUES ('451421', '2018-01-30 19:30:19', NULL, NULL, NULL, '扶绥县', '广西壮族自治区崇左市扶绥县', '3', 3, 'F', NULL, '1', '532199', '451400');
INSERT INTO `sys_region` VALUES ('451422', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁明县', '广西壮族自治区崇左市宁明县', '3', 4, 'N', NULL, '1', '532599', '451400');
INSERT INTO `sys_region` VALUES ('451423', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙州县', '广西壮族自治区崇左市龙州县', '3', 5, 'L', NULL, '1', '532499', '451400');
INSERT INTO `sys_region` VALUES ('451424', '2018-01-30 19:30:19', NULL, NULL, NULL, '大新县', '广西壮族自治区崇左市大新县', '3', 6, 'D', NULL, '1', '532399', '451400');
INSERT INTO `sys_region` VALUES ('451425', '2018-01-30 19:30:19', NULL, NULL, NULL, '天等县', '广西壮族自治区崇左市天等县', '3', 7, 'T', NULL, '1', '532899', '451400');
INSERT INTO `sys_region` VALUES ('451481', '2018-01-30 19:30:19', NULL, NULL, NULL, '凭祥市', '广西壮族自治区崇左市凭祥市', '3', 8, 'P', NULL, '1', '532699', '451400');
INSERT INTO `sys_region` VALUES ('460000', '2018-01-30 19:30:19', NULL, NULL, NULL, '海南省', '海南省', '1', 21, 'H', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('460100', '2018-01-30 19:30:19', NULL, NULL, NULL, '海口市', '海南省海口市', '2', 1, 'H', NULL, '1', '570000', '460000');
INSERT INTO `sys_region` VALUES ('460101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '海南省海口市市辖区', '3', 1, 'S', NULL, '1', NULL, '460100');
INSERT INTO `sys_region` VALUES ('460105', '2018-01-30 19:30:19', NULL, NULL, NULL, '秀英区', '海南省海口市秀英区', '3', 2, 'X', NULL, '1', '570311', '460100');
INSERT INTO `sys_region` VALUES ('460106', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙华区', '海南省海口市龙华区', '3', 3, 'L', NULL, '1', '570145', '460100');
INSERT INTO `sys_region` VALUES ('460107', '2018-01-30 19:30:19', NULL, NULL, NULL, '琼山区', '海南省海口市琼山区', '3', 4, 'Q', NULL, '1', '571100', '460100');
INSERT INTO `sys_region` VALUES ('460108', '2018-01-30 19:30:19', NULL, NULL, NULL, '美兰区', '海南省海口市美兰区', '3', 5, 'M', NULL, '1', '570203', '460100');
INSERT INTO `sys_region` VALUES ('460200', '2018-01-30 19:30:19', NULL, NULL, NULL, '三亚市', '海南省三亚市', '2', 2, 'S', NULL, '1', '572000', '460000');
INSERT INTO `sys_region` VALUES ('460201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '海南省三亚市市辖区', '3', 1, 'S', NULL, '1', NULL, '460200');
INSERT INTO `sys_region` VALUES ('460202', '2018-01-30 19:30:19', NULL, NULL, NULL, '海棠区', '海南省三亚市海棠区', '3', 2, 'H', NULL, '1', '572000', '460200');
INSERT INTO `sys_region` VALUES ('460203', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉阳区', '海南省三亚市吉阳区', '3', 3, 'J', NULL, '1', '572000', '460200');
INSERT INTO `sys_region` VALUES ('460204', '2018-01-30 19:30:19', NULL, NULL, NULL, '天涯区', '海南省三亚市天涯区', '3', 4, 'T', NULL, '1', '572000', '460200');
INSERT INTO `sys_region` VALUES ('460205', '2018-01-30 19:30:19', NULL, NULL, NULL, '崖州区', '海南省三亚市崖州区', '3', 5, 'Y', NULL, '1', '572000', '460200');
INSERT INTO `sys_region` VALUES ('460300', '2018-01-30 19:30:19', NULL, NULL, NULL, '三沙市', '海南省三沙市', '2', 3, 'S', NULL, '1', '573199', '460000');
INSERT INTO `sys_region` VALUES ('460400', '2018-01-30 19:30:19', NULL, NULL, NULL, '儋州市', '海南省儋州市', '2', 4, 'Z', NULL, '1', NULL, '460000');
INSERT INTO `sys_region` VALUES ('469000', '2018-01-30 19:30:19', NULL, NULL, NULL, '省直辖县级行政区划', '海南省省直辖县级行政区划', '2', 5, 'S', NULL, '1', '', '460000');
INSERT INTO `sys_region` VALUES ('469001', '2018-01-30 19:30:19', NULL, NULL, NULL, '五指山市', '海南省省直辖县级行政区划五指山市', '3', 1, 'W', NULL, '1', '572200', '469000');
INSERT INTO `sys_region` VALUES ('469002', '2018-01-30 19:30:19', NULL, NULL, NULL, '琼海市', '海南省省直辖县级行政区划琼海市', '3', 2, 'Q', NULL, '1', '571400', '469000');
INSERT INTO `sys_region` VALUES ('469005', '2018-01-30 19:30:19', NULL, NULL, NULL, '文昌市', '海南省省直辖县级行政区划文昌市', '3', 3, 'W', NULL, '1', '571339', '469000');
INSERT INTO `sys_region` VALUES ('469006', '2018-01-30 19:30:19', NULL, NULL, NULL, '万宁市', '海南省省直辖县级行政区划万宁市', '3', 4, 'W', NULL, '1', '571500', '469000');
INSERT INTO `sys_region` VALUES ('469007', '2018-01-30 19:30:19', NULL, NULL, NULL, '东方市', '海南省省直辖县级行政区划东方市', '3', 5, 'D', NULL, '1', '572600', '469000');
INSERT INTO `sys_region` VALUES ('469021', '2018-01-30 19:30:19', NULL, NULL, NULL, '定安县', '海南省省直辖县级行政区划定安县', '3', 6, 'D', NULL, '1', '571200', '469000');
INSERT INTO `sys_region` VALUES ('469022', '2018-01-30 19:30:19', NULL, NULL, NULL, '屯昌县', '海南省省直辖县级行政区划屯昌县', '3', 7, 'T', NULL, '1', '571600', '469000');
INSERT INTO `sys_region` VALUES ('469023', '2018-01-30 19:30:19', NULL, NULL, NULL, '澄迈县', '海南省省直辖县级行政区划澄迈县', '3', 8, 'C', NULL, '1', '571900', '469000');
INSERT INTO `sys_region` VALUES ('469024', '2018-01-30 19:30:19', NULL, NULL, NULL, '临高县', '海南省省直辖县级行政区划临高县', '3', 9, 'L', NULL, '1', '571800', '469000');
INSERT INTO `sys_region` VALUES ('469025', '2018-01-30 19:30:19', NULL, NULL, NULL, '白沙黎族自治县', '海南省省直辖县级行政区划白沙黎族自治县', '3', 10, 'B', NULL, '1', '572800', '469000');
INSERT INTO `sys_region` VALUES ('469026', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌江黎族自治县', '海南省省直辖县级行政区划昌江黎族自治县', '3', 11, 'C', NULL, '1', '572700', '469000');
INSERT INTO `sys_region` VALUES ('469027', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐东黎族自治县', '海南省省直辖县级行政区划乐东黎族自治县', '3', 12, 'L', NULL, '1', '572500', '469000');
INSERT INTO `sys_region` VALUES ('469028', '2018-01-30 19:30:19', NULL, NULL, NULL, '陵水黎族自治县', '海南省省直辖县级行政区划陵水黎族自治县', '3', 13, 'L', NULL, '1', '572400', '469000');
INSERT INTO `sys_region` VALUES ('469029', '2018-01-30 19:30:19', NULL, NULL, NULL, '保亭黎族苗族自治县', '海南省省直辖县级行政区划保亭黎族苗族自治县', '3', 14, 'B', NULL, '1', '572300', '469000');
INSERT INTO `sys_region` VALUES ('469030', '2018-01-30 19:30:19', NULL, NULL, NULL, '琼中黎族苗族自治县', '海南省省直辖县级行政区划琼中黎族苗族自治县', '3', 15, 'Q', NULL, '1', '572900', '469000');
INSERT INTO `sys_region` VALUES ('500000', '2018-01-30 19:30:19', NULL, NULL, NULL, '重庆市', '重庆市', '1', 22, 'Z', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('500100', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '重庆市市辖区', '2', 1, 'S', NULL, '1', '400000', '500000');
INSERT INTO `sys_region` VALUES ('500101', '2018-01-30 19:30:19', NULL, NULL, NULL, '万州区', '重庆市市辖区万州区', '3', 1, 'W', NULL, '1', '404000', '500100');
INSERT INTO `sys_region` VALUES ('500102', '2018-01-30 19:30:19', NULL, NULL, NULL, '涪陵区', '重庆市市辖区涪陵区', '3', 2, 'F', NULL, '1', '408000', '500100');
INSERT INTO `sys_region` VALUES ('500103', '2018-01-30 19:30:19', NULL, NULL, NULL, '渝中区', '重庆市市辖区渝中区', '3', 3, 'Y', NULL, '1', '400010', '500100');
INSERT INTO `sys_region` VALUES ('500104', '2018-01-30 19:30:19', NULL, NULL, NULL, '大渡口区', '重庆市市辖区大渡口区', '3', 4, 'D', NULL, '1', '400080', '500100');
INSERT INTO `sys_region` VALUES ('500105', '2018-01-30 19:30:19', NULL, NULL, NULL, '江北区', '重庆市市辖区江北区', '3', 5, 'J', NULL, '1', '400020', '500100');
INSERT INTO `sys_region` VALUES ('500106', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙坪坝区', '重庆市市辖区沙坪坝区', '3', 6, 'S', NULL, '1', '400030', '500100');
INSERT INTO `sys_region` VALUES ('500107', '2018-01-30 19:30:19', NULL, NULL, NULL, '九龙坡区', '重庆市市辖区九龙坡区', '3', 7, 'J', NULL, '1', '400050', '500100');
INSERT INTO `sys_region` VALUES ('500108', '2018-01-30 19:30:19', NULL, NULL, NULL, '南岸区', '重庆市市辖区南岸区', '3', 8, 'N', NULL, '1', '400064', '500100');
INSERT INTO `sys_region` VALUES ('500109', '2018-01-30 19:30:19', NULL, NULL, NULL, '北碚区', '重庆市市辖区北碚区', '3', 9, 'B', NULL, '1', '400700', '500100');
INSERT INTO `sys_region` VALUES ('500110', '2018-01-30 19:30:19', NULL, NULL, NULL, '綦江区', '重庆市市辖区綦江区', '3', 10, 'Z', NULL, '1', '400800', '500100');
INSERT INTO `sys_region` VALUES ('500111', '2018-01-30 19:30:19', NULL, NULL, NULL, '大足区', '重庆市市辖区大足区', '3', 11, 'D', NULL, '1', '400900', '500100');
INSERT INTO `sys_region` VALUES ('500112', '2018-01-30 19:30:19', NULL, NULL, NULL, '渝北区', '重庆市市辖区渝北区', '3', 12, 'Y', NULL, '1', '401120', '500100');
INSERT INTO `sys_region` VALUES ('500113', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴南区', '重庆市市辖区巴南区', '3', 13, 'B', NULL, '1', '401320', '500100');
INSERT INTO `sys_region` VALUES ('500114', '2018-01-30 19:30:19', NULL, NULL, NULL, '黔江区', '重庆市市辖区黔江区', '3', 14, 'Q', NULL, '1', '409700', '500100');
INSERT INTO `sys_region` VALUES ('500115', '2018-01-30 19:30:19', NULL, NULL, NULL, '长寿区', '重庆市市辖区长寿区', '3', 15, 'C', NULL, '1', '401220', '500100');
INSERT INTO `sys_region` VALUES ('500116', '2018-01-30 19:30:19', NULL, NULL, NULL, '江津区', '重庆市市辖区江津区', '3', 16, 'J', NULL, '1', '402260', '500100');
INSERT INTO `sys_region` VALUES ('500117', '2018-01-30 19:30:19', NULL, NULL, NULL, '合川区', '重庆市市辖区合川区', '3', 17, 'H', NULL, '1', '401520', '500100');
INSERT INTO `sys_region` VALUES ('500118', '2018-01-30 19:30:19', NULL, NULL, NULL, '永川区', '重庆市市辖区永川区', '3', 18, 'Y', NULL, '1', '402160', '500100');
INSERT INTO `sys_region` VALUES ('500119', '2018-01-30 19:30:19', NULL, NULL, NULL, '南川区', '重庆市市辖区南川区', '3', 19, 'N', NULL, '1', '408400', '500100');
INSERT INTO `sys_region` VALUES ('500120', '2018-01-30 19:30:19', NULL, NULL, NULL, '璧山区', '重庆市市辖区璧山区', '3', 20, 'Z', NULL, '1', '402760', '500100');
INSERT INTO `sys_region` VALUES ('500151', '2018-01-30 19:30:19', NULL, NULL, NULL, '铜梁区', '重庆市市辖区铜梁区', '3', 21, 'T', NULL, '1', '402560', '500100');
INSERT INTO `sys_region` VALUES ('500152', '2018-01-30 19:30:19', NULL, NULL, NULL, '潼南区', '重庆市市辖区潼南区', '3', 22, 'Z', NULL, '1', NULL, '500100');
INSERT INTO `sys_region` VALUES ('500153', '2018-01-30 19:30:19', NULL, NULL, NULL, '荣昌区', '重庆市市辖区荣昌区', '3', 23, 'R', NULL, '1', NULL, '500100');
INSERT INTO `sys_region` VALUES ('500154', '2018-01-30 19:30:19', NULL, NULL, NULL, '开州区', '重庆市市辖区开州区', '3', 24, 'K', NULL, '1', NULL, '500100');
INSERT INTO `sys_region` VALUES ('500200', '2018-01-30 19:30:19', NULL, NULL, NULL, '县', '重庆市县', '2', 2, 'X', NULL, '1', NULL, '500000');
INSERT INTO `sys_region` VALUES ('500228', '2018-01-30 19:30:19', NULL, NULL, NULL, '梁平县', '重庆市县梁平县', '3', 1, 'L', NULL, '1', '405200', '500200');
INSERT INTO `sys_region` VALUES ('500229', '2018-01-30 19:30:19', NULL, NULL, NULL, '城口县', '重庆市县城口县', '3', 2, 'C', NULL, '1', '405900', '500200');
INSERT INTO `sys_region` VALUES ('500230', '2018-01-30 19:30:19', NULL, NULL, NULL, '丰都县', '重庆市县丰都县', '3', 3, 'F', NULL, '1', '408200', '500200');
INSERT INTO `sys_region` VALUES ('500231', '2018-01-30 19:30:19', NULL, NULL, NULL, '垫江县', '重庆市县垫江县', '3', 4, 'D', NULL, '1', '408300', '500200');
INSERT INTO `sys_region` VALUES ('500232', '2018-01-30 19:30:19', NULL, NULL, NULL, '武隆县', '重庆市县武隆县', '3', 5, 'W', NULL, '1', '408500', '500200');
INSERT INTO `sys_region` VALUES ('500233', '2018-01-30 19:30:19', NULL, NULL, NULL, '忠县', '重庆市县忠县', '3', 6, 'Z', NULL, '1', '404300', '500200');
INSERT INTO `sys_region` VALUES ('500235', '2018-01-30 19:30:19', NULL, NULL, NULL, '云阳县', '重庆市县云阳县', '3', 7, 'Y', NULL, '1', '404500', '500200');
INSERT INTO `sys_region` VALUES ('500236', '2018-01-30 19:30:19', NULL, NULL, NULL, '奉节县', '重庆市县奉节县', '3', 8, 'F', NULL, '1', '404600', '500200');
INSERT INTO `sys_region` VALUES ('500237', '2018-01-30 19:30:19', NULL, NULL, NULL, '巫山县', '重庆市县巫山县', '3', 9, 'W', NULL, '1', '404700', '500200');
INSERT INTO `sys_region` VALUES ('500238', '2018-01-30 19:30:19', NULL, NULL, NULL, '巫溪县', '重庆市县巫溪县', '3', 10, 'W', NULL, '1', '405800', '500200');
INSERT INTO `sys_region` VALUES ('500240', '2018-01-30 19:30:19', NULL, NULL, NULL, '石柱土家族自治县', '重庆市县石柱土家族自治县', '3', 11, 'S', NULL, '1', '409100', '500200');
INSERT INTO `sys_region` VALUES ('500241', '2018-01-30 19:30:19', NULL, NULL, NULL, '秀山土家族苗族自治县', '重庆市县秀山土家族苗族自治县', '3', 12, 'X', NULL, '1', '409900', '500200');
INSERT INTO `sys_region` VALUES ('500242', '2018-01-30 19:30:19', NULL, NULL, NULL, '酉阳土家族苗族自治县', '重庆市县酉阳土家族苗族自治县', '3', 13, 'Y', NULL, '1', '409800', '500200');
INSERT INTO `sys_region` VALUES ('500243', '2018-01-30 19:30:19', NULL, NULL, NULL, '彭水苗族土家族自治县', '重庆市县彭水苗族土家族自治县', '3', 14, 'P', NULL, '1', '409600', '500200');
INSERT INTO `sys_region` VALUES ('510000', '2018-01-30 19:30:19', NULL, NULL, NULL, '四川省', '四川省', '1', 23, 'S', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('510100', '2018-01-30 19:30:19', NULL, NULL, NULL, '成都市', '四川省成都市', '2', 1, 'C', NULL, '1', '610015', '510000');
INSERT INTO `sys_region` VALUES ('510101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省成都市市辖区', '3', 1, 'S', NULL, '1', NULL, '510100');
INSERT INTO `sys_region` VALUES ('510104', '2018-01-30 19:30:19', NULL, NULL, NULL, '锦江区', '四川省成都市锦江区', '3', 2, 'J', NULL, '1', '610021', '510100');
INSERT INTO `sys_region` VALUES ('510105', '2018-01-30 19:30:19', NULL, NULL, NULL, '青羊区', '四川省成都市青羊区', '3', 3, 'Q', NULL, '1', '610031', '510100');
INSERT INTO `sys_region` VALUES ('510106', '2018-01-30 19:30:19', NULL, NULL, NULL, '金牛区', '四川省成都市金牛区', '3', 4, 'J', NULL, '1', '610036', '510100');
INSERT INTO `sys_region` VALUES ('510107', '2018-01-30 19:30:19', NULL, NULL, NULL, '武侯区', '四川省成都市武侯区', '3', 5, 'W', NULL, '1', '610041', '510100');
INSERT INTO `sys_region` VALUES ('510108', '2018-01-30 19:30:19', NULL, NULL, NULL, '成华区', '四川省成都市成华区', '3', 6, 'C', NULL, '1', '610066', '510100');
INSERT INTO `sys_region` VALUES ('510112', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙泉驿区', '四川省成都市龙泉驿区', '3', 7, 'L', NULL, '1', '610100', '510100');
INSERT INTO `sys_region` VALUES ('510113', '2018-01-30 19:30:19', NULL, NULL, NULL, '青白江区', '四川省成都市青白江区', '3', 8, 'Q', NULL, '1', '610300', '510100');
INSERT INTO `sys_region` VALUES ('510114', '2018-01-30 19:30:19', NULL, NULL, NULL, '新都区', '四川省成都市新都区', '3', 9, 'X', NULL, '1', '610500', '510100');
INSERT INTO `sys_region` VALUES ('510115', '2018-01-30 19:30:19', NULL, NULL, NULL, '温江区', '四川省成都市温江区', '3', 10, 'W', NULL, '1', '611130', '510100');
INSERT INTO `sys_region` VALUES ('510116', '2018-01-30 19:30:19', NULL, NULL, NULL, '双流区', '四川省成都市双流区', '3', 11, 'S', NULL, '1', NULL, '510100');
INSERT INTO `sys_region` VALUES ('510121', '2018-01-30 19:30:19', NULL, NULL, NULL, '金堂县', '四川省成都市金堂县', '3', 12, 'J', NULL, '1', '610400', '510100');
INSERT INTO `sys_region` VALUES ('510124', '2018-01-30 19:30:19', NULL, NULL, NULL, '郫县', '四川省成都市郫县', '3', 13, 'Z', NULL, '1', '611730', '510100');
INSERT INTO `sys_region` VALUES ('510129', '2018-01-30 19:30:19', NULL, NULL, NULL, '大邑县', '四川省成都市大邑县', '3', 14, 'D', NULL, '1', '611330', '510100');
INSERT INTO `sys_region` VALUES ('510131', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒲江县', '四川省成都市蒲江县', '3', 15, 'P', NULL, '1', '611630', '510100');
INSERT INTO `sys_region` VALUES ('510132', '2018-01-30 19:30:19', NULL, NULL, NULL, '新津县', '四川省成都市新津县', '3', 16, 'X', NULL, '1', '611430', '510100');
INSERT INTO `sys_region` VALUES ('510181', '2018-01-30 19:30:19', NULL, NULL, NULL, '都江堰市', '四川省成都市都江堰市', '3', 17, 'D', NULL, '1', '611830', '510100');
INSERT INTO `sys_region` VALUES ('510182', '2018-01-30 19:30:19', NULL, NULL, NULL, '彭州市', '四川省成都市彭州市', '3', 18, 'P', NULL, '1', '611930', '510100');
INSERT INTO `sys_region` VALUES ('510183', '2018-01-30 19:30:19', NULL, NULL, NULL, '邛崃市', '四川省成都市邛崃市', '3', 19, 'Z', NULL, '1', '611530', '510100');
INSERT INTO `sys_region` VALUES ('510184', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇州市', '四川省成都市崇州市', '3', 20, 'C', NULL, '1', '611230', '510100');
INSERT INTO `sys_region` VALUES ('510185', '2018-01-30 19:30:19', NULL, NULL, NULL, '简阳市', '四川省成都市简阳市', '3', 21, 'J', NULL, '1', NULL, '510100');
INSERT INTO `sys_region` VALUES ('510300', '2018-01-30 19:30:19', NULL, NULL, NULL, '自贡市', '四川省自贡市', '2', 2, 'Z', NULL, '1', '643000', '510000');
INSERT INTO `sys_region` VALUES ('510301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省自贡市市辖区', '3', 1, 'S', NULL, '1', NULL, '510300');
INSERT INTO `sys_region` VALUES ('510302', '2018-01-30 19:30:19', NULL, NULL, NULL, '自流井区', '四川省自贡市自流井区', '3', 2, 'Z', NULL, '1', '643000', '510300');
INSERT INTO `sys_region` VALUES ('510303', '2018-01-30 19:30:19', NULL, NULL, NULL, '贡井区', '四川省自贡市贡井区', '3', 3, 'G', NULL, '1', '643020', '510300');
INSERT INTO `sys_region` VALUES ('510304', '2018-01-30 19:30:19', NULL, NULL, NULL, '大安区', '四川省自贡市大安区', '3', 4, 'D', NULL, '1', '643010', '510300');
INSERT INTO `sys_region` VALUES ('510311', '2018-01-30 19:30:19', NULL, NULL, NULL, '沿滩区', '四川省自贡市沿滩区', '3', 5, 'Y', NULL, '1', '643030', '510300');
INSERT INTO `sys_region` VALUES ('510321', '2018-01-30 19:30:19', NULL, NULL, NULL, '荣县', '四川省自贡市荣县', '3', 6, 'R', NULL, '1', '643100', '510300');
INSERT INTO `sys_region` VALUES ('510322', '2018-01-30 19:30:19', NULL, NULL, NULL, '富顺县', '四川省自贡市富顺县', '3', 7, 'F', NULL, '1', '643200', '510300');
INSERT INTO `sys_region` VALUES ('510400', '2018-01-30 19:30:19', NULL, NULL, NULL, '攀枝花市', '四川省攀枝花市', '2', 3, 'P', NULL, '1', '617000', '510000');
INSERT INTO `sys_region` VALUES ('510401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省攀枝花市市辖区', '3', 1, 'S', NULL, '1', NULL, '510400');
INSERT INTO `sys_region` VALUES ('510402', '2018-01-30 19:30:19', NULL, NULL, NULL, '东区', '四川省攀枝花市东区', '3', 2, 'D', NULL, '1', '617067', '510400');
INSERT INTO `sys_region` VALUES ('510403', '2018-01-30 19:30:19', NULL, NULL, NULL, '西区', '四川省攀枝花市西区', '3', 3, 'X', NULL, '1', '617068', '510400');
INSERT INTO `sys_region` VALUES ('510411', '2018-01-30 19:30:19', NULL, NULL, NULL, '仁和区', '四川省攀枝花市仁和区', '3', 4, 'R', NULL, '1', '617061', '510400');
INSERT INTO `sys_region` VALUES ('510421', '2018-01-30 19:30:19', NULL, NULL, NULL, '米易县', '四川省攀枝花市米易县', '3', 5, 'M', NULL, '1', '617200', '510400');
INSERT INTO `sys_region` VALUES ('510422', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐边县', '四川省攀枝花市盐边县', '3', 6, 'Y', NULL, '1', '617100', '510400');
INSERT INTO `sys_region` VALUES ('510500', '2018-01-30 19:30:19', NULL, NULL, NULL, '泸州市', '四川省泸州市', '2', 4, 'Z', NULL, '1', '646000', '510000');
INSERT INTO `sys_region` VALUES ('510501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省泸州市市辖区', '3', 1, 'S', NULL, '1', NULL, '510500');
INSERT INTO `sys_region` VALUES ('510502', '2018-01-30 19:30:19', NULL, NULL, NULL, '江阳区', '四川省泸州市江阳区', '3', 2, 'J', NULL, '1', '646000', '510500');
INSERT INTO `sys_region` VALUES ('510503', '2018-01-30 19:30:19', NULL, NULL, NULL, '纳溪区', '四川省泸州市纳溪区', '3', 3, 'N', NULL, '1', '646300', '510500');
INSERT INTO `sys_region` VALUES ('510504', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙马潭区', '四川省泸州市龙马潭区', '3', 4, 'L', NULL, '1', '646000', '510500');
INSERT INTO `sys_region` VALUES ('510521', '2018-01-30 19:30:19', NULL, NULL, NULL, '泸县', '四川省泸州市泸县', '3', 5, 'Z', NULL, '1', '646106', '510500');
INSERT INTO `sys_region` VALUES ('510522', '2018-01-30 19:30:19', NULL, NULL, NULL, '合江县', '四川省泸州市合江县', '3', 6, 'H', NULL, '1', '646200', '510500');
INSERT INTO `sys_region` VALUES ('510524', '2018-01-30 19:30:19', NULL, NULL, NULL, '叙永县', '四川省泸州市叙永县', '3', 7, 'X', NULL, '1', '646400', '510500');
INSERT INTO `sys_region` VALUES ('510525', '2018-01-30 19:30:19', NULL, NULL, NULL, '古蔺县', '四川省泸州市古蔺县', '3', 8, 'G', NULL, '1', '646500', '510500');
INSERT INTO `sys_region` VALUES ('510600', '2018-01-30 19:30:19', NULL, NULL, NULL, '德阳市', '四川省德阳市', '2', 5, 'D', NULL, '1', '618000', '510000');
INSERT INTO `sys_region` VALUES ('510601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省德阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '510600');
INSERT INTO `sys_region` VALUES ('510603', '2018-01-30 19:30:19', NULL, NULL, NULL, '旌阳区', '四川省德阳市旌阳区', '3', 2, 'Z', NULL, '1', '618000', '510600');
INSERT INTO `sys_region` VALUES ('510623', '2018-01-30 19:30:19', NULL, NULL, NULL, '中江县', '四川省德阳市中江县', '3', 3, 'Z', NULL, '1', '618100', '510600');
INSERT INTO `sys_region` VALUES ('510626', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗江县', '四川省德阳市罗江县', '3', 4, 'L', NULL, '1', '618500', '510600');
INSERT INTO `sys_region` VALUES ('510681', '2018-01-30 19:30:19', NULL, NULL, NULL, '广汉市', '四川省德阳市广汉市', '3', 5, 'G', NULL, '1', '618300', '510600');
INSERT INTO `sys_region` VALUES ('510682', '2018-01-30 19:30:19', NULL, NULL, NULL, '什邡市', '四川省德阳市什邡市', '3', 6, 'S', NULL, '1', '618400', '510600');
INSERT INTO `sys_region` VALUES ('510683', '2018-01-30 19:30:19', NULL, NULL, NULL, '绵竹市', '四川省德阳市绵竹市', '3', 7, 'M', NULL, '1', '618200', '510600');
INSERT INTO `sys_region` VALUES ('510700', '2018-01-30 19:30:19', NULL, NULL, NULL, '绵阳市', '四川省绵阳市', '2', 6, 'M', NULL, '1', '621000', '510000');
INSERT INTO `sys_region` VALUES ('510701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省绵阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '510700');
INSERT INTO `sys_region` VALUES ('510703', '2018-01-30 19:30:19', NULL, NULL, NULL, '涪城区', '四川省绵阳市涪城区', '3', 2, 'F', NULL, '1', '621000', '510700');
INSERT INTO `sys_region` VALUES ('510704', '2018-01-30 19:30:19', NULL, NULL, NULL, '游仙区', '四川省绵阳市游仙区', '3', 3, 'Y', NULL, '1', '621022', '510700');
INSERT INTO `sys_region` VALUES ('510705', '2018-01-30 19:30:19', NULL, NULL, NULL, '安州区', '四川省绵阳市安州区', '3', 4, 'A', NULL, '1', NULL, '510700');
INSERT INTO `sys_region` VALUES ('510722', '2018-01-30 19:30:19', NULL, NULL, NULL, '三台县', '四川省绵阳市三台县', '3', 5, 'S', NULL, '1', '621100', '510700');
INSERT INTO `sys_region` VALUES ('510723', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐亭县', '四川省绵阳市盐亭县', '3', 6, 'Y', NULL, '1', '621600', '510700');
INSERT INTO `sys_region` VALUES ('510725', '2018-01-30 19:30:19', NULL, NULL, NULL, '梓潼县', '四川省绵阳市梓潼县', '3', 7, 'Z', NULL, '1', '622150', '510700');
INSERT INTO `sys_region` VALUES ('510726', '2018-01-30 19:30:19', NULL, NULL, NULL, '北川羌族自治县', '四川省绵阳市北川羌族自治县', '3', 8, 'B', NULL, '1', '622750', '510700');
INSERT INTO `sys_region` VALUES ('510727', '2018-01-30 19:30:19', NULL, NULL, NULL, '平武县', '四川省绵阳市平武县', '3', 9, 'P', NULL, '1', '622550', '510700');
INSERT INTO `sys_region` VALUES ('510781', '2018-01-30 19:30:19', NULL, NULL, NULL, '江油市', '四川省绵阳市江油市', '3', 10, 'J', NULL, '1', '621700', '510700');
INSERT INTO `sys_region` VALUES ('510800', '2018-01-30 19:30:19', NULL, NULL, NULL, '广元市', '四川省广元市', '2', 7, 'G', NULL, '1', '628000', '510000');
INSERT INTO `sys_region` VALUES ('510801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省广元市市辖区', '3', 1, 'S', NULL, '1', NULL, '510800');
INSERT INTO `sys_region` VALUES ('510802', '2018-01-30 19:30:19', NULL, NULL, NULL, '利州区', '四川省广元市利州区', '3', 2, 'L', NULL, '1', '628017', '510800');
INSERT INTO `sys_region` VALUES ('510811', '2018-01-30 19:30:19', NULL, NULL, NULL, '昭化区', '四川省广元市昭化区', '3', 3, 'Z', NULL, '1', '628017', '510800');
INSERT INTO `sys_region` VALUES ('510812', '2018-01-30 19:30:19', NULL, NULL, NULL, '朝天区', '四川省广元市朝天区', '3', 4, 'C', NULL, '1', '628017', '510800');
INSERT INTO `sys_region` VALUES ('510821', '2018-01-30 19:30:19', NULL, NULL, NULL, '旺苍县', '四川省广元市旺苍县', '3', 5, 'W', NULL, '1', '628200', '510800');
INSERT INTO `sys_region` VALUES ('510822', '2018-01-30 19:30:19', NULL, NULL, NULL, '青川县', '四川省广元市青川县', '3', 6, 'Q', NULL, '1', '628100', '510800');
INSERT INTO `sys_region` VALUES ('510823', '2018-01-30 19:30:19', NULL, NULL, NULL, '剑阁县', '四川省广元市剑阁县', '3', 7, 'J', NULL, '1', '628300', '510800');
INSERT INTO `sys_region` VALUES ('510824', '2018-01-30 19:30:19', NULL, NULL, NULL, '苍溪县', '四川省广元市苍溪县', '3', 8, 'C', NULL, '1', '628400', '510800');
INSERT INTO `sys_region` VALUES ('510900', '2018-01-30 19:30:19', NULL, NULL, NULL, '遂宁市', '四川省遂宁市', '2', 8, 'S', NULL, '1', '629000', '510000');
INSERT INTO `sys_region` VALUES ('510901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省遂宁市市辖区', '3', 1, 'S', NULL, '1', NULL, '510900');
INSERT INTO `sys_region` VALUES ('510903', '2018-01-30 19:30:19', NULL, NULL, NULL, '船山区', '四川省遂宁市船山区', '3', 2, 'C', NULL, '1', '629000', '510900');
INSERT INTO `sys_region` VALUES ('510904', '2018-01-30 19:30:19', NULL, NULL, NULL, '安居区', '四川省遂宁市安居区', '3', 3, 'A', NULL, '1', '629000', '510900');
INSERT INTO `sys_region` VALUES ('510921', '2018-01-30 19:30:19', NULL, NULL, NULL, '蓬溪县', '四川省遂宁市蓬溪县', '3', 4, 'P', NULL, '1', '629100', '510900');
INSERT INTO `sys_region` VALUES ('510922', '2018-01-30 19:30:19', NULL, NULL, NULL, '射洪县', '四川省遂宁市射洪县', '3', 5, 'S', NULL, '1', '629200', '510900');
INSERT INTO `sys_region` VALUES ('510923', '2018-01-30 19:30:19', NULL, NULL, NULL, '大英县', '四川省遂宁市大英县', '3', 6, 'D', NULL, '1', '629300', '510900');
INSERT INTO `sys_region` VALUES ('511000', '2018-01-30 19:30:19', NULL, NULL, NULL, '内江市', '四川省内江市', '2', 9, 'N', NULL, '1', '641000', '510000');
INSERT INTO `sys_region` VALUES ('511001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省内江市市辖区', '3', 1, 'S', NULL, '1', NULL, '511000');
INSERT INTO `sys_region` VALUES ('511002', '2018-01-30 19:30:19', NULL, NULL, NULL, '市中区', '四川省内江市市中区', '3', 2, 'S', NULL, '1', '641000', '511000');
INSERT INTO `sys_region` VALUES ('511011', '2018-01-30 19:30:19', NULL, NULL, NULL, '东兴区', '四川省内江市东兴区', '3', 3, 'D', NULL, '1', '641100', '511000');
INSERT INTO `sys_region` VALUES ('511024', '2018-01-30 19:30:19', NULL, NULL, NULL, '威远县', '四川省内江市威远县', '3', 4, 'W', NULL, '1', '642450', '511000');
INSERT INTO `sys_region` VALUES ('511025', '2018-01-30 19:30:19', NULL, NULL, NULL, '资中县', '四川省内江市资中县', '3', 5, 'Z', NULL, '1', '641200', '511000');
INSERT INTO `sys_region` VALUES ('511028', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆昌县', '四川省内江市隆昌县', '3', 6, 'L', NULL, '1', '642150', '511000');
INSERT INTO `sys_region` VALUES ('511100', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐山市', '四川省乐山市', '2', 10, 'L', NULL, '1', '614000', '510000');
INSERT INTO `sys_region` VALUES ('511101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省乐山市市辖区', '3', 1, 'S', NULL, '1', NULL, '511100');
INSERT INTO `sys_region` VALUES ('511102', '2018-01-30 19:30:19', NULL, NULL, NULL, '市中区', '四川省乐山市市中区', '3', 2, 'S', NULL, '1', '614000', '511100');
INSERT INTO `sys_region` VALUES ('511111', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙湾区', '四川省乐山市沙湾区', '3', 3, 'S', NULL, '1', '614900', '511100');
INSERT INTO `sys_region` VALUES ('511112', '2018-01-30 19:30:19', NULL, NULL, NULL, '五通桥区', '四川省乐山市五通桥区', '3', 4, 'W', NULL, '1', '614800', '511100');
INSERT INTO `sys_region` VALUES ('511113', '2018-01-30 19:30:19', NULL, NULL, NULL, '金口河区', '四川省乐山市金口河区', '3', 5, 'J', NULL, '1', '614700', '511100');
INSERT INTO `sys_region` VALUES ('511123', '2018-01-30 19:30:19', NULL, NULL, NULL, '犍为县', '四川省乐山市犍为县', '3', 6, 'Z', NULL, '1', '614400', '511100');
INSERT INTO `sys_region` VALUES ('511124', '2018-01-30 19:30:19', NULL, NULL, NULL, '井研县', '四川省乐山市井研县', '3', 7, 'J', NULL, '1', '613100', '511100');
INSERT INTO `sys_region` VALUES ('511126', '2018-01-30 19:30:19', NULL, NULL, NULL, '夹江县', '四川省乐山市夹江县', '3', 8, 'J', NULL, '1', '614100', '511100');
INSERT INTO `sys_region` VALUES ('511129', '2018-01-30 19:30:19', NULL, NULL, NULL, '沐川县', '四川省乐山市沐川县', '3', 9, 'Z', NULL, '1', '614500', '511100');
INSERT INTO `sys_region` VALUES ('511132', '2018-01-30 19:30:19', NULL, NULL, NULL, '峨边彝族自治县', '四川省乐山市峨边彝族自治县', '3', 10, 'E', NULL, '1', '614300', '511100');
INSERT INTO `sys_region` VALUES ('511133', '2018-01-30 19:30:19', NULL, NULL, NULL, '马边彝族自治县', '四川省乐山市马边彝族自治县', '3', 11, 'M', NULL, '1', '614600', '511100');
INSERT INTO `sys_region` VALUES ('511181', '2018-01-30 19:30:19', NULL, NULL, NULL, '峨眉山市', '四川省乐山市峨眉山市', '3', 12, 'E', NULL, '1', '614200', '511100');
INSERT INTO `sys_region` VALUES ('511300', '2018-01-30 19:30:19', NULL, NULL, NULL, '南充市', '四川省南充市', '2', 11, 'N', NULL, '1', '637000', '510000');
INSERT INTO `sys_region` VALUES ('511301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省南充市市辖区', '3', 1, 'S', NULL, '1', NULL, '511300');
INSERT INTO `sys_region` VALUES ('511302', '2018-01-30 19:30:19', NULL, NULL, NULL, '顺庆区', '四川省南充市顺庆区', '3', 2, 'S', NULL, '1', '637000', '511300');
INSERT INTO `sys_region` VALUES ('511303', '2018-01-30 19:30:19', NULL, NULL, NULL, '高坪区', '四川省南充市高坪区', '3', 3, 'G', NULL, '1', '637100', '511300');
INSERT INTO `sys_region` VALUES ('511304', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉陵区', '四川省南充市嘉陵区', '3', 4, 'J', NULL, '1', '637100', '511300');
INSERT INTO `sys_region` VALUES ('511321', '2018-01-30 19:30:19', NULL, NULL, NULL, '南部县', '四川省南充市南部县', '3', 5, 'N', NULL, '1', '637300', '511300');
INSERT INTO `sys_region` VALUES ('511322', '2018-01-30 19:30:19', NULL, NULL, NULL, '营山县', '四川省南充市营山县', '3', 6, 'Y', NULL, '1', '637700', '511300');
INSERT INTO `sys_region` VALUES ('511323', '2018-01-30 19:30:19', NULL, NULL, NULL, '蓬安县', '四川省南充市蓬安县', '3', 7, 'P', NULL, '1', '637800', '511300');
INSERT INTO `sys_region` VALUES ('511324', '2018-01-30 19:30:19', NULL, NULL, NULL, '仪陇县', '四川省南充市仪陇县', '3', 8, 'Y', NULL, '1', '637600', '511300');
INSERT INTO `sys_region` VALUES ('511325', '2018-01-30 19:30:19', NULL, NULL, NULL, '西充县', '四川省南充市西充县', '3', 9, 'X', NULL, '1', '637200', '511300');
INSERT INTO `sys_region` VALUES ('511381', '2018-01-30 19:30:19', NULL, NULL, NULL, '阆中市', '四川省南充市阆中市', '3', 10, 'Z', NULL, '1', '637400', '511300');
INSERT INTO `sys_region` VALUES ('511400', '2018-01-30 19:30:19', NULL, NULL, NULL, '眉山市', '四川省眉山市', '2', 12, 'M', NULL, '1', '620020', '510000');
INSERT INTO `sys_region` VALUES ('511401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省眉山市市辖区', '3', 1, 'S', NULL, '1', NULL, '511400');
INSERT INTO `sys_region` VALUES ('511402', '2018-01-30 19:30:19', NULL, NULL, NULL, '东坡区', '四川省眉山市东坡区', '3', 2, 'D', NULL, '1', '620010', '511400');
INSERT INTO `sys_region` VALUES ('511403', '2018-01-30 19:30:19', NULL, NULL, NULL, '彭山区', '四川省眉山市彭山区', '3', 3, 'P', NULL, '1', '620860', '511400');
INSERT INTO `sys_region` VALUES ('511421', '2018-01-30 19:30:19', NULL, NULL, NULL, '仁寿县', '四川省眉山市仁寿县', '3', 4, 'R', NULL, '1', '620500', '511400');
INSERT INTO `sys_region` VALUES ('511423', '2018-01-30 19:30:19', NULL, NULL, NULL, '洪雅县', '四川省眉山市洪雅县', '3', 5, 'H', NULL, '1', '620360', '511400');
INSERT INTO `sys_region` VALUES ('511424', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹棱县', '四川省眉山市丹棱县', '3', 6, 'D', NULL, '1', '620200', '511400');
INSERT INTO `sys_region` VALUES ('511425', '2018-01-30 19:30:19', NULL, NULL, NULL, '青神县', '四川省眉山市青神县', '3', 7, 'Q', NULL, '1', '620460', '511400');
INSERT INTO `sys_region` VALUES ('511500', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜宾市', '四川省宜宾市', '2', 13, 'Y', NULL, '1', '644000', '510000');
INSERT INTO `sys_region` VALUES ('511501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省宜宾市市辖区', '3', 1, 'S', NULL, '1', NULL, '511500');
INSERT INTO `sys_region` VALUES ('511502', '2018-01-30 19:30:19', NULL, NULL, NULL, '翠屏区', '四川省宜宾市翠屏区', '3', 2, 'C', NULL, '1', '644000', '511500');
INSERT INTO `sys_region` VALUES ('511503', '2018-01-30 19:30:19', NULL, NULL, NULL, '南溪区', '四川省宜宾市南溪区', '3', 3, 'N', NULL, '1', '644100', '511500');
INSERT INTO `sys_region` VALUES ('511521', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜宾县', '四川省宜宾市宜宾县', '3', 4, 'Y', NULL, '1', '644600', '511500');
INSERT INTO `sys_region` VALUES ('511523', '2018-01-30 19:30:19', NULL, NULL, NULL, '江安县', '四川省宜宾市江安县', '3', 5, 'J', NULL, '1', '644200', '511500');
INSERT INTO `sys_region` VALUES ('511524', '2018-01-30 19:30:19', NULL, NULL, NULL, '长宁县', '四川省宜宾市长宁县', '3', 6, 'C', NULL, '1', '644300', '511500');
INSERT INTO `sys_region` VALUES ('511525', '2018-01-30 19:30:19', NULL, NULL, NULL, '高县', '四川省宜宾市高县', '3', 7, 'G', NULL, '1', '645150', '511500');
INSERT INTO `sys_region` VALUES ('511526', '2018-01-30 19:30:19', NULL, NULL, NULL, '珙县', '四川省宜宾市珙县', '3', 8, 'Z', NULL, '1', '644500', '511500');
INSERT INTO `sys_region` VALUES ('511527', '2018-01-30 19:30:19', NULL, NULL, NULL, '筠连县', '四川省宜宾市筠连县', '3', 9, 'Z', NULL, '1', '645250', '511500');
INSERT INTO `sys_region` VALUES ('511528', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴文县', '四川省宜宾市兴文县', '3', 10, 'X', NULL, '1', '644400', '511500');
INSERT INTO `sys_region` VALUES ('511529', '2018-01-30 19:30:19', NULL, NULL, NULL, '屏山县', '四川省宜宾市屏山县', '3', 11, 'P', NULL, '1', '645350', '511500');
INSERT INTO `sys_region` VALUES ('511600', '2018-01-30 19:30:19', NULL, NULL, NULL, '广安市', '四川省广安市', '2', 14, 'G', NULL, '1', '638000', '510000');
INSERT INTO `sys_region` VALUES ('511601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省广安市市辖区', '3', 1, 'S', NULL, '1', NULL, '511600');
INSERT INTO `sys_region` VALUES ('511602', '2018-01-30 19:30:19', NULL, NULL, NULL, '广安区', '四川省广安市广安区', '3', 2, 'G', NULL, '1', '638000', '511600');
INSERT INTO `sys_region` VALUES ('511603', '2018-01-30 19:30:19', NULL, NULL, NULL, '前锋区', '四川省广安市前锋区', '3', 3, 'Q', NULL, '1', '638019', '511600');
INSERT INTO `sys_region` VALUES ('511621', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳池县', '四川省广安市岳池县', '3', 4, 'Y', NULL, '1', '638300', '511600');
INSERT INTO `sys_region` VALUES ('511622', '2018-01-30 19:30:19', NULL, NULL, NULL, '武胜县', '四川省广安市武胜县', '3', 5, 'W', NULL, '1', '638400', '511600');
INSERT INTO `sys_region` VALUES ('511623', '2018-01-30 19:30:19', NULL, NULL, NULL, '邻水县', '四川省广安市邻水县', '3', 6, 'L', NULL, '1', '638500', '511600');
INSERT INTO `sys_region` VALUES ('511681', '2018-01-30 19:30:19', NULL, NULL, NULL, '华蓥市', '四川省广安市华蓥市', '3', 7, 'H', NULL, '1', '638600', '511600');
INSERT INTO `sys_region` VALUES ('511700', '2018-01-30 19:30:19', NULL, NULL, NULL, '达州市', '四川省达州市', '2', 15, 'D', NULL, '1', '635000', '510000');
INSERT INTO `sys_region` VALUES ('511701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省达州市市辖区', '3', 1, 'S', NULL, '1', NULL, '511700');
INSERT INTO `sys_region` VALUES ('511702', '2018-01-30 19:30:19', NULL, NULL, NULL, '通川区', '四川省达州市通川区', '3', 2, 'T', NULL, '1', '635000', '511700');
INSERT INTO `sys_region` VALUES ('511703', '2018-01-30 19:30:19', NULL, NULL, NULL, '达川区', '四川省达州市达川区', '3', 3, 'D', NULL, '1', '635000', '511700');
INSERT INTO `sys_region` VALUES ('511722', '2018-01-30 19:30:19', NULL, NULL, NULL, '宣汉县', '四川省达州市宣汉县', '3', 4, 'X', NULL, '1', '636150', '511700');
INSERT INTO `sys_region` VALUES ('511723', '2018-01-30 19:30:19', NULL, NULL, NULL, '开江县', '四川省达州市开江县', '3', 5, 'K', NULL, '1', '636250', '511700');
INSERT INTO `sys_region` VALUES ('511724', '2018-01-30 19:30:19', NULL, NULL, NULL, '大竹县', '四川省达州市大竹县', '3', 6, 'D', NULL, '1', '635100', '511700');
INSERT INTO `sys_region` VALUES ('511725', '2018-01-30 19:30:19', NULL, NULL, NULL, '渠县', '四川省达州市渠县', '3', 7, 'Q', NULL, '1', '635200', '511700');
INSERT INTO `sys_region` VALUES ('511781', '2018-01-30 19:30:19', NULL, NULL, NULL, '万源市', '四川省达州市万源市', '3', 8, 'W', NULL, '1', '636350', '511700');
INSERT INTO `sys_region` VALUES ('511800', '2018-01-30 19:30:19', NULL, NULL, NULL, '雅安市', '四川省雅安市', '2', 16, 'Y', NULL, '1', '625000', '510000');
INSERT INTO `sys_region` VALUES ('511801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省雅安市市辖区', '3', 1, 'S', NULL, '1', NULL, '511800');
INSERT INTO `sys_region` VALUES ('511802', '2018-01-30 19:30:19', NULL, NULL, NULL, '雨城区', '四川省雅安市雨城区', '3', 2, 'Y', NULL, '1', '625000', '511800');
INSERT INTO `sys_region` VALUES ('511803', '2018-01-30 19:30:19', NULL, NULL, NULL, '名山区', '四川省雅安市名山区', '3', 3, 'M', NULL, '1', '625100', '511800');
INSERT INTO `sys_region` VALUES ('511822', '2018-01-30 19:30:19', NULL, NULL, NULL, '荥经县', '四川省雅安市荥经县', '3', 4, 'Z', NULL, '1', '625200', '511800');
INSERT INTO `sys_region` VALUES ('511823', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉源县', '四川省雅安市汉源县', '3', 5, 'H', NULL, '1', '625300', '511800');
INSERT INTO `sys_region` VALUES ('511824', '2018-01-30 19:30:19', NULL, NULL, NULL, '石棉县', '四川省雅安市石棉县', '3', 6, 'S', NULL, '1', '625400', '511800');
INSERT INTO `sys_region` VALUES ('511825', '2018-01-30 19:30:19', NULL, NULL, NULL, '天全县', '四川省雅安市天全县', '3', 7, 'T', NULL, '1', '625500', '511800');
INSERT INTO `sys_region` VALUES ('511826', '2018-01-30 19:30:19', NULL, NULL, NULL, '芦山县', '四川省雅安市芦山县', '3', 8, 'L', NULL, '1', '625600', '511800');
INSERT INTO `sys_region` VALUES ('511827', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝兴县', '四川省雅安市宝兴县', '3', 9, 'B', NULL, '1', '625700', '511800');
INSERT INTO `sys_region` VALUES ('511900', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴中市', '四川省巴中市', '2', 17, 'B', NULL, '1', '636000', '510000');
INSERT INTO `sys_region` VALUES ('511901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省巴中市市辖区', '3', 1, 'S', NULL, '1', NULL, '511900');
INSERT INTO `sys_region` VALUES ('511902', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴州区', '四川省巴中市巴州区', '3', 2, 'B', NULL, '1', '636001', '511900');
INSERT INTO `sys_region` VALUES ('511903', '2018-01-30 19:30:19', NULL, NULL, NULL, '恩阳区', '四川省巴中市恩阳区', '3', 3, 'E', NULL, '1', '636064', '511900');
INSERT INTO `sys_region` VALUES ('511921', '2018-01-30 19:30:19', NULL, NULL, NULL, '通江县', '四川省巴中市通江县', '3', 4, 'T', NULL, '1', '636700', '511900');
INSERT INTO `sys_region` VALUES ('511922', '2018-01-30 19:30:19', NULL, NULL, NULL, '南江县', '四川省巴中市南江县', '3', 5, 'N', NULL, '1', '636600', '511900');
INSERT INTO `sys_region` VALUES ('511923', '2018-01-30 19:30:19', NULL, NULL, NULL, '平昌县', '四川省巴中市平昌县', '3', 6, 'P', NULL, '1', '636400', '511900');
INSERT INTO `sys_region` VALUES ('512000', '2018-01-30 19:30:19', NULL, NULL, NULL, '资阳市', '四川省资阳市', '2', 18, 'Z', NULL, '1', '641300', '510000');
INSERT INTO `sys_region` VALUES ('512001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '四川省资阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '512000');
INSERT INTO `sys_region` VALUES ('512002', '2018-01-30 19:30:19', NULL, NULL, NULL, '雁江区', '四川省资阳市雁江区', '3', 2, 'Y', NULL, '1', '641300', '512000');
INSERT INTO `sys_region` VALUES ('512021', '2018-01-30 19:30:19', NULL, NULL, NULL, '安岳县', '四川省资阳市安岳县', '3', 3, 'A', NULL, '1', '642350', '512000');
INSERT INTO `sys_region` VALUES ('512022', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐至县', '四川省资阳市乐至县', '3', 4, 'L', NULL, '1', '641500', '512000');
INSERT INTO `sys_region` VALUES ('513200', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿坝藏族羌族自治州', '四川省阿坝藏族羌族自治州', '2', 19, 'A', NULL, '1', '624000', '510000');
INSERT INTO `sys_region` VALUES ('513201', '2018-01-30 19:30:19', NULL, NULL, NULL, '马尔康市', '四川省阿坝藏族羌族自治州马尔康市', '3', 1, 'M', NULL, '1', NULL, '513200');
INSERT INTO `sys_region` VALUES ('513221', '2018-01-30 19:30:19', NULL, NULL, NULL, '汶川县', '四川省阿坝藏族羌族自治州汶川县', '3', 2, 'Z', NULL, '1', '623000', '513200');
INSERT INTO `sys_region` VALUES ('513222', '2018-01-30 19:30:19', NULL, NULL, NULL, '理县', '四川省阿坝藏族羌族自治州理县', '3', 3, 'L', NULL, '1', '623100', '513200');
INSERT INTO `sys_region` VALUES ('513223', '2018-01-30 19:30:19', NULL, NULL, NULL, '茂县', '四川省阿坝藏族羌族自治州茂县', '3', 4, 'M', NULL, '1', '623200', '513200');
INSERT INTO `sys_region` VALUES ('513224', '2018-01-30 19:30:19', NULL, NULL, NULL, '松潘县', '四川省阿坝藏族羌族自治州松潘县', '3', 5, 'S', NULL, '1', '623300', '513200');
INSERT INTO `sys_region` VALUES ('513225', '2018-01-30 19:30:19', NULL, NULL, NULL, '九寨沟县', '四川省阿坝藏族羌族自治州九寨沟县', '3', 6, 'J', NULL, '1', '623400', '513200');
INSERT INTO `sys_region` VALUES ('513226', '2018-01-30 19:30:19', NULL, NULL, NULL, '金川县', '四川省阿坝藏族羌族自治州金川县', '3', 7, 'J', NULL, '1', '624100', '513200');
INSERT INTO `sys_region` VALUES ('513227', '2018-01-30 19:30:19', NULL, NULL, NULL, '小金县', '四川省阿坝藏族羌族自治州小金县', '3', 8, 'X', NULL, '1', '624200', '513200');
INSERT INTO `sys_region` VALUES ('513228', '2018-01-30 19:30:19', NULL, NULL, NULL, '黑水县', '四川省阿坝藏族羌族自治州黑水县', '3', 9, 'H', NULL, '1', '623500', '513200');
INSERT INTO `sys_region` VALUES ('513230', '2018-01-30 19:30:19', NULL, NULL, NULL, '壤塘县', '四川省阿坝藏族羌族自治州壤塘县', '3', 10, 'R', NULL, '1', '624300', '513200');
INSERT INTO `sys_region` VALUES ('513231', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿坝县', '四川省阿坝藏族羌族自治州阿坝县', '3', 11, 'A', NULL, '1', '624600', '513200');
INSERT INTO `sys_region` VALUES ('513232', '2018-01-30 19:30:19', NULL, NULL, NULL, '若尔盖县', '四川省阿坝藏族羌族自治州若尔盖县', '3', 12, 'R', NULL, '1', '624500', '513200');
INSERT INTO `sys_region` VALUES ('513233', '2018-01-30 19:30:19', NULL, NULL, NULL, '红原县', '四川省阿坝藏族羌族自治州红原县', '3', 13, 'H', NULL, '1', '624400', '513200');
INSERT INTO `sys_region` VALUES ('513300', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘孜藏族自治州', '四川省甘孜藏族自治州', '2', 20, 'G', NULL, '1', '626000', '510000');
INSERT INTO `sys_region` VALUES ('513301', '2018-01-30 19:30:19', NULL, NULL, NULL, '康定市', '四川省甘孜藏族自治州康定市', '3', 1, 'K', NULL, '1', NULL, '513300');
INSERT INTO `sys_region` VALUES ('513322', '2018-01-30 19:30:19', NULL, NULL, NULL, '泸定县', '四川省甘孜藏族自治州泸定县', '3', 2, 'Z', NULL, '1', '626100', '513300');
INSERT INTO `sys_region` VALUES ('513323', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹巴县', '四川省甘孜藏族自治州丹巴县', '3', 3, 'D', NULL, '1', '626300', '513300');
INSERT INTO `sys_region` VALUES ('513324', '2018-01-30 19:30:19', NULL, NULL, NULL, '九龙县', '四川省甘孜藏族自治州九龙县', '3', 4, 'J', NULL, '1', '626200', '513300');
INSERT INTO `sys_region` VALUES ('513325', '2018-01-30 19:30:19', NULL, NULL, NULL, '雅江县', '四川省甘孜藏族自治州雅江县', '3', 5, 'Y', NULL, '1', '627450', '513300');
INSERT INTO `sys_region` VALUES ('513326', '2018-01-30 19:30:19', NULL, NULL, NULL, '道孚县', '四川省甘孜藏族自治州道孚县', '3', 6, 'D', NULL, '1', '626400', '513300');
INSERT INTO `sys_region` VALUES ('513327', '2018-01-30 19:30:19', NULL, NULL, NULL, '炉霍县', '四川省甘孜藏族自治州炉霍县', '3', 7, 'L', NULL, '1', '626500', '513300');
INSERT INTO `sys_region` VALUES ('513328', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘孜县', '四川省甘孜藏族自治州甘孜县', '3', 8, 'G', NULL, '1', '626700', '513300');
INSERT INTO `sys_region` VALUES ('513329', '2018-01-30 19:30:19', NULL, NULL, NULL, '新龙县', '四川省甘孜藏族自治州新龙县', '3', 9, 'X', NULL, '1', '626800', '513300');
INSERT INTO `sys_region` VALUES ('513330', '2018-01-30 19:30:19', NULL, NULL, NULL, '德格县', '四川省甘孜藏族自治州德格县', '3', 10, 'D', NULL, '1', '627250', '513300');
INSERT INTO `sys_region` VALUES ('513331', '2018-01-30 19:30:19', NULL, NULL, NULL, '白玉县', '四川省甘孜藏族自治州白玉县', '3', 11, 'B', NULL, '1', '627150', '513300');
INSERT INTO `sys_region` VALUES ('513332', '2018-01-30 19:30:19', NULL, NULL, NULL, '石渠县', '四川省甘孜藏族自治州石渠县', '3', 12, 'S', NULL, '1', '627350', '513300');
INSERT INTO `sys_region` VALUES ('513333', '2018-01-30 19:30:19', NULL, NULL, NULL, '色达县', '四川省甘孜藏族自治州色达县', '3', 13, 'S', NULL, '1', '626600', '513300');
INSERT INTO `sys_region` VALUES ('513334', '2018-01-30 19:30:19', NULL, NULL, NULL, '理塘县', '四川省甘孜藏族自治州理塘县', '3', 14, 'L', NULL, '1', '627550', '513300');
INSERT INTO `sys_region` VALUES ('513335', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴塘县', '四川省甘孜藏族自治州巴塘县', '3', 15, 'B', NULL, '1', '627650', '513300');
INSERT INTO `sys_region` VALUES ('513336', '2018-01-30 19:30:19', NULL, NULL, NULL, '乡城县', '四川省甘孜藏族自治州乡城县', '3', 16, 'X', NULL, '1', '627850', '513300');
INSERT INTO `sys_region` VALUES ('513337', '2018-01-30 19:30:19', NULL, NULL, NULL, '稻城县', '四川省甘孜藏族自治州稻城县', '3', 17, 'D', NULL, '1', '627750', '513300');
INSERT INTO `sys_region` VALUES ('513338', '2018-01-30 19:30:19', NULL, NULL, NULL, '得荣县', '四川省甘孜藏族自治州得荣县', '3', 18, 'D', NULL, '1', '627950', '513300');
INSERT INTO `sys_region` VALUES ('513400', '2018-01-30 19:30:19', NULL, NULL, NULL, '凉山彝族自治州', '四川省凉山彝族自治州', '2', 21, 'L', NULL, '1', '615000', '510000');
INSERT INTO `sys_region` VALUES ('513401', '2018-01-30 19:30:19', NULL, NULL, NULL, '西昌市', '四川省凉山彝族自治州西昌市', '3', 1, 'X', NULL, '1', '615000', '513400');
INSERT INTO `sys_region` VALUES ('513422', '2018-01-30 19:30:19', NULL, NULL, NULL, '木里藏族自治县', '四川省凉山彝族自治州木里藏族自治县', '3', 2, 'M', NULL, '1', '615800', '513400');
INSERT INTO `sys_region` VALUES ('513423', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐源县', '四川省凉山彝族自治州盐源县', '3', 3, 'Y', NULL, '1', '615700', '513400');
INSERT INTO `sys_region` VALUES ('513424', '2018-01-30 19:30:19', NULL, NULL, NULL, '德昌县', '四川省凉山彝族自治州德昌县', '3', 4, 'D', NULL, '1', '615500', '513400');
INSERT INTO `sys_region` VALUES ('513425', '2018-01-30 19:30:19', NULL, NULL, NULL, '会理县', '四川省凉山彝族自治州会理县', '3', 5, 'H', NULL, '1', '615100', '513400');
INSERT INTO `sys_region` VALUES ('513426', '2018-01-30 19:30:19', NULL, NULL, NULL, '会东县', '四川省凉山彝族自治州会东县', '3', 6, 'H', NULL, '1', '615200', '513400');
INSERT INTO `sys_region` VALUES ('513427', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁南县', '四川省凉山彝族自治州宁南县', '3', 7, 'N', NULL, '1', '615400', '513400');
INSERT INTO `sys_region` VALUES ('513428', '2018-01-30 19:30:19', NULL, NULL, NULL, '普格县', '四川省凉山彝族自治州普格县', '3', 8, 'P', NULL, '1', '615300', '513400');
INSERT INTO `sys_region` VALUES ('513429', '2018-01-30 19:30:19', NULL, NULL, NULL, '布拖县', '四川省凉山彝族自治州布拖县', '3', 9, 'B', NULL, '1', '616350', '513400');
INSERT INTO `sys_region` VALUES ('513430', '2018-01-30 19:30:19', NULL, NULL, NULL, '金阳县', '四川省凉山彝族自治州金阳县', '3', 10, 'J', NULL, '1', '616250', '513400');
INSERT INTO `sys_region` VALUES ('513431', '2018-01-30 19:30:19', NULL, NULL, NULL, '昭觉县', '四川省凉山彝族自治州昭觉县', '3', 11, 'Z', NULL, '1', '616150', '513400');
INSERT INTO `sys_region` VALUES ('513432', '2018-01-30 19:30:19', NULL, NULL, NULL, '喜德县', '四川省凉山彝族自治州喜德县', '3', 12, 'X', NULL, '1', '616750', '513400');
INSERT INTO `sys_region` VALUES ('513433', '2018-01-30 19:30:19', NULL, NULL, NULL, '冕宁县', '四川省凉山彝族自治州冕宁县', '3', 13, 'M', NULL, '1', '615600', '513400');
INSERT INTO `sys_region` VALUES ('513434', '2018-01-30 19:30:19', NULL, NULL, NULL, '越西县', '四川省凉山彝族自治州越西县', '3', 14, 'Y', NULL, '1', '616650', '513400');
INSERT INTO `sys_region` VALUES ('513435', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘洛县', '四川省凉山彝族自治州甘洛县', '3', 15, 'G', NULL, '1', '616850', '513400');
INSERT INTO `sys_region` VALUES ('513436', '2018-01-30 19:30:19', NULL, NULL, NULL, '美姑县', '四川省凉山彝族自治州美姑县', '3', 16, 'M', NULL, '1', '616450', '513400');
INSERT INTO `sys_region` VALUES ('513437', '2018-01-30 19:30:19', NULL, NULL, NULL, '雷波县', '四川省凉山彝族自治州雷波县', '3', 17, 'L', NULL, '1', '616550', '513400');
INSERT INTO `sys_region` VALUES ('520000', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵州省', '贵州省', '1', 24, 'G', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('520100', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵阳市', '贵州省贵阳市', '2', 1, 'G', NULL, '1', '550001', '520000');
INSERT INTO `sys_region` VALUES ('520101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '贵州省贵阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '520100');
INSERT INTO `sys_region` VALUES ('520102', '2018-01-30 19:30:19', NULL, NULL, NULL, '南明区', '贵州省贵阳市南明区', '3', 2, 'N', NULL, '1', '550001', '520100');
INSERT INTO `sys_region` VALUES ('520103', '2018-01-30 19:30:19', NULL, NULL, NULL, '云岩区', '贵州省贵阳市云岩区', '3', 3, 'Y', NULL, '1', '550001', '520100');
INSERT INTO `sys_region` VALUES ('520111', '2018-01-30 19:30:19', NULL, NULL, NULL, '花溪区', '贵州省贵阳市花溪区', '3', 4, 'H', NULL, '1', '550025', '520100');
INSERT INTO `sys_region` VALUES ('520112', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌当区', '贵州省贵阳市乌当区', '3', 5, 'W', NULL, '1', '550018', '520100');
INSERT INTO `sys_region` VALUES ('520113', '2018-01-30 19:30:19', NULL, NULL, NULL, '白云区', '贵州省贵阳市白云区', '3', 6, 'B', NULL, '1', '550014', '520100');
INSERT INTO `sys_region` VALUES ('520115', '2018-01-30 19:30:19', NULL, NULL, NULL, '观山湖区', '贵州省贵阳市观山湖区', '3', 7, 'G', NULL, '1', '550009', '520100');
INSERT INTO `sys_region` VALUES ('520121', '2018-01-30 19:30:19', NULL, NULL, NULL, '开阳县', '贵州省贵阳市开阳县', '3', 8, 'K', NULL, '1', '550300', '520100');
INSERT INTO `sys_region` VALUES ('520122', '2018-01-30 19:30:19', NULL, NULL, NULL, '息烽县', '贵州省贵阳市息烽县', '3', 9, 'X', NULL, '1', '551100', '520100');
INSERT INTO `sys_region` VALUES ('520123', '2018-01-30 19:30:19', NULL, NULL, NULL, '修文县', '贵州省贵阳市修文县', '3', 10, 'X', NULL, '1', '550200', '520100');
INSERT INTO `sys_region` VALUES ('520181', '2018-01-30 19:30:19', NULL, NULL, NULL, '清镇市', '贵州省贵阳市清镇市', '3', 11, 'Q', NULL, '1', '551400', '520100');
INSERT INTO `sys_region` VALUES ('520200', '2018-01-30 19:30:19', NULL, NULL, NULL, '六盘水市', '贵州省六盘水市', '2', 2, 'L', NULL, '1', '553400', '520000');
INSERT INTO `sys_region` VALUES ('520201', '2018-01-30 19:30:19', NULL, NULL, NULL, '钟山区', '贵州省六盘水市钟山区', '3', 1, 'Z', NULL, '1', '553000', '520200');
INSERT INTO `sys_region` VALUES ('520203', '2018-01-30 19:30:19', NULL, NULL, NULL, '六枝特区', '贵州省六盘水市六枝特区', '3', 2, 'L', NULL, '1', '553400', '520200');
INSERT INTO `sys_region` VALUES ('520221', '2018-01-30 19:30:19', NULL, NULL, NULL, '水城县', '贵州省六盘水市水城县', '3', 3, 'S', NULL, '1', '553000', '520200');
INSERT INTO `sys_region` VALUES ('520222', '2018-01-30 19:30:19', NULL, NULL, NULL, '盘县', '贵州省六盘水市盘县', '3', 4, 'P', NULL, '1', '561601', '520200');
INSERT INTO `sys_region` VALUES ('520300', '2018-01-30 19:30:19', NULL, NULL, NULL, '遵义市', '贵州省遵义市', '2', 3, 'Z', NULL, '1', '563000', '520000');
INSERT INTO `sys_region` VALUES ('520301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '贵州省遵义市市辖区', '3', 1, 'S', NULL, '1', NULL, '520300');
INSERT INTO `sys_region` VALUES ('520302', '2018-01-30 19:30:19', NULL, NULL, NULL, '红花岗区', '贵州省遵义市红花岗区', '3', 2, 'H', NULL, '1', '563000', '520300');
INSERT INTO `sys_region` VALUES ('520303', '2018-01-30 19:30:19', NULL, NULL, NULL, '汇川区', '贵州省遵义市汇川区', '3', 3, 'H', NULL, '1', '563000', '520300');
INSERT INTO `sys_region` VALUES ('520304', '2018-01-30 19:30:19', NULL, NULL, NULL, '播州区', '贵州省遵义市播州区', '3', 4, 'B', NULL, '1', NULL, '520300');
INSERT INTO `sys_region` VALUES ('520322', '2018-01-30 19:30:19', NULL, NULL, NULL, '桐梓县', '贵州省遵义市桐梓县', '3', 5, 'T', NULL, '1', '563200', '520300');
INSERT INTO `sys_region` VALUES ('520323', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥阳县', '贵州省遵义市绥阳县', '3', 6, 'S', NULL, '1', '563300', '520300');
INSERT INTO `sys_region` VALUES ('520324', '2018-01-30 19:30:19', NULL, NULL, NULL, '正安县', '贵州省遵义市正安县', '3', 7, 'Z', NULL, '1', '563400', '520300');
INSERT INTO `sys_region` VALUES ('520325', '2018-01-30 19:30:19', NULL, NULL, NULL, '道真仡佬族苗族自治县', '贵州省遵义市道真仡佬族苗族自治县', '3', 8, 'D', NULL, '1', '563500', '520300');
INSERT INTO `sys_region` VALUES ('520326', '2018-01-30 19:30:19', NULL, NULL, NULL, '务川仡佬族苗族自治县', '贵州省遵义市务川仡佬族苗族自治县', '3', 9, 'W', NULL, '1', '564300', '520300');
INSERT INTO `sys_region` VALUES ('520327', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤冈县', '贵州省遵义市凤冈县', '3', 10, 'F', NULL, '1', '564200', '520300');
INSERT INTO `sys_region` VALUES ('520328', '2018-01-30 19:30:19', NULL, NULL, NULL, '湄潭县', '贵州省遵义市湄潭县', '3', 11, 'Z', NULL, '1', '564100', '520300');
INSERT INTO `sys_region` VALUES ('520329', '2018-01-30 19:30:19', NULL, NULL, NULL, '余庆县', '贵州省遵义市余庆县', '3', 12, 'Y', NULL, '1', '564400', '520300');
INSERT INTO `sys_region` VALUES ('520330', '2018-01-30 19:30:19', NULL, NULL, NULL, '习水县', '贵州省遵义市习水县', '3', 13, 'X', NULL, '1', '564600', '520300');
INSERT INTO `sys_region` VALUES ('520381', '2018-01-30 19:30:19', NULL, NULL, NULL, '赤水市', '贵州省遵义市赤水市', '3', 14, 'C', NULL, '1', '564700', '520300');
INSERT INTO `sys_region` VALUES ('520382', '2018-01-30 19:30:19', NULL, NULL, NULL, '仁怀市', '贵州省遵义市仁怀市', '3', 15, 'R', NULL, '1', '564500', '520300');
INSERT INTO `sys_region` VALUES ('520400', '2018-01-30 19:30:19', NULL, NULL, NULL, '安顺市', '贵州省安顺市', '2', 4, 'A', NULL, '1', '561000', '520000');
INSERT INTO `sys_region` VALUES ('520401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '贵州省安顺市市辖区', '3', 1, 'S', NULL, '1', NULL, '520400');
INSERT INTO `sys_region` VALUES ('520402', '2018-01-30 19:30:19', NULL, NULL, NULL, '西秀区', '贵州省安顺市西秀区', '3', 2, 'X', NULL, '1', '561000', '520400');
INSERT INTO `sys_region` VALUES ('520403', '2018-01-30 19:30:19', NULL, NULL, NULL, '平坝区', '贵州省安顺市平坝区', '3', 3, 'P', NULL, '1', NULL, '520400');
INSERT INTO `sys_region` VALUES ('520422', '2018-01-30 19:30:19', NULL, NULL, NULL, '普定县', '贵州省安顺市普定县', '3', 4, 'P', NULL, '1', '562100', '520400');
INSERT INTO `sys_region` VALUES ('520423', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇宁布依族苗族自治县', '贵州省安顺市镇宁布依族苗族自治县', '3', 5, 'Z', NULL, '1', '561200', '520400');
INSERT INTO `sys_region` VALUES ('520424', '2018-01-30 19:30:19', NULL, NULL, NULL, '关岭布依族苗族自治县', '贵州省安顺市关岭布依族苗族自治县', '3', 6, 'G', NULL, '1', '561300', '520400');
INSERT INTO `sys_region` VALUES ('520425', '2018-01-30 19:30:19', NULL, NULL, NULL, '紫云苗族布依族自治县', '贵州省安顺市紫云苗族布依族自治县', '3', 7, 'Z', NULL, '1', '550800', '520400');
INSERT INTO `sys_region` VALUES ('520500', '2018-01-30 19:30:19', NULL, NULL, NULL, '毕节市', '贵州省毕节市', '2', 5, 'B', NULL, '1', '551700', '520000');
INSERT INTO `sys_region` VALUES ('520501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '贵州省毕节市市辖区', '3', 1, 'S', NULL, '1', NULL, '520500');
INSERT INTO `sys_region` VALUES ('520502', '2018-01-30 19:30:19', NULL, NULL, NULL, '七星关区', '贵州省毕节市七星关区', '3', 2, 'Q', NULL, '1', '551700', '520500');
INSERT INTO `sys_region` VALUES ('520521', '2018-01-30 19:30:19', NULL, NULL, NULL, '大方县', '贵州省毕节市大方县', '3', 3, 'D', NULL, '1', '551600', '520500');
INSERT INTO `sys_region` VALUES ('520522', '2018-01-30 19:30:19', NULL, NULL, NULL, '黔西县', '贵州省毕节市黔西县', '3', 4, 'Q', NULL, '1', '551500', '520500');
INSERT INTO `sys_region` VALUES ('520523', '2018-01-30 19:30:19', NULL, NULL, NULL, '金沙县', '贵州省毕节市金沙县', '3', 5, 'J', NULL, '1', '551800', '520500');
INSERT INTO `sys_region` VALUES ('520524', '2018-01-30 19:30:19', NULL, NULL, NULL, '织金县', '贵州省毕节市织金县', '3', 6, 'Z', NULL, '1', '552100', '520500');
INSERT INTO `sys_region` VALUES ('520525', '2018-01-30 19:30:19', NULL, NULL, NULL, '纳雍县', '贵州省毕节市纳雍县', '3', 7, 'N', NULL, '1', '553300', '520500');
INSERT INTO `sys_region` VALUES ('520526', '2018-01-30 19:30:19', NULL, NULL, NULL, '威宁彝族回族苗族自治县', '贵州省毕节市威宁彝族回族苗族自治县', '3', 8, 'W', NULL, '1', '553100', '520500');
INSERT INTO `sys_region` VALUES ('520527', '2018-01-30 19:30:19', NULL, NULL, NULL, '赫章县', '贵州省毕节市赫章县', '3', 9, 'H', NULL, '1', '553200', '520500');
INSERT INTO `sys_region` VALUES ('520600', '2018-01-30 19:30:19', NULL, NULL, NULL, '铜仁市', '贵州省铜仁市', '2', 6, 'T', NULL, '1', '554300', '520000');
INSERT INTO `sys_region` VALUES ('520601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '贵州省铜仁市市辖区', '3', 1, 'S', NULL, '1', NULL, '520600');
INSERT INTO `sys_region` VALUES ('520602', '2018-01-30 19:30:19', NULL, NULL, NULL, '碧江区', '贵州省铜仁市碧江区', '3', 2, 'B', NULL, '1', '554300', '520600');
INSERT INTO `sys_region` VALUES ('520603', '2018-01-30 19:30:19', NULL, NULL, NULL, '万山区', '贵州省铜仁市万山区', '3', 3, 'W', NULL, '1', '554200', '520600');
INSERT INTO `sys_region` VALUES ('520621', '2018-01-30 19:30:19', NULL, NULL, NULL, '江口县', '贵州省铜仁市江口县', '3', 4, 'J', NULL, '1', '554400', '520600');
INSERT INTO `sys_region` VALUES ('520622', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉屏侗族自治县', '贵州省铜仁市玉屏侗族自治县', '3', 5, 'Y', NULL, '1', '554004', '520600');
INSERT INTO `sys_region` VALUES ('520623', '2018-01-30 19:30:19', NULL, NULL, NULL, '石阡县', '贵州省铜仁市石阡县', '3', 6, 'S', NULL, '1', '555100', '520600');
INSERT INTO `sys_region` VALUES ('520624', '2018-01-30 19:30:19', NULL, NULL, NULL, '思南县', '贵州省铜仁市思南县', '3', 7, 'S', NULL, '1', '565100', '520600');
INSERT INTO `sys_region` VALUES ('520625', '2018-01-30 19:30:19', NULL, NULL, NULL, '印江土家族苗族自治县', '贵州省铜仁市印江土家族苗族自治县', '3', 8, 'Y', NULL, '1', '555200', '520600');
INSERT INTO `sys_region` VALUES ('520626', '2018-01-30 19:30:19', NULL, NULL, NULL, '德江县', '贵州省铜仁市德江县', '3', 9, 'D', NULL, '1', '565200', '520600');
INSERT INTO `sys_region` VALUES ('520627', '2018-01-30 19:30:19', NULL, NULL, NULL, '沿河土家族自治县', '贵州省铜仁市沿河土家族自治县', '3', 10, 'Y', NULL, '1', '565300', '520600');
INSERT INTO `sys_region` VALUES ('520628', '2018-01-30 19:30:19', NULL, NULL, NULL, '松桃苗族自治县', '贵州省铜仁市松桃苗族自治县', '3', 11, 'S', NULL, '1', '554100', '520600');
INSERT INTO `sys_region` VALUES ('522300', '2018-01-30 19:30:19', NULL, NULL, NULL, '黔西南布依族苗族自治州', '贵州省黔西南布依族苗族自治州', '2', 7, 'Q', NULL, '1', '562400', '520000');
INSERT INTO `sys_region` VALUES ('522301', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴义市', '贵州省黔西南布依族苗族自治州兴义市', '3', 1, 'X', NULL, '1', '562400', '522300');
INSERT INTO `sys_region` VALUES ('522322', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴仁县', '贵州省黔西南布依族苗族自治州兴仁县', '3', 2, 'X', NULL, '1', '562300', '522300');
INSERT INTO `sys_region` VALUES ('522323', '2018-01-30 19:30:19', NULL, NULL, NULL, '普安县', '贵州省黔西南布依族苗族自治州普安县', '3', 3, 'P', NULL, '1', '561500', '522300');
INSERT INTO `sys_region` VALUES ('522324', '2018-01-30 19:30:19', NULL, NULL, NULL, '晴隆县', '贵州省黔西南布依族苗族自治州晴隆县', '3', 4, 'Q', NULL, '1', '561400', '522300');
INSERT INTO `sys_region` VALUES ('522325', '2018-01-30 19:30:19', NULL, NULL, NULL, '贞丰县', '贵州省黔西南布依族苗族自治州贞丰县', '3', 5, 'Z', NULL, '1', '562200', '522300');
INSERT INTO `sys_region` VALUES ('522326', '2018-01-30 19:30:19', NULL, NULL, NULL, '望谟县', '贵州省黔西南布依族苗族自治州望谟县', '3', 6, 'W', NULL, '1', '552300', '522300');
INSERT INTO `sys_region` VALUES ('522327', '2018-01-30 19:30:19', NULL, NULL, NULL, '册亨县', '贵州省黔西南布依族苗族自治州册亨县', '3', 7, 'C', NULL, '1', '552200', '522300');
INSERT INTO `sys_region` VALUES ('522328', '2018-01-30 19:30:19', NULL, NULL, NULL, '安龙县', '贵州省黔西南布依族苗族自治州安龙县', '3', 8, 'A', NULL, '1', '552400', '522300');
INSERT INTO `sys_region` VALUES ('522600', '2018-01-30 19:30:19', NULL, NULL, NULL, '黔东南苗族侗族自治州', '贵州省黔东南苗族侗族自治州', '2', 8, 'Q', NULL, '1', '556000', '520000');
INSERT INTO `sys_region` VALUES ('522601', '2018-01-30 19:30:19', NULL, NULL, NULL, '凯里市', '贵州省黔东南苗族侗族自治州凯里市', '3', 1, 'K', NULL, '1', '556000', '522600');
INSERT INTO `sys_region` VALUES ('522622', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄平县', '贵州省黔东南苗族侗族自治州黄平县', '3', 2, 'H', NULL, '1', '556100', '522600');
INSERT INTO `sys_region` VALUES ('522623', '2018-01-30 19:30:19', NULL, NULL, NULL, '施秉县', '贵州省黔东南苗族侗族自治州施秉县', '3', 3, 'S', NULL, '1', '556200', '522600');
INSERT INTO `sys_region` VALUES ('522624', '2018-01-30 19:30:19', NULL, NULL, NULL, '三穗县', '贵州省黔东南苗族侗族自治州三穗县', '3', 4, 'S', NULL, '1', '556500', '522600');
INSERT INTO `sys_region` VALUES ('522625', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇远县', '贵州省黔东南苗族侗族自治州镇远县', '3', 5, 'Z', NULL, '1', '557700', '522600');
INSERT INTO `sys_region` VALUES ('522626', '2018-01-30 19:30:19', NULL, NULL, NULL, '岑巩县', '贵州省黔东南苗族侗族自治州岑巩县', '3', 6, 'Z', NULL, '1', '557800', '522600');
INSERT INTO `sys_region` VALUES ('522627', '2018-01-30 19:30:19', NULL, NULL, NULL, '天柱县', '贵州省黔东南苗族侗族自治州天柱县', '3', 7, 'T', NULL, '1', '556600', '522600');
INSERT INTO `sys_region` VALUES ('522628', '2018-01-30 19:30:19', NULL, NULL, NULL, '锦屏县', '贵州省黔东南苗族侗族自治州锦屏县', '3', 8, 'J', NULL, '1', '556700', '522600');
INSERT INTO `sys_region` VALUES ('522629', '2018-01-30 19:30:19', NULL, NULL, NULL, '剑河县', '贵州省黔东南苗族侗族自治州剑河县', '3', 9, 'J', NULL, '1', '556400', '522600');
INSERT INTO `sys_region` VALUES ('522630', '2018-01-30 19:30:19', NULL, NULL, NULL, '台江县', '贵州省黔东南苗族侗族自治州台江县', '3', 10, 'T', NULL, '1', '556300', '522600');
INSERT INTO `sys_region` VALUES ('522631', '2018-01-30 19:30:19', NULL, NULL, NULL, '黎平县', '贵州省黔东南苗族侗族自治州黎平县', '3', 11, 'L', NULL, '1', '557300', '522600');
INSERT INTO `sys_region` VALUES ('522632', '2018-01-30 19:30:19', NULL, NULL, NULL, '榕江县', '贵州省黔东南苗族侗族自治州榕江县', '3', 12, 'Z', NULL, '1', '557200', '522600');
INSERT INTO `sys_region` VALUES ('522633', '2018-01-30 19:30:19', NULL, NULL, NULL, '从江县', '贵州省黔东南苗族侗族自治州从江县', '3', 13, 'C', NULL, '1', '557400', '522600');
INSERT INTO `sys_region` VALUES ('522634', '2018-01-30 19:30:19', NULL, NULL, NULL, '雷山县', '贵州省黔东南苗族侗族自治州雷山县', '3', 14, 'L', NULL, '1', '557100', '522600');
INSERT INTO `sys_region` VALUES ('522635', '2018-01-30 19:30:19', NULL, NULL, NULL, '麻江县', '贵州省黔东南苗族侗族自治州麻江县', '3', 15, 'M', NULL, '1', '557600', '522600');
INSERT INTO `sys_region` VALUES ('522636', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹寨县', '贵州省黔东南苗族侗族自治州丹寨县', '3', 16, 'D', NULL, '1', '557500', '522600');
INSERT INTO `sys_region` VALUES ('522700', '2018-01-30 19:30:19', NULL, NULL, NULL, '黔南布依族苗族自治州', '贵州省黔南布依族苗族自治州', '2', 9, 'Q', NULL, '1', '558000', '520000');
INSERT INTO `sys_region` VALUES ('522701', '2018-01-30 19:30:19', NULL, NULL, NULL, '都匀市', '贵州省黔南布依族苗族自治州都匀市', '3', 1, 'D', NULL, '1', '558000', '522700');
INSERT INTO `sys_region` VALUES ('522702', '2018-01-30 19:30:19', NULL, NULL, NULL, '福泉市', '贵州省黔南布依族苗族自治州福泉市', '3', 2, 'F', NULL, '1', '550500', '522700');
INSERT INTO `sys_region` VALUES ('522722', '2018-01-30 19:30:19', NULL, NULL, NULL, '荔波县', '贵州省黔南布依族苗族自治州荔波县', '3', 3, 'L', NULL, '1', '558400', '522700');
INSERT INTO `sys_region` VALUES ('522723', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵定县', '贵州省黔南布依族苗族自治州贵定县', '3', 4, 'G', NULL, '1', '551300', '522700');
INSERT INTO `sys_region` VALUES ('522725', '2018-01-30 19:30:19', NULL, NULL, NULL, '瓮安县', '贵州省黔南布依族苗族自治州瓮安县', '3', 5, 'W', NULL, '1', '550400', '522700');
INSERT INTO `sys_region` VALUES ('522726', '2018-01-30 19:30:19', NULL, NULL, NULL, '独山县', '贵州省黔南布依族苗族自治州独山县', '3', 6, 'D', NULL, '1', '558200', '522700');
INSERT INTO `sys_region` VALUES ('522727', '2018-01-30 19:30:19', NULL, NULL, NULL, '平塘县', '贵州省黔南布依族苗族自治州平塘县', '3', 7, 'P', NULL, '1', '558300', '522700');
INSERT INTO `sys_region` VALUES ('522728', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗甸县', '贵州省黔南布依族苗族自治州罗甸县', '3', 8, 'L', NULL, '1', '550100', '522700');
INSERT INTO `sys_region` VALUES ('522729', '2018-01-30 19:30:19', NULL, NULL, NULL, '长顺县', '贵州省黔南布依族苗族自治州长顺县', '3', 9, 'C', NULL, '1', '550700', '522700');
INSERT INTO `sys_region` VALUES ('522730', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙里县', '贵州省黔南布依族苗族自治州龙里县', '3', 10, 'L', NULL, '1', '551200', '522700');
INSERT INTO `sys_region` VALUES ('522731', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠水县', '贵州省黔南布依族苗族自治州惠水县', '3', 11, 'H', NULL, '1', '550600', '522700');
INSERT INTO `sys_region` VALUES ('522732', '2018-01-30 19:30:19', NULL, NULL, NULL, '三都水族自治县', '贵州省黔南布依族苗族自治州三都水族自治县', '3', 12, 'S', NULL, '1', '558100', '522700');
INSERT INTO `sys_region` VALUES ('530000', '2018-01-30 19:30:19', NULL, NULL, NULL, '云南省', '云南省', '1', 25, 'Y', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('530100', '2018-01-30 19:30:19', NULL, NULL, NULL, '昆明市', '云南省昆明市', '2', 1, 'K', NULL, '1', '650500', '530000');
INSERT INTO `sys_region` VALUES ('530101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省昆明市市辖区', '3', 1, 'S', NULL, '1', NULL, '530100');
INSERT INTO `sys_region` VALUES ('530102', '2018-01-30 19:30:19', NULL, NULL, NULL, '五华区', '云南省昆明市五华区', '3', 2, 'W', NULL, '1', '650021', '530100');
INSERT INTO `sys_region` VALUES ('530103', '2018-01-30 19:30:19', NULL, NULL, NULL, '盘龙区', '云南省昆明市盘龙区', '3', 3, 'P', NULL, '1', '650051', '530100');
INSERT INTO `sys_region` VALUES ('530111', '2018-01-30 19:30:19', NULL, NULL, NULL, '官渡区', '云南省昆明市官渡区', '3', 4, 'G', NULL, '1', '650200', '530100');
INSERT INTO `sys_region` VALUES ('530112', '2018-01-30 19:30:19', NULL, NULL, NULL, '西山区', '云南省昆明市西山区', '3', 5, 'X', NULL, '1', '650118', '530100');
INSERT INTO `sys_region` VALUES ('530113', '2018-01-30 19:30:19', NULL, NULL, NULL, '东川区', '云南省昆明市东川区', '3', 6, 'D', NULL, '1', '654100', '530100');
INSERT INTO `sys_region` VALUES ('530114', '2018-01-30 19:30:19', NULL, NULL, NULL, '呈贡区', '云南省昆明市呈贡区', '3', 7, 'C', NULL, '1', '650500', '530100');
INSERT INTO `sys_region` VALUES ('530122', '2018-01-30 19:30:19', NULL, NULL, NULL, '晋宁县', '云南省昆明市晋宁县', '3', 8, 'J', NULL, '1', '650600', '530100');
INSERT INTO `sys_region` VALUES ('530124', '2018-01-30 19:30:19', NULL, NULL, NULL, '富民县', '云南省昆明市富民县', '3', 9, 'F', NULL, '1', '650400', '530100');
INSERT INTO `sys_region` VALUES ('530125', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜良县', '云南省昆明市宜良县', '3', 10, 'Y', NULL, '1', '652100', '530100');
INSERT INTO `sys_region` VALUES ('530126', '2018-01-30 19:30:19', NULL, NULL, NULL, '石林彝族自治县', '云南省昆明市石林彝族自治县', '3', 11, 'S', NULL, '1', '652200', '530100');
INSERT INTO `sys_region` VALUES ('530127', '2018-01-30 19:30:19', NULL, NULL, NULL, '嵩明县', '云南省昆明市嵩明县', '3', 12, 'Z', NULL, '1', '651700', '530100');
INSERT INTO `sys_region` VALUES ('530128', '2018-01-30 19:30:19', NULL, NULL, NULL, '禄劝彝族苗族自治县', '云南省昆明市禄劝彝族苗族自治县', '3', 13, 'L', NULL, '1', '651500', '530100');
INSERT INTO `sys_region` VALUES ('530129', '2018-01-30 19:30:19', NULL, NULL, NULL, '寻甸回族彝族自治县', '云南省昆明市寻甸回族彝族自治县', '3', 14, 'X', NULL, '1', '655200', '530100');
INSERT INTO `sys_region` VALUES ('530181', '2018-01-30 19:30:19', NULL, NULL, NULL, '安宁市', '云南省昆明市安宁市', '3', 15, 'A', NULL, '1', '650300', '530100');
INSERT INTO `sys_region` VALUES ('530300', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲靖市', '云南省曲靖市', '2', 2, 'Q', NULL, '1', '655000', '530000');
INSERT INTO `sys_region` VALUES ('530301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省曲靖市市辖区', '3', 1, 'S', NULL, '1', NULL, '530300');
INSERT INTO `sys_region` VALUES ('530302', '2018-01-30 19:30:19', NULL, NULL, NULL, '麒麟区', '云南省曲靖市麒麟区', '3', 2, 'Z', NULL, '1', '655000', '530300');
INSERT INTO `sys_region` VALUES ('530303', '2018-01-30 19:30:19', NULL, NULL, NULL, '沾益区', '云南省曲靖市沾益区', '3', 3, 'Z', NULL, '1', NULL, '530300');
INSERT INTO `sys_region` VALUES ('530321', '2018-01-30 19:30:19', NULL, NULL, NULL, '马龙县', '云南省曲靖市马龙县', '3', 4, 'M', NULL, '1', '655100', '530300');
INSERT INTO `sys_region` VALUES ('530322', '2018-01-30 19:30:19', NULL, NULL, NULL, '陆良县', '云南省曲靖市陆良县', '3', 5, 'L', NULL, '1', '655600', '530300');
INSERT INTO `sys_region` VALUES ('530323', '2018-01-30 19:30:19', NULL, NULL, NULL, '师宗县', '云南省曲靖市师宗县', '3', 6, 'S', NULL, '1', '655700', '530300');
INSERT INTO `sys_region` VALUES ('530324', '2018-01-30 19:30:19', NULL, NULL, NULL, '罗平县', '云南省曲靖市罗平县', '3', 7, 'L', NULL, '1', '655800', '530300');
INSERT INTO `sys_region` VALUES ('530325', '2018-01-30 19:30:19', NULL, NULL, NULL, '富源县', '云南省曲靖市富源县', '3', 8, 'F', NULL, '1', '655500', '530300');
INSERT INTO `sys_region` VALUES ('530326', '2018-01-30 19:30:19', NULL, NULL, NULL, '会泽县', '云南省曲靖市会泽县', '3', 9, 'H', NULL, '1', '654200', '530300');
INSERT INTO `sys_region` VALUES ('530381', '2018-01-30 19:30:19', NULL, NULL, NULL, '宣威市', '云南省曲靖市宣威市', '3', 10, 'X', NULL, '1', '655400', '530300');
INSERT INTO `sys_region` VALUES ('530400', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉溪市', '云南省玉溪市', '2', 3, 'Y', NULL, '1', '653100', '530000');
INSERT INTO `sys_region` VALUES ('530401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省玉溪市市辖区', '3', 1, 'S', NULL, '1', NULL, '530400');
INSERT INTO `sys_region` VALUES ('530402', '2018-01-30 19:30:19', NULL, NULL, NULL, '红塔区', '云南省玉溪市红塔区', '3', 2, 'H', NULL, '1', '653100', '530400');
INSERT INTO `sys_region` VALUES ('530403', '2018-01-30 19:30:19', NULL, NULL, NULL, '江川区', '云南省玉溪市江川区', '3', 3, 'J', NULL, '1', NULL, '530400');
INSERT INTO `sys_region` VALUES ('530422', '2018-01-30 19:30:19', NULL, NULL, NULL, '澄江县', '云南省玉溪市澄江县', '3', 4, 'C', NULL, '1', '652500', '530400');
INSERT INTO `sys_region` VALUES ('530423', '2018-01-30 19:30:19', NULL, NULL, NULL, '通海县', '云南省玉溪市通海县', '3', 5, 'T', NULL, '1', '652700', '530400');
INSERT INTO `sys_region` VALUES ('530424', '2018-01-30 19:30:19', NULL, NULL, NULL, '华宁县', '云南省玉溪市华宁县', '3', 6, 'H', NULL, '1', '652800', '530400');
INSERT INTO `sys_region` VALUES ('530425', '2018-01-30 19:30:19', NULL, NULL, NULL, '易门县', '云南省玉溪市易门县', '3', 7, 'Y', NULL, '1', '651100', '530400');
INSERT INTO `sys_region` VALUES ('530426', '2018-01-30 19:30:19', NULL, NULL, NULL, '峨山彝族自治县', '云南省玉溪市峨山彝族自治县', '3', 8, 'E', NULL, '1', '653200', '530400');
INSERT INTO `sys_region` VALUES ('530427', '2018-01-30 19:30:19', NULL, NULL, NULL, '新平彝族傣族自治县', '云南省玉溪市新平彝族傣族自治县', '3', 9, 'X', NULL, '1', '653400', '530400');
INSERT INTO `sys_region` VALUES ('530428', '2018-01-30 19:30:19', NULL, NULL, NULL, '元江哈尼族彝族傣族自治县', '云南省玉溪市元江哈尼族彝族傣族自治县', '3', 10, 'Y', NULL, '1', '653300', '530400');
INSERT INTO `sys_region` VALUES ('530500', '2018-01-30 19:30:19', NULL, NULL, NULL, '保山市', '云南省保山市', '2', 4, 'B', NULL, '1', '678000', '530000');
INSERT INTO `sys_region` VALUES ('530501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省保山市市辖区', '3', 1, 'S', NULL, '1', NULL, '530500');
INSERT INTO `sys_region` VALUES ('530502', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆阳区', '云南省保山市隆阳区', '3', 2, 'L', NULL, '1', '678000', '530500');
INSERT INTO `sys_region` VALUES ('530521', '2018-01-30 19:30:19', NULL, NULL, NULL, '施甸县', '云南省保山市施甸县', '3', 3, 'S', NULL, '1', '678200', '530500');
INSERT INTO `sys_region` VALUES ('530523', '2018-01-30 19:30:19', NULL, NULL, NULL, '龙陵县', '云南省保山市龙陵县', '3', 4, 'L', NULL, '1', '678300', '530500');
INSERT INTO `sys_region` VALUES ('530524', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌宁县', '云南省保山市昌宁县', '3', 5, 'C', NULL, '1', '678100', '530500');
INSERT INTO `sys_region` VALUES ('530581', '2018-01-30 19:30:19', NULL, NULL, NULL, '腾冲市', '云南省保山市腾冲市', '3', 6, 'T', NULL, '1', NULL, '530500');
INSERT INTO `sys_region` VALUES ('530600', '2018-01-30 19:30:19', NULL, NULL, NULL, '昭通市', '云南省昭通市', '2', 5, 'Z', NULL, '1', '657000', '530000');
INSERT INTO `sys_region` VALUES ('530601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省昭通市市辖区', '3', 1, 'S', NULL, '1', NULL, '530600');
INSERT INTO `sys_region` VALUES ('530602', '2018-01-30 19:30:19', NULL, NULL, NULL, '昭阳区', '云南省昭通市昭阳区', '3', 2, 'Z', NULL, '1', '657000', '530600');
INSERT INTO `sys_region` VALUES ('530621', '2018-01-30 19:30:19', NULL, NULL, NULL, '鲁甸县', '云南省昭通市鲁甸县', '3', 3, 'L', NULL, '1', '657100', '530600');
INSERT INTO `sys_region` VALUES ('530622', '2018-01-30 19:30:19', NULL, NULL, NULL, '巧家县', '云南省昭通市巧家县', '3', 4, 'Q', NULL, '1', '654600', '530600');
INSERT INTO `sys_region` VALUES ('530623', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐津县', '云南省昭通市盐津县', '3', 5, 'Y', NULL, '1', '657500', '530600');
INSERT INTO `sys_region` VALUES ('530624', '2018-01-30 19:30:19', NULL, NULL, NULL, '大关县', '云南省昭通市大关县', '3', 6, 'D', NULL, '1', '657400', '530600');
INSERT INTO `sys_region` VALUES ('530625', '2018-01-30 19:30:19', NULL, NULL, NULL, '永善县', '云南省昭通市永善县', '3', 7, 'Y', NULL, '1', '657300', '530600');
INSERT INTO `sys_region` VALUES ('530626', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥江县', '云南省昭通市绥江县', '3', 8, 'S', NULL, '1', '657700', '530600');
INSERT INTO `sys_region` VALUES ('530627', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇雄县', '云南省昭通市镇雄县', '3', 9, 'Z', NULL, '1', '657200', '530600');
INSERT INTO `sys_region` VALUES ('530628', '2018-01-30 19:30:19', NULL, NULL, NULL, '彝良县', '云南省昭通市彝良县', '3', 10, 'Y', NULL, '1', '657600', '530600');
INSERT INTO `sys_region` VALUES ('530629', '2018-01-30 19:30:19', NULL, NULL, NULL, '威信县', '云南省昭通市威信县', '3', 11, 'W', NULL, '1', '657900', '530600');
INSERT INTO `sys_region` VALUES ('530630', '2018-01-30 19:30:19', NULL, NULL, NULL, '水富县', '云南省昭通市水富县', '3', 12, 'S', NULL, '1', '657800', '530600');
INSERT INTO `sys_region` VALUES ('530700', '2018-01-30 19:30:19', NULL, NULL, NULL, '丽江市', '云南省丽江市', '2', 6, 'L', NULL, '1', '674100', '530000');
INSERT INTO `sys_region` VALUES ('530701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省丽江市市辖区', '3', 1, 'S', NULL, '1', NULL, '530700');
INSERT INTO `sys_region` VALUES ('530702', '2018-01-30 19:30:19', NULL, NULL, NULL, '古城区', '云南省丽江市古城区', '3', 2, 'G', NULL, '1', '674100', '530700');
INSERT INTO `sys_region` VALUES ('530721', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉龙纳西族自治县', '云南省丽江市玉龙纳西族自治县', '3', 3, 'Y', NULL, '1', '674100', '530700');
INSERT INTO `sys_region` VALUES ('530722', '2018-01-30 19:30:19', NULL, NULL, NULL, '永胜县', '云南省丽江市永胜县', '3', 4, 'Y', NULL, '1', '674200', '530700');
INSERT INTO `sys_region` VALUES ('530723', '2018-01-30 19:30:19', NULL, NULL, NULL, '华坪县', '云南省丽江市华坪县', '3', 5, 'H', NULL, '1', '674800', '530700');
INSERT INTO `sys_region` VALUES ('530724', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁蒗彝族自治县', '云南省丽江市宁蒗彝族自治县', '3', 6, 'N', NULL, '1', '674300', '530700');
INSERT INTO `sys_region` VALUES ('530800', '2018-01-30 19:30:19', NULL, NULL, NULL, '普洱市', '云南省普洱市', '2', 7, 'P', NULL, '1', '665000', '530000');
INSERT INTO `sys_region` VALUES ('530801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省普洱市市辖区', '3', 1, 'S', NULL, '1', NULL, '530800');
INSERT INTO `sys_region` VALUES ('530802', '2018-01-30 19:30:19', NULL, NULL, NULL, '思茅区', '云南省普洱市思茅区', '3', 2, 'S', NULL, '1', '665000', '530800');
INSERT INTO `sys_region` VALUES ('530821', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁洱哈尼族彝族自治县', '云南省普洱市宁洱哈尼族彝族自治县', '3', 3, 'N', NULL, '1', '665100', '530800');
INSERT INTO `sys_region` VALUES ('530822', '2018-01-30 19:30:19', NULL, NULL, NULL, '墨江哈尼族自治县', '云南省普洱市墨江哈尼族自治县', '3', 4, 'M', NULL, '1', '654800', '530800');
INSERT INTO `sys_region` VALUES ('530823', '2018-01-30 19:30:19', NULL, NULL, NULL, '景东彝族自治县', '云南省普洱市景东彝族自治县', '3', 5, 'J', NULL, '1', '676200', '530800');
INSERT INTO `sys_region` VALUES ('530824', '2018-01-30 19:30:19', NULL, NULL, NULL, '景谷傣族彝族自治县', '云南省普洱市景谷傣族彝族自治县', '3', 6, 'J', NULL, '1', '666400', '530800');
INSERT INTO `sys_region` VALUES ('530825', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇沅彝族哈尼族拉祜族自治县', '云南省普洱市镇沅彝族哈尼族拉祜族自治县', '3', 7, 'Z', NULL, '1', '666500', '530800');
INSERT INTO `sys_region` VALUES ('530826', '2018-01-30 19:30:19', NULL, NULL, NULL, '江城哈尼族彝族自治县', '云南省普洱市江城哈尼族彝族自治县', '3', 8, 'J', NULL, '1', '665900', '530800');
INSERT INTO `sys_region` VALUES ('530827', '2018-01-30 19:30:19', NULL, NULL, NULL, '孟连傣族拉祜族佤族自治县', '云南省普洱市孟连傣族拉祜族佤族自治县', '3', 9, 'M', NULL, '1', '665800', '530800');
INSERT INTO `sys_region` VALUES ('530828', '2018-01-30 19:30:19', NULL, NULL, NULL, '澜沧拉祜族自治县', '云南省普洱市澜沧拉祜族自治县', '3', 10, 'L', NULL, '1', '665600', '530800');
INSERT INTO `sys_region` VALUES ('530829', '2018-01-30 19:30:19', NULL, NULL, NULL, '西盟佤族自治县', '云南省普洱市西盟佤族自治县', '3', 11, 'X', NULL, '1', '665700', '530800');
INSERT INTO `sys_region` VALUES ('530900', '2018-01-30 19:30:19', NULL, NULL, NULL, '临沧市', '云南省临沧市', '2', 8, 'L', NULL, '1', '677000', '530000');
INSERT INTO `sys_region` VALUES ('530901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '云南省临沧市市辖区', '3', 1, 'S', NULL, '1', NULL, '530900');
INSERT INTO `sys_region` VALUES ('530902', '2018-01-30 19:30:19', NULL, NULL, NULL, '临翔区', '云南省临沧市临翔区', '3', 2, 'L', NULL, '1', '677000', '530900');
INSERT INTO `sys_region` VALUES ('530921', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤庆县', '云南省临沧市凤庆县', '3', 3, 'F', NULL, '1', '675900', '530900');
INSERT INTO `sys_region` VALUES ('530922', '2018-01-30 19:30:19', NULL, NULL, NULL, '云县', '云南省临沧市云县', '3', 4, 'Y', NULL, '1', '675800', '530900');
INSERT INTO `sys_region` VALUES ('530923', '2018-01-30 19:30:19', NULL, NULL, NULL, '永德县', '云南省临沧市永德县', '3', 5, 'Y', NULL, '1', '677600', '530900');
INSERT INTO `sys_region` VALUES ('530924', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇康县', '云南省临沧市镇康县', '3', 6, 'Z', NULL, '1', '677704', '530900');
INSERT INTO `sys_region` VALUES ('530925', '2018-01-30 19:30:19', NULL, NULL, NULL, '双江拉祜族佤族布朗族傣族自治县', '云南省临沧市双江拉祜族佤族布朗族傣族自治县', '3', 7, 'S', NULL, '1', '677300', '530900');
INSERT INTO `sys_region` VALUES ('530926', '2018-01-30 19:30:19', NULL, NULL, NULL, '耿马傣族佤族自治县', '云南省临沧市耿马傣族佤族自治县', '3', 8, 'G', NULL, '1', '677500', '530900');
INSERT INTO `sys_region` VALUES ('530927', '2018-01-30 19:30:19', NULL, NULL, NULL, '沧源佤族自治县', '云南省临沧市沧源佤族自治县', '3', 9, 'C', NULL, '1', '677400', '530900');
INSERT INTO `sys_region` VALUES ('532300', '2018-01-30 19:30:19', NULL, NULL, NULL, '楚雄彝族自治州', '云南省楚雄彝族自治州', '2', 9, 'C', NULL, '1', '675000', '530000');
INSERT INTO `sys_region` VALUES ('532301', '2018-01-30 19:30:19', NULL, NULL, NULL, '楚雄市', '云南省楚雄彝族自治州楚雄市', '3', 1, 'C', NULL, '1', '675000', '532300');
INSERT INTO `sys_region` VALUES ('532322', '2018-01-30 19:30:19', NULL, NULL, NULL, '双柏县', '云南省楚雄彝族自治州双柏县', '3', 2, 'S', NULL, '1', '675100', '532300');
INSERT INTO `sys_region` VALUES ('532323', '2018-01-30 19:30:19', NULL, NULL, NULL, '牟定县', '云南省楚雄彝族自治州牟定县', '3', 3, 'M', NULL, '1', '675500', '532300');
INSERT INTO `sys_region` VALUES ('532324', '2018-01-30 19:30:19', NULL, NULL, NULL, '南华县', '云南省楚雄彝族自治州南华县', '3', 4, 'N', NULL, '1', '675200', '532300');
INSERT INTO `sys_region` VALUES ('532325', '2018-01-30 19:30:19', NULL, NULL, NULL, '姚安县', '云南省楚雄彝族自治州姚安县', '3', 5, 'Y', NULL, '1', '675300', '532300');
INSERT INTO `sys_region` VALUES ('532326', '2018-01-30 19:30:19', NULL, NULL, NULL, '大姚县', '云南省楚雄彝族自治州大姚县', '3', 6, 'D', NULL, '1', '675400', '532300');
INSERT INTO `sys_region` VALUES ('532327', '2018-01-30 19:30:19', NULL, NULL, NULL, '永仁县', '云南省楚雄彝族自治州永仁县', '3', 7, 'Y', NULL, '1', '651400', '532300');
INSERT INTO `sys_region` VALUES ('532328', '2018-01-30 19:30:19', NULL, NULL, NULL, '元谋县', '云南省楚雄彝族自治州元谋县', '3', 8, 'Y', NULL, '1', '651300', '532300');
INSERT INTO `sys_region` VALUES ('532329', '2018-01-30 19:30:19', NULL, NULL, NULL, '武定县', '云南省楚雄彝族自治州武定县', '3', 9, 'W', NULL, '1', '651600', '532300');
INSERT INTO `sys_region` VALUES ('532331', '2018-01-30 19:30:19', NULL, NULL, NULL, '禄丰县', '云南省楚雄彝族自治州禄丰县', '3', 10, 'L', NULL, '1', '651200', '532300');
INSERT INTO `sys_region` VALUES ('532500', '2018-01-30 19:30:19', NULL, NULL, NULL, '红河哈尼族彝族自治州', '云南省红河哈尼族彝族自治州', '2', 10, 'H', NULL, '1', '661400', '530000');
INSERT INTO `sys_region` VALUES ('532501', '2018-01-30 19:30:19', NULL, NULL, NULL, '个旧市', '云南省红河哈尼族彝族自治州个旧市', '3', 1, 'G', NULL, '1', '661000', '532500');
INSERT INTO `sys_region` VALUES ('532502', '2018-01-30 19:30:19', NULL, NULL, NULL, '开远市', '云南省红河哈尼族彝族自治州开远市', '3', 2, 'K', NULL, '1', '661600', '532500');
INSERT INTO `sys_region` VALUES ('532503', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒙自市', '云南省红河哈尼族彝族自治州蒙自市', '3', 3, 'M', NULL, '1', '661101', '532500');
INSERT INTO `sys_region` VALUES ('532504', '2018-01-30 19:30:19', NULL, NULL, NULL, '弥勒市', '云南省红河哈尼族彝族自治州弥勒市', '3', 4, 'M', NULL, '1', '652300', '532500');
INSERT INTO `sys_region` VALUES ('532523', '2018-01-30 19:30:19', NULL, NULL, NULL, '屏边苗族自治县', '云南省红河哈尼族彝族自治州屏边苗族自治县', '3', 5, 'P', NULL, '1', '661200', '532500');
INSERT INTO `sys_region` VALUES ('532524', '2018-01-30 19:30:19', NULL, NULL, NULL, '建水县', '云南省红河哈尼族彝族自治州建水县', '3', 6, 'J', NULL, '1', '654300', '532500');
INSERT INTO `sys_region` VALUES ('532525', '2018-01-30 19:30:19', NULL, NULL, NULL, '石屏县', '云南省红河哈尼族彝族自治州石屏县', '3', 7, 'S', NULL, '1', '662200', '532500');
INSERT INTO `sys_region` VALUES ('532527', '2018-01-30 19:30:19', NULL, NULL, NULL, '泸西县', '云南省红河哈尼族彝族自治州泸西县', '3', 8, 'Z', NULL, '1', '652400', '532500');
INSERT INTO `sys_region` VALUES ('532528', '2018-01-30 19:30:19', NULL, NULL, NULL, '元阳县', '云南省红河哈尼族彝族自治州元阳县', '3', 9, 'Y', NULL, '1', '662400', '532500');
INSERT INTO `sys_region` VALUES ('532529', '2018-01-30 19:30:19', NULL, NULL, NULL, '红河县', '云南省红河哈尼族彝族自治州红河县', '3', 10, 'H', NULL, '1', '654400', '532500');
INSERT INTO `sys_region` VALUES ('532530', '2018-01-30 19:30:19', NULL, NULL, NULL, '金平苗族瑶族傣族自治县', '云南省红河哈尼族彝族自治州金平苗族瑶族傣族自治县', '3', 11, 'J', NULL, '1', '661500', '532500');
INSERT INTO `sys_region` VALUES ('532531', '2018-01-30 19:30:19', NULL, NULL, NULL, '绿春县', '云南省红河哈尼族彝族自治州绿春县', '3', 12, 'L', NULL, '1', '662500', '532500');
INSERT INTO `sys_region` VALUES ('532532', '2018-01-30 19:30:19', NULL, NULL, NULL, '河口瑶族自治县', '云南省红河哈尼族彝族自治州河口瑶族自治县', '3', 13, 'H', NULL, '1', '661300', '532500');
INSERT INTO `sys_region` VALUES ('532600', '2018-01-30 19:30:19', NULL, NULL, NULL, '文山壮族苗族自治州', '云南省文山壮族苗族自治州', '2', 11, 'W', NULL, '1', '663000', '530000');
INSERT INTO `sys_region` VALUES ('532601', '2018-01-30 19:30:19', NULL, NULL, NULL, '文山市', '云南省文山壮族苗族自治州文山市', '3', 1, 'W', NULL, '1', '663000', '532600');
INSERT INTO `sys_region` VALUES ('532622', '2018-01-30 19:30:19', NULL, NULL, NULL, '砚山县', '云南省文山壮族苗族自治州砚山县', '3', 2, 'Y', NULL, '1', '663100', '532600');
INSERT INTO `sys_region` VALUES ('532623', '2018-01-30 19:30:19', NULL, NULL, NULL, '西畴县', '云南省文山壮族苗族自治州西畴县', '3', 3, 'X', NULL, '1', '663500', '532600');
INSERT INTO `sys_region` VALUES ('532624', '2018-01-30 19:30:19', NULL, NULL, NULL, '麻栗坡县', '云南省文山壮族苗族自治州麻栗坡县', '3', 4, 'M', NULL, '1', '663600', '532600');
INSERT INTO `sys_region` VALUES ('532625', '2018-01-30 19:30:19', NULL, NULL, NULL, '马关县', '云南省文山壮族苗族自治州马关县', '3', 5, 'M', NULL, '1', '663700', '532600');
INSERT INTO `sys_region` VALUES ('532626', '2018-01-30 19:30:19', NULL, NULL, NULL, '丘北县', '云南省文山壮族苗族自治州丘北县', '3', 6, 'Q', NULL, '1', '663200', '532600');
INSERT INTO `sys_region` VALUES ('532627', '2018-01-30 19:30:19', NULL, NULL, NULL, '广南县', '云南省文山壮族苗族自治州广南县', '3', 7, 'G', NULL, '1', '663300', '532600');
INSERT INTO `sys_region` VALUES ('532628', '2018-01-30 19:30:19', NULL, NULL, NULL, '富宁县', '云南省文山壮族苗族自治州富宁县', '3', 8, 'F', NULL, '1', '663400', '532600');
INSERT INTO `sys_region` VALUES ('532800', '2018-01-30 19:30:19', NULL, NULL, NULL, '西双版纳傣族自治州', '云南省西双版纳傣族自治州', '2', 12, 'X', NULL, '1', '666100', '530000');
INSERT INTO `sys_region` VALUES ('532801', '2018-01-30 19:30:19', NULL, NULL, NULL, '景洪市', '云南省西双版纳傣族自治州景洪市', '3', 1, 'J', NULL, '1', '666100', '532800');
INSERT INTO `sys_region` VALUES ('532822', '2018-01-30 19:30:19', NULL, NULL, NULL, '勐海县', '云南省西双版纳傣族自治州勐海县', '3', 2, 'Z', NULL, '1', '666200', '532800');
INSERT INTO `sys_region` VALUES ('532823', '2018-01-30 19:30:19', NULL, NULL, NULL, '勐腊县', '云南省西双版纳傣族自治州勐腊县', '3', 3, 'Z', NULL, '1', '666300', '532800');
INSERT INTO `sys_region` VALUES ('532900', '2018-01-30 19:30:19', NULL, NULL, NULL, '大理白族自治州', '云南省大理白族自治州', '2', 13, 'D', NULL, '1', '671000', '530000');
INSERT INTO `sys_region` VALUES ('532901', '2018-01-30 19:30:19', NULL, NULL, NULL, '大理市', '云南省大理白族自治州大理市', '3', 1, 'D', NULL, '1', '671000', '532900');
INSERT INTO `sys_region` VALUES ('532922', '2018-01-30 19:30:19', NULL, NULL, NULL, '漾濞彝族自治县', '云南省大理白族自治州漾濞彝族自治县', '3', 2, 'Y', NULL, '1', '672500', '532900');
INSERT INTO `sys_region` VALUES ('532923', '2018-01-30 19:30:19', NULL, NULL, NULL, '祥云县', '云南省大理白族自治州祥云县', '3', 3, 'X', NULL, '1', '672100', '532900');
INSERT INTO `sys_region` VALUES ('532924', '2018-01-30 19:30:19', NULL, NULL, NULL, '宾川县', '云南省大理白族自治州宾川县', '3', 4, 'B', NULL, '1', '671600', '532900');
INSERT INTO `sys_region` VALUES ('532925', '2018-01-30 19:30:19', NULL, NULL, NULL, '弥渡县', '云南省大理白族自治州弥渡县', '3', 5, 'M', NULL, '1', '675600', '532900');
INSERT INTO `sys_region` VALUES ('532926', '2018-01-30 19:30:19', NULL, NULL, NULL, '南涧彝族自治县', '云南省大理白族自治州南涧彝族自治县', '3', 6, 'N', NULL, '1', '675700', '532900');
INSERT INTO `sys_region` VALUES ('532927', '2018-01-30 19:30:19', NULL, NULL, NULL, '巍山彝族回族自治县', '云南省大理白族自治州巍山彝族回族自治县', '3', 7, 'W', NULL, '1', '672400', '532900');
INSERT INTO `sys_region` VALUES ('532928', '2018-01-30 19:30:19', NULL, NULL, NULL, '永平县', '云南省大理白族自治州永平县', '3', 8, 'Y', NULL, '1', '672600', '532900');
INSERT INTO `sys_region` VALUES ('532929', '2018-01-30 19:30:19', NULL, NULL, NULL, '云龙县', '云南省大理白族自治州云龙县', '3', 9, 'Y', NULL, '1', '672700', '532900');
INSERT INTO `sys_region` VALUES ('532930', '2018-01-30 19:30:19', NULL, NULL, NULL, '洱源县', '云南省大理白族自治州洱源县', '3', 10, 'E', NULL, '1', '671200', '532900');
INSERT INTO `sys_region` VALUES ('532931', '2018-01-30 19:30:19', NULL, NULL, NULL, '剑川县', '云南省大理白族自治州剑川县', '3', 11, 'J', NULL, '1', '671300', '532900');
INSERT INTO `sys_region` VALUES ('532932', '2018-01-30 19:30:19', NULL, NULL, NULL, '鹤庆县', '云南省大理白族自治州鹤庆县', '3', 12, 'H', NULL, '1', '671500', '532900');
INSERT INTO `sys_region` VALUES ('533100', '2018-01-30 19:30:19', NULL, NULL, NULL, '德宏傣族景颇族自治州', '云南省德宏傣族景颇族自治州', '2', 14, 'D', NULL, '1', '678400', '530000');
INSERT INTO `sys_region` VALUES ('533102', '2018-01-30 19:30:19', NULL, NULL, NULL, '瑞丽市', '云南省德宏傣族景颇族自治州瑞丽市', '3', 1, 'R', NULL, '1', '678600', '533100');
INSERT INTO `sys_region` VALUES ('533103', '2018-01-30 19:30:19', NULL, NULL, NULL, '芒市', '云南省德宏傣族景颇族自治州芒市', '3', 2, 'M', NULL, '1', '678400', '533100');
INSERT INTO `sys_region` VALUES ('533122', '2018-01-30 19:30:19', NULL, NULL, NULL, '梁河县', '云南省德宏傣族景颇族自治州梁河县', '3', 3, 'L', NULL, '1', '679200', '533100');
INSERT INTO `sys_region` VALUES ('533123', '2018-01-30 19:30:19', NULL, NULL, NULL, '盈江县', '云南省德宏傣族景颇族自治州盈江县', '3', 4, 'Y', NULL, '1', '679300', '533100');
INSERT INTO `sys_region` VALUES ('533124', '2018-01-30 19:30:19', NULL, NULL, NULL, '陇川县', '云南省德宏傣族景颇族自治州陇川县', '3', 5, 'L', NULL, '1', '678700', '533100');
INSERT INTO `sys_region` VALUES ('533300', '2018-01-30 19:30:19', NULL, NULL, NULL, '怒江傈僳族自治州', '云南省怒江傈僳族自治州', '2', 15, 'N', NULL, '1', '673100', '530000');
INSERT INTO `sys_region` VALUES ('533301', '2018-01-30 19:30:19', NULL, NULL, NULL, '泸水市', '云南省怒江傈僳族自治州泸水市', '3', 1, 'Z', NULL, '1', NULL, '533300');
INSERT INTO `sys_region` VALUES ('533323', '2018-01-30 19:30:19', NULL, NULL, NULL, '福贡县', '云南省怒江傈僳族自治州福贡县', '3', 2, 'F', NULL, '1', '673400', '533300');
INSERT INTO `sys_region` VALUES ('533324', '2018-01-30 19:30:19', NULL, NULL, NULL, '贡山独龙族怒族自治县', '云南省怒江傈僳族自治州贡山独龙族怒族自治县', '3', 3, 'G', NULL, '1', '673500', '533300');
INSERT INTO `sys_region` VALUES ('533325', '2018-01-30 19:30:19', NULL, NULL, NULL, '兰坪白族普米族自治县', '云南省怒江傈僳族自治州兰坪白族普米族自治县', '3', 4, 'L', NULL, '1', '671400', '533300');
INSERT INTO `sys_region` VALUES ('533400', '2018-01-30 19:30:19', NULL, NULL, NULL, '迪庆藏族自治州', '云南省迪庆藏族自治州', '2', 16, 'D', NULL, '1', '674400', '530000');
INSERT INTO `sys_region` VALUES ('533401', '2018-01-30 19:30:19', NULL, NULL, NULL, '香格里拉市', '云南省迪庆藏族自治州香格里拉市', '3', 1, 'X', NULL, '1', NULL, '533400');
INSERT INTO `sys_region` VALUES ('533422', '2018-01-30 19:30:19', NULL, NULL, NULL, '德钦县', '云南省迪庆藏族自治州德钦县', '3', 2, 'D', NULL, '1', '674500', '533400');
INSERT INTO `sys_region` VALUES ('533423', '2018-01-30 19:30:19', NULL, NULL, NULL, '维西傈僳族自治县', '云南省迪庆藏族自治州维西傈僳族自治县', '3', 3, 'W', NULL, '1', '674600', '533400');
INSERT INTO `sys_region` VALUES ('540000', '2018-01-30 19:30:19', NULL, NULL, NULL, '西藏自治区', '西藏自治区', '1', 26, 'X', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('540100', '2018-01-30 19:30:19', NULL, NULL, NULL, '拉萨市', '西藏自治区拉萨市', '2', 1, 'L', NULL, '1', '850000', '540000');
INSERT INTO `sys_region` VALUES ('540101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '西藏自治区拉萨市市辖区', '3', 1, 'S', NULL, '1', NULL, '540100');
INSERT INTO `sys_region` VALUES ('540102', '2018-01-30 19:30:19', NULL, NULL, NULL, '城关区', '西藏自治区拉萨市城关区', '3', 2, 'C', NULL, '1', '850000', '540100');
INSERT INTO `sys_region` VALUES ('540103', '2018-01-30 19:30:19', NULL, NULL, NULL, '堆龙德庆区', '西藏自治区拉萨市堆龙德庆区', '3', 3, 'D', NULL, '1', NULL, '540100');
INSERT INTO `sys_region` VALUES ('540121', '2018-01-30 19:30:19', NULL, NULL, NULL, '林周县', '西藏自治区拉萨市林周县', '3', 4, 'L', NULL, '1', '851600', '540100');
INSERT INTO `sys_region` VALUES ('540122', '2018-01-30 19:30:19', NULL, NULL, NULL, '当雄县', '西藏自治区拉萨市当雄县', '3', 5, 'D', NULL, '1', '851500', '540100');
INSERT INTO `sys_region` VALUES ('540123', '2018-01-30 19:30:19', NULL, NULL, NULL, '尼木县', '西藏自治区拉萨市尼木县', '3', 6, 'N', NULL, '1', '851300', '540100');
INSERT INTO `sys_region` VALUES ('540124', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲水县', '西藏自治区拉萨市曲水县', '3', 7, 'Q', NULL, '1', '850600', '540100');
INSERT INTO `sys_region` VALUES ('540126', '2018-01-30 19:30:19', NULL, NULL, NULL, '达孜县', '西藏自治区拉萨市达孜县', '3', 8, 'D', NULL, '1', '850100', '540100');
INSERT INTO `sys_region` VALUES ('540127', '2018-01-30 19:30:19', NULL, NULL, NULL, '墨竹工卡县', '西藏自治区拉萨市墨竹工卡县', '3', 9, 'M', NULL, '1', '850200', '540100');
INSERT INTO `sys_region` VALUES ('540200', '2018-01-30 19:30:19', NULL, NULL, NULL, '日喀则市', '西藏自治区日喀则市', '2', 2, 'R', NULL, '1', '857000', '540000');
INSERT INTO `sys_region` VALUES ('540202', '2018-01-30 19:30:19', NULL, NULL, NULL, '桑珠孜区', '西藏自治区日喀则市桑珠孜区', '3', 1, 'S', NULL, '1', '857000', '540200');
INSERT INTO `sys_region` VALUES ('540221', '2018-01-30 19:30:19', NULL, NULL, NULL, '南木林县', '西藏自治区日喀则市南木林县', '3', 2, 'N', NULL, '1', '857100', '540200');
INSERT INTO `sys_region` VALUES ('540222', '2018-01-30 19:30:19', NULL, NULL, NULL, '江孜县', '西藏自治区日喀则市江孜县', '3', 3, 'J', NULL, '1', '857400', '540200');
INSERT INTO `sys_region` VALUES ('540223', '2018-01-30 19:30:19', NULL, NULL, NULL, '定日县', '西藏自治区日喀则市定日县', '3', 4, 'D', NULL, '1', '858200', '540200');
INSERT INTO `sys_region` VALUES ('540224', '2018-01-30 19:30:19', NULL, NULL, NULL, '萨迦县', '西藏自治区日喀则市萨迦县', '3', 5, 'S', NULL, '1', '857800', '540200');
INSERT INTO `sys_region` VALUES ('540225', '2018-01-30 19:30:19', NULL, NULL, NULL, '拉孜县', '西藏自治区日喀则市拉孜县', '3', 6, 'L', NULL, '1', '858100', '540200');
INSERT INTO `sys_region` VALUES ('540226', '2018-01-30 19:30:19', NULL, NULL, NULL, '昂仁县', '西藏自治区日喀则市昂仁县', '3', 7, 'A', NULL, '1', '858500', '540200');
INSERT INTO `sys_region` VALUES ('540227', '2018-01-30 19:30:19', NULL, NULL, NULL, '谢通门县', '西藏自治区日喀则市谢通门县', '3', 8, 'X', NULL, '1', '858900', '540200');
INSERT INTO `sys_region` VALUES ('540228', '2018-01-30 19:30:19', NULL, NULL, NULL, '白朗县', '西藏自治区日喀则市白朗县', '3', 9, 'B', NULL, '1', '857300', '540200');
INSERT INTO `sys_region` VALUES ('540229', '2018-01-30 19:30:19', NULL, NULL, NULL, '仁布县', '西藏自治区日喀则市仁布县', '3', 10, 'R', NULL, '1', '857200', '540200');
INSERT INTO `sys_region` VALUES ('540230', '2018-01-30 19:30:19', NULL, NULL, NULL, '康马县', '西藏自治区日喀则市康马县', '3', 11, 'K', NULL, '1', '857500', '540200');
INSERT INTO `sys_region` VALUES ('540231', '2018-01-30 19:30:19', NULL, NULL, NULL, '定结县', '西藏自治区日喀则市定结县', '3', 12, 'D', NULL, '1', '857900', '540200');
INSERT INTO `sys_region` VALUES ('540232', '2018-01-30 19:30:19', NULL, NULL, NULL, '仲巴县', '西藏自治区日喀则市仲巴县', '3', 13, 'Z', NULL, '1', '858800', '540200');
INSERT INTO `sys_region` VALUES ('540233', '2018-01-30 19:30:19', NULL, NULL, NULL, '亚东县', '西藏自治区日喀则市亚东县', '3', 14, 'Y', NULL, '1', '857600', '540200');
INSERT INTO `sys_region` VALUES ('540234', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉隆县', '西藏自治区日喀则市吉隆县', '3', 15, 'J', NULL, '1', '858700', '540200');
INSERT INTO `sys_region` VALUES ('540235', '2018-01-30 19:30:19', NULL, NULL, NULL, '聂拉木县', '西藏自治区日喀则市聂拉木县', '3', 16, 'N', NULL, '1', '858300', '540200');
INSERT INTO `sys_region` VALUES ('540236', '2018-01-30 19:30:19', NULL, NULL, NULL, '萨嘎县', '西藏自治区日喀则市萨嘎县', '3', 17, 'S', NULL, '1', '857800', '540200');
INSERT INTO `sys_region` VALUES ('540237', '2018-01-30 19:30:19', NULL, NULL, NULL, '岗巴县', '西藏自治区日喀则市岗巴县', '3', 18, 'G', NULL, '1', '857700', '540200');
INSERT INTO `sys_region` VALUES ('540300', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌都市', '西藏自治区昌都市', '2', 3, 'C', NULL, '1', '854000', '540000');
INSERT INTO `sys_region` VALUES ('540302', '2018-01-30 19:30:19', NULL, NULL, NULL, '卡若区', '西藏自治区昌都市卡若区', '3', 1, 'K', NULL, '1', '854000', '540300');
INSERT INTO `sys_region` VALUES ('540321', '2018-01-30 19:30:19', NULL, NULL, NULL, '江达县', '西藏自治区昌都市江达县', '3', 2, 'J', NULL, '1', '854100', '540300');
INSERT INTO `sys_region` VALUES ('540322', '2018-01-30 19:30:19', NULL, NULL, NULL, '贡觉县', '西藏自治区昌都市贡觉县', '3', 3, 'G', NULL, '1', '854200', '540300');
INSERT INTO `sys_region` VALUES ('540323', '2018-01-30 19:30:19', NULL, NULL, NULL, '类乌齐县', '西藏自治区昌都市类乌齐县', '3', 4, 'L', NULL, '1', '855600', '540300');
INSERT INTO `sys_region` VALUES ('540324', '2018-01-30 19:30:19', NULL, NULL, NULL, '丁青县', '西藏自治区昌都市丁青县', '3', 5, 'D', NULL, '1', '855700', '540300');
INSERT INTO `sys_region` VALUES ('540325', '2018-01-30 19:30:19', NULL, NULL, NULL, '察雅县', '西藏自治区昌都市察雅县', '3', 6, 'C', NULL, '1', '854300', '540300');
INSERT INTO `sys_region` VALUES ('540326', '2018-01-30 19:30:19', NULL, NULL, NULL, '八宿县', '西藏自治区昌都市八宿县', '3', 7, 'B', NULL, '1', '854600', '540300');
INSERT INTO `sys_region` VALUES ('540327', '2018-01-30 19:30:19', NULL, NULL, NULL, '左贡县', '西藏自治区昌都市左贡县', '3', 8, 'Z', NULL, '1', '854400', '540300');
INSERT INTO `sys_region` VALUES ('540328', '2018-01-30 19:30:19', NULL, NULL, NULL, '芒康县', '西藏自治区昌都市芒康县', '3', 9, 'M', NULL, '1', '854500', '540300');
INSERT INTO `sys_region` VALUES ('540329', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛隆县', '西藏自治区昌都市洛隆县', '3', 10, 'L', NULL, '1', '855400', '540300');
INSERT INTO `sys_region` VALUES ('540330', '2018-01-30 19:30:19', NULL, NULL, NULL, '边坝县', '西藏自治区昌都市边坝县', '3', 11, 'B', NULL, '1', '855500', '540300');
INSERT INTO `sys_region` VALUES ('540400', '2018-01-30 19:30:19', NULL, NULL, NULL, '林芝市', '西藏自治区林芝市', '2', 4, 'L', NULL, '1', NULL, '540000');
INSERT INTO `sys_region` VALUES ('540402', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴宜区', '西藏自治区林芝市巴宜区', '3', 1, 'B', NULL, '1', NULL, '540400');
INSERT INTO `sys_region` VALUES ('540421', '2018-01-30 19:30:19', NULL, NULL, NULL, '工布江达县', '西藏自治区林芝市工布江达县', '3', 2, 'G', NULL, '1', NULL, '540400');
INSERT INTO `sys_region` VALUES ('540422', '2018-01-30 19:30:19', NULL, NULL, NULL, '米林县', '西藏自治区林芝市米林县', '3', 3, 'M', NULL, '1', NULL, '540400');
INSERT INTO `sys_region` VALUES ('540423', '2018-01-30 19:30:19', NULL, NULL, NULL, '墨脱县', '西藏自治区林芝市墨脱县', '3', 4, 'M', NULL, '1', NULL, '540400');
INSERT INTO `sys_region` VALUES ('540424', '2018-01-30 19:30:19', NULL, NULL, NULL, '波密县', '西藏自治区林芝市波密县', '3', 5, 'B', NULL, '1', NULL, '540400');
INSERT INTO `sys_region` VALUES ('540425', '2018-01-30 19:30:19', NULL, NULL, NULL, '察隅县', '西藏自治区林芝市察隅县', '3', 6, 'C', NULL, '1', NULL, '540400');
INSERT INTO `sys_region` VALUES ('540426', '2018-01-30 19:30:19', NULL, NULL, NULL, '朗县', '西藏自治区林芝市朗县', '3', 7, 'L', NULL, '1', NULL, '540400');
INSERT INTO `sys_region` VALUES ('540500', '2018-01-30 19:30:19', NULL, NULL, NULL, '山南市', '西藏自治区山南市', '2', 5, 'S', NULL, '1', NULL, '540000');
INSERT INTO `sys_region` VALUES ('540501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '西藏自治区山南市市辖区', '3', 1, 'S', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540502', '2018-01-30 19:30:19', NULL, NULL, NULL, '乃东区', '西藏自治区山南市乃东区', '3', 2, 'N', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540521', '2018-01-30 19:30:19', NULL, NULL, NULL, '扎囊县', '西藏自治区山南市扎囊县', '3', 3, 'Z', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540522', '2018-01-30 19:30:19', NULL, NULL, NULL, '贡嘎县', '西藏自治区山南市贡嘎县', '3', 4, 'G', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540523', '2018-01-30 19:30:19', NULL, NULL, NULL, '桑日县', '西藏自治区山南市桑日县', '3', 5, 'S', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540524', '2018-01-30 19:30:19', NULL, NULL, NULL, '琼结县', '西藏自治区山南市琼结县', '3', 6, 'Q', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540525', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲松县', '西藏自治区山南市曲松县', '3', 7, 'Q', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540526', '2018-01-30 19:30:19', NULL, NULL, NULL, '措美县', '西藏自治区山南市措美县', '3', 8, 'C', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540527', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛扎县', '西藏自治区山南市洛扎县', '3', 9, 'L', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540528', '2018-01-30 19:30:19', NULL, NULL, NULL, '加查县', '西藏自治区山南市加查县', '3', 10, 'J', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540529', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆子县', '西藏自治区山南市隆子县', '3', 11, 'L', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540530', '2018-01-30 19:30:19', NULL, NULL, NULL, '错那县', '西藏自治区山南市错那县', '3', 12, 'C', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('540531', '2018-01-30 19:30:19', NULL, NULL, NULL, '浪卡子县', '西藏自治区山南市浪卡子县', '3', 13, 'L', NULL, '1', NULL, '540500');
INSERT INTO `sys_region` VALUES ('542400', '2018-01-30 19:30:19', NULL, NULL, NULL, '那曲地区', '西藏自治区那曲地区', '2', 6, 'N', NULL, '1', '852000', '540000');
INSERT INTO `sys_region` VALUES ('542421', '2018-01-30 19:30:19', NULL, NULL, NULL, '那曲县', '西藏自治区那曲地区那曲县', '3', 1, 'N', NULL, '1', '852000', '542400');
INSERT INTO `sys_region` VALUES ('542422', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉黎县', '西藏自治区那曲地区嘉黎县', '3', 2, 'J', NULL, '1', '852400', '542400');
INSERT INTO `sys_region` VALUES ('542423', '2018-01-30 19:30:19', NULL, NULL, NULL, '比如县', '西藏自治区那曲地区比如县', '3', 3, 'B', NULL, '1', '852300', '542400');
INSERT INTO `sys_region` VALUES ('542424', '2018-01-30 19:30:19', NULL, NULL, NULL, '聂荣县', '西藏自治区那曲地区聂荣县', '3', 4, 'N', NULL, '1', '853500', '542400');
INSERT INTO `sys_region` VALUES ('542425', '2018-01-30 19:30:19', NULL, NULL, NULL, '安多县', '西藏自治区那曲地区安多县', '3', 5, 'A', NULL, '1', '853400', '542400');
INSERT INTO `sys_region` VALUES ('542426', '2018-01-30 19:30:19', NULL, NULL, NULL, '申扎县', '西藏自治区那曲地区申扎县', '3', 6, 'S', NULL, '1', '853100', '542400');
INSERT INTO `sys_region` VALUES ('542427', '2018-01-30 19:30:19', NULL, NULL, NULL, '索县', '西藏自治区那曲地区索县', '3', 7, 'S', NULL, '1', '852200', '542400');
INSERT INTO `sys_region` VALUES ('542428', '2018-01-30 19:30:19', NULL, NULL, NULL, '班戈县', '西藏自治区那曲地区班戈县', '3', 8, 'B', NULL, '1', '852500', '542400');
INSERT INTO `sys_region` VALUES ('542429', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴青县', '西藏自治区那曲地区巴青县', '3', 9, 'B', NULL, '1', '852100', '542400');
INSERT INTO `sys_region` VALUES ('542430', '2018-01-30 19:30:19', NULL, NULL, NULL, '尼玛县', '西藏自治区那曲地区尼玛县', '3', 10, 'N', NULL, '1', '852600', '542400');
INSERT INTO `sys_region` VALUES ('542431', '2018-01-30 19:30:19', NULL, NULL, NULL, '双湖县', '西藏自治区那曲地区双湖县', '3', 11, 'S', NULL, '1', '852600', '542400');
INSERT INTO `sys_region` VALUES ('542500', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿里地区', '西藏自治区阿里地区', '2', 7, 'A', NULL, '1', '859000', '540000');
INSERT INTO `sys_region` VALUES ('542521', '2018-01-30 19:30:19', NULL, NULL, NULL, '普兰县', '西藏自治区阿里地区普兰县', '3', 1, 'P', NULL, '1', '859500', '542500');
INSERT INTO `sys_region` VALUES ('542522', '2018-01-30 19:30:19', NULL, NULL, NULL, '札达县', '西藏自治区阿里地区札达县', '3', 2, 'Z', NULL, '1', '859600', '542500');
INSERT INTO `sys_region` VALUES ('542523', '2018-01-30 19:30:19', NULL, NULL, NULL, '噶尔县', '西藏自治区阿里地区噶尔县', '3', 3, 'G', NULL, '1', '859400', '542500');
INSERT INTO `sys_region` VALUES ('542524', '2018-01-30 19:30:19', NULL, NULL, NULL, '日土县', '西藏自治区阿里地区日土县', '3', 4, 'R', NULL, '1', '859700', '542500');
INSERT INTO `sys_region` VALUES ('542525', '2018-01-30 19:30:19', NULL, NULL, NULL, '革吉县', '西藏自治区阿里地区革吉县', '3', 5, 'G', NULL, '1', '859100', '542500');
INSERT INTO `sys_region` VALUES ('542526', '2018-01-30 19:30:19', NULL, NULL, NULL, '改则县', '西藏自治区阿里地区改则县', '3', 6, 'G', NULL, '1', '859200', '542500');
INSERT INTO `sys_region` VALUES ('542527', '2018-01-30 19:30:19', NULL, NULL, NULL, '措勤县', '西藏自治区阿里地区措勤县', '3', 7, 'C', NULL, '1', '859300', '542500');
INSERT INTO `sys_region` VALUES ('610000', '2018-01-30 19:30:19', NULL, NULL, NULL, '陕西省', '陕西省', '1', 27, 'S', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('610100', '2018-01-30 19:30:19', NULL, NULL, NULL, '西安市', '陕西省西安市', '2', 1, 'X', NULL, '1', '710003', '610000');
INSERT INTO `sys_region` VALUES ('610101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省西安市市辖区', '3', 1, 'S', NULL, '1', NULL, '610100');
INSERT INTO `sys_region` VALUES ('610102', '2018-01-30 19:30:19', NULL, NULL, NULL, '新城区', '陕西省西安市新城区', '3', 2, 'X', NULL, '1', '710004', '610100');
INSERT INTO `sys_region` VALUES ('610103', '2018-01-30 19:30:19', NULL, NULL, NULL, '碑林区', '陕西省西安市碑林区', '3', 3, 'B', NULL, '1', '710001', '610100');
INSERT INTO `sys_region` VALUES ('610104', '2018-01-30 19:30:19', NULL, NULL, NULL, '莲湖区', '陕西省西安市莲湖区', '3', 4, 'L', NULL, '1', '710003', '610100');
INSERT INTO `sys_region` VALUES ('610111', '2018-01-30 19:30:19', NULL, NULL, NULL, '灞桥区', '陕西省西安市灞桥区', '3', 5, 'Z', NULL, '1', '710038', '610100');
INSERT INTO `sys_region` VALUES ('610112', '2018-01-30 19:30:19', NULL, NULL, NULL, '未央区', '陕西省西安市未央区', '3', 6, 'W', NULL, '1', '710014', '610100');
INSERT INTO `sys_region` VALUES ('610113', '2018-01-30 19:30:19', NULL, NULL, NULL, '雁塔区', '陕西省西安市雁塔区', '3', 7, 'Y', NULL, '1', '710061', '610100');
INSERT INTO `sys_region` VALUES ('610114', '2018-01-30 19:30:19', NULL, NULL, NULL, '阎良区', '陕西省西安市阎良区', '3', 8, 'Y', NULL, '1', '710087', '610100');
INSERT INTO `sys_region` VALUES ('610115', '2018-01-30 19:30:19', NULL, NULL, NULL, '临潼区', '陕西省西安市临潼区', '3', 9, 'L', NULL, '1', '710600', '610100');
INSERT INTO `sys_region` VALUES ('610116', '2018-01-30 19:30:19', NULL, NULL, NULL, '长安区', '陕西省西安市长安区', '3', 10, 'C', NULL, '1', '710100', '610100');
INSERT INTO `sys_region` VALUES ('610117', '2018-01-30 19:30:19', NULL, NULL, NULL, '高陵区', '陕西省西安市高陵区', '3', 11, 'G', NULL, '1', NULL, '610100');
INSERT INTO `sys_region` VALUES ('610122', '2018-01-30 19:30:19', NULL, NULL, NULL, '蓝田县', '陕西省西安市蓝田县', '3', 12, 'L', NULL, '1', '710500', '610100');
INSERT INTO `sys_region` VALUES ('610124', '2018-01-30 19:30:19', NULL, NULL, NULL, '周至县', '陕西省西安市周至县', '3', 13, 'Z', NULL, '1', '710400', '610100');
INSERT INTO `sys_region` VALUES ('610125', '2018-01-30 19:30:19', NULL, NULL, NULL, '户县', '陕西省西安市户县', '3', 14, 'H', NULL, '1', '710300', '610100');
INSERT INTO `sys_region` VALUES ('610200', '2018-01-30 19:30:19', NULL, NULL, NULL, '铜川市', '陕西省铜川市', '2', 2, 'T', NULL, '1', '727100', '610000');
INSERT INTO `sys_region` VALUES ('610201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省铜川市市辖区', '3', 1, 'S', NULL, '1', NULL, '610200');
INSERT INTO `sys_region` VALUES ('610202', '2018-01-30 19:30:19', NULL, NULL, NULL, '王益区', '陕西省铜川市王益区', '3', 2, 'W', NULL, '1', '727000', '610200');
INSERT INTO `sys_region` VALUES ('610203', '2018-01-30 19:30:19', NULL, NULL, NULL, '印台区', '陕西省铜川市印台区', '3', 3, 'Y', NULL, '1', '727007', '610200');
INSERT INTO `sys_region` VALUES ('610204', '2018-01-30 19:30:19', NULL, NULL, NULL, '耀州区', '陕西省铜川市耀州区', '3', 4, 'Y', NULL, '1', '727100', '610200');
INSERT INTO `sys_region` VALUES ('610222', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜君县', '陕西省铜川市宜君县', '3', 5, 'Y', NULL, '1', '727200', '610200');
INSERT INTO `sys_region` VALUES ('610300', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝鸡市', '陕西省宝鸡市', '2', 3, 'B', NULL, '1', '721000', '610000');
INSERT INTO `sys_region` VALUES ('610301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省宝鸡市市辖区', '3', 1, 'S', NULL, '1', NULL, '610300');
INSERT INTO `sys_region` VALUES ('610302', '2018-01-30 19:30:19', NULL, NULL, NULL, '渭滨区', '陕西省宝鸡市渭滨区', '3', 2, 'W', NULL, '1', '721000', '610300');
INSERT INTO `sys_region` VALUES ('610303', '2018-01-30 19:30:19', NULL, NULL, NULL, '金台区', '陕西省宝鸡市金台区', '3', 3, 'J', NULL, '1', '721000', '610300');
INSERT INTO `sys_region` VALUES ('610304', '2018-01-30 19:30:19', NULL, NULL, NULL, '陈仓区', '陕西省宝鸡市陈仓区', '3', 4, 'C', NULL, '1', '721300', '610300');
INSERT INTO `sys_region` VALUES ('610322', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤翔县', '陕西省宝鸡市凤翔县', '3', 5, 'F', NULL, '1', '721400', '610300');
INSERT INTO `sys_region` VALUES ('610323', '2018-01-30 19:30:19', NULL, NULL, NULL, '岐山县', '陕西省宝鸡市岐山县', '3', 6, 'Z', NULL, '1', '722400', '610300');
INSERT INTO `sys_region` VALUES ('610324', '2018-01-30 19:30:19', NULL, NULL, NULL, '扶风县', '陕西省宝鸡市扶风县', '3', 7, 'F', NULL, '1', '722200', '610300');
INSERT INTO `sys_region` VALUES ('610326', '2018-01-30 19:30:19', NULL, NULL, NULL, '眉县', '陕西省宝鸡市眉县', '3', 8, 'M', NULL, '1', '722300', '610300');
INSERT INTO `sys_region` VALUES ('610327', '2018-01-30 19:30:19', NULL, NULL, NULL, '陇县', '陕西省宝鸡市陇县', '3', 9, 'L', NULL, '1', '721200', '610300');
INSERT INTO `sys_region` VALUES ('610328', '2018-01-30 19:30:19', NULL, NULL, NULL, '千阳县', '陕西省宝鸡市千阳县', '3', 10, 'Q', NULL, '1', '721100', '610300');
INSERT INTO `sys_region` VALUES ('610329', '2018-01-30 19:30:19', NULL, NULL, NULL, '麟游县', '陕西省宝鸡市麟游县', '3', 11, 'Z', NULL, '1', '721500', '610300');
INSERT INTO `sys_region` VALUES ('610330', '2018-01-30 19:30:19', NULL, NULL, NULL, '凤县', '陕西省宝鸡市凤县', '3', 12, 'F', NULL, '1', '721700', '610300');
INSERT INTO `sys_region` VALUES ('610331', '2018-01-30 19:30:19', NULL, NULL, NULL, '太白县', '陕西省宝鸡市太白县', '3', 13, 'T', NULL, '1', '721600', '610300');
INSERT INTO `sys_region` VALUES ('610400', '2018-01-30 19:30:19', NULL, NULL, NULL, '咸阳市', '陕西省咸阳市', '2', 4, 'X', NULL, '1', '712000', '610000');
INSERT INTO `sys_region` VALUES ('610401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省咸阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '610400');
INSERT INTO `sys_region` VALUES ('610402', '2018-01-30 19:30:19', NULL, NULL, NULL, '秦都区', '陕西省咸阳市秦都区', '3', 2, 'Q', NULL, '1', '712000', '610400');
INSERT INTO `sys_region` VALUES ('610403', '2018-01-30 19:30:19', NULL, NULL, NULL, '杨陵区', '陕西省咸阳市杨陵区', '3', 3, 'Y', NULL, '1', '712100', '610400');
INSERT INTO `sys_region` VALUES ('610404', '2018-01-30 19:30:19', NULL, NULL, NULL, '渭城区', '陕西省咸阳市渭城区', '3', 4, 'W', NULL, '1', '712000', '610400');
INSERT INTO `sys_region` VALUES ('610422', '2018-01-30 19:30:19', NULL, NULL, NULL, '三原县', '陕西省咸阳市三原县', '3', 5, 'S', NULL, '1', '713800', '610400');
INSERT INTO `sys_region` VALUES ('610423', '2018-01-30 19:30:19', NULL, NULL, NULL, '泾阳县', '陕西省咸阳市泾阳县', '3', 6, 'Z', NULL, '1', '713700', '610400');
INSERT INTO `sys_region` VALUES ('610424', '2018-01-30 19:30:19', NULL, NULL, NULL, '乾县', '陕西省咸阳市乾县', '3', 7, 'Q', NULL, '1', '713300', '610400');
INSERT INTO `sys_region` VALUES ('610425', '2018-01-30 19:30:19', NULL, NULL, NULL, '礼泉县', '陕西省咸阳市礼泉县', '3', 8, 'L', NULL, '1', '713200', '610400');
INSERT INTO `sys_region` VALUES ('610426', '2018-01-30 19:30:19', NULL, NULL, NULL, '永寿县', '陕西省咸阳市永寿县', '3', 9, 'Y', NULL, '1', '713400', '610400');
INSERT INTO `sys_region` VALUES ('610427', '2018-01-30 19:30:19', NULL, NULL, NULL, '彬县', '陕西省咸阳市彬县', '3', 10, 'B', NULL, '1', '713500', '610400');
INSERT INTO `sys_region` VALUES ('610428', '2018-01-30 19:30:19', NULL, NULL, NULL, '长武县', '陕西省咸阳市长武县', '3', 11, 'C', NULL, '1', '713600', '610400');
INSERT INTO `sys_region` VALUES ('610429', '2018-01-30 19:30:19', NULL, NULL, NULL, '旬邑县', '陕西省咸阳市旬邑县', '3', 12, 'X', NULL, '1', '711300', '610400');
INSERT INTO `sys_region` VALUES ('610430', '2018-01-30 19:30:19', NULL, NULL, NULL, '淳化县', '陕西省咸阳市淳化县', '3', 13, 'C', NULL, '1', '711200', '610400');
INSERT INTO `sys_region` VALUES ('610431', '2018-01-30 19:30:19', NULL, NULL, NULL, '武功县', '陕西省咸阳市武功县', '3', 14, 'W', NULL, '1', '712200', '610400');
INSERT INTO `sys_region` VALUES ('610481', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴平市', '陕西省咸阳市兴平市', '3', 15, 'X', NULL, '1', '713100', '610400');
INSERT INTO `sys_region` VALUES ('610500', '2018-01-30 19:30:19', NULL, NULL, NULL, '渭南市', '陕西省渭南市', '2', 5, 'W', NULL, '1', '714000', '610000');
INSERT INTO `sys_region` VALUES ('610501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省渭南市市辖区', '3', 1, 'S', NULL, '1', NULL, '610500');
INSERT INTO `sys_region` VALUES ('610502', '2018-01-30 19:30:19', NULL, NULL, NULL, '临渭区', '陕西省渭南市临渭区', '3', 2, 'L', NULL, '1', '714000', '610500');
INSERT INTO `sys_region` VALUES ('610503', '2018-01-30 19:30:19', NULL, NULL, NULL, '华州区', '陕西省渭南市华州区', '3', 3, 'H', NULL, '1', NULL, '610500');
INSERT INTO `sys_region` VALUES ('610522', '2018-01-30 19:30:19', NULL, NULL, NULL, '潼关县', '陕西省渭南市潼关县', '3', 4, 'Z', NULL, '1', '714300', '610500');
INSERT INTO `sys_region` VALUES ('610523', '2018-01-30 19:30:19', NULL, NULL, NULL, '大荔县', '陕西省渭南市大荔县', '3', 5, 'D', NULL, '1', '715100', '610500');
INSERT INTO `sys_region` VALUES ('610524', '2018-01-30 19:30:19', NULL, NULL, NULL, '合阳县', '陕西省渭南市合阳县', '3', 6, 'H', NULL, '1', '715300', '610500');
INSERT INTO `sys_region` VALUES ('610525', '2018-01-30 19:30:19', NULL, NULL, NULL, '澄城县', '陕西省渭南市澄城县', '3', 7, 'C', NULL, '1', '715200', '610500');
INSERT INTO `sys_region` VALUES ('610526', '2018-01-30 19:30:19', NULL, NULL, NULL, '蒲城县', '陕西省渭南市蒲城县', '3', 8, 'P', NULL, '1', '715500', '610500');
INSERT INTO `sys_region` VALUES ('610527', '2018-01-30 19:30:19', NULL, NULL, NULL, '白水县', '陕西省渭南市白水县', '3', 9, 'B', NULL, '1', '715600', '610500');
INSERT INTO `sys_region` VALUES ('610528', '2018-01-30 19:30:19', NULL, NULL, NULL, '富平县', '陕西省渭南市富平县', '3', 10, 'F', NULL, '1', '711700', '610500');
INSERT INTO `sys_region` VALUES ('610581', '2018-01-30 19:30:19', NULL, NULL, NULL, '韩城市', '陕西省渭南市韩城市', '3', 11, 'H', NULL, '1', '715400', '610500');
INSERT INTO `sys_region` VALUES ('610582', '2018-01-30 19:30:19', NULL, NULL, NULL, '华阴市', '陕西省渭南市华阴市', '3', 12, 'H', NULL, '1', '714200', '610500');
INSERT INTO `sys_region` VALUES ('610600', '2018-01-30 19:30:19', NULL, NULL, NULL, '延安市', '陕西省延安市', '2', 6, 'Y', NULL, '1', '716000', '610000');
INSERT INTO `sys_region` VALUES ('610601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省延安市市辖区', '3', 1, 'S', NULL, '1', NULL, '610600');
INSERT INTO `sys_region` VALUES ('610602', '2018-01-30 19:30:19', NULL, NULL, NULL, '宝塔区', '陕西省延安市宝塔区', '3', 2, 'B', NULL, '1', '716000', '610600');
INSERT INTO `sys_region` VALUES ('610603', '2018-01-30 19:30:19', NULL, NULL, NULL, '安塞区', '陕西省延安市安塞区', '3', 3, 'A', NULL, '1', NULL, '610600');
INSERT INTO `sys_region` VALUES ('610621', '2018-01-30 19:30:19', NULL, NULL, NULL, '延长县', '陕西省延安市延长县', '3', 4, 'Y', NULL, '1', '717100', '610600');
INSERT INTO `sys_region` VALUES ('610622', '2018-01-30 19:30:19', NULL, NULL, NULL, '延川县', '陕西省延安市延川县', '3', 5, 'Y', NULL, '1', '717200', '610600');
INSERT INTO `sys_region` VALUES ('610623', '2018-01-30 19:30:19', NULL, NULL, NULL, '子长县', '陕西省延安市子长县', '3', 6, 'Z', NULL, '1', '717300', '610600');
INSERT INTO `sys_region` VALUES ('610625', '2018-01-30 19:30:19', NULL, NULL, NULL, '志丹县', '陕西省延安市志丹县', '3', 7, 'Z', NULL, '1', '717500', '610600');
INSERT INTO `sys_region` VALUES ('610626', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴起县', '陕西省延安市吴起县', '3', 8, 'W', NULL, '1', '717600', '610600');
INSERT INTO `sys_region` VALUES ('610627', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘泉县', '陕西省延安市甘泉县', '3', 9, 'G', NULL, '1', '716100', '610600');
INSERT INTO `sys_region` VALUES ('610628', '2018-01-30 19:30:19', NULL, NULL, NULL, '富县', '陕西省延安市富县', '3', 10, 'F', NULL, '1', '727500', '610600');
INSERT INTO `sys_region` VALUES ('610629', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛川县', '陕西省延安市洛川县', '3', 11, 'L', NULL, '1', '727400', '610600');
INSERT INTO `sys_region` VALUES ('610630', '2018-01-30 19:30:19', NULL, NULL, NULL, '宜川县', '陕西省延安市宜川县', '3', 12, 'Y', NULL, '1', '716200', '610600');
INSERT INTO `sys_region` VALUES ('610631', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄龙县', '陕西省延安市黄龙县', '3', 13, 'H', NULL, '1', '715700', '610600');
INSERT INTO `sys_region` VALUES ('610632', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄陵县', '陕西省延安市黄陵县', '3', 14, 'H', NULL, '1', '727300', '610600');
INSERT INTO `sys_region` VALUES ('610700', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉中市', '陕西省汉中市', '2', 7, 'H', NULL, '1', '723000', '610000');
INSERT INTO `sys_region` VALUES ('610701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省汉中市市辖区', '3', 1, 'S', NULL, '1', NULL, '610700');
INSERT INTO `sys_region` VALUES ('610702', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉台区', '陕西省汉中市汉台区', '3', 2, 'H', NULL, '1', '723000', '610700');
INSERT INTO `sys_region` VALUES ('610721', '2018-01-30 19:30:19', NULL, NULL, NULL, '南郑县', '陕西省汉中市南郑县', '3', 3, 'N', NULL, '1', '723100', '610700');
INSERT INTO `sys_region` VALUES ('610722', '2018-01-30 19:30:19', NULL, NULL, NULL, '城固县', '陕西省汉中市城固县', '3', 4, 'C', NULL, '1', '723200', '610700');
INSERT INTO `sys_region` VALUES ('610723', '2018-01-30 19:30:19', NULL, NULL, NULL, '洋县', '陕西省汉中市洋县', '3', 5, 'Y', NULL, '1', '723300', '610700');
INSERT INTO `sys_region` VALUES ('610724', '2018-01-30 19:30:19', NULL, NULL, NULL, '西乡县', '陕西省汉中市西乡县', '3', 6, 'X', NULL, '1', '723500', '610700');
INSERT INTO `sys_region` VALUES ('610725', '2018-01-30 19:30:19', NULL, NULL, NULL, '勉县', '陕西省汉中市勉县', '3', 7, 'M', NULL, '1', '724200', '610700');
INSERT INTO `sys_region` VALUES ('610726', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁强县', '陕西省汉中市宁强县', '3', 8, 'N', NULL, '1', '724400', '610700');
INSERT INTO `sys_region` VALUES ('610727', '2018-01-30 19:30:19', NULL, NULL, NULL, '略阳县', '陕西省汉中市略阳县', '3', 9, 'L', NULL, '1', '724300', '610700');
INSERT INTO `sys_region` VALUES ('610728', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇巴县', '陕西省汉中市镇巴县', '3', 10, 'Z', NULL, '1', '723600', '610700');
INSERT INTO `sys_region` VALUES ('610729', '2018-01-30 19:30:19', NULL, NULL, NULL, '留坝县', '陕西省汉中市留坝县', '3', 11, 'L', NULL, '1', '724100', '610700');
INSERT INTO `sys_region` VALUES ('610730', '2018-01-30 19:30:19', NULL, NULL, NULL, '佛坪县', '陕西省汉中市佛坪县', '3', 12, 'F', NULL, '1', '723400', '610700');
INSERT INTO `sys_region` VALUES ('610800', '2018-01-30 19:30:19', NULL, NULL, NULL, '榆林市', '陕西省榆林市', '2', 8, 'Y', NULL, '1', '719000', '610000');
INSERT INTO `sys_region` VALUES ('610801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省榆林市市辖区', '3', 1, 'S', NULL, '1', NULL, '610800');
INSERT INTO `sys_region` VALUES ('610802', '2018-01-30 19:30:19', NULL, NULL, NULL, '榆阳区', '陕西省榆林市榆阳区', '3', 2, 'Y', NULL, '1', '719000', '610800');
INSERT INTO `sys_region` VALUES ('610803', '2018-01-30 19:30:19', NULL, NULL, NULL, '横山区', '陕西省榆林市横山区', '3', 3, 'H', NULL, '1', NULL, '610800');
INSERT INTO `sys_region` VALUES ('610821', '2018-01-30 19:30:19', NULL, NULL, NULL, '神木县', '陕西省榆林市神木县', '3', 4, 'S', NULL, '1', '719300', '610800');
INSERT INTO `sys_region` VALUES ('610822', '2018-01-30 19:30:19', NULL, NULL, NULL, '府谷县', '陕西省榆林市府谷县', '3', 5, 'F', NULL, '1', '719400', '610800');
INSERT INTO `sys_region` VALUES ('610824', '2018-01-30 19:30:19', NULL, NULL, NULL, '靖边县', '陕西省榆林市靖边县', '3', 6, 'J', NULL, '1', '718500', '610800');
INSERT INTO `sys_region` VALUES ('610825', '2018-01-30 19:30:19', NULL, NULL, NULL, '定边县', '陕西省榆林市定边县', '3', 7, 'D', NULL, '1', '718600', '610800');
INSERT INTO `sys_region` VALUES ('610826', '2018-01-30 19:30:19', NULL, NULL, NULL, '绥德县', '陕西省榆林市绥德县', '3', 8, 'S', NULL, '1', '718000', '610800');
INSERT INTO `sys_region` VALUES ('610827', '2018-01-30 19:30:19', NULL, NULL, NULL, '米脂县', '陕西省榆林市米脂县', '3', 9, 'M', NULL, '1', '718100', '610800');
INSERT INTO `sys_region` VALUES ('610828', '2018-01-30 19:30:19', NULL, NULL, NULL, '佳县', '陕西省榆林市佳县', '3', 10, 'J', NULL, '1', '719200', '610800');
INSERT INTO `sys_region` VALUES ('610829', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴堡县', '陕西省榆林市吴堡县', '3', 11, 'W', NULL, '1', '718200', '610800');
INSERT INTO `sys_region` VALUES ('610830', '2018-01-30 19:30:19', NULL, NULL, NULL, '清涧县', '陕西省榆林市清涧县', '3', 12, 'Q', NULL, '1', '718300', '610800');
INSERT INTO `sys_region` VALUES ('610831', '2018-01-30 19:30:19', NULL, NULL, NULL, '子洲县', '陕西省榆林市子洲县', '3', 13, 'Z', NULL, '1', '718400', '610800');
INSERT INTO `sys_region` VALUES ('610900', '2018-01-30 19:30:19', NULL, NULL, NULL, '安康市', '陕西省安康市', '2', 9, 'A', NULL, '1', '725000', '610000');
INSERT INTO `sys_region` VALUES ('610901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省安康市市辖区', '3', 1, 'S', NULL, '1', NULL, '610900');
INSERT INTO `sys_region` VALUES ('610902', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉滨区', '陕西省安康市汉滨区', '3', 2, 'H', NULL, '1', '725000', '610900');
INSERT INTO `sys_region` VALUES ('610921', '2018-01-30 19:30:19', NULL, NULL, NULL, '汉阴县', '陕西省安康市汉阴县', '3', 3, 'H', NULL, '1', '725100', '610900');
INSERT INTO `sys_region` VALUES ('610922', '2018-01-30 19:30:19', NULL, NULL, NULL, '石泉县', '陕西省安康市石泉县', '3', 4, 'S', NULL, '1', '725200', '610900');
INSERT INTO `sys_region` VALUES ('610923', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁陕县', '陕西省安康市宁陕县', '3', 5, 'N', NULL, '1', '711600', '610900');
INSERT INTO `sys_region` VALUES ('610924', '2018-01-30 19:30:19', NULL, NULL, NULL, '紫阳县', '陕西省安康市紫阳县', '3', 6, 'Z', NULL, '1', '725300', '610900');
INSERT INTO `sys_region` VALUES ('610925', '2018-01-30 19:30:19', NULL, NULL, NULL, '岚皋县', '陕西省安康市岚皋县', '3', 7, 'Z', NULL, '1', '725400', '610900');
INSERT INTO `sys_region` VALUES ('610926', '2018-01-30 19:30:19', NULL, NULL, NULL, '平利县', '陕西省安康市平利县', '3', 8, 'P', NULL, '1', '725500', '610900');
INSERT INTO `sys_region` VALUES ('610927', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇坪县', '陕西省安康市镇坪县', '3', 9, 'Z', NULL, '1', '725600', '610900');
INSERT INTO `sys_region` VALUES ('610928', '2018-01-30 19:30:19', NULL, NULL, NULL, '旬阳县', '陕西省安康市旬阳县', '3', 10, 'X', NULL, '1', '725700', '610900');
INSERT INTO `sys_region` VALUES ('610929', '2018-01-30 19:30:19', NULL, NULL, NULL, '白河县', '陕西省安康市白河县', '3', 11, 'B', NULL, '1', '725800', '610900');
INSERT INTO `sys_region` VALUES ('610930', '2018-01-30 19:30:19', NULL, NULL, NULL, '高新区', '陕西省安康市高新区', '3', 12, 'G', NULL, '1', NULL, '610900');
INSERT INTO `sys_region` VALUES ('611000', '2018-01-30 19:30:19', NULL, NULL, NULL, '商洛市', '陕西省商洛市', '2', 10, 'S', NULL, '1', '726000', '610000');
INSERT INTO `sys_region` VALUES ('611001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '陕西省商洛市市辖区', '3', 1, 'S', NULL, '1', NULL, '611000');
INSERT INTO `sys_region` VALUES ('611002', '2018-01-30 19:30:19', NULL, NULL, NULL, '商州区', '陕西省商洛市商州区', '3', 2, 'S', NULL, '1', '726000', '611000');
INSERT INTO `sys_region` VALUES ('611021', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛南县', '陕西省商洛市洛南县', '3', 3, 'L', NULL, '1', '726100', '611000');
INSERT INTO `sys_region` VALUES ('611022', '2018-01-30 19:30:19', NULL, NULL, NULL, '丹凤县', '陕西省商洛市丹凤县', '3', 4, 'D', NULL, '1', '726200', '611000');
INSERT INTO `sys_region` VALUES ('611023', '2018-01-30 19:30:19', NULL, NULL, NULL, '商南县', '陕西省商洛市商南县', '3', 5, 'S', NULL, '1', '726300', '611000');
INSERT INTO `sys_region` VALUES ('611024', '2018-01-30 19:30:19', NULL, NULL, NULL, '山阳县', '陕西省商洛市山阳县', '3', 6, 'S', NULL, '1', '726400', '611000');
INSERT INTO `sys_region` VALUES ('611025', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇安县', '陕西省商洛市镇安县', '3', 7, 'Z', NULL, '1', '711500', '611000');
INSERT INTO `sys_region` VALUES ('611026', '2018-01-30 19:30:19', NULL, NULL, NULL, '柞水县', '陕西省商洛市柞水县', '3', 8, 'Z', NULL, '1', '711400', '611000');
INSERT INTO `sys_region` VALUES ('611100', '2018-01-30 19:30:19', NULL, NULL, NULL, '杨凌示范区', '陕西省杨凌示范区', '2', 11, 'Y', NULL, '1', '712000', '610000');
INSERT INTO `sys_region` VALUES ('611200', '2018-01-30 19:30:19', NULL, NULL, NULL, '西咸新区', '陕西省西咸新区', '2', 12, 'X', NULL, '1', NULL, '610000');
INSERT INTO `sys_region` VALUES ('611300', '2018-01-30 19:30:19', NULL, NULL, NULL, '西安国际商务区片区', '陕西省西安国际商务区片区', '2', 13, 'X', NULL, '1', NULL, '610000');
INSERT INTO `sys_region` VALUES ('611400', '2018-01-30 19:30:19', NULL, NULL, NULL, '中心片区', '陕西省中心片区', '2', 14, 'Z', NULL, '1', NULL, '610000');
INSERT INTO `sys_region` VALUES ('611500', '2019-07-11 10:52:56', NULL, NULL, NULL, '西安市高新区', '陕西省西安市高新区', '2', 15, 'X', NULL, '1', NULL, '610000');
INSERT INTO `sys_region` VALUES ('611600', '2019-07-11 10:54:01', NULL, NULL, NULL, '西安市浐灞生态区', '陕西省西安市浐灞生态区', '2', 16, 'X', NULL, '1', NULL, '610000');
INSERT INTO `sys_region` VALUES ('611700', '2019-07-11 10:54:45', NULL, NULL, NULL, '西安市经济技术开发区', '陕西省西安市经济技术开发区', '2', 17, 'X', NULL, '1', NULL, '610000');
INSERT INTO `sys_region` VALUES ('611800', '2019-07-11 11:00:42', NULL, NULL, NULL, '西安市灞桥区国际港务区', '陕西省西安市灞桥区国际港务区', '2', 18, 'X', NULL, '1', NULL, '610000');
INSERT INTO `sys_region` VALUES ('620000', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘肃省', '甘肃省', '1', 28, 'G', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('620100', '2018-01-30 19:30:19', NULL, NULL, NULL, '兰州市', '甘肃省兰州市', '2', 1, 'L', NULL, '1', '730030', '620000');
INSERT INTO `sys_region` VALUES ('620101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省兰州市市辖区', '3', 1, 'S', NULL, '1', NULL, '620100');
INSERT INTO `sys_region` VALUES ('620102', '2018-01-30 19:30:19', NULL, NULL, NULL, '城关区', '甘肃省兰州市城关区', '3', 2, 'C', NULL, '1', '730030', '620100');
INSERT INTO `sys_region` VALUES ('620103', '2018-01-30 19:30:19', NULL, NULL, NULL, '七里河区', '甘肃省兰州市七里河区', '3', 3, 'Q', NULL, '1', '730050', '620100');
INSERT INTO `sys_region` VALUES ('620104', '2018-01-30 19:30:19', NULL, NULL, NULL, '西固区', '甘肃省兰州市西固区', '3', 4, 'X', NULL, '1', '730060', '620100');
INSERT INTO `sys_region` VALUES ('620105', '2018-01-30 19:30:19', NULL, NULL, NULL, '安宁区', '甘肃省兰州市安宁区', '3', 5, 'A', NULL, '1', '730070', '620100');
INSERT INTO `sys_region` VALUES ('620111', '2018-01-30 19:30:19', NULL, NULL, NULL, '红古区', '甘肃省兰州市红古区', '3', 6, 'H', NULL, '1', '730084', '620100');
INSERT INTO `sys_region` VALUES ('620121', '2018-01-30 19:30:19', NULL, NULL, NULL, '永登县', '甘肃省兰州市永登县', '3', 7, 'Y', NULL, '1', '730300', '620100');
INSERT INTO `sys_region` VALUES ('620122', '2018-01-30 19:30:19', NULL, NULL, NULL, '皋兰县', '甘肃省兰州市皋兰县', '3', 8, 'G', NULL, '1', '730200', '620100');
INSERT INTO `sys_region` VALUES ('620123', '2018-01-30 19:30:19', NULL, NULL, NULL, '榆中县', '甘肃省兰州市榆中县', '3', 9, 'Y', NULL, '1', '730100', '620100');
INSERT INTO `sys_region` VALUES ('620200', '2018-01-30 19:30:19', NULL, NULL, NULL, '嘉峪关市', '甘肃省嘉峪关市', '2', 2, 'J', NULL, '1', '735100', '620000');
INSERT INTO `sys_region` VALUES ('620201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省嘉峪关市市辖区', '3', 1, 'S', NULL, '1', '735100', '620200');
INSERT INTO `sys_region` VALUES ('620300', '2018-01-30 19:30:19', NULL, NULL, NULL, '金昌市', '甘肃省金昌市', '2', 3, 'J', NULL, '1', '737100', '620000');
INSERT INTO `sys_region` VALUES ('620301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省金昌市市辖区', '3', 1, 'S', NULL, '1', NULL, '620300');
INSERT INTO `sys_region` VALUES ('620302', '2018-01-30 19:30:19', NULL, NULL, NULL, '金川区', '甘肃省金昌市金川区', '3', 2, 'J', NULL, '1', '737100', '620300');
INSERT INTO `sys_region` VALUES ('620321', '2018-01-30 19:30:19', NULL, NULL, NULL, '永昌县', '甘肃省金昌市永昌县', '3', 3, 'Y', NULL, '1', '737200', '620300');
INSERT INTO `sys_region` VALUES ('620400', '2018-01-30 19:30:19', NULL, NULL, NULL, '白银市', '甘肃省白银市', '2', 4, 'B', NULL, '1', '730900', '620000');
INSERT INTO `sys_region` VALUES ('620401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省白银市市辖区', '3', 1, 'S', NULL, '1', NULL, '620400');
INSERT INTO `sys_region` VALUES ('620402', '2018-01-30 19:30:19', NULL, NULL, NULL, '白银区', '甘肃省白银市白银区', '3', 2, 'B', NULL, '1', '730900', '620400');
INSERT INTO `sys_region` VALUES ('620403', '2018-01-30 19:30:19', NULL, NULL, NULL, '平川区', '甘肃省白银市平川区', '3', 3, 'P', NULL, '1', '730913', '620400');
INSERT INTO `sys_region` VALUES ('620421', '2018-01-30 19:30:19', NULL, NULL, NULL, '靖远县', '甘肃省白银市靖远县', '3', 4, 'J', NULL, '1', '730600', '620400');
INSERT INTO `sys_region` VALUES ('620422', '2018-01-30 19:30:19', NULL, NULL, NULL, '会宁县', '甘肃省白银市会宁县', '3', 5, 'H', NULL, '1', '730700', '620400');
INSERT INTO `sys_region` VALUES ('620423', '2018-01-30 19:30:19', NULL, NULL, NULL, '景泰县', '甘肃省白银市景泰县', '3', 6, 'J', NULL, '1', '730400', '620400');
INSERT INTO `sys_region` VALUES ('620500', '2018-01-30 19:30:19', NULL, NULL, NULL, '天水市', '甘肃省天水市', '2', 5, 'T', NULL, '1', '741000', '620000');
INSERT INTO `sys_region` VALUES ('620501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省天水市市辖区', '3', 1, 'S', NULL, '1', NULL, '620500');
INSERT INTO `sys_region` VALUES ('620502', '2018-01-30 19:30:19', NULL, NULL, NULL, '秦州区', '甘肃省天水市秦州区', '3', 2, 'Q', NULL, '1', '741000', '620500');
INSERT INTO `sys_region` VALUES ('620503', '2018-01-30 19:30:19', NULL, NULL, NULL, '麦积区', '甘肃省天水市麦积区', '3', 3, 'M', NULL, '1', '741020', '620500');
INSERT INTO `sys_region` VALUES ('620521', '2018-01-30 19:30:19', NULL, NULL, NULL, '清水县', '甘肃省天水市清水县', '3', 4, 'Q', NULL, '1', '741400', '620500');
INSERT INTO `sys_region` VALUES ('620522', '2018-01-30 19:30:19', NULL, NULL, NULL, '秦安县', '甘肃省天水市秦安县', '3', 5, 'Q', NULL, '1', '741600', '620500');
INSERT INTO `sys_region` VALUES ('620523', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘谷县', '甘肃省天水市甘谷县', '3', 6, 'G', NULL, '1', '741200', '620500');
INSERT INTO `sys_region` VALUES ('620524', '2018-01-30 19:30:19', NULL, NULL, NULL, '武山县', '甘肃省天水市武山县', '3', 7, 'W', NULL, '1', '741300', '620500');
INSERT INTO `sys_region` VALUES ('620525', '2018-01-30 19:30:19', NULL, NULL, NULL, '张家川回族自治县', '甘肃省天水市张家川回族自治县', '3', 8, 'Z', NULL, '1', '741500', '620500');
INSERT INTO `sys_region` VALUES ('620600', '2018-01-30 19:30:19', NULL, NULL, NULL, '武威市', '甘肃省武威市', '2', 6, 'W', NULL, '1', '733000', '620000');
INSERT INTO `sys_region` VALUES ('620601', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省武威市市辖区', '3', 1, 'S', NULL, '1', NULL, '620600');
INSERT INTO `sys_region` VALUES ('620602', '2018-01-30 19:30:19', NULL, NULL, NULL, '凉州区', '甘肃省武威市凉州区', '3', 2, 'L', NULL, '1', '733000', '620600');
INSERT INTO `sys_region` VALUES ('620621', '2018-01-30 19:30:19', NULL, NULL, NULL, '民勤县', '甘肃省武威市民勤县', '3', 3, 'M', NULL, '1', '733300', '620600');
INSERT INTO `sys_region` VALUES ('620622', '2018-01-30 19:30:19', NULL, NULL, NULL, '古浪县', '甘肃省武威市古浪县', '3', 4, 'G', NULL, '1', '733100', '620600');
INSERT INTO `sys_region` VALUES ('620623', '2018-01-30 19:30:19', NULL, NULL, NULL, '天祝藏族自治县', '甘肃省武威市天祝藏族自治县', '3', 5, 'T', NULL, '1', '733200', '620600');
INSERT INTO `sys_region` VALUES ('620700', '2018-01-30 19:30:19', NULL, NULL, NULL, '张掖市', '甘肃省张掖市', '2', 7, 'Z', NULL, '1', '734000', '620000');
INSERT INTO `sys_region` VALUES ('620701', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省张掖市市辖区', '3', 1, 'S', NULL, '1', NULL, '620700');
INSERT INTO `sys_region` VALUES ('620702', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘州区', '甘肃省张掖市甘州区', '3', 2, 'G', NULL, '1', '734000', '620700');
INSERT INTO `sys_region` VALUES ('620721', '2018-01-30 19:30:19', NULL, NULL, NULL, '肃南裕固族自治县', '甘肃省张掖市肃南裕固族自治县', '3', 3, 'S', NULL, '1', '734400', '620700');
INSERT INTO `sys_region` VALUES ('620722', '2018-01-30 19:30:19', NULL, NULL, NULL, '民乐县', '甘肃省张掖市民乐县', '3', 4, 'M', NULL, '1', '734500', '620700');
INSERT INTO `sys_region` VALUES ('620723', '2018-01-30 19:30:19', NULL, NULL, NULL, '临泽县', '甘肃省张掖市临泽县', '3', 5, 'L', NULL, '1', '734200', '620700');
INSERT INTO `sys_region` VALUES ('620724', '2018-01-30 19:30:19', NULL, NULL, NULL, '高台县', '甘肃省张掖市高台县', '3', 6, 'G', NULL, '1', '734300', '620700');
INSERT INTO `sys_region` VALUES ('620725', '2018-01-30 19:30:19', NULL, NULL, NULL, '山丹县', '甘肃省张掖市山丹县', '3', 7, 'S', NULL, '1', '734100', '620700');
INSERT INTO `sys_region` VALUES ('620800', '2018-01-30 19:30:19', NULL, NULL, NULL, '平凉市', '甘肃省平凉市', '2', 8, 'P', NULL, '1', '744000', '620000');
INSERT INTO `sys_region` VALUES ('620801', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省平凉市市辖区', '3', 1, 'S', NULL, '1', NULL, '620800');
INSERT INTO `sys_region` VALUES ('620802', '2018-01-30 19:30:19', NULL, NULL, NULL, '崆峒区', '甘肃省平凉市崆峒区', '3', 2, 'Z', NULL, '1', '744000', '620800');
INSERT INTO `sys_region` VALUES ('620821', '2018-01-30 19:30:19', NULL, NULL, NULL, '泾川县', '甘肃省平凉市泾川县', '3', 3, 'Z', NULL, '1', '744300', '620800');
INSERT INTO `sys_region` VALUES ('620822', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵台县', '甘肃省平凉市灵台县', '3', 4, 'L', NULL, '1', '744400', '620800');
INSERT INTO `sys_region` VALUES ('620823', '2018-01-30 19:30:19', NULL, NULL, NULL, '崇信县', '甘肃省平凉市崇信县', '3', 5, 'C', NULL, '1', '744200', '620800');
INSERT INTO `sys_region` VALUES ('620824', '2018-01-30 19:30:19', NULL, NULL, NULL, '华亭县', '甘肃省平凉市华亭县', '3', 6, 'H', NULL, '1', '744100', '620800');
INSERT INTO `sys_region` VALUES ('620825', '2018-01-30 19:30:19', NULL, NULL, NULL, '庄浪县', '甘肃省平凉市庄浪县', '3', 7, 'Z', NULL, '1', '744600', '620800');
INSERT INTO `sys_region` VALUES ('620826', '2018-01-30 19:30:19', NULL, NULL, NULL, '静宁县', '甘肃省平凉市静宁县', '3', 8, 'J', NULL, '1', '743400', '620800');
INSERT INTO `sys_region` VALUES ('620900', '2018-01-30 19:30:19', NULL, NULL, NULL, '酒泉市', '甘肃省酒泉市', '2', 9, 'J', NULL, '1', '735000', '620000');
INSERT INTO `sys_region` VALUES ('620901', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省酒泉市市辖区', '3', 1, 'S', NULL, '1', NULL, '620900');
INSERT INTO `sys_region` VALUES ('620902', '2018-01-30 19:30:19', NULL, NULL, NULL, '肃州区', '甘肃省酒泉市肃州区', '3', 2, 'S', NULL, '1', '735000', '620900');
INSERT INTO `sys_region` VALUES ('620921', '2018-01-30 19:30:19', NULL, NULL, NULL, '金塔县', '甘肃省酒泉市金塔县', '3', 3, 'J', NULL, '1', '735300', '620900');
INSERT INTO `sys_region` VALUES ('620922', '2018-01-30 19:30:19', NULL, NULL, NULL, '瓜州县', '甘肃省酒泉市瓜州县', '3', 4, 'G', NULL, '1', '736100', '620900');
INSERT INTO `sys_region` VALUES ('620923', '2018-01-30 19:30:19', NULL, NULL, NULL, '肃北蒙古族自治县', '甘肃省酒泉市肃北蒙古族自治县', '3', 5, 'S', NULL, '1', '736300', '620900');
INSERT INTO `sys_region` VALUES ('620924', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿克塞哈萨克族自治县', '甘肃省酒泉市阿克塞哈萨克族自治县', '3', 6, 'A', NULL, '1', '736400', '620900');
INSERT INTO `sys_region` VALUES ('620981', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉门市', '甘肃省酒泉市玉门市', '3', 7, 'Y', NULL, '1', '735200', '620900');
INSERT INTO `sys_region` VALUES ('620982', '2018-01-30 19:30:19', NULL, NULL, NULL, '敦煌市', '甘肃省酒泉市敦煌市', '3', 8, 'D', NULL, '1', '736200', '620900');
INSERT INTO `sys_region` VALUES ('621000', '2018-01-30 19:30:19', NULL, NULL, NULL, '庆阳市', '甘肃省庆阳市', '2', 10, 'Q', NULL, '1', '745000', '620000');
INSERT INTO `sys_region` VALUES ('621001', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省庆阳市市辖区', '3', 1, 'S', NULL, '1', NULL, '621000');
INSERT INTO `sys_region` VALUES ('621002', '2018-01-30 19:30:19', NULL, NULL, NULL, '西峰区', '甘肃省庆阳市西峰区', '3', 2, 'X', NULL, '1', '745000', '621000');
INSERT INTO `sys_region` VALUES ('621021', '2018-01-30 19:30:19', NULL, NULL, NULL, '庆城县', '甘肃省庆阳市庆城县', '3', 3, 'Q', NULL, '1', '745100', '621000');
INSERT INTO `sys_region` VALUES ('621022', '2018-01-30 19:30:19', NULL, NULL, NULL, '环县', '甘肃省庆阳市环县', '3', 4, 'H', NULL, '1', '745700', '621000');
INSERT INTO `sys_region` VALUES ('621023', '2018-01-30 19:30:19', NULL, NULL, NULL, '华池县', '甘肃省庆阳市华池县', '3', 5, 'H', NULL, '1', '745600', '621000');
INSERT INTO `sys_region` VALUES ('621024', '2018-01-30 19:30:19', NULL, NULL, NULL, '合水县', '甘肃省庆阳市合水县', '3', 6, 'H', NULL, '1', '745400', '621000');
INSERT INTO `sys_region` VALUES ('621025', '2018-01-30 19:30:19', NULL, NULL, NULL, '正宁县', '甘肃省庆阳市正宁县', '3', 7, 'Z', NULL, '1', '745300', '621000');
INSERT INTO `sys_region` VALUES ('621026', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁县', '甘肃省庆阳市宁县', '3', 8, 'N', NULL, '1', '745200', '621000');
INSERT INTO `sys_region` VALUES ('621027', '2018-01-30 19:30:19', NULL, NULL, NULL, '镇原县', '甘肃省庆阳市镇原县', '3', 9, 'Z', NULL, '1', '744500', '621000');
INSERT INTO `sys_region` VALUES ('621100', '2018-01-30 19:30:19', NULL, NULL, NULL, '定西市', '甘肃省定西市', '2', 11, 'D', NULL, '1', '743000', '620000');
INSERT INTO `sys_region` VALUES ('621101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省定西市市辖区', '3', 1, 'S', NULL, '1', NULL, '621100');
INSERT INTO `sys_region` VALUES ('621102', '2018-01-30 19:30:19', NULL, NULL, NULL, '安定区', '甘肃省定西市安定区', '3', 2, 'A', NULL, '1', '743000', '621100');
INSERT INTO `sys_region` VALUES ('621121', '2018-01-30 19:30:19', NULL, NULL, NULL, '通渭县', '甘肃省定西市通渭县', '3', 3, 'T', NULL, '1', '743300', '621100');
INSERT INTO `sys_region` VALUES ('621122', '2018-01-30 19:30:19', NULL, NULL, NULL, '陇西县', '甘肃省定西市陇西县', '3', 4, 'L', NULL, '1', '748100', '621100');
INSERT INTO `sys_region` VALUES ('621123', '2018-01-30 19:30:19', NULL, NULL, NULL, '渭源县', '甘肃省定西市渭源县', '3', 5, 'W', NULL, '1', '748200', '621100');
INSERT INTO `sys_region` VALUES ('621124', '2018-01-30 19:30:19', NULL, NULL, NULL, '临洮县', '甘肃省定西市临洮县', '3', 6, 'L', NULL, '1', '730500', '621100');
INSERT INTO `sys_region` VALUES ('621125', '2018-01-30 19:30:19', NULL, NULL, NULL, '漳县', '甘肃省定西市漳县', '3', 7, 'Z', NULL, '1', '748300', '621100');
INSERT INTO `sys_region` VALUES ('621126', '2018-01-30 19:30:19', NULL, NULL, NULL, '岷县', '甘肃省定西市岷县', '3', 8, 'Z', NULL, '1', '748400', '621100');
INSERT INTO `sys_region` VALUES ('621200', '2018-01-30 19:30:19', NULL, NULL, NULL, '陇南市', '甘肃省陇南市', '2', 12, 'L', NULL, '1', '746000', '620000');
INSERT INTO `sys_region` VALUES ('621201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '甘肃省陇南市市辖区', '3', 1, 'S', NULL, '1', NULL, '621200');
INSERT INTO `sys_region` VALUES ('621202', '2018-01-30 19:30:19', NULL, NULL, NULL, '武都区', '甘肃省陇南市武都区', '3', 2, 'W', NULL, '1', '746000', '621200');
INSERT INTO `sys_region` VALUES ('621221', '2018-01-30 19:30:19', NULL, NULL, NULL, '成县', '甘肃省陇南市成县', '3', 3, 'C', NULL, '1', '742500', '621200');
INSERT INTO `sys_region` VALUES ('621222', '2018-01-30 19:30:19', NULL, NULL, NULL, '文县', '甘肃省陇南市文县', '3', 4, 'W', NULL, '1', '746400', '621200');
INSERT INTO `sys_region` VALUES ('621223', '2018-01-30 19:30:19', NULL, NULL, NULL, '宕昌县', '甘肃省陇南市宕昌县', '3', 5, 'Z', NULL, '1', '748500', '621200');
INSERT INTO `sys_region` VALUES ('621224', '2018-01-30 19:30:19', NULL, NULL, NULL, '康县', '甘肃省陇南市康县', '3', 6, 'K', NULL, '1', '746500', '621200');
INSERT INTO `sys_region` VALUES ('621225', '2018-01-30 19:30:19', NULL, NULL, NULL, '西和县', '甘肃省陇南市西和县', '3', 7, 'X', NULL, '1', '742100', '621200');
INSERT INTO `sys_region` VALUES ('621226', '2018-01-30 19:30:19', NULL, NULL, NULL, '礼县', '甘肃省陇南市礼县', '3', 8, 'L', NULL, '1', '742200', '621200');
INSERT INTO `sys_region` VALUES ('621227', '2018-01-30 19:30:19', NULL, NULL, NULL, '徽县', '甘肃省陇南市徽县', '3', 9, 'H', NULL, '1', '742300', '621200');
INSERT INTO `sys_region` VALUES ('621228', '2018-01-30 19:30:19', NULL, NULL, NULL, '两当县', '甘肃省陇南市两当县', '3', 10, 'L', NULL, '1', '742400', '621200');
INSERT INTO `sys_region` VALUES ('622900', '2018-01-30 19:30:19', NULL, NULL, NULL, '临夏回族自治州', '甘肃省临夏回族自治州', '2', 13, 'L', NULL, '1', '731100', '620000');
INSERT INTO `sys_region` VALUES ('622901', '2018-01-30 19:30:19', NULL, NULL, NULL, '临夏市', '甘肃省临夏回族自治州临夏市', '3', 1, 'L', NULL, '1', '731100', '622900');
INSERT INTO `sys_region` VALUES ('622921', '2018-01-30 19:30:19', NULL, NULL, NULL, '临夏县', '甘肃省临夏回族自治州临夏县', '3', 2, 'L', NULL, '1', '731800', '622900');
INSERT INTO `sys_region` VALUES ('622922', '2018-01-30 19:30:19', NULL, NULL, NULL, '康乐县', '甘肃省临夏回族自治州康乐县', '3', 3, 'K', NULL, '1', '731500', '622900');
INSERT INTO `sys_region` VALUES ('622923', '2018-01-30 19:30:19', NULL, NULL, NULL, '永靖县', '甘肃省临夏回族自治州永靖县', '3', 4, 'Y', NULL, '1', '731600', '622900');
INSERT INTO `sys_region` VALUES ('622924', '2018-01-30 19:30:19', NULL, NULL, NULL, '广河县', '甘肃省临夏回族自治州广河县', '3', 5, 'G', NULL, '1', '731300', '622900');
INSERT INTO `sys_region` VALUES ('622925', '2018-01-30 19:30:19', NULL, NULL, NULL, '和政县', '甘肃省临夏回族自治州和政县', '3', 6, 'H', NULL, '1', '731200', '622900');
INSERT INTO `sys_region` VALUES ('622926', '2018-01-30 19:30:19', NULL, NULL, NULL, '东乡族自治县', '甘肃省临夏回族自治州东乡族自治县', '3', 7, 'D', NULL, '1', '731400', '622900');
INSERT INTO `sys_region` VALUES ('622927', '2018-01-30 19:30:19', NULL, NULL, NULL, '积石山保安族东乡族撒拉族自治县', '甘肃省临夏回族自治州积石山保安族东乡族撒拉族自治县', '3', 8, 'J', NULL, '1', '731700', '622900');
INSERT INTO `sys_region` VALUES ('623000', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘南藏族自治州', '甘肃省甘南藏族自治州', '2', 14, 'G', NULL, '1', '747000', '620000');
INSERT INTO `sys_region` VALUES ('623001', '2018-01-30 19:30:19', NULL, NULL, NULL, '合作市', '甘肃省甘南藏族自治州合作市', '3', 1, 'H', NULL, '1', '747000', '623000');
INSERT INTO `sys_region` VALUES ('623021', '2018-01-30 19:30:19', NULL, NULL, NULL, '临潭县', '甘肃省甘南藏族自治州临潭县', '3', 2, 'L', NULL, '1', '747500', '623000');
INSERT INTO `sys_region` VALUES ('623022', '2018-01-30 19:30:19', NULL, NULL, NULL, '卓尼县', '甘肃省甘南藏族自治州卓尼县', '3', 3, 'Z', NULL, '1', '747600', '623000');
INSERT INTO `sys_region` VALUES ('623023', '2018-01-30 19:30:19', NULL, NULL, NULL, '舟曲县', '甘肃省甘南藏族自治州舟曲县', '3', 4, 'Z', NULL, '1', '746300', '623000');
INSERT INTO `sys_region` VALUES ('623024', '2018-01-30 19:30:19', NULL, NULL, NULL, '迭部县', '甘肃省甘南藏族自治州迭部县', '3', 5, 'D', NULL, '1', '747400', '623000');
INSERT INTO `sys_region` VALUES ('623025', '2018-01-30 19:30:19', NULL, NULL, NULL, '玛曲县', '甘肃省甘南藏族自治州玛曲县', '3', 6, 'M', NULL, '1', '747300', '623000');
INSERT INTO `sys_region` VALUES ('623026', '2018-01-30 19:30:19', NULL, NULL, NULL, '碌曲县', '甘肃省甘南藏族自治州碌曲县', '3', 7, 'L', NULL, '1', '747200', '623000');
INSERT INTO `sys_region` VALUES ('623027', '2018-01-30 19:30:19', NULL, NULL, NULL, '夏河县', '甘肃省甘南藏族自治州夏河县', '3', 8, 'X', NULL, '1', '747100', '623000');
INSERT INTO `sys_region` VALUES ('630000', '2018-01-30 19:30:19', NULL, NULL, NULL, '青海省', '青海省', '1', 29, 'Q', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('630100', '2018-01-30 19:30:19', NULL, NULL, NULL, '西宁市', '青海省西宁市', '2', 1, 'X', NULL, '1', '810000', '630000');
INSERT INTO `sys_region` VALUES ('630101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '青海省西宁市市辖区', '3', 1, 'S', NULL, '1', NULL, '630100');
INSERT INTO `sys_region` VALUES ('630102', '2018-01-30 19:30:19', NULL, NULL, NULL, '城东区', '青海省西宁市城东区', '3', 2, 'C', NULL, '1', '810007', '630100');
INSERT INTO `sys_region` VALUES ('630103', '2018-01-30 19:30:19', NULL, NULL, NULL, '城中区', '青海省西宁市城中区', '3', 3, 'C', NULL, '1', '810000', '630100');
INSERT INTO `sys_region` VALUES ('630104', '2018-01-30 19:30:19', NULL, NULL, NULL, '城西区', '青海省西宁市城西区', '3', 4, 'C', NULL, '1', '810001', '630100');
INSERT INTO `sys_region` VALUES ('630105', '2018-01-30 19:30:19', NULL, NULL, NULL, '城北区', '青海省西宁市城北区', '3', 5, 'C', NULL, '1', '810003', '630100');
INSERT INTO `sys_region` VALUES ('630121', '2018-01-30 19:30:19', NULL, NULL, NULL, '大通回族土族自治县', '青海省西宁市大通回族土族自治县', '3', 6, 'D', NULL, '1', '810100', '630100');
INSERT INTO `sys_region` VALUES ('630122', '2018-01-30 19:30:19', NULL, NULL, NULL, '湟中县', '青海省西宁市湟中县', '3', 7, 'Z', NULL, '1', '811600', '630100');
INSERT INTO `sys_region` VALUES ('630123', '2018-01-30 19:30:19', NULL, NULL, NULL, '湟源县', '青海省西宁市湟源县', '3', 8, 'Z', NULL, '1', '812100', '630100');
INSERT INTO `sys_region` VALUES ('630200', '2018-01-30 19:30:19', NULL, NULL, NULL, '海东市', '青海省海东市', '2', 2, 'H', NULL, '1', '810700', '630000');
INSERT INTO `sys_region` VALUES ('630202', '2018-01-30 19:30:19', NULL, NULL, NULL, '乐都区', '青海省海东市乐都区', '3', 1, 'L', NULL, '1', '810700', '630200');
INSERT INTO `sys_region` VALUES ('630203', '2018-01-30 19:30:19', NULL, NULL, NULL, '平安区', '青海省海东市平安区', '3', 2, 'P', NULL, '1', NULL, '630200');
INSERT INTO `sys_region` VALUES ('630222', '2018-01-30 19:30:19', NULL, NULL, NULL, '民和回族土族自治县', '青海省海东市民和回族土族自治县', '3', 3, 'M', NULL, '1', '810800', '630200');
INSERT INTO `sys_region` VALUES ('630223', '2018-01-30 19:30:19', NULL, NULL, NULL, '互助土族自治县', '青海省海东市互助土族自治县', '3', 4, 'H', NULL, '1', '810500', '630200');
INSERT INTO `sys_region` VALUES ('630224', '2018-01-30 19:30:19', NULL, NULL, NULL, '化隆回族自治县', '青海省海东市化隆回族自治县', '3', 5, 'H', NULL, '1', '810900', '630200');
INSERT INTO `sys_region` VALUES ('630225', '2018-01-30 19:30:19', NULL, NULL, NULL, '循化撒拉族自治县', '青海省海东市循化撒拉族自治县', '3', 6, 'X', NULL, '1', '811100', '630200');
INSERT INTO `sys_region` VALUES ('632200', '2018-01-30 19:30:19', NULL, NULL, NULL, '海北藏族自治州', '青海省海北藏族自治州', '2', 3, 'H', NULL, '1', '812200', '630000');
INSERT INTO `sys_region` VALUES ('632221', '2018-01-30 19:30:19', NULL, NULL, NULL, '门源回族自治县', '青海省海北藏族自治州门源回族自治县', '3', 1, 'M', NULL, '1', '810300', '632200');
INSERT INTO `sys_region` VALUES ('632222', '2018-01-30 19:30:19', NULL, NULL, NULL, '祁连县', '青海省海北藏族自治州祁连县', '3', 2, 'Q', NULL, '1', '810400', '632200');
INSERT INTO `sys_region` VALUES ('632223', '2018-01-30 19:30:19', NULL, NULL, NULL, '海晏县', '青海省海北藏族自治州海晏县', '3', 3, 'H', NULL, '1', '812200', '632200');
INSERT INTO `sys_region` VALUES ('632224', '2018-01-30 19:30:19', NULL, NULL, NULL, '刚察县', '青海省海北藏族自治州刚察县', '3', 4, 'G', NULL, '1', '812300', '632200');
INSERT INTO `sys_region` VALUES ('632300', '2018-01-30 19:30:19', NULL, NULL, NULL, '黄南藏族自治州', '青海省黄南藏族自治州', '2', 4, 'H', NULL, '1', '811300', '630000');
INSERT INTO `sys_region` VALUES ('632321', '2018-01-30 19:30:19', NULL, NULL, NULL, '同仁县', '青海省黄南藏族自治州同仁县', '3', 1, 'T', NULL, '1', '811300', '632300');
INSERT INTO `sys_region` VALUES ('632322', '2018-01-30 19:30:19', NULL, NULL, NULL, '尖扎县', '青海省黄南藏族自治州尖扎县', '3', 2, 'J', NULL, '1', '811200', '632300');
INSERT INTO `sys_region` VALUES ('632323', '2018-01-30 19:30:19', NULL, NULL, NULL, '泽库县', '青海省黄南藏族自治州泽库县', '3', 3, 'Z', NULL, '1', '811400', '632300');
INSERT INTO `sys_region` VALUES ('632324', '2018-01-30 19:30:19', NULL, NULL, NULL, '河南蒙古族自治县', '青海省黄南藏族自治州河南蒙古族自治县', '3', 4, 'H', NULL, '1', '811500', '632300');
INSERT INTO `sys_region` VALUES ('632500', '2018-01-30 19:30:19', NULL, NULL, NULL, '海南藏族自治州', '青海省海南藏族自治州', '2', 5, 'H', NULL, '1', '813000', '630000');
INSERT INTO `sys_region` VALUES ('632521', '2018-01-30 19:30:19', NULL, NULL, NULL, '共和县', '青海省海南藏族自治州共和县', '3', 1, 'G', NULL, '1', '813000', '632500');
INSERT INTO `sys_region` VALUES ('632522', '2018-01-30 19:30:19', NULL, NULL, NULL, '同德县', '青海省海南藏族自治州同德县', '3', 2, 'T', NULL, '1', '813200', '632500');
INSERT INTO `sys_region` VALUES ('632523', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵德县', '青海省海南藏族自治州贵德县', '3', 3, 'G', NULL, '1', '811700', '632500');
INSERT INTO `sys_region` VALUES ('632524', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴海县', '青海省海南藏族自治州兴海县', '3', 4, 'X', NULL, '1', '813300', '632500');
INSERT INTO `sys_region` VALUES ('632525', '2018-01-30 19:30:19', NULL, NULL, NULL, '贵南县', '青海省海南藏族自治州贵南县', '3', 5, 'G', NULL, '1', '813100', '632500');
INSERT INTO `sys_region` VALUES ('632600', '2018-01-30 19:30:19', NULL, NULL, NULL, '果洛藏族自治州', '青海省果洛藏族自治州', '2', 6, 'G', NULL, '1', '814000', '630000');
INSERT INTO `sys_region` VALUES ('632621', '2018-01-30 19:30:19', NULL, NULL, NULL, '玛沁县', '青海省果洛藏族自治州玛沁县', '3', 1, 'M', NULL, '1', '814000', '632600');
INSERT INTO `sys_region` VALUES ('632622', '2018-01-30 19:30:19', NULL, NULL, NULL, '班玛县', '青海省果洛藏族自治州班玛县', '3', 2, 'B', NULL, '1', '814300', '632600');
INSERT INTO `sys_region` VALUES ('632623', '2018-01-30 19:30:19', NULL, NULL, NULL, '甘德县', '青海省果洛藏族自治州甘德县', '3', 3, 'G', NULL, '1', '814100', '632600');
INSERT INTO `sys_region` VALUES ('632624', '2018-01-30 19:30:19', NULL, NULL, NULL, '达日县', '青海省果洛藏族自治州达日县', '3', 4, 'D', NULL, '1', '814200', '632600');
INSERT INTO `sys_region` VALUES ('632625', '2018-01-30 19:30:19', NULL, NULL, NULL, '久治县', '青海省果洛藏族自治州久治县', '3', 5, 'J', NULL, '1', '624700', '632600');
INSERT INTO `sys_region` VALUES ('632626', '2018-01-30 19:30:19', NULL, NULL, NULL, '玛多县', '青海省果洛藏族自治州玛多县', '3', 6, 'M', NULL, '1', '813500', '632600');
INSERT INTO `sys_region` VALUES ('632700', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉树藏族自治州', '青海省玉树藏族自治州', '2', 7, 'Y', NULL, '1', '815000', '630000');
INSERT INTO `sys_region` VALUES ('632701', '2018-01-30 19:30:19', NULL, NULL, NULL, '玉树市', '青海省玉树藏族自治州玉树市', '3', 1, 'Y', NULL, '1', '815000', '632700');
INSERT INTO `sys_region` VALUES ('632722', '2018-01-30 19:30:19', NULL, NULL, NULL, '杂多县', '青海省玉树藏族自治州杂多县', '3', 2, 'Z', NULL, '1', '815300', '632700');
INSERT INTO `sys_region` VALUES ('632723', '2018-01-30 19:30:19', NULL, NULL, NULL, '称多县', '青海省玉树藏族自治州称多县', '3', 3, 'C', NULL, '1', '815100', '632700');
INSERT INTO `sys_region` VALUES ('632724', '2018-01-30 19:30:19', NULL, NULL, NULL, '治多县', '青海省玉树藏族自治州治多县', '3', 4, 'Z', NULL, '1', '815400', '632700');
INSERT INTO `sys_region` VALUES ('632725', '2018-01-30 19:30:19', NULL, NULL, NULL, '囊谦县', '青海省玉树藏族自治州囊谦县', '3', 5, 'N', NULL, '1', '815200', '632700');
INSERT INTO `sys_region` VALUES ('632726', '2018-01-30 19:30:19', NULL, NULL, NULL, '曲麻莱县', '青海省玉树藏族自治州曲麻莱县', '3', 6, 'Q', NULL, '1', '815500', '632700');
INSERT INTO `sys_region` VALUES ('632800', '2018-01-30 19:30:19', NULL, NULL, NULL, '海西蒙古族藏族自治州', '青海省海西蒙古族藏族自治州', '2', 8, 'H', NULL, '1', '817000', '630000');
INSERT INTO `sys_region` VALUES ('632801', '2018-01-30 19:30:19', NULL, NULL, NULL, '格尔木市', '青海省海西蒙古族藏族自治州格尔木市', '3', 1, 'G', NULL, '1', '816000', '632800');
INSERT INTO `sys_region` VALUES ('632802', '2018-01-30 19:30:19', NULL, NULL, NULL, '德令哈市', '青海省海西蒙古族藏族自治州德令哈市', '3', 2, 'D', NULL, '1', '817000', '632800');
INSERT INTO `sys_region` VALUES ('632821', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌兰县', '青海省海西蒙古族藏族自治州乌兰县', '3', 3, 'W', NULL, '1', '817100', '632800');
INSERT INTO `sys_region` VALUES ('632822', '2018-01-30 19:30:19', NULL, NULL, NULL, '都兰县', '青海省海西蒙古族藏族自治州都兰县', '3', 4, 'D', NULL, '1', '816100', '632800');
INSERT INTO `sys_region` VALUES ('632823', '2018-01-30 19:30:19', NULL, NULL, NULL, '天峻县', '青海省海西蒙古族藏族自治州天峻县', '3', 5, 'T', NULL, '1', '817200', '632800');
INSERT INTO `sys_region` VALUES ('640000', '2018-01-30 19:30:19', NULL, NULL, NULL, '宁夏回族自治区', '宁夏回族自治区', '1', 30, 'N', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('640100', '2018-01-30 19:30:19', NULL, NULL, NULL, '银川市', '宁夏回族自治区银川市', '2', 1, 'Y', NULL, '1', '750004', '640000');
INSERT INTO `sys_region` VALUES ('640101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '宁夏回族自治区银川市市辖区', '3', 1, 'S', NULL, '1', NULL, '640100');
INSERT INTO `sys_region` VALUES ('640104', '2018-01-30 19:30:19', NULL, NULL, NULL, '兴庆区', '宁夏回族自治区银川市兴庆区', '3', 2, 'X', NULL, '1', '750001', '640100');
INSERT INTO `sys_region` VALUES ('640105', '2018-01-30 19:30:19', NULL, NULL, NULL, '西夏区', '宁夏回族自治区银川市西夏区', '3', 3, 'X', NULL, '1', '750021', '640100');
INSERT INTO `sys_region` VALUES ('640106', '2018-01-30 19:30:19', NULL, NULL, NULL, '金凤区', '宁夏回族自治区银川市金凤区', '3', 4, 'J', NULL, '1', '750011', '640100');
INSERT INTO `sys_region` VALUES ('640121', '2018-01-30 19:30:19', NULL, NULL, NULL, '永宁县', '宁夏回族自治区银川市永宁县', '3', 5, 'Y', NULL, '1', '750100', '640100');
INSERT INTO `sys_region` VALUES ('640122', '2018-01-30 19:30:19', NULL, NULL, NULL, '贺兰县', '宁夏回族自治区银川市贺兰县', '3', 6, 'H', NULL, '1', '750200', '640100');
INSERT INTO `sys_region` VALUES ('640181', '2018-01-30 19:30:19', NULL, NULL, NULL, '灵武市', '宁夏回族自治区银川市灵武市', '3', 7, 'L', NULL, '1', '750004', '640100');
INSERT INTO `sys_region` VALUES ('640200', '2018-01-30 19:30:19', NULL, NULL, NULL, '石嘴山市', '宁夏回族自治区石嘴山市', '2', 2, 'S', NULL, '1', '753000', '640000');
INSERT INTO `sys_region` VALUES ('640201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '宁夏回族自治区石嘴山市市辖区', '3', 1, 'S', NULL, '1', NULL, '640200');
INSERT INTO `sys_region` VALUES ('640202', '2018-01-30 19:30:19', NULL, NULL, NULL, '大武口区', '宁夏回族自治区石嘴山市大武口区', '3', 2, 'D', NULL, '1', '753000', '640200');
INSERT INTO `sys_region` VALUES ('640205', '2018-01-30 19:30:19', NULL, NULL, NULL, '惠农区', '宁夏回族自治区石嘴山市惠农区', '3', 3, 'H', NULL, '1', '753600', '640200');
INSERT INTO `sys_region` VALUES ('640221', '2018-01-30 19:30:19', NULL, NULL, NULL, '平罗县', '宁夏回族自治区石嘴山市平罗县', '3', 4, 'P', NULL, '1', '753400', '640200');
INSERT INTO `sys_region` VALUES ('640300', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴忠市', '宁夏回族自治区吴忠市', '2', 3, 'W', NULL, '1', '751100', '640000');
INSERT INTO `sys_region` VALUES ('640301', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '宁夏回族自治区吴忠市市辖区', '3', 1, 'S', NULL, '1', NULL, '640300');
INSERT INTO `sys_region` VALUES ('640302', '2018-01-30 19:30:19', NULL, NULL, NULL, '利通区', '宁夏回族自治区吴忠市利通区', '3', 2, 'L', NULL, '1', '751100', '640300');
INSERT INTO `sys_region` VALUES ('640303', '2018-01-30 19:30:19', NULL, NULL, NULL, '红寺堡区', '宁夏回族自治区吴忠市红寺堡区', '3', 3, 'H', NULL, '1', '751900', '640300');
INSERT INTO `sys_region` VALUES ('640323', '2018-01-30 19:30:19', NULL, NULL, NULL, '盐池县', '宁夏回族自治区吴忠市盐池县', '3', 4, 'Y', NULL, '1', '751500', '640300');
INSERT INTO `sys_region` VALUES ('640324', '2018-01-30 19:30:19', NULL, NULL, NULL, '同心县', '宁夏回族自治区吴忠市同心县', '3', 5, 'T', NULL, '1', '751300', '640300');
INSERT INTO `sys_region` VALUES ('640381', '2018-01-30 19:30:19', NULL, NULL, NULL, '青铜峡市', '宁夏回族自治区吴忠市青铜峡市', '3', 6, 'Q', NULL, '1', '751600', '640300');
INSERT INTO `sys_region` VALUES ('640400', '2018-01-30 19:30:19', NULL, NULL, NULL, '固原市', '宁夏回族自治区固原市', '2', 4, 'G', NULL, '1', '756000', '640000');
INSERT INTO `sys_region` VALUES ('640401', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '宁夏回族自治区固原市市辖区', '3', 1, 'S', NULL, '1', NULL, '640400');
INSERT INTO `sys_region` VALUES ('640402', '2018-01-30 19:30:19', NULL, NULL, NULL, '原州区', '宁夏回族自治区固原市原州区', '3', 2, 'Y', NULL, '1', '756000', '640400');
INSERT INTO `sys_region` VALUES ('640422', '2018-01-30 19:30:19', NULL, NULL, NULL, '西吉县', '宁夏回族自治区固原市西吉县', '3', 3, 'X', NULL, '1', '756200', '640400');
INSERT INTO `sys_region` VALUES ('640423', '2018-01-30 19:30:19', NULL, NULL, NULL, '隆德县', '宁夏回族自治区固原市隆德县', '3', 4, 'L', NULL, '1', '756300', '640400');
INSERT INTO `sys_region` VALUES ('640424', '2018-01-30 19:30:19', NULL, NULL, NULL, '泾源县', '宁夏回族自治区固原市泾源县', '3', 5, 'Z', NULL, '1', '756400', '640400');
INSERT INTO `sys_region` VALUES ('640425', '2018-01-30 19:30:19', NULL, NULL, NULL, '彭阳县', '宁夏回族自治区固原市彭阳县', '3', 6, 'P', NULL, '1', '756500', '640400');
INSERT INTO `sys_region` VALUES ('640500', '2018-01-30 19:30:19', NULL, NULL, NULL, '中卫市', '宁夏回族自治区中卫市', '2', 5, 'Z', NULL, '1', '751700', '640000');
INSERT INTO `sys_region` VALUES ('640501', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '宁夏回族自治区中卫市市辖区', '3', 1, 'S', NULL, '1', NULL, '640500');
INSERT INTO `sys_region` VALUES ('640502', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙坡头区', '宁夏回族自治区中卫市沙坡头区', '3', 2, 'S', NULL, '1', '755000', '640500');
INSERT INTO `sys_region` VALUES ('640521', '2018-01-30 19:30:19', NULL, NULL, NULL, '中宁县', '宁夏回族自治区中卫市中宁县', '3', 3, 'Z', NULL, '1', '751200', '640500');
INSERT INTO `sys_region` VALUES ('640522', '2018-01-30 19:30:19', NULL, NULL, NULL, '海原县', '宁夏回族自治区中卫市海原县', '3', 4, 'H', NULL, '1', '751800', '640500');
INSERT INTO `sys_region` VALUES ('642100', '2018-01-30 19:30:19', NULL, NULL, NULL, '吴忠县', '宁夏回族自治区吴忠县', '3', 7, 'W', NULL, '1', NULL, '640300');
INSERT INTO `sys_region` VALUES ('642200', '2018-01-30 19:30:19', NULL, NULL, NULL, '固原县', '宁夏回族自治区固原县', '3', 7, 'G', NULL, '1', NULL, '640400');
INSERT INTO `sys_region` VALUES ('650000', '2018-01-30 19:30:19', NULL, NULL, NULL, '新疆维吾尔自治区', '新疆维吾尔自治区', '1', 31, 'X', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('650100', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌鲁木齐市', '新疆维吾尔自治区乌鲁木齐市', '2', 1, 'W', NULL, '1', '830002', '650000');
INSERT INTO `sys_region` VALUES ('650101', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '新疆维吾尔自治区乌鲁木齐市市辖区', '3', 1, 'S', NULL, '1', NULL, '650100');
INSERT INTO `sys_region` VALUES ('650102', '2018-01-30 19:30:19', NULL, NULL, NULL, '天山区', '新疆维吾尔自治区乌鲁木齐市天山区', '3', 2, 'T', NULL, '1', '830002', '650100');
INSERT INTO `sys_region` VALUES ('650103', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙依巴克区', '新疆维吾尔自治区乌鲁木齐市沙依巴克区', '3', 3, 'S', NULL, '1', '830000', '650100');
INSERT INTO `sys_region` VALUES ('650104', '2018-01-30 19:30:19', NULL, NULL, NULL, '新市区', '新疆维吾尔自治区乌鲁木齐市新市区', '3', 4, 'X', NULL, '1', '830011', '650100');
INSERT INTO `sys_region` VALUES ('650105', '2018-01-30 19:30:19', NULL, NULL, NULL, '水磨沟区', '新疆维吾尔自治区乌鲁木齐市水磨沟区', '3', 5, 'S', NULL, '1', '830017', '650100');
INSERT INTO `sys_region` VALUES ('650106', '2018-01-30 19:30:19', NULL, NULL, NULL, '头屯河区', '新疆维吾尔自治区乌鲁木齐市头屯河区', '3', 6, 'T', NULL, '1', '830022', '650100');
INSERT INTO `sys_region` VALUES ('650107', '2018-01-30 19:30:19', NULL, NULL, NULL, '达坂城区', '新疆维吾尔自治区乌鲁木齐市达坂城区', '3', 7, 'D', NULL, '1', '830039', '650100');
INSERT INTO `sys_region` VALUES ('650109', '2018-01-30 19:30:19', NULL, NULL, NULL, '米东区', '新疆维吾尔自治区乌鲁木齐市米东区', '3', 8, 'M', NULL, '1', '830019', '650100');
INSERT INTO `sys_region` VALUES ('650121', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌鲁木齐县', '新疆维吾尔自治区乌鲁木齐市乌鲁木齐县', '3', 9, 'W', NULL, '1', '830063', '650100');
INSERT INTO `sys_region` VALUES ('650200', '2018-01-30 19:30:19', NULL, NULL, NULL, '克拉玛依市', '新疆维吾尔自治区克拉玛依市', '2', 2, 'K', NULL, '1', '834000', '650000');
INSERT INTO `sys_region` VALUES ('650201', '2018-01-30 19:30:19', NULL, NULL, NULL, '市辖区', '新疆维吾尔自治区克拉玛依市市辖区', '3', 1, 'S', NULL, '1', NULL, '650200');
INSERT INTO `sys_region` VALUES ('650202', '2018-01-30 19:30:19', NULL, NULL, NULL, '独山子区', '新疆维吾尔自治区克拉玛依市独山子区', '3', 2, 'D', NULL, '1', '834021', '650200');
INSERT INTO `sys_region` VALUES ('650203', '2018-01-30 19:30:19', NULL, NULL, NULL, '克拉玛依区', '新疆维吾尔自治区克拉玛依市克拉玛依区', '3', 3, 'K', NULL, '1', '834000', '650200');
INSERT INTO `sys_region` VALUES ('650204', '2018-01-30 19:30:19', NULL, NULL, NULL, '白碱滩区', '新疆维吾尔自治区克拉玛依市白碱滩区', '3', 4, 'B', NULL, '1', '834008', '650200');
INSERT INTO `sys_region` VALUES ('650205', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌尔禾区', '新疆维吾尔自治区克拉玛依市乌尔禾区', '3', 5, 'W', NULL, '1', '834012', '650200');
INSERT INTO `sys_region` VALUES ('650400', '2018-01-30 19:30:19', NULL, NULL, NULL, '吐鲁番市', '新疆维吾尔自治区吐鲁番市', '2', 3, 'T', NULL, '1', NULL, '650000');
INSERT INTO `sys_region` VALUES ('650402', '2018-01-30 19:30:19', NULL, NULL, NULL, '高昌区', '新疆维吾尔自治区吐鲁番市高昌区', '3', 1, 'G', NULL, '1', NULL, '650400');
INSERT INTO `sys_region` VALUES ('650421', '2018-01-30 19:30:19', NULL, NULL, NULL, '鄯善县', '新疆维吾尔自治区吐鲁番市鄯善县', '3', 2, 'Z', NULL, '1', NULL, '650400');
INSERT INTO `sys_region` VALUES ('650422', '2018-01-30 19:30:19', NULL, NULL, NULL, '托克逊县', '新疆维吾尔自治区吐鲁番市托克逊县', '3', 3, 'T', NULL, '1', NULL, '650400');
INSERT INTO `sys_region` VALUES ('650500', '2018-01-30 19:30:19', NULL, NULL, NULL, '哈密市', '新疆维吾尔自治区哈密市', '2', 4, 'H', NULL, '1', NULL, '650000');
INSERT INTO `sys_region` VALUES ('650502', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊州区', '新疆维吾尔自治区哈密市伊州区', '3', 1, 'Y', NULL, '1', NULL, '650500');
INSERT INTO `sys_region` VALUES ('650521', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴里坤哈萨克自治县', '新疆维吾尔自治区哈密市巴里坤哈萨克自治县', '3', 2, 'B', NULL, '1', NULL, '650500');
INSERT INTO `sys_region` VALUES ('650522', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊吾县', '新疆维吾尔自治区哈密市伊吾县', '3', 3, 'Y', NULL, '1', NULL, '650500');
INSERT INTO `sys_region` VALUES ('652300', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌吉回族自治州', '新疆维吾尔自治区昌吉回族自治州', '2', 5, 'C', NULL, '1', '831100', '650000');
INSERT INTO `sys_region` VALUES ('652301', '2018-01-30 19:30:19', NULL, NULL, NULL, '昌吉市', '新疆维吾尔自治区昌吉回族自治州昌吉市', '3', 1, 'C', NULL, '1', '831100', '652300');
INSERT INTO `sys_region` VALUES ('652302', '2018-01-30 19:30:19', NULL, NULL, NULL, '阜康市', '新疆维吾尔自治区昌吉回族自治州阜康市', '3', 2, 'F', NULL, '1', '831500', '652300');
INSERT INTO `sys_region` VALUES ('652323', '2018-01-30 19:30:19', NULL, NULL, NULL, '呼图壁县', '新疆维吾尔自治区昌吉回族自治州呼图壁县', '3', 3, 'H', NULL, '1', '831200', '652300');
INSERT INTO `sys_region` VALUES ('652324', '2018-01-30 19:30:19', NULL, NULL, NULL, '玛纳斯县', '新疆维吾尔自治区昌吉回族自治州玛纳斯县', '3', 4, 'M', NULL, '1', '832200', '652300');
INSERT INTO `sys_region` VALUES ('652325', '2018-01-30 19:30:19', NULL, NULL, NULL, '奇台县', '新疆维吾尔自治区昌吉回族自治州奇台县', '3', 5, 'Q', NULL, '1', '831800', '652300');
INSERT INTO `sys_region` VALUES ('652327', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉木萨尔县', '新疆维吾尔自治区昌吉回族自治州吉木萨尔县', '3', 6, 'J', NULL, '1', '831700', '652300');
INSERT INTO `sys_region` VALUES ('652328', '2018-01-30 19:30:19', NULL, NULL, NULL, '木垒哈萨克自治县', '新疆维吾尔自治区昌吉回族自治州木垒哈萨克自治县', '3', 7, 'M', NULL, '1', '831900', '652300');
INSERT INTO `sys_region` VALUES ('652700', '2018-01-30 19:30:19', NULL, NULL, NULL, '博尔塔拉蒙古自治州', '新疆维吾尔自治区博尔塔拉蒙古自治州', '2', 6, 'B', NULL, '1', '833400', '650000');
INSERT INTO `sys_region` VALUES ('652701', '2018-01-30 19:30:19', NULL, NULL, NULL, '博乐市', '新疆维吾尔自治区博尔塔拉蒙古自治州博乐市', '3', 1, 'B', NULL, '1', '833400', '652700');
INSERT INTO `sys_region` VALUES ('652702', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿拉山口市', '新疆维吾尔自治区博尔塔拉蒙古自治州阿拉山口市', '3', 2, 'A', NULL, '1', '833400', '652700');
INSERT INTO `sys_region` VALUES ('652722', '2018-01-30 19:30:19', NULL, NULL, NULL, '精河县', '新疆维吾尔自治区博尔塔拉蒙古自治州精河县', '3', 3, 'J', NULL, '1', '833300', '652700');
INSERT INTO `sys_region` VALUES ('652723', '2018-01-30 19:30:19', NULL, NULL, NULL, '温泉县', '新疆维吾尔自治区博尔塔拉蒙古自治州温泉县', '3', 4, 'W', NULL, '1', '833500', '652700');
INSERT INTO `sys_region` VALUES ('652800', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴音郭楞蒙古自治州', '新疆维吾尔自治区巴音郭楞蒙古自治州', '2', 7, 'B', NULL, '1', '841000', '650000');
INSERT INTO `sys_region` VALUES ('652801', '2018-01-30 19:30:19', NULL, NULL, NULL, '库尔勒市', '新疆维吾尔自治区巴音郭楞蒙古自治州库尔勒市', '3', 1, 'K', NULL, '1', '841000', '652800');
INSERT INTO `sys_region` VALUES ('652822', '2018-01-30 19:30:19', NULL, NULL, NULL, '轮台县', '新疆维吾尔自治区巴音郭楞蒙古自治州轮台县', '3', 2, 'L', NULL, '1', '841600', '652800');
INSERT INTO `sys_region` VALUES ('652823', '2018-01-30 19:30:19', NULL, NULL, NULL, '尉犁县', '新疆维吾尔自治区巴音郭楞蒙古自治州尉犁县', '3', 3, 'W', NULL, '1', '841500', '652800');
INSERT INTO `sys_region` VALUES ('652824', '2018-01-30 19:30:19', NULL, NULL, NULL, '若羌县', '新疆维吾尔自治区巴音郭楞蒙古自治州若羌县', '3', 4, 'R', NULL, '1', '841800', '652800');
INSERT INTO `sys_region` VALUES ('652825', '2018-01-30 19:30:19', NULL, NULL, NULL, '且末县', '新疆维吾尔自治区巴音郭楞蒙古自治州且末县', '3', 5, 'Q', NULL, '1', '841900', '652800');
INSERT INTO `sys_region` VALUES ('652826', '2018-01-30 19:30:19', NULL, NULL, NULL, '焉耆回族自治县', '新疆维吾尔自治区巴音郭楞蒙古自治州焉耆回族自治县', '3', 6, 'Y', NULL, '1', '841100', '652800');
INSERT INTO `sys_region` VALUES ('652827', '2018-01-30 19:30:19', NULL, NULL, NULL, '和静县', '新疆维吾尔自治区巴音郭楞蒙古自治州和静县', '3', 7, 'H', NULL, '1', '841300', '652800');
INSERT INTO `sys_region` VALUES ('652828', '2018-01-30 19:30:19', NULL, NULL, NULL, '和硕县', '新疆维吾尔自治区巴音郭楞蒙古自治州和硕县', '3', 8, 'H', NULL, '1', '841200', '652800');
INSERT INTO `sys_region` VALUES ('652829', '2018-01-30 19:30:19', NULL, NULL, NULL, '博湖县', '新疆维吾尔自治区巴音郭楞蒙古自治州博湖县', '3', 9, 'B', NULL, '1', '841400', '652800');
INSERT INTO `sys_region` VALUES ('652900', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿克苏地区', '新疆维吾尔自治区阿克苏地区', '2', 8, 'A', NULL, '1', '843000', '650000');
INSERT INTO `sys_region` VALUES ('652901', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿克苏市', '新疆维吾尔自治区阿克苏地区阿克苏市', '3', 1, 'A', NULL, '1', '843000', '652900');
INSERT INTO `sys_region` VALUES ('652922', '2018-01-30 19:30:19', NULL, NULL, NULL, '温宿县', '新疆维吾尔自治区阿克苏地区温宿县', '3', 2, 'W', NULL, '1', '843100', '652900');
INSERT INTO `sys_region` VALUES ('652923', '2018-01-30 19:30:19', NULL, NULL, NULL, '库车县', '新疆维吾尔自治区阿克苏地区库车县', '3', 3, 'K', NULL, '1', '842000', '652900');
INSERT INTO `sys_region` VALUES ('652924', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙雅县', '新疆维吾尔自治区阿克苏地区沙雅县', '3', 4, 'S', NULL, '1', '842200', '652900');
INSERT INTO `sys_region` VALUES ('652925', '2018-01-30 19:30:19', NULL, NULL, NULL, '新和县', '新疆维吾尔自治区阿克苏地区新和县', '3', 5, 'X', NULL, '1', '842100', '652900');
INSERT INTO `sys_region` VALUES ('652926', '2018-01-30 19:30:19', NULL, NULL, NULL, '拜城县', '新疆维吾尔自治区阿克苏地区拜城县', '3', 6, 'B', NULL, '1', '842300', '652900');
INSERT INTO `sys_region` VALUES ('652927', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌什县', '新疆维吾尔自治区阿克苏地区乌什县', '3', 7, 'W', NULL, '1', '843400', '652900');
INSERT INTO `sys_region` VALUES ('652928', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿瓦提县', '新疆维吾尔自治区阿克苏地区阿瓦提县', '3', 8, 'A', NULL, '1', '843200', '652900');
INSERT INTO `sys_region` VALUES ('652929', '2018-01-30 19:30:19', NULL, NULL, NULL, '柯坪县', '新疆维吾尔自治区阿克苏地区柯坪县', '3', 9, 'K', NULL, '1', '843600', '652900');
INSERT INTO `sys_region` VALUES ('653000', '2018-01-30 19:30:19', NULL, NULL, NULL, '克孜勒苏柯尔克孜自治州', '新疆维吾尔自治区克孜勒苏柯尔克孜自治州', '2', 9, 'K', NULL, '1', '845350', '650000');
INSERT INTO `sys_region` VALUES ('653001', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿图什市', '新疆维吾尔自治区克孜勒苏柯尔克孜自治州阿图什市', '3', 1, 'A', NULL, '1', '845350', '653000');
INSERT INTO `sys_region` VALUES ('653022', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿克陶县', '新疆维吾尔自治区克孜勒苏柯尔克孜自治州阿克陶县', '3', 2, 'A', NULL, '1', '845550', '653000');
INSERT INTO `sys_region` VALUES ('653023', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿合奇县', '新疆维吾尔自治区克孜勒苏柯尔克孜自治州阿合奇县', '3', 3, 'A', NULL, '1', '843500', '653000');
INSERT INTO `sys_region` VALUES ('653024', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌恰县', '新疆维吾尔自治区克孜勒苏柯尔克孜自治州乌恰县', '3', 4, 'W', NULL, '1', '845450', '653000');
INSERT INTO `sys_region` VALUES ('653100', '2018-01-30 19:30:19', NULL, NULL, NULL, '喀什地区', '新疆维吾尔自治区喀什地区', '2', 10, 'K', NULL, '1', '844000', '650000');
INSERT INTO `sys_region` VALUES ('653101', '2018-01-30 19:30:19', NULL, NULL, NULL, '喀什市', '新疆维吾尔自治区喀什地区喀什市', '3', 1, 'K', NULL, '1', '844000', '653100');
INSERT INTO `sys_region` VALUES ('653121', '2018-01-30 19:30:19', NULL, NULL, NULL, '疏附县', '新疆维吾尔自治区喀什地区疏附县', '3', 2, 'S', NULL, '1', '844100', '653100');
INSERT INTO `sys_region` VALUES ('653122', '2018-01-30 19:30:19', NULL, NULL, NULL, '疏勒县', '新疆维吾尔自治区喀什地区疏勒县', '3', 3, 'S', NULL, '1', '844200', '653100');
INSERT INTO `sys_region` VALUES ('653123', '2018-01-30 19:30:19', NULL, NULL, NULL, '英吉沙县', '新疆维吾尔自治区喀什地区英吉沙县', '3', 4, 'Y', NULL, '1', '844500', '653100');
INSERT INTO `sys_region` VALUES ('653124', '2018-01-30 19:30:19', NULL, NULL, NULL, '泽普县', '新疆维吾尔自治区喀什地区泽普县', '3', 5, 'Z', NULL, '1', '844800', '653100');
INSERT INTO `sys_region` VALUES ('653125', '2018-01-30 19:30:19', NULL, NULL, NULL, '莎车县', '新疆维吾尔自治区喀什地区莎车县', '3', 6, 'S', NULL, '1', '844700', '653100');
INSERT INTO `sys_region` VALUES ('653126', '2018-01-30 19:30:19', NULL, NULL, NULL, '叶城县', '新疆维吾尔自治区喀什地区叶城县', '3', 7, 'Y', NULL, '1', '844900', '653100');
INSERT INTO `sys_region` VALUES ('653127', '2018-01-30 19:30:19', NULL, NULL, NULL, '麦盖提县', '新疆维吾尔自治区喀什地区麦盖提县', '3', 8, 'M', NULL, '1', '844600', '653100');
INSERT INTO `sys_region` VALUES ('653128', '2018-01-30 19:30:19', NULL, NULL, NULL, '岳普湖县', '新疆维吾尔自治区喀什地区岳普湖县', '3', 9, 'Y', NULL, '1', '844400', '653100');
INSERT INTO `sys_region` VALUES ('653129', '2018-01-30 19:30:19', NULL, NULL, NULL, '伽师县', '新疆维吾尔自治区喀什地区伽师县', '3', 10, 'Z', NULL, '1', '844300', '653100');
INSERT INTO `sys_region` VALUES ('653130', '2018-01-30 19:30:19', NULL, NULL, NULL, '巴楚县', '新疆维吾尔自治区喀什地区巴楚县', '3', 11, 'B', NULL, '1', '843800', '653100');
INSERT INTO `sys_region` VALUES ('653131', '2018-01-30 19:30:19', NULL, NULL, NULL, '塔什库尔干塔吉克自治县', '新疆维吾尔自治区喀什地区塔什库尔干塔吉克自治县', '3', 12, 'T', NULL, '1', '845250', '653100');
INSERT INTO `sys_region` VALUES ('653200', '2018-01-30 19:30:19', NULL, NULL, NULL, '和田地区', '新疆维吾尔自治区和田地区', '2', 11, 'H', NULL, '1', '848000', '650000');
INSERT INTO `sys_region` VALUES ('653201', '2018-01-30 19:30:19', NULL, NULL, NULL, '和田市', '新疆维吾尔自治区和田地区和田市', '3', 1, 'H', NULL, '1', '848000', '653200');
INSERT INTO `sys_region` VALUES ('653221', '2018-01-30 19:30:19', NULL, NULL, NULL, '和田县', '新疆维吾尔自治区和田地区和田县', '3', 2, 'H', NULL, '1', '848000', '653200');
INSERT INTO `sys_region` VALUES ('653222', '2018-01-30 19:30:19', NULL, NULL, NULL, '墨玉县', '新疆维吾尔自治区和田地区墨玉县', '3', 3, 'M', NULL, '1', '848100', '653200');
INSERT INTO `sys_region` VALUES ('653223', '2018-01-30 19:30:19', NULL, NULL, NULL, '皮山县', '新疆维吾尔自治区和田地区皮山县', '3', 4, 'P', NULL, '1', '845150', '653200');
INSERT INTO `sys_region` VALUES ('653224', '2018-01-30 19:30:19', NULL, NULL, NULL, '洛浦县', '新疆维吾尔自治区和田地区洛浦县', '3', 5, 'L', NULL, '1', '848200', '653200');
INSERT INTO `sys_region` VALUES ('653225', '2018-01-30 19:30:19', NULL, NULL, NULL, '策勒县', '新疆维吾尔自治区和田地区策勒县', '3', 6, 'C', NULL, '1', '848300', '653200');
INSERT INTO `sys_region` VALUES ('653226', '2018-01-30 19:30:19', NULL, NULL, NULL, '于田县', '新疆维吾尔自治区和田地区于田县', '3', 7, 'Y', NULL, '1', '848400', '653200');
INSERT INTO `sys_region` VALUES ('653227', '2018-01-30 19:30:19', NULL, NULL, NULL, '民丰县', '新疆维吾尔自治区和田地区民丰县', '3', 8, 'M', NULL, '1', '848500', '653200');
INSERT INTO `sys_region` VALUES ('654000', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊犁哈萨克自治州', '新疆维吾尔自治区伊犁哈萨克自治州', '2', 12, 'Y', NULL, '1', '835100', '650000');
INSERT INTO `sys_region` VALUES ('654002', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊宁市', '新疆维吾尔自治区伊犁哈萨克自治州伊宁市', '3', 1, 'Y', NULL, '1', '835000', '654000');
INSERT INTO `sys_region` VALUES ('654003', '2018-01-30 19:30:19', NULL, NULL, NULL, '奎屯市', '新疆维吾尔自治区伊犁哈萨克自治州奎屯市', '3', 2, 'K', NULL, '1', '833200', '654000');
INSERT INTO `sys_region` VALUES ('654004', '2018-01-30 19:30:19', NULL, NULL, NULL, '霍尔果斯市', '新疆维吾尔自治区伊犁哈萨克自治州霍尔果斯市', '3', 3, 'H', NULL, '1', '835221', '654000');
INSERT INTO `sys_region` VALUES ('654021', '2018-01-30 19:30:19', NULL, NULL, NULL, '伊宁县', '新疆维吾尔自治区伊犁哈萨克自治州伊宁县', '3', 4, 'Y', NULL, '1', '835100', '654000');
INSERT INTO `sys_region` VALUES ('654022', '2018-01-30 19:30:19', NULL, NULL, NULL, '察布查尔锡伯自治县', '新疆维吾尔自治区伊犁哈萨克自治州察布查尔锡伯自治县', '3', 5, 'C', NULL, '1', '835300', '654000');
INSERT INTO `sys_region` VALUES ('654023', '2018-01-30 19:30:19', NULL, NULL, NULL, '霍城县', '新疆维吾尔自治区伊犁哈萨克自治州霍城县', '3', 6, 'H', NULL, '1', '835200', '654000');
INSERT INTO `sys_region` VALUES ('654024', '2018-01-30 19:30:19', NULL, NULL, NULL, '巩留县', '新疆维吾尔自治区伊犁哈萨克自治州巩留县', '3', 7, 'G', NULL, '1', '835400', '654000');
INSERT INTO `sys_region` VALUES ('654025', '2018-01-30 19:30:19', NULL, NULL, NULL, '新源县', '新疆维吾尔自治区伊犁哈萨克自治州新源县', '3', 8, 'X', NULL, '1', '835800', '654000');
INSERT INTO `sys_region` VALUES ('654026', '2018-01-30 19:30:19', NULL, NULL, NULL, '昭苏县', '新疆维吾尔自治区伊犁哈萨克自治州昭苏县', '3', 9, 'Z', NULL, '1', '835600', '654000');
INSERT INTO `sys_region` VALUES ('654027', '2018-01-30 19:30:19', NULL, NULL, NULL, '特克斯县', '新疆维吾尔自治区伊犁哈萨克自治州特克斯县', '3', 10, 'T', NULL, '1', '835500', '654000');
INSERT INTO `sys_region` VALUES ('654028', '2018-01-30 19:30:19', NULL, NULL, NULL, '尼勒克县', '新疆维吾尔自治区伊犁哈萨克自治州尼勒克县', '3', 11, 'N', NULL, '1', '835700', '654000');
INSERT INTO `sys_region` VALUES ('654200', '2018-01-30 19:30:19', NULL, NULL, NULL, '塔城地区', '新疆维吾尔自治区塔城地区', '2', 13, 'T', NULL, '1', '834700', '650000');
INSERT INTO `sys_region` VALUES ('654201', '2018-01-30 19:30:19', NULL, NULL, NULL, '塔城市', '新疆维吾尔自治区塔城地区塔城市', '3', 1, 'T', NULL, '1', '834700', '654200');
INSERT INTO `sys_region` VALUES ('654202', '2018-01-30 19:30:19', NULL, NULL, NULL, '乌苏市', '新疆维吾尔自治区塔城地区乌苏市', '3', 2, 'W', NULL, '1', '833000', '654200');
INSERT INTO `sys_region` VALUES ('654221', '2018-01-30 19:30:19', NULL, NULL, NULL, '额敏县', '新疆维吾尔自治区塔城地区额敏县', '3', 3, 'E', NULL, '1', '834600', '654200');
INSERT INTO `sys_region` VALUES ('654223', '2018-01-30 19:30:19', NULL, NULL, NULL, '沙湾县', '新疆维吾尔自治区塔城地区沙湾县', '3', 4, 'S', NULL, '1', '832100', '654200');
INSERT INTO `sys_region` VALUES ('654224', '2018-01-30 19:30:19', NULL, NULL, NULL, '托里县', '新疆维吾尔自治区塔城地区托里县', '3', 5, 'T', NULL, '1', '834500', '654200');
INSERT INTO `sys_region` VALUES ('654225', '2018-01-30 19:30:19', NULL, NULL, NULL, '裕民县', '新疆维吾尔自治区塔城地区裕民县', '3', 6, 'Y', NULL, '1', '834800', '654200');
INSERT INTO `sys_region` VALUES ('654226', '2018-01-30 19:30:19', NULL, NULL, NULL, '和布克赛尔蒙古自治县', '新疆维吾尔自治区塔城地区和布克赛尔蒙古自治县', '3', 7, 'H', NULL, '1', '834400', '654200');
INSERT INTO `sys_region` VALUES ('654300', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿勒泰地区', '新疆维吾尔自治区阿勒泰地区', '2', 14, 'A', NULL, '1', '836500', '650000');
INSERT INTO `sys_region` VALUES ('654301', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿勒泰市', '新疆维吾尔自治区阿勒泰地区阿勒泰市', '3', 1, 'A', NULL, '1', '836500', '654300');
INSERT INTO `sys_region` VALUES ('654321', '2018-01-30 19:30:19', NULL, NULL, NULL, '布尔津县', '新疆维吾尔自治区阿勒泰地区布尔津县', '3', 2, 'B', NULL, '1', '836600', '654300');
INSERT INTO `sys_region` VALUES ('654322', '2018-01-30 19:30:19', NULL, NULL, NULL, '富蕴县', '新疆维吾尔自治区阿勒泰地区富蕴县', '3', 3, 'F', NULL, '1', '836100', '654300');
INSERT INTO `sys_region` VALUES ('654323', '2018-01-30 19:30:19', NULL, NULL, NULL, '福海县', '新疆维吾尔自治区阿勒泰地区福海县', '3', 4, 'F', NULL, '1', '836400', '654300');
INSERT INTO `sys_region` VALUES ('654324', '2018-01-30 19:30:19', NULL, NULL, NULL, '哈巴河县', '新疆维吾尔自治区阿勒泰地区哈巴河县', '3', 5, 'H', NULL, '1', '836700', '654300');
INSERT INTO `sys_region` VALUES ('654325', '2018-01-30 19:30:19', NULL, NULL, NULL, '青河县', '新疆维吾尔自治区阿勒泰地区青河县', '3', 6, 'Q', NULL, '1', '836200', '654300');
INSERT INTO `sys_region` VALUES ('654326', '2018-01-30 19:30:19', NULL, NULL, NULL, '吉木乃县', '新疆维吾尔自治区阿勒泰地区吉木乃县', '3', 7, 'J', NULL, '1', '836800', '654300');
INSERT INTO `sys_region` VALUES ('659000', '2018-01-30 19:30:19', NULL, NULL, NULL, '自治区直辖县级行政区划', '新疆维吾尔自治区自治区直辖县级行政区划', '2', 15, 'Z', NULL, '1', '', '650000');
INSERT INTO `sys_region` VALUES ('659001', '2018-01-30 19:30:19', NULL, NULL, NULL, '石河子市', '新疆维吾尔自治区自治区直辖县级行政区划石河子市', '3', 1, 'S', NULL, '1', '832000', '659000');
INSERT INTO `sys_region` VALUES ('659002', '2018-01-30 19:30:19', NULL, NULL, NULL, '阿拉尔市', '新疆维吾尔自治区自治区直辖县级行政区划阿拉尔市', '3', 2, 'A', NULL, '1', '843300', '659000');
INSERT INTO `sys_region` VALUES ('659003', '2018-01-30 19:30:19', NULL, NULL, NULL, '图木舒克市', '新疆维吾尔自治区自治区直辖县级行政区划图木舒克市', '3', 3, 'T', NULL, '1', '843806', '659000');
INSERT INTO `sys_region` VALUES ('659004', '2018-01-30 19:30:19', NULL, NULL, NULL, '五家渠市', '新疆维吾尔自治区自治区直辖县级行政区划五家渠市', '3', 4, 'W', NULL, '1', '831300', '659000');
INSERT INTO `sys_region` VALUES ('659006', '2018-01-30 19:30:19', NULL, NULL, NULL, '铁门关市', '新疆维吾尔自治区自治区直辖县级行政区划铁门关市', '3', 5, 'T', NULL, '1', '836000', '659000');
INSERT INTO `sys_region` VALUES ('710000', '2021-03-18 13:30:19', NULL, NULL, NULL, '台湾省', '台湾省', '1', 32, 'T', NULL, '1', '999079', '100000');
INSERT INTO `sys_region` VALUES ('810000', '2021-03-18 13:30:19', NULL, NULL, NULL, '香港特别行政区', '香港特别行政区', '1', 33, 'X', NULL, '1', '999077', '100000');
INSERT INTO `sys_region` VALUES ('820000', '2021-03-18 13:30:19', NULL, NULL, NULL, '澳门特别行政区', '澳门特别行政区', '1', 34, 'A', NULL, '1', '999078', '100000');
INSERT INTO `sys_region` VALUES ('900000', '2019-05-10 11:15:37', NULL, NULL, NULL, '国外', '国外', '1', 50, 'H', NULL, '1', '', '100000');
INSERT INTO `sys_region` VALUES ('900101', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿鲁巴', '阿鲁巴', '2', 1, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900102', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿富汗', '阿富汗', '2', 2, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900103', '2019-07-01 10:13:52', NULL, NULL, NULL, '安哥拉', '安哥拉', '2', 3, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900104', '2019-07-01 10:13:52', NULL, NULL, NULL, '安圭拉', '安圭拉', '2', 4, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900105', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿尔巴尼亚', '阿尔巴尼亚', '2', 5, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900106', '2019-07-01 10:13:52', NULL, NULL, NULL, '安道尔', '安道尔', '2', 6, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900107', '2019-07-01 10:13:52', NULL, NULL, NULL, '荷属安的列斯', '荷属安的列斯', '2', 7, 'H', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900108', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿联酋', '阿联酋', '2', 8, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900109', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿根廷', '阿根廷', '2', 9, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900110', '2019-07-01 10:13:52', NULL, NULL, NULL, '亚美尼亚', '亚美尼亚', '2', 10, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900111', '2019-07-01 10:13:52', NULL, NULL, NULL, '美属萨摩亚', '美属萨摩亚', '2', 11, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900112', '2019-07-01 10:13:52', NULL, NULL, NULL, '南极洲', '南极洲', '2', 12, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900113', '2019-07-01 10:13:52', NULL, NULL, NULL, '法属南部领土', '法属南部领土', '2', 13, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900114', '2019-07-01 10:13:52', NULL, NULL, NULL, '安提瓜和巴布达', '安提瓜和巴布达', '2', 14, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900115', '2019-07-01 10:13:52', NULL, NULL, NULL, '澳大利亚', '澳大利亚', '2', 15, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900116', '2019-07-01 10:13:52', NULL, NULL, NULL, '奥地利', '奥地利', '2', 16, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900117', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿塞拜疆', '阿塞拜疆', '2', 17, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900118', '2019-07-01 10:13:52', NULL, NULL, NULL, '布隆迪', '布隆迪', '2', 18, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900119', '2019-07-01 10:13:52', NULL, NULL, NULL, '比利时', '比利时', '2', 19, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900120', '2019-07-01 10:13:52', NULL, NULL, NULL, '贝宁', '贝宁', '2', 20, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900121', '2019-07-01 10:13:52', NULL, NULL, NULL, '布基纳法索', '布基纳法索', '2', 21, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900122', '2019-07-01 10:13:52', NULL, NULL, NULL, '孟加拉国', '孟加拉国', '2', 22, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900123', '2019-07-01 10:13:52', NULL, NULL, NULL, '保加利亚', '保加利亚', '2', 23, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900124', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴林', '巴林', '2', 24, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900125', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴哈马', '巴哈马', '2', 25, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900126', '2019-07-01 10:13:52', NULL, NULL, NULL, '波斯尼亚和黑塞哥维那', '波斯尼亚和黑塞哥维那', '2', 26, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900127', '2019-07-01 10:13:52', NULL, NULL, NULL, '白俄罗斯', '白俄罗斯', '2', 27, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900128', '2019-07-01 10:13:52', NULL, NULL, NULL, '伯利兹', '伯利兹', '2', 28, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900129', '2019-07-01 10:13:52', NULL, NULL, NULL, '百幕大', '百幕大', '2', 29, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900130', '2019-07-01 10:13:52', NULL, NULL, NULL, '玻利维亚', '玻利维亚', '2', 30, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900131', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴西', '巴西', '2', 31, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900132', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴巴多斯', '巴巴多斯', '2', 32, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900133', '2019-07-01 10:13:52', NULL, NULL, NULL, '文莱', '文莱', '2', 33, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900134', '2019-07-01 10:13:52', NULL, NULL, NULL, '不丹', '不丹', '2', 34, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900135', '2019-07-01 10:13:52', NULL, NULL, NULL, '布维岛', '布维岛', '2', 35, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900136', '2019-07-01 10:13:52', NULL, NULL, NULL, '博茨瓦纳', '博茨瓦纳', '2', 36, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900137', '2019-07-01 10:13:52', NULL, NULL, NULL, '中非', '中非', '2', 37, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900138', '2019-07-01 10:13:52', NULL, NULL, NULL, '加拿大', '加拿大', '2', 38, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900139', '2019-07-01 10:13:52', NULL, NULL, NULL, '科科斯群岛', '科科斯群岛', '2', 39, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900140', '2019-07-01 10:13:52', NULL, NULL, NULL, '瑞士', '瑞士', '2', 40, 'R', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900141', '2019-07-01 10:13:52', NULL, NULL, NULL, '智利', '智利', '2', 41, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900143', '2019-07-01 10:13:52', NULL, NULL, NULL, '科特迪瓦', '科特迪瓦', '2', 43, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900144', '2019-07-01 10:13:52', NULL, NULL, NULL, '喀麦隆', '喀麦隆', '2', 44, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900145', '2019-07-01 10:13:52', NULL, NULL, NULL, '刚果民主共和国', '刚果民主共和国', '2', 45, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900146', '2019-07-01 10:13:52', NULL, NULL, NULL, '刚果', '刚果', '2', 46, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900147', '2019-07-01 10:13:52', NULL, NULL, NULL, '库克群岛', '库克群岛', '2', 47, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900148', '2019-07-01 10:13:52', NULL, NULL, NULL, '哥伦比亚', '哥伦比亚', '2', 48, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900149', '2019-07-01 10:13:52', NULL, NULL, NULL, '科摩罗', '科摩罗', '2', 49, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900150', '2019-07-01 10:13:52', NULL, NULL, NULL, '佛得角', '佛得角', '2', 50, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900151', '2019-07-01 10:13:52', NULL, NULL, NULL, '哥斯达黎加', '哥斯达黎加', '2', 51, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900152', '2019-07-01 10:13:52', NULL, NULL, NULL, '古巴', '古巴', '2', 52, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900153', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣诞岛', '圣诞岛', '2', 53, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900154', '2019-07-01 10:13:52', NULL, NULL, NULL, '开曼群岛', '开曼群岛', '2', 54, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900155', '2019-07-01 10:13:52', NULL, NULL, NULL, '塞浦路斯', '塞浦路斯', '2', 55, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900156', '2019-07-01 10:13:52', NULL, NULL, NULL, '捷克', '捷克', '2', 56, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900157', '2019-07-01 10:13:52', NULL, NULL, NULL, '德国', '德国', '2', 57, 'D', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900158', '2019-07-01 10:13:52', NULL, NULL, NULL, '吉布提', '吉布提', '2', 58, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900159', '2019-07-01 10:13:52', NULL, NULL, NULL, '多米尼加', '多米尼加', '2', 59, 'D', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900160', '2019-07-01 10:13:52', NULL, NULL, NULL, '丹麦', '丹麦', '2', 60, 'D', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900161', '2019-07-01 10:13:52', NULL, NULL, NULL, '多米尼家共和国', '多米尼家共和国', '2', 61, 'D', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900162', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿尔及利亚', '阿尔及利亚', '2', 62, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900163', '2019-07-01 10:13:52', NULL, NULL, NULL, '厄瓜多尔', '厄瓜多尔', '2', 63, 'E', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900164', '2019-07-01 10:13:52', NULL, NULL, NULL, '埃及', '埃及', '2', 64, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900165', '2019-07-01 10:13:52', NULL, NULL, NULL, '厄立特里亚', '厄立特里亚', '2', 65, 'E', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900166', '2019-07-01 10:13:52', NULL, NULL, NULL, '西撒哈拉', '西撒哈拉', '2', 66, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900167', '2019-07-01 10:13:52', NULL, NULL, NULL, '西班牙', '西班牙', '2', 67, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900168', '2019-07-01 10:13:52', NULL, NULL, NULL, '爱沙尼亚', '爱沙尼亚', '2', 68, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900169', '2019-07-01 10:13:52', NULL, NULL, NULL, '埃塞俄比亚', '埃塞俄比亚', '2', 69, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900170', '2019-07-01 10:13:52', NULL, NULL, NULL, '芬兰', '芬兰', '2', 70, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900171', '2019-07-01 10:13:52', NULL, NULL, NULL, '斐济', '斐济', '2', 71, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900172', '2019-07-01 10:13:52', NULL, NULL, NULL, '马尔维纳斯群岛', '马尔维纳斯群岛', '2', 72, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900173', '2019-07-01 10:13:52', NULL, NULL, NULL, '法国', '法国', '2', 73, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900174', '2019-07-01 10:13:52', NULL, NULL, NULL, '法罗群岛', '法罗群岛', '2', 74, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900175', '2019-07-01 10:13:52', NULL, NULL, NULL, '密克罗尼西亚', '密克罗尼西亚', '2', 75, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900176', '2019-07-01 10:13:52', NULL, NULL, NULL, '加蓬', '加蓬', '2', 76, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900177', '2019-07-01 10:13:52', NULL, NULL, NULL, '英国（独立领土公民、出国不用）', '英国（独立领土公民、出国不用）', '2', 77, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900178', '2019-07-01 10:13:52', NULL, NULL, NULL, '英国（海外国民，出国不用）', '英国（海外国民，出国不用）', '2', 78, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900179', '2019-07-01 10:13:52', NULL, NULL, NULL, '英国（海外公民，出国不用）', '英国（海外公民，出国不用）', '2', 79, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900180', '2019-07-01 10:13:52', NULL, NULL, NULL, '英国（保护公民，出国不用）', '英国（保护公民，出国不用）', '2', 80, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900181', '2019-07-01 10:13:52', NULL, NULL, NULL, '英国', '英国', '2', 81, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900182', '2019-07-01 10:13:52', NULL, NULL, NULL, '英国（隶属，出国不用）', '英国（隶属，出国不用）', '2', 82, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900183', '2019-07-01 10:13:52', NULL, NULL, NULL, '格鲁吉亚', '格鲁吉亚', '2', 83, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900184', '2019-07-01 10:13:52', NULL, NULL, NULL, '加纳', '加纳', '2', 84, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900185', '2019-07-01 10:13:52', NULL, NULL, NULL, '直布罗陀', '直布罗陀', '2', 85, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900186', '2019-07-01 10:13:52', NULL, NULL, NULL, '几内亚', '几内亚', '2', 86, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900187', '2019-07-01 10:13:52', NULL, NULL, NULL, '瓜德罗普', '瓜德罗普', '2', 87, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900188', '2019-07-01 10:13:52', NULL, NULL, NULL, '冈比亚', '冈比亚', '2', 88, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900189', '2019-07-01 10:13:52', NULL, NULL, NULL, '几内亚比绍', '几内亚比绍', '2', 89, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900190', '2019-07-01 10:13:52', NULL, NULL, NULL, '赤道几内亚', '赤道几内亚', '2', 90, 'C', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900191', '2019-07-01 10:13:52', NULL, NULL, NULL, '希腊', '希腊', '2', 91, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900192', '2019-07-01 10:13:52', NULL, NULL, NULL, '格林纳达', '格林纳达', '2', 92, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900193', '2019-07-01 10:13:52', NULL, NULL, NULL, '格陵兰', '格陵兰', '2', 93, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900194', '2019-07-01 10:13:52', NULL, NULL, NULL, '危地马拉', '危地马拉', '2', 94, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900195', '2019-07-01 10:13:52', NULL, NULL, NULL, '法属圭亚那', '法属圭亚那', '2', 95, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900196', '2019-07-01 10:13:52', NULL, NULL, NULL, '关岛', '关岛', '2', 96, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900197', '2019-07-01 10:13:52', NULL, NULL, NULL, '圭亚那', '圭亚那', '2', 97, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900198', '2019-07-01 10:13:52', NULL, NULL, NULL, '中国香港', '中国香港', '2', 98, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900199', '2019-07-01 10:13:52', NULL, NULL, NULL, '赫德岛和麦克唐纳岛', '赫德岛和麦克唐纳岛', '2', 99, 'H', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900200', '2019-07-01 10:13:52', NULL, NULL, NULL, '洪都拉斯', '洪都拉斯', '2', 100, 'H', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900201', '2019-07-01 10:13:52', NULL, NULL, NULL, '克罗地亚', '克罗地亚', '2', 101, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900202', '2019-07-01 10:13:52', NULL, NULL, NULL, '海地', '海地', '2', 102, 'H', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900203', '2019-07-01 10:13:52', NULL, NULL, NULL, '匈牙利', '匈牙利', '2', 103, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900204', '2019-07-01 10:13:52', NULL, NULL, NULL, '印度尼西亚', '印度尼西亚', '2', 104, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900205', '2019-07-01 10:13:52', NULL, NULL, NULL, '印度', '印度', '2', 105, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900206', '2019-07-01 10:13:52', NULL, NULL, NULL, '英属印度洋领土', '英属印度洋领土', '2', 106, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900207', '2019-07-01 10:13:52', NULL, NULL, NULL, '爱尔兰', '爱尔兰', '2', 107, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900208', '2019-07-01 10:13:52', NULL, NULL, NULL, '伊朗', '伊朗', '2', 108, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900209', '2019-07-01 10:13:52', NULL, NULL, NULL, '伊拉克', '伊拉克', '2', 109, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900210', '2019-07-01 10:13:52', NULL, NULL, NULL, '冰岛', '冰岛', '2', 110, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900211', '2019-07-01 10:13:52', NULL, NULL, NULL, '以色列', '以色列', '2', 111, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900212', '2019-07-01 10:13:52', NULL, NULL, NULL, '意大利', '意大利', '2', 112, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900213', '2019-07-01 10:13:52', NULL, NULL, NULL, '牙买加', '牙买加', '2', 113, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900214', '2019-07-01 10:13:52', NULL, NULL, NULL, '约旦', '约旦', '2', 114, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900215', '2019-07-01 10:13:52', NULL, NULL, NULL, '日本', '日本', '2', 115, 'R', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900216', '2019-07-01 10:13:52', NULL, NULL, NULL, '约翰斯顿岛', '约翰斯顿岛', '2', 116, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900217', '2019-07-01 10:13:52', NULL, NULL, NULL, '哈萨克斯坦', '哈萨克斯坦', '2', 117, 'H', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900218', '2019-07-01 10:13:52', NULL, NULL, NULL, '肯尼亚', '肯尼亚', '2', 118, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900219', '2019-07-01 10:13:52', NULL, NULL, NULL, '吉尔吉斯斯坦', '吉尔吉斯斯坦', '2', 119, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900220', '2019-07-01 10:13:52', NULL, NULL, NULL, '柬埔寨', '柬埔寨', '2', 120, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900221', '2019-07-01 10:13:52', NULL, NULL, NULL, '基里巴斯', '基里巴斯', '2', 121, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900222', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣基茨和尼维斯', '圣基茨和尼维斯', '2', 122, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900223', '2019-07-01 10:13:52', NULL, NULL, NULL, '韩国（南朝鲜）', '韩国（南朝鲜）', '2', 123, 'H', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900224', '2019-07-01 10:13:52', NULL, NULL, NULL, '科威特', '科威特', '2', 124, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900225', '2019-07-01 10:13:52', NULL, NULL, NULL, '老挝', '老挝', '2', 125, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900226', '2019-07-01 10:13:52', NULL, NULL, NULL, '黎巴嫩', '黎巴嫩', '2', 126, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900227', '2019-07-01 10:13:52', NULL, NULL, NULL, '利比里亚', '利比里亚', '2', 127, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900228', '2019-07-01 10:13:52', NULL, NULL, NULL, '利比亚', '利比亚', '2', 128, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900229', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣卢西亚', '圣卢西亚', '2', 129, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900230', '2019-07-01 10:13:52', NULL, NULL, NULL, '列支敦土登', '列支敦土登', '2', 130, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900231', '2019-07-01 10:13:52', NULL, NULL, NULL, '斯里兰卡', '斯里兰卡', '2', 131, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900232', '2019-07-01 10:13:52', NULL, NULL, NULL, '莱索托', '莱索托', '2', 132, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900233', '2019-07-01 10:13:52', NULL, NULL, NULL, '立陶宛', '立陶宛', '2', 133, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900234', '2019-07-01 10:13:52', NULL, NULL, NULL, '卢森堡', '卢森堡', '2', 134, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900235', '2019-07-01 10:13:52', NULL, NULL, NULL, '拉脱维亚', '拉脱维亚', '2', 135, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900236', '2019-07-01 10:13:52', NULL, NULL, NULL, '中国澳门', '中国澳门', '2', 136, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900237', '2019-07-01 10:13:52', NULL, NULL, NULL, '摩洛哥', '摩洛哥', '2', 137, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900238', '2019-07-01 10:13:52', NULL, NULL, NULL, '摩纳哥', '摩纳哥', '2', 138, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900239', '2019-07-01 10:13:52', NULL, NULL, NULL, '摩尔多瓦', '摩尔多瓦', '2', 139, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900240', '2019-07-01 10:13:52', NULL, NULL, NULL, '马达加斯加', '马达加斯加', '2', 140, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900241', '2019-07-01 10:13:52', NULL, NULL, NULL, '马尔代夫', '马尔代夫', '2', 141, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900242', '2019-07-01 10:13:52', NULL, NULL, NULL, '墨西哥', '墨西哥', '2', 142, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900243', '2019-07-01 10:13:52', NULL, NULL, NULL, '马绍尔群岛', '马绍尔群岛', '2', 143, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900244', '2019-07-01 10:13:52', NULL, NULL, NULL, '中途岛', '中途岛', '2', 144, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900245', '2019-07-01 10:13:52', NULL, NULL, NULL, '马其顿', '马其顿', '2', 145, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900246', '2019-07-01 10:13:52', NULL, NULL, NULL, '马里', '马里', '2', 146, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900247', '2019-07-01 10:13:52', NULL, NULL, NULL, '马耳他', '马耳他', '2', 147, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900248', '2019-07-01 10:13:52', NULL, NULL, NULL, '缅甸', '缅甸', '2', 148, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900249', '2019-07-01 10:13:52', NULL, NULL, NULL, '蒙古', '蒙古', '2', 149, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900250', '2019-07-01 10:13:52', NULL, NULL, NULL, '北马里亚纳', '北马里亚纳', '2', 150, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900251', '2019-07-01 10:13:52', NULL, NULL, NULL, '莫桑比克', '莫桑比克', '2', 151, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900252', '2019-07-01 10:13:52', NULL, NULL, NULL, '毛里塔尼亚', '毛里塔尼亚', '2', 152, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900253', '2019-07-01 10:13:52', NULL, NULL, NULL, '蒙特塞拉特', '蒙特塞拉特', '2', 153, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900254', '2019-07-01 10:13:52', NULL, NULL, NULL, '马提尼克', '马提尼克', '2', 154, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900255', '2019-07-01 10:13:52', NULL, NULL, NULL, '毛里求斯', '毛里求斯', '2', 155, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900256', '2019-07-01 10:13:52', NULL, NULL, NULL, '马拉维', '马拉维', '2', 156, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900257', '2019-07-01 10:13:52', NULL, NULL, NULL, '马来西亚', '马来西亚', '2', 157, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900258', '2019-07-01 10:13:52', NULL, NULL, NULL, '马约特', '马约特', '2', 158, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900259', '2019-07-01 10:13:52', NULL, NULL, NULL, '纳米比亚', '纳米比亚', '2', 159, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900260', '2019-07-01 10:13:52', NULL, NULL, NULL, '新喀里多尼亚', '新喀里多尼亚', '2', 160, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900261', '2019-07-01 10:13:52', NULL, NULL, NULL, '尼日尔', '尼日尔', '2', 161, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900262', '2019-07-01 10:13:52', NULL, NULL, NULL, '诺福克岛', '诺福克岛', '2', 162, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900263', '2019-07-01 10:13:52', NULL, NULL, NULL, '尼日利亚', '尼日利亚', '2', 163, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900264', '2019-07-01 10:13:52', NULL, NULL, NULL, '尼加拉瓜', '尼加拉瓜', '2', 164, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900265', '2019-07-01 10:13:52', NULL, NULL, NULL, '纽埃', '纽埃', '2', 165, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900266', '2019-07-01 10:13:52', NULL, NULL, NULL, '荷兰', '荷兰', '2', 166, 'H', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900267', '2019-07-01 10:13:52', NULL, NULL, NULL, '挪威', '挪威', '2', 167, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900268', '2019-07-01 10:13:52', NULL, NULL, NULL, '尼波尔', '尼波尔', '2', 168, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900269', '2019-07-01 10:13:52', NULL, NULL, NULL, '瑙鲁', '瑙鲁', '2', 169, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900270', '2019-07-01 10:13:52', NULL, NULL, NULL, '中间地带', '中间地带', '2', 170, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900271', '2019-07-01 10:13:52', NULL, NULL, NULL, '新西兰', '新西兰', '2', 171, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900272', '2019-07-01 10:13:52', NULL, NULL, NULL, '阿曼', '阿曼', '2', 172, 'A', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900273', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴基斯坦', '巴基斯坦', '2', 173, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900274', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴拿马', '巴拿马', '2', 174, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900275', '2019-07-01 10:13:52', NULL, NULL, NULL, '皮特凯恩群岛', '皮特凯恩群岛', '2', 175, 'P', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900276', '2019-07-01 10:13:52', NULL, NULL, NULL, '秘鲁', '秘鲁', '2', 176, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900277', '2019-07-01 10:13:52', NULL, NULL, NULL, '菲律宾', '菲律宾', '2', 177, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900278', '2019-07-01 10:13:52', NULL, NULL, NULL, '贝劳', '贝劳', '2', 178, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900279', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴布亚新几内亚', '巴布亚新几内亚', '2', 179, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900280', '2019-07-01 10:13:52', NULL, NULL, NULL, '波兰', '波兰', '2', 180, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900281', '2019-07-01 10:13:52', NULL, NULL, NULL, '波多黎各', '波多黎各', '2', 181, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900282', '2019-07-01 10:13:52', NULL, NULL, NULL, '朝鲜', '朝鲜', '2', 182, 'C', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900283', '2019-07-01 10:13:52', NULL, NULL, NULL, '葡萄牙', '葡萄牙', '2', 183, 'P', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900284', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴拉圭', '巴拉圭', '2', 184, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900285', '2019-07-01 10:13:52', NULL, NULL, NULL, '巴勒斯坦', '巴勒斯坦', '2', 185, 'B', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900286', '2019-07-01 10:13:52', NULL, NULL, NULL, '法属菠利尼西亚', '法属菠利尼西亚', '2', 186, 'F', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900287', '2019-07-01 10:13:52', NULL, NULL, NULL, '卡塔尔', '卡塔尔', '2', 187, 'K', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900288', '2019-07-01 10:13:52', NULL, NULL, NULL, '留尼汪', '留尼汪', '2', 188, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900289', '2019-07-01 10:13:52', NULL, NULL, NULL, '罗马尼亚', '罗马尼亚', '2', 189, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900290', '2019-07-01 10:13:52', NULL, NULL, NULL, '俄罗斯', '俄罗斯', '2', 190, 'E', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900291', '2019-07-01 10:13:52', NULL, NULL, NULL, '卢旺达', '卢旺达', '2', 191, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900292', '2019-07-01 10:13:52', NULL, NULL, NULL, '沙特阿拉伯', '沙特阿拉伯', '2', 192, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900293', '2019-07-01 10:13:52', NULL, NULL, NULL, '苏丹', '苏丹', '2', 193, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900294', '2019-07-01 10:13:52', NULL, NULL, NULL, '塞内加尔', '塞内加尔', '2', 194, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900295', '2019-07-01 10:13:52', NULL, NULL, NULL, '塞尔维亚', '塞尔维亚', '2', 195, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900296', '2019-07-01 10:13:52', NULL, NULL, NULL, '新加坡', '新加坡', '2', 196, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900297', '2019-07-01 10:13:52', NULL, NULL, NULL, '南乔治亚岛和南桑德韦奇岛', '南乔治亚岛和南桑德韦奇岛', '2', 197, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900298', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣赫勒拿', '圣赫勒拿', '2', 198, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900299', '2019-07-01 10:13:52', NULL, NULL, NULL, '斯瓦尔巴群岛', '斯瓦尔巴群岛', '2', 199, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900300', '2019-07-01 10:13:52', NULL, NULL, NULL, '所罗门群岛', '所罗门群岛', '2', 200, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900301', '2019-07-01 10:13:52', NULL, NULL, NULL, '塞拉利昂', '塞拉利昂', '2', 201, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900302', '2019-07-01 10:13:52', NULL, NULL, NULL, '萨尔瓦多', '萨尔瓦多', '2', 202, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900303', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣马力诺', '圣马力诺', '2', 203, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900304', '2019-07-01 10:13:52', NULL, NULL, NULL, '索马里', '索马里', '2', 204, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900305', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣皮埃尔和密克隆', '圣皮埃尔和密克隆', '2', 205, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900306', '2019-07-01 10:13:52', NULL, NULL, NULL, '塞班', '塞班', '2', 206, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900307', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣多美和普林西比', '圣多美和普林西比', '2', 207, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900308', '2019-07-01 10:13:52', NULL, NULL, NULL, '苏里南', '苏里南', '2', 208, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900309', '2019-07-01 10:13:52', NULL, NULL, NULL, '斯洛伐克', '斯洛伐克', '2', 209, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900310', '2019-07-01 10:13:52', NULL, NULL, NULL, '斯洛文尼亚', '斯洛文尼亚', '2', 210, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900311', '2019-07-01 10:13:52', NULL, NULL, NULL, '瑞典', '瑞典', '2', 211, 'R', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900312', '2019-07-01 10:13:52', NULL, NULL, NULL, '斯威士兰', '斯威士兰', '2', 212, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900313', '2019-07-01 10:13:52', NULL, NULL, NULL, '锡金', '锡金', '2', 213, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900314', '2019-07-01 10:13:52', NULL, NULL, NULL, '塞舌尔', '塞舌尔', '2', 214, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900315', '2019-07-01 10:13:52', NULL, NULL, NULL, '叙利亚', '叙利亚', '2', 215, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900316', '2019-07-01 10:13:52', NULL, NULL, NULL, '特克斯和凯科斯群岛', '特克斯和凯科斯群岛', '2', 216, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900317', '2019-07-01 10:13:52', NULL, NULL, NULL, '乍得', '乍得', '2', 217, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900318', '2019-07-01 10:13:52', NULL, NULL, NULL, '多哥', '多哥', '2', 218, 'D', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900319', '2019-07-01 10:13:52', NULL, NULL, NULL, '泰国', '泰国', '2', 219, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900320', '2019-07-01 10:13:52', NULL, NULL, NULL, '塔吉克斯坦', '塔吉克斯坦', '2', 220, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900321', '2019-07-01 10:13:52', NULL, NULL, NULL, '托克劳', '托克劳', '2', 221, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900322', '2019-07-01 10:13:52', NULL, NULL, NULL, '土库曼斯坦', '土库曼斯坦', '2', 222, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900323', '2019-07-01 10:13:52', NULL, NULL, NULL, '东帝汶', '东帝汶', '2', 223, 'D', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900324', '2019-07-01 10:13:52', NULL, NULL, NULL, '汤加', '汤加', '2', 224, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900325', '2019-07-01 10:13:52', NULL, NULL, NULL, '特立尼达和多巴哥', '特立尼达和多巴哥', '2', 225, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900326', '2019-07-01 10:13:52', NULL, NULL, NULL, '突尼斯', '突尼斯', '2', 226, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900327', '2019-07-01 10:13:52', NULL, NULL, NULL, '土耳其', '土耳其', '2', 227, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900328', '2019-07-01 10:13:52', NULL, NULL, NULL, '图瓦卢', '图瓦卢', '2', 228, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900329', '2019-07-01 10:13:52', NULL, NULL, NULL, '中国台湾', '中国台湾', '2', 229, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900330', '2019-07-01 10:13:52', NULL, NULL, NULL, '坦桑尼亚', '坦桑尼亚', '2', 230, 'T', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900331', '2019-07-01 10:13:52', NULL, NULL, NULL, '乌干达', '乌干达', '2', 231, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900332', '2019-07-01 10:13:52', NULL, NULL, NULL, '乌克兰', '乌克兰', '2', 232, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900333', '2019-07-01 10:13:52', NULL, NULL, NULL, '美属太平洋各群岛', '美属太平洋各群岛', '2', 233, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900334', '2019-07-01 10:13:52', NULL, NULL, NULL, '联合国', '联合国', '2', 234, 'L', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900335', '2019-07-01 10:13:52', NULL, NULL, NULL, '乌拉圭', '乌拉圭', '2', 235, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900336', '2019-07-01 10:13:52', NULL, NULL, NULL, '美国', '美国', '2', 236, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900337', '2019-07-01 10:13:52', NULL, NULL, NULL, '乌兹别克斯坦', '乌兹别克斯坦', '2', 237, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900338', '2019-07-01 10:13:52', NULL, NULL, NULL, '梵蒂冈', '梵蒂冈', '2', 238, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900339', '2019-07-01 10:13:52', NULL, NULL, NULL, '圣文森特和格林纳丁斯', '圣文森特和格林纳丁斯', '2', 239, 'S', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900340', '2019-07-01 10:13:52', NULL, NULL, NULL, '委内瑞拉', '委内瑞拉', '2', 240, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900341', '2019-07-01 10:13:52', NULL, NULL, NULL, '英属维尔京群岛', '英属维尔京群岛', '2', 241, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900342', '2019-07-01 10:13:52', NULL, NULL, NULL, '美属维尔京群岛', '美属维尔京群岛', '2', 242, 'M', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900343', '2019-07-01 10:13:52', NULL, NULL, NULL, '越南', '越南', '2', 243, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900344', '2019-07-01 10:13:52', NULL, NULL, NULL, '瓦努阿图', '瓦努阿图', '2', 244, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900345', '2019-07-01 10:13:52', NULL, NULL, NULL, '威克岛', '威克岛', '2', 245, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900346', '2019-07-01 10:13:52', NULL, NULL, NULL, '瓦利斯和富图纳群岛', '瓦利斯和富图纳群岛', '2', 246, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900347', '2019-07-01 10:13:52', NULL, NULL, NULL, '西萨摩亚', '西萨摩亚', '2', 247, 'X', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900348', '2019-07-01 10:13:52', NULL, NULL, NULL, '无国籍（无国籍人）', '无国籍（无国籍人）', '2', 248, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900349', '2019-07-01 10:13:52', NULL, NULL, NULL, '无国籍（难民）', '无国籍（难民）', '2', 249, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900350', '2019-07-01 10:13:52', NULL, NULL, NULL, '无国籍（未声明国籍）', '无国籍（未声明国籍）', '2', 250, 'W', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900351', '2019-07-01 10:13:52', NULL, NULL, NULL, '也门', '也门', '2', 251, 'Y', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900352', '2019-07-01 10:13:52', NULL, NULL, NULL, '南斯拉夫', '南斯拉夫', '2', 252, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900353', '2019-07-01 10:13:52', NULL, NULL, NULL, '南非', '南非', '2', 253, 'N', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900354', '2019-07-01 10:13:52', NULL, NULL, NULL, '扎伊尔', '扎伊尔', '2', 254, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900355', '2019-07-01 10:13:52', NULL, NULL, NULL, '赞比亚', '赞比亚', '2', 255, 'Z', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900356', '2019-07-01 10:13:52', NULL, NULL, NULL, '津巴布韦', '津巴布韦', '2', 256, 'J', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900357', '2019-07-01 10:13:52', NULL, NULL, NULL, '国籍不详', '国籍不详', '2', 257, 'G', NULL, '1', NULL, '900000');
INSERT INTO `sys_region` VALUES ('900400', '2018-01-30 19:30:19', NULL, NULL, NULL, '国外', '国外国外', '2', 1, 'G', '', '1', '900000', '900000');
INSERT INTO `sys_region` VALUES ('900401', '2018-01-30 19:30:19', NULL, NULL, NULL, '国外', '国外国外国外', '3', 1, 'G', '', '1', '900010', '900400');

SET FOREIGN_KEY_CHECKS = 1;
