/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.web.commons;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.exceptions.AbnormalPersonnelException;
import com.bcxin.Infrastructures.exceptions.AccountLockedException;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.exceptions.ConfirmCheckStatusException;
import com.bcxin.Infrastructures.exceptions.ConflictTenantException;
import com.bcxin.Infrastructures.exceptions.ForbidTenantException;
import com.bcxin.Infrastructures.exceptions.NotAllowedTenantException;
import com.bcxin.Infrastructures.exceptions.TenantExceptionAbstract;
import com.bcxin.Infrastructures.exceptions.UnAuthorizedTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.filter.ExceptionFilter;

@Activate(group={"provider"})
public class GlobalExceptionFilter
extends ExceptionFilter {
    public GlobalExceptionFilter() {
        System.out.println("GlobalExceptionFilter");
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Object data = invocation.getObjectAttachment("API.CURRENT_TENANT_USER_INFO");
        if (data != null) {
            TenantContext.getInstance().getUserContext().init((TenantUserContext.UserModel)data);
        }
        return super.invoke(invoker, invocation);
    }

    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        if (appResponse.hasException()) {
            if (!ExceptionUtil.is((Throwable)appResponse.getException(), TenantExceptionAbstract.class)) {
                super.onResponse(appResponse, invoker, invocation);
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), ForbidTenantException.class)) {
                appResponse.setException((Throwable)new ForbidTenantException(appResponse.getException().getMessage()));
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), NotAllowedTenantException.class)) {
                appResponse.setException((Throwable)new NotAllowedTenantException(appResponse.getException().getMessage()));
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), AccountLockedException.class)) {
                appResponse.setException((Throwable)new AccountLockedException(appResponse.getException().getMessage()));
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), AbnormalPersonnelException.class)) {
                AbnormalPersonnelException abnormalPersonnelException = (AbnormalPersonnelException)appResponse.getException();
                appResponse.setException((Throwable)new AbnormalPersonnelException(abnormalPersonnelException.getCode(), abnormalPersonnelException.getMessage(), abnormalPersonnelException.getExceptionList()));
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), ConflictTenantException.class)) {
                appResponse.setException((Throwable)new ConflictTenantException(appResponse.getException().getMessage()));
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), UnAuthorizedTenantException.class)) {
                appResponse.setException((Throwable)new UnAuthorizedTenantException(appResponse.getException().getMessage()));
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), ConfirmCheckStatusException.class)) {
                ConfirmCheckStatusException ck = (ConfirmCheckStatusException)appResponse.getException();
                appResponse.setException((Throwable)new ConfirmCheckStatusException(ck.getTenantUserId(), ck.getCheckedStatus(), ck.getMessage()));
            } else if (ExceptionUtil.is((Throwable)appResponse.getException(), TenantExceptionAbstract.class)) {
                appResponse.setException((Throwable)new BadTenantException(appResponse.getException().getMessage()));
            } else {
                appResponse.setException((Throwable)new RuntimeException(appResponse.getException().getMessage()));
            }
        }
    }

    public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
        super.onError(e, invoker, invocation);
    }
}

