/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.utils;

import com.bcxin.tenant.domain.entities.SysIndustryTypeEntity;
import com.bcxin.tenant.domain.entities.SysInstitutionalTypeEntity;
import com.bcxin.tenant.domain.repositories.SysIndustryTypeRepository;
import com.bcxin.tenant.domain.repositories.SysInstitutionalTypeRepository;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OrganizationTypeUtils {
    private final SysIndustryTypeRepository sysIndustryTypeRepository;
    private final SysInstitutionalTypeRepository sysInstitutionalTypeRepository;

    public OrganizationTypeUtils(SysIndustryTypeRepository sysIndustryTypeRepository, SysInstitutionalTypeRepository sysInstitutionalTypeRepository) {
        this.sysIndustryTypeRepository = sysIndustryTypeRepository;
        this.sysInstitutionalTypeRepository = sysInstitutionalTypeRepository;
    }

    public String industryCodeOutOfName(String code) {
        if (!StringUtils.hasLength((String)code)) {
            return "";
        }
        SysIndustryTypeEntity industryType = this.sysIndustryTypeRepository.findByCodeAndIsDeleted(code, 0);
        if (industryType != null) {
            return industryType.getName();
        }
        return "";
    }

    public String institutionalCodeOutOfName(String code) {
        if (!StringUtils.hasLength((String)code)) {
            return "";
        }
        SysInstitutionalTypeEntity institutionalType = this.sysInstitutionalTypeRepository.findByCodeAndIsDeleted(code, 0);
        if (institutionalType != null) {
            return institutionalType.getName();
        }
        return "";
    }
}

