/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.services.commands.organizations;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CompanyCertificateType;
import com.bcxin.Infrastructures.enums.CompanyNature;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.EconomicType;
import com.bcxin.Infrastructures.enums.IndustryDetailType;
import com.bcxin.Infrastructures.enums.ParentSubsidiary;
import com.bcxin.Infrastructures.enums.SecurityArmedRating;
import com.bcxin.Infrastructures.enums.SecurityPreparednessRating;
import com.bcxin.Infrastructures.enums.SecuritySafetyDefenseRating;
import com.bcxin.Infrastructures.enums.ServiceScope;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import com.bcxin.tenant.domain.services.commands.organizations.LocationCommandItem;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RegisterCompanyCommand
extends CommandAbstract {
    private final String industryCode;
    private final String institutionalCode;
    private final IndustryDetailType industryDetailType;
    private final String name;
    private final ParentSubsidiary type;
    private final String telephone;
    private final EconomicType economicType;
    private final CompanyNature nature;
    private final LocationCommandItem placeOfRegister;
    private final LocationCommandItem placeOfBusiness;
    private final String parentName;
    private final CompanyCertificateType parentCertificateType;
    private final String parentCertificateNumber;
    private final String parentLegalPersonName;
    private final String parentLegalPersonTelephone;
    private final String legalPersonName;
    private final String legalPersonTelephone;
    private final CredentialType legalPersonCredentialType;
    private final String legalPersonCredentialNumber;
    private final String legalPersonNationality;
    private final String securityPersonName;
    private final String securityPersonTelephone;
    private final CredentialType securityPersonCredentialType;
    private final String securityPersonCredentialNumber;
    private final String registeredCapital;
    private final String fixedCapital;
    private final String annualSalesVolume;
    private final String annualProfitTax;
    private final CompanyCertificateType certificateType;
    private final String unifySocialCreditCode;
    private final String unifySocialCreditCodeFile;
    private final String servicePermitNumber;
    private final String nameOfIssuingAuthority;
    private final Date firstIssueServicePermit;
    private final String servicePermitAttachment;
    private final String securityApprovalNumber;
    private final List<String> serviceScopeList;
    private final SecurityPreparednessRating securityPreparednessRating;
    private final SecurityArmedRating securityArmedRating;
    private final SecuritySafetyDefenseRating securitySafetyDefenseRating;
    private final Boolean isRiskAssessment;
    private final String trainContent;
    private final Integer numberOfSecurityGuards;
    private final Boolean isPublicSecuritySecurity;
    private final Boolean isPropertyEnterprise;
    private final String natureOfSelfRecruitedUnits;
    private final LocationCommandItem placeOfSupervise;
    private final String superviseDepartId;
    private final String superviseDepartName;
    private final ContactCommandItem administrator;
    private final Map<String, String> dynamic;
    private final Map<String, Object> dynamicFields;
    private final String shareOrganizationId;
    private final String shareOrganizationName;
    private final String shareEmployeeId;
    private final String shareEmployeeName;

    public void validate() {
        if (this.getInstitutionalCode().equals("0102") || this.getInstitutionalCode().equals("0103") || this.getInstitutionalCode().equals("0104")) {
            if (this.getType() == null) {
                throw new BadTenantException("\u603b/\u5206/\u5b50\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getTelephone())) {
                throw new BadTenantException("\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.getEconomicType() == null) {
                throw new BadTenantException("\u7ecf\u6d4e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.getNature() == null) {
                throw new BadTenantException("\u516c\u53f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getLegalPersonNationality())) {
                throw new BadTenantException("\u6cd5\u4eba\u56fd\u7c4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getRegisteredCapital())) {
                throw new BadTenantException("\u6ce8\u518c\u8d44\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.validateLocation(this.getPlaceOfSupervise(), "\u76d1\u7ba1\u5730\u533a", false);
            if (StringUtils.isBlank((CharSequence)this.getSuperviseDepartId())) {
                throw new BadTenantException("\u76d1\u7ba1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getSuperviseDepartName())) {
                throw new BadTenantException("\u76d1\u7ba1\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        switch (this.getInstitutionalCode()) {
            case "0102": {
                if (this.getIndustryDetailType() == null) {
                    throw new BadTenantException("\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getFixedCapital())) {
                    throw new BadTenantException("\u56fa\u5b9a\u8d44\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getAnnualSalesVolume())) {
                    throw new BadTenantException("\u5e74\u8425\u4e1a\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getAnnualProfitTax())) {
                    throw new BadTenantException("\u5e74\u5229\u7a0e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getSecurityApprovalNumber())) {
                    throw new BadTenantException("\u6279\u51c6\u6587\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (CollectionUtils.isEmpty(this.getServiceScopeList())) {
                    throw new BadTenantException("\u670d\u52a1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getSecurityPreparednessRating() == null) {
                    throw new BadTenantException("\u4eba\u529b\u9632\u8303\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getSecurityArmedRating() == null) {
                    throw new BadTenantException("\u6b66\u88c5\u5b88\u62a4\u62bc\u8fd0\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getSecuritySafetyDefenseRating() == null) {
                    throw new BadTenantException("\u5b89\u5168\u6280\u672f\u9632\u8303\u8bc4\u5b9a\u7b49\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getIsRiskAssessment() == null) {
                    throw new BadTenantException("\u662f\u5426\u6709\u98ce\u9669\u8bc4\u4f30\u8d44\u8d28\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                for (String serviceScope : this.getServiceScopeList()) {
                    if (!serviceScope.equals(ServiceScope.SecurityRiskAssessment.getTypeValue()) || this.getIsRiskAssessment().booleanValue()) continue;
                    throw new BadTenantException("\u670d\u52a1\u8303\u56f4\u5305\u542b\uff1a\u5b89\u5168\u98ce\u9669\u8bc4\u4f30\uff0c\u662f\u5426\u6709\u98ce\u9669\u8bc4\u4f30\u8d44\u8d28\u5fc5\u987b\u9009\u62e9\uff1a\u662f");
                }
                if (StringUtils.isBlank((CharSequence)this.getServicePermitNumber())) {
                    throw new BadTenantException("\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getNameOfIssuingAuthority())) {
                    throw new BadTenantException("\u53d1\u8bc1\u673a\u5173\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getFirstIssueServicePermit() == null) {
                    throw new BadTenantException("\u53d1\u8bc1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getServicePermitAttachment())) {
                    throw new BadTenantException("\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1\u626b\u63cf\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getType().ordinal() != ParentSubsidiary.Branch.ordinal() && this.getType().ordinal() != ParentSubsidiary.Subsidiary.ordinal()) break;
                if (StringUtils.isBlank((CharSequence)this.getParentName())) {
                    throw new BadTenantException("\u603b\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getParentCertificateType() == null) {
                    throw new BadTenantException("\u603b\u516c\u53f8\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getParentCertificateNumber())) {
                    throw new BadTenantException("\u603b\u516c\u53f8\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getParentLegalPersonName())) {
                    throw new BadTenantException("\u603b\u516c\u53f8\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isBlank((CharSequence)this.getParentLegalPersonTelephone())) break;
                throw new BadTenantException("\u603b\u516c\u53f8\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            case "0103": {
                if (StringUtils.isBlank((CharSequence)this.getTrainContent())) {
                    throw new BadTenantException("\u57f9\u8bad\u5355\u4f4d\u7684\u57f9\u8bad\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getServicePermitNumber())) {
                    throw new BadTenantException("\u4fdd\u5b89\u57f9\u8bad\u8bb8\u53ef\uff08\u5907\u6848\uff09\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getNameOfIssuingAuthority())) {
                    throw new BadTenantException("\u53d1\u8bc1\u673a\u5173\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getFirstIssueServicePermit() == null) {
                    throw new BadTenantException("\u53d1\u8bc1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isBlank((CharSequence)this.getServicePermitAttachment())) break;
                throw new BadTenantException("\u4fdd\u5b89\u57f9\u8bad\u8bb8\u53ef\uff08\u5907\u6848\uff09\u8bc1\u626b\u63cf\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            case "0104": {
                if (StringUtils.isBlank((CharSequence)this.getSecurityPersonName())) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)this.getSecurityPersonTelephone())) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (this.getSecurityPersonCredentialType() == null) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)this.getSecurityPersonCredentialNumber())) {
                    throw new BadTenantException("\u4fdd\u5b89\u8d1f\u8d23\u4eba\u8bc1\u4ef6\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (this.getNumberOfSecurityGuards() == null) {
                    throw new BadTenantException("\u62df\u81ea\u62db\u4fdd\u5b89\u5458\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getIsPublicSecuritySecurity() == null) {
                    throw new BadTenantException("\u662f\u5426\u6cbb\u5b89\u4fdd\u536b\u91cd\u70b9\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.getIsPropertyEnterprise() == null) {
                    throw new BadTenantException("\u662f\u5426\u7269\u4e1a\u4f01\u4e1a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isBlank((CharSequence)this.getNatureOfSelfRecruitedUnits())) break;
                throw new BadTenantException("\u81ea\u62db\u4fdd\u5b89\u5355\u4f4d\u6027\u8d28\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if ("01".contains(this.getIndustryCode())) {
            if (!this.getInstitutionalCode().equals("0406")) {
                this.validateLocation(this.getPlaceOfRegister(), "\u6ce8\u518c\u5730\u533a", true);
                if (this.getCertificateType() == null) {
                    throw new BadTenantException("\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getUnifySocialCreditCode())) {
                    throw new BadTenantException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtils.isBlank((CharSequence)this.getUnifySocialCreditCodeFile())) {
                    throw new BadTenantException("\u8425\u4e1a\u6267\u7167\u626b\u63cf\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            this.validateLocation(this.getPlaceOfBusiness(), "\u7ecf\u8425\u5730\u533a", true);
            if (StringUtils.isBlank((CharSequence)this.getLegalPersonName())) {
                throw new BadTenantException("\u6cd5\u4eba\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getLegalPersonTelephone())) {
                throw new BadTenantException("\u6cd5\u4eba\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.getLegalPersonCredentialType() == null) {
                throw new BadTenantException("\u6cd5\u4eba\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getLegalPersonCredentialNumber())) {
                throw new BadTenantException("\u6cd5\u4eba\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if ("02,07".equals(this.getIndustryCode())) {
            this.validateLocation(this.getPlaceOfBusiness(), "\u529e\u516c\u5730\u533a", true);
        }
        if ("04,06".contains(this.getIndustryCode())) {
            this.validateLocation(this.getPlaceOfSupervise(), "\u76d1\u7ba1\u5730\u533a", false);
            if (StringUtils.isBlank((CharSequence)this.getSuperviseDepartId())) {
                throw new BadTenantException("\u76d1\u7ba1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((CharSequence)this.getSuperviseDepartName())) {
                throw new BadTenantException("\u76d1\u7ba1\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        this.validateContact(this.getAdministrator(), "\u7cfb\u7edf\u7ba1\u7406\u5458", false);
    }

    private void validateContact(ContactCommandItem commandItem, String category, boolean isValidNationality) {
        if (commandItem == null) {
            throw new BadTenantException(String.format("%s\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (StringUtils.isBlank((CharSequence)commandItem.getName())) {
            throw new BadTenantException(String.format("%s\u7684\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (StringUtils.isBlank((CharSequence)commandItem.getTelephone())) {
            throw new BadTenantException(String.format("%s\u7684\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (commandItem.getCredentialType() == null) {
            throw new BadTenantException(String.format("%s\u7684\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (StringUtils.isBlank((CharSequence)commandItem.getCredentialNumber())) {
            throw new BadTenantException(String.format("%s\u7684\u8bc1\u4ef6\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (isValidNationality && StringUtils.isBlank((CharSequence)commandItem.getNationality())) {
            throw new BadTenantException(String.format("%s\u7684\u56fd\u7c4d\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
    }

    private void validateLocation(LocationCommandItem commandItem, String category, boolean isValidAddress) {
        if (commandItem == null) {
            throw new BadTenantException(String.format("%s\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (commandItem.getProvince() == null || StringUtils.isBlank((CharSequence)commandItem.getProvince().getCode())) {
            throw new BadTenantException(String.format("%s\u7684\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
        if (isValidAddress && StringUtils.isBlank((CharSequence)commandItem.getAddress())) {
            throw new BadTenantException(String.format("%s\u7684\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!", category));
        }
    }

    public static RegisterCompanyCommand create(CompanyRegistrationRequest registrationRequest) {
        return new RegisterCompanyCommand(registrationRequest.getIndustryCode(), registrationRequest.getInstitutionalCode(), registrationRequest.getIndustryDetailType(), registrationRequest.getName(), registrationRequest.getType(), registrationRequest.getTelephone(), registrationRequest.getEconomicType(), registrationRequest.getNature(), LocationCommandItem.create(registrationRequest.getPlaceOfRegister()), LocationCommandItem.create(registrationRequest.getPlaceOfBusiness()), registrationRequest.getParentName(), registrationRequest.getParentCertificateType(), registrationRequest.getParentCertificateNumber(), registrationRequest.getParentLegalPersonName(), registrationRequest.getParentLegalPersonTelephone(), registrationRequest.getLegalPersonName(), registrationRequest.getLegalPersonTelephone(), registrationRequest.getLegalPersonCredentialType(), registrationRequest.getLegalPersonCredentialNumber(), registrationRequest.getLegalPersonNationality(), registrationRequest.getSecurityPersonName(), registrationRequest.getSecurityPersonTelephone(), registrationRequest.getSecurityPersonCredentialType(), registrationRequest.getSecurityPersonCredentialNumber(), registrationRequest.getRegisteredCapital(), registrationRequest.getFixedCapital(), registrationRequest.getAnnualSalesVolume(), registrationRequest.getAnnualProfitTax(), registrationRequest.getCertificateType(), registrationRequest.getUnifySocialCreditCode(), registrationRequest.getUnifySocialCreditCodeFile(), registrationRequest.getServicePermitNumber(), registrationRequest.getNameOfIssuingAuthority(), registrationRequest.getFirstIssueServicePermit(), registrationRequest.getServicePermitAttachment(), registrationRequest.getSecurityApprovalNumber(), registrationRequest.getServiceScopeList(), registrationRequest.getSecurityPreparednessRating(), registrationRequest.getSecurityArmedRating(), registrationRequest.getSecuritySafetyDefenseRating(), registrationRequest.getIsRiskAssessment(), registrationRequest.getTrainContent(), registrationRequest.getNumberOfSecurityGuards(), registrationRequest.getIsPublicSecuritySecurity(), registrationRequest.getIsPropertyEnterprise(), registrationRequest.getNatureOfSelfRecruitedUnits(), LocationCommandItem.create(registrationRequest.getPlaceOfSupervise()), registrationRequest.getSuperviseDepartId(), registrationRequest.getSuperviseDepartName(), ContactCommandItem.create(registrationRequest.getAdministrator()), registrationRequest.getDynamic(), registrationRequest.getDynamicFields(), registrationRequest.getShareOrganizationId(), registrationRequest.getShareOrganizationName(), registrationRequest.getShareEmployeeId(), registrationRequest.getShareEmployeeName());
    }

    public RegisterCompanyCommand(String industryCode, String institutionalCode, IndustryDetailType industryDetailType, String name, ParentSubsidiary type, String telephone, EconomicType economicType, CompanyNature nature, LocationCommandItem placeOfRegister, LocationCommandItem placeOfBusiness, String parentName, CompanyCertificateType parentCertificateType, String parentCertificateNumber, String parentLegalPersonName, String parentLegalPersonTelephone, String legalPersonName, String legalPersonTelephone, CredentialType legalPersonCredentialType, String legalPersonCredentialNumber, String legalPersonNationality, String securityPersonName, String securityPersonTelephone, CredentialType securityPersonCredentialType, String securityPersonCredentialNumber, String registeredCapital, String fixedCapital, String annualSalesVolume, String annualProfitTax, CompanyCertificateType certificateType, String unifySocialCreditCode, String unifySocialCreditCodeFile, String servicePermitNumber, String nameOfIssuingAuthority, Date firstIssueServicePermit, String servicePermitAttachment, String securityApprovalNumber, List<String> serviceScopeList, SecurityPreparednessRating securityPreparednessRating, SecurityArmedRating securityArmedRating, SecuritySafetyDefenseRating securitySafetyDefenseRating, Boolean isRiskAssessment, String trainContent, Integer numberOfSecurityGuards, Boolean isPublicSecuritySecurity, Boolean isPropertyEnterprise, String natureOfSelfRecruitedUnits, LocationCommandItem placeOfSupervise, String superviseDepartId, String superviseDepartName, ContactCommandItem administrator, Map<String, String> dynamic, Map<String, Object> dynamicFields, String shareOrganizationId, String shareOrganizationName, String shareEmployeeId, String shareEmployeeName) {
        this.industryCode = industryCode;
        this.institutionalCode = institutionalCode;
        this.industryDetailType = industryDetailType;
        this.name = name;
        this.type = type;
        this.telephone = telephone;
        this.economicType = economicType;
        this.nature = nature;
        this.placeOfRegister = placeOfRegister;
        this.placeOfBusiness = placeOfBusiness;
        this.parentName = parentName;
        this.parentCertificateType = parentCertificateType;
        this.parentCertificateNumber = parentCertificateNumber;
        this.parentLegalPersonName = parentLegalPersonName;
        this.parentLegalPersonTelephone = parentLegalPersonTelephone;
        this.legalPersonName = legalPersonName;
        this.legalPersonTelephone = legalPersonTelephone;
        this.legalPersonCredentialType = legalPersonCredentialType;
        this.legalPersonCredentialNumber = legalPersonCredentialNumber;
        this.legalPersonNationality = legalPersonNationality;
        this.securityPersonName = securityPersonName;
        this.securityPersonTelephone = securityPersonTelephone;
        this.securityPersonCredentialType = securityPersonCredentialType;
        this.securityPersonCredentialNumber = securityPersonCredentialNumber;
        this.registeredCapital = registeredCapital;
        this.fixedCapital = fixedCapital;
        this.annualSalesVolume = annualSalesVolume;
        this.annualProfitTax = annualProfitTax;
        this.certificateType = certificateType;
        this.unifySocialCreditCode = unifySocialCreditCode;
        this.unifySocialCreditCodeFile = unifySocialCreditCodeFile;
        this.servicePermitNumber = servicePermitNumber;
        this.nameOfIssuingAuthority = nameOfIssuingAuthority;
        this.firstIssueServicePermit = firstIssueServicePermit;
        this.servicePermitAttachment = servicePermitAttachment;
        this.securityApprovalNumber = securityApprovalNumber;
        this.serviceScopeList = serviceScopeList;
        this.securityPreparednessRating = securityPreparednessRating;
        this.securityArmedRating = securityArmedRating;
        this.securitySafetyDefenseRating = securitySafetyDefenseRating;
        this.isRiskAssessment = isRiskAssessment;
        this.trainContent = trainContent;
        this.numberOfSecurityGuards = numberOfSecurityGuards;
        this.isPublicSecuritySecurity = isPublicSecuritySecurity;
        this.isPropertyEnterprise = isPropertyEnterprise;
        this.natureOfSelfRecruitedUnits = natureOfSelfRecruitedUnits;
        this.placeOfSupervise = placeOfSupervise;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.administrator = administrator;
        this.dynamic = dynamic;
        this.dynamicFields = dynamicFields;
        if (this.industryCode.equals("04")) {
            this.shareOrganizationId = shareOrganizationId;
            this.shareOrganizationName = shareOrganizationName;
            this.shareEmployeeId = shareEmployeeId;
            this.shareEmployeeName = shareEmployeeName;
        } else {
            this.shareOrganizationId = null;
            this.shareOrganizationName = null;
            this.shareEmployeeId = null;
            this.shareEmployeeName = null;
        }
    }

    public String getIndustryCode() {
        return this.industryCode;
    }

    public String getInstitutionalCode() {
        return this.institutionalCode;
    }

    public IndustryDetailType getIndustryDetailType() {
        return this.industryDetailType;
    }

    public String getName() {
        return this.name;
    }

    public ParentSubsidiary getType() {
        return this.type;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public EconomicType getEconomicType() {
        return this.economicType;
    }

    public CompanyNature getNature() {
        return this.nature;
    }

    public LocationCommandItem getPlaceOfRegister() {
        return this.placeOfRegister;
    }

    public LocationCommandItem getPlaceOfBusiness() {
        return this.placeOfBusiness;
    }

    public String getParentName() {
        return this.parentName;
    }

    public CompanyCertificateType getParentCertificateType() {
        return this.parentCertificateType;
    }

    public String getParentCertificateNumber() {
        return this.parentCertificateNumber;
    }

    public String getParentLegalPersonName() {
        return this.parentLegalPersonName;
    }

    public String getParentLegalPersonTelephone() {
        return this.parentLegalPersonTelephone;
    }

    public String getLegalPersonName() {
        return this.legalPersonName;
    }

    public String getLegalPersonTelephone() {
        return this.legalPersonTelephone;
    }

    public CredentialType getLegalPersonCredentialType() {
        return this.legalPersonCredentialType;
    }

    public String getLegalPersonCredentialNumber() {
        return this.legalPersonCredentialNumber;
    }

    public String getLegalPersonNationality() {
        return this.legalPersonNationality;
    }

    public String getSecurityPersonName() {
        return this.securityPersonName;
    }

    public String getSecurityPersonTelephone() {
        return this.securityPersonTelephone;
    }

    public CredentialType getSecurityPersonCredentialType() {
        return this.securityPersonCredentialType;
    }

    public String getSecurityPersonCredentialNumber() {
        return this.securityPersonCredentialNumber;
    }

    public String getRegisteredCapital() {
        return this.registeredCapital;
    }

    public String getFixedCapital() {
        return this.fixedCapital;
    }

    public String getAnnualSalesVolume() {
        return this.annualSalesVolume;
    }

    public String getAnnualProfitTax() {
        return this.annualProfitTax;
    }

    public CompanyCertificateType getCertificateType() {
        return this.certificateType;
    }

    public String getUnifySocialCreditCode() {
        return this.unifySocialCreditCode;
    }

    public String getUnifySocialCreditCodeFile() {
        return this.unifySocialCreditCodeFile;
    }

    public String getServicePermitNumber() {
        return this.servicePermitNumber;
    }

    public String getNameOfIssuingAuthority() {
        return this.nameOfIssuingAuthority;
    }

    public Date getFirstIssueServicePermit() {
        return this.firstIssueServicePermit;
    }

    public String getServicePermitAttachment() {
        return this.servicePermitAttachment;
    }

    public String getSecurityApprovalNumber() {
        return this.securityApprovalNumber;
    }

    public List<String> getServiceScopeList() {
        return this.serviceScopeList;
    }

    public SecurityPreparednessRating getSecurityPreparednessRating() {
        return this.securityPreparednessRating;
    }

    public SecurityArmedRating getSecurityArmedRating() {
        return this.securityArmedRating;
    }

    public SecuritySafetyDefenseRating getSecuritySafetyDefenseRating() {
        return this.securitySafetyDefenseRating;
    }

    public Boolean getIsRiskAssessment() {
        return this.isRiskAssessment;
    }

    public String getTrainContent() {
        return this.trainContent;
    }

    public Integer getNumberOfSecurityGuards() {
        return this.numberOfSecurityGuards;
    }

    public Boolean getIsPublicSecuritySecurity() {
        return this.isPublicSecuritySecurity;
    }

    public Boolean getIsPropertyEnterprise() {
        return this.isPropertyEnterprise;
    }

    public String getNatureOfSelfRecruitedUnits() {
        return this.natureOfSelfRecruitedUnits;
    }

    public LocationCommandItem getPlaceOfSupervise() {
        return this.placeOfSupervise;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public ContactCommandItem getAdministrator() {
        return this.administrator;
    }

    public Map<String, String> getDynamic() {
        return this.dynamic;
    }

    public Map<String, Object> getDynamicFields() {
        return this.dynamicFields;
    }

    public String getShareOrganizationId() {
        return this.shareOrganizationId;
    }

    public String getShareOrganizationName() {
        return this.shareOrganizationName;
    }

    public String getShareEmployeeId() {
        return this.shareEmployeeId;
    }

    public String getShareEmployeeName() {
        return this.shareEmployeeName;
    }

    public static class ContactCommandItem {
        private final String name;
        private final String telephone;
        private final CredentialType credentialType;
        private final String credentialNumber;
        private final String nationality;

        public ContactCommandItem(String name, String telephone, CredentialType credentialType, String credentialNumber, String nationality) {
            this.name = name;
            this.telephone = telephone;
            this.credentialType = credentialType;
            this.credentialNumber = credentialNumber;
            this.nationality = nationality;
        }

        public static ContactCommandItem create(String name, String telephone, CredentialType credentialType, String credentialNumber) {
            return new ContactCommandItem(name, telephone, credentialType, credentialNumber, null);
        }

        public static ContactCommandItem create(CompanyRegistrationRequest.ContactRequest contactRequest) {
            if (contactRequest != null) {
                return new ContactCommandItem(contactRequest.getName(), contactRequest.getTelephone(), contactRequest.getCredentialType(), contactRequest.getCredentialNumber(), contactRequest.getNationality());
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getTelephone() {
            return this.telephone;
        }

        public CredentialType getCredentialType() {
            return this.credentialType;
        }

        public String getCredentialNumber() {
            return this.credentialNumber;
        }

        public String getNationality() {
            return this.nationality;
        }
    }
}

