/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.domain.events.handlers;

import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.entities.EmployeeEntity;
import com.bcxin.tenant.domain.entities.EmployeeEventEntity;
import com.bcxin.tenant.domain.entities.EmployeeRecordEntity;
import com.bcxin.tenant.domain.enums.EmployeeEventType;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.EmployeeAfterCreatedEvent;
import com.bcxin.tenant.domain.repositories.EmployeeEventRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRecordRepository;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import com.bcxin.tenant.domain.snapshots.TenantEmployeeSnapshot;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class EmployeeAfterCreatedEvent_Handler
extends DomainEventHandlerAbstract<EmployeeAfterCreatedEvent> {
    private final TenantEventService tenantEventService;
    private final JsonProvider jsonProvider;
    private final EmployeeEventRepository employeeEventRepository;
    private final EmployeeRecordRepository employeeRecordRepository;

    public EmployeeAfterCreatedEvent_Handler(TenantEventService tenantEventService, JsonProvider jsonProvider, EmployeeEventRepository employeeEventRepository, EmployeeRecordRepository employeeRecordRepository) {
        this.tenantEventService = tenantEventService;
        this.jsonProvider = jsonProvider;
        this.employeeEventRepository = employeeEventRepository;
        this.employeeRecordRepository = employeeRecordRepository;
    }

    protected void execute(EmployeeAfterCreatedEvent event) {
        TenantEmployeeSnapshot snapshot = TenantEmployeeSnapshot.create(((EmployeeEntity)((Object)event.getData())).getId());
        String json = this.jsonProvider.getJson((Object)snapshot);
        this.tenantEventService.create(CreateTenantEventCommand.create(EventAction.EmployeeCreated, json, event.getTelephone()));
        Timestamp hiredDate = null;
        hiredDate = event.getData() != null && ((EmployeeEntity)((Object)event.getData())).getHiredDate() != null ? Timestamp.valueOf(DateUtil.toLocalDateTime((Date)((EmployeeEntity)((Object)event.getData())).getHiredDate())) : (event.getData() == null ? new Timestamp(System.currentTimeMillis()) : ((EmployeeEntity)((Object)event.getData())).getCreatedTime());
        this.employeeEventRepository.save((EntityAbstract)EmployeeEventEntity.create((EmployeeEntity)((Object)event.getData()), EmployeeEventType.EntryJob, hiredDate, "\u5165\u804c"));
        EmployeeRecordEntity record = EmployeeRecordEntity.create((EmployeeEntity)((Object)event.getData()));
        this.employeeRecordRepository.save(record);
    }
}

