/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import java.util.Collection;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class AppRolePermissionResponse
extends ResponseAbstract {
    private final String employeeId;
    private final Collection<AppResponse> apps;

    public AppRolePermissionResponse(String employeeId, Collection<AppResponse> apps) {
        this.employeeId = employeeId;
        this.apps = apps;
    }

    public static AppRolePermissionResponse create(String employeeId, Collection<AppResponse> apps) {
        return new AppRolePermissionResponse(employeeId, apps);
    }

    public String toString() {
        if (CollectionUtils.isEmpty(this.getApps())) {
            return null;
        }
        return this.getApps().stream().map(ii -> ii.toString()).collect(Collectors.joining(";"));
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public Collection<AppResponse> getApps() {
        return this.apps;
    }

    public static class RoleResponse
    extends ResponseAbstract {
        private final String id;
        private final String name;

        public RoleResponse(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static RoleResponse create(String id, String name) {
            return new RoleResponse(id, name);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class AppResponse
    extends ResponseAbstract {
        private final String appId;
        private final String appName;
        private final Collection<RoleResponse> roles;

        public AppResponse(String appId, String appName, Collection<RoleResponse> roles) {
            this.appId = appId;
            this.appName = appName;
            this.roles = roles;
        }

        public static AppResponse create(String appId, String appName, Collection<RoleResponse> roles) {
            return new AppResponse(appId, appName, roles);
        }

        public String toString() {
            return String.format("\u3010%s\u3011%s", this.getAppName(), this.getRoles().stream().map(ix -> ix.getName()).collect(Collectors.joining(",")));
        }

        public String getAppId() {
            return this.appId;
        }

        public String getAppName() {
            return this.appName;
        }

        public Collection<RoleResponse> getRoles() {
            return this.roles;
        }
    }
}

