package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class WechatBindCommand extends CommandAbstract {
    private final String tenantId;
    private final String openId;
    private final String nicky;
    private final String unionId;

    public WechatBindCommand(String tenantId, String openId,String nicky, String unionId) {
        this.tenantId = tenantId;
        this.openId = openId;
        this.nicky = nicky;
        this.unionId = unionId;
    }

    public static WechatBindCommand create(String tenantId, String openId,String nicky, String unionId) {
        return new WechatBindCommand(tenantId, openId,nicky, unionId);
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getTenantId())) {
            throw new ArgumentTenantException("当前用户信息无效");
        }

        if (!StringUtils.hasLength(this.getOpenId())) {
            throw new ArgumentTenantException("微信OpenId不能为空");
        }

    }
}
