package com.bcxin.identity.domains.readers.dtos;

import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import lombok.Getter;

@Getter
public class UserReaderDto {
    private final String id;
    private final String name;
    private final RealNameAuthenticatedStatus authenticatedStatus;
    private final String telephone;
    private final String headPhoto;
    private final UserCheckedStatus status;

    private UserReaderDto(String id, String name, String telephone,
                          RealNameAuthenticatedStatus authenticatedStatus,
                          String headPhoto, UserCheckedStatus status) {
        this.id = id;
        this.name = name;
        this.authenticatedStatus = authenticatedStatus;
        this.telephone = telephone;
        this.headPhoto = headPhoto;
        this.status = status;
    }

    public static UserReaderDto create(String id, String name, String telephone,
                                       RealNameAuthenticatedStatus authenticatedStatus,
                                       String headPhoto, UserCheckedStatus status) {
        return new UserReaderDto(id, name, telephone, authenticatedStatus, headPhoto, status);
    }
}
