package com.bcxin.identity.domains.components;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.identity.domains.components.commands.ForgetPasswordActionExecuteCommand;
import com.bcxin.identity.domains.services.commandResult.PrepareResetPasswordCommandResult;
import com.bcxin.identity.domains.utils.JwtUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@Component("FaceIdentityForgetPasswordExecutorImpl")
public class FaceIdentityForgetPasswordExecutorImpl implements ForgetPasswordExecutorImpl {
    private final String identityWebSite;

    public FaceIdentityForgetPasswordExecutorImpl(
            @Value("${identity.face.website}")
            String identityWebSite) {
        this.identityWebSite = identityWebSite;
    }


    @Override
    public PrepareResetPasswordCommandResult execute(ForgetPasswordActionExecuteCommand command) {
        if (command.getUserCheckedStatus() != UserCheckedStatus.Matched) {
            return new PrepareResetPasswordCommandResult(null, false, "-3", null);
        }

        Map<String, Object> faceParams = new HashMap<>();
        faceParams.put("oneImg", command.getDataNoe());
        faceParams.put("twoImg", command.getDataTow());
        faceParams.put("bizFaceMode", "UNIAPP");
        faceParams.put("bizFaceMode", "UNIAPP");
        faceParams.put("vtp", 70);
        String facePost = null;
        try {
            facePost = HttpUtil.post(identityWebSite, faceParams);
            cn.hutool.json.JSONObject faceJsonObject = JSONUtil.parseObj(facePost);
            String retType = (String) faceJsonObject.get("retType");
            if ("0".equals(retType)) {
                //调用成功
                cn.hutool.json.JSONObject faceJson = (cn.hutool.json.JSONObject) faceJsonObject.get("data");
                String faceResult = (String) faceJson.get("result");
                if ("1".equals(faceResult)) {
                    Map<String, Object> map = new HashMap<>();
                    map.put("GetPasswordType", "0");
                    map.put("loginName", command.getLoginName());
                    map.put("time", DateUtil.now());
                    String json = JSON.toJSONString(map);
                    // 生成jwt
                    String jwt = JwtUtil.createJwt(json);
                    return new PrepareResetPasswordCommandResult(jwt, true, "200", null);
                }
                return new PrepareResetPasswordCommandResult("比对失败,msg:" + faceJson.get("response"), false, "-1", null);
            } else {
                return new PrepareResetPasswordCommandResult("调用失败", false, "-1", null);
            }
        } catch (Exception ex) {
            throw new BadTenantException(String.format("人脸找回密码发生异常-API=%s;响应内容:%s", identityWebSite, facePost), ex);
        }
    }
}
