/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.JwtUtil;
import com.bcxin.api.interfaces.enums.UpdatePasswordType;
import com.bcxin.identity.domains.utils.SecurityUtil;

public class SignInCommand
extends CommandAbstract {
    private final String userName;
    private final String password;
    private final String ipAddress;
    private final boolean isFromMobile;
    private final boolean validPassword;

    public SignInCommand(String userName, String password, boolean isFromMobile, String ipAddress) {
        this.userName = userName;
        this.password = password;
        this.isFromMobile = isFromMobile;
        this.validPassword = true;
        this.ipAddress = ipAddress;
    }

    public SignInCommand(String userName, String password, boolean isFromMobile, boolean validPassword, String ipAddress) {
        this.userName = userName;
        this.password = password;
        this.isFromMobile = isFromMobile;
        this.validPassword = validPassword;
        this.ipAddress = ipAddress;
    }

    public String getDecodedPassword() {
        try {
            String edPassword = this.getPassword();
            if (edPassword != null && edPassword.length() > 2) {
                String lp = edPassword.substring(0, edPassword.length() - 2);
                String rp = edPassword.substring(edPassword.length() - 2, edPassword.length());
                edPassword = SecurityUtil.decodeBASE64(rp + lp);
            }
            return edPassword;
        }
        catch (Exception ex) {
            throw new BadTenantException("\u5bc6\u7801\u65e0\u6548");
        }
    }

    public static SignInCommand create(String userName, String password, boolean isFromMobile, String ipAddress) {
        return new SignInCommand(userName, password, isFromMobile, ipAddress);
    }

    public static SignInCommand create(String userName, String password, boolean isFromMobile, boolean validPassword, String ipAddress) {
        return new SignInCommand(userName, password, isFromMobile, validPassword, ipAddress);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean isFromMobile() {
        return this.isFromMobile;
    }

    public boolean isValidPassword() {
        return this.validPassword;
    }

    public static class SignInCommandResult {
        private final String id;
        private final String name;
        private final String idNum;
        private final String token;
        private final String tenantUserId;
        private final UpdatePasswordType updatePasswordType;

        public SignInCommandResult(String id, String tenantUserId, String name, String idNum, boolean isFromMobile, UpdatePasswordType updatePasswordType) {
            this.id = id;
            this.name = name;
            this.idNum = idNum;
            this.tenantUserId = tenantUserId;
            this.updatePasswordType = updatePasswordType;
            this.token = isFromMobile ? JwtUtil.getMobileToken((String)tenantUserId) : JwtUtil.getToken((String)tenantUserId);
        }

        public static SignInCommandResult create(String id, String tenantUserId, String name, String idNum, boolean isFromMobile, UpdatePasswordType updatePasswordType) {
            return new SignInCommandResult(id, tenantUserId, name, idNum, isFromMobile, updatePasswordType);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getIdNum() {
            return this.idNum;
        }

        public String getToken() {
            return this.token;
        }

        public String getTenantUserId() {
            return this.tenantUserId;
        }

        public UpdatePasswordType getUpdatePasswordType() {
            return this.updatePasswordType;
        }
    }
}

