package com.bcxin.ferry.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

 /**
 * 接收任务表;
 * @author : linchunpeng
 * @date : 2024-3-6
 */
@Data
@TableName("ferry_receive_task")
public class FerryReceiveTaskEntity implements Serializable {

private static final long serialVersionUID = 1L;
    
    //主键id
    @TableId(value = "id")
    private Long id;
    
    //摆渡任务id
    private Long ferryTaskId;

     //请求id
     private String requestId;
    
    //摆渡包文件目录url
    private String packageUrl;
    
    //文件总数
    private Integer fileTotalCount;
    
    //文件已接收总数
    private Integer fileReceiveCount;
    
    //任务状态，1-接收请求，2-解析任务文件，3-初始化任务信息，4-回调请求端，5-接收明细文件开始，6-接收明细文件完成，7-合并文件开始，8-合并文件完成，9-执行推送操作，10-摆渡完成
    private Integer taskStatus;
    
    //接收结果
    private String receiveResult;
    
    //创建时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date createTime;
    
    //更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date updateTime;

}