package com.bcxin.ferry.common.emus;

/**
 * 摆渡任务状态，1-开始拉取，2-拉取完成，3-扫描摆渡文件完成，9-摆渡任务完成，-1-摆渡失败
 */
public enum FerryTaskStatusEnum {

    //开始拉取
    BEGIN_PULL(1, "开始拉取"),
    //拉取完成
    PULL_COMPLETE(2, "拉取完成"),
    //放入发送文件夹完成
    PUT_SEND_COMPLETE(3, "放入发送文件夹完成"),
    //摆渡任务完成
    FERRY_TASK_COMPLETE(9, "摆渡任务完成"),
    //摆渡失败
    FERRY_FAIL(-1, "摆渡失败");
    /**
     * 状态代码
     */
    private int code;
    /**
     * 默认消息
     */
    private String defaultMessage;

    FerryTaskStatusEnum(int code, String defaultMessage) {
        this.code = code;
        this.defaultMessage = defaultMessage;
    }

    /**
     * 获取状态代码
     */
    public int getCode() {
        return this.code;
    }

    /**
     * 获取默认消息
     */
    public String getDefaultMessage() {
        return this.defaultMessage;
    }
}
