package com.bcxin.shared.rest.web.apis.controllers.commons;

import com.bcxin.api.interfaces.commons.ConfigRpcProvider;
import com.bcxin.api.interfaces.commons.RegionRpcProvider;
import com.bcxin.rest.web.commons.ControllerAbstract;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/common/config")
public class SysConfigController extends ControllerAbstract {

    private final ConfigRpcProvider configRpcProvider;

    public SysConfigController(ConfigRpcProvider configRpcProvider) {
        this.configRpcProvider = configRpcProvider;
    }


    @GetMapping("/getValue")
    public ResponseEntity getValue(String configKey) {
        return this.ok(this.configRpcProvider.getValueByKey(configKey));
    }

    @GetMapping("/reload")
    public ResponseEntity reload(String configKey) {
        this.configRpcProvider.reload(configKey);
        return this.ok();
    }

}
