package com.bcxin.rest.web.apis.responses;

import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

@ApiModel(description = "ExternalMemberInviteInfoResponse 邀请的基本信息")
@Getter
public class ExternalMemberInviteInfoResponse extends ResponseAbstract {

    @ApiModelProperty("邀请人用户employeeId")
    private final String employeeId;
    @ApiModelProperty("邀请人用户姓名")
    private final String name;

    @ApiModelProperty("邀请人用户姓名")
    private final String organizationId;

    @ApiModelProperty("邀请加入的团体")
    private final String organizationName;

    public ExternalMemberInviteInfoResponse(String employeeId, String name, String organizationId, String organizationName) {
        this.employeeId = employeeId;
        this.name = name;
        this.organizationId = organizationId;
        this.organizationName = organizationName;
    }

    public static ExternalMemberInviteInfoResponse create(String employeeId, String name, String organizationId, String organizationName){
        return new ExternalMemberInviteInfoResponse(employeeId,name,organizationId,organizationName);
    }
}
