package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.tenants.OrgRelationRpcProvider;
import com.bcxin.api.interfaces.tenants.responses.OrgRelationResponse;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/tenant/organizations/{organizationId}/relation")
public class OrgRelationController extends ControllerAbstract {

    private final OrgRelationRpcProvider orgRelationRpcProvider;


    public OrgRelationController(OrgRelationRpcProvider orgRelationRpcProvider) {
        this.orgRelationRpcProvider = orgRelationRpcProvider;
    }


    /*@ApiOperation(value = "查询组织信息", response = OrgRelationResponse.class)
    @GetMapping("/search")
    public ResponseEntity search(@PathVariable String organizationId) {
        OrgRelationResponse data = this.orgRelationRpcProvider.getParentList(organizationId);
        return this.ok(data);
    }*/


    @ApiOperation(value = "新增上级组织", response = String.class)
    @PostMapping("add/{parentOrgId}")
    public ResponseEntity add(@PathVariable String organizationId,@PathVariable String parentOrgId) {
        String orgRelationId = this.orgRelationRpcProvider.create(organizationId, parentOrgId);
        return this.ok(orgRelationId);
    }

    @ApiOperation(value = "解绑", response = Void.class)
    @PostMapping("/relieve/{relationId}")
    public ResponseEntity relieve(@PathVariable String relationId) {
        this.orgRelationRpcProvider.relieve(relationId);
        return this.ok();
    }

    @ApiOperation(value = "获取上级组织列表", response = OrgRelationResponse.class)
    @GetMapping("/getParentList")
    public ResponseEntity getParentList(@PathVariable String organizationId) {
        List<OrgRelationResponse> data = this.orgRelationRpcProvider.getParentList(organizationId);
        return this.ok(data);
    }

    @ApiOperation(value = "获取下级组织列表", response = OrgRelationResponse.class)
    @GetMapping("/getChildrenList")
    public ResponseEntity getChildrenList(@PathVariable String organizationId) {
        List<OrgRelationResponse> data = this.orgRelationRpcProvider.getChildrenList(organizationId);
        return this.ok(data);
    }

}
