package com.bcxin.tenant.apis.translates.impls;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.api.interfaces.commons.responses.CompanyResponse;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyRegistrationRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.CompanyUpdateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationApproveGetResponse;
import com.bcxin.tenant.apis.translates.OrganizationTranslate;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.entities.CompanyEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.entities.valueTypes.ItemValueType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.services.commands.organizations.ItemValueCommandItem;
import com.bcxin.tenant.domain.services.commands.organizations.LocationCommandItem;
import com.bcxin.tenant.domain.services.commands.organizations.RegisterCompanyCommand;
import com.bcxin.tenant.domain.services.commands.organizations.UpdateCompanyCommand;
import com.bcxin.tenant.domain.utils.OrganizationTypeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Component
public class OrganizationTranslateImpl implements OrganizationTranslate {

    private final JsonProvider jsonProvider;

    private final EnvConfig envConfig;

    public OrganizationTranslateImpl(JsonProvider jsonProvider, EnvConfig envConfig) {
        this.jsonProvider = jsonProvider;
        this.envConfig = envConfig;
    }

    /**
     * description: 数据转换
     * author: linchunpeng
     * date:  2023-05-09 13:55
     */
    @Override
    public RegisterCompanyCommand translate(CompanyRegistrationRequest request) {
        //创建企业注册信息对象
        return RegisterCompanyCommand.create(request);
    }

    @Override
    public UpdateCompanyCommand translate(CompanyUpdateRequest request) {
        UpdateCompanyCommand command = UpdateCompanyCommand.create(
                request.getId(),
                request.getSysName(),
                request.getLogoPath(),
                request.getDescription(),
                request.getLongitude(),
                request.getLatitude(),
                request);
        return command;
    }

    @Override
    public CompanyResponse translate(OrganizationEntity organizationEntity, CompanyResponse.ContactRequest admin) {
        CompanyEntity company = organizationEntity.getCompany();
        if(company == null) {
            company = new CompanyEntity();
        }

        List<String> serviceList = StringUtils.isNotBlank(company.getServiceScopeDescription()) ? Arrays.asList(company.getServiceScopeDescription().split(";")) : new ArrayList<>();
        String industryCodeOutOfName = OrganizationTypeUtils.industryCodeOutOfName(organizationEntity.getIndustryCode());
        String institutionalCodeOutOfName = OrganizationTypeUtils.institutionalCodeOutOfName(organizationEntity.getInstitutionalCode());
        CompanyResponse response = new CompanyResponse(
                organizationEntity.getId(),
                organizationEntity.getLogoPath(),
                organizationEntity.getIndustryCode(), organizationEntity.getInstitutionalCode(),
                industryCodeOutOfName,institutionalCodeOutOfName,
                organizationEntity.getIndustryDetailType(), organizationEntity.getName(),
                organizationEntity.getType(), organizationEntity.getTelephone(), company.getEconomicType(),
                company.getNature(), translate2LocationResponse(organizationEntity.getPlaceOfRegister()),
                translate2LocationResponse(organizationEntity.getPlaceOfBusiness()), company.getParentName(), company.getParentCertificateType(),
                company.getParentCertificateNumber(), company.getParentLegalPersonName(), company.getParentLegalPersonTelephone(),
                company.getLegalPersonName(), company.getLegalPersonTelephone(), company.getLegalPersonCredentialType(),
                company.getLegalPersonCredentialNumber(), company.getLegalPersonNationality(), company.getSecurityPersonName(),
                company.getSecurityPersonTelephone(), company.getSecurityPersonCredentialType(), company.getSecurityPersonCredentialNumber(),
                company.getRegisteredCapital(), company.getFixedCapital(), company.getAnnualSalesVolume(), company.getAnnualProfitTax(),
                company.getCertificateType(), company.getUnifySocialCreditCode(), company.getUnifySocialCreditCodeFile(),
                company.getServicePermitNumber(), company.getNameOfIssuingAuthority(), company.getFirstIssueServicePermit(),
                company.getServicePermitAttachment(), company.getSecurityApprovalNumber(), serviceList,
                company.getSecurityPreparednessRating(), company.getSecurityArmedRating(), company.getSecuritySafetyDefenseRating(),
                company.getIsRiskAssessment(), company.getTrainContent(), company.getNumberOfSecurityGuards(), company.getIsPublicSecuritySecurity(),
                company.getIsPropertyEnterprise(), company.getNatureOfSelfRecruitedUnits(), organizationEntity.getSuperviseRegionCode(),
                organizationEntity.getSuperviseDepartId(), organizationEntity.getSuperviseDepartName(),
                organizationEntity.getShareOrganizationName(), organizationEntity.getShareEmployeeName(), admin,
                organizationEntity.getLongitude(),organizationEntity.getLatitude(),organizationEntity.getLonLatJson(),
                this.jsonProvider,envConfig.getAllowedmonthGisChanges()
        );
        response.setDynamicFields(organizationEntity.getDynamicFields());
        return response;
    }

    private static LocationCommandItem translateLocationItem(LocationRequest locationRequest) {
        return LocationCommandItem.create(
                translateItemValueItem(locationRequest.getProvince()),
                translateItemValueItem(locationRequest.getCity()),
                translateItemValueItem(locationRequest.getDistrict()),
                locationRequest.getAddress()
        );
    }

    private static ItemValueCommandItem translateItemValueItem(LocationRequest.ItemValueRequest itemValueRequest) {
        return ItemValueCommandItem.create(itemValueRequest.getCode(), itemValueRequest.getName());
    }


    private static RegisterCompanyCommand.ContactCommandItem translate2ContactCommandItem(
            CompanyRegistrationRequest.ContactRequest request) {
        return RegisterCompanyCommand.ContactCommandItem.create(
                request.getName(), request.getTelephone(),
                translate2CredentialType(request.getCredentialType()),
                request.getCredentialNumber());
    }

    private static com.bcxin.Infrastructures.enums.CredentialType translate2CredentialType(CredentialType credentialType) {
        if (credentialType == null) {
            throw new ArgumentTenantException("证件类型不能为空");
        }

        switch (credentialType) {
            case IdCard:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCard;
            case IdCardOfAoMen:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCardOfAoMen;
            case Arms:
                return com.bcxin.Infrastructures.enums.CredentialType.Arms;
            case Passport:
                return com.bcxin.Infrastructures.enums.CredentialType.Passport;
            case IdCardOfTaiwan:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCardOfTaiwan;
            case IdCardOfXiangGang:
                return com.bcxin.Infrastructures.enums.CredentialType.IdCardOfXiangGang;
        }

        throw new NotSupportTenantException(String.format("不支持该证件类型(%s)!", credentialType));
    }

    private static LocationRequest translate2LocationResponse(LocationValueType location) {
        if (location == null) {
            return null;
        }
        return new LocationRequest(
                translate2ItemValueType(location.getProvince()),
                translate2ItemValueType(location.getCity()),
                translate2ItemValueType(location.getDistrict()),
                location.getAddress());
    }

    private static LocationRequest.ItemValueRequest translate2ItemValueType(ItemValueType itemValueType) {
        if(itemValueType == null){
            return null;
        }
        return new LocationRequest.ItemValueRequest(itemValueType.getCode(), itemValueType.getName());
    }


    private static OrganizationApproveGetResponse.LocationResponse translate2ApproveLocationResponse(LocationValueType location) {
        if (location == null) {
            return null;
        }

        return new OrganizationApproveGetResponse.LocationResponse(
                translate2ApproveItemValueType(location.getProvince()),
                translate2ApproveItemValueType(location.getCity()),
                translate2ApproveItemValueType(location.getDistrict()),
                location.getAddress());
    }

    private static OrganizationApproveGetResponse.ItemValueResponse translate2ApproveItemValueType(ItemValueType itemValueType) {
        return new OrganizationApproveGetResponse.ItemValueResponse(itemValueType.getCode(), itemValueType.getName());
    }
}
