package com.bcxin.tenant.apis.impls;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.PlatformOperateLogRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.operatelog.PlatformOperateLogRequest;
import com.bcxin.tenant.domain.entities.PlatformOperateLogEntity;
import com.bcxin.tenant.domain.repository.impls.PlatformOperateLogJpaRepository;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.BeanUtils;

import java.util.Date;

/**
 * description：平台操作日志表
 * author：linchunpeng
 * date：2024/11/12
 */
@Slf4j
@DubboService(version = ApiConstant.VERSION, validation = "true", timeout = 120 * 1000, retries = 0)
public class PlatformOperateLogRpcProviderImpl implements PlatformOperateLogRpcProvider {

    private final UnitWork unitWork;

    private final PlatformOperateLogJpaRepository platformOperateLogJpaRepository;

    public PlatformOperateLogRpcProviderImpl(UnitWork unitWork, PlatformOperateLogJpaRepository platformOperateLogJpaRepository) {
        this.unitWork = unitWork;
        this.platformOperateLogJpaRepository = platformOperateLogJpaRepository;
    }

    /**
     * description：记录平台操作日志
     * author：linchunpeng
     * date：2024/11/12
     */
    @Override
    public void logOperate(PlatformOperateLogRequest request) {
        try {
            log.info("记录平台操作日志，参数：{}", JSONObject.toJSONString(request));
            this.unitWork.executeTran(() -> {
                PlatformOperateLogEntity platformOperateLogEntity = new PlatformOperateLogEntity();
                BeanUtils.copyProperties(request, platformOperateLogEntity);
                platformOperateLogEntity.setOperateTime(new Date());
                this.platformOperateLogJpaRepository.save(platformOperateLogEntity);
            });
        } catch (Exception e) {
            log.error("记录平台操作日志异常：{}", e.getMessage(), e);
        }
    }

}
