package com.bcxin.tenant.apis.impls;

import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.tenants.OrganizationTypeRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.organizationType.OrganizationTypeCreateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizationType.OrganizationTypeUpdateRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationTypeResponse;
import com.bcxin.tenant.domain.entities.OrganizationTypeEntity;
import com.bcxin.tenant.domain.repositories.OrganizationTypeRepository;
import com.bcxin.tenant.domain.services.OrganizationTypeService;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.Collection;

@DubboService(version = ApiConstant.VERSION,validation = "true",retries = 0,timeout = 120_000)
public class OrganizationTypeRpcProviderImpl implements OrganizationTypeRpcProvider {

    private final OrganizationTypeService organizationTypeService;
    private final OrganizationTypeRepository organizationTypeRepository;

    public OrganizationTypeRpcProviderImpl(OrganizationTypeService organizationTypeService, OrganizationTypeRepository organizationTypeRepository) {
        this.organizationTypeService = organizationTypeService;
        this.organizationTypeRepository = organizationTypeRepository;
    }


    @Override
    public void create(OrganizationTypeCreateRequest request) {
        organizationTypeService.save(request);
    }

    @Override
    public void delete(long id) {
        organizationTypeRepository.deleteById(id);
    }

    @Override
    public void update(OrganizationTypeUpdateRequest request) {
        OrganizationTypeEntity tenantOrganizationTypeEntity=organizationTypeRepository.findById(request.getId());
        tenantOrganizationTypeEntity.change(request.getName(),
                request.getNote(),
                request.getOrganizationId());
        organizationTypeRepository.save(tenantOrganizationTypeEntity);
    }

    @Override
    public OrganizationTypeResponse findById(long id) {
        OrganizationTypeEntity organizationTypeEntity = organizationTypeRepository.findById(id);
         if (organizationTypeEntity != null) {
            return OrganizationTypeResponse.create(organizationTypeEntity.getId(),organizationTypeEntity.getName(),organizationTypeEntity.getNote(),organizationTypeEntity.getOrganizationId(),organizationTypeEntity.getCreatedTime(),organizationTypeEntity.getCreatorId(),organizationTypeEntity.getLastUpdatorId(),organizationTypeEntity.getLastUpdatedTime());
        }
        return null;
    }

    @Override
    public Collection<OrganizationTypeResponse> findByOrganizationId(String organizationId) {
        Collection<OrganizationTypeEntity> organizationTypeEntities = organizationTypeRepository.findByOrganizationId(organizationId);
        if (organizationTypeEntities != null) {
            return organizationTypeEntities.stream().map(organizationTypeEntity -> OrganizationTypeResponse.create(organizationTypeEntity.getId(),organizationTypeEntity.getName(),organizationTypeEntity.getNote(),organizationTypeEntity.getOrganizationId(),organizationTypeEntity.getCreatedTime(),organizationTypeEntity.getCreatorId(),organizationTypeEntity.getLastUpdatorId(),organizationTypeEntity.getLastUpdatedTime())).collect(java.util.stream.Collectors.toList());
        }
        return null;
    }
}
