package com.bcxin.tenant.apis.impls;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.nacos.api.utils.StringUtils;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.components.CacheProvider;
import com.bcxin.Infrastructures.enums.AbnormalPersonnelEmployeeType;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.utils.AuthUtil;
import com.bcxin.Infrastructures.utils.DateUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.CommonImportResponse;
import com.bcxin.api.interfaces.rbacs.RbacCategoryRpcProvider;
import com.bcxin.api.interfaces.rbacs.responses.CategoryDetailGetResponse;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeCriteria;
import com.bcxin.api.interfaces.tenants.criterias.EmployeeLeaveCriteria;
import com.bcxin.api.interfaces.tenants.requests.employees.*;
import com.bcxin.api.interfaces.tenants.requests.organizations.LocationRequest;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.IMContactCriteria;
import com.bcxin.api.interfaces.tenants.responses.*;
import com.bcxin.tenant.apis.translates.CommonTranslate;
import com.bcxin.tenant.domain.configs.EnvConfig;
import com.bcxin.tenant.domain.configs.PlatformUploadConfig;
import com.bcxin.tenant.domain.entities.DepartmentAdminEntity;
import com.bcxin.tenant.domain.entities.EmployeeExportViewEntity;
import com.bcxin.tenant.domain.entities.valueTypes.ItemValueType;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.readers.criterias.LeaveEmployeeCriteria;
import com.bcxin.tenant.domain.readers.dtos.*;
import com.bcxin.tenant.domain.repositories.DepartmentAdminRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.dtos.EmployeeExportDto;
import com.bcxin.tenant.domain.repositories.dtos.LeaveEmployeeExportDto;
import com.bcxin.tenant.domain.repositories.dtos.LeaveEmployeeExport_06_Dto;
import com.bcxin.tenant.domain.repositories.dtos.OrganizationAdminiInfoDto;
import com.bcxin.tenant.domain.services.EmployeeService;
import com.bcxin.tenant.domain.services.ImportDataService;
import com.bcxin.tenant.domain.services.commands.*;
import com.bcxin.tenant.domain.services.commands.results.ProcessImportDataCommandResult;
import com.bcxin.tenant.domain.services.impls.TenantUserExtensionService;
import com.bcxin.tenant.domain.utils.poi.ExcelUtils;
import com.bcxin.tenant.domain.v5.entities.TDepartmentUserEntity;
import com.bcxin.tenant.domain.v5.repositories.TDepartmentUserRepository;
import com.bcxin.tenant.domain.v5.services.TUserService;
import com.bcxin.tenant.domain.v5.services.commands.ClearUserRoleCommand;
import com.bcxin.tenant.domain.v5.services.commands.SyncUserRoleCommand;
import com.lowagie.text.*;
import com.lowagie.text.rtf.RtfWriter2;
import org.apache.dubbo.config.annotation.DubboService;
import org.apache.dubbo.config.annotation.Method;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.lang.reflect.Field;
import java.util.List;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@DubboService(version = ApiConstant.VERSION,validation = "true",
        retries = 0,timeout = 120_000, methods = {
        @Method(name = "create",retries = 0,timeout = 10_000),
        @Method(name = "batchMove",retries = 0,timeout = -1),
        @Method(name = "batchImport",retries = 0,timeout = -1)
})
public class EmployeeRpcProviderImpl implements EmployeeRpcProvider {
    private final EmployeeService employeeService;
    private final EmployeeRepository employeeRepository;
    private final TenantDbReader tenantDbReader;
    private final CommonTranslate commonTranslate;
    private final ImportDataService importDataService;
    private final TUserService tUserService;
    private final TDepartmentUserRepository tDepartmentUserRepository;
    private final DepartmentAdminRepository departmentAdminRepository;
    private final RbacCategoryRpcProvider rbacCategoryRpcProvider;
    private final TenantDbReader dbReader;
    private final CacheProvider cacheProvider;
    private final EnvConfig envConfig;
    private final TenantUserExtensionService tenantUserExtensionService;

    public EmployeeRpcProviderImpl(EmployeeService employeeService,
                                   EmployeeRepository employeeRepository,
                                   TenantDbReader tenantDbReader,
                                   CommonTranslate commonTranslate,
                                   ImportDataService importDataService,
                                   TUserService tUserService,
                                   TDepartmentUserRepository tDepartmentUserRepository,
                                   DepartmentAdminRepository departmentAdminRepository,
                                   RbacCategoryRpcProvider rbacCategoryRpcProvider,
                                   TenantDbReader dbReader, CacheProvider cacheProvider,
                                   EnvConfig envConfig,
                                   TenantUserExtensionService tenantUserExtensionService) {
        this.employeeService = employeeService;
        this.employeeRepository = employeeRepository;
        this.tenantDbReader = tenantDbReader;
        this.commonTranslate = commonTranslate;
        this.importDataService = importDataService;
        this.tUserService = tUserService;
        this.tDepartmentUserRepository = tDepartmentUserRepository;
        this.departmentAdminRepository = departmentAdminRepository;
        this.rbacCategoryRpcProvider = rbacCategoryRpcProvider;
        this.dbReader = dbReader;
        this.cacheProvider = cacheProvider;
        this.envConfig = envConfig;
        this.tenantUserExtensionService = tenantUserExtensionService;
    }

    @Override
    public String create(String organizationId, EmployeeRequest request) {
        CreateEmployeeRequestCommand createEmployeeRequestCommand =
                CreateEmployeeRequestCommand.create(organizationId,
                request.getName(), request.getTelephone(),
                null,
                request.getDepartId(), request.getOccupationType(), request.getPosition(),
                request.getHiredDate(), request.getCredential() == null?null:request.getCredential().getType(),
                request.getCredential()==null?null:request.getCredential().getNumber(),
                request.getOperator(),
                request.getAbnormalPersonnelConfirm() == null || !request.getAbnormalPersonnelConfirm() ? AbnormalPersonnelEmployeeType.NEED_VERIFY : AbnormalPersonnelEmployeeType.NEED_VERIFY_REMIND_CONFIRM
                );

        String employeeId =
                this.employeeService.dispatch(createEmployeeRequestCommand);

        return employeeId;
    }

    @Override
    public void update(String organizationId, String id, UpdateEmployeeRequest request) {
        this.employeeService.dispatch(
                UpdateEmployeeRequestCommand.create(
                        organizationId, id,
                        request.getDepartId(), request.getHiredDate(),
                        request.getSuperiorId(),
                        request.getPosition(), request.getPositiveDate(),
                        request.getDepartIds(),
                        request.getInterview(),
                        request.getPersonStatus(),
                        request.getProbation(),
                        request.getPlanPositiveDate(),
                        request.getSalary())
        );
    }

    @Override
    public Pageable<EmployeeGetResponse> find(String organizationId, EmployeeCriteria criteria) {
        com.bcxin.tenant.domain.readers.criterias.EmployeeCriteria employeeCriteria =
                translate2EmployeeCriteria(organizationId, criteria);
        Pageable<EmployeeDto> employeeDtoPageable = this.tenantDbReader.find(organizationId, employeeCriteria);

        Collection<EmployeeGetResponse> responses =
                employeeDtoPageable.getData().stream().map(ii -> {
                    LocationValueType placeOfNow = ii.getPlaceOfNow();
                    String placeOfNowName = "";
                    try {
                        if (placeOfNow != null) {
                            placeOfNowName = (placeOfNow.getProvince() != null && placeOfNow.getProvince().getName() != null) ? placeOfNow.getProvince().getName() : "";
                            placeOfNowName += (placeOfNow.getCity() != null && placeOfNow.getCity().getName() != null) ? placeOfNow.getCity().getName() : "";
                            placeOfNowName += (placeOfNow.getDistrict() != null && placeOfNow.getDistrict().getName() != null) ? placeOfNow.getDistrict().getName() : "";
                            placeOfNowName += placeOfNow.getAddress() != null ? placeOfNow.getAddress() : "";
                        }
                        String gradeLevel="";
                        if(ii.getGradeLevel()=="1"){
                            gradeLevel="高级保安师";
                        }
                        if(ii.getGradeLevel()=="2"){
                            gradeLevel="保安师";
                        }
                        if(ii.getGradeLevel()=="3"){
                            gradeLevel="高级保安员";
                        }
                        if(ii.getGradeLevel()=="4"){
                            gradeLevel="中级保安员";
                        }
                        if(ii.getGradeLevel()=="5"){
                            gradeLevel="初级保安员";
                        }
                        EmployeeGetResponse responseItem =
                                EmployeeGetResponse.create(
                                        ii.getOrganName(), ii.getId(), ii.getName(),
                                        ii.getTelephone(), ii.getDepartId(), ii.getDepartName(), ii.getDepartLeader(), ii.getCredentialType(), ii.getCredentialNumber(),
                                        ii.getCheckedStatus(), ii.getOccupationType(), ii.getAuthenticatedStatus(), ii.getHiredTime(),
                                        ii.isCerStatus(), ii.isContractStatus(), ii.isGradeCerStatus(),
                                        gradeLevel, ii.getGradeCerNo(),
                                        ii.getPosition(), ii.getAuthenticatedResult(), ii.getSex(), ii.getBirthdate(), ii.getNation(),
                                        ii.getEducation(), ii.getPoliticsStatus(), ii.getHouseholdType(), ii.getMilitaryStatus(), ii.getNativePlace(),
                                        ii.getMaritalStatus(), ii.getStature(), ii.getEmergencyContact(), ii.getEmergencyPhone(), ii.getLicenseLevel(),ii.getBackgroundScreeningStatus(),
                                        ii.getInsure(), ii.getCerNo(), ii.getSuperiorName(), ii.getContractValidDateTo(), ii.getPositiveDate(), ii.getValidDateFrom(),
                                        ii.getValidDateTo(), ii.getAddress(), ii.getCreatedTime(), ii.getDomainAdmin(), ii.getDepartAdmin(), ii.getManageDeparts(),
                                        ii.getPersonStatus() == null ? null : ii.getPersonStatus().getTypeName(),
                                        ii.getProbation(),
                                        ii.getPlanPositiveDate() == null ? null : DateUtil.format2ShortDate(ii.getPlanPositiveDate(), "yyyy-MM-dd"),
                                        placeOfNowName,
                                        ii.getHiredOperator(),
                                        ii.getLastCheckedStatusTime(),ii.getXlcpResult(),ii.getXlcpResultRuleTip(),ii.getXlcpFileUrl());

                        return responseItem;
                    } catch (Exception ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }).filter(ii -> ii != null).collect(Collectors.toList());

        return Pageable.create(criteria.getPageIndex(), criteria.getPageSize(), employeeDtoPageable.getTotalCount(), responses);
    }

    /**
     * <b> 根据部门id查询人员 </b>
     * @author ZXF
     * @create 2021/12/27 0027 10:39
     * @version
     * @注意事项 </b>
     */
    @Override
    public Collection<MyImContactGetResponse> getMyImContacts(IMContactCriteria request) {
        Collection<MyImContactDto> data = tenantDbReader.getMyImContacts(request);
        if(data == null || data.size() == 0){
            return new ArrayList<MyImContactGetResponse>();
        }
        //所有有权限部门添加对应挂钩的人员数据
        List<MyImContactGetResponse> list = data.stream().map(ix -> {
            return MyImContactGetResponse.create(ix.getId(), ix.getEmpId(),
                    ix.getName(), ix.getSex(), ix.getHeadPhoto(), ix.getTelephone(), ix.getImIdentity());
        }).collect(Collectors.toList());
        return list;
    }
    @Override
    public Collection<MyImContactGetResponse> getMyImContactSearch(IMContactCriteria request) {
        Collection<MyImContactDto> data = tenantDbReader.getMyImContactSearch(request);
        if(data == null || data.size() == 0){
            return new ArrayList<MyImContactGetResponse>();
        }
        //所有有权限部门添加对应挂钩的人员数据
        List<MyImContactGetResponse> list = data.stream().map(ix -> {
            return MyImContactGetResponse.create(ix.getId(), ix.getEmpId(),
                    ix.getName(), ix.getSex(), ix.getHeadPhoto(), ix.getTelephone(), ix.getImIdentity());
        }).collect(Collectors.toList());
        return list;
    }

    @Override
    public Pageable<ImContactResponse>  contactSearch(IMContactCriteria criteria) {
        Pageable<ImContactDto> data = tenantDbReader.contactSearch(criteria);
        List<ImContactResponse> list = data.getData().stream().map(ix -> {
            return ImContactResponse.create(ix.getId(),
                    ix.getName(),
                    ix.getHeadPhoto(),
                    ix.getTelephone(),
                    IdcardUtil.hide(ix.getIdNum(),4,14),
                    ix.getImIdentity(),
                    ix.getSex(),
                    ix.getOneInchColorWhitePhoto());
        }).collect(Collectors.toList());
        return Pageable.create(data.getPageIndex(),data.getPageSize(),data.getTotalCount(),list);
    }

    /**
     * <b> 根据当前用户查询有权限的部门，递归树 </b>
     * @author ZXF
     * @create 2021/12/27 0027 10:39
     * @version
     * @注意事项 </b>
     */
    @Override
    public Collection<MyImDepartGetResponse> getMyImDeparts(String organizationId, String tenantUserId) {
        int assign = tenantDbReader.isAssign(organizationId, tenantUserId);
        Collection<MyImDepartDto> data = tenantDbReader.getMyDeparts(organizationId, tenantUserId);
        if(data == null || data.size() == 0){
            return new ArrayList<MyImDepartGetResponse>();
        }
        //所有有权限部门添加对应挂钩的人员数据
        List<MyImDepartGetResponse> list = data.stream().map(ix -> {
            return MyImDepartGetResponse.create(ix.getId(), ix.getName(), ix.getParentId(), ix.getDisplayOrder(), assign, null);
        }).collect(Collectors.toList());

        if(assign == 0){
            return list;
        }else{
            Collection<MyImDepartGetResponse> nDeparts = new ArrayList<MyImDepartGetResponse>();
            Collection<MyImDepartGetResponse> departs = list;
            for (MyImDepartGetResponse ixt: departs) {
                String par = "";
                for (MyImDepartGetResponse ix: departs) {
                    if(ix.getId().equals(ixt.getParentId())){
                        par = ixt.getParentId();
                        break;
                    }
                }
                nDeparts.add(MyImDepartGetResponse.create(ixt.getId(), ixt.getName(), par, ixt.getDisplayOrder(), 1, null));
            }

            return getDepartChild("", nDeparts);
        }
    }

    private Collection<MyImDepartGetResponse> getDepartChild(String parentDepartId, Collection<MyImDepartGetResponse> departList) {
        Collection<MyImDepartGetResponse> deptVosList = new ArrayList<MyImDepartGetResponse>();
        if (departList != null && departList.size() > 0) {
            for (MyImDepartGetResponse depart : departList) {
                //顶级parentDepartId为空的情况
                if(StringUtils.isEmpty(parentDepartId)&&StringUtils.isEmpty(depart.getParentId())){
                    MyImDepartGetResponse orgTreeDto = new MyImDepartGetResponse(depart.getId()
                            ,depart.getName()
                            ,depart.getParentId()
                            ,depart.getDisplayOrder()
                            ,1,getDepartChild(depart.getId(), departList));
                    deptVosList.add(orgTreeDto);
                }else{
                    if (parentDepartId.equals(depart.getParentId())) {
                        MyImDepartGetResponse orgTreeDto = new MyImDepartGetResponse(depart.getId()
                                ,depart.getName()
                                ,depart.getParentId()
                                ,depart.getDisplayOrder()
                                ,1,getDepartChild(depart.getId(), departList));
                        deptVosList.add(orgTreeDto);
                    }
                }
            }
        }
//        return JSON.parseArray(JSON.toJSONString(deptVosList, SerializerFeature.DisableCircularReferenceDetect),MyDepartImContactGetResponse.class);
        return deptVosList;
    }

    @Override
    public void batchMove(String organizationId, BatchMoveEmployeesRequest request) {
        BatchMoveEmployeesCommand command = BatchMoveEmployeesCommand.create(organizationId, request.getEmployeeIds(), request.getDestDepartId());

        this.employeeService.dispatch(command);
    }

    @Override
    public CommonImportResponse batchImport(String organizationId, String institutionalCode, String path, Collection<BatchImportEmployeeRequest> requests) {
        AtomicInteger paramIndex = new AtomicInteger();
        Collection<BatchImportEmployeeCommand.EmployeeCommandItem> employeeCommandItems =
                requests.parallelStream().map(ii -> {
                    paramIndex.getAndIncrement();
                    return BatchImportEmployeeCommand.EmployeeCommandItem.create(
                            institutionalCode,
                            paramIndex.get(),
                            ii.getName(),
                            ii.getTelephone(),
                            ii.getDepartName(),
                            ii.getOccupationType(),
                            ii.getPosition(),
                            ii.getHiredDate(),
                            ii.getCredentialType(),
                            StrUtil.isEmpty(ii.getCredentialNumber()) ? null: ii.getCredentialNumber().toUpperCase(),
                            ii.getNation(),
                            ii.getEducation(),
                            ii.getPoliticsStatus(),
                            ii.getMilitaryStatus(),
                            ii.getMaritalStatus(),
                            ii.getEmergencyContact(),
                            ii.getEmergencyPhone(),
                            ii.getAddress(),
                            ii.getHouseholdType()
                    );
                }).collect(Collectors.toList());

        BatchImportEmployeeCommand command = BatchImportEmployeeCommand.create(organizationId, institutionalCode, path, employeeCommandItems);

        String importedDataId = this.employeeService.dispatch(command);
        ProcessImportDataCommandResult result = this.importDataService.waitForProcessing(importedDataId,AuthUtil.getCurrentOperator(), getDeptAdminTopTreeCodes(organizationId));
        String message = "完成导入处理";
        if (result.getTotalSuccess() + result.getTotalFailed() < result.getTotalCount()) {
            message = "部分数据未处理完成, 请5分钟后刷新进行查询";
            // System.err.println(String.format("导入的员工总数（%s）跟预期（成功=%s;失败=%s）的不一致", totalCount, result.getTotalSuccess(), result.getTotalFailed()));
        }

        return CommonImportResponse.create(
                result.getId(),
                result.getTotalCount(),
                result.getTotalSuccess(),
                result.getTotalFailed(),
                message);
    }

    @Override
    public void batchLeave(String organizationId, BatchLeaveEmployeeRequest request) {
        this.employeeService.dispatch(BatchLeaveEmployeeCommand.create(request.getIds(),
                organizationId, request.getExpectedDate(), request.getNote()));
    }

    @Override
    public CommonImportResponse batchLeaveExcel(String organizationId, String path, Collection<BatchLeaveEmployeeExcelRequest> requests) {
        AtomicInteger paramIndex = new AtomicInteger();
        Collection<BatchLeaveEmployeeExcelCommand.EmployeeCommandItem> employeeCommandItems =
                requests.parallelStream().map(ii -> {
                    paramIndex.getAndIncrement();
                    return BatchLeaveEmployeeExcelCommand.EmployeeCommandItem.create(
                            paramIndex.get(),
                            ii.getUsername(),
                            ii.getIdNum(),
                            ii.getLeaveDateText(),
                            ii.getRemark()
                    );
                }).collect(Collectors.toList());
        BatchLeaveEmployeeExcelCommand command = BatchLeaveEmployeeExcelCommand.create(organizationId, path, employeeCommandItems, getDeptAdminTopTreeCodes(organizationId));
        CommonImportResponse commonImportResponse = employeeService.dispatch(command);
        return commonImportResponse;
    }


    @Override
    public void batchAssignSuperiors(String organizationId, BatchAssignEmployeeSuperiorRequest request) {
        Collection<BatchAssignEmployeeSuperiorCommand.AssignEmployeeSuperiorItem>
                employeeSuperiorItems = request.getItems().stream().map(ix ->
                        BatchAssignEmployeeSuperiorCommand.AssignEmployeeSuperiorItem.create(ix.getOriginalSuperiorId(), ix.getNewSuperiorId()))
                .collect(Collectors.toList());

        this.employeeService.dispatch(BatchAssignEmployeeSuperiorCommand.create(organizationId, employeeSuperiorItems));
    }

    @Override
    public void back(String organizationId, BackEmployeeRequest request) {
        this.employeeService.dispatch(
                BackEmployeeCommand.create(request.getId(), organizationId,
                        request.getDepartId(), request.getOccupationType(), request.getHiredDate(),
                        AuthUtil.getCurrentOperator())
        );
    }

    @Override
    public Pageable<EmployeeLeaveGetResponse> findLeaves(String organizationId, EmployeeLeaveCriteria criteria) {
        Set<String> treeCodes = getDeptAdminTopTreeCodes(organizationId);

        Pageable<EmployeeLeaveDto> employeeLeaveDtoPageable =
                this.tenantDbReader.findLeaveEmployees(organizationId,
                        LeaveEmployeeCriteria.create(criteria.getPageIndex(), criteria.getPageSize(),
                                criteria.getKeyword(),criteria.getStartDate(),criteria.getEndDate(),
                                criteria.getInsure(),
                                criteria.getDepartIds(), treeCodes));

        return Pageable.create(
                employeeLeaveDtoPageable.getPageIndex(), employeeLeaveDtoPageable.getPageSize(),
                employeeLeaveDtoPageable.getTotalCount(),
                employeeLeaveDtoPageable.getData()
                        .stream().map(ix -> EmployeeLeaveGetResponse.create(ix.getId(), ix.getName(), ix.getTelephone(),
                                ix.getDepartName(), ix.getCredentialType(), ix.getCredentialNumber(),
                        ix.getHiredDate(),ix.getLeaveTime(), ix.getLeaveNote(),
                                ix.getOperatorName(), ix.getCreatedTime(),
                        ix.getInsure() != null ?ix.getInsure().getTypeName() : TrueFalseStatus.False.getTypeName()
                )).collect(Collectors.toList())
        );
    }

    /**
     * description: 获取部门管理员管理的所有部门顶级treeCode
     * author: linchunpeng
     * date:  2023-05-16 14:33
     */
    private Set<String> getDeptAdminTopTreeCodes(String organizationId) {
        Set<String> treeCodes = null;
        TenantUserContext userContext = TenantContext.getInstance().getUserContext();
        if (userContext.get().isDepartAdmin()) {
            //部门管理员，需要汇集根节点，提高查询速度
            Collection<DepartmentAdminEntity> departmentAdmins = departmentAdminRepository.getByEmployeeIds(organizationId, Collections.singletonList(userContext.get().getEmployeeId()));
            if (!CollectionUtils.isEmpty(departmentAdmins)) {
                treeCodes = new HashSet<>();
                Map<String, String> treeCodeMap = new HashMap<>();
                String split = "-";
                for (DepartmentAdminEntity departmentAdmin : departmentAdmins) {
                    if (org.springframework.util.StringUtils.hasLength(departmentAdmin.getDepartmentIndexTree())) {
                        treeCodeMap.put(departmentAdmin.getDepartmentIndexTree(), departmentAdmin.getDepartmentIndexTree());
                    }
                }

                for (DepartmentAdminEntity departmentAdmin : departmentAdmins) {
                    if(org.springframework.util.StringUtils.hasLength(departmentAdmin.getDepartmentIndexTree())) {
                        String[] codes = departmentAdmin.getDepartmentIndexTree().split(split);
                        StringBuffer parentCode = new StringBuffer();
                        for (int i = 0; i < codes.length; i++) {
                            if (i > 0) {
                                parentCode.append(split);
                            }
                            parentCode.append(codes[i]);

                            if (treeCodeMap.get(parentCode.toString()) != null) {
                                //有父节点
                                treeCodes.add(parentCode.toString());
                                break;
                            }
                        }
                    }
                }
            }
        }
        return treeCodes;
    }

    @Override
    public void batchPermissions(String organizationId, BatchPermissionRequest request) {
        this.tUserService.dispatch(SyncUserRoleCommand.create(request.isFromAdmin(), organizationId, request.getEmployeeIds(), request.getRoleIds()));
    }

    @Override
    public AppRolePermissionResponse getPermissions(String organizationId, String id) {
        Collection<AppRolePermissionResponse> appRolePermissionResponses = getBatchPermissions(organizationId, Collections.singleton(id));
        if (appRolePermissionResponses.size() == 0) {
            return null;
        }

        return appRolePermissionResponses.stream().findFirst().get();
    }

    @Override
    public void clearPermissions(String organizationId, String id) {
        this.tUserService.dispatch(ClearUserRoleCommand.create(organizationId, id));
    }

    @Override
    public EmployeeDetailGetResponse getByOrganIdAndId(String organizationId, String id) {
        EmployeeDetailDto employeeDetailDto = this.dbReader.getByEmployeeId(organizationId, id);
        if (employeeDetailDto == null) {
            throw new NotFoundTenantException("找不到职员信息");
        }

        UserDetailGetResponse userInfo = UserDetailGetResponse.create(
                employeeDetailDto.getId(),
                employeeDetailDto.getName(),
                employeeDetailDto.getEmail(),
                employeeDetailDto.getNicky(),
                employeeDetailDto.getTelephone(),
                employeeDetailDto.getLonLatJson(),
                employeeDetailDto.getBirthdate(),
                employeeDetailDto.getCheckedStatus(),
                employeeDetailDto.getAuthenticateStatus(),
                employeeDetailDto.getAuthenticatedResult(),
                employeeDetailDto.getStature(),
                employeeDetailDto.getHeadPhoto(),
                employeeDetailDto.getSex(),
                employeeDetailDto.getNation(),
                employeeDetailDto.getWorkYear(),
                employeeDetailDto.getDiseasesHistory(),
                employeeDetailDto.getPoliticsStatus(),
                employeeDetailDto.getMilitaryStatus(),
                employeeDetailDto.getEducation(),
                employeeDetailDto.getHouseholdType(),
                employeeDetailDto.getNativePlace(),
                employeeDetailDto.getMaritalStatus(),
                employeeDetailDto.getOneInchColorWhitePhoto(),
                employeeDetailDto.getTwoInchColorBluePhoto(),
                employeeDetailDto.getCid(),
                employeeDetailDto.getEmergencyContact(),
                employeeDetailDto.getEmergencyPhone(),
                employeeDetailDto.getLicenseLevel(),
                employeeDetailDto.getThirdPartyLoginNo(),
                employeeDetailDto.getImIdentity(),
                employeeDetailDto.getPlaceOfNow() != null ?translateLocationItem(employeeDetailDto.getPlaceOfNow()):null,
                UserDetailGetResponse.CredentialInfo.create(
                        employeeDetailDto.getCredentialName(),
                        employeeDetailDto.getCredentialHeadPhoto(),
                        employeeDetailDto.getCredentialType(),
                        employeeDetailDto.getCredentialNumber(),
                        employeeDetailDto.getCredentialValidDateFrom(),
                        employeeDetailDto.getCredentialValidDateTo(),
                        employeeDetailDto.getCredentialFrontPhoto(),
                        employeeDetailDto.getCredentialReversePhoto(),
                        employeeDetailDto.getCredentialAddress()
                ),
                tenantUserExtensionService.getExtensionListByTenantUserId(employeeDetailDto.getId())
        );

        List<DepartResponse> departResponses = new ArrayList<>();
        for (DepartDto depart : employeeDetailDto.getDeparts()) {
            departResponses.add(DepartResponse.create(depart.getDepartId(),depart.getDepartName()));
        }

        return EmployeeDetailGetResponse.create(
                employeeDetailDto.getId(),
                employeeDetailDto.getEmployeeDepartId(),
                employeeDetailDto.getEmployeeDepartName(),
                employeeDetailDto.getEmployeeSuperiorId(),
                employeeDetailDto.getEmployeeSuperiorName(),
                employeeDetailDto.getEmployeeHiredDate(),
                employeeDetailDto.getEmployeePositiveDate(), employeeDetailDto.getEmployeePosition(),
                employeeDetailDto.getEmployeeOccupationType(),
                employeeDetailDto.getInsure(),
                userInfo,departResponses,
                employeeDetailDto.getInterview(),
                employeeDetailDto.getPersonStatus(),
                employeeDetailDto.getProbation(),
                employeeDetailDto.getPlanPositiveDate(),
                employeeDetailDto.getSalary()
        );
    }

    private LocationRequest translateLocationItem(LocationValueType placeOfNow) {
        return LocationRequest.create(
                translateItemValueItem(placeOfNow.getProvince() == null ? null:placeOfNow.getProvince()),
                translateItemValueItem(placeOfNow.getCity() == null ? null:placeOfNow.getCity()),
                translateItemValueItem(placeOfNow.getDistrict() == null ? null:placeOfNow.getDistrict()),
                placeOfNow.getAddress()
        );
    }

    private LocationRequest.ItemValueRequest translateItemValueItem(ItemValueType itemValueRequest) {
        return LocationRequest.ItemValueRequest.create(itemValueRequest == null ? null : itemValueRequest.getCode(), itemValueRequest == null ? null : itemValueRequest.getName());
    }

    @Override
    public InviteUserGetResponse getByOrganIdAndPhone(String organizationId, String phone) {
        InviteUserDto inviteUserDto = this.dbReader.getByOranIdAndPhone(organizationId, phone);
        if (inviteUserDto == null) {
            inviteUserDto = this.dbReader.getByPhone(phone);
        }
        if (inviteUserDto == null) {
            return null;
        }

        return InviteUserGetResponse.create(
                inviteUserDto.getId(),
                inviteUserDto.getName(),
                inviteUserDto.getHiredDate(),
                inviteUserDto.getOccupationType(),
                inviteUserDto.getCredentialType(),
                inviteUserDto.getCredentialNumber()
                );

    }

    @Override
    public InviteUserGetResponse getByOrganIdAndIdNum(String organizationId, String idNum) {
        InviteUserDto inviteUserDto = this.dbReader.getByOranIdAndIdNum(organizationId, idNum);
        if (inviteUserDto == null) {
            inviteUserDto = this.dbReader.getByIdNum(idNum);
        }
        if (inviteUserDto == null) {
            return null;
        }

        return InviteUserGetResponse.create(
                inviteUserDto.getId(),
                inviteUserDto.getName(),
                inviteUserDto.getHiredDate(),
                inviteUserDto.getOccupationType(),
                inviteUserDto.getCredentialType(),
                inviteUserDto.getCredentialNumber()
                );

    }

    @Override
    public String createExcel(String organizationId, EmployeeCriteria criteria) {
        com.bcxin.tenant.domain.readers.criterias.EmployeeCriteria employeeCriteria = translate2EmployeeCriteria(organizationId, criteria);
        List<EmployeeExportViewEntity> list = dbReader.searchEmployeeList(organizationId,employeeCriteria);
        if(list == null || list.size()<1){
            throw new NotFoundTenantException("无可导出数据");
        }
        int index = 1;
        List<EmployeeExportDto> dtoList = new ArrayList<>();
        for (EmployeeExportViewEntity employeeExportViewEntity : list) {
            String gradeLevel=" ";
            if(employeeExportViewEntity.getGradeLevel()=="1"){
                gradeLevel="高级保安师";
            }
            if(employeeExportViewEntity.getGradeLevel()=="2"){
                gradeLevel="保安师";
            }
            if(employeeExportViewEntity.getGradeLevel()=="3"){
                gradeLevel="高级保安员";
            }
            if(employeeExportViewEntity.getGradeLevel()=="4"){
                gradeLevel="中级保安员";
            }
            if(employeeExportViewEntity.getGradeLevel()=="5"){
                gradeLevel="初级保安员";
            }
            dtoList.add(new EmployeeExportDto(
                    index++,
                    employeeExportViewEntity.getName(),
                    employeeExportViewEntity.getTelephone(),
                    employeeExportViewEntity.getCredentialType(),
                    employeeExportViewEntity.getNumber(),
                    employeeExportViewEntity.getCheckedStatus(),
                    employeeExportViewEntity.getLastCheckedStatusTime()!= null? DateUtil.format2ShortDate(employeeExportViewEntity.getLastCheckedStatusTime()) :null,
                    employeeExportViewEntity.getAuthenticateStatus(),
                    employeeExportViewEntity.getAuthenticatedResult(),
                    employeeExportViewEntity.getDepartName(),
                    employeeExportViewEntity.getOccupationType(),
                    employeeExportViewEntity.getSuperiorName(),
                    employeeExportViewEntity.getPosition(),
                    employeeExportViewEntity.getHiredDate() != null? DateUtil.format2ShortDate(employeeExportViewEntity.getHiredDate()) :null,
                    employeeExportViewEntity.getPositiveDate() != null?DateUtil.format2ShortDate(employeeExportViewEntity.getPositiveDate()) :null,
                    employeeExportViewEntity.getSex(),
                    employeeExportViewEntity.getBirthdate() != null?DateUtil.format2ShortDate(employeeExportViewEntity.getBirthdate(),"yyyy-MM-dd") :null,
                    employeeExportViewEntity.getNation(),
                    employeeExportViewEntity.getEducation(),
                    employeeExportViewEntity.getPoliticsStatus(),
                    employeeExportViewEntity.getHouseholdType(),
                    employeeExportViewEntity.getStature(),
                    employeeExportViewEntity.getNativePlace(),
                    employeeExportViewEntity.getMilitaryStatus(),
                    employeeExportViewEntity.getMaritalStatus(),
                    employeeExportViewEntity.getValidDateFrom(),
                    employeeExportViewEntity.getValidDateTo(),
                    employeeExportViewEntity.getAddress(),
                    employeeExportViewEntity.getContractStatus(),
                    employeeExportViewEntity.getCerStatus(),
                    employeeExportViewEntity.getGradeCerStatus(),
                    employeeExportViewEntity.getCerNo(),
                    gradeLevel,
                    employeeExportViewEntity.getGradeCerNo(),
                    employeeExportViewEntity.getInsure(),
                    employeeExportViewEntity.getCreatedTime() != null?DateUtil.format2ShortDate(employeeExportViewEntity.getCreatedTime(),"yyyy-MM-dd HH:mm:ss") :null,
                    employeeExportViewEntity.getDomainAdmin(),
                    employeeExportViewEntity.getDepartAdmin(),
                    employeeExportViewEntity.getManageDeparts(),
                    employeeExportViewEntity.getPersonStatus(),
                    employeeExportViewEntity.getProbation(),
                    employeeExportViewEntity.getPlanPositiveDate() != null?DateUtil.format2ShortDate(employeeExportViewEntity.getPlanPositiveDate(),"yyyy-MM-dd") :null,
                    employeeExportViewEntity.getEmergencyContact(),
                    employeeExportViewEntity.getEmergencyPhone(),
                    employeeExportViewEntity.getLicenseLevel(),
                    employeeExportViewEntity.getPlaceOfNow(),
                    employeeExportViewEntity.getHiredOperator()
            ));
        }
        List<String> titleList = new ArrayList<>();
        criteria.getColumns().add(0,"index");
        List<ColumnResponse> columnResponses = getExportColumnsContainIgnore();
        Map<String, String> columnMap = columnResponses.stream().collect(Collectors.toMap(ColumnResponse::getKey, ColumnResponse::getName));
        for (String column : criteria.getColumns()) {
            titleList.add(columnMap.get(column));
        }
        List<List<Object>> dataList = new ArrayList<>();
        for (EmployeeExportDto entity : dtoList) {
            List<Object> objList = new ArrayList<>();
            for (String column : criteria.getColumns()) {
                Object obj = ReflectUtil.getFieldValue(entity,column);
                objList.add(obj);
            }
            dataList.add(objList);
        }

        String fileName = "员工数据"+ Math.random();
        String filePath = PlatformUploadConfig.getDownloadPath();
        return ExcelUtils.customDynamicExport(filePath,fileName,titleList,null,dataList);
    }

    @Override
    public List<ColumnResponse> getExportColumns() {
        List<ColumnResponse> columnResponses = new ArrayList<>();
        Field[] fields = EmployeeExportDto.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(ExcelIgnore.class)) {
                continue;
            }
            if (field.isAnnotationPresent(ExcelProperty.class)) {
                ExcelProperty resource = field.getAnnotation(ExcelProperty.class);
                columnResponses.add(ColumnResponse.create(field.getName(), resource.value()[0]));
            }
        }
        return columnResponses;
    }

    private List<ColumnResponse> getExportColumnsContainIgnore() {
        List<ColumnResponse> columnResponses = new ArrayList<>();
        Field[] fields = EmployeeExportDto.class.getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(ExcelProperty.class)) {
                ExcelProperty resource = field.getAnnotation(ExcelProperty.class);
                columnResponses.add(ColumnResponse.create(field.getName(), resource.value()[0]));
            }
        }
        return columnResponses;
    }

    @Override
    public String createLeaveExcel(String organizationId, EmployeeLeaveCriteria criteria, String industryCode) {
        Set<String> treeCodes = getDeptAdminTopTreeCodes(organizationId);
        criteria.setTreeCodes(treeCodes);
        String path = PlatformUploadConfig.getDownloadPath()+"离职数据"+ Math.random()+".xlsx";
        File file = new File(path);
        if(!file.getParentFile().exists()){
            file.mkdirs();
        }

        List<LeaveEmployeeExportDto> list = this.tenantDbReader.findLeaveEmployeeList(organizationId,criteria);

        if ("02,04,06,07".contains(industryCode)) {
            //大活行业、群防群治行业、内保行业、行业主管部门
            List<LeaveEmployeeExport_06_Dto> list_06 = new ArrayList<>();
            if (CollectionUtil.isNotEmpty(list)) {
                for (LeaveEmployeeExportDto leaveEmployeeExportDto : list) {
                    LeaveEmployeeExport_06_Dto dto = new LeaveEmployeeExport_06_Dto();
                    BeanUtils.copyProperties(leaveEmployeeExportDto, dto);
                    list_06.add(dto);
                }
            }
            EasyExcel.write(path,LeaveEmployeeExportDto.class).sheet().doWrite(list_06);
        } else {
            EasyExcel.write(path,LeaveEmployeeExportDto.class).sheet().doWrite(list);
        }
        return path;
    }

    @Override
    public String createLeaveWord(String organizationId, String id) {
        EmployeeDetailDto employeeDetailDto = this.dbReader.getByEmployeeId(organizationId, id);
        if (employeeDetailDto == null) {
            throw new NotFoundTenantException("找不到职员信息");
        }

        String content = "兹证明${name}(${idType}:${idNum})自${hiredDate}入职我公司${departName}${position}，至${leaveDate}因${leaveNote}，经公司准予离职，已办理交接手续。";
        content = content.replace("${name}",employeeDetailDto.getName())
                .replace("${idType}",employeeDetailDto.getCredentialType() == null ? "":employeeDetailDto.getCredentialType().getTypeName())
                .replace("${idNum}",employeeDetailDto.getCredentialNumber() == null ? "":employeeDetailDto.getCredentialNumber())
                .replace("${hiredDate}",employeeDetailDto.getEmployeeHiredDate() == null ? "":DateUtil.format2ShortDate(employeeDetailDto.getEmployeeHiredDate(),"yyyy年MM月dd日"))
                .replace("${departName}",(employeeDetailDto.getDeparts() == null || employeeDetailDto.getDeparts().size() == 0) ? "":employeeDetailDto.getDeparts().stream().map(DepartDto::getDepartName).collect(Collectors.joining(", ")))
                .replace("${position}",employeeDetailDto.getEmployeePosition() == null ? "":employeeDetailDto.getEmployeePosition())
                .replace("${leaveDate}",employeeDetailDto.getEmployeeLeaveDate() == null ? "":DateUtil.format2ShortDate(employeeDetailDto.getEmployeeLeaveDate(),"yyyy年MM月dd日"))
                .replace("${leaveNote}",employeeDetailDto.getEmployeeLeaveNote() == null ? "":employeeDetailDto.getEmployeeLeaveNote());

        String filePath = PlatformUploadConfig.getDownloadPath()+"离职证明"+ Math.random()+".doc";
        File file = new File(filePath);
        if(!file.getParentFile().exists()) {
            file.mkdirs();
        }

        Rectangle r = new Rectangle(PageSize.A4.getWidth(),PageSize.A4.getHeight());
        Document document = new Document(r,20,20,20,20);
        //3.把文件写的路径
        try {
            RtfWriter2.getInstance(document,new FileOutputStream(filePath));
            //打开word进行填充数据
            document.open();
            //创建段落,段落不会不超过当前行的长度不会换行
            Paragraph paragraph = new Paragraph("离职证明");
            Font titleFont = new Font();
            titleFont.setSize(20);
            titleFont.setFamily("Courier");
            titleFont.setStyle(1);
            paragraph.setFont(titleFont);
            paragraph.setAlignment("center");
            paragraph.setSpacingBefore(40);
            paragraph.setSpacingAfter(40);
            document.add(paragraph);

            Paragraph paragraph1 = new Paragraph(content);
            Font titleFont1 = new Font();
            titleFont1.setSize(15);
            titleFont1.setFamily("Courier");
            titleFont1.setStyle(0);
            paragraph1.setFont(titleFont1);
            paragraph1.setAlignment("left");
            paragraph1.setSpacingBefore(20);
            paragraph1.setSpacingAfter(20);
            paragraph1.setIndentationLeft(30);
            document.add(paragraph1);

            Paragraph paragraph2 = new Paragraph("特此证明");
            Font titleFont2 = new Font();
            titleFont2.setSize(15);
            titleFont2.setFamily("Courier");
            titleFont2.setStyle(0);
            paragraph2.setFont(titleFont2);
            paragraph2.setAlignment("left");
            paragraph2.setSpacingBefore(20);
            paragraph2.setSpacingAfter(20);
            paragraph2.setIndentationLeft(30);
            document.add(paragraph2);

            Paragraph paragraph3 = new Paragraph("（公司盖章）");
            Font titleFont3 = new Font();
            titleFont3.setSize(15);
            titleFont3.setFamily("Courier");
            titleFont3.setStyle(0);
            paragraph3.setFont(titleFont3);
            paragraph3.setAlignment("right");
            paragraph3.setSpacingBefore(20);
            paragraph3.setSpacingAfter(40);
            paragraph3.setIndentationRight(40);
            document.add(paragraph3);

            Paragraph paragraph4 = new Paragraph("日期：" + (employeeDetailDto.getEmployeeLeaveDate() == null ? "":DateUtil.format2ShortDate(employeeDetailDto.getEmployeeLeaveDate(),"yyyy年MM月dd日")));
            Font titleFont4 = new Font();
            titleFont4.setSize(15);
            titleFont4.setFamily("Courier");
            titleFont4.setStyle(0);
            paragraph4.setFont(titleFont4);
            paragraph4.setAlignment("right");
            paragraph4.setSpacingBefore(20);
            paragraph4.setSpacingAfter(20);
            paragraph4.setIndentationRight(30);
            document.add(paragraph4);
        } catch (FileNotFoundException e) {
            throw new NotFoundTenantException("创建word路径错误");
        } catch (BadElementException e) {
            throw new NotFoundTenantException("创建表格错误");
        } catch (DocumentException e) {
            throw new NotFoundTenantException("word填充表格失败");
        }finally {
            //关闭
            if(document!=null) {
                document.close();
            }
        }

        return filePath;
    }

    @Override
    public EmployeeReportResponse findReport(String organizationId, EmployeeCriteria criteria) {

        com.bcxin.tenant.domain.readers.criterias.EmployeeCriteria employeeCriteria = translate2EmployeeCriteria(organizationId, criteria);
        EmployeeReportDto employeeReportDto = this.tenantDbReader.findReport(organizationId, employeeCriteria);

        return EmployeeReportResponse.create(employeeReportDto.getTotal(),
                employeeReportDto.getUnCheckedCount(),
                employeeReportDto.getCheckedCount(),
                employeeReportDto.getCommitCount(),
                employeeReportDto.getContractCount(),
                employeeReportDto.getSecTotal(),
                employeeReportDto.getSecUnCheckedCount(),
                employeeReportDto.getSecCheckedCount(),
                employeeReportDto.getSecUnAuthCount(),
                employeeReportDto.getSecAuthCount(),
                employeeReportDto.getSecAuthFailCount(),
                employeeReportDto.getSecContractCount());
    }

    @Override
    public EmployeeBasicResponse getEmployeeBasic(String organizationId, String id) {
        EmployeeBasicDto employee = tenantDbReader.getEmployeeBasic(organizationId, id);
        if (employee==null) {
           throw  new NotFoundTenantException("用户信息不存在");
        }
        return EmployeeBasicResponse.create(employee.getId(),employee.getIdNum(),employee.isHasChild(),employee.getStatus(),employee.getMasterSlaveType());
    }

    @Override
    public Collection<AppRolePermissionResponse> getBatchPermissions(String organizationId, Collection<String> ids) {
        Collection<String> appIds =this.dbReader.getMyOrganApps(organizationId);
        Collection<CategoryDetailGetResponse> appDetailResponse = this.rbacCategoryRpcProvider.getAllDetails();

        Collection<TDepartmentUserEntity> departmentUsers = this.tDepartmentUserRepository.getByIds(organizationId, ids);
        Collection<String> userIds = departmentUsers.stream().map(ii -> ii.getUserId()).distinct().collect(Collectors.toList());

        Collection<AppRolePermissionResponse> appRolePermissionResponses =
                userIds.stream().map(uid -> {
                    Collection<String> roleIds = departmentUsers.stream().filter(ix -> ix.getUserId().equals(uid))
                            .map(ii -> ii.getRoleId()).collect(Collectors.toList());

                    Collection<AppRolePermissionResponse.AppResponse> apps =
                            appDetailResponse.stream().filter(ii -> appIds.contains(ii.getId()))
                                    .map(ii -> {
                                        Collection<AppRolePermissionResponse.RoleResponse> roleResponses =
                                                ii.getResponses().stream().filter(ix -> roleIds.contains(ix.getId()))
                                                        .map(ix -> AppRolePermissionResponse.RoleResponse.create(ix.getId(), ix.getName()))
                                                        .collect(Collectors.toList());
                                        return AppRolePermissionResponse.AppResponse.create(ii.getId(), ii.getName(), roleResponses);
                                    }).filter(ii -> !CollectionUtils.isEmpty(ii.getRoles())).collect(Collectors.toList());

                    return AppRolePermissionResponse.create(uid, apps);
                }).collect(Collectors.toList());

        return appRolePermissionResponses;
    }

    @Override
    public Collection<OrganizationAdminResponse> getOrganizationAdministrators(String organizationId) {
        Collection<OrganizationAdminiInfoDto> adminInfoCollection = dbReader.getOrganizationAdminInfo(organizationId);
        return adminInfoCollection.stream()
                .map(ix->OrganizationAdminResponse.create(ix.getEmployeeId(),ix.getUserName(),ix.getTelephone(),null))
                .collect(Collectors.toList());
    }

    private com.bcxin.tenant.domain.readers.criterias.EmployeeCriteria translate2EmployeeCriteria(
            String organizationId,
            EmployeeCriteria criteria) {
        com.bcxin.tenant.domain.readers.criterias.EmployeeCriteria employeeCriteria = com.bcxin.tenant.domain.readers.criterias.EmployeeCriteria.create(
                criteria.getPageIndex(),
                criteria.getPageSize(),
                organizationId,
                criteria.getKeyword(),
                criteria.getHiredDate(),
                criteria.getOrganName(),
                criteria.getPosition(),
                criteria.getCredentialTypes(),
                criteria.getOccupationTypes(),
                criteria.getAuthenticatedStatuses(),
                criteria.getDepartIds(),
                getDeptAdminTopTreeCodes(organizationId),
                criteria.getCerStatus(),
                criteria.getContractStatus(),
                criteria.getGradeCerStatus(),
                criteria.getCheckedStatuses(),
                criteria.getBackgroundScreeningStatus(),
                criteria.getLevel(),
                criteria.getSex(),
                criteria.getBeginAge(),
                criteria.getEndAge(),
                criteria.getStartDate(),
                criteria.getEndDate(),
                criteria.getInsure()

        );

        employeeCriteria.markIgnorePermission(criteria.isIgnorePermission());

        return employeeCriteria;
    }
}
