package com.bcxin.tenant.apis.impls;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.Infrastructures.enums.*;
import com.bcxin.Infrastructures.utils.DictUtil;
import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.commons.ConfigDictRpcProvider;
import com.bcxin.tenant.domain.entities.ConfigDictEntity;
import com.bcxin.tenant.domain.repositories.ConfigDictRepository;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboService;

import java.util.*;

/**
 * <b> 字典 </b>
 * @author ZXF
 * @create 2021/12/21 0021 11:06
 * @version
 * @注意事项 </b>
 */
@DubboService(version = ApiConstant.VERSION,validation = "true",timeout = 120 *1000,retries = 0)
public class ConfigDictRpcProviderImpl implements ConfigDictRpcProvider {


    private final ConfigDictRepository configDictRepository;

    private final RedisUtil redisUtil;

    private final static String REGISTER_DICT_REDIS_KEY = "bcxin:tenant:platform:register:dict";

    public ConfigDictRpcProviderImpl(ConfigDictRepository configDictRepository, RedisUtil redisUtil){
        this.configDictRepository = configDictRepository;
        this.redisUtil = redisUtil;
    }

    @Override
    public JSONObject findAll() {
        Collection<ConfigDictEntity> dictList=  configDictRepository.findAll();
        JSONObject json = new JSONObject();
        if(dictList.size() > 0) {
            String codeType = "";
            JSONObject lJson;
            JSONArray jArr = null;
            for (ConfigDictEntity entity : dictList) {
                if(jArr == null){
                    jArr = new JSONArray();
                    codeType = entity.getCodeType();
                }
                if(!entity.getCodeType().equals(codeType)){
                    json.put(codeType,jArr);
                    jArr = new JSONArray();
                    codeType = entity.getCodeType();
                }
                lJson = new JSONObject();
                lJson.put("label",entity.getLabel());
                lJson.put("value",entity.getCodeValue());
                jArr.add(lJson);
            }
            //最后一个只能在完成循环后插入
            json.put(codeType,jArr);
        }

        return json;
    }


    /**
     * description: 根据行业类型，获取机构类型列表
     * author: linchunpeng
     * date:  2023-05-08 13:10
     */
    @Override
    public List<Map<String, String>> getOrgTypeList(String industryTypeValue) {
        if (StringUtils.isNotBlank(industryTypeValue)) {
            List<Map<String, String>> orgTypeList = new ArrayList<>();
            switch (industryTypeValue) {
                case "01" :
                    orgTypeList.add(DictUtil.getDictMap("0102", "保安服务公司"));
                    orgTypeList.add(DictUtil.getDictMap("0103", "保安培训单位"));
                    orgTypeList.add(DictUtil.getDictMap("0104", "自行招用保安员单位"));
                    break;
                case "02" :
                    orgTypeList.add(DictUtil.getDictMap("0201", "活动承办方"));
                    orgTypeList.add(DictUtil.getDictMap("0211", "活动运营方"));
                    orgTypeList.add(DictUtil.getDictMap("0212", "组委会"));
                    orgTypeList.add(DictUtil.getDictMap("0214", "体育局"));
                    orgTypeList.add(DictUtil.getDictMap("0215", "文旅局"));
                    orgTypeList.add(DictUtil.getDictMap("0216", "卫健委"));
                    orgTypeList.add(DictUtil.getDictMap("0217", "政法委"));
                    orgTypeList.add(DictUtil.getDictMap("0218", "共青团"));
                    orgTypeList.add(DictUtil.getDictMap("0219", "社团志愿者团队"));
                    orgTypeList.add(DictUtil.getDictMap("0221", "无人机反制公司"));
                    orgTypeList.add(DictUtil.getDictMap("0222", "医疗服务团队"));
                    orgTypeList.add(DictUtil.getDictMap("0223", "裁判服务团队"));
                    break;
                case "03" :
                    orgTypeList.add(DictUtil.getDictMap("0302", "培训机构会员单位"));
                    orgTypeList.add(DictUtil.getDictMap("0301", "其他"));
                    break;
                case "04" :
                    orgTypeList.add(DictUtil.getDictMap("0403", "中小学、幼儿园"));
                    orgTypeList.add(DictUtil.getDictMap("0404", "高校"));
                    orgTypeList.add(DictUtil.getDictMap("0401", "医疗单位"));
                    orgTypeList.add(DictUtil.getDictMap("0405", "金融单位"));
                    orgTypeList.add(DictUtil.getDictMap("0402", "文博单位"));
                    orgTypeList.add(DictUtil.getDictMap("0406", "党政机关"));
                    break;
                case "05" :
                    orgTypeList.add(DictUtil.getDictMap("0501", "渠道合作方"));
                    orgTypeList.add(DictUtil.getDictMap("0502", "供应商"));
                    break;
                case "06" :
                    orgTypeList.add(DictUtil.getDictMap("0601", "社区警务团队"));
                    break;
                case "07" :
                    orgTypeList.add(DictUtil.getDictMap("0701", "教育单位"));
                    orgTypeList.add(DictUtil.getDictMap("0702", "医疗单位"));
                    orgTypeList.add(DictUtil.getDictMap("0703", "金融单位"));
                    orgTypeList.add(DictUtil.getDictMap("0704", "文博单位"));
                    orgTypeList.add(DictUtil.getDictMap("0705", "党政机关"));
                    break;
            }
            return orgTypeList;
        }
        return null;
    }

//    /**
//     * description: 根据机构类型，获取主管单位列表
//     * author: linchunpeng
//     * date:  2023-05-08 13:10
//     */
//    @Override
//    public List<Map<String, String>> getCompetentUnitCodeList(String institutionalCode) {
//        if (StringUtils.isNotBlank(institutionalCode)) {
//            List<Map<String, String>> competentUnitCodeList = new ArrayList<>();
//            switch (institutionalCode) {
//                case "0401" :
//                    //医院
//                    competentUnitCodeList.add(DictUtil.getDictMap("01", "卫生局"));
//                    break;
//                case "0402" :
//                    //文博单位
//                    competentUnitCodeList.add(DictUtil.getDictMap("02", "文物局"));
//                    break;
//                case "0403" :
//                    //中小学、幼儿园
//                    competentUnitCodeList.add(DictUtil.getDictMap("03", "教育局"));
//                    break;
//                case "0404" :
//                    //高校高职
//                    competentUnitCodeList.add(DictUtil.getDictMap("03", "教育局"));
//                    break;
//                case "0405" :
//                    //金融单位
//                    competentUnitCodeList.add(DictUtil.getDictMap("05", "金融监督管理局"));
//                    break;
//            }
//            return competentUnitCodeList;
//        }
//        return null;
//    }


    /**
     * description: 获取注册页面数据字典列表
     * author: linchunpeng
     * date:  2023-05-08 14:01
     */
    @Override
    public Map<String, List<Map<String, String>>> findRegisterDict() {
        Map<String, List<Map<String, String>>> resultMap = new HashMap<>();

        Object redisCache = redisUtil.get(REGISTER_DICT_REDIS_KEY);
        if (redisCache != null) {
            return JSONObject.parseObject(redisCache.toString(), Map.class);
        }

        //行业类型
        List<Map<String, String>> industryTypeList = new ArrayList<>();
        industryTypeList.add(DictUtil.getDictMap("01", "保安行业"));
        industryTypeList.add(DictUtil.getDictMap("02", "大活行业"));
        industryTypeList.add(DictUtil.getDictMap("04", "内保行业"));
        industryTypeList.add(DictUtil.getDictMap("05", "合作行业"));
        industryTypeList.add(DictUtil.getDictMap("06", "群防群治行业"));
        industryTypeList.add(DictUtil.getDictMap("07", "行业主管部门"));
        industryTypeList.add(DictUtil.getDictMap("03", "其他"));
        resultMap.put("industryType", industryTypeList);

        //保安服务公司类型
        List<Map<String, String>> industryDetailTypeList = new ArrayList<>();
        for (IndustryDetailType value : IndustryDetailType.values()) {
            if (value.ordinal() > 0) {
                industryDetailTypeList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
            }
        }
        resultMap.put("industryDetailType", industryDetailTypeList);

        //总分子公司
        List<Map<String, String>> parentSubsidiaryList = new ArrayList<>();
        for (ParentSubsidiary value : ParentSubsidiary.values()) {
            if (value.ordinal() > 0) {
                parentSubsidiaryList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
            }
        }
        resultMap.put("parentSubsidiary", parentSubsidiaryList);

        //经济类型
        List<Map<String, String>> economicTypeList = new ArrayList<>();
        for (EconomicType value : EconomicType.values()) {
            if (value.ordinal() > 0) {
                economicTypeList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
            }
        }
        resultMap.put("economicType", economicTypeList);

        //公司类型
        List<Map<String, String>> companyNatureList = new ArrayList<>();
        for (CompanyNature value : CompanyNature.values()) {
            if (value.ordinal() > 0) {
                companyNatureList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
            }
        }
        resultMap.put("companyNature", companyNatureList);

        //公司证件类型
        List<Map<String, String>> companyCertificateTypeList = new ArrayList<>();
        for (CompanyCertificateType value : CompanyCertificateType.values()) {
            companyCertificateTypeList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
        }
        resultMap.put("companyCertificateType", companyCertificateTypeList);

        //人员证件类型
        List<Map<String, String>> credentialTypeList = new ArrayList<>();
        for (CredentialType value : CredentialType.values()) {
            if (value.isIdentityNo()) {
                credentialTypeList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
            }
        }
        resultMap.put("credentialType", credentialTypeList);

        //服务范围
        List<Map<String, String>> serviceScopeList = new ArrayList<>();
        for (ServiceScope value : ServiceScope.values()) {
            if (value.ordinal() > 0) {
                serviceScopeList.add(DictUtil.getDictMap(value.getTypeValue(), value.getTypeName()));
            }
        }
        resultMap.put("serviceScope", serviceScopeList);

        //人力防范评定等级
        List<Map<String, String>> securityPreparednessRatingList = new ArrayList<>();
        for (SecurityPreparednessRating value : SecurityPreparednessRating.values()) {
            securityPreparednessRatingList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
        }
        resultMap.put("securityPreparednessRating", securityPreparednessRatingList);

        //武装守护押运评定等级
        List<Map<String, String>> securityArmedRatingList = new ArrayList<>();
        for (SecurityArmedRating value : SecurityArmedRating.values()) {
            securityArmedRatingList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
        }
        resultMap.put("securityArmedRating", securityArmedRatingList);

        //安全技术防范评定等级
        List<Map<String, String>> securitySafetyDefenseRatingList = new ArrayList<>();
        for (SecuritySafetyDefenseRating value : SecuritySafetyDefenseRating.values()) {
            securitySafetyDefenseRatingList.add(DictUtil.getDictMap("" + value.ordinal(), value.getTypeName()));
        }
        resultMap.put("securitySafetyDefenseRating", securitySafetyDefenseRatingList);

        //自招保安单位性质
        resultMap.put("natureOfSelfRecruitedUnits", NatureOfSelfRecruitedUnits.getDictList());

        //国籍
        resultMap.put("nationality", Nationality.getDictList());

        //放入缓存
        redisUtil.set(REGISTER_DICT_REDIS_KEY, JSONObject.toJSONString(resultMap), -1);
        return resultMap;
    }

    /**
     * description: 删除注册页面数据字典缓存
     * author: linchunpeng
     * date:  2023-05-08 14:34
     */
    @Override
    public void clearRegisterDictRedis() {
        redisUtil.del(REGISTER_DICT_REDIS_KEY);
    }

}
