package com.bcxin.tenant.apis.eventHandlers;

import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.ChangeBasicIdentityRequest;
import com.bcxin.tenant.domain.events.TenantUserTelephoneChangedEvent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class TenantUserTelephoneChangedEvent_IdentityHandler extends DomainEventHandlerAbstract<TenantUserTelephoneChangedEvent> {
    private final IdentityRpcProvider identityRpcProvider;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final RetryProvider retryProvider;

    public TenantUserTelephoneChangedEvent_IdentityHandler(IdentityRpcProvider identityRpcProvider,
                                                           ThreadPoolTaskExecutor taskExecutor,
                                                           RetryProvider retryProvider) {
        this.identityRpcProvider = identityRpcProvider;
        this.taskExecutor = taskExecutor;
        this.retryProvider = retryProvider;
    }

    @Override
    protected void execute(TenantUserTelephoneChangedEvent event) {
        this.taskExecutor.execute(() -> {
            this.retryProvider.execute(() -> {
                this.identityRpcProvider.change(ChangeBasicIdentityRequest.create(event.getId(), event.getName(), event.getIdNum(), event.getTelephone()));
            }, 10);
        });
    }
}
