package com.bcxin.tenant.apis.eventHandlers;

import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.ChangeBasicIdentityRequest;
import com.bcxin.tenant.domain.events.TenantCredentialChangedEvent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class TenantUserCredentialChangedEvent_IdentityHandler extends DomainEventHandlerAbstract<TenantCredentialChangedEvent> {
    private final IdentityRpcProvider identityRpcProvider;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final RetryProvider retryProvider;

    public TenantUserCredentialChangedEvent_IdentityHandler(IdentityRpcProvider identityRpcProvider,
                                                            ThreadPoolTaskExecutor taskExecutor,
                                                            RetryProvider retryProvider) {
        this.identityRpcProvider = identityRpcProvider;
        this.taskExecutor = taskExecutor;
        this.retryProvider = retryProvider;
    }

    @Override
    protected void execute(TenantCredentialChangedEvent event) {
        this.taskExecutor.execute(() -> {
            this.retryProvider.execute(() -> {
                this.identityRpcProvider.change(ChangeBasicIdentityRequest.create(event.getTenantUserId(), event.getName(), event.getNumber(),event.getTelephone()));
            }, 10);
        });
    }
}
