package com.bcxin.api.interfaces.tenants.responses;

import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;

@Getter
public class MyRegistrationOrganizationResponse extends ResponseAbstract {

    @ApiModelProperty("Id")
    private final String id;

    @ApiModelProperty("团队名称")
    private final String name;

    @ApiModelProperty("审核状态")
    private final String status;

    @ApiModelProperty("审核时间")
    private final String approvedTime;

    @ApiModelProperty("审核备注")
    private final String approvedNote;

    /**
     * 机构类型
     */
    @ApiModelProperty("机构类型")
    private final String institutionalCode;
    /**
     * 行业类型
     */
    @ApiModelProperty("行业类型")
    private final String industryCode;

    @ApiModelProperty("创建时间")
    private final String createdTime;

    public MyRegistrationOrganizationResponse(String id, String name, ApprovedStatus status, String approvedTime, String approvedNote,
                                              String institutionalCode, String industryCode, String createdTime) {
        this.id = id;
        this.name = name;
        this.status = status == null ? "" : status.getTypeName();
        this.institutionalCode = institutionalCode;
        this.industryCode = industryCode;
        this.createdTime = createdTime;
        this.approvedNote = approvedNote;
        this.approvedTime = approvedTime;
    }

    public static MyRegistrationOrganizationResponse create(String id, String name, ApprovedStatus status,String approvedTime,String approvedNote,
                                                            String institutionalCode, String industryCode, String createdTime)
    {
        return new MyRegistrationOrganizationResponse(id,name,status,approvedTime,approvedNote, institutionalCode,industryCode,createdTime);
    }
}
