package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.MemberType;
import com.bcxin.api.interfaces.ResponseAbstract;
import com.bcxin.api.interfaces.enums.ExternalMemberInviteType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.Collection;
import java.util.Date;

@ApiModel("团队成员信息")
@Data
public class ExternalMemberSearchResponse extends ResponseAbstract {

    @ApiModelProperty("团队成员Id")
    private String id;

    @ApiModelProperty("姓名")
    private String tenantUserName;

    @ApiModelProperty("智能人事Id")
    private String tenantUserId;

    @ApiModelProperty("手机号码")
    private String telephone;

    @ApiModelProperty("证件类型")
    private CredentialType credentialType;

    @ApiModelProperty("证件号")
    private String credentialNumber;

    @ApiModelProperty("邀请方式: 邀请码/二维码")
    private String inviteType;

    @ApiModelProperty("邀请码信息")
    private String inviteCode;

    @ApiModelProperty("加入时间")
    private String createdTime;

    @ApiModelProperty("审核状态")
    private String approvedStatus;

    @ApiModelProperty("审批备注")
    private String approvedNote;

    @ApiModelProperty("加入时候指定的组")
    private String inviteGroupName;

    @ApiModelProperty("所属的分组")
    private Collection<String> principalGroupIds;

    @ApiModelProperty("是否为分组负责人")
    private boolean principal;

    @ApiModelProperty("人员类型（Master=团队负责人, Normal=普通人员）")
    private MemberType memberType;

    public ExternalMemberSearchResponse() {
    }

    public ExternalMemberSearchResponse(String id,
                                        String tenantUserName,
                                        String tenantUserId,
                                        String telephone,
                                        CredentialType credentialType,
                                        String credentialNumber,
                                        ExternalMemberInviteType inviteType,
                                        String inviteCode, String createdTime,
                                        ApprovedStatus approvedStatus,
                                        String approvedNote, String inviteGroupName,
                                        Collection<String> principalGroupIds,
                                        MemberType memberType) {
        this.id = id;
        this.tenantUserName = tenantUserName;
        this.tenantUserId = tenantUserId;
        this.telephone = telephone;
        this.inviteType = inviteType.getName();
        this.inviteCode = inviteCode;
        this.createdTime = createdTime;
        this.approvedStatus = approvedStatus.getTypeName();
        this.approvedNote = approvedNote;
        this.inviteGroupName = inviteGroupName;
        this.principalGroupIds = principalGroupIds;
        this.credentialType = credentialType;
        this.credentialNumber = credentialNumber;
        this.principal = !CollectionUtils.isEmpty(principalGroupIds);
        this.memberType = memberType;
    }

    public static ExternalMemberSearchResponse create(String id, String tenantUserName,
                                                      String tenantUserId,
                                                      String telephone,
                                                      CredentialType credentialType,
                                                      String credentialNumber,
                                                      ExternalMemberInviteType inviteType,
                                                      String inviteCode, Date createdTime,
                                                      ApprovedStatus approvedStatus,
                                                      String approvedNote,
                                                      String inviteGroupName,
                                                      Collection<String> principalGroupIds,
                                                      MemberType memberType
    ) {
        return new ExternalMemberSearchResponse(
                id, tenantUserName, tenantUserId,
                telephone,
                credentialType,
                credentialNumber,
                inviteType, inviteCode,
                DateUtil.format(createdTime, "yyyy-MM-dd HH:mm:ss"),
                approvedStatus, approvedNote, inviteGroupName, principalGroupIds,
                memberType);
    }
}
