package com.bcxin.api.interfaces.tenants.responses;

import cn.hutool.core.date.DateUtil;
import com.bcxin.Infrastructures.enums.ApprovedStatus;
import com.bcxin.api.interfaces.ResponseAbstract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@ApiModel("人员加入团队记录")
@Data
public class ExternalMemberJoinRecordResponse extends ResponseAbstract {
    @ApiModelProperty("团队成员Id")
    private String id;
    @ApiModelProperty("团队成员Id")
    private String orgId;
    @ApiModelProperty("团队成员Id")
    private String orgName;
    @ApiModelProperty("审核状态")
    private String approvedStatus;
    @ApiModelProperty("审核备注")
    private String approvedNote;

    @ApiModelProperty("审核时间")
    private String approvedTime;

    @ApiModelProperty("发起时间")
    private String createdTime;

    public static ExternalMemberJoinRecordResponse create(String id, String orgId, String orgName, ApprovedStatus approvedStatus,
                                                          String approvedNote, Date approvedTime, Date createdTime){
        ExternalMemberJoinRecordResponse data = new ExternalMemberJoinRecordResponse();
        data.setId(id);
        data.setOrgId(orgId);
        data.setOrgName(orgName);
        data.setApprovedStatus(approvedStatus.getTypeName());
        data.setApprovedNote(approvedNote);
        if(approvedTime!=null){
            data.setApprovedTime(DateUtil.format(approvedTime,"yyyy-MM-dd HH:mm:ss"));
        }

        data.setCreatedTime(DateUtil.format(createdTime,"yyyy-MM-dd HH:mm:ss"));

        return data;
    }
}
