package com.bcxin.api.interfaces.rbacs.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import lombok.Getter;

import java.util.Collection;

@Getter
public class ResourceItemRequest extends RequestAbstract {
    private final String categoryId;
    private final Collection<String> resourceIds;

    public ResourceItemRequest(String categoryId, Collection<String> resourceIds) {
        this.categoryId = categoryId;
        this.resourceIds = resourceIds;
    }

    public static ResourceItemRequest create(String categoryId, Collection<String> resourceIds) {
        return new ResourceItemRequest(categoryId, resourceIds);
    }
}
