package com.bcxin.api.interfaces.identities.requests;

import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.CriteriaAbstract;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.util.Collection;

@Data
@NoArgsConstructor
public class GetCredentialRequest extends CriteriaAbstract {
    @NotEmpty
    @ApiModelProperty(value = "证件类型")
    private  Collection<String> credentialTypes;
    @ApiModelProperty(value = "姓名")
    private  String name;
    @ApiModelProperty(value = "证件号码")
    private  String number;

    @ApiModelProperty(value = "证书是否显示所有区域")
    private  Boolean skipAreaCodeFilter;
    public int getSkip() {
        int index = this.getPageIndex() - 1;
        if (index < 0) {
            index = 0;
        }

        return this.getPageSize() * index;
    }
}
