package com.bcxin.api.interfaces.buses.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import lombok.Data;

import java.util.Map;

@Data
public class MessageRequest extends RequestAbstract {
    private final MessageType messageType;
    private final Map<String, Object> params;

    public MessageRequest(MessageType messageType, Map<String, Object> params)
    {
        this.messageType = messageType;
        this.params = params;
    }

    public static MessageRequest create(MessageType messageType, Map<String, Object> params) {
        return new MessageRequest(messageType, params);
    }
}
