package com.bcxin.identity.domains.services.commands;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.BadTenantException;
import com.bcxin.Infrastructures.utils.StringUtils;
import lombok.Getter;

@Getter
public class ResetPasswordCommand extends CommandAbstract {
    private final String jwt;
    private final String loginName;
    private final String newPassword;
    private final String code;

    @Override
    public void validate() {
        if (StringUtils.isEmpty(this.getJwt())) {
            throw new BadTenantException("jwt不能为空");
        }
    }

    public ResetPasswordCommand(String jwt, String loginName, String newPassword, String code) {
        this.jwt = jwt;
        this.loginName = loginName;
        this.newPassword = newPassword;
        this.code = code;
    }

    public static ResetPasswordCommand create(String jwt, String loginName, String newPassword, String code) {
        return new ResetPasswordCommand(jwt, loginName, newPassword, code);
    }
}
