package com.bcxin.identity.domains.entities;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.identity.domains.enums.PrincipalStatus;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

@Getter
@Setter(AccessLevel.PROTECTED)
@Entity
@Table(name = "identity_principals")
@Inheritance(strategy = InheritanceType.JOINED)
public abstract class PrincipalAbstract extends EntityAbstract {
    @Id
    @Column(name = "id", length = 100)
    private String id;

    @Column(name = "last_updated_time", nullable = true)
    private Timestamp lastUpdatedTime;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    @Column(name = "last_login_time", nullable = true)
    private Timestamp lastLoginTime;

    @Column(nullable = false)
    @Enumerated(EnumType.ORDINAL)
    private PrincipalStatus status;

    /**
     * 上次状态修改时间
     */
    @Column(name = "last_status_changed_time")
    private Timestamp lastStatusChangedTime;

    @ManyToOne
    @JoinColumn(name = "identity_user_id", referencedColumnName = "id",nullable = false)
    private IdentityUserEntity identityUser;

    protected PrincipalAbstract() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setStatus(PrincipalStatus.INACTIVATE);
    }

    public void recordLastLoginTime() {
        this.setLastLoginTime(Timestamp.from(Instant.now()));
    }
}
