/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.identity.domains.components;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.exceptions.NotSupportTenantException;
import com.bcxin.Infrastructures.utils.RedisUtil;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.buses.enums.MessageType;
import com.bcxin.api.interfaces.buses.requests.MessageRequest;
import com.bcxin.api.interfaces.identities.requests.SmsRequest;
import com.bcxin.identity.domains.services.commandResult.SMSCommandResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.springframework.stereotype.Component;

@Component
public class SmsExecutor {
    private final RedisUtil redisUtil;
    private final MessageRpcProvider messageRpcProvider;

    public SmsExecutor(RedisUtil redisUtil, MessageRpcProvider messageRpcProvider) {
        this.redisUtil = redisUtil;
        this.messageRpcProvider = messageRpcProvider;
    }

    public SMSCommandResult sendCode(SmsRequest request) {
        String key = request.getBusinessType().name() + ":" + request.getPhone();
        String countKey = request.getBusinessType().name() + ":count:" + DateUtil.today() + ":" + request.getPhone();
        int count = 0;
        if (this.redisUtil.get(countKey) != null) {
            count = (Integer)this.redisUtil.get(countKey);
            if (count >= 2) {
                throw new NotSupportTenantException("\u8d85\u8fc7\u4eca\u5929\u53d1\u9001\u6b21\u6570\uff01");
            }
            ++count;
        }
        this.redisUtil.set(countKey, (Object)count, 86400L);
        if (this.redisUtil.get(key) == null) {
            HashMap<String, String> huaWeiSmsContent = new HashMap<String, String>();
            huaWeiSmsContent.put("smsCode", "B02");
            String code = SmsExecutor.verificationCode();
            ArrayList<String> sendParams = new ArrayList<String>();
            sendParams.add(code);
            huaWeiSmsContent.put("params", JSON.toJSONString(sendParams));
            huaWeiSmsContent.put("mobile", request.getPhone());
            this.messageRpcProvider.dispatch(MessageRequest.create((MessageType)MessageType.SMS, huaWeiSmsContent));
            this.redisUtil.set(key, (Object)code, 180L);
            System.out.println(code);
        }
        return SMSCommandResult.create(true, "200");
    }

    public static String verificationCode() {
        Random random = new Random();
        String result = "";
        for (int i = 0; i < 6; ++i) {
            result = result + random.nextInt(10);
        }
        return result;
    }

    public boolean checkCode(SmsRequest request) {
        String key = request.getBusinessType().name() + ":" + request.getPhone();
        return this.redisUtil.get(key) != null && request.getCode().equals(this.redisUtil.get(key).toString());
    }
}

