package com.bcxin.tenant.bcx.rest.apis.utils;

import com.bcxin.tenant.bcx.infrastructures.KeyValueConstants;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

import java.util.Map;

public class ServletRequestUtil {
    private static final String AUTHENTICATION = "Authorization";
    public static final String PAAS_AUTHENTICATION = "x-bcx-paas-token";

    public static final String HEADER_TRAFFIC_TAG="TRAFFIC_TAG";

    public static String getBearerToken(ServletRequest servletRequest) {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        String authentication = request.getHeader(AUTHENTICATION);

        if (!StringUtils.hasLength(authentication)) {
            return null;
        }

        if (!authentication.contains("Bearer ")) {
            return null;
        }

        return authentication.substring(7);
    }

    public static String getDispatchToken(ServletRequest servletRequest) {
        return getValueFromHeader(servletRequest, PAAS_AUTHENTICATION, false);
    }

    public static String getValueFromHeader(ServletRequest servletRequest, String headName, boolean skipParams) {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        String headerValue = request.getHeader(headName);

        if (!skipParams && !StringUtils.hasLength(headerValue)) {
            Map<String, String[]> parameterMap = request.getParameterMap();
            if (parameterMap != null) {
                String[] tokens = parameterMap.get(headName);
                if (tokens != null && tokens.length > 0) {
                    return tokens[0];
                }
            }

            return null;
        }

        return headerValue;
    }

    public static String getIpAddress(HttpServletRequest servletRequest) {
        String skipIpAddressValidation =
                servletRequest.getParameter(KeyValueConstants.IGNORE_IP_ADDRESS_VALUE_PARAMETER_NAME);
        if ("1".equalsIgnoreCase(skipIpAddressValidation)) {
            return KeyValueConstants.IGNORE_IP_ADDRESS_VALUE;
        }

        if ("1".equalsIgnoreCase(servletRequest.getHeader(KeyValueConstants.IGNORE_IP_ADDRESS_VALUE_PARAMETER_NAME))) {
            return KeyValueConstants.IGNORE_IP_ADDRESS_VALUE;
        }

        String ipAddress = servletRequest.getHeader(KeyValueConstants.HEADER_X_FORWARD_FOR);
        if (!StringUtils.hasLength(ipAddress)) {
            ipAddress = servletRequest.getHeader(KeyValueConstants.HEADER_X_REAL_FOR);
        } else {
            return ipAddress;
        }

        if (!StringUtils.hasLength(ipAddress)) {
            ipAddress = servletRequest.getHeader(KeyValueConstants.HEADER_X_REAL_FOR);
        } else {
            return ipAddress;
        }

        if (!StringUtils.hasLength(ipAddress)) {
            return servletRequest.getRemoteHost();
        } else {
            return ipAddress;
        }
    }
}