package com.bcxin.tenant.bcx.rest.apis.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.tenant.bcx.infrastructures.exceptions.UnAuthorizedTenantException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Calendar;
import java.util.Date;

public class JwtUtil {
    private static Logger logger = LoggerFactory.getLogger(JwtUtil.class);
    public static final String JWT_USER_ID="username";
    public static final String SECRET_KEY = "teemlink_obpm";

    private static final String PAAS_SECRET_KEY="paas_token_link";
    private static JWTVerifier verifier;
    private static JWTVerifier paasTokenVerifier;

    static {
        verifier = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").build();
        paasTokenVerifier = JWT.require(Algorithm.HMAC256(PAAS_SECRET_KEY)).withIssuer("auth0").build();
    }

    public static String getSaasUserIdFromToken(String token) throws JWTVerificationException {
        try {
            DecodedJWT jwt2 = verifier.verify(token);
            String userId = jwt2.getClaim(JwtUtil.JWT_USER_ID).asString();
            return userId;
        } catch (TokenExpiredException ex) {
            throw new UnAuthorizedTenantException("账号过期, 请重新登入系统", token);
        } catch (Exception ex) {
            throw new UnAuthorizedTenantException("账号异常, 请重新登入系统");
        }
    }

    public static String getPaasTokenFromIdentityData(String content) {
        String token = null;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DATE,10);
            Date expiresAt = calendar.getTime();
            token = JWT.create()
                    .withIssuer("auth0")
                    .withClaim(JwtUtil.JWT_USER_ID, content)
                    .withExpiresAt(expiresAt)
                    // 使用了HMAC256加密算法。
                    .sign(Algorithm.HMAC256(PAAS_SECRET_KEY));
        } catch (Exception e) {
        }

        return token;
    }

    public static String getContentFromPaasToken(String token) throws JWTVerificationException {
        try {
            DecodedJWT jwt2 = paasTokenVerifier.verify(token);
            String userId = jwt2.getClaim(JwtUtil.JWT_USER_ID).asString();
            return userId;
        } catch (TokenExpiredException ex) {
            throw new UnAuthorizedTenantException("账号过期, 请重新登入系统", token);
        } catch (Exception ex) {
            throw new UnAuthorizedTenantException("账号异常, 请重新登入系统");
        }
    }
}