package com.bcxin.tenant.bcx.rest.apis.utils;

import com.bcxin.tenant.bcx.infrastructures.TenantContext;
import jakarta.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DubboCommonUtils {
    private static final Logger logger = LoggerFactory.getLogger(DubboCommonUtils.class);
    public static void addContextTag(ServletRequest request, TenantContext tenantContext,String regionCode) {
        try {
            String tag = ServletRequestUtil.getValueFromHeader(request, ServletRequestUtil.HEADER_TRAFFIC_TAG, true);
            if (!StringUtils.hasLength(tag) && StringUtils.hasLength(regionCode)) {
                //tag = userModel.getTrafficTag();
                try {
                    tag = regionCode.substring(0, 1);
                } catch (Exception ex) {
                    //todo: 忽略跳转这种非频繁使用情况
                }
            }

            tenantContext.addAttachValues(TenantContext.FLOW_TAG_NAME, tag);
        } catch (Exception ex) {
            logger.error("上下文添加Tag异常:{}", regionCode, ex);
        }
    }
}
