package com.bcxin.tenant.bcx.rest.apis.easyexcel;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class BooleanConverter implements Converter<Boolean> {

    @Override
    public Class<Boolean> supportJavaTypeKey() {
        return Boolean.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.BOOLEAN;
    }

    @Override
    public Boolean convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty,
                                     GlobalConfiguration globalConfiguration)  {
        // 在实际应用中，你可能需要添加更复杂的逻辑，这里简单示例将 "是" 视为 true，其他为 false
        return "是".equals(cellData.getStringValue());
    }

    @Override
    public WriteCellData convertToExcelData(Boolean value, ExcelContentProperty contentProperty,
                                            GlobalConfiguration globalConfiguration) {
        // 根据布尔值返回相应的字符串 "是" 或 "否"
        return new WriteCellData(value ? "是" : "否");
    }
}
