package com.bcxin.tenant.bcx.rest.apis.dtos;

import jakarta.websocket.Session;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;

@Data
public class SocketSessionDTO implements Serializable {
    private String employeeId;
    private String category;
    private String tencentUserId;
    private String[] superviseDepartIds;
    private Session session;

    public boolean contain(Collection<String> specialSuperviseDepartIds) {
        if (CollectionUtils.isEmpty(specialSuperviseDepartIds)) {
            return false;
        }

        if (this.getSuperviseDepartIds() == null || this.getSuperviseDepartIds().length == 0) {
            return false;
        }

        return Arrays.stream(this.getSuperviseDepartIds())
                .anyMatch(ix -> specialSuperviseDepartIds.stream()
                        .anyMatch(ii -> ii.equalsIgnoreCase(ix))
                );
    }

    public SocketSessionDTO(){}

    public static SocketSessionDTO create(String category,
                                          String employeeId,
                                          String tencentUserId,
                                          String[] superviseDepartIds,
                                          Session session) {
        SocketSessionDTO socketSession = new SocketSessionDTO();
        socketSession.setCategory(category);
        socketSession.setSession(session);
        socketSession.setSuperviseDepartIds(superviseDepartIds);
        socketSession.setEmployeeId(employeeId);
        socketSession.setTencentUserId(tencentUserId);

        return socketSession;
    }

    public String getDescription() {
        return String.format("session=%s;category=%s;employeeId=%s;superviseDepartIds=%s;",
                (session == null ? "" : session.getId()), this.getCategory(), this.getEmployeeId(),
                (this.getSuperviseDepartIds() == null ? "EMPTY" : Arrays.stream(this.getSuperviseDepartIds()).collect(Collectors.joining(",")))
        );
    }
}
