package com.bcxin.tenant.bcx.rest.apis.dtos;

import com.bcxin.tenant.bcx.jdks.requests.enums.BroadcastMessageType;
import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import lombok.Data;

import java.util.Collection;

@Data
public class RefreshPublishMessageResponse extends ResponseAbstract {
    private BroadcastMessageType messageType;
    private Collection<String> superviseDepartIds;

    public static RefreshPublishMessageResponse create(BroadcastMessageType messageType,Collection<String> superviseDepartIds) {
        RefreshPublishMessageResponse publishMessage = new RefreshPublishMessageResponse();
        publishMessage.setSuperviseDepartIds(superviseDepartIds);
        publishMessage.setMessageType(messageType);

        return publishMessage;
    }
}
