package com.bcxin.tenant.bcx.rest.apis.controllers.responses;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "StationTypeResponse",title = "StationTypeResponse 驻勤点类型")
@Getter
public class StationTypeResponse extends ResponseAbstract {
    @Schema(name = "code", title = "驻勤编码")
    private final String code;
    @Schema(name = "name", title = "驻勤名称")
    private final String name;

    public StationTypeResponse(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static StationTypeResponse create(String code, String name) {
        return new StationTypeResponse(code, name);
    }
}
