package com.bcxin.tenant.bcx.rest.apis.controllers.responses;

import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

@Getter
@Setter(AccessLevel.PRIVATE)
public class ResourceResponse implements Serializable {
    private boolean success;
    private String msg;
    private Object data;

    public static ResourceResponse create(Object data) {
        ResourceResponse response = new ResourceResponse();
        response.setData(data);
        response.setSuccess(true);
        response.setMsg("操作成功");

        return response;
    }

    public static ResourceResponse createOk() {
        ResourceResponse response = new ResourceResponse();
        response.setData(null);
        response.setSuccess(true);
        response.setMsg("操作成功");

        return response;
    }

    public static ResourceResponse createError(String msg) {

        return createError(msg, null);
    }

    public static ResourceResponse createError(String msg,Object data) {
        ResourceResponse response = new ResourceResponse();
        response.setData(data);
        response.setSuccess(false);
        response.setMsg(msg == null ? "操作失败" : msg);

        return response;
    }
}