package com.bcxin.tenant.bcx.rest.apis.controllers.responses;

import com.bcxin.tenant.bcx.infrastructures.ResponseAbstract;
import com.bcxin.tenant.bcx.infrastructures.UserDetailResponse;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Getter
public class DispatchResponse extends ResponseAbstract {
    @Schema(name = "paasToken", title = "身份Token")
    private final String paasToken;

    @Schema(name = "info", title = "用户信息")
    private final UserDetailResponse user;

    public DispatchResponse(String paasToken,UserDetailResponse user) {

        this.paasToken = paasToken;
        this.user = user;
    }

    public static DispatchResponse create(String paasToken,UserDetailResponse user) {
        return new DispatchResponse(paasToken,user);
    }
}
